#include <exec/types.h>
#include <stdio.h>
#include <libraries/dos.h>
#include <ctype.h>
#include "zexport.h"

#include <link/io.h>

char MSGAREADUMMYVAR[255]; /******* THIS IS USED FOR DETECTING PROBLEMS *****/
char MSGAREATAG[255];      /* information in a line of areas.bbs   */
char MSGAREAPATH[255];     /* these lines will hold the equivalent */
int MSGAREANUMBER;
BOOL MSGAREAPASSTHRU=FALSE;

int AREASPROCESSED=0;
int AREASSKIPPED=0;
int MSGSPROCESSED=0;
int OUTBOUNDSCREATED=0;
int PKTSCREATED=0;

int EX_THIS_AREA;
int EX_NODES_THIS_AREA;

struct area *thisarea;

/// CheckDLGMAILSTOP
int CheckDLGMAILSTOP()
{
   if(Exists("Env:DLGMailStop"))
   {
      Log("DLGMail told me to stop processing areas");
      return(1);
   }
   return(0);
}
//-

/// AreaLoop()
int AreaLoop()
{
   /* this is the outermost loop of ZExp - it reads in a line of
      areas.bbs file, processes is, and calls the routine to process
      the area in full */

   char string[150];

   int returncode=0;

   int areacounter;

   int i;

   BPTR fp;

   int MSGAREACLASS;


   for(areacounter=1;;areacounter++)
   {
      if(CheckDLGMAILSTOP())
         break;

      if(_VERBOSITY>3)
      {  ASPrintf(NULL,logstring,"-> Top of the area loop, the _areacounter_ equals: %d",areacounter);
         Log(logstring);
      }

      EX_THIS_AREA=0;
      EX_NODES_THIS_AREA=0;

/* get pointer into ross structure to area */

      thisarea=get_area(a,areacounter);

      if(thisarea == NULL)
      {
         if(_VERBOSITY>3) Log(".  get_area() returned a NULL. may be normal");
         if(areacounter==1) returncode=-1;
         break;   /* we've run out of areas */
      }

/* retrieve its tagname */

      strcpy(MSGAREATAG,thisarea->name);

      if(_VERBOSITY>3)
      {
         ASPrintf(NULL,logstring,"#  The tagname is [%s]",MSGAREATAG);
         Log(logstring);
      }

      strcpy(MSGAREAPATH,thisarea->path);

      if(_VERBOSITY>3)
      {
         ASPrintf(NULL,logstring,"#  The path is [%s]",MSGAREAPATH);
         Log(logstring);
      }

      if(*MSGAREAPATH==NULL)
      {
         ASPrintf(NULL,logstring,"** Path for %s is NULL [1]",MSGAREATAG);
         Log(logstring);
      }

   /*
    * We've detected a problem and logged it... Now what?
    */

      MSGAREANUMBER=thisarea->areanum;

      if(_VERBOSITY>3)
      {
         ASPrintf(NULL,logstring,"#  The area number is [%d]",MSGAREANUMBER);
         Log(logstring);
      }


      MSGAREAPASSTHRU=thisarea->passthru;

      if(_VERBOSITY>3)
      {
         ASPrintf(NULL,logstring,"#  The area is designated %s",MSGAREAPASSTHRU?"Passthru":"NoPassThru");
         Log(logstring);
      }

      MSGAREACLASS=thisarea->class;

      if(_VERBOSITY>3)
      {
         ASPrintf(NULL,logstring,"#  The class for this area is [%d]",MSGAREACLASS);
         Log(logstring);
      }

/* do we want to export the area? */

      if(EXPORTLIMITFLAG)
      {
         if(CheckToExport(MSGAREATAG,MSGAREANUMBER)==0)
         {
            AREASSKIPPED++;
            if(_VERBOSITY>3) Log("#  skipping due to CheckToExport()");
            continue; /* skip this area */
         }
      }

//skip passthru areas // march 15
      if(MSGAREAPASSTHRU == 1)/// && !EXPORTLIMITFLAG)
      {
         if(_VERBOSITY>3) Log("#  skipping due to this area being passthru");
         AREASSKIPPED++;
         continue;
      }

      if(*MSGAREAPATH==NULL)
      {
         ASPrintf(NULL,logstring,"** Path for %s is NULL [2]",MSGAREATAG);
         Log(logstring);
      }

      if(*MSGAREAPATH)
      {
         ASPrintf(NULL,logstring,"-> Processing %s",MSGAREATAG);
         Log(logstring);

         if(*MSGAREAPATH==NULL)
         {
            ASPrintf(NULL,logstring,"** Path for %s is NULL [3]",MSGAREATAG);
            Log(logstring);
         }

         AFPrintf(NULL,sout,"Exporting [[33m%25s[0m]   [[32m%-4d[0m]   [[32m%s[0m]\n",MSGAREATAG,MSGAREANUMBER,MSGAREAPATH);

         if(MSGAREAPASSTHRU==FALSE) EnterArea(MSGAREANUMBER,MSGLOCK);

         i=ExportTheArea(); /* <=== LINKS TO PROCAREA.C */

         if(MSGAREAPASSTHRU==FALSE) LeaveArea(MSGAREANUMBER,MSGLOCK);

         if(*MSGAREAPATH==NULL)
         {
            ASPrintf(NULL,logstring,"** Path for %s is NULL [4]",MSGAREATAG);
            Log(logstring);
         }

         if(MSGAREAPASSTHRU)
         {
            i=DeletePassMsgs(MSGAREAPATH);

            if(_VERBOSITY)
            {
               ASPrintf(NULL,logstring,".  DeletePassMsgs() deleted %d files",i);
               Log(logstring);
            }
   
            if(MyDEBUG) AFPrintf(NULL,sout,"Rebuilding POINTERS.MSG... ");

            ASPrintf(NULL,string,"%sPOINTERS.MSG",MSGAREAPATH);

            fp=Open(string,MODE_READWRITE);

            if(fp)
            {
               AFPrintf(NULL,fp,"1\n1\n");
               Close(fp);
            }

            if(MyDEBUG) AFPrintf(NULL,sout,"Done\n");
         }

         if(*MSGAREAPATH==NULL)
         {
            ASPrintf(NULL,logstring,"** Path for %s is NULL [5]",MSGAREATAG);
            Log(logstring);
         }

         if(_ACTIVITYLOG) LogImported(0,EX_THIS_AREA,EX_NODES_THIS_AREA,MSGAREAPATH,MSGAREATAG,MSGAREACLASS);

         if(*MSGAREAPATH==NULL)
         {
            ASPrintf(NULL,logstring,"** Path for %s is NULL [6]",MSGAREATAG);
            Log(logstring);
         }
      }
      else
      {
         Log("!! Skipping processing this area because of a path bug");
      }

      AREASPROCESSED++;

      ASPrintf(NULL,logstring,"<- Done processing %s",MSGAREATAG);
      Log(logstring);

      if(_VERBOSITY>3)
      {
         ASPrintf(NULL,logstring,"<- Bottom of the area loop, the _areacounter_ equals: %d",areacounter);
         Log(logstring);
      }
   }

   FastCloseAll();
   ExportReport();
   return(returncode);
}
//-

/// DeletePassMsgs
int DeletePassMsgs(char *path)
{
   int rc;
   BPTR fp;
   int lo=0,hi=0;
   int i;
   char buffer[100];
   char filename[100];
   char *p;

   if(_VERBOSITY) Log("-> In DeletePassMsgs()");

   ASPrintf(NULL,filename,"%sPOINTERS.MSG",path);

   fp=Open(filename,MODE_OLDFILE);

   if(fp)
   {
      p=FGets(fp,buffer,10);
      if(p) lo=atoi(buffer);     
      p=FGets(fp,buffer,10);

      if(p) hi=atoi(buffer);
      Close(fp);
      DeleteFile(filename);
      rc = 1;
   }
   else
   {
      Log("!  WARNING: No POINTERS.MSG file");
      return(0);
   }

   if(hi)
   {
      if(_VERBOSITY)
      {
         ASPrintf(NULL,logstring,".  Deleting messages 1 to %d (actual reported as %d to %d)",hi,lo,hi);
         Log(logstring);
      }

      for(i=0;i<(hi+1);i++)
      {
         ASPrintf(NULL,filename,"%s%d.MSG",path,i);

         if(DeleteFile(filename))
         {
            rc++;
         }
      }
   }
   else
   {
      if(_VERBOSITY) Log(".  No messages to delete");
   }


   if(_VERBOSITY) Log("<- End DeletePassMsgs()");
   return(rc);
}
//-

/// ExportReport
int ExportReport()
{
   if(_VERBOSITY)
   {
      AFPrintf(NULL,sout,"\nDLGExp Statistics:\n\n");
   
      AFPrintf(NULL,sout,"Total number of areas processed for exporting: %d\n",AREASPROCESSED);
      AFPrintf(NULL,sout,"                Total number of areas skipped: %d\n",AREASSKIPPED);
      AFPrintf(NULL,sout,"           Total number of messages processed: %d\n",MSGSPROCESSED);
      AFPrintf(NULL,sout,"   Total number of outbound messages exported: %d\n",OUTBOUNDSCREATED);
      AFPrintf(NULL,sout,"              Total number of packets created: %d\n",PKTSCREATED);
   }

   Log("-> Statistics:");
   ASPrintf(NULL,logstring," |            Areas Processed: %d",AREASPROCESSED);
   Log(logstring);
   ASPrintf(NULL,logstring," |              Areas Skipped: %d",AREASSKIPPED);
   Log(logstring);
   ASPrintf(NULL,logstring," |         Messages Processed: %d",MSGSPROCESSED);
   Log(logstring);
   ASPrintf(NULL,logstring," | Outbound Messages Exported: %d",OUTBOUNDSCREATED);
   Log(logstring);
   ASPrintf(NULL,logstring," |            Packets Created: %d",PKTSCREATED);
   Log(logstring);
   Log("<- End of statistics");
   
   return(0);
}
//-

/// CheckToExport
int CheckToExport(char *tagname,long number)
{
   char buffer[255];

   Seek(ZMAILEXPfile,0,OFFSET_BEGINNING);

   while(FGets(ZMAILEXPfile,buffer,250))
   {
      buffer[strlen(buffer)-1]=NULL;

      if(!Stricmp(buffer,tagname)) return(1);

      if(isdigit(*buffer))
      {
         if(atoi(buffer)==number) return(1);
      }
   }

   return(0);
}
//-
