#include "DLGAreaFix.h"

#include <link/io.h>

/// GenerateActiveReport
int GenerateActiveReport(char *reportname, char *fiveDaddr)
{
   BPTR  fh;
   int   rc = 0;
   struct area   *Area;

   int   IsActive;

   int   c1 = 0;

   Area = a->first_area;

   fh = Open(reportname, MODE_NEWFILE);

   if (fh != NULL)
   {
      AFPrintf(NULL, fh, "This report was automatically generated by DLGAreaFix.  %s\nactive for the following MESSAGE areas:\n\n", fiveDaddr);

      AFPrintf(NULL, fh, "Tagname                                             KEY\n");
      AFPrintf(NULL, fh, "--------------------------------------------------  ---\n");

      for (; Area; Area = get_next_area(Area))
      {
         IsActive = CheckActive(Area->first_nodenum, fiveDaddr);

         if (1)
         {
            if (IsActive)
            {
               AFPrintf(NULL, fh, "%-50s  ", Area->name);

               if (IsActive == 1)
                  AFPrintf(NULL, fh, "F   ");
               else
                  AFPrintf(NULL, fh, "A   ");

               AFPrintf(NULL, fh, "\n");
               c1++;
            }
         }

      }

      AFPrintf(NULL, fh, "\n");
      AFPrintf(NULL, fh, "Key: A=Active F=Feed U=Unauthorized\n\n");
      AFPrintf(NULL, fh, "Active in [%d] areas\n", c1);
      Close(fh);
      rc = 1;
   }
   else
      Log("!  Couldn't open reply message to append report to");

   return(rc);
}
//-

/// CheckActive
CheckActive(struct nodenum *n, char *addr)
{
   char  work[100];
   int   i = 0;

   for (; n; n = n->next_nodenum)
   {
      i++;
      ASPrintf(NULL,work, "%s!%d:%d/%d.%d", n->organization, n->zone, n->net,
               n->node, n->point);

      if (!Stricmp(work, addr))
         return (i);

   }
   return (0);
}
//-


