// character manipulation routines

#include "Include.h"

/// isletter()
/*      Is the character a letter?  We presume a letter must
   be either in the upper or lower case tables (even if it gets
   translated to itself).
*/
int REG isletter(register unsigned int ch)
{
   return(isupper(ch) || islower(ch));
}
//-

/// islower()
/*      Is the character a lower case letter?  This looks
   in the lower to uppercase translation table.
*/
int REG islower(register unsigned int ch)
{
   return(lowcase[ch] != 0);
}
//-

/// isupper()
/*      Is the character a upper case letter?  This looks
   in the upper to lowercase translation table.
*/
int REG isupper(register unsigned int ch)
{
   return(upcase[ch] != 0);
}
//-

/// uppercase()
/* change *cp to an upper case character
**
** char *cp;      ptr to character to uppercase
****************/
int uppercase(char *cp)
{
   if (islower(*cp)) *cp = lowcase[*cp];  //translate lowercase
   return(1);
}
//-

/// lowercase()
/* change *cp to an lower case character
**
** char *cp;      ptr to character to lowercase
**************/
lowercase(char *cp)
{
   if (isupper(*cp)) *cp = upcase[*cp];   //translate lowercase
   return(1);
}
//-

/// upperc()
/* return the upper case equivalant of a character */
char REG upperc(char ch)
{
   if (islower(ch))
      return(lowcase[ch]);
   else
      return(ch);
}
//-

/// lowerc()
/* return the lower case equivalant of a character */
char REG lowerc(char ch)
{
   if (isupper(ch))
      return(upcase[ch]);
   else
      return(ch);
}
//-

