#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>

#include <dlg/dlg.h>
#include <dlg/msg.h>

#include <link/io.h>

#include <proto/exec.h>
#include <proto/dos.h>
#include <proto/dlg.h>

#include <pragmas/dlg.h>

#include <private/Version.h>
#define  ObjRev "1"
const UBYTE version[]="\0$VER: Quote " BUILDVER "." ObjRev " " COPYRIGHT " by Digerati Dreams "__AMIGADATE__;

void  main  (int, char **);
void _CXBRK(void);
void  Usage (char *);

BPTR            sout;
struct Library *DLGBase = NULL;
char           *body    = NULL;


void main(int argc, char *argv[])

{ULONG             size;

 UBYTE            *currchar;
 UBYTE            *oindex;
 UBYTE            *tchar;

 long              numcols = 78;
 BPTR              mfile;
 struct Msg_Header mhead;

 long    linelen;
 long    counter;
 long    count;
 long    pos;
 long    wrap   = 1;
 UBYTE   b;
 UBYTE   inansi = FALSE;


 sout = Output();
 if (!(DLGBase = OpenLibrary(DLGNAME, DLGVERSION)))  exit(5);

 if (argc < 2)  Usage(" No filename specified");
 if (argc > 2)
    {numcols = atol(argv[2]);
     if (!numcols)  Usage(" Invalid word-wrap column");
    }

 if (!FileSize(argv[1], &size))
    {size -= sizeof(struct Msg_Header);
     body  = malloc(size+1);

     if (body)
        {if ((mfile = Open(argv[1], MODE_OLDFILE)))
            {Read(mfile, &mhead, sizeof(struct Msg_Header));
             Read(mfile, body,   size);
            *(body+size) = 0;
             Close(mfile);

             for(oindex=body, currchar=body; *currchar; currchar++)
                {b = *currchar;

                 if (b == 1)
                    {currchar++;
                     while(*currchar)
                          {if (*currchar == 13)  break;
                           currchar++;
                          }

                     if (!*currchar)  break;
                     if (*(currchar+1) == 10)  currchar++;
                     continue;
                    }

                 if (b == 13 || b == 10)
                    {*oindex++ = 13;
                      if (b == 13)
                          if (*(currchar+1) == 10)  currchar++;

                     tchar = currchar + 1;
                     if (!strncmp(tchar, "SEEN-BY: ", 9))  *tchar = 0;

                     continue;
                    }

                 if (b < 27)  continue;

                 if (inansi)
                    {if (isalpha(b)) inansi = FALSE;
                     continue;
                    }
                  else
                    {if (b == 27)
                        {inansi = TRUE;
                         continue;
                        }
                    }

                 if (b >  27  &&  b <  32)  continue;
                 if (b > 126  &&  b < 160)  continue;

                *oindex++ = b;
                }
            *oindex = 0;

             AFPrintf(NULL, sout, "In a message dated %s, %s wrote:\r\r", mhead.Date, mhead.From);
             pos = 0;

             do{if (wrap == 2)
                   {while(body[pos] == 32)
                          pos++;
                   }

                wrap  = 0;
                count = 2;

                for(counter = 0; count <= numcols; counter++)
                   {b = body[pos+counter];

                    if (b == 13)
                       {wrap = 1;
                        break;
                       }

                    if (b == 0)
                       {wrap = 3;
                        break;
                       }

                    count++;
                   }

                linelen = counter;

                /* If no hard return, do word wrap */
                if (!wrap)
                   {wrap = 2;

                    for(counter--; counter; counter--)
                       {if (body[pos+counter] == 32)
                           {if (counter > (numcols / 2)) linelen = counter;
                            break;
                           }
                       }
                   }


                b = body[pos + linelen];
                body[pos + linelen] = 0;

                AFPrintf(NULL, sout, "> %s\r", body+pos);

                body[pos + linelen] = b;
                pos += linelen;
                if (b == 13) pos++;
               } while(wrap != 3);

             AFPrintf(NULL, sout, "\r");
            }
        }
    }

_CXBRK();
}


void _CXBRK()

{if (body)  free(body);

 CloseLibrary(DLGBase);
 exit(0);
}


void Usage(char *string)

{if (string)  AFPrintf(NULL, sout, string);
 AFPrintf(NULL, sout, "\n\n Usage: Quote <sourcefile> [<numcols>]");
 AFPrintf(NULL, sout, "\n\n   Where <sourcefile> is the file to be quoted and");
 AFPrintf(NULL, sout, "         <numcols> is the word-wrap column (default 78)\n\n");

_CXBRK();
}
