#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>
#include <exec/types.h>

#include <devices/timer.h>

#include <dlg/misc.h>

#include <link/io.h>

#include <proto/exec.h>
#include <proto/dos.h>
#include <proto/dlg.h>

#include <pragmas/dlg.h>

struct Month {char  name[4];
              UBYTE days;
             } months[12] = {{"Jan",31},
                             {"Feb",28},
                             {"Mar",31},
                             {"Apr",30},
                             {"May",31},
                             {"Jun",30},
                        {"Jul",31},
                             {"Aug",31},
                             {"Sep",30},
                             {"Oct",31},
                             {"Nov",30},
                             {"Dec",31}};

char wkdays[7][4] = {"Sun",
                     "Mon",
                     "Tue",
                     "Wed",
                     "Thu",
                     "Fri",
                     "Sat"};


extern struct DosLibrary *DOSBase;
extern struct timerequest tr;


void __saveds __asm LIBUnpackTime(register __d0 ULONG         secs,
                                  register __a0 struct ATime *at)
{long year;
 long month;
 long wday;
 long years;
 long fyears;
 long days;
 long mdays;
 long hours;
 long mins;

  days  =  secs / 86400;
  secs -= (days * 86400);
  wday  =  days % 7;

  fyears  = days   / 1461;
  days   -= fyears * 1461;
  years   = days   / 365;

/*AFPrintf(NULL,Output(),"\ndays: %d  years: %d\n",days,years);*/

  if (years==3 || years==4)  years = (days-1) / 365;
  if (years==3)
      days -= (years * 365);
    else
      days -= (years * 365) - 1;

  at->yday = days;

  years   += fyears*4;

  year     = 1978+years;

  for(month=0; month<12; month++)
     {mdays = months[month].days;
      if (month==1  &&  year == ((year/4)*4))  mdays++;

      if (days>mdays)
          days -= mdays;
        else
          break;
     }

  at->mon  = month;
  at->mday = days;
  at->wday = wday;

  hours    = secs/3600;
  secs    -= hours*3600;

  mins     = secs/60;
  secs    -= mins*60;

  at->hour = hours;
  at->min  = mins;
  at->sec  = secs;
  at->year = year;

  return;
}


void __saveds __asm LIBSMDate(register __d0 ULONG cur_time,
                              register __a0 char *string)
{struct ATime at;

 LIBUnpackTime(cur_time, &at);

 ASPrintf(NULL,string,"%s %2d %s %02d %02d:%02d",wkdays[at.wday],at.mday,months[at.mon].name,at.year%100,at.hour,at.min);

 return;
}


ULONG __saveds __asm LIBAmigaTime(void)

{struct MsgPort    *tport;
 struct timerequest mytr;

 tport = CreateMsgPort();
 if (!tport)  return(0);

 movmem(&tr, &mytr, sizeof(struct timerequest));
 mytr.tr_node.io_Message.mn_ReplyPort = tport;
 mytr.tr_node.io_Command              = TR_GETSYSTIME;

 DoIO((struct IORequest *)&mytr);
 DeleteMsgPort(tport);

 return(mytr.tr_time.tv_secs);
}


void __saveds __asm LIBMDate(register __a0 char *string)

{LIBSMDate(LIBAmigaTime(), string);
 return;
}
