#include <stdlib.h>
#include <string.h>
#include <dos.h>
#include <fcntl.h>
#include <exec/types.h>
#include <ctype.h>

#include <dlg/dlg.h>
#include <dlg/msg.h>
#include <dlg/resman.h>

#include <link/io.h>
#include <link/lang.h>

#include <proto/exec.h>
#include <proto/dos.h>
#include <proto/dlg.h>

#include <pragmas/dlg.h>

#include <private/Version.h>
#define  ObjRev "1"
const UBYTE version[]="\0$VER: OpenAreas " BUILDVER "." ObjRev " " COPYRIGHT " by Digerati Dreams "__AMIGADATE__;


void  main(int argc, char **argv);
long  MakeAreaArray(USHORT *,char *);
long  MakeEchoNet  (USHORT *, USHORT, unsigned char);
void _CXBRK(void);
void  Usage(char *);
void  CleanUp(char *);


BPTR            sout;
char          **SA;
struct Library *DLGBase = NULL;

#define NumAreas 100000
USHORT *AreaArray = NULL;
char    flags  =  0;
int     fp     =  EOF;

/// main
void main(int argc,char **argv)
{
   long     retval;
   USHORT   numareas;
   USHORT   area;

   char *s;
   char *alist  =  NULL;
   char *passwd = "DIALOG";

   sout    = Output();
   DLGBase = OpenLibrary(DLGNAME,DLGVERSION);
   if (!DLGBase)               CleanUp("Unable to open dlg.library");
   if (!(SA = getlang(NULL)))  CleanUp("Can't read language file");

   AFPrintf(NULL, sout, "\n");

   while(--argc>0)
   {
      s = *++argv;

      if (*s++=='-')
      {
         while(*s)
         {
            switch(*s++)
            {
               case 'a':
               case 'A':  if (!--argc)  break;
               alist = *++argv;
               break;

               case 'k':
               case 'K':  if (!--argc)  break;
               passwd = *++argv;
               break;

               case 'm':
               case 'M':  flags = MSGLOCK;
               break;

               case 'f':
               case 'F':  flags = FILELOCK;
               break;
            }
         }
      }
   }

   if (!alist)  Usage(SA[2866]);

   if(! (AreaArray = calloc(NumAreas,sizeof(ULONG))))
      CleanUp(NULL);

   numareas = MakeAreaArray(AreaArray,alist);
   sqsort((SHORT *)AreaArray, numareas);

   for(area = 0; area < numareas; area++)
   {
      AFPrintf(NULL, sout, SA[2867],AreaArray[area]);

      retval=FreeArea(AreaArray[area],passwd,flags);
      if (retval==RMNOERR)
      AFPrintf(NULL, sout, SA[2868]);
      else
      {
         if (retval==NORM)
         CleanUp(SA[2869]);
         else
         if (retval==BADAREA)
         AFPrintf(NULL, sout, SA[2870]);
         else
         if (retval==NOTLOCKED)
         AFPrintf(NULL, sout, SA[2871]);
         else
         AFPrintf(NULL, sout, SA[2872]);
         break;
      }
   }

   AFPrintf(NULL, sout, "\n");
   CleanUp(NULL);
}
//-

/// MakeAreaArray
long MakeAreaArray(USHORT *array, char *alist)
{
   USHORT        area;
   char         *s;

   unsigned char EchoFlag  = 0;
   unsigned char NetFlag   = 0;
   unsigned char LocalFlag = 0;

   s = alist;

   for(area=0; area < NumAreas; area++)
   {
      while(*s==32) s++;
      if (!*s) break;

      if (!Strnicmp(s,"ECHO",4))
      {
         if (EchoFlag)
         {
            AFPrintf(NULL, sout, SA[2873]);
            area--;
         }
         else
         if (flags & FILELOCK)
         {
            AFPrintf(NULL, sout, SA[2874]);
            area--;
         }
         else
         {
            EchoFlag = 1;
            area     = MakeEchoNet(array, area, ECHO_AREA);
         }
      }
      else
      if (!Strnicmp(s,"NET",3))
      {
         if (NetFlag)
         {
            AFPrintf(NULL, sout, SA[2875]);
            area--;
         }
         else
         if (flags & FILELOCK)
         {
            AFPrintf(NULL, sout, SA[2876]);
            area--;
         }
         else
         {
            NetFlag = 1;
            area    = MakeEchoNet(array, area, NETMAIL_AREA);
         }
      }
      else
      if (!Strnicmp(s,"LOCAL",5))
      {
         if (LocalFlag)
         {
            AFPrintf(NULL, sout, SA[2877]);
            area--;
         }
         else
         {
            LocalFlag = 1;
            area      = MakeEchoNet(array, area, 0);
         }
      }
      else
      array[area] = atoi(s);

      while((*s)&&(*s!=32)) s++;
   }

   if (area == NumAreas)
   AFPrintf(NULL, sout, SA[2878], NumAreas);

   return(area);
}
//-

/// MakeEchoNet
long MakeEchoNet(USHORT *array, USHORT area, unsigned char type)
{
   char              areafile[80];
   struct  Msg_Area  Area;

   ASPrintf(NULL, areafile, "%s:Area.bbs", (flags & FILELOCK)?"FILE":"MSG");

   if ((fp = open(areafile,O_RDONLY)) == EOF)
   AFPrintf(NULL, sout, SA[2879], areafile);
   else
   {
      while(((read(fp, &Area, sizeof(Area))) == sizeof(Area)) && (area < NumAreas))
      {
         if ((Area.Flag & type)  ||  (!type && !(Area.Flag & (ECHO_AREA | NETMAIL_AREA))))
         {
            array[area] = Area.Number;
            area++;
         }
      }

      close(fp);
      fp = EOF;
   }

   --area;
   return(area);
}
//-

void  _CXBRK(void)

{
   CleanUp(NULL);
}


void Usage(char *string)

{
   AFPrintf(NULL, sout, SA[2880],string);
   AFPrintf(NULL, sout, SA[2881]);
   AFPrintf(NULL, sout, SA[2882]);

   CleanUp(NULL);
}


void CleanUp(char *s)

{
   if (AreaArray)  free(AreaArray);
   if (fp != EOF)  close(fp);
   if (DLGBase)    CloseLibrary(DLGBase);

   if (s)
   {
      Write(sout, "\n Error: ", 9);
      Write(sout,  s,    strlen(s));
      Write(sout, "\n\n",       2);
   }

   exit(s?5:0);
}
