#include <stdlib.h>
#include <string.h>
#include <exec/types.h>
#include <ctype.h>

#include <dlg/dlg.h>
#include <dlg/msg.h>
#include <dlg/resman.h>

#include <link/io.h>
#include <link/lang.h>

#include <proto/exec.h>
#include <proto/dos.h>
#include <proto/dlg.h>

#include <pragmas/dlg.h>

void main   (int, char **);
void Usage  (char *);
void CleanUp(char *);


BPTR            sout;
char          **SA;
struct Library *DLGBase = NULL;

#include <private/Version.h>
#define  ObjRev "1"
const UBYTE version[]="\0$VER: EnterArea " BUILDVER "." ObjRev " " COPYRIGHT " by Digerati Dreams "__AMIGADATE__;

void main(int argc,char **argv)
{
   long   retval;
   long   area;
   UBYTE  flags = 0;

   sout    = Output();
   DLGBase = OpenLibrary(DLGNAME,DLGVERSION);
   if (!DLGBase)               CleanUp("Unable to open dlg.library");
   if (!(SA = getlang(NULL)))  CleanUp("Can't read language file");

   AFPrintf(NULL, sout, "\n");
   area = -2;

   while(--argc>0)
   {
      char *s;

      s = *++argv;
      if (*s++ == '-')
      {
         while(*s)
         {
            switch(*s)
            {
               case 'a':
               case 'A':  if (!--argc) break;
               area = atol(*++argv);
               break;

               case 'm':
               case 'M':  flags |= MSGLOCK;
               break;

               case 'f':
               case 'F':  flags |= FILELOCK;
               break;

               case 'w':
               case 'W':  flags |= ENTERPEND;
               break;
            }
            s++;
         }
      }
   }

   if (area == -2)  Usage(SA[2777]);

   retval = EnterArea(area, flags);
   if (retval == RMNOERR)
   AFPrintf(NULL, sout, SA[2778]);
   else
   if (retval == NORM)
   CleanUp(SA[2779]);
   else
   if (retval == AREAINUSE)
   CleanUp(SA[2780]);
   else
   CleanUp(SA[2781]);

   AFPrintf(NULL, sout, "\n");
   CleanUp(NULL);
}


void Usage(char *string)

{
   AFPrintf(NULL, sout, SA[2782],string);
   AFPrintf(NULL, sout, SA[2783]);
   AFPrintf(NULL, sout, SA[2784]);
   AFPrintf(NULL, sout, SA[2785]);

   CleanUp(NULL);
}


void CleanUp(char *s)

{
   if (DLGBase)  CloseLibrary(DLGBase);

   if (s)
   {
      Write(sout, "\n Error: ", 9);
      Write(sout,  s,    strlen(s));
      Write(sout, "\n\n",       2);
   }

   exit(s?5:0);
}
