// Return info about an area to stdout.
#include <stdlib.h>
#include <string.h>
#include <exec/types.h>
#include <ctype.h>

#include <dlg/resman.h>
#include <dlg/dlg.h>

#include <link/io.h>
#include <link/lang.h>

#include <proto/exec.h>
#include <proto/dos.h>

#include <proto/dlg.h>
#include <pragmas/dlg.h>

#include <private/Version.h>
#define  ObjRev "1"
const UBYTE version[]="\0$VER: AreaInfo " BUILDVER "." ObjRev " " COPYRIGHT " by Digerati Dreams "__AMIGADATE__;

void main   (int, char**);
void Usage  (char *);
void CleanUp(char *);


BPTR            sout;
char          **SA;
struct Library *DLGBase =  NULL;

/// main
void main(int argc, char **argv)
{
   long               retval;
   UBYTE              flags   =  MSGLOCK;
   struct DLGAreaInfo istruct = {-2, 0, 0, 0, 0};

   sout    = Output();
   DLGBase = OpenLibrary(DLGNAME,DLGVERSION);
   if (!DLGBase)               CleanUp("Unable to open dlg.library");
   if (!(SA = getlang(NULL)))  CleanUp("Can't read language file");

   AFPrintf(NULL, sout, "\n");

/// parse args
   while(--argc>0)
   {
      char *s;

      s = *++argv;

      if (*s++=='-')
      {
         while(*s)
         {
            switch(toupper(*s))
            {
               case 'A':   if (!--argc)  break;
                           istruct.area = atol(*++argv);
                           break;

               case 'M':   flags = MSGLOCK;  break;
               case 'F':   flags = FILELOCK; break;
            }

            s++;
         }
      }
   }
//-

   if (istruct.area == -2)  Usage(SA[2710]);

   retval = GetAreaInfo(&istruct, flags);

   if (retval == RMNOERR)
   {
      AFPrintf(NULL, sout, SA[2711], istruct.area);
      AFPrintf(NULL, sout, SA[2712], istruct.passwd);
      AFPrintf(NULL, sout, SA[2713], istruct.reason);
      AFPrintf(NULL, sout, SA[2714], istruct.priority);
      AFPrintf(NULL, sout, SA[2715], istruct.users);

      FreeAreaInfo(&istruct);
   }
   else
   {
      if (retval == NORM)
      {
         CleanUp(SA[2716]);
      }
      else
      {
         if (retval == BADAREA)
         {
            CleanUp(SA[2717]);
         }
         else
         {
            if (retval == NOTLOCKED)
               CleanUp(SA[2718]);
            else
               CleanUp(SA[2719]);
         }
      }
   }

   AFPrintf(NULL, sout, "\n");
   CleanUp(NULL);
}
//-

void Usage(char *string)
{
   AFPrintf(NULL, sout, SA[2720],string);
   AFPrintf(NULL, sout, SA[2721]);
   AFPrintf(NULL, sout, SA[2722]);

   CleanUp(NULL);
}


void CleanUp(char *s)
{
   if (DLGBase)  CloseLibrary(DLGBase);

   if (s)
   {
      Write(sout, "\n Error: ", 9);
      Write(sout,  s,    strlen(s));
      Write(sout, "\n\n",       2);
   }

   exit(s?5:0);
}
