{騪 権  ZX Spectrum.                                         }
{-----------------------------------                                         }
{(c) 1999 by Flying/Digital Reality                                          }
{஬ ᯠᨡ  ﭪ    প.                    }

Program ZX_Animation_Packer;
{$M 65520,0,655360}

Uses
  ZXA,
  Dos,
  Speccy,
  Screen,
  Keyboard,
  Video,
  CLParser,
  StringsUnit,
  ExitUnit;

Const
  RotateSym : string = '/-\|';

  MaxForwardLook  = 1;  {⢮ "ᬠਢ ।" }
  MaxMethods      = 12; {⢮ ⮤ 㯠 ᫥⥫쭮}

{䨪 ⮤ 㯠 ᫥⥫쭮⥩}
  idSkip        = 1;             {ய ᪮쪨 }
  idSkipAdd     = 2;             {ய ᪮쪨  + . }
  idInverse     = 3;             { ᪮쪨 }
  idInverseAdd  = 4;             { ᪮쪨  + . }
  idByte        = 5;             { । 祭}
  idByteAdd     = 6;             { । 祭 + . }
  idFillFF      = 7;             { #FF}
  idFillFFAdd   = 8;             { #FF + . }
  idFillZero    = 9;             { #00}
  idFillZeroAdd = 10;            { #00 + . }
  idSpecByte    = 11;            {饭 ᯥ. }
  idSpecByteAdd = 12;            {饭 ᯥ.  + . }

Type
  TSizeArray = array [1..3] of byte;

  TRatio = record
    UnpackedSize : word; { ࠡ⠭ 㯠 ᫥⥫쭮.}
    PackedSize   : word; { 㯠 ᫥⥫쭮.}
    Ratio        : real; {⭮襭 ࠧ஢. 0 ᫨ 㯠  뫮}
  end;

  TBox = record
    x1,y1,x2,y2:byte;
    Empty:boolean;
  end;

  PFNameArray = ^TFNameArray;
  TFNameArray = array [0..255] of string[100];

Var
  Buf:PScreen;
  ZXScreen:PSpeccyScreen;
  ZXPrevScreen:PSpeccyScreen;
  ZXScr:PSpeccyScreen;
  ZXPrev:PSpeccyScreen;
  Param:PCLParam;
  PackedSize:word;
  TotalUnpacked:longint;
  TotalPacked:word;
  i,j,k:integer;
  FNameArray:PFNameArray;
  QFrames:byte;
  FileType:TFileType;
  ft:text;
  f_tmp,f:file;
  p,tp:real;
  s,s1:string;
  D:DirStr;
  N:NameStr;
  E:ExtStr;
  wx,wy,b:byte;
  sz:word;
  WriteStat:boolean;
  MaxFrameSize:word;
  Spr:Pointer;
  OutArray:PByteArray;
  FramesPtrs:array [0..$FF] of word;
  BoundsArray:array [0..$FF] of TBox;
  Bounds:TBox;
  TempCreated:boolean;
  WasC64Warnings:boolean;
  WasLacedWarnings:boolean;
{Options related variables}
  FName:string;
  x,y,xs,ys:byte;
  XOffset,YOffset:byte;
  PlayerType:byte;
  SaveEach:boolean;
  isPrev:boolean;
  isColumn:boolean;
  isInvert:boolean;
  isRemap:boolean;
  isScale:boolean;
  isSave:boolean;
  isSingle:boolean;
  useStartScreen:boolean;

{㧪 ࠭     }
{㦠 SCR, Hobeta  PCX ࠭}
Procedure LoadScreen(FName:string;Buf:PSpeccyScreen);
var
  r:byte;
  f:file;
  Adr:word;
  b1,b2:byte;
  i:word;
  Pal:TPalette;
  ft:TFileType;
  TempScr:PSpeccyScreen;
  lastSS:word;
begin
  ft:=CheckScreen(FName);
  if not (ft in [ft_PCX,ft_SCR,ft_Hobeta]) then
  begin
    ErrorMessage:='File '''+FName+''' is not a screen into supported formats!';
    halt(exit_CustomError);
  end;
  SetSpeccyScreen(Buf);
  ClearSpeccyScreen($47);
  case ft of
    ft_PCX:
      begin
{Load .PCX file}
        ClearScr;
        r:=LoadPCX(FName,ScreenBuf,@Palette);
        if r<>exit_Ok then
          halt(r);
        if isRemap then
        begin
          FillChar(Pal,SizeOf(Pal),0);
          Pal[255,1]:=$3F;
          Pal[255,2]:=$3F;
          Pal[255,3]:=$3F;
          RemapScreen(ScreenBuf,@Palette,@Pal);
        end;
        GetSprite(ScreenBuf,Spr,0,0,255,192);
        PutPCSprite(Spr,0,0,255,192,psmNormal);
      end;
    ft_Hobeta:
      begin
{Load Hobeta file}
        ReadHobetaFile(FName,Buf);
      end;
    ft_SCR:
      begin
{Load .SCR file}
        Assign(f,FName);
{$I-}
        reset(f,1);
{$I+}
        if IOResult<>0 then
        begin
          ErrorMessage:=FName;
          halt(exit_ErrorOpenFile);
        end;
        BlockRead(f,Buf^,SizeOf(Buf^));
        close(f);
      end;
  end;
  if isInvert then
    for i:=0 to 6143 do
      Buf^[i]:=Buf^[i] xor $FF;
  if isSave then
    SaveScreen(FName,Buf);
{᫨ ࠭ C64 like player  㦭 ந 㬥襭 ஢,
 㬥蠥 室 ࠭  4 ࠧ}
  if (PlayerType=ptC64) and (isScale) then
  begin
    lastSS:=SpeccyScreen;
    CreateSpeccyScreen(TempScr);
    for i:=0 to 191 div 2 do
    begin
      for j:=0 to 15 do
      begin
        Adr:=GetScreenAddress(j*2,i*2);
        b1:=Buf^[Adr];
        b2:=Buf^[Adr+1];
        asm
          mov bh,b1
          mov bl,b2
          xor al,al
          rcl bh,2
          rcl al,1
          rcl bh,2
          rcl al,1
          rcl bh,2
          rcl al,1
          rcl bh,2
          rcl al,1
          rcl bl,2
          rcl al,1
          rcl bl,2
          rcl al,1
          rcl bl,2
          rcl al,1
          rcl bl,2
          rcl al,1
          mov b1,al
        end;
        Adr:=GetScreenAddress(j,i);
        TempScr^[Adr]:=b1;
      end;
    end;
    Move(TempScr^,Buf^,SizeOf(Buf^));
    DestroySpeccyScreen(TempScr);
    SpeccyScreen:=lastSS;
  end;
end;

{楤 室  אַ㣮쭨   頥 ࠦ}
Procedure GetBoundingBox(Buf:PSpeccyScreen;var Box:TBox);
var
  i,j:byte;
  Adr:word;
begin
{left bound}
  for i:=0 to 31 do
  begin
    for j:=0 to 191 do
    begin
      Adr:=GetScreenAddress(i,j);
      if Buf^[Adr]>0 then
        break;
    end;
    if Buf^[Adr]>0 then
      break;
  end;
  Box.x1:=i;
{right bound}
  for i:=31 downto 0 do
  begin
    for j:=0 to 191 do
    begin
      Adr:=GetScreenAddress(i,j);
      if Buf^[Adr]>0 then
        break;
    end;
    if Buf^[Adr]>0 then
      break;
  end;
  Box.x2:=i;
{up bound}
  for j:=0 to 191 do
  begin
    for i:=0 to 31 do
    begin
      Adr:=GetScreenAddress(i,j);
      if Buf^[Adr]>0 then
        break;
    end;
    if Buf^[Adr]>0 then
      break;
  end;
  Box.y1:=j;
{down bound}
  for j:=191 downto 0 do
  begin
    for i:=0 to 31 do
    begin
      Adr:=GetScreenAddress(i,j);
      if Buf^[Adr]>0 then
        break;
    end;
    if Buf^[Adr]>0 then
      break;
  end;
  Box.y2:=j;
  with Box do
  begin
    Empty:=false;
    if (x2<x1) or (y2<y1) then
      Empty:=true;
  end;
end;

{ꥤ bounding boxes  ஢ 樨}
Procedure JoinBounds(Bounds1:TBox;var Bounds2:TBox);
begin
  if Bounds2.Empty then
  begin
    Bounds2:=Bounds1;
    exit;
  end;
  if Bounds1.x1<Bounds2.x1 then
    Bounds2.x1:=Bounds1.x1;
  if Bounds1.x2>Bounds2.x2 then
    Bounds2.x2:=Bounds1.x2;
  if Bounds1.y1<Bounds2.y1 then
    Bounds2.y1:=Bounds1.y1;
  if Bounds1.y2>Bounds2.y2 then
    Bounds2.y2:=Bounds1.y2;
end;

{஢ ⨥ ESC  室  ணࠬ}
Procedure CheckKeyboard;
begin
  if ESCPressed then
  begin
    writeln;
    writeln('ESC pressed. Program aborted.');
    halt(exit_Ok);
  end;
end;

(*
ZXScreen     : ⥪騩  樨
ZXPrevScreen : ।騩  樨
x,y       = न  孥 㣫 ࠡ뢠 
            (y  ᥫ)
xs,ys     = ࠧ ࠡ뢠  (y  ᥫ)
isPrev    = TRUE  - ᦨ ⭮⥫쭮 ।饣   PrevScr
          = FALSE - ᦨ ᨬ 
isColumns = TRUE  - ᦨ  ⮫栬
          = FALSE - ᦨ  ப

㭪 頥 ࠧ 㯠 .
*)
Function PackFrame(x,y,xs,ys:byte;isPrev,isColumns:boolean):word;
var
  TotalSize:word;
  SrcPtr:word;
  DestPtr:word;
  PackRatings:array[0..MaxForwardLook-1,1..MaxMethods] of TRatio;
  TempBuf:TByteArray;
  isSequence:boolean;
  SequenceIndex:word;
  QBytes:byte;
  Data:TSizeArray;
  Index:byte;
  MethodID:byte;
  UnpSz:word;
  MaxRatio:real;
  i,j:integer;
  b:byte;
  u,p:word;
  r:real;

{ ࠭  ࠩ  ப}
Procedure ConvertToLines(SrcScr,DestScr:PSpeccyScreen;x,y,xs,ys:byte);
var
  i,j:byte;
  ptr:word;
  Adr:word;
begin
  ptr:=0;
  i:=y;
  repeat
    Adr:=GetScreenAddress(0,i);
    for j:=x to x+xs-1 do
    begin
      DestScr^[ptr]:=SrcScr^[Adr+j];
      inc(ptr);
    end;
    inc(i);
    if PlayerType=ptLaced then
      inc(i);
  until i>=y+ys;
end;

{ ࠭  ࠩ  ⮫栬}
Procedure ConvertToColumns(SrcScr,DestScr:PSpeccyScreen;x,y,xs,ys:byte);
var
  i,j:byte;
  ptr:word;
  Adr:word;
begin
  ptr:=0;
  for i:=x to x+xs-1 do
  begin
    j:=y;
    repeat
      Adr:=GetScreenAddress(i,j);
      DestScr^[ptr]:=SrcScr^[Adr];
      inc(ptr);
      inc(j);
      if PlayerType=ptLaced then
        inc(j);
    until j>=y+ys;
  end;
end;

{頥 ࠧ ᫥⥫쭮  ,}
{ᯮ 稭  .}
Function GetSequenceSize(Buf:PByteArray;Ptr:word):word;
var
  cnt:word;
  b:byte;
begin
  if Ptr>=TotalSize then
  begin
    GetSequenceSize:=0;
    exit;
  end;
  b:=Buf^[Ptr];
  cnt:=1;
  repeat
    if Ptr+cnt>=TotalSize then
      break;
    if Buf^[Ptr+cnt]=b then
      inc(cnt)
    else
      break;
  until false;
  GetSequenceSize:=cnt;
end;

(*
   ࠧ ᫥⥫쭮   
࠭塞  㯠 䠩.
Size      - 室   ࠧ ᫥⥫쭮.
ByteLimit - ᨬ쭮 ᫮, ஥    1- .
QBytes    - ⢮    ࠧ.
Data      -   ࠧ.
*)
Procedure ConvertSize(Size:word;ByteLimit:byte;
                      var QBytes:byte;var Data:TSizeArray);
begin
  if Size<ByteLimit then
  begin
    QBytes:=1;
    Data[1]:=Size;
    exit;
  end;
  if Size<=$FF then
  begin
    QBytes:=2;
    Data[1]:=0;
    Data[2]:=Size;
    exit;
  end;
  QBytes:=3;
  Data[1]:=0;
  Data[2]:=Hi(Size);
  Data[3]:=Lo(Size);
  exit;
end;

{࠭   DestBuf}
Procedure StoreByte(DestBuf:PByteArray;var Ptr:word;Data:byte);
begin
  DestBuf^[Ptr]:=Data;
  Inc(Ptr);
end;

(*
 楤 ⢫騥   ᫥騩 ଠ ࠬ஢:
-----------------------------------------------------------------------
ZXScr  : ⥪騩  樨
ZXPrev : ।騩  樨 (筥  ⥪饣 
         ⭮⥫쭮 ।饣)
Ptr          = ⥫  ⥪饬   砫 㥬 ᫥⥫쭮
DestBuf      = ⥫     㤥 ᪫뢠 㯠
               ᫥⥫쭮.
isAdd        = TRUE/FALSE - /   . .
Ratio        =   ࠧ ᫥⥫쭮⥩.
*)

{ ⥪饩 ᫥⥫쭮 ⥬ ய᪠ ᪮쪨 }
{᫨  ᨬ ࠭ - ᥣ 頥 PackedSize=0}
Procedure Pack_Skip(Ptr:word;DestBuf:PByteArray;isAdd:boolean;var Ratio:TRatio);
var
  i:integer;
  QBytes:byte;
  Data:TSizeArray;
begin
{᫨  ᨬ ࠭  ⥪騩    ࠢ }
{।騬 ஬ -   室}
  if (not isPrev) or
     (ZXPrev^[Ptr]<>$00) then
  begin
    with Ratio do
    begin
      UnpackedSize:=0;
      PackedSize:=0;
      Ratio:=0;
    end;
    exit;
  end;
{稫 ࠧ ய᪠ }
  Ratio.UnpackedSize:=GetSequenceSize(PByteArray(ZXPrev),Ptr);
  Ratio.PackedSize:=0;
  ConvertSize(Ratio.UnpackedSize,qSkip div 2,QBytes,Data);
{ନ஢  .   2 - 室 ᢮}
{0-   ਧ . }
  Data[1]:=bSkip+(Data[1]*2);
{⠭ ਧ . }
  if isAdd then
    Inc(Data[1]);
{࠭塞  }
  for i:=1 to QBytes do
    StoreByte(DestBuf,Ratio.PackedSize,Data[i]);
{ 室 ࠭塞 . }
  if isAdd then
  begin
    StoreByte(DestBuf,Ratio.PackedSize,ZXScr^[Ptr+Ratio.UnpackedSize]);
    inc(Ratio.UnpackedSize);
  end;
  with Ratio do
    Ratio:=UnpackedSize/PackedSize;
end;

{ ⥪饩 ᫥⥫쭮 ⥬ ᨨ ᪮쪨 }
{᫨  ᨬ ࠭ - ᥣ 頥 PackedSize=0}
Procedure Pack_Inverse(Ptr:word;DestBuf:PByteArray;isAdd:boolean;var Ratio:TRatio);
var
  i:integer;
  QBytes:byte;
  Data:TSizeArray;
begin
{᫨  ᨬ ࠭  ⥪騩   ஢ }
{ࠢ  ।騬 ஬ -   室}
  if (not isPrev) or
     (ZXPrev^[Ptr]<>$FF) then
  begin
    with Ratio do
    begin
      UnpackedSize:=0;
      PackedSize:=0;
      Ratio:=0;
    end;
    exit;
  end;
{稫 ࠧ 㥬 }
  Ratio.UnpackedSize:=GetSequenceSize(PByteArray(ZXPrev),Ptr);
  Ratio.PackedSize:=0;
  ConvertSize(Ratio.UnpackedSize,qInverse div 2,QBytes,Data);
{ନ஢  .   2 - 室 ᢮}
{0-   ਧ . }
  Data[1]:=bInverse+(Data[1]*2);
{⠭ ਧ . }
  if isAdd then
    Inc(Data[1]);
{࠭塞  }
  for i:=1 to QBytes do
    StoreByte(DestBuf,Ratio.PackedSize,Data[i]);
{ 室 ࠭塞 . }
  if isAdd then
  begin
    StoreByte(DestBuf,Ratio.PackedSize,ZXScr^[Ptr+Ratio.UnpackedSize]);
    inc(Ratio.UnpackedSize);
  end;
  with Ratio do
    Ratio:=UnpackedSize/PackedSize;
end;

{ ⥪饩 ᫥⥫쭮 ⥬  ⮬}
Procedure Pack_Byte(Ptr:word;DestBuf:PByteArray;isAdd:boolean;var Ratio:TRatio);
var
  i:integer;
  QBytes:byte;
  Data:TSizeArray;
begin
{稫 ࠧ  }
  Ratio.UnpackedSize:=GetSequenceSize(PByteArray(ZXScr),Ptr);
  Ratio.PackedSize:=0;
  ConvertSize(Ratio.UnpackedSize,qByte div 2,QBytes,Data);
{ନ஢  .   2 - 室 ᢮}
{0-   ਧ . .}
  Data[1]:=bByte+(Data[1]*2);
{⠭ ਧ . }
  if isAdd then
    Inc(Data[1]);
{࠭塞  }
  for i:=1 to QBytes do
    StoreByte(DestBuf,Ratio.PackedSize,Data[i]);
  StoreByte(DestBuf,Ratio.PackedSize,ZXScr^[Ptr]);
{ 室 ࠭塞 . }
  if isAdd then
  begin
    StoreByte(DestBuf,Ratio.PackedSize,ZXScr^[Ptr+Ratio.UnpackedSize]);
    inc(Ratio.UnpackedSize);
  end;
  with Ratio do
    Ratio:=UnpackedSize/PackedSize;
end;

{ ⥪饩 ᫥⥫쭮 ⥬  ⮬ #FF}
Procedure Pack_FillFF(Ptr:word;DestBuf:PByteArray;isAdd:boolean;var Ratio:TRatio);
var
  i:integer;
  QBytes:byte;
  Data:TSizeArray;
begin
{᫨ ⥪騩  -  #FF,   室}
  if (ZXScr^[Ptr]<>$FF) then
  begin
    with Ratio do
    begin
      UnpackedSize:=0;
      PackedSize:=0;
      Ratio:=0;
    end;
    exit;
  end;
{稫 ࠧ  }
  Ratio.UnpackedSize:=GetSequenceSize(PByteArray(ZXScr),Ptr);
  Ratio.PackedSize:=0;
  ConvertSize(Ratio.UnpackedSize,qFillFF div 2,QBytes,Data);
{ନ஢  .   2 - 室 ᢮}
{0-   ਧ . .}
  Data[1]:=bFillFF+(Data[1]*2);
{⠭ ਧ . }
  if isAdd then
    Inc(Data[1]);
{࠭塞  }
  for i:=1 to QBytes do
    StoreByte(DestBuf,Ratio.PackedSize,Data[i]);
{ 室 ࠭塞 . }
  if isAdd then
  begin
    StoreByte(DestBuf,Ratio.PackedSize,ZXScr^[Ptr+Ratio.UnpackedSize]);
    inc(Ratio.UnpackedSize);
  end;
  with Ratio do
    Ratio:=UnpackedSize/PackedSize;
end;

{ ⥪饩 ᫥⥫쭮 ⥬  ⮬ #00}
Procedure Pack_FillZero(Ptr:word;DestBuf:PByteArray;isAdd:boolean;var Ratio:TRatio);
var
  i:integer;
  QBytes:byte;
  Data:TSizeArray;
begin
{᫨ ⥪騩  -  #00,   室}
  if (ZXScr^[Ptr]<>$00) then
  begin
    with Ratio do
    begin
      UnpackedSize:=0;
      PackedSize:=0;
      Ratio:=0;
    end;
    exit;
  end;
{稫 ࠧ  }
  Ratio.UnpackedSize:=GetSequenceSize(PByteArray(ZXScr),Ptr);
  Ratio.PackedSize:=0;
  ConvertSize(Ratio.UnpackedSize,qFillZero div 2,QBytes,Data);
{ନ஢  .   2 - 室 ᢮}
{0-   ਧ . .}
  Data[1]:=bFillZero+(Data[1]*2);
{⠭ ਧ . }
  if isAdd then
    Inc(Data[1]);
{࠭塞  }
  for i:=1 to QBytes do
    StoreByte(DestBuf,Ratio.PackedSize,Data[i]);
{ 室 ࠭塞 . }
  if isAdd then
  begin
    StoreByte(DestBuf,Ratio.PackedSize,ZXScr^[Ptr+Ratio.UnpackedSize]);
    inc(Ratio.UnpackedSize);
  end;
  with Ratio do
    Ratio:=UnpackedSize/PackedSize;
end;

{ ⥪饩 ᫥⥫쭮 ⥬ 饭 ᯥ. }
Procedure Pack_SpecByte(Ptr:word;DestBuf:PByteArray;isAdd:boolean;var Ratio:TRatio);
var
  i:integer;
  QBytes:byte;
  Data:TSizeArray;
begin
{᫨ ⥪騩  -    ᯥ. ⮢,   室}
  if not (ZXScr^[Ptr] in SpecByteSet) then
  begin
    with Ratio do
    begin
      UnpackedSize:=0;
      PackedSize:=0;
      Ratio:=0;
    end;
    exit;
  end;
{宦  ⮣ ᯥ. }
  for i:=0 to $0F do
    if ZXScr^[Ptr]=SpecBytes[i] then break;
{ନ஢  .   2 - 室 ᢮}
{0-   ਧ . }
  Data[1]:=bSpecByte+(i*2);
  Ratio.UnpackedSize:=1;   {ᥣ 1  ᯥ. }
  Ratio.PackedSize:=0;
{⠭ ਧ . }
  if isAdd then
    Inc(Data[1]);
{࠭塞  }
  StoreByte(DestBuf,Ratio.PackedSize,Data[1]);
{ 室 ࠭塞 . }
  if isAdd then
  begin
    StoreByte(DestBuf,Ratio.PackedSize,ZXScr^[Ptr+Ratio.UnpackedSize]);
    inc(Ratio.UnpackedSize);
  end;
  with Ratio do
    Ratio:=UnpackedSize/PackedSize;
end;

{  । ஬}
{MethodID - 䨪 ⮤ 㯠 (idXXXX)}
{Index -   ᨢ PackRatings}
{SrcIndex - ᬥ饭 砫 ᫥⥫쭮 ⭮⥫쭮 ⥪饣 }
Procedure CallMethod(MethodID:byte;Index:word;SrcIndex:word);
begin
  case MethodID of
    idSkip        : Pack_Skip    (SrcPtr+SrcIndex,@TempBuf,False,PackRatings[Index,idSkip]);
    idSkipAdd     : Pack_Skip    (SrcPtr+SrcIndex,@TempBuf,True ,PackRatings[Index,idSkipAdd]);
    idInverse     : Pack_Inverse (SrcPtr+SrcIndex,@TempBuf,False,PackRatings[Index,idInverse]);
    idInverseAdd  : Pack_Inverse (SrcPtr+SrcIndex,@TempBuf,True ,PackRatings[Index,idInverseAdd]);
    idByte        : Pack_Byte    (SrcPtr+SrcIndex,@TempBuf,False,PackRatings[Index,idByte]);
    idByteAdd     : Pack_Byte    (SrcPtr+SrcIndex,@TempBuf,True ,PackRatings[Index,idByteAdd]);
    idFillFF      : Pack_FillFF  (SrcPtr+SrcIndex,@TempBuf,False,PackRatings[Index,idFillFF]);
    idFillFFAdd   : Pack_FillFF  (SrcPtr+SrcIndex,@TempBuf,True ,PackRatings[Index,idFillFFAdd]);
    idFillZero    : Pack_FillZero(SrcPtr+SrcIndex,@TempBuf,False,PackRatings[Index,idFillZero]);
    idFillZeroAdd : Pack_FillZero(SrcPtr+SrcIndex,@TempBuf,True ,PackRatings[Index,idFillZeroAdd]);
    idSpecByte    : Pack_SpecByte(SrcPtr+SrcIndex,@TempBuf,False,PackRatings[Index,idSpecByte]);
    idSpecByteAdd : Pack_SpecByte(SrcPtr+SrcIndex,@TempBuf,True ,PackRatings[Index,idSpecByteAdd]);
  end;
end;

{楤 蠥 ନ஢ ᫥⥫쭮 㯠 }
Procedure CompleteSequence;
var
  i:integer;
begin
  if not isSequence then
    exit;
{     㯠 ᫥⥫쭮 .}
{ 室 ࠭ ० 祬 ࠭ ⥪ ᫥⥫쭮.}
  ConvertSize(SequenceIndex,qSequence,QBytes,Data);
  Data[1]:=bSequence+Data[1];
{  ࠧ}
  for i:=1 to QBytes do
    StoreByte(OutArray,DestPtr,Data[i]);
{ ᫥⥫쭮}
  for i:=0 to SequenceIndex-1 do
    StoreByte(OutArray,DestPtr,ZXScr^[SrcPtr+i]);
end;

{஡ ᯮ짮  ⮤ 㯠 ⥪饩 ᫥⥫쭮}
{ ᡮ   ३⨭ 㯠.}
{Index -   ᨢ PackRatings}
{SrcIndex - ᬥ饭 砫 ᫥⥫쭮 ⭮⥫쭮 ⥪饣 }
Procedure TryAllMethods(Index:word;SrcIndex:word);
var
  i:byte;
begin
  for i:=1 to MaxMethods do
    CallMethod(i,Index,SrcIndex);
end;

begin
{ ஢  室 ଠ}
  if isColumns then
    begin
      ConvertToColumns(ZXScreen,ZXScr,x,y,xs,ys);
      if isPrev then
        ConvertToColumns(ZXPrevScreen,ZXPrev,x,y,xs,ys);
    end
  else
    begin
      ConvertToLines(ZXScreen,ZXScr,x,y,xs,ys);
      if isPrev then
        ConvertToLines(ZXPrevScreen,ZXPrev,x,y,xs,ys);
    end;
{樠 ६}
  TotalSize:=xs*ys;
  if PlayerType=ptLaced then
    TotalSize:=TotalSize div 2;
  SrcPtr:=0;
  DestPtr:=0;
  SequenceIndex:=0;
  isSequence:=false;
  repeat
    MaxRatio:=1;
    UnpSz:=0;
    MethodID:=0;
    Index:=0;
    if not isSequence then
    begin
      SequenceIndex:=0;
      isSequence:=false;
    end;
    CheckKeyboard;
    for i:=0 to MaxForwardLook-1 do
    begin
      TryAllMethods(i,SequenceIndex+i);
      for j:=1 to MaxMethods do
      begin
        ConvertSize(i,qSequence,QBytes,Data);
{室 㬬 ᯠ  ⥪饩 ᫥⥫쭮  ⥪饩 byte sequence}
        u:=PackRatings[i,j].UnpackedSize+i;
{室 㬬 㯠 ...}
        p:=PackRatings[i,j].PackedSize+(QBytes+i);
{⠥ 騩 Ratio   ᫥⥫쭮⥩}
        if p<>0 then
          r:=u/p
        else
          r:=0;
{᫨ ratio ⥪饣 ⮤ ࠢ ⥪饬 ᨬ쭮 ratio,  墠뢠}
{訩 ࠧ  -  ६  ⮤}
        if (r=MaxRatio) and
           (u>UnpSz) then
          begin
            MaxRatio:=r;
            UnpSz:=u;
            MethodID:=j;
            Index:=i;
          end
        else
{᫨ ratio ⥪饣 ⮤  ⥪饣 ᨬ쭮 ratio -  ६  ⮤}
          if r>=MaxRatio then
            begin
              MaxRatio:=r;
              UnpSz:=u;
              MethodID:=j;
              Index:=i;
            end;
      end;
    end;
    if Index<>0 then
    begin
      isSequence:=true;
      Inc(SequenceIndex,Index);
    end;
    if MethodID<>0 then
{襫 ⮤ 㯠 ⮩ ᫥⥫쭮  樥⮬ 㯠 >=1}
      begin
        CompleteSequence;
        CallMethod(MethodID,Index,SequenceIndex);
        for i:=0 to PackRatings[Index,MethodID].PackedSize-1 do
        begin
          OutArray^[DestPtr]:=TempBuf[i];
          inc(DestPtr);
        end;
        Inc(SrcPtr,PackRatings[Index,MethodID].UnpackedSize);
        Inc(SrcPtr,SequenceIndex);
        SequenceIndex:=0;
        isSequence:=false;
      end
    else
      begin
        isSequence:=true;
        inc(SequenceIndex,MaxForwardLook);
      end;
  until (SrcPtr+SequenceIndex)>=TotalSize;
  CompleteSequence;
  Inc(SrcPtr,SequenceIndex);
  StoreByte(OutArray,DestPtr,bEnd);
  PackFrame:=DestPtr;
end;

Procedure CreateFlagsByte(ID:string;var Flags:byte);
begin
  Flags:=0;
  case PlayerType of
    ptNormal: Flags:=Flags or flg_ptNormal;
    ptLaced : Flags:=Flags or flg_ptLaced;
    ptC64   : Flags:=Flags or flg_ptC64;
  end;
  if isColumn then
    Flags:=Flags or flg_Columns;
  if ID=ZXA_ID then
    if not isPrev then
      Flags:=Flags or flg_Independent;
end;

{뢮 ।०  ࠭祭  ᯮ짮 interlaced ⮤}
Procedure LacedWarning(str:string);
begin
  if not WasLacedWarnings then
  begin
    writeln('Interlaced player warnings:');
    WasLacedWarnings:=true;
  end;
  writeln(' - ',str);
end;

{뢮 ।०  ࠭祭  ᯮ짮 C64 like ⮤}
Procedure C64Warning(str:string);
begin
  if not WasC64Warnings then
  begin
    writeln('C64 like player warnings:');
    WasC64Warnings:=true;
  end;
  writeln(' - ',str);
end;

Procedure InitMem;
begin
  GetMem(OutArray,SizeOf(OutArray^));
  GetMem(FNameArray,SizeOf(FNameArray^));
  GetMem(Spr,255*192);
  CreateScreen(Buf);
  CreateSpeccyScreen(ZXScreen);
  CreateSpeccyScreen(ZXPrevScreen);
  CreateSpeccyScreen(ZXScr);
  CreateSpeccyScreen(ZXPrev);
  InitCLParser;

  FName:='';
  x:=0;
  y:=0;
  xs:=32;
  ys:=24*8;
  XOffset:=0;
  YOffset:=0;
  PlayerType:=ptNormal;
  SaveEach:=false;
  isPrev:=false;
  isColumn:=true;
  isInvert:=false;
  isRemap:=false;
  isScale:=false;
  isSave:=false;
  isSingle:=false;
  SaveType:=ft_SCR;
  WriteStat:=false;
  useStartScreen:=false;
  TempCreated:=false;
end;

Procedure DoneMem;far;
var
  f:file;
begin
  if TempCreated then
  begin
    close(f_tmp);
    Erase(f_tmp);
  end;
  DoneCLParser;
  DestroySpeccyScreen(ZXPrev);
  DestroySpeccyScreen(ZXScr);
  DestroySpeccyScreen(ZXPrevScreen);
  DestroySpeccyScreen(ZXScreen);
  DestroyScreen(Buf);
  FreeMem(Spr,255*192);
  FreeMem(FNameArray,SizeOf(FNameArray^));
  FreeMem(OutArray,SizeOf(OutArray^));
end;

BEGIN
  InitMem;
  DoneMemProc:=DoneMem;
  if CLParam^.GetParamCount=0 then
  begin
    writeln('ZX animation packer v3.00');
    writeln('Special edition for Scenergy #2 disk magazine.');
    writeln('(c) 13.12.1999 by Flying/Digital Reality. Special thanks to Dmitry Pjankov.');
    writeln('Usage: ZXA_PACK <Filename> [Output Filename] [Parameters]');
    writeln('<Filename> - text file with animation frames filenames, or');
    writeln('             file name of file into supported format to pack.');
    writeln('PCX (256 colors), SCR and Hobeta screen files are supported.');
    writeln;
    writeln('Parameters: /|-<key>[:<value>]');
    writeln(' X - set animation window X position     Y - set animation window Y position');
    writeln('XS - set animation window X size        YS - set animation window Y size');
    writeln('OX - set animation window X offset      OY - set animation window Y offset');
    writeln(' L - pack frames for interlaced player   C - pack frames for C64-like player');
    writeln(' A - pack frames as animation, not as independent frames');
    writeln(' E - save each frame into different file (.zxf)');
    writeln(' S - use first image as start screen content, do not pack it as frame');
    writeln(' H - use horisontal screen coding (by lines)');
    writeln(' I - invert screens');
    writeln(' R - remap PCX screens to necessary palette');
    writeln('SC - scale frames to use with C64 packing method');
    writeln('ST - write packing statistic into .log file');
    writeln('SV - save unpacked frames (specify one of following formats: PCX, Hobeta, SCR)');
    halt(exit_Ok);
  end;
  ClrScr;
  with CLParam^ do
  begin
    if isParamExist(1) and not isKey(1) then
      GetStringParamNum(1,FName);
    if isKeyExist('OX') then
      GetByteParamKey('OX',XOffset);
    if isKeyExist('OY') then
      GetByteParamKey('OY',YOffset);
    if isKeyExist('A') then
      isPrev:=true;
    if isKeyExist('L') then
      PlayerType:=ptLaced;
    if isKeyExist('C') then
      PlayerType:=ptC64;
    if isKeyExist('E') then
      SaveEach:=true;
    if isKeyExist('S') then
      useStartScreen:=true;
    if isKeyExist('H') then
      isColumn:=false;
    if isKeyExist('I') then
      isInvert:=true;
    if isKeyExist('R') then
      isRemap:=true;
    if isKeyExist('SC') then
    begin
      if (PlayerType=ptC64) then
        isScale:=true
      else
        begin
          writeln('Warning: frames scaling can be used only for C64-like player.');
          isScale:=false;
        end;
    end;
    if isKeyExist('ST') then
      WriteStat:=true;
    if isKeyExist('SV') then
    begin
      GetStringParamKey('SV',s1);
      s:=StrUpCase(s1);
      SaveType:=ft_Invalid;
      if s[1]='P' then
        SaveType:=ft_PCX;
      if s[1]='S' then
        SaveType:=ft_SCR;
      if s[1]='H' then
        SaveType:=ft_Hobeta;
      isSave:=true;
      if SaveType=ft_Invalid then
      begin
        writeln('Warning: format type ''',s1,''' specified into /SV key is not recognized!');
        writeln('         Frames saving disabled.');
        isSave:=false;
      end;
    end;
  end;
  if FName='' then
  begin
    ErrorMessage:='Frames list file or file to pack must be specified!';
    halt(exit_CustomError);
  end;
  FileType:=CheckScreen(FName);
  if FileType in [ft_PCX,ft_SCR,ft_Hobeta] then
    begin
      QFrames:=1;
      FNameArray^[0]:=FName;
      isSingle:=true;
      SaveEach:=true;
      isPrev:=false;
      useStartScreen:=false;
    end
  else
    begin
      Assign(ft,FName);
{$I-}
      reset(ft);
{$I+}
      if IOResult<>0 then
      begin
        ErrorMessage:=FName;
        halt(exit_ErrorOpenFile);
      end;
      QFrames:=0;
      repeat
        readln(ft,FNameArray^[QFrames]);
        inc(QFrames);
      until EoF(ft);
      if isPrev and useStartScreen then
        dec(QFrames);
      close(ft);
    end;
  writeln('Frames quantity: ',QFrames);
  write('Counting common bounding box...');
  if isPrev and useStartScreen then
    LoadScreen(FNameArray^[0],ZXScreen)
  else
    FillChar(ZXScreen^,SizeOf(ZXScreen^),0);
  Bounds.Empty:=true;
  for i:=0 to QFrames-1 do
  begin
    CheckKeyboard;
    if isPrev then
      begin
        if useStartScreen then
          k:=i+1
        else
          k:=i;
        Move(ZXScreen^,ZXPrevScreen^,SizeOf(ZXScreen^));
        LoadScreen(FNameArray^[k],ZXScreen);
        for j:=0 to SizeOf(ZXPrevScreen^)-1 do
          ZXPrevScreen^[j]:=ZXScreen^[j] xor ZXPrevScreen^[j];
        GetBoundingBox(ZXPrevScreen,BoundsArray[k]);
      end
    else
      begin
        LoadScreen(FNameArray^[i],ZXScreen);
        GetBoundingBox(ZXScreen,BoundsArray[i]);
      end;
    JoinBounds(BoundsArray[i],Bounds);
    GotoXY(33,WhereY);
    Write(RotateSym[(i and 3)+1]);
  end;
  GotoXY(33,WhereY);
  writeln('Done');
  writeln;
  isSave:=false;        { ⮣ ⮡  㦠  ன ࠧ}
  x:=Bounds.x1;
  y:=Bounds.y1;
  xs:=Bounds.x2-Bounds.x1+1;
  ys:=Bounds.y2-Bounds.y1+1;
  with CLParam^ do
  begin
    if isKeyExist('X') then
      GetByteParamKey('X',x);
    if isKeyExist('Y') then
      GetByteParamKey('Y',y);
    if isKeyExist('XS') then
      GetByteParamKey('XS',xs);
    if isKeyExist('YS') then
      GetByteParamKey('YS',ys);
  end;
  if xs=0 then
  begin
    ErrorMessage:='Invalid frame window X size!';
    halt(exit_CustomError);
  end;
  if ys=0 then
  begin
    ErrorMessage:='Invalid frame window Y size!';
    halt(exit_CustomError);
  end;
  if PlayerType=ptLaced then
  begin
    WasLacedWarnings:=false;
{  Y  뢮  interlaced player' 易  !}
    if (ys and 1)<>0 then
    begin
      LacedWarning('Frame window Y size must be even.');
      inc(ys);
    end;
    if WasLacedWarnings then
      writeln;
  end;
  if PlayerType=ptC64 then
  begin
    WasC64Warnings:=false;
{Y न  뢮  C64-like player' 易  ⭠ !}
    if (y and 7)<>0 then
    begin
      C64Warning('Frame window Y coordinate must be aligned to nearest cell.');
      y:=y and $F8;
    end;
{  Y  뢮  C64-like player' 易  ⥭ !}
    if (ys and 7)<>0 then
    begin
      C64Warning('Frame window Y size must be aligned to nearest cell size.');
      ys:=(ys and $F8)+8;
    end;
    if (xs>(32 div 2)) or (ys>((24 div 2)*8)) then
    begin
      C64Warning('Frame window size can''t be larger then 128x96 pixels.');
      xs:=32 div 2;
      ys:=(24 div 2)*8;
    end;
    if WasC64Warnings then
      writeln;
  end;
  Bounds.x1:=x;
  Bounds.y1:=y;
  Bounds.x2:=x+xs-1;
  Bounds.y2:=y+ys-1;
  writeln('X pos : ',Bounds.x1:3);
  writeln('Y pos : ',Bounds.y1:3);
  writeln('X size: ',(Bounds.x2-Bounds.x1+1):3,' (',Bounds.x2,')');
  writeln('Y size: ',(Bounds.y2-Bounds.y1+1):3,' (',Bounds.y2,')');
  writeln;
  if not SaveEach then
  begin
    Assign(f_tmp,'zxa_pack.tmp');
{$I-}
    rewrite(f_tmp,1);
{$I+}
    if IOResult<>0 then
    begin
      ErrorMessage:='Temporary file';
      halt(exit_ErrorOpenFile);
    end;
    TempCreated:=true;
  end;
  if isPrev and useStartScreen then
    LoadScreen(FNameArray^[0],ZXScreen)
  else
    FillChar(ZXScreen^,SizeOf(ZXScreen^),0);
  wx:=WhereX;
  wy:=WhereY;
  TotalUnpacked:=0;
  TotalPacked:=0;
  MaxFrameSize:=0;
  for i:=0 to QFrames-1 do
  begin
    CheckKeyboard;
    if isPrev and useStartScreen then
      k:=i+1
    else
      k:=i;
    if isPrev then
      begin
        Move(ZXScreen^,ZXPrevScreen^,SizeOf(ZXScreen^));
        LoadScreen(FNameArray^[k],ZXScreen);
        for j:=0 to SizeOf(ZXPrevScreen^)-1 do
          ZXPrevScreen^[j]:=ZXScreen^[j] xor ZXPrevScreen^[j];
        if BoundsArray[k].Empty then
          begin
            x:=0;
            y:=0;
            xs:=1;
            ys:=1;
          end
        else
          begin
            x:=BoundsArray[k].x1;
            y:=BoundsArray[k].y1;
            xs:=BoundsArray[k].x2-BoundsArray[k].x1+1;
            ys:=BoundsArray[k].y2-BoundsArray[k].y1+1;
          end;
      end
    else
      begin
        LoadScreen(FNameArray^[k],ZXScreen);
        x:=Bounds.x1;
        y:=Bounds.y1;
        xs:=Bounds.x2-Bounds.x1+1;
        ys:=Bounds.y2-Bounds.y1+1;
      end;
    PackedSize:=PackFrame(x+XOffset,y+YOffset,xs,ys,isPrev,isColumn);
    if PackedSize>MaxFrameSize then
      MaxFrameSize:=PackedSize;
    FramesPtrs[i]:=TotalPacked;
    TotalPacked:=TotalPacked+4; {4-ࠧ   (x,y,xs,ys)}
    TotalUnpacked:=TotalUnpacked+(xs*ys);
    TotalPacked:=TotalPacked+PackedSize;
    p:=(PackedSize/(xs*ys))*100;
    tp:=(TotalPacked/TotalUnpacked)*100;
    GotoXY(wx,wy);
    writeln('Process frame  : ',i+1,'   ');
    writeln('Unpacked size  : ',xs*ys,'   ');
    writeln('Packed size    : ',PackedSize,'   ');
    writeln('Percentage     : ',p:4:2,'%   ');
    writeln('Total unpacked : ',TotalUnpacked,'   ');
    writeln('Total packed   : ',TotalPacked,'   ');
    writeln('Total percent  : ',tp:4:2,'%   ');
    if SaveEach then
    begin
      FName:=FNameArray^[k];
      FSplit(FName,D,N,E);
      FName:=D+N+'.zxf';
      Assign(f_tmp,FName);
{$I-}
      rewrite(f_tmp,1);
{$I+}
      if IOResult<>0 then
      begin
        ErrorMessage:=FName;
        halt(exit_ErrorOpenFile);
      end;
    end;
    if PlayerType=ptLaced then
      ys:=ys div 2;
    if SaveEach then
    begin
{  .ZXF 䠩}
      s:=ZXF_ID;
      BlockWrite(f_tmp,s[1],byte(s[0]));
      b:=ZXF_Version;
      BlockWrite(f_tmp,b,sizeof(byte));
      CreateFlagsByte(s,b);
      BlockWrite(f_tmp,b,sizeof(byte));
    end;
    BlockWrite(f_tmp,x,sizeof(byte));
    BlockWrite(f_tmp,y,sizeof(byte));
    BlockWrite(f_tmp,xs,sizeof(byte));
    BlockWrite(f_tmp,ys,sizeof(byte));
{  }
    BlockWrite(f_tmp,OutArray^,PackedSize);
    if SaveEach then
      close(f_tmp);
  end;
  writeln('Max. frame size: ',MaxFrameSize);
  if not SaveEach then
  begin
    close(f_tmp);
    writeln;
    write('Writing... ');
    with CLParam^ do
    begin
      if isParamExist(2) and not isKey(2) then
        GetStringParamNum(2,FName)
      else
        begin
          FSplit(FName,D,N,E);
          FName:=D+N+'.zxa';
        end;
    end;
    Assign(f,FName);
{$I-}
    rewrite(f,1);
{$I+}
    if IOResult<>0 then
    begin
      ErrorMessage:=FName;
      halt(exit_ErrorOpenFile);
    end;
{  .ZXA 䠩}
    s:=ZXA_ID;
    BlockWrite(f,s[1],byte(s[0]));
    b:=ZXA_Version;
    BlockWrite(f,b,sizeof(byte));
    BlockWrite(f,QFrames,sizeof(byte));
    CreateFlagsByte(s,b);
    BlockWrite(f,b,sizeof(byte));
    for i:=0 to QFrames-1 do
      BlockWrite(f,FramesPtrs[i],sizeof(word));
{஢    .ZXA 䠩}
{$I-}
    reset(f_tmp,1);
{$I+}
    if IOResult<>0 then
    begin
      ErrorMessage:='Temporary file';
      halt(exit_ErrorOpenFile);
    end;
    repeat
      BlockRead(f_tmp,Buf^,SizeOf(Buf^),sz);
      BlockWrite(f,Buf^,sz);
    until EoF(f_tmp);
    close(f);
    close(f_tmp);
    Erase(f_tmp);
    TempCreated:=false;
    writeln('Done');
  end;
{ ᪨   .log 䠩}
  if WriteStat then
  begin
    with CLParam^ do
    begin
      if isParamExist(2) and not isKey(2) then
        GetStringParamNum(2,FName)
      else
        GetStringParamNum(1,FName);
    end;
    FSplit(FName,D,N,E);
    FName:=D+N+'.log';
    Assign(ft,FName);
{$I-}
    rewrite(ft);
{$I+}
    if IOResult<>0 then
    begin
      ErrorMessage:=FName;
      halt(exit_ErrorOpenFile);
    end;
    writeln(ft,'Common bounding box:');
    writeln(ft,'X pos : ',Bounds.x1:3);
    writeln(ft,'Y pos : ',Bounds.y1:3);
    writeln(ft,'X size: ',(Bounds.x2-Bounds.x1+1):3);
    writeln(ft,'Y size: ',(Bounds.y2-Bounds.y1+1):3);
    writeln(ft,'Top-left corner    : (',Bounds.x1:3,',',Bounds.y1:3,')');
    writeln(ft,'Bottom-right corner: (',Bounds.x2:3,',',Bounds.y2:3,')');
    writeln(ft,'');
    writeln(ft,'Total frames   : ',QFrames);
    writeln(ft,'Total unpacked : ',TotalUnpacked);
    writeln(ft,'Total packed   : ',TotalPacked);
    writeln(ft,'Total percent  : ',tp:4:2,'%');
    writeln(ft,'Max. frame size: ',MaxFrameSize);
    close(ft);
  end;
END.
