{Speccy screens, sprites and Hobeta files handling.                          }
{v2.2.1 (c) 18.08.2000 by Flying/Digital Reality                             }
Unit Speccy;

Interface

Type
  PSpeccyScreen = ^TSpeccyScreen;
  TSpeccyScreen = array [0..6911] of byte;

{ 뢮 PC-ࠩ  ᯥ㬮᪨ ࠭}
  TPutSpriteModes = (psmNormal,psmAND,psmOR,psmXOR);

Const
  HobetaHeaderSize = 17;

Type
  THobetaHeader = array [0..HobetaHeaderSize-1] of byte;

{p  Hobeta-䠩}
  THobetaInfo = record
    Name     : string[8];
    Ext      : char;
    Start    : word;
    Length   : word;
    QSectors : byte;
    CheckSum : word;
  end;

Const
  Bits : array [0..7] of byte =
    ($80,$40,$20,$10,$08,$04,$02,$01);

  BitMask : array [0..7] of byte =
    ($7F,$BF,$DF,$EF,$F7,$FB,$FD,$FE);

  SpeccyPalette : array [0..15,1..3] of byte =
   (($00,$00,$00),
    ($00,$00,$30),
    ($30,$00,$00),
    ($30,$00,$30),
    ($00,$30,$00),
    ($00,$30,$30),
    ($30,$30,$00),
    ($30,$30,$30),
    ($0F,$0F,$0F),
    ($00,$00,$3F),
    ($3F,$00,$00),
    ($3F,$00,$3F),
    ($00,$3F,$00),
    ($00,$3F,$3F),
    ($3F,$3F,$00),
    ($3F,$3F,$3F));

{ ᯥ㬮᪮ ࠭}
Procedure CreateSpeccyScreen(var Scr:PSpeccyScreen);
{⮦ ᯥ㬮᪮ ࠭}
Procedure DestroySpeccyScreen(Scr:PSpeccyScreen);
{⠭ ⥪騩 ᯥ㬮᪨ ࠭}
Procedure SetSpeccyScreen(Scr:PSpeccyScreen);
{⠭  16 梥⮢   ᮮ⢥⢨  梥⠬ Speccy}
Procedure SetSpeccyPalette;
{頥 ⥪騩 "ᯥ㬮᪨" ࠭  ⠭ Attr ਡ}
Procedure ClearSpeccyScreen(Attr:byte);
{뢮 ⥪騩 ᯥ㬮᪨ ࠭   PC-࠭}
Procedure ViewSpeccyScreen(PCScreen:word;X,Y:byte);
{뢠 ࠩ  ᯥ㬮᪮ ࠭   }
Procedure GetSpeccySprite(Sprite:pointer;X,Y,XS,YS:byte;Attr:boolean);
{뢮  ࠩ  ᯥ㬮᪨ ࠭}
Procedure PutSpeccySprite(Sprite:pointer;X,Y,XS,YS:byte;Attr:boolean);
{뢠 PC ࠩ  ᯥ㬮᪮ ࠭   }
{ 筮  ᥫ}
Procedure GetPCSprite(PCSprite:pointer;X,Y,XS,YS:byte);
{뢮  PC ࠩ  ᯥ㬮᪨ ࠭  筮  ᥫ}
{ࠩ  梥⭮, ਭ : 0 -  窨,  0 -  窠}
Procedure PutPCSprite(PCSprite:pointer;X,Y,XS,YS:byte;Mode:TPutSpriteModes);
{  न⠬ 頥 ᮮ⢥騩  }
{ᯥ㬮᪮ ࠭}
Function  GetScreenAddress(X,Y:byte):word;
{  न⠬ 頥 ᮮ⢥騩  }
{ᯥ㬮᪨ ਡ}
Function  GetAttrAddress(X,Y:byte):word;
{p頥 p  Hobeta-䠩}
{p頥 False ᫨  䠩 -  Hobeta-䠩}
Function  GetHobetaInfo(Name:string;var Info:THobetaInfo):boolean;
Function  ReadHobetaFile(Name:string;Buf:pointer):boolean;
Procedure WriteHobetaFile(Name:string;Info:THobetaInfo;Buf:pointer;Size:word);
Procedure HobetaInfo2Header(Info:THobetaInfo;var Header:THobetaHeader);
Procedure HobetaHeader2Info(Header:THobetaHeader;var Info:THobetaInfo);

Var
  SpeccyScreen:word;
  Enable_BlackBright:boolean;   {蠥 ᮢ black+bright}
                                { ⤥쭮 梥}
Implementation

Uses
  Memory,
  ExitUnit,
  Video;

Var
  Hdr:THobetaHeader;

Procedure CreateSpeccyScreen(var Scr:PSpeccyScreen);
var
  Buf:word;
begin
  Scr:=MemAllocSeg(SizeOf(TSpeccyScreen));
  if Scr=nil then halt(exit_NoMemory);
  SetSpeccyScreen(Scr);
  ClearSpeccyScreen($47);
end;

Procedure DestroySpeccyScreen(Scr:PSpeccyScreen);
begin
  FreeMem(Scr,SizeOf(TSpeccyScreen));
end;

Procedure SetSpeccyScreen(Scr:PSpeccyScreen);
begin
  SpeccyScreen:=Seg(Scr^);
end;

Procedure SetSpeccyPalette;
var
  i:byte;
begin
  for i:=0 to 15 do
    SetPaletteItem(i,SpeccyPalette[i,1],
                     SpeccyPalette[i,2],
                     SpeccyPalette[i,3]);
end;

Procedure ClearSpeccyScreen(Attr:byte);
begin
  FillChar(Mem[SpeccyScreen:0],$1800,0);
  FillChar(Mem[SpeccyScreen:$1800],$300,Attr);
end;

Procedure ViewSpeccyScreen(PCScreen:word;X,Y:byte);
var
  Adr:word;
  BlackBright:boolean;
begin
  Adr:=X_Res*Y+X;
  BlackBright:=Enable_BlackBright;
  asm
    push ds
    xor si,si
    mov di,Adr
    mov ax,PCScreen
    mov es,ax
    mov ax,SpeccyScreen
    mov ds,ax
    mov ch,$C0
@@Loop1:
    push si
    mov cl,$20
@@Loop2:
    mov bx,si
    shr bh,3
    and bh,3
    mov al,[bx+$1800]
    mov ah,al
    mov bh,al
    and bh,$40
    shr bh,3
    mov bl,bh
    and al,7
    or bl,al
    shr ah,3
    and ah,7
    or bh,ah
    mov ah,BlackBright
    or ah,ah
    jnz @@2
    cmp bh,8            {Black paper with bright}
    jnz @@1
    xor bh,bh
@@1:
    cmp bl,8            {Black ink with bright}
    jnz @@2
    xor bl,bl
@@2:
    mov ah,8
    lodsb
@@Loop3:
    rol al,1
    jnc @@PaperColor
    mov es:[di],bl
    jmp @@NextBit
@@PaperColor:
    mov es:[di],bh
@@NextBit:
    inc di
    dec ah
    jnz @@Loop3
    dec cl
    jnz @@Loop2
    add di,X_Res-$100
    pop dx
    inc dh
    mov al,dh
    and al,7
    jnz @@NextLine
    add dl,$20
    jc @@NextLine
    sub dh,8
@@NextLine:
    mov si,dx
    dec ch
    jnz @@Loop1
    pop ds
  end;
end;

Procedure GetSpeccySprite(Sprite:pointer;X,Y,XS,YS:byte;Attr:boolean);
var
  Adr,Atr:word;
begin
  Adr:=GetScreenAddress(X,Y*8);
  Atr:=GetAttrAddress(X,Y);
  asm
    push ds
    mov si,Adr
    mov ax,Atr
    push ax
    mov bh,YS
    mov dh,Attr
    mov dl,XS
    push bx
    push dx
    shl bh,3
    les di,Sprite
    mov ax,SpeccyScreen
    mov ds,ax
@@Loop1:
    push si
    mov cl,dl
    xor ch,ch
    rep movsb
    pop cx
    inc ch
    mov al,ch
    and al,7
    jnz @@NextLine
    add cl,$20
    jc @@NextLine
    sub ch,8
@@NextLine:
    mov si,cx
    dec bh
    jnz @@Loop1
    pop dx
    pop bx
    pop ax
    or dh,dh
    jz @@End
    mov si,ax
@@Loop2:
    push si
    mov cl,dl
    xor ch,ch
    rep movsb
    pop si
    add si,$20
    dec bh
    jnz @@Loop2
@@End:
    pop ds
  end;
end;

Procedure PutSpeccySprite(Sprite:pointer;X,Y,XS,YS:byte;Attr:boolean);
var
  Adr,Atr:word;
begin
  Adr:=GetScreenAddress(X,Y*8);
  Atr:=GetAttrAddress(X,Y);
  asm
    push ds
    mov di,Adr
    mov ax,Atr
    push ax
    mov bh,YS
    mov dh,Attr
    mov dl,XS
    push bx
    push dx
    shl bh,3
    mov ax,SpeccyScreen
    mov es,ax
    lds si,Sprite
@@Loop1:
    push di
    mov cl,dl
    xor ch,ch
    rep movsb
    pop cx
    inc ch
    mov al,ch
    and al,7
    jnz @@NextLine
    add cl,$20
    jc @@NextLine
    sub ch,8
@@NextLine:
    mov di,cx
    dec bh
    jnz @@Loop1
    pop dx
    pop bx
    pop ax
    or dh,dh
    jz @@End
    mov di,ax
@@Loop2:
    push di
    mov cl,dl
    xor ch,ch
    rep movsb
    pop di
    add di,$20
    dec bh
    jnz @@Loop2
@@End:
    pop ds
  end;
end;

Procedure GetPCSprite(PCSprite:pointer;X,Y,XS,YS:byte);
var
  Adr,Atr:word;
  PaperColor,InkColor:byte;
  b:byte;
  x1,y1:byte;
  cnt:byte;
  PCSeg:word;
  PCPtr:word;

Procedure InitVars;
begin
  Adr:=GetScreenAddress(X1 shr 3,Y1);
  Atr:=GetAttrAddress(X1 shr 3,Y1 shr 3);
  b:=Mem[SpeccyScreen:Adr];
  InkColor:=((Mem[SpeccyScreen:Atr] and $40) shr 3) or (Mem[SpeccyScreen:Atr] and 7);
  PaperColor:=(Mem[SpeccyScreen:Atr] and $78) shr 3;
  b:=b shl (X1 and 7);
end;

begin
  PCSeg:=Seg(PCSprite^);
  PCPtr:=word(PCSprite);
  for y1:=Y to Y+YS-1 do
  begin
    x1:=x;
    cnt:=xs;
    InitVars;
    repeat
      if (b and $80)=0 then
        Mem[PCSeg:PCPtr]:=PaperColor
      else
        Mem[PCSeg:PCPtr]:=InkColor;
      b:=b shl 1;
      inc(x1);
      dec(cnt);
      inc(PCPtr);
      if (X1 and 7)=0 then InitVars;
    until cnt=0;
  end;
end;

Procedure PutPCSprite(PCSprite:pointer;X,Y,XS,YS:byte;Mode:TPutSpriteModes);
var
  Adr:word;
  b:byte;
  x1,y1:byte;
  cnt:byte;
  PCSeg:word;
  PCPtr:word;
begin
  PCSeg:=Seg(PCSprite^);
  PCPtr:=word(PCSprite);
  for y1:=Y to Y+YS-1 do
  begin
    x1:=x;
    cnt:=xs;
    Adr:=GetScreenAddress(X1 shr 3,Y1);
    repeat
      case Mode of
        psmNormal:
          if Mem[PCSeg:PCPtr]<>0 then
            Mem[SpeccyScreen:Adr]:=Mem[SpeccyScreen:Adr] or Bits[x1 and 7]
          else
            Mem[SpeccyScreen:Adr]:=Mem[SpeccyScreen:Adr] and BitMask[x1 and 7];
        psmAND:
          if Mem[PCSeg:PCPtr]<>0 then
            Mem[SpeccyScreen:Adr]:=Mem[SpeccyScreen:Adr] and BitMask[x1 and 7];
        psmOR:
          if Mem[PCSeg:PCPtr]<>0 then
          Mem[SpeccyScreen:Adr]:=Mem[SpeccyScreen:Adr] or Bits[x1 and 7];
        psmXOR:
          if Mem[PCSeg:PCPtr]<>0 then
          Mem[SpeccyScreen:Adr]:=Mem[SpeccyScreen:Adr] xor Bits[x1 and 7];
      end;
      inc(x1);
      dec(cnt);
      inc(PCPtr);
      if (X1 and 7)=0 then Adr:=GetScreenAddress(X1 shr 3,Y1);;
    until cnt=0;
  end;
end;

Function GetScreenAddress(X,Y:byte):word;
var
  Addr:word;
begin
  asm
    mov al,Y
    and al,7
    mov bh,al
    mov al,Y
    shr al,3
    and al,$18
    or bh,al
    mov al,Y
    shl al,2
    and al,$E0
    mov bl,al
    mov al,X
    and al,$1F
    or bl,al
    mov Addr,bx
  end;
  GetScreenAddress:=Addr;
end;

Function GetAttrAddress(X,Y:byte):word;
var
  Addr:word;
begin
  Addr:=$1800+$20*Y+X;
  GetAttrAddress:=Addr;
end;

Function GetHobetaInfo(Name:string;var Info:THobetaInfo):boolean;
var
  f:file;
  _Info:THobetaInfo;
begin
  Assign(f,Name);
{$I-}
  reset(f,1);
{$I+}
  if IOResult<>exit_Ok then
  begin
    ErrorMessage:=Name;
    halt(exit_ErrorOpenFile);
  end;
  if FileSize(f)<SizeOf(Hdr) then
  begin
    GetHobetaInfo:=false;
    exit;
  end;
  BlockRead(f,Hdr,SizeOf(Hdr));
  Close(f);
  if Hdr[13]<>0 then
  begin
    GetHobetaInfo:=false;
    exit;
  end;
  HobetaHeader2Info(Hdr,_Info);
  if _Info.CheckSum<>Hdr[15]+$100*Hdr[16] then
  begin
    GetHobetaInfo:=false;
    exit;
  end;
  Move(_Info,Info,SizeOf(Info));
  GetHobetaInfo:=True;
end;

Function ReadHobetaFile(Name:string;Buf:pointer):boolean;
var
  Info:THobetaInfo;
  f:file;
begin
  if not GetHobetaInfo(Name,Info) then
  begin
    ReadHobetaFile:=false;
    exit;
  end;
  Assign(f,Name);
{$I-}
  reset(f,1);
{$I+}
  if IOResult<>exit_Ok then
  begin
    ErrorMessage:=Name;
    halt(exit_ErrorOpenFile);
  end;
  Seek(f,SizeOf(Hdr));
  blockread(f,Buf^,FileSize(f)-SizeOf(Hdr));
  close(f);
end;

Procedure WriteHobetaFile(Name:string;Info:THobetaInfo;Buf:pointer;Size:word);
var
  f:file;
  i:word;
  b:byte;
begin
  HobetaInfo2Header(Info,Hdr);
  Assign(f,Name);
{$I-}
  rewrite(f,1);
{$I+}
  if IOResult<>exit_Ok then
  begin
    ErrorMessage:=Name;
    halt(exit_ErrorOpenFile);
  end;
  BlockWrite(f,Hdr,SizeOf(Hdr));
  BlockWrite(f,Buf^,Size);
  b:=0;
  if Lo(Size)<>0 then
    for i:=1 to $100-Lo(Size) do
      BlockWrite(f,b,1);
  close(f);
end;

Procedure HobetaInfo2Header(Info:THobetaInfo;var Header:THobetaHeader);
var
  w:word;
begin
  with Info do
  begin
    FillChar(Hdr[0],8,' ');
    Move(Name[1],Hdr[0],byte(Name[0]));
    Hdr[8]:=byte(Ext);
    Hdr[9]:=Lo(Start);
    Hdr[10]:=Hi(Start);
    Hdr[11]:=Lo(Length);
    Hdr[12]:=Hi(Length);
    Hdr[13]:=0;
    Hdr[14]:=Hi(Length);
    if Lo(Length)<>0 then inc(Hdr[14]);
    asm
      mov si,Offset(Hdr)
      xor bx,bx
      mov cx,15
@1:   add bl,ds:[si]
      jnc @2
      inc bh
@2:   inc si
      loop @1
      add bh,bl
      add bx,105
      mov w,bx
    end;
    Hdr[15]:=Lo(w);
    Hdr[16]:=Hi(w);
  end;
  Header:=Hdr;
end;

Procedure HobetaHeader2Info(Header:THobetaHeader;var Info:THobetaInfo);
var
  w:word;
begin
  Hdr:=Header;
  asm
    mov si,Offset(Hdr)
    xor bx,bx
    mov cx,15
@1: add bl,ds:[si]
    jnc @2
    inc bh
@2: inc si
    loop @1
    add bh,bl
    add bx,105
    mov w,bx
  end;
  with Info do
  begin
    byte(Name[0]):=8;
    Move(Hdr[0],Name[1],8);
    Ext:=char(Hdr[8]);
    Start:=Hdr[9]+$100*Hdr[10];
    Length:=Hdr[11]+$100*Hdr[12];
    QSectors:=Hdr[14];
    CheckSum:=w;
  end;
end;

BEGIN
  Enable_BlackBright:=false;
END.
