/*

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

*/

#include "opcodes.h"

const unsigned char c65816[]=
    // 1   2     3           4     5           6     7     8                  9    10          11                12                13
    //                 14                15                      16   17                18            19   20          21    22          23  24
    //     a     #b    $l    $w    $b    $l,x  $w,x  $b,x  $w,x) $b,x) $b,s $b,s),y $l,y $w,y $b,y [$b],y ($b),y [$w] [$b]  ($w)  ($b)  +$w   +$b  $b,$b
{
    ____, ____, 0x69, 0x6F, 0x6D, 0x65, 0x7F, 0x7D, 0x75, ____, 0x61, 0x63, 0x73, ____, 0x79, ____, 0x77, 0x71, ____, 0x67, ____, 0x72, ____, ____, ____, //ADC
    ____, ____, 0x29, 0x2F, 0x2D, 0x25, 0x3F, 0x3D, 0x35, ____, 0x21, 0x23, 0x33, ____, 0x39, ____, 0x37, 0x31, ____, 0x27, ____, 0x32, ____, ____, ____, //AND
    0x0A, 0x0A, ____, ____, 0x0E, 0x06, ____, 0x1E, 0x16, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, //ASL
    ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, 0x90, ____, //BCC
    ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, 0xB0, ____, //BCS
    ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, 0xF0, ____, //BEQ
    ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, 0xB0, ____, //BGE (BCS)
    ____, ____, 0x89, ____, 0x2C, 0x24, ____, 0x3C, 0x34, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, //BIT
    ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, 0x90, ____, //BLT (BCC)
    ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, 0x30, ____, //BMI
    ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, 0xD0, ____, //BNE
    ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, 0x10, ____, //BPL
    ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, 0x80, ____, //BRA
    0x00, ____, 0x00, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, //BRK
    ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, 0x82, ____, ____, //BRL
    ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, 0x50, ____, //BVC
    ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, 0x70, ____, //BVS
    0x18, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, //CLC
    0xD8, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, //CLD
    0x58, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, //CLI
    0xB8, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, //CLV
    //     a     #b    $l    $w    $b    $l,x  $w,x  $b,x  $w,x) $b,x) $b,s $b,s),y $l,y $w,y $b,y [$b],y ($b),y [$w] [$b]  ($w)  ($b)  +$w   +$b  $b,$b
    ____, ____, 0xC9, 0xCF, 0xCD, 0xC5, 0xDF, 0xDD, 0xD5, ____, 0xC1, 0xC3, 0xD3, ____, 0xD9, ____, 0xD7, 0xD1, ____, 0xC7, ____, 0xD2, ____, ____, ____, //CMP
    0x02, ____, 0x02, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, //COP
    ____, ____, 0xE0, ____, 0xEC, 0xE4, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, //CPX
    ____, ____, 0xC0, ____, 0xCC, 0xC4, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, //CPY
    0x3A, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, //DEA (DEC A)
    ____, 0x3A, ____, ____, 0xCE, 0xC6, ____, 0xDE, 0xD6, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, //DEC
    0xCA, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, //DEX
    0x88, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, //DEY
    ____, ____, 0x49, 0x4F, 0x4D, 0x45, 0x5F, 0x5D, 0x55, ____, 0x41, 0x43, 0x53, ____, 0x59, ____, 0x57, 0x51, ____, 0x47, ____, 0x52, ____, ____, ____, //EOR
    ____, ____, ____, ____, 0x4C, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, 0x90, ____, //GCC
    ____, ____, ____, ____, 0x4C, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, 0xB0, ____, //GCS
    ____, ____, ____, ____, 0x4C, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, 0xF0, ____, //GEQ
    ____, ____, ____, ____, 0x4C, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, 0xB0, ____, //GGE (GCS)
    ____, ____, ____, ____, 0x4C, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, 0x90, ____, //GLT (GCC)
    ____, ____, ____, ____, 0x4C, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, 0x30, ____, //GMI
    ____, ____, ____, ____, 0x4C, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, 0xD0, ____, //GNE
    ____, ____, ____, ____, 0x4C, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, 0x10, ____, //GPL
    ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, 0x82, 0x80, ____, //GRA
    ____, ____, ____, ____, 0x4C, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, 0x50, ____, //GVC
    ____, ____, ____, ____, 0x4C, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, 0x70, ____, //GVS
    0x1A, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, //INA (INC A)
    ____, 0x1A, ____, ____, 0xEE, 0xE6, ____, 0xFE, 0xF6, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, //INC
    0xE8, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, //INX
    0xC8, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, //INY
    ____, ____, ____, 0x5C, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, 0xDC, ____, ____, ____, ____, ____, ____, //JML (JMP)
    ____, ____, ____, 0x5C, 0x4C, ____, ____, ____, ____, 0x7C, ____, ____, ____, ____, ____, ____, ____, ____, 0xDC, ____, 0x6C, ____, ____, ____, ____, //JMP
    ____, ____, ____, 0x22, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, //JSL (JSR)
    ____, ____, ____, 0x22, 0x20, ____, ____, ____, ____, 0xFC, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, //JSR
    ____, ____, 0xA9, 0xAF, 0xAD, 0xA5, 0xBF, 0xBD, 0xB5, ____, 0xA1, 0xA3, 0xB3, ____, 0xB9, ____, 0xB7, 0xB1, ____, 0xA7, ____, 0xB2, ____, ____, ____, //LDA
    ____, ____, 0xA2, ____, 0xAE, 0xA6, ____, ____, ____, ____, ____, ____, ____, ____, 0xBE, 0xB6, ____, ____, ____, ____, ____, ____, ____, ____, ____, //LDX
    ____, ____, 0xA0, ____, 0xAC, 0xA4, ____, 0xBC, 0xB4, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, //LDY
    0x4A, 0x4A, ____, ____, 0x4E, 0x46, ____, 0x5E, 0x56, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, //LSR
    ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, 0x54, //MVN
    //     a     #b    $l    $w    $b    $l,x  $w,x  $b,x  $w,x) $b,x) $b,s $b,s),y $l,y $w,y $b,y [$b],y ($b),y [$w] [$b]  ($w)  ($b)  +$w   +$b  $b,$b
    ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, 0x44, //MVP
    0xEA, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, //NOP
    ____, ____, 0x09, 0x0F, 0x0D, 0x05, 0x1F, 0x1D, 0x15, ____, 0x01, 0x03, 0x13, ____, 0x19, ____, 0x17, 0x11, ____, 0x07, ____, 0x12, ____, ____, ____, //ORA
    ____, ____, ____, ____, 0xF4, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, //PEA
    ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, 0xD4, ____, ____, ____, //PEI
    ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, 0x62, ____, ____, //PER
    0x48, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, //PHA
    0x8B, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, //PHB
    0x0B, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, //PHD
    0x4B, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, //PHK
    0x08, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, //PHP
    0xDA, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, //PHX
    0x5A, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, //PHY
    0x68, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, //PLA
    0xAB, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, //PLB
    0x2B, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, //PLD
    0x28, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, //PLP
    0xFA, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, //PLX
    0x7A, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, //PLY
    ____, ____, 0xC2, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, //REP
    0x2A, 0x2A, ____, ____, 0x2E, 0x26, ____, 0x3E, 0x36, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, //ROL
    0x6A, 0x6A, ____, ____, 0x6E, 0x66, ____, 0x7E, 0x76, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, //ROR
    //     a     #b    $l    $w    $b    $l,x  $w,x  $b,x  $w,x) $b,x) $b,s $b,s),y $l,y $w,y $b,y [$b],y ($b),y [$w] [$b]  ($w)  ($b)  +$w   +$b  $b,$b
    0x40, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, //RTI
    0x6B, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, //RTL
    0x60, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, //RTS
    ____, ____, 0xE9, 0xEF, 0xED, 0xE5, 0xFF, 0xFD, 0xF5, ____, 0xE1, 0xE3, 0xF3, ____, 0xF9, ____, 0xF7, 0xF1, ____, 0xE7, ____, 0xF2, ____, ____, ____, //SBC
    0x38, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, //SEC
    0xF8, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, //SED
    0x78, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, //SEI
    ____, ____, 0xE2, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, //SEP
    ____, ____, ____, 0x8F, 0x8D, 0x85, 0x9F, 0x9D, 0x95, ____, 0x81, 0x83, 0x93, ____, 0x99, ____, 0x97, 0x91, ____, 0x87, ____, 0x92, ____, ____, ____, //STA
    0xDB, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, //STP
    ____, ____, ____, ____, 0x8E, 0x86, ____, ____, ____, ____, ____, ____, ____, ____, ____, 0x96, ____, ____, ____, ____, ____, ____, ____, ____, ____, //STX
    ____, ____, ____, ____, 0x8C, 0x84, ____, ____, 0x94, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, //STY
    ____, ____, ____, ____, 0x9C, 0x64, ____, 0x9E, 0x74, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, //STZ
    0xEB, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, //SWA (XBA)
    0x5B, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, //TAD (TCD)
    0x1B, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, //TAS (TCS)
    0xAA, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, //TAX
    0xA8, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, //TAY
    0x5B, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, //TCD
    0x1B, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, //TCS
    0x7B, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, //TDA (TDC)
    0x7B, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, //TDC
    //     a     #b    $l    $w    $b    $l,x  $w,x  $b,x  $w,x) $b,x) $b,s $b,s),y $l,y $w,y $b,y [$b],y ($b),y [$w] [$b]  ($w)  ($b)  +$w   +$b  $b,$b
    ____, ____, ____, ____, 0x1C, 0x14, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, //TRB
    0x3B, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, //TSA (TSC)
    ____, ____, ____, ____, 0x0C, 0x04, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, //TSB
    0x3B, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, //TSC
    0xBA, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, //TSX
    0x8A, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, //TXA
    0x9A, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, //TXS
    0x9B, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, //TXY
    0x98, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, //TYA
    0xBB, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, //TYX
    0xCB, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, //WAI
    0xEB, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, //XBA
    0xFB, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____};//XCE

const unsigned char c6502[]=
    // 1   2     3           4     5           6     7     8                  9    10          11                12                13
    //                 14                15                      16   17                18            19   20          21    22          23  24
    //     a     #b    $l    $w    $b    $l,x  $w,x  $b,x  $w,x) $b,x) $b,s $b,s),y $l,y $w,y $b,y [$b],y ($b),y [$w] [$b]  ($w)  ($b)  +$w   +$b  $b,$b
{
    ____, ____, 0x69, ____, 0x6D, 0x65, ____, 0x7D, 0x75, ____, 0x61, ____, ____, ____, 0x79, ____, ____, 0x71, ____, ____, ____, ____, ____, ____, ____, //ADC
    ____, ____, 0x29, ____, 0x2D, 0x25, ____, 0x3D, 0x35, ____, 0x21, ____, ____, ____, 0x39, ____, ____, 0x31, ____, ____, ____, ____, ____, ____, ____, //AND
    0x0A, 0x0A, ____, ____, 0x0E, 0x06, ____, 0x1E, 0x16, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, //ASL
    ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, 0x90, ____, //BCC
    ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, 0xB0, ____, //BCS
    ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, 0xF0, ____, //BEQ
    ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, 0xB0, ____, //BGE (BCS)
    ____, ____, ____, ____, 0x2C, 0x24, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, //BIT
    ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, 0x90, ____, //BLT (BCC)
    ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, 0x30, ____, //BMI
    ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, 0xD0, ____, //BNE
    ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, 0x10, ____, //BPL
    0x00, ____, 0x00, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, //BRK
    ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, 0x50, ____, //BVC
    ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, 0x70, ____, //BVS
    0x18, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, //CLC
    0xD8, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, //CLD
    0x58, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, //CLI
    0xB8, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, //CLV
    ____, ____, 0xC9, ____, 0xCD, 0xC5, ____, 0xDD, 0xD5, ____, 0xC1, ____, ____, ____, 0xD9, ____, ____, 0xD1, ____, ____, ____, ____, ____, ____, ____, //CMP
    ____, ____, 0xE0, ____, 0xEC, 0xE4, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, //CPX
    //     a     #b    $l    $w    $b    $l,x  $w,x  $b,x  $w,x) $b,x) $b,s $b,s),y $l,y $w,y $b,y [$b],y ($b),y [$w] [$b]  ($w)  ($b)  +$w   +$b  $b,$b
    ____, ____, 0xC0, ____, 0xCC, 0xC4, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, //CPY
    ____, ____, ____, ____, 0xCE, 0xC6, ____, 0xDE, 0xD6, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, //DEC
    0xCA, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, //DEX
    0x88, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, //DEY
    ____, ____, 0x49, ____, 0x4D, 0x45, ____, 0x5D, 0x55, ____, 0x41, ____, ____, ____, 0x59, ____, ____, 0x51, ____, ____, ____, ____, ____, ____, ____, //EOR
    ____, ____, ____, ____, 0x4C, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, 0x90, ____, //GCC
    ____, ____, ____, ____, 0x4C, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, 0xB0, ____, //GCS
    ____, ____, ____, ____, 0x4C, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, 0xF0, ____, //GEQ
    ____, ____, ____, ____, 0x4C, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, 0xB0, ____, //GGE (GCS)
    ____, ____, ____, ____, 0x4C, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, 0x90, ____, //GLT (GCC)
    ____, ____, ____, ____, 0x4C, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, 0x30, ____, //GMI
    ____, ____, ____, ____, 0x4C, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, 0xD0, ____, //GNE
    ____, ____, ____, ____, 0x4C, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, 0x10, ____, //GPL
    ____, ____, ____, ____, 0x4C, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, 0x50, ____, //GVC
    ____, ____, ____, ____, 0x4C, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, 0x70, ____, //GVS
    ____, ____, ____, ____, 0xEE, 0xE6, ____, 0xFE, 0xF6, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, //INC
    0xE8, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, //INX
    0xC8, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, //INY
    ____, ____, ____, ____, 0x4C, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, 0x6C, ____, ____, ____, ____, //JMP
    ____, ____, ____, ____, 0x20, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, //JSR
    ____, ____, 0xA9, ____, 0xAD, 0xA5, ____, 0xBD, 0xB5, ____, 0xA1, ____, ____, ____, 0xB9, ____, ____, 0xB1, ____, ____, ____, ____, ____, ____, ____, //LDA
    ____, ____, 0xA2, ____, 0xAE, 0xA6, ____, ____, ____, ____, ____, ____, ____, ____, 0xBE, 0xB6, ____, ____, ____, ____, ____, ____, ____, ____, ____, //LDX
    ____, ____, 0xA0, ____, 0xAC, 0xA4, ____, 0xBC, 0xB4, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, //LDY
    0x4A, 0x4A, ____, ____, 0x4E, 0x46, ____, 0x5E, 0x56, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, //LSR
    0xEA, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, //NOP
    ____, ____, 0x09, ____, 0x0D, 0x05, ____, 0x1D, 0x15, ____, 0x01, ____, ____, ____, 0x19, ____, ____, 0x11, ____, ____, ____, ____, ____, ____, ____, //ORA
    0x48, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, //PHA
    0x08, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, //PHP
    0x68, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, //PLA
    0x28, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, //PLP
    0x2A, 0x2A, ____, ____, 0x2E, 0x26, ____, 0x3E, 0x36, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, //ROL
    0x6A, 0x6A, ____, ____, 0x6E, 0x66, ____, 0x7E, 0x76, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, //ROR
    //     a     #b    $l    $w    $b    $l,x  $w,x  $b,x  $w,x) $b,x) $b,s $b,s),y $l,y $w,y $b,y [$b],y ($b),y [$w] [$b]  ($w)  ($b)  +$w   +$b  $b,$b
    0x40, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, //RTI
    0x60, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, //RTS
    ____, ____, 0xE9, ____, 0xED, 0xE5, ____, 0xFD, 0xF5, ____, 0xE1, ____, ____, ____, 0xF9, ____, ____, 0xF1, ____, ____, ____, ____, ____, ____, ____, //SBC
    0x38, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, //SEC
    0xF8, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, //SED
    0x78, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, //SEI
    ____, ____, ____, ____, 0x8D, 0x85, ____, 0x9D, 0x95, ____, 0x81, ____, ____, ____, 0x99, ____, ____, 0x91, ____, ____, ____, ____, ____, ____, ____, //STA
    ____, ____, ____, ____, 0x8E, 0x86, ____, ____, ____, ____, ____, ____, ____, ____, ____, 0x96, ____, ____, ____, ____, ____, ____, ____, ____, ____, //STX
    ____, ____, ____, ____, 0x8C, 0x84, ____, ____, 0x94, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, //STY
    0xAA, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, //TAX
    0xA8, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, //TAY
    0xBA, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, //TSX
    0x8A, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, //TXA
    0x9A, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, //TXS
    0x98, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____};//TYA

const unsigned char c65c02[]=
    // 1   2     3           4     5           6     7     8                  9    10          11                12                13
    //                 14                15                      16   17                18            19   20          21    22          23  24
    //     a     #b    $l    $w    $b    $l,x  $w,x  $b,x  $w,x) $b,x) $b,s $b,s),y $l,y $w,y $b,y [$b],y ($b),y [$w] [$b]  ($w)  ($b)  +$w   +$b  $b,$b
{
    ____, ____, 0x69, ____, 0x6D, 0x65, ____, 0x7D, 0x75, ____, 0x61, ____, ____, ____, 0x79, ____, ____, 0x71, ____, ____, ____, 0x72, ____, ____, ____, //ADC
    ____, ____, 0x29, ____, 0x2D, 0x25, ____, 0x3D, 0x35, ____, 0x21, ____, ____, ____, 0x39, ____, ____, 0x31, ____, ____, ____, 0x32, ____, ____, ____, //AND
    0x0A, 0x0A, ____, ____, 0x0E, 0x06, ____, 0x1E, 0x16, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, //ASL
    ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, 0x90, ____, //BCC
    ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, 0xB0, ____, //BCS
    ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, 0xF0, ____, //BEQ
    ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, 0xB0, ____, //BGE (BCS)
    ____, ____, 0x89, ____, 0x2C, 0x24, ____, 0x3C, 0x34, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, //BIT
    ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, 0x90, ____, //BLT (BCC)
    ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, 0x30, ____, //BMI
    ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, 0xD0, ____, //BNE
    ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, 0x10, ____, //BPL
    ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, 0x80, ____, //BRA
    0x00, ____, 0x00, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, //BRK
    ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, 0x50, ____, //BVC
    ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, 0x70, ____, //BVS
    0x18, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, //CLC
    0xD8, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, //CLD
    0x58, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, //CLI
    0xB8, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, //CLV
    ____, ____, 0xC9, ____, 0xCD, 0xC5, ____, 0xDD, 0xD5, ____, 0xC1, ____, ____, ____, 0xD9, ____, ____, 0xD1, ____, ____, ____, 0xD2, ____, ____, ____, //CMP
    ____, ____, 0xE0, ____, 0xEC, 0xE4, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, //CPX
    //     a     #b    $l    $w    $b    $l,x  $w,x  $b,x  $w,x) $b,x) $b,s $b,s),y $l,y $w,y $b,y [$b],y ($b),y [$w] [$b]  ($w)  ($b)  +$w   +$b  $b,$b
    ____, ____, 0xC0, ____, 0xCC, 0xC4, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, //CPY
    0x3A, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, //DEA (DEC A)
    ____, 0x3A, ____, ____, 0xCE, 0xC6, ____, 0xDE, 0xD6, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, //DEC
    0xCA, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, //DEX
    0x88, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, //DEY
    ____, ____, 0x49, ____, 0x4D, 0x45, ____, 0x5D, 0x55, ____, 0x41, ____, ____, ____, 0x59, ____, ____, 0x51, ____, ____, ____, 0x52, ____, ____, ____, //EOR
    ____, ____, ____, ____, 0x4C, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, 0x90, ____, //GCC
    ____, ____, ____, ____, 0x4C, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, 0xB0, ____, //GCS
    ____, ____, ____, ____, 0x4C, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, 0xF0, ____, //GEQ
    ____, ____, ____, ____, 0x4C, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, 0xB0, ____, //GGE (GCS)
    ____, ____, ____, ____, 0x4C, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, 0x90, ____, //GLT (GCC)
    ____, ____, ____, ____, 0x4C, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, 0x30, ____, //GMI
    ____, ____, ____, ____, 0x4C, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, 0xD0, ____, //GNE
    ____, ____, ____, ____, 0x4C, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, 0x10, ____, //GPL
    ____, ____, ____, ____, 0x4C, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, 0x80, ____, //GRA
    ____, ____, ____, ____, 0x4C, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, 0x50, ____, //GVC
    ____, ____, ____, ____, 0x4C, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, 0x70, ____, //GVS
    0x1A, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, //INA (INC A)
    ____, 0x1A, ____, ____, 0xEE, 0xE6, ____, 0xFE, 0xF6, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, //INC
    0xE8, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, //INX
    0xC8, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, //INY
    ____, ____, ____, ____, 0x4C, ____, ____, ____, ____, 0x7C, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, 0x6C, ____, ____, ____, ____, //JMP
    ____, ____, ____, ____, 0x20, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, //JSR
    ____, ____, 0xA9, ____, 0xAD, 0xA5, ____, 0xBD, 0xB5, ____, 0xA1, ____, ____, ____, 0xB9, ____, ____, 0xB1, ____, ____, ____, 0xB2, ____, ____, ____, //LDA
    ____, ____, 0xA2, ____, 0xAE, 0xA6, ____, ____, ____, ____, ____, ____, ____, ____, 0xBE, 0xB6, ____, ____, ____, ____, ____, ____, ____, ____, ____, //LDX
    ____, ____, 0xA0, ____, 0xAC, 0xA4, ____, 0xBC, 0xB4, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, //LDY
    0x4A, 0x4A, ____, ____, 0x4E, 0x46, ____, 0x5E, 0x56, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, //LSR
    0xEA, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, //NOP
    ____, ____, 0x09, ____, 0x0D, 0x05, ____, 0x1D, 0x15, ____, 0x01, ____, ____, ____, 0x19, ____, ____, 0x11, ____, ____, ____, 0x12, ____, ____, ____, //ORA
    0x48, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, //PHA
    0x08, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, //PHP
    0xDA, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, //PHX
    0x5A, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, //PHY
    0x68, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, //PLA
    0x28, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, //PLP
    0xFA, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, //PLX
    0x7A, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, //PLY
    //     a     #b    $l    $w    $b    $l,x  $w,x  $b,x  $w,x) $b,x) $b,s $b,s),y $l,y $w,y $b,y [$b],y ($b),y [$w] [$b]  ($w)  ($b)  +$w   +$b  $b,$b
    0x2A, 0x2A, ____, ____, 0x2E, 0x26, ____, 0x3E, 0x36, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, //ROL
    0x6A, 0x6A, ____, ____, 0x6E, 0x66, ____, 0x7E, 0x76, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, //ROR
    0x40, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, //RTI
    0x60, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, //RTS
    ____, ____, 0xE9, ____, 0xED, 0xE5, ____, 0xFD, 0xF5, ____, 0xE1, ____, ____, ____, 0xF9, ____, ____, 0xF1, ____, ____, ____, 0xF2, ____, ____, ____, //SBC
    0x38, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, //SEC
    0xF8, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, //SED
    0x78, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, //SEI
    ____, ____, ____, ____, 0x8D, 0x85, ____, 0x9D, 0x95, ____, 0x81, ____, ____, ____, 0x99, ____, ____, 0x91, ____, ____, ____, 0x92, ____, ____, ____, //STA
    ____, ____, ____, ____, 0x8E, 0x86, ____, ____, ____, ____, ____, ____, ____, ____, ____, 0x96, ____, ____, ____, ____, ____, ____, ____, ____, ____, //STX
    ____, ____, ____, ____, 0x8C, 0x84, ____, ____, 0x94, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, //STY
    ____, ____, ____, ____, 0x9C, 0x64, ____, 0x9E, 0x74, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, //STZ
    0xAA, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, //TAX
    0xA8, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, //TAY
    ____, ____, ____, ____, 0x1C, 0x14, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, //TRB
    ____, ____, ____, ____, 0x0C, 0x04, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, //TSB
    0xBA, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, //TSX
    0x8A, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, //TXA
    0x9A, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, //TXS
    0x98, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____};//TYA

const unsigned char c6502i[]=
    // 1   2     3           4     5           6     7     8                  9    10          11                12                13
    //                 14                15                      16   17                18            19   20          21    22          23  24
    //     a     #b    $l    $w    $b    $l,x  $w,x  $b,x  $w,x) $b,x) $b,s $b,s),y $l,y $w,y $b,y [$b],y ($b),y [$w] [$b]  ($w)  ($b)  +$w   +$b  $b,$b
{
    ____, ____, 0x69, ____, 0x6D, 0x65, ____, 0x7D, 0x75, ____, 0x61, ____, ____, ____, 0x79, ____, ____, 0x71, ____, ____, ____, ____, ____, ____, ____, //ADC
    ____, ____, ____, ____, ____, ____, ____, 0x93, ____, ____, ____, ____, ____, ____, 0x9F, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, //AHX* (SHA)
    ____, ____, 0x4B, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, //ALR* (ASR)
    ____, ____, 0x0B, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, //ANC*
    ____, ____, 0x29, ____, 0x2D, 0x25, ____, 0x3D, 0x35, ____, 0x21, ____, ____, ____, 0x39, ____, ____, 0x31, ____, ____, ____, ____, ____, ____, ____, //AND
    ____, ____, 0x8B, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, //ANE*
    ____, ____, 0x6B, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, //ARR*
    0x0A, 0x0A, ____, ____, 0x0E, 0x06, ____, 0x1E, 0x16, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, //ASL
    ____, ____, 0x4B, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, //ASR*
    ____, ____, 0xCB, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, //AXS* (SBX)
    ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, 0x90, ____, //BCC
    ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, 0xB0, ____, //BCS
    ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, 0xF0, ____, //BEQ
    ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, 0xB0, ____, //BGE (BCS)
    ____, ____, ____, ____, 0x2C, 0x24, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, //BIT
    ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, 0x90, ____, //BLT (BCC)
    ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, 0x30, ____, //BMI
    ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, 0xD0, ____, //BNE
    ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, 0x10, ____, //BPL
    0x00, ____, 0x00, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, //BRK
    ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, 0x50, ____, //BVC
    ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, 0x70, ____, //BVS
    0x18, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, //CLC
    0xD8, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, //CLD
    //     a     #b    $l    $w    $b    $l,x  $w,x  $b,x  $w,x) $b,x) $b,s $b,s),y $l,y $w,y $b,y [$b],y ($b),y [$w] [$b]  ($w)  ($b)  +$w   +$b  $b,$b
    0x58, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, //CLI
    0xB8, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, //CLV
    ____, ____, 0xC9, ____, 0xCD, 0xC5, ____, 0xDD, 0xD5, ____, 0xC1, ____, ____, ____, 0xD9, ____, ____, 0xD1, ____, ____, ____, ____, ____, ____, ____, //CMP
    ____, ____, 0xE0, ____, 0xEC, 0xE4, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, //CPX
    ____, ____, 0xC0, ____, 0xCC, 0xC4, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, //CPY
    ____, ____, ____, ____, 0xCF, 0xC7, ____, 0xDF, 0xD7, ____, 0xC3, ____, ____, ____, 0xDB, ____, ____, 0xD3, ____, ____, ____, ____, ____, ____, ____, //DCM* (DCP)
    ____, ____, ____, ____, 0xCF, 0xC7, ____, 0xDF, 0xD7, ____, 0xC3, ____, ____, ____, 0xDB, ____, ____, 0xD3, ____, ____, ____, ____, ____, ____, ____, //DCP*
    ____, ____, ____, ____, 0xCE, 0xC6, ____, 0xDE, 0xD6, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, //DEC
    0xCA, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, //DEX
    0x88, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, //DEY
    ____, ____, 0x49, ____, 0x4D, 0x45, ____, 0x5D, 0x55, ____, 0x41, ____, ____, ____, 0x59, ____, ____, 0x51, ____, ____, ____, ____, ____, ____, ____, //EOR
    ____, ____, ____, ____, 0x4C, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, 0x90, ____, //GCC
    ____, ____, ____, ____, 0x4C, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, 0xB0, ____, //GCS
    ____, ____, ____, ____, 0x4C, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, 0xF0, ____, //GEQ
    ____, ____, ____, ____, 0x4C, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, 0xB0, ____, //GGE (GCS)
    ____, ____, ____, ____, 0x4C, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, 0x90, ____, //GLT (GCC)
    ____, ____, ____, ____, 0x4C, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, 0x30, ____, //GMI
    ____, ____, ____, ____, 0x4C, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, 0xD0, ____, //GNE
    ____, ____, ____, ____, 0x4C, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, 0x10, ____, //GPL
    ____, ____, ____, ____, 0x4C, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, 0x50, ____, //GVC
    ____, ____, ____, ____, 0x4C, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, 0x70, ____, //GVS
    ____, ____, ____, ____, 0xEE, 0xE6, ____, 0xFE, 0xF6, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, //INC
    ____, ____, ____, ____, 0xEF, 0xE7, ____, 0xFF, 0xF7, ____, 0xE3, ____, ____, ____, 0xFB, ____, ____, 0xF3, ____, ____, ____, ____, ____, ____, ____, //INS* (ISB)
    0xE8, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, //INX
    0xC8, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, //INY
    ____, ____, ____, ____, 0xEF, 0xE7, ____, 0xFF, 0xF7, ____, 0xE3, ____, ____, ____, 0xFB, ____, ____, 0xF3, ____, ____, ____, ____, ____, ____, ____, //ISB*
    ____, ____, ____, ____, 0xEF, 0xE7, ____, 0xFF, 0xF7, ____, 0xE3, ____, ____, ____, 0xFB, ____, ____, 0xF3, ____, ____, ____, ____, ____, ____, ____, //ISC* (ISB)
    0x02, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, //JAM*
    ____, ____, ____, ____, 0x4C, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, 0x6C, ____, ____, ____, ____, //JMP
    ____, ____, ____, ____, 0x20, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, //JSR
    ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, 0xBB, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, //LAE*
    ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, 0xBB, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, //LAS* (LAE)
    ____, ____, 0xAB, ____, 0xAF, 0xA7, ____, ____, ____, ____, 0xA3, ____, ____, ____, 0xBF, 0xB7, ____, 0xB3, ____, ____, ____, ____, ____, ____, ____, //LAX* (LXA #00)
    ____, ____, 0xA9, ____, 0xAD, 0xA5, ____, 0xBD, 0xB5, ____, 0xA1, ____, ____, ____, 0xB9, ____, ____, 0xB1, ____, ____, ____, ____, ____, ____, ____, //LDA
    ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, 0xBB, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, //LDS* (LAE)
    ____, ____, 0xA2, ____, 0xAE, 0xA6, ____, ____, ____, ____, ____, ____, ____, ____, 0xBE, 0xB6, ____, ____, ____, ____, ____, ____, ____, ____, ____, //LDX
    ____, ____, 0xA0, ____, 0xAC, 0xA4, ____, 0xBC, 0xB4, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, //LDY
    //     a     #b    $l    $w    $b    $l,x  $w,x  $b,x  $w,x) $b,x) $b,s $b,s),y $l,y $w,y $b,y [$b],y ($b),y [$w] [$b]  ($w)  ($b)  +$w   +$b  $b,$b
    0x4A, 0x4A, ____, ____, 0x4E, 0x46, ____, 0x5E, 0x56, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, //LSR
    ____, ____, 0xAB, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, //LXA*
    0xEA, ____, 0x80, ____, 0x0C, 0x04, ____, 0x1C, 0x14, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, //NOP
    ____, ____, 0x09, ____, 0x0D, 0x05, ____, 0x1D, 0x15, ____, 0x01, ____, ____, ____, 0x19, ____, ____, 0x11, ____, ____, ____, ____, ____, ____, ____, //ORA
    0x48, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, //PHA
    0x08, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, //PHP
    0x68, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, //PLA
    0x28, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, //PLP
    ____, ____, ____, ____, 0x2F, 0x27, ____, 0x3F, 0x37, ____, 0x23, ____, ____, ____, 0x3B, ____, ____, 0x33, ____, ____, ____, ____, ____, ____, ____, //RLA*
    0x2A, 0x2A, ____, ____, 0x2E, 0x26, ____, 0x3E, 0x36, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, //ROL
    0x6A, 0x6A, ____, ____, 0x6E, 0x66, ____, 0x7E, 0x76, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, //ROR
    ____, ____, ____, ____, 0x6F, 0x67, ____, 0x7F, 0x77, ____, 0x63, ____, ____, ____, 0x7B, ____, ____, 0x73, ____, ____, ____, ____, ____, ____, ____, //RRA*
    0x40, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, //RTI
    0x60, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, //RTS
    ____, ____, ____, ____, 0x8F, 0x87, ____, ____, ____, ____, 0x83, ____, ____, ____, ____, 0x97, ____, ____, ____, ____, ____, ____, ____, ____, ____, //SAX*
    ____, ____, 0xE9, ____, 0xED, 0xE5, ____, 0xFD, 0xF5, ____, 0xE1, ____, ____, ____, 0xF9, ____, ____, 0xF1, ____, ____, ____, ____, ____, ____, ____, //SBC
    ____, ____, 0xCB, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, //SBX*
    0x38, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, //SEC
    0xF8, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, //SED
    0x78, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, //SEI
    ____, ____, ____, ____, ____, ____, ____, 0x93, ____, ____, ____, ____, ____, ____, 0x9F, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, //SHA*
    ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, 0x9B, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, //SHS*
    //     a     #b    $l    $w    $b    $l,x  $w,x  $b,x  $w,x) $b,x) $b,s $b,s),y $l,y $w,y $b,y [$b],y ($b),y [$w] [$b]  ($w)  ($b)  +$w   +$b  $b,$b
    ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, 0x9E, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, //SHX*
    ____, ____, ____, ____, ____, ____, ____, 0x9C, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, //SHY*
    ____, ____, ____, ____, 0x0F, 0x07, ____, 0x1F, 0x17, ____, 0x03, ____, ____, ____, 0x1B, ____, ____, 0x13, ____, ____, ____, ____, ____, ____, ____, //SLO*
    ____, ____, ____, ____, 0x4F, 0x47, ____, 0x5F, 0x57, ____, 0x43, ____, ____, ____, 0x5B, ____, ____, 0x53, ____, ____, ____, ____, ____, ____, ____, //SRE*
    ____, ____, ____, ____, 0x8D, 0x85, ____, 0x9D, 0x95, ____, 0x81, ____, ____, ____, 0x99, ____, ____, 0x91, ____, ____, ____, ____, ____, ____, ____, //STA
    ____, ____, ____, ____, 0x8E, 0x86, ____, ____, ____, ____, ____, ____, ____, ____, ____, 0x96, ____, ____, ____, ____, ____, ____, ____, ____, ____, //STX
    ____, ____, ____, ____, 0x8C, 0x84, ____, ____, 0x94, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, //STY
    ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, 0x9B, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, //TAS* (SHS)
    0xAA, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, //TAX
    0xA8, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, //TAY
    0xBA, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, //TSX
    0x8A, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, //TXA
    0x9A, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, //TXS
    0x98, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, //TYA
    ____, ____, 0x8B, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____};//XAA* (ANE)

const unsigned char ccpu64[]=
    // 1   2     3           4     5           6     7     8                  9    10          11                12                13
    //                 14                15                      16   17                18            19   20          21    22          23  24
    //     a     #b    $l    $w    $b    $l,x  $w,x  $b,x  $w,x) $b,x) $b,s $b,s),y $l,y $w,y $b,y [$b],y ($b),y [$w] [$b]  ($w)  ($b)  +$w   +$b  $b,$b
{
    ____, ____, 0x69, 0x6F, 0x6D, 0x65, 0x7F, 0x7D, 0x75, ____, 0x61, ____, ____, 0x73, 0x79, ____, ____, 0x71, ____, ____, ____, ____, ____, ____, ____, //ADC
    ____, ____, 0x29, 0x2F, 0x2D, 0x25, 0x3F, 0x3D, 0x35, ____, 0x21, ____, ____, 0x33, 0x39, ____, ____, 0x31, ____, ____, ____, ____, ____, ____, ____, //AND
    0x0A, 0x0A, ____, 0x07, 0x0E, 0x06, 0x17, 0x1E, 0x16, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, //ASL
    ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, 0x90, ____, //BCC
    ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, 0xB0, ____, //BCS
    ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, 0xF0, ____, //BEQ
    ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, 0xB0, ____, //BGE (BCS)
    ____, ____, 0x89, ____, 0x2C, 0x24, ____, 0x3C, 0x34, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, //BIT
    ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, 0x90, ____, //BLT (BCC)
    ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, 0x30, ____, //BMI
    ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, 0xD0, ____, //BNE
    ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, 0x10, ____, //BPL
    ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, 0x80, ____, //BRA
    0x00, ____, 0x00, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, //BRK
    ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, 0x50, ____, //BVC
    ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, 0x70, ____, //BVS
    0x18, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, //CLC
    0xD8, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, //CLD
    0x58, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, //CLI
    0xB8, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, //CLV
    ____, ____, 0xC9, 0xCF, 0xCD, 0xC5, 0xDF, 0xDD, 0xD5, ____, 0xC1, ____, ____, 0xD3, 0xD9, ____, ____, 0xD1, ____, ____, ____, ____, ____, ____, ____, //CMP
    ____, ____, 0xE0, ____, 0xEC, 0xE4, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, //CPX
    //     a     #b    $l    $w    $b    $l,x  $w,x  $b,x  $w,x) $b,x) $b,s $b,s),y $l,y $w,y $b,y [$b],y ($b),y [$w] [$b]  ($w)  ($b)  +$w   +$b  $b,$b
    ____, ____, 0xC0, ____, 0xCC, 0xC4, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, //CPY
    0x3A, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, //DEA (DEC A)
    ____, 0x3A, ____, 0xC7, 0xCE, 0xC6, 0xD7, 0xDE, 0xD6, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, //DEC
    0xCA, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, //DEX
    0x88, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, //DEY
    ____, ____, 0x49, 0x4F, 0x4D, 0x45, 0x5F, 0x5D, 0x55, ____, 0x41, ____, ____, 0x53, 0x59, ____, ____, 0x51, ____, ____, ____, ____, ____, ____, ____, //EOR
    ____, ____, ____, ____, 0x4C, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, 0x90, ____, //GCC
    ____, ____, ____, ____, 0x4C, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, 0xB0, ____, //GCS
    ____, ____, ____, ____, 0x4C, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, 0xF0, ____, //GEQ
    ____, ____, ____, ____, 0x4C, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, 0xB0, ____, //GGE (GCS)
    ____, ____, ____, ____, 0x4C, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, 0x90, ____, //GLT (GCC)
    ____, ____, ____, ____, 0x4C, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, 0x30, ____, //GMI
    ____, ____, ____, ____, 0x4C, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, 0xD0, ____, //GNE
    ____, ____, ____, ____, 0x4C, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, 0x10, ____, //GPL
    ____, ____, ____, ____, 0x4C, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, 0x50, ____, //GVC
    ____, ____, ____, ____, 0x4C, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, 0x70, ____, //GVS
    0x1A, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, //INA (INC A)
    ____, 0x1A, ____, 0xE7, 0xEE, 0xE6, 0xF7, 0xFE, 0xF6, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, //INC
    0xE8, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, //INX
    0xC8, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, //INY
    ____, ____, ____, 0x5C, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, //JML (JMP)
    ____, ____, ____, 0x5C, 0x4C, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, 0x6C, ____, ____, ____, ____, //JMP
    ____, ____, ____, 0x22, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, //JSL (JSR)
    ____, ____, ____, 0x22, 0x20, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, //JSR
    ____, ____, 0xA9, 0xAF, 0xAD, 0xA5, 0xBF, 0xBD, 0xB5, ____, 0xA1, ____, ____, 0xB3, 0xB9, ____, ____, 0xB1, ____, ____, ____, ____, ____, ____, ____, //LDA
    ____, ____, 0xA2, 0xA7, 0xAE, 0xA6, 0xB7, ____, ____, ____, ____, ____, ____, ____, 0xBE, 0xB6, ____, ____, ____, ____, ____, ____, ____, ____, ____, //LDX
    ____, ____, 0xA0, 0xA3, 0xAC, 0xA4, ____, 0xBC, 0xB4, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, //LDY
    0x4A, 0x4A, ____, 0x47, 0x4E, 0x46, 0x57, 0x5E, 0x56, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, //LSR
    0xEA, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, //NOP
    ____, ____, 0x09, 0x0F, 0x0D, 0x05, 0x1F, 0x1D, 0x15, ____, 0x01, ____, ____, 0x13, 0x19, ____, ____, 0x11, ____, ____, ____, ____, ____, ____, ____, //ORA
    0x48, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, //PHA
    0x8B, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, //PHB
    0x08, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, //PHP
    0xDA, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, //PHX
    0x5A, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, //PHY
    0x68, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, //PLA
    0xAB, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, //PLB
    0x28, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, //PLP
    0xFA, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, //PLX
    0x7A, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, //PLY
    0x2A, 0x2A, ____, 0x27, 0x2E, 0x26, 0x37, 0x3E, 0x36, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, //ROL
    0x6A, 0x6A, ____, 0x67, 0x6E, 0x66, 0x77, 0x7E, 0x76, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, //ROR
    //     a     #b    $l    $w    $b    $l,x  $w,x  $b,x  $w,x) $b,x) $b,s $b,s),y $l,y $w,y $b,y [$b],y ($b),y [$w] [$b]  ($w)  ($b)  +$w   +$b  $b,$b
    0x40, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, //RTI
    0x6B, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, //RTL
    0x60, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, //RTS
    ____, ____, 0xE9, 0xEF, 0xED, 0xE5, 0xFF, 0xFD, 0xF5, ____, 0xE1, ____, ____, ____, 0xF9, ____, ____, 0xF1, ____, ____, ____, ____, ____, ____, ____, //SBC
    0x38, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, //SEC
    0xF8, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, //SED
    0x78, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, //SEI
    ____, ____, ____, 0x8F, 0x8D, 0x85, 0x9F, 0x9D, 0x95, ____, 0x81, ____, ____, 0x93, 0x99, ____, ____, 0x91, ____, ____, ____, ____, ____, ____, ____, //STA
    ____, ____, ____, 0x87, 0x8E, 0x86, 0x97, ____, ____, ____, ____, ____, ____, ____, ____, 0x96, ____, ____, ____, ____, ____, ____, ____, ____, ____, //STX
    ____, ____, ____, 0x83, 0x8C, 0x84, ____, ____, 0x94, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, //STY
    ____, ____, ____, ____, 0x9C, ____, ____, 0x9E, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, //STZ
    0xAA, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, //TAX
    0xA8, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, //TAY
    0xBA, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, //TSX
    0x8A, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, //TXA
    0x9A, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, //TXS
    0x98, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____};//TYA

const unsigned char c65dtv02[]=
    // 1   2     3           4     5           6     7     8                  9    10          11                12                13
    //                 14                15                      16   17                18            19   20          21    22          23  24
    //     a     #b    $l    $w    $b    $l,x  $w,x  $b,x  $w,x) $b,x) $b,s $b,s),y $l,y $w,y $b,y [$b],y ($b),y [$w] [$b]  ($w)  ($b)  +$w   +$b  $b,$b
{
    ____, ____, 0x69, ____, 0x6D, 0x65, ____, 0x7D, 0x75, ____, 0x61, ____, ____, ____, 0x79, ____, ____, 0x71, ____, ____, ____, ____, ____, ____, ____, //ADC
    ____, ____, 0x4B, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, //ALR* (ASR)
    ____, ____, 0x29, ____, 0x2D, 0x25, ____, 0x3D, 0x35, ____, 0x21, ____, ____, ____, 0x39, ____, ____, 0x31, ____, ____, ____, ____, ____, ____, ____, //AND
    ____, ____, 0x8B, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, //ANE*
    ____, ____, 0x6B, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, //ARR*
    0x0A, 0x0A, ____, ____, 0x0E, 0x06, ____, 0x1E, 0x16, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, //ASL
    ____, ____, 0x4B, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, //ASR*
    ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, 0x90, ____, //BCC
    ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, 0xB0, ____, //BCS
    ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, 0xF0, ____, //BEQ
    ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, 0xB0, ____, //BGE (BCS)
    ____, ____, ____, ____, 0x2C, 0x24, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, //BIT
    ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, 0x90, ____, //BLT (BCC)
    ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, 0x30, ____, //BMI
    ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, 0xD0, ____, //BNE
    ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, 0x10, ____, //BPL
    ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, 0x12, ____, //BRA
    0x00, ____, 0x00, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, //BRK
    ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, 0x50, ____, //BVC
    ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, 0x70, ____, //BVS
    0x18, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, //CLC
    0xD8, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, //CLD
    0x58, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, //CLI
    0xB8, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, //CLV
    ____, ____, 0xC9, ____, 0xCD, 0xC5, ____, 0xDD, 0xD5, ____, 0xC1, ____, ____, ____, 0xD9, ____, ____, 0xD1, ____, ____, ____, ____, ____, ____, ____, //CMP
    ____, ____, 0xE0, ____, 0xEC, 0xE4, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, //CPX
    //     a     #b    $l    $w    $b    $l,x  $w,x  $b,x  $w,x) $b,x) $b,s $b,s),y $l,y $w,y $b,y [$b],y ($b),y [$w] [$b]  ($w)  ($b)  +$w   +$b  $b,$b
    ____, ____, 0xC0, ____, 0xCC, 0xC4, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, //CPY
    ____, ____, ____, ____, 0xCF, 0xC7, ____, 0xDF, 0xD7, ____, 0xC3, ____, ____, ____, 0xDB, ____, ____, 0xD3, ____, ____, ____, ____, ____, ____, ____, //DCM* (DCP)
    ____, ____, ____, ____, 0xCF, 0xC7, ____, 0xDF, 0xD7, ____, 0xC3, ____, ____, ____, 0xDB, ____, ____, 0xD3, ____, ____, ____, ____, ____, ____, ____, //DCP*
    ____, ____, ____, ____, 0xCE, 0xC6, ____, 0xDE, 0xD6, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, //DEC
    0xCA, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, //DEX
    0x88, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, //DEY
    ____, ____, 0x49, ____, 0x4D, 0x45, ____, 0x5D, 0x55, ____, 0x41, ____, ____, ____, 0x59, ____, ____, 0x51, ____, ____, ____, ____, ____, ____, ____, //EOR
    ____, ____, ____, ____, 0x4C, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, 0x90, ____, //GCC
    ____, ____, ____, ____, 0x4C, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, 0xB0, ____, //GCS
    ____, ____, ____, ____, 0x4C, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, 0xF0, ____, //GEQ
    ____, ____, ____, ____, 0x4C, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, 0xB0, ____, //GGE (GCS)
    ____, ____, ____, ____, 0x4C, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, 0x90, ____, //GLT (GCC)
    ____, ____, ____, ____, 0x4C, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, 0x30, ____, //GMI
    ____, ____, ____, ____, 0x4C, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, 0xD0, ____, //GNE
    ____, ____, ____, ____, 0x4C, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, 0x10, ____, //GPL
    ____, ____, ____, ____, 0x4C, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, 0x12, ____, //GRA
    ____, ____, ____, ____, 0x4C, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, 0x50, ____, //GVC
    ____, ____, ____, ____, 0x4C, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, 0x70, ____, //GVS
    ____, ____, ____, ____, 0xEE, 0xE6, ____, 0xFE, 0xF6, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, //INC
    ____, ____, ____, ____, 0xEF, 0xE7, ____, 0xFF, 0xF7, ____, 0xE3, ____, ____, ____, 0xFB, ____, ____, 0xF3, ____, ____, ____, ____, ____, ____, ____, //INS* (ISB)
    0xE8, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, //INX
    0xC8, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, //INY
    ____, ____, ____, ____, 0xEF, 0xE7, ____, 0xFF, 0xF7, ____, 0xE3, ____, ____, ____, 0xFB, ____, ____, 0xF3, ____, ____, ____, ____, ____, ____, ____, //ISB*
    ____, ____, ____, ____, 0xEF, 0xE7, ____, 0xFF, 0xF7, ____, 0xE3, ____, ____, ____, 0xFB, ____, ____, 0xF3, ____, ____, ____, ____, ____, ____, ____, //ISC* (ISB)
    ____, ____, ____, ____, 0x4C, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, 0x6C, ____, ____, ____, ____, //JMP
    ____, ____, ____, ____, 0x20, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, //JSR
    ____, ____, 0xAB, ____, 0xAF, 0xA7, ____, ____, ____, ____, 0xA3, ____, ____, ____, 0xBF, 0xB7, ____, 0xB3, ____, ____, ____, ____, ____, ____, ____, //LAX* (LXA #00)
    ____, ____, 0xA9, ____, 0xAD, 0xA5, ____, 0xBD, 0xB5, ____, 0xA1, ____, ____, ____, 0xB9, ____, ____, 0xB1, ____, ____, ____, ____, ____, ____, ____, //LDA
    ____, ____, 0xA2, ____, 0xAE, 0xA6, ____, ____, ____, ____, ____, ____, ____, ____, 0xBE, 0xB6, ____, ____, ____, ____, ____, ____, ____, ____, ____, //LDX
    ____, ____, 0xA0, ____, 0xAC, 0xA4, ____, 0xBC, 0xB4, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, //LDY
    0x4A, 0x4A, ____, ____, 0x4E, 0x46, ____, 0x5E, 0x56, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, //LSR
    ____, ____, 0xAB, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, //LXA*
    0xEA, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, //NOP
    ____, ____, 0x09, ____, 0x0D, 0x05, ____, 0x1D, 0x15, ____, 0x01, ____, ____, ____, 0x19, ____, ____, 0x11, ____, ____, ____, ____, ____, ____, ____, //ORA
    0x48, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, //PHA
    0x08, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, //PHP
    0x68, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, //PLA
    0x28, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, //PLP
    ____, ____, ____, ____, 0x2F, 0x27, ____, 0x3F, 0x37, ____, 0x23, ____, ____, ____, 0x3B, ____, ____, 0x33, ____, ____, ____, ____, ____, ____, ____, //RLA*
    0x2A, 0x2A, ____, ____, 0x2E, 0x26, ____, 0x3E, 0x36, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, //ROL
    0x6A, 0x6A, ____, ____, 0x6E, 0x66, ____, 0x7E, 0x76, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, //ROR
    ____, ____, ____, ____, 0x6F, 0x67, ____, 0x7F, 0x77, ____, 0x63, ____, ____, ____, 0x7B, ____, ____, 0x73, ____, ____, ____, ____, ____, ____, ____, //RRA*
    //     a     #b    $l    $w    $b    $l,x  $w,x  $b,x  $w,x) $b,x) $b,s $b,s),y $l,y $w,y $b,y [$b],y ($b),y [$w] [$b]  ($w)  ($b)  +$w   +$b  $b,$b
    0x40, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, //RTI
    0x60, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, //RTS
    ____, ____, 0x32, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, //SAC
    ____, ____, ____, ____, 0x8F, 0x87, ____, ____, ____, ____, 0x83, ____, ____, ____, ____, 0x97, ____, ____, ____, ____, ____, ____, ____, ____, ____, //SAX*
    ____, ____, 0xE9, ____, 0xED, 0xE5, ____, 0xFD, 0xF5, ____, 0xE1, ____, ____, ____, 0xF9, ____, ____, 0xF1, ____, ____, ____, ____, ____, ____, ____, //SBC
    0x38, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, //SEC
    0xF8, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, //SED
    0x78, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, //SEI
    ____, ____, 0x02, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, //SIR
    ____, ____, ____, ____, 0x0F, 0x07, ____, 0x1F, 0x17, ____, 0x03, ____, ____, ____, 0x1B, ____, ____, 0x13, ____, ____, ____, ____, ____, ____, ____, //SLO*
    ____, ____, ____, ____, 0x4F, 0x47, ____, 0x5F, 0x57, ____, 0x43, ____, ____, ____, 0x5B, ____, ____, 0x53, ____, ____, ____, ____, ____, ____, ____, //SRE*
    ____, ____, ____, ____, 0x8D, 0x85, ____, 0x9D, 0x95, ____, 0x81, ____, ____, ____, 0x99, ____, ____, 0x91, ____, ____, ____, ____, ____, ____, ____, //STA
    ____, ____, ____, ____, 0x8E, 0x86, ____, ____, ____, ____, ____, ____, ____, ____, ____, 0x96, ____, ____, ____, ____, ____, ____, ____, ____, ____, //STX
    ____, ____, ____, ____, 0x8C, 0x84, ____, ____, 0x94, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, //STY
    0xAA, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, //TAX
    0xA8, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, //TAY
    0xBA, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, //TSX
    0x8A, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, //TXA
    0x9A, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, //TXS
    0x98, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, //TYA
    ____, ____, 0x8B, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____, ____};//XAA* (ANE)
