ColourCycle:
	lda	cycling
	cmp	#$01
	beq	.cycleslow
	cmp	#$04		;1 and 4 are slow cycles
	beq	.cycleslow
;------------- now we cycle fast
	lda	nmi_count
	and	#$07		;Check vblanks first
	beq	.cyclenow
	jmp	.no_cycle_yet
.cycleslow:
	lda	nmi_count
	and	#$0F
	beq	.cyclenow
	jmp	.no_cycle_yet	
.cyclenow:
;---------------------
	stw	#$01,color_reg	;Save to colour address
	lda	colouridx
	sta	colourcur	;Make a temp copy
	cly
	ldx	#$0F
.cyc_next:
	jsr	Point_Palette
	lda	[_cx],Y
	sta	color_data
	iny
	lda	[_cx],Y
	sta	color_data+1
	dey
	inc	colourcur	;To next colour
	dex
	bne	.cyc_next

	lda	cycling
	cmp	#$01
	beq	.cycleup
	cmp	#$02
	beq	.cycleup
	dec	colouridx
	bra	.no_cycle_yet
.cycleup:
	inc	colouridx	;Inc it for next time
.no_cycle_yet:
	rts

Point_Palette:
	lda	colourcur
	sta	<_cx
	stz	<_cx+1
	aslw	<_cx	;0-255 -> 0-510
	addw	#cyclepal,<_cx	;Point to palette
	rts

Move_Box_Sides:
	addw	#$10,boxside1x		;Move top box across screen
	cmpw	boxside1x,box1sprx	;If at right, then reset!
	bcs	.no_reset_boxtop
	stw	box2sprx,boxside1x
.no_reset_boxtop:
	subw	#$10,boxside2x		;Move Bottom box
	cmpw	boxside2x,box2sprx
	bcc	.no_reset_boxbot
	stw	box1sprx,boxside2x
.no_reset_boxbot:
	subw	#$10,boxside3y		;Move Left box
	cmpw	boxside3y,box1spry
	bcc	.no_reset_boxleft
	stw	box2spry,boxside3y
.no_reset_boxleft:
	addw	#$10,boxside4y		;Move Right box
	cmpw	boxside4y,box2spry
	bcs	.no_reset_boxright
	stw	box1spry,boxside4y
.no_reset_boxright:
	rts

Position_Box_Sides:
	stw	box2sprx,boxside1x	;Top side
	stw	box1spry,boxside1y
	stw	box1sprx,boxside2x	;Bottom side
	stw	box2spry,boxside2y
	stw	box2sprx,boxside3x	;Left side
	stw	box2spry,boxside3y
	stw	box1sprx,boxside4x	;Right side
	stw	box1spry,boxside4y
	rts

Clear_Box_Sides:
	stwz	boxside1x
	stwz	boxside2x
	stwz	boxside3x
	stwz	boxside4x
	rts

Init_Box_Sides:
	spr_set #16,satb
	spr_pattern #$1880	;Point to Box
	spr_ctrl  #SIZE_MASK|FLIP_MASK,#SIZE_16x16|NO_FLIP
	spr_pri   #1
	spr_pal   #0
	spr_set #17,satb
	spr_pattern #$1880	;Point to Box
	spr_ctrl  #SIZE_MASK|FLIP_MASK,#SIZE_16x16|FLIP_Y
	spr_pri   #1
	spr_pal   #0
	spr_set #18,satb
	spr_pattern #$18C0	;Point to Box
	spr_ctrl  #SIZE_MASK|FLIP_MASK,#SIZE_16x16|NO_FLIP
	spr_pri   #1
	spr_pal   #0
	spr_set #19,satb
	spr_pattern #$18C0	;Point to Box
	spr_ctrl  #SIZE_MASK|FLIP_MASK,#SIZE_16x16|FLIP_X
	spr_pri   #1
	spr_pal   #0
	rts

Copy_Box_Frac_Vars:
	stw	boxposx,<x0_start	;Copy variables
	stw	boxposx+2,<x0_start+2
	stw	boxposy,<y0_start
	stw	boxposy+2,<y0_start+2
;---------------- now calculate the zoom factor
	lda	<xres
	cmp	boxwidth	;If the scale hasn't changed.
	bne	.write_zoom
	jmp	.no_write_zoom
.write_zoom:
;-------------------------- Okay, we have to scale the zoom factor
	;First divide boxzoom by 32 or 64
	lda	<horiz_res	;0 or 1
	add	#$05		;5 or 6
	tax			;A counter for the shift.
.shiftloop:
	lsrw	boxzoom+6
	rorw	boxzoom+4
	rorw	boxzoom+2
	rorw	boxzoom		;I doubt this is needed.
	dex
	bne	.shiftloop
;---------- OK, divided, now multiply by boxwidth to scale back up!
	stw	boxzoom,<multpart1	;Current Zoom is one factor
	stw	boxzoom+2,<multpart1+2	;Low 32 bits first...
	lda	boxwidth
	sta	<multpart2	;Width is the other factor
	stz	<multpart2+1
	stwz	<multpart2+2
;----
	lda	<restart_flag	
	pha
	smb0	<restart_flag
	jsr	Multiply_Unsigned	;Zoom is unsigned!
	pla
	sta	<restart_flag
;-------	
	stw	<multresult,<x_zoom
	stw	<multresult+2,<x_zoom+2
	stw	<multresult+4,<x_zoom+4
	stw	<multresult+6,<x_zoom+6

	stw	boxzoom+4,<multpart1	;Current Zoom is one factor
	stw	boxzoom+6,<multpart1+2	;High 32 bits next...
	lda	boxwidth
	sta	<multpart2	;Width is the other factor
	stz	<multpart2+1
	stwz	<multpart2+2
;----
	lda	<restart_flag	
	pha
	smb0	<restart_flag
	jsr	Multiply_Unsigned
	pla
	sta	<restart_flag
;-------	
	addw	<multresult,<x_zoom+4		;into the top 32 bits
	adcw	<multresult+2,<x_zoom+6


.no_write_zoom:
	rts

BoxScaleDown:
	lda	<horiz_res	;(0 or 1)
	asl	a		;(0 or 2)
	asl	a		;(0 or 4)
	add	#$05		;(5 or 9)
	cmp	boxwidth
	beq	.no_scale_boxwidth
	bbs0	<horiz_res,.boxsc_512
	subw	#$04,box2spry	;If it's 256, do twice Y!
.boxsc_512:
	subw	#$04,box2spry
	addw	#$08,box2sprx
	dec	boxwidth
	jsr	Show_Boxes
.no_scale_boxwidth:
	rts

BoxScaleUp:
	bbs0	<horiz_res,.boxsc_512
	addw	#$04,box2spry	;If it's 256, do twice Y!
.boxsc_512:
	addw	#$04,box2spry
	subw	#$08,box2sprx
	inc	boxwidth
	jsr	Show_Boxes
	rts

Box_Move_Right:
	subw	<x0_step,boxposx	;Sub the step value from the position!
	sbcw	<x0_step+2,boxposx+2
	addw	#$08,box1sprx
	addw	#$08,box2sprx
	jsr	Show_Boxes
	rts

Box_Move_Left:
	addw	<x0_step,boxposx	;Add the step value to the position!
	adcw	<x0_step+2,boxposx+2
	subw	#$08,box1sprx
	subw	#$08,box2sprx
	jsr	Show_Boxes
	rts

Box_Move_Up:
	subw	<y0_step,boxposy	;Sub the step value from the position!
	sbcw	<y0_step+2,boxposy+2
	subw	#$08,box1spry
	subw	#$08,box2spry
	jsr	Show_Boxes
	rts

Box_Move_Down:
	addw	<y0_step,boxposy	;Add the step value to the position!
	adcw	<y0_step+2,boxposy+2
	addw	#$08,box1spry
	addw	#$08,box2spry
	jsr	Show_Boxes
	rts


Hide_Boxes:
	spr_set #1,satb
	spr_x #$0
	spr_set #2,satb
	spr_x #$0
	spr_set #3,satb
	spr_x #$0
	spr_set #4,satb		;Hide box sprites
	spr_x #$0
	stz	<box_mode
	rts

Show_Boxes:
	spr_set #1,satb
	spr_x box1sprx
	spr_y box1spry
	spr_set #2,satb
	spr_x box2sprx
	spr_y box1spry
	spr_set #3,satb
	spr_x box1sprx
	spr_y box2spry
	spr_set #4,satb
	spr_x box2sprx
	spr_y box2spry

	jsr	Position_Box_Sides
	rts

Setup_Box_Sprites:

	stw	<x0_start,boxposx	;Copy variables
	stw	<x0_start+2,boxposx+2
	stw	<y0_start,boxposy
	stw	<y0_start+2,boxposy+2
	stw	<x_zoom,boxzoom		;Copy zoom factor
	stw	<x_zoom+2,boxzoom+2
	stw	<x_zoom+4,boxzoom+4
	stw	<x_zoom+6,boxzoom+6

	lda	#$01
	sta	<box_mode

	lda	<xres
	sta	boxwidth	;Copy into width for scaling.

	lda	<horiz_res
	inc	a
	sta	box1sprx+1	;Put into position!
	lda	#$10
	sta	box1sprx	;$110 if lores, $210 if high.

	stw   #$0040,box1spry	;Top-Right

	stw   #$20,box2sprx	;
	stw   #$0120,box2spry	;Bottom-Left


	spr_set #1,satb
	spr_pattern #$1840	;Point to Box
	spr_ctrl  #SIZE_MASK|FLIP_MASK,#SIZE_16x16|NO_FLIP
	spr_pri   #1
	spr_pal   #0

	spr_set #2,satb
	spr_pattern #$1840	;Point to Box
	spr_ctrl  #SIZE_MASK|FLIP_MASK,#SIZE_16x16|FLIP_X
	spr_pri   #1
	spr_pal   #0

	spr_set #3,satb
	spr_pattern #$1840	;Point to Box
	spr_ctrl  #SIZE_MASK|FLIP_MASK,#SIZE_16x16|FLIP_Y
	spr_pri   #1
	spr_pal   #0

	spr_set #4,satb
	spr_pattern #$1840	;Point to Box
	spr_ctrl  #SIZE_MASK|FLIP_MASK,#SIZE_16x16|FLIP_X|FLIP_Y
	spr_pri   #1
	spr_pal   #0

	jsr	Show_Boxes	;Position boxes on-screen
	jsr	Init_Box_Sides	;Position moving box border?

	rts


Write_Gfx:
	bbs0	<quality,highqual_write	;Either quality or preview
	;If the write flag is 0, don't do anything.
	bbr0	<write_flag,LOnothing_to_write
		;Something to do!
	stw	<write_add,<_di		;Get the address to write to
	jsr   set_write
	stw	<write_data,video_data	;Write it!
	rmb0	<write_flag	;Signal that a byte is done.
LOnothing_to_write:
	rts	;Early exit
highqual_write:
	bbr0	<Qwrite_flag,Qnothing_to_write
	bbs0	<howdy,.write_nothing	;A little test...
	stw	<Qwrite_address,<_di
	jsr   set_write
	stw	<Qwrite_ram,video_data	;Write it!
	lda	<_di
	ora	#%00001000
	sta	<_di
	jsr   set_write
	stw	<Qwrite_ram+2,video_data	;Write it!
.write_nothing:
	rmb0	<Qwrite_flag
	rts	;Early exit
Qnothing_to_write:
	rts

Init_Quality_Screen:
;Initialize the MAP for all tiles, clear sprites, etc...
	init_satb satb
	jsr	Update_Satb_BLOCKTRANSFER	;clear sprites
	SCREEN_OFF
	stwz	<_di
	jsr	set_write	;Write to VRAM
	stw	#$0080,<_ax	;Change this for 256 resolution
.fill_vram_loop:
	stw	<_ax,video_data
	incw	<_ax		;Write increasing tiles
	cmpw	#$0800,<_ax	;Limit of VRAM!
	bne	.fill_vram_loop
;	SCREEN_ON
	vreg  #5	;Screen on but sprites off!
	st1   #$8C
	st2   #$00

	rts
;@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@

Update_Panel_Readout:
	;write progress in the panel,
	bbs0	<quality,high_quality_remaining
	stw	#$09D9,<_di
	jsr	set_write
	lda	<remaining+1	;Write the remaining # of dots!
	jsr	print_byte
	lda	<remaining
	jsr	print_byte
	rts

high_quality_remaining:

	rts

;@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@

PutPixel:
	bbs0	<quality,high_quality_pixel
.not_ready_write:
	;If the write flag is still 1, have to wait for the Write_Gfx rt.
	bbs0	<write_flag,.not_ready_write

	lda	<py
;	dec	a
	sta	<_bx
	stz	<_bx+1
	aslw	<_bx
	aslw	<_bx
	aslw	<_bx
	aslw	<_bx
	aslw	<_bx	;Multiply by 32
	aslw	<_bx	;Multiply by 64
	lda	<px
	dec	a
	add	<_bx
	sta	<_bx
	lda	<_bx+1
	adc	#$00
	sta	<_bx+1
	stw	<_bx,<write_add	;address for VRAM writing

	lda	<iteration
	beq	.write_zeros
	and	#$0F	;Limit to 0-F
	bne	.no_fuckup_iter		;So there are no "0" tiles.
	lda	#$0F			;But there will be 2 "Fs"!
.no_fuckup_iter:

.write_zeros:
	sta	<write_data
	lda	#$01
	sta	<write_data+1
	smb0	<write_flag	;Signal that a byte is to be written.

	rts

high_quality_pixel:
	;High-quality.  First we have to wait for it to be saved to VRAM
	bbs0	<Qwrite_flag,high_quality_pixel
	
	lda	<px	;Get horizontal counter (512-1)
	dec	a	;Align by byte (511-0)
			;Only need low 3 bits
;---------------- save to buffer ------------------
	pha
	and	#$07	;isolate
	tax
	lda	<iteration
	beq	.Qwrite_zeros		;If 0, write
	and	#$0F	;Limit to 0-F
	bne	.Qwrite_zeros		;So there are no "0" tiles.
	lda	#$0F			;But there will be 2 "Fs"!
.Qwrite_zeros:
	sta	Qwrite_buff,X	;Store in the buffer
	pla
;-----------------------
	and	#$07	;Check if 8 total...
	bne	.no_write_vram_yet

	jsr	Adjust_Qwrite_Add
	jsr	Configure_Bits

	smb0	<Qwrite_flag	;buffer is ready for VRAM writing.
.no_write_vram_yet:
	
	rts

Configure_Bits:		;Mangle the bits into PCE tiles!
	clx
.bitmash_loop:
	lsr	Qwrite_buff
	rol	Qwrite_ram,X
	lsr	Qwrite_buff+1
	rol	Qwrite_ram,X
	lsr	Qwrite_buff+2
	rol	Qwrite_ram,X
	lsr	Qwrite_buff+3
	rol	Qwrite_ram,X
	lsr	Qwrite_buff+4
	rol	Qwrite_ram,X
	lsr	Qwrite_buff+5
	rol	Qwrite_ram,X
	lsr	Qwrite_buff+6
	rol	Qwrite_ram,X
	lsr	Qwrite_buff+7
	rol	Qwrite_ram,X
	inx
	cpx	#$04
	bne	.bitmash_loop


Adjust_Qwrite_Add:	;Set up address for writing
	stw	<px,<Qwrite_address
	decw	<Qwrite_address		;Because <px starts 512
	aslw	<Qwrite_address
	aslw	<Qwrite_address	;x bit 3 goes up to 5
	lda	<Qwrite_address
	and	#%11100000
	sta	<Qwrite_address
	lda	<py
	asl	a
	and	#%00001110	;Y address is complicated.
	ora	<Qwrite_address
	sta	<Qwrite_address	;That's the low nybble done
	lda	<py	;I'm pretty sure it's 8-bit only
	and	#%11111000
	ora	<Qwrite_address+1
	sta	<Qwrite_address+1	;OK, that's written
	lsrw	<Qwrite_address		;Convert to VRAM Addr!
	addw	#$0800,<Qwrite_address	;Shift b/c of NAM table!
	rts

;***************************************************

Position_Cursor:	;Places the sprite on-screen
	stw	#SPRXINIT,<sx
	stw	#SPRYINIT,<sy	;Setup defaults
	lda	<cursx		;Get cursor position
	asl	a
	asl	a
	asl	a		;Multiply by 8
	add	<sx
	sta	<sx
	lda	<sx+1
	adc	#$00
	sta	<sx+1		;Moves the cursor over
	ldx	<cursy
	lda	Cursor_X_Pos_Tbl,X
	add	<sx
	sta	<sx
	lda	<sx+1
	adc	#$00
	sta	<sx+1		;Moves the cursor over
	ldx	<cursy
	lda	Cursor_Y_Pos_Tbl,X
	add	<sy
	sta	<sy
	lda	<sy+1
	adc	#$00
	sta	<sy+1		;Moves the cursor over
	spr_set #0,satb
	spr_x sx
	spr_y sy
	rts

Cursor_X_Pos_Tbl:
	.db $68,$68,$68,$68,$68,$68,$68,$68
Cursor_Y_Pos_Tbl:
	.db $08,$10,$18,$20,$28,$30,$38,$00
;***************************************************

setup_video:
	stz	<write_flag	
	stz	<Qwrite_flag
	map    blockgfx		; map in the memory bank

	; load blank character into VRAM:

	vload	blockgfx,#$0100
	vload	textgfx,#$0700

	load_sprites $1800,spritegfx,#1
	init_satb satb

	stw   #$A0,sx	; that will center it on the screen
	stw   #$A0,sy

	spr_set #0,satb
	spr_pattern #$1800
	spr_ctrl  #SIZE_MASK|FLIP_MASK,#SIZE_16x16|NO_FLIP
	spr_pri   #1
	spr_pal   #0
	jsr	Position_Cursor
	jsr	Update_Satb_BLOCKTRANSFER

	set_bgpal #0,blockpal,#2	; fill palette #0,1
	set_sprpal #0,sprpal,#1
	jsr	yres_240

; blank the background

	vreg #9
	lda	#%01010000	;Set virtual height to 64
	sta	video_data	;And width to 64!
	stz	video_data+1

	stw	#$0800,<_di
	jsr	set_write
	stw	#$240,<_ax	;a counter
	stw	#PanelText,<_si
	cly
.write_panel
	lda	[_si],Y
	sta	video_data
	st2	#$11	;2nd palette
	incw	<_si
	decw	<_ax
	cmpw	#0000,<_ax
	bne	.write_panel

	vreg #07
	stwz	video_data
	setcolor #256,0,0,0	;Clear the Border colour!
	rts



Draw_Splash_Screen:
;------------------------------
	stw	#$0000,<_di	;Clear a little bit of the map!
	jsr	set_write		
	clx
.clear_small_vram:
	st1	#$00
	st2	#$01	;Palette 0, char $100!
	dex
	bne	.clear_small_vram

	map	splash_gfx
	vload	$2000,splash_gfx,#$1000
	tma	#3
	inc	a
	tam	#3	;Increases the bank!?
	vload	$3000,splash_gfx,#$1000
	tma	#3
	inc	a
	tam	#3	;Increases the bank!?
	vload	$4000,splash_gfx,#$1000
	tma	#3
	inc	a
	tam	#3	;Increases the bank!?
	vload	$5000,splash_gfx,#$1000
	tma	#3
	inc	a
	tam	#3	;Increases the bank!?
	vload	$6000,splash_gfx,#$1000
	tma	#3
	inc	a
	tam	#3	;Increases the bank!?
	vload	$7000,splash_gfx,#$1000

	set_bgpal #2,splash_pal,#4	; fill palette #2-5

	tma	#3
	inc	a
	tam	#3	;Increases the bank!?	
	batcpy $0A40,#64,splash_map,#64,#23	;512x184 image.

	rts



yres_224:
	st0 #$0C
	stw #$1702,video_data
	st0 #$0D
	stw #$00DF,video_data
	rts

yres_240:
	st0 #$0C
	stw #$0D02,video_data	;(was $0F02 for 239 lines)
	st0 #$0D
	stw #$00EF,video_data
	rts

xres_256:
	vreg	#$0A
	stw	#$0202,video_data
	vreg	#$0B
	stw	#$041F,video_data
	lda	#%00000100
	sta	$0400
	rts

xres_512:
	vreg	#$0A
	stw	#$0B02,video_data
	vreg	#$0B
	stw	#$043F,video_data
	lda	#%00000110
	sta	$0400
	rts

;*******************************************************************************
goto_line:	; print on the background

	add	#1		; line #1 of 29 (line #0 is not viewable)
	sta   <a_cnt

	cla			; line number in _di
	sta   <_di+1
	lda   <a_cnt
	sta   <_di

	aslw  <_di		; multiply by $40 chars/line, to find address
	aslw  <_di		; of start-of-line (use a 6-bit left-shift)
	aslw  <_di
	aslw  <_di
	aslw  <_di
	aslw  <_di

	jsr   set_write 	; set VRAM write address
	rts

;66666666666666666666666666666666666666666666666666
Check_Sixes:
	cmpw	#$6666,<x0_start
	bne	.noshowhowdy
	cmpw	#$6666,<x0_start+2
	bne	.noshowhowdy
	cmpw	#$6666,<y0_start
	bne	.noshowhowdy
	cmpw	#$6666,<y0_start+2
	bne	.noshowhowdy
	bra	.Show_Howdy
.noshowhowdy:
	stz	howdy
	jmp	.howdy_end
.Show_Howdy:
	lda	#$01
	sta	howdy

	stw	#$0000,<_di	;Clear the map!
	jsr	set_write
	ldy	#$08		
	clx
.clear_small_vram:
	st1	#$00
	st2	#$01	;Palette 0, char $100!
	dex
	bne	.clear_small_vram
	dey
	bne	.clear_small_vram

	map	howdychr0a
	vload	howdychr0a,#$0800
	vload	howdychr0b,#$0800
	map	howdychr1a
	vload	howdychr1a,#$0800
	vload	howdychr1b,#$0800
	map	howdychr2a
	vload	howdychr2a,#$0800
	vload	howdychr2b,#$0800

	map	howdypal
	set_bgpal #0,howdypal,#1	; fill palette #2-5

	bbs0	<horiz_res,.centre_image
	batcpy $0040,#64,howdybat,#32,#23	;256x184 image.
	bra	.howdy_end
.centre_image:
	batcpy $0050,#64,howdybat,#32,#23	;256x184 image.
.howdy_end:
	rts
;66666666666666666666666666666666666666666666666666

print_byte:	;Prints a byte to the screen.
	pha			; preserve
	lsr   a 		; use top nybble
	lsr   a
	lsr   a
	lsr   a
	ora	#$10		;point to font
	sta   video_data	; store char # (0-F) (LSB of VRAM word)
	st2   #$11		; MSB of VRAM word: palette #0, base addr $1000
.nextprintbyte
	pla			; restore byte
	and   #$0F		; use bottom nybble
	ora	#$10		;point to font
	sta   video_data	; store char # (0-F) (LSB of VRAM word)
	st2   #$11		; MSB of VRAM word: palette #0, base addr $1000
.nextprintbyte2
	rts

;**********************************
Print_All_Panels:
	stz	<tempidx	;0
.all_pans:
	jsr	Print_Panel_Num
	inc	<tempidx
	lda	<tempidx
	cmp	#$08		;Current limit!!!
	bne	.all_pans
	rts

Print_Panel_Num:	;INPUT: <tempidx for each number in panel
	pha
			;Prints the numbers in Panel
	ldx	<tempidx
	cpx	#$07		;If 7 (presets), don't do etc etc...
	beq	.print_pan_presets
	cpx	#$06		;If #6 (X-res), don't do the following.
	beq	.print_pan_xres
	cpx	#$05		;If #5 (Cycling), don't do the following.
	bne	.print_pan_normal
;------------------------
.colour_cycling:
	stw	#$098D,<_di
	jsr	set_write
	lda	<cycling
	asl	a
	asl	a		;Multiply by 4
	tax
	ldy	#$03
.draw_cyc_loop:
	lda	CycText,X
	sta	video_data
	st2	#$11
	inx
	dey
	bne	.draw_cyc_loop
	jmp	.print_pan_end
;------------------------
.print_pan_presets:
	stw	#$080D,<_di
	jsr	set_write
	lda	preset
;	and	#$0F		;Probably never more than 15!
	ora	#$10		;Change to text
	sta	video_data
	st2	#$11
	st1	#$20		;Print space
	st2	#$11
	asl	a
	asl	a
	asl	a
	asl	a	;Multiply by 16 (no need to clear top bit)
	tax
	ldy	#16
.write_pre0:
	lda	preset_text,X
	sta	video_data
	st2	#$11
	inx
	dey
	bne	.write_pre0
	jmp	.print_pan_end	
.print_pan_xres:
	stw	#$09CD,<_di
	jsr	set_write
	lda	<horiz_res
	asl	a
	asl	a		;Multiply by 4
	tax
	ldy	#$03
.draw_res_loop:
	lda	ResText,X
	sta	video_data
	st2	#$11
	inx
	dey
	bne	.draw_res_loop
	jmp	.print_pan_end
;---------------------
.print_pan_normal:
	lda	Cursor_Y_Pos_Tbl,X	;Get y-position (in pixels...)
	sta	<_di
	stz	<_di+1
	aslw	<_di		;We need to convert it to char lines
	aslw	<_di
	aslw	<_di		;(multiply by 8
	lda	Cursor_X_Pos_Tbl,X	;Get X-position (in pixels...)
	lsr	a		;We need to convert it to CHARs
	lsr	a
	lsr	a		;Divide by 8
	add	<_di
	sta	<_di
	lda	<_di+1
	adc	#$00
	sta	<_di+1		;Save as well.
	addw	#$0800,<_di	;Point to panel
	jsr	set_write
;-------------
;------------- OK, we set the position in VRAM, now go to variable
;-------------
	txa		;Transfer cursor back to A
	asl	a	;Point to RAM locations
	tax
	lda	Panel_RAM_Locations,X
	sta	<_si
	lda	Panel_RAM_Locations+1,X
	sta	<_si+1		;We have our writing value here.
	ldx	<tempidx
	lda	Curs_Limit_Tbl,X	;Get length of variables
	lsr	a			;Divide by 2
	dec	a			;eg. 16/2=8, now 7
	tay
.print_pan_loop:
	lda	[_si],Y		;Load the variable
	jsr	print_byte
	dey
	cpy	#$FF
	bne	.print_pan_loop
	bra	.print_pan_end
.print_pan_end:
;-------------- DONE!
	pla
	rts

ResText: .db "256 512 "
CycText: .db "OFF >   >>  <<  <   "




IncPanelValue:
	lda	<cursy
	cmp	#7	;Is it presets?
	bne	.no_inc_preset
;------------------- Option 7: Load presets!
	inc	preset
	lda	preset
	cmp	PRESETMAX
	bne	.no_resetpreset
	stz	preset
.no_resetpreset:
	jsr	Copy_Presets	;Copy Preset Variables
	jmp	.incpan_end
.no_inc_preset:
	cmp	#6	;is it resolution?
	bne	.no_inc_res
;------------------- Option 6: change resolutions!
	lda	<horiz_res
	eor	#$01
	sta	<horiz_res	;Invert horiz. res
	jsr	Setup_Horizontal_Res_Vars
	jmp	.incpan_end
.no_inc_res:
	cmp	#5	;is it cycling?
	bne	.no_inc_cycle
	inc	<cycling
	lda	<cycling
	cmp	#$5		;only 4 types of cycling, plus off
	bne	.no_reset_cycling
	stz	<cycling
.no_reset_cycling:
	jmp	.incpan_end
.no_inc_cycle:
;--------------------------------
;-------------------- OK, first we have to point to the RAM location that
; we want to increase, as well as choose the value to increase.
;--------------------------------
	lda	<cursy
	asl	a	;Point to RAM locations
	tax
	lda	Panel_RAM_Locations,X
	sta	<_si
	lda	Panel_RAM_Locations+1,X
	sta	<_si+1		;We have our writing value here.
	ldx	<cursy
	lda	Curs_Limit_Tbl,X	;Get length of variables
					;eg. 8
;------------------------- this is something separate
	pha
	lsr	a			;Divide by 2
;	dec	a			;eg. 16/2=8
					;we want to stop at REG+1
	sta	<tempidx		;Save as an index
	pla
;---------------------------------------------------------
	sub	<cursx			;Subtract current cursor
					;eg. max 7
	dec	a			;8-7=1 so, make it 0.
					;so range is now 0..7 or so
	pha
	lsr	a	;Divide by 2
	tay		;Now editing RAM addresses, not nybbles
			;Y will be the pointer, as well as counter
	pla
	and	#$01	;Test if low nybble or high nybble
	beq	.add_low_nyb
	lda	#$0F	;High nybble
.add_low_nyb:
	add	#$01	;Make it 01 or 10
	sta	<tempvar1
;============================ now, let's do it!
	lda	[_si],Y		;Load the variable
	add	<tempvar1	;Add 01 or 10
	sta	[_si],Y		;Save it back
.add_pan_ram_loop:
	php	;Is it necessary to push the Carry flag?
	iny
	cpy	<tempidx	;If the index is too high, bail
	beq	.add_pan_ram_end
	plp
	lda	[_si],Y		;Load the variable
	adc	#$00		;Propagate the carry.
	sta	[_si],Y		;Save it back
	bra	.add_pan_ram_loop
.add_pan_ram_end:
	plp	;(I hope this is OK!)
;---- So now we've added a value to any variable in RAM.

.incpan_end:
	lda	<cursy
	sta	<tempidx
	cmp	#7
	bne	.dont_redraw_all	;Is it a preset?
	jsr	Print_All_Panels	;If so, redraw everything!
	smb0	<restart_flag	;Restart fractal
	bra	.no_redraw
;---------------
.dont_redraw_all:
	jsr	Print_Panel_Num		;Print changes
	cmp	#4		;Is the panel number 4 (FULL ITER)?
	beq	.no_redraw
	cmp	#5		;Is the panel number 5 (Cycling)?
	beq	.no_redraw
	smb0	<restart_flag	;Restart fractal with every change(??)
.no_redraw:
	rts

;********************


DecPanelValue:
	lda	<cursy
	cmp	#7	;Is it presets?
	bne	.no_dec_preset
;------------------- Option 7: Load presets!
	dec	preset
	lda	preset
	cmp	#$FF
	bne	.no_looppreset
	lda	PRESETMAX
	dec	a
	sta	preset
.no_looppreset:
	jsr	Copy_Presets	;Copy Preset Variables
	jmp	.decpan_end
.no_dec_preset:
	cmp	#6	;is it resolution?
	bne	.no_dec_res
;------------------- Option 6: change resolutions!
	lda	<horiz_res
	eor	#$01
	sta	<horiz_res	;Invert horiz. res
	jsr	Setup_Horizontal_Res_Vars
	jmp	.decpan_end
.no_dec_res:
	cmp	#5	;is it cycling?
	bne	.no_dec_cycle
	dec	<cycling
	lda	<cycling
	cmp	#$FF		;only 4 types of cycling, plus off
	bne	.no_reset_cycling
	lda	#$04
	sta	<cycling
.no_reset_cycling:
	jmp	.decpan_end
.no_dec_cycle:
;--------------------------------
;-------------------- OK, first we have to point to the RAM location that
; we want to decrease, as well as choose the value to decrease.
;--------------------------------
	lda	<cursy
	asl	a	;Point to RAM locations
	tax
	lda	Panel_RAM_Locations,X
	sta	<_si
	lda	Panel_RAM_Locations+1,X
	sta	<_si+1		;We have our writing value here.
	ldx	<cursy
	lda	Curs_Limit_Tbl,X	;Get length of variables
					;eg. 8
;------------------------- this is something separate
	pha
	lsr	a			;Divide by 2
;	dec	a			;eg. 16/2=8
					;we want to stop at REG+1
	sta	<tempidx		;Save as an index
	pla
;---------------------------------------------------------
	sub	<cursx			;Subtract current cursor
					;eg. max 7
	dec	a			;8-7=1 so, make it 0.
					;so range is now 0..7 or so
	pha
	lsr	a	;Divide by 2
	tay		;Now editing RAM addresses, not nybbles
			;Y will be the pointer, as well as counter
	pla
	and	#$01	;Test if low nybble or high nybble
	beq	.dec_low_nyb
	lda	#$0F	;High nybble
.dec_low_nyb:
	add	#$01	;Make it 01 or 10
	sta	<tempvar1
;============================ now, let's do it!
	lda	[_si],Y		;Load the variable
	sub	<tempvar1	;Sub 01 or 10
	sta	[_si],Y		;Save it back
.sub_pan_ram_loop:
	php	;Is it necessary to push the Carry flag?
	iny
	cpy	<tempidx	;If the index is too high, bail
	beq	.sub_pan_ram_end
	plp
	lda	[_si],Y		;Load the variable
	sbc	#$00		;Propagate the carry.
	sta	[_si],Y		;Save it back
	bra	.sub_pan_ram_loop
.sub_pan_ram_end:
	plp	;(I hope this is OK!)
;---- So now we've added a value to any variable in RAM.

.decpan_end:
	lda	<cursy
	sta	<tempidx
	cmp	#7
	bne	.dont_redraw_all	;Is it a preset?
	jsr	Print_All_Panels	;If so, redraw everything!
	smb0	<restart_flag	;Restart fractal
	bra	.no_redraw
;---------------
.dont_redraw_all:
	jsr	Print_Panel_Num		;Print changes
	cmp	#4		;Is the panel number 4?
	beq	.no_redraw
	cmp	#5		;Is the panel number 5 (Cycling)?
	beq	.no_redraw
	smb0	<restart_flag	;Restart fractal with every change(??)
.no_redraw:
	rts

Panel_RAM_Locations:
	.dw x0_start,y0_start,x_zoom,itermaxpv,itermaxfu


Setup_Horizontal_Res_Vars:
	bbs0	<horiz_res,.reso_512
.reso_256:
	jsr	xres_256
	bbs0	<quality,.hq256	;If high-quality, branch
	stw	#32,<xres	;X res is 32 bytes for now
	stw	#30,<yres	;Y res is 28 lines
	bra	.setup_end
.hq256:
	stw	#256,<xres	;X res is 256 pixels for now
	stw	#240,<yres	;Y res is 240 lines
	bra	.setup_end
.reso_512:
	jsr	xres_512
	bbs0	<quality,.hq512	;If high-quality, branch
	stw	#64,<xres	;X res is 64 bytes for now
	stw	#30,<yres	;Y res is 28 lines
	bra	.setup_end
.hq512:
	stw	#512,<xres	;X res is 512 pixels for now
	stw	#240,<yres	;Y res is 240 lines
.setup_end:
	rts

Update_Satb_BLOCKTRANSFER:
	stw   #$7F00,<_di	;Default SATB location
	jsr	set_write	;Load up into latch
	tia   satb,$0002,$0200	;BLOCK TRANSFER INSTRUCTION!
				;Block transfer 512 bytes...
				;from RAM to VRAM thru $0002!
			;MUCH more efficient than the MagicKit code!
	rts