Init_Fractal_Vars:
;	stw	#$10,<itermaxpv	;Max iterations = 16.
;	stw	#$10,<itermaxfu ; for full render
	jsr	Setup_Horizontal_Res_Vars
	stw	#30,<yres	;Y res is 28 lines
	jsr	Copy_Presets	;see below :-)
	rts

Copy_Presets:	;Copies the preset fractal variables!
	phx
	phy

	lda	preset		;Which preset?
	beq	.nodomath	;(a shortcut)
	asl	a		;Multiply by 2
	asl	a		;4
	sta	<_al		;Store temporarily
	asl	a		;8
	asl	a		;16
	add	<_al		;16+4 = 20 (that's how many bytes we have!)
.nodomath:
	tay			;One index...
	ldx	#20		;20 (hex $14) bytes to copy
.copy_pres0:
	lda	preset_bytes,Y
	sta	<x0_start-1,X	;(20..1 instead of 19..0)
	iny
	dex
	bne	.copy_pres0

	ply
	plx
	rts


Init_Fractal:
	rmb0	<period_test	;No periodicity (here????)
	stw	<itermaxpv,<itermax	;Preview first
	bbr0	<quality,.iter_quality
	stw	<itermaxfu,<itermax	;Preview first
.iter_quality:
	stw	<yres,<multpart1
	stw	<xres,<multpart2
	stwz	<multpart1+2
	stwz	<multpart2+2
	jsr	Multiply_32x32		;Multiply X, Y resolution
	stw	<multresult,<remaining	;Remaining dots ($E000 max!)


;------------
	stw	<x_zoom,<DVDQUO
	stw	<x_zoom+2,<DVDQUO+2
	stw	<x_zoom+4,<DVDQUO+4	;Clear 48 bits decimal
	stw	<x_zoom+6,<DVDQUO+6	;top 16 bits = 4.0
	stw	<xres,<DVDR+3	;Store divisor in high 16 bits
	stwz	<DVDR
	stz	<DVDR+2		;Clear low bits
	stwz	<DVDR+5
	stz	<DVDR+7		;Clear high parts too!
	jsr	DIVIDE		;Divide 4.0 by XRES
	stw	<DVDQUO,<x0_step
	stw	<DVDQUO+2,<x0_step+2	;Copy 32-bit result
;------------
	stw	<x_zoom,<DVDQUO		;NOW ONLY 1 ZOOM FACTOR!
	stw	<x_zoom+2,<DVDQUO+2
	stw	<x_zoom+4,<DVDQUO+4	;Clear 48 bits decimal
	stw	<x_zoom+6,<DVDQUO+6	;top 16 bits = 4.0
	stw	<yres,<DVDR+3	;Store divisor in high 16 bits
	stwz	<DVDR
	stz	<DVDR+2		;Clear low bits
	stwz	<DVDR+5
	stz	<DVDR+7		;Clear high parts too!
	jsr	DIVIDE		;Divide 3.0 by YRES
	;I took out a negation here.  Why was it necessary?
	stw	<DVDQUO,<y0_step
	stw	<DVDQUO+2,<y0_step+2	;Copy 32-bit result
;------------
	stw	<y0_start,<y0
	stw	<y0_start+2,<y0+2	;Init Intial y0
	stwz	<py	;Y starts at 0 to start at the top of the screen.
	rts

;@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@

Generate_Fractal:
.yloop:
	stw	<x0_start,<x0
	stw	<x0_start+2,<x0+2
	stw	<xres,<px	;Init initial X!
.xloop:
	stw	<x0,<x_val
	stw	<x0+2,<x_val+2
	stw	<y0,<y_val
	stw	<y0+2,<y_val+2
	stwz	<iteration
;-------
; check SQUARE(X) + SQUARE(Y) >= 4	(DISABLED FOR A SPEEDUP?)
;	stw	<x_val,<multpart1
;	stw	<x_val+2,<multpart1+2
;	jsr	Square_32x32	;Square X!
;	stw	<multresult,<TEMP64A	;Store 32? 64-bit?
;	stw	<multresult+2,<TEMP64A+2
;	stw	<multresult+4,<TEMP64A+4
;	stw	<multresult+6,<TEMP64A+6
;	stw	<y_val,<multpart1
;	stw	<y_val+2,<multpart1+2
;	jsr	Square_32x32	;Square Y!
;	addw	<multresult,<TEMP64A
;	adcw	<multresult+2,<TEMP64A+2
;	adcw	<multresult+4,<TEMP64A+4
;	adcw	<multresult+6,<TEMP64A+6
;	cmpw	#$0004,<TEMP64A+5
;	beq	.toSkip
;	bcc	.toSkip
;	bra	.IterLoop
;.toSkip:
;	jmp	.SkipIterLoop
;-------
.IterLoop:
	stw	<x_val,<multpart1
	stw	<x_val+2,<multpart1+2
	jsr	Square_32x32		;Square X!
	stw	<multresult+5,<xx+2
	stw	<multresult+3,<xx
	stw	<y_val,<multpart1
	stw	<y_val+2,<multpart1+2
	jsr	Square_32x32		;Square Y!
;	stw	<multresult+5,<yy+2	;save to YY eliminated! 
;	stw	<multresult+3,<yy	;For the sake of optimization
	lda	<xx
	add	<multresult+3		;(Was add <yy)
	sta	<xx_yy
	lda	<xx+1
	adc	<multresult+4		;(was <yy+1)
	sta	<xx_yy+1
	lda	<xx+2
	adc	<multresult+5		;(was <yy+2)
	sta	<xx_yy+2
	lda	<xx+3
	adc	<multresult+6		;(was <yy+3)
	sta	<xx_yy+3	;Add the two and save in xx_yy
;---
	lda	<xx
	sec
	sbc	<multresult+3	;<yy	;Subtract YY
	sta	<xtemp
	lda	<xx+1
	sbc	<multresult+4	;<yy+1
	sta	<xtemp+1
	lda	<xx+2
	sbc	<multresult+5	;<yy+2
	sta	<xtemp+2
	lda	<xx+3
	sbc	<multresult+6	;<yy+3
	sta	<xtemp+3
	addw	<x0,<xtemp
	adcw	<x0+2,<xtemp+2	;And add x0, whatever that does.
;---
	stw	<x_val,<multpart1
	stw	<x_val+2,<multpart1+2
	stw	<y_val,<multpart2
	stw	<y_val+2,<multpart2+2
	jsr	Multiply_32x32		;Include the shift here!!!
	lda	<multresult+3		;Get 8.24 of 16.48!
	add	<y0
	sta	<y_val
	lda	<multresult+4
	adc	<y0+1
	sta	<y_val+1
	lda	<multresult+5
	adc	<y0+2
	sta	<y_val+2
	lda	<multresult+6
	adc	<y0+3
	sta	<y_val+3
;----
	stw	<xtemp,<x_val
	stw	<xtemp+2,<x_val+2
	incw	<iteration
	bbr0	<period_test,.no_check_periods
	jsr	Check_Periods	;****VERY IMPORTANT****
.no_check_periods:

; - TEST
;****   if(iteration < ITERMAX && xx_yy < TOFIXED(2 * 2)) ****
; -
	lda	<xx_yy+3	;Get integer portion
	cmp	#$04
	beq	.SkipIterLoop	;If equal, bail
	bpl	.SkipIterLoop	;If greater, bail
	cmpw	<iteration,<itermax	;Is iteration = itermax?
	beq	.Iter_Clear		;if so, finish!
	bbs0	<restart_flag,.Early_End	;Draw Aborted!
	jmp	.IterLoop
.Iter_Clear:
;----------- here we reached black (infinite iterations!)
	jsr	Setup_Period_Test
	stwz	<iteration	;Colour is set to black
	bra	.Skip_period_clear
;-------
.SkipIterLoop:
	rmb0	<period_test	;No periodicity (here????)
.Skip_period_clear:
	jsr	PutPixel
	decw	<remaining
;---
	addw	<x0_step,<x0
	adcw	<x0_step+2,<x0+2
	decw	<px	;Decrement X-counter
	lda	<px
	ora	<px+1	;Check if both 0!
	beq	.endofxstep
	jmp	.xloop
.endofxstep:

	addw	<y0_step,<y0
	adcw	<y0_step+2,<y0+2
	incw	<py	;Increment Y-counter
	cmpw	<py,<yres
	beq	.endofystep
	jmp	.yloop
.endofystep:

.Early_End:
	rts

;@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@
;@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@
;@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@
;@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@
;@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@
;	The periodicity test will greatly speed up calculation
;	of pixels inside of the black space!

Setup_Period_Test:
	stwz	<per_aX
	stwz	<per_aX+2
	stwz	<per_aY
	stwz	<per_aY+2
	lda	#$01
	sta	<period		;Initialize period values
	lda	#$03
	sta	<per_check
	smb0	<period_test	;but next time check for perodicity!!!
	rts

Check_Periods:
	lda	<per_aX
	cmp	<x_val		;x AND y must all be equal!
	bne	no_periodicity_0
	lda	<per_aY
	cmp	<y_val
	bne	no_periodicity_0
	lda	<per_aX+1
	cmp	<x_val+1		;x AND y must all be equal!
	bne	no_periodicity_0
	lda	<per_aY+1
	cmp	<y_val+1
	bne	no_periodicity_0
	lda	<per_aX+2
	cmp	<x_val+2		;x AND y must all be equal!
	bne	no_periodicity_0
	lda	<per_aY+2
	cmp	<y_val+2
	bne	no_periodicity_0
	lda	<per_aX+3
	cmp	<x_val+3		;x AND y must all be equal!
	bne	no_periodicity_0
	lda	<per_aY+3
	cmp	<y_val+3
	bne	no_periodicity_0
;---------- at this point, they're BOTH equal!
	stw	<itermax,<iteration	;A cheat to skip to the end
	rts

no_periodicity_0:
	inc	<period
	lda	<per_check
	cmp	<period		;is (check - period) negative?
	bcs	.no_increase_check
	asl	<per_check	;Multiply by 2, for some reason
	lda	#$01
	sta	<period
	stw	<x_val,<per_aX
	stw	<x_val+2,<per_aX+2
	stw	<y_val,<per_aY
	stw	<y_val+2,<per_aY+2
.no_increase_check:
	rts

