/*
	GBAhi v0.3 (Gameboy Advance Header Info)
		by Meij <meijie@gmail.com>

	Note: GBAhi has been tested on both msvc++ 6 and gcc
		  (on freebsd, linux & windows), so it should
		  compile on any POSIX compliant compiler

		  The intro checking is by no means accurate
		  it is probably worth just ignoring it. I
		  added it by request not because i want it
		  and i doubt i will bother improoving it.

	Todo:
		- more accurate save searching
		  - same method, just maybe scan for multiple entrys
		    print all if they dont match.
		  - once there a match count past till you get to a non
		    printable character (not A-Z 0-9 _, and possibly a-z)
		- add real time clock searching
		- keep it portable

	2004-11-04 (v0.3)
	    - fixed the 'unable to open file' error output
	    - fixed output to only be 1 line when useing the -o option
		- added mingw makefile.bat

	2004-09-12 (v0.2)
		- cleaned up code and fixed some core dumps
		- split up into gbahi.c/h
		- added command line arguments
		- added crc32, save type (bit sketchy), megabit and size output

	2004-05-29 (v0.1)
		- initial version

	CRC32 code borrowed from Glenn Rhoads
		Url: http://remus.rutgers.edu/~rhoads/Code/crc-32b.c
 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "gbahi.h"

int main(int argc, char * argv[])
{
	FILE *fp;
	int i, j, a, z;
	gba_header header;
	char *buffer, *b;
	unsigned long s;

	if (argc < 2) usage(argv[0]);

	for (a = 1; a < argc; a++)
	{
		if (argv[a][0] == '-')
		{
			switch ( argv[a][1] )
			{
				case 'c':
					arg_crc = 1;
					break;
				case 's':
					arg_save = 1;
					break;
				case 'o':
					arg_short = 1;
					break;
				default:
					printf("Unknown option: %s\n", argv[a]);
					exit(1);
			}
		}
	}

	if ((fp = fopen(argv[a-1], "rb")) != NULL)
	{
		if (arg_short != 1)
			printf("GBAhi v%s (Gameboy Advance Header Info)\n\n", PROGRAM_VERSION);
		
		memset(&header, 0, sizeof(gba_header));
		header.intro = 0;
		header.crc = 0x00000000;
		strcpy(header.savetype, "n/a");
		fread(&header.entrypoint, sizeof(char), 4, fp);
		fread(&header.nintendologo, sizeof(char), 156, fp);
		fread(&header.gametitle, sizeof(char), 12, fp);
		fread(&header.gamecode, sizeof(char), 4, fp);
		fread(&header.makercode, sizeof(char), 2, fp);
		fread(&header.fixedvalue, sizeof(char), 1, fp);
		fread(&header.mainunitcode, sizeof(char), 1, fp);
		fread(&header.devicetype, sizeof(char), 1, fp);
		fread(&header.lreservedarea, sizeof(char), 7, fp);
		fread(&header.version, sizeof(char), 1, fp);
		fread(&header.complement, sizeof(char), 1, fp);
		fread(&header.sreservedarea, sizeof(char), 3, fp);
		if (arg_crc == 1)
		{
			fseek (fp , 0 , SEEK_SET);
			gen_table();
			header.crc = get_crc(fp);
		}
		else fseek (fp , 0 , SEEK_END);
		header.size = ftell(fp);
		if (arg_save == 1)
		{
			strcpy(header.savetype, "None");
			fseek(fp , 0 , 0);
			buffer = (char *)malloc(header.size);
			fread(buffer, sizeof(char), header.size, fp);
			b = buffer;
			for(s = 0; s < header.size; s++)
			{
				for (z = 0; z < 5; z++)
				{
					if(*b == save_types[z][0])
					{
						if(cmp(b, save_types[z], strlen(save_types[z])))
						{
							fseek(fp, b - buffer, SEEK_SET);
							fread(header.savetype, sizeof(char), 15, fp);
							z = 0;
							break;
						}

					}
				}
				b++;
				if (z == 0) break;
			}
		}
		fclose(fp);

		if (header.size > 0)
			header.mbits = ((float) header.size / 1048576 * 8);
		else header.mbits = 0;

		i = 0;
		while ( (country_number[i] != header.gamecode[3]) && (country_number[i] != 0) )
			i++;

		j = 0;
		while ( (strcmp(maker_letter[j], header.makercode)) && (strcmp(maker_letter[j], "\0"))  )
			j++;

		if (strlen(header.gamecode) == 0) strcpy(header.gamecode, "????\0");

		if ((header.entrypoint != 0xEA00002E) && (header.entrypoint != 0xEA00007F))
			header.intro = 1;

		if (arg_short == 0)
		{
			printf("Internal Name:  %s\n"
				"Developer:      %s (%s)\n"
				"Serial:         AGB-%s-%s\n"
				"Save:           %s\n"
				"Version:        1.%.2X\n"
				"CRC32:          0x%08X\n"
				"Complement:     0x%02X\n"
				"Size:           %iMB (%0.fMb)\n"
				"Fixed Value:    0x%.2X (0x96)\n"
				"Main Unit Code: 0x%.2X\n"
				"Entrypoint:     0x%.8X\n"
				"Intro:          %s\n"
				"Device Type:    0x%.2X\n",
				header.gametitle, maker_name[j],
				header.makercode, header.gamecode,
				country_code[i], header.savetype,
				header.version, header.crc,
				header.complement, header.size / 1048576,
				header.mbits, header.fixedvalue,
				header.mainunitcode, header.entrypoint,
				(header.intro == 1)?("Yes"):("No"), header.devicetype);
		}
		else {
			printf("%s~AGB-%s-%s~%s~%08X~%s~%i~%.f~1.%X~%02X~%i~%08X\n", header.gametitle, header.gamecode, country_code[i],
				header.savetype, header.crc, maker_name[j], header.size, header.mbits, header.version, header.complement,
				header.intro, header.entrypoint);
		}
	}
	else
	{
		fprintf(stderr, "Error, unable to open: %s\n", argv[a-1]);
		exit(1);
	}
	exit(0);
}

void usage(char * argv)
{
	char * fn;
	char file[FILELEN];

	fn = strtok(argv, "\\/");
	sprintf(file, "%s", fn);
	while ((fn = strtok(NULL, "\\/")) != NULL)
		sprintf(file, "%s", fn);

	printf("Usage: %s [options] <filename.gba>\n", file);
	printf("   -c   calculate crc32\n"
		   "   -o   display info in short form\n"
		   "   -s   find savetype\n\n");
	printf("Send bugs or comments to Meij <meijie@gmail.com>\n");
	exit(1);
}

void gen_table(void)
{
	unsigned long crc, poly;
	int	i, j;

	poly = 0xEDB88320L;
	for (i = 0; i < 256; i++)
	{
		crc = i;
		for (j = 8; j > 0; j--)
		{
			if (crc & 1)
				crc = (crc >> 1) ^ poly;
			else
				crc >>= 1;
		}
		crc_table[i] = crc;
	}
}

unsigned long get_crc(FILE *fp)
{
	register unsigned long crc;
	int ch;

	crc = 0xFFFFFFFF;
	while ((ch = getc(fp)) != EOF)
		crc = (crc>>8) ^ crc_table[ (crc^ch) & 0xFF ];

	return( crc^0xFFFFFFFF );
}

int cmp(char *s1, char *s2, int len)
{
    while(len)
    {
        if(*s1 != *s2)
            break;

        s1++;
        s2++;
        len--;
    }
    return(!len);
}

