// Game Boy camera utility to convert three 5-bit greyscale images produced
// by camera.exe to a 24-bit (only 15-bits used) colored BMP.
// By Victor Kemp, July 2000.
// vkemp@paradise.net.nz
// http://homepages.paradise.net.nz/vkemp/gbcam.htm


#include <conio.h>
#include <stdio.h>
#include <dos.h>
#include <string.h>
#include <io.h>
#include <fcntl.h>
#include <sys\stat.h>
#include <stdlib.h>

#define TRUE  1
#define FALSE 0

unsigned char imager[128*123];
unsigned char imageg[128*123];
unsigned char imageb[128*123];

unsigned char bmpheader[54] = {0x42,0x4D,0xB6,0xB8,0x00,0x00,0x00,0x00,0x00,
			       0x00,0x36,0x00,0x00,0x00,0x28,0x00,0x00,0x00,
			       0x80,0x00,0x00,0x00,0x7B,0x00,0x00,0x00,0x01,
			       0x00,0x18,0x00,0x00,0x00,0x00,0x00,0x80,0xB8,
			       0x00,0x00,0xC4,0x0E,0x00,0x00,0xC4,0x0E,0x00,
			       0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00};




//############################################################################
//############################################################################
// Reads a 128*123 greyscale 8-bit .BMP into the specified array.
void readbmp(char *filename, unsigned char *image){

 int handle;
 int filepos;

 handle = open(filename, O_BINARY | O_RDONLY, S_IREAD);

 if(handle == -1) printf("Cannot read input file %s\n", filename);
 else{

  lseek(handle, 54+(256*4), SEEK_SET); // Skip over the header and pallete

  read(handle, image, 128*123);

  close(handle);
 }


}
//############################################################################
//############################################################################
// Shift each byte in the array left by 3 bits.
void shiftleft(unsigned char *image){

 int pixelnum;

 for(pixelnum = 0; pixelnum < 128*123; pixelnum++)
 image[pixelnum] = image[pixelnum] << 3;

}
//############################################################################
//############################################################################
// Saves the data in imager, imageg, imageb as a 24-bit BMP.
void savebmp(char *bmpname){

 int handle;
 int pixelnum;

 // Open file
 unlink(bmpname); // Delete it first, because buggered if I can get O_TRUNC to work.
 handle = open(bmpname, O_CREAT | O_BINARY | O_WRONLY, S_IWRITE);
 if(handle == -1) printf("Cannot create image file %s\n", bmpname);
 else{

  // Write header
  write(handle, bmpheader, sizeof(bmpheader));

  // Write image
  for(pixelnum = 0; pixelnum < 128*123; pixelnum++){
   write(handle, &imageb[pixelnum], 1);
   write(handle, &imageg[pixelnum], 1);
   write(handle, &imager[pixelnum], 1);
  }

  // Close file
  close(handle);
 }


}
//############################################################################
//############################################################################
// Main function.
void main(int numargs, char **args){


 char filer[256];
 char fileg[256];
 char fileb[256];


 clrscr();

 if(numargs == 4){
  strcpy(filer, args[1]);
  strcpy(fileg, args[2]);
  strcpy(fileb, args[3]);
 }

 else{
  printf("              Game Boy Camera greyscale -> RGB converter.\n");
  printf(" vkemp@paradise.net.nz    http://homepages.paradise.net.nz/~vkemp/gbcam.htm\n\n");


  printf("usage:     RGB redfile greenfile bluefile\n\n");

  printf("redfile, greenfile and bluefile are the names of .BMP files generated by\n");
  printf("the CAMERA.EXE program. A 24-bit BMP is created with the images in these\n");
  printf("three files as the red, green and blue components. They are assumed\n");
  printf("to be 128*123*256 greyscale BMPs with only the first 32 colors used.\n\n");

  printf("eg:        RGB CAM00005.BMP CAM00012.BMP CAM00014.BMP\n\n");

  printf("Output is put in RGB.BMP\n");

  delay(500);
  exit(1);
 }


 printf("combining %s, %s and %s into RGB.BMP\n", filer, fileg, fileb);

 readbmp(filer, imager);
 readbmp(fileg, imageg);
 readbmp(fileb, imageb);

 // Shift each byte left three so the colors aren't all dark.
 shiftleft(imager);
 shiftleft(imageg);
 shiftleft(imageb);

 savebmp("rgb.bmp");


}

