
	;;
	;; Display MODE B0 example
	;;
	;; Developed on WinAPE assembler
	;;

	LET	SAVE_DSK = 0		;; to save example on DSK

	RUN	start

	NOLIST

	IF 	SAVE_DSK
		WRITE DIRECT "A:DMODEB.BIN"
	ELSE
		WRITE DIRECT -1,-1,#c0
	ENDIF

	ORG	&8000
start
	di

	ld	bc,&7f8c + 0		;; set scr mode 0
	out	(c),c

	ld	hl,palette		;; set scr palette
	call	setPalette

mainLoop
	call	wVb

	ld	bc,&bc0c		;; video page switch (#c000 / #4000)
	out	(c),c
	inc	b
	ld	a,(CRTCReg12)
	out	(c),a
	xor	&20
	ld	(CRTCReg12),a

	jr	mainLoop

	;; Set Palette

setPalette
	xor	a
	ld	bc,#7f11
setPalette_loop
	out	(c),a
	inc	b
	outi
	inc	a
	cp	c
	jr	nz,setPalette_loop
	ret

	;; Wait vertical blank

wVb
	ld 	b,#f5
vbLoop1
	in 	a,(c)
        rra
        jr 	c, vbLoop1
vbLoop2
	in 	a,(c)
        rra
        jr 	nc, vbLoop2
	ret

	;; Data

CRTCReg12	db	&30
palette		db 	&54, &5c, &4c, &4e, &4a, &43, &5e, &56, &42, &59, &5a, &46, &5b, &47, &40, &4b
border		db	&54

	;; Screen

	IF 	SAVE_DSK
		WRITE DIRECT "A:SHADOW.RWE"
	ENDIF

	ORG	&4000

	incbin "shadow.rwe"		;; even screen frame

	IF 	SAVE_DSK
		WRITE DIRECT "A:SHADOW.RWO"
	ENDIF

	ORG	&c000

	incbin "shadow.rwo"		;; odd screen frame
