/*
 * Decompiled with CFR 0.152.
 */
package perfectpix;

import java.io.ByteArrayInputStream;
import java.io.DataInputStream;

public class PPH {
    public static final int PPH_MODE_R = 3;
    public static final int PPH_MODE_B0 = 4;
    public static final int PPH_MODE_B1 = 5;
    public int mode;
    public int width;
    public int height;
    public int widthBytes;
    public int frameSize;
    public int nPalettes;
    public byte[] palettes;
    private static byte[] of = new byte[16384];

    public PPH(byte[] header) throws Exception {
        int nColorsPerPal;
        ByteArrayInputStream bai = new ByteArrayInputStream(header);
        DataInputStream dis = new DataInputStream(bai);
        this.mode = dis.readUnsignedByte();
        this.width = dis.readUnsignedByte() + dis.readUnsignedByte() * 256;
        this.height = dis.readUnsignedByte() + dis.readUnsignedByte() * 256;
        this.nPalettes = dis.readUnsignedByte();
        System.out.println("mode = " + this.mode);
        System.out.println("width = " + this.width);
        System.out.println("height = " + this.height);
        this.widthBytes = this.width / 4;
        this.frameSize = this.widthBytes * this.height;
        switch (this.mode) {
            case 3: 
            case 4: {
                nColorsPerPal = 16;
                break;
            }
            default: {
                nColorsPerPal = 4;
            }
        }
        byte[][] pals = new byte[this.nPalettes][];
        pals[0] = new byte[nColorsPerPal];
        dis.readFully(pals[0]);
        for (int i = 1; i < this.nPalettes; ++i) {
            pals[i] = new byte[nColorsPerPal - 1];
            dis.readFully(pals[i]);
        }
        dis.close();
    }

    public boolean twoBanks(int offset) {
        return offset + this.frameSize > 16384;
    }

    public byte[][] getRAW(boolean forceFragment, int offset, byte[] src) {
        int nf;
        boolean overscan;
        boolean bl = overscan = this.frameSize > 16384;
        if (overscan) {
            nf = offset > 0 ? 16 : 9;
        } else {
            if (this.twoBanks(offset)) {
                return null;
            }
            nf = forceFragment ? 8 : 1;
        }
        byte[][] des = new byte[nf][];
        switch (nf) {
            case 1: {
                this.getOrderedFrame(src, 0, 2048);
                int fsize = this.frameSize / 8;
                des[0] = new byte[14336 + fsize];
                int f = 0;
                int pos = 0;
                while (f < 8) {
                    System.arraycopy(of, pos, des[0], pos, fsize);
                    ++f;
                    pos += 2048;
                }
                break;
            }
            case 8: {
                this.getOrderedFrame(src, 0, 2048);
                int fsize = this.frameSize / 8;
                int f = 0;
                int pos = 0;
                while (f < 8) {
                    des[f] = new byte[fsize];
                    System.arraycopy(of, pos, des[f], 0, fsize);
                    ++f;
                    pos += 2048;
                }
                break;
            }
            case 9: {
                this.getOrderedFrame(src, 0, 2048);
                des[0] = new byte[16384];
                System.arraycopy(of, 0, des[0], 0, 16384);
                int sbo = 16384 / this.widthBytes / 8 * 8 * this.widthBytes;
                int fbr = (16384 - sbo) / 8;
                byte[] srcb = new byte[src.length - sbo];
                System.arraycopy(src, sbo, srcb, 0, srcb.length);
                int fsize = srcb.length / 8 - fbr;
                this.getOrderedFrame(srcb, fbr, fsize);
                int f = 1;
                int pos = 0;
                while (f < 9) {
                    des[f] = new byte[fsize];
                    System.arraycopy(of, pos, des[f], 0, fsize);
                    ++f;
                    pos += 2048;
                }
                break;
            }
            case 16: {
                int fsize = 2048 - offset;
                this.getOrderedFrame(src, 0, fsize);
                int f = 0;
                int pos = 0;
                while (f < 8) {
                    des[f] = new byte[fsize];
                    System.arraycopy(of, pos, des[f], 0, fsize);
                    ++f;
                    pos += 2048;
                }
                int sbo = (16384 - offset * 8) / this.widthBytes / 8 * 8 * this.widthBytes;
                int fbr = (16384 - sbo) / 8 - offset;
                byte[] srcb = new byte[src.length - sbo];
                System.arraycopy(src, sbo, srcb, 0, srcb.length);
                fsize = srcb.length / 8 - fbr;
                if (fsize > 2048) {
                    return null;
                }
                this.getOrderedFrame(srcb, fbr, fsize);
                f = 8;
                pos = 0;
                while (f < 16) {
                    des[f] = new byte[fsize];
                    System.arraycopy(of, pos, des[f], 0, fsize);
                    ++f;
                    pos += 2048;
                }
                break;
            }
        }
        return des;
    }

    private byte[] getOrderedFrame(byte[] src, int srcPos, int flimit) {
        int off = srcPos;
        int o_srcPos = srcPos;
        int o_desPos = 0;
        int fcopied = 0;
        int desPos = o_desPos;
        while (desPos < 16384 && srcPos < src.length) {
            int len = this.widthBytes;
            if (off == 0) {
                System.arraycopy(src, srcPos, of, desPos, len);
            } else {
                System.arraycopy(src, srcPos, of, desPos, len - off);
                System.arraycopy(src, srcPos + 8 * this.widthBytes - off, of, desPos + len - off, off);
            }
            desPos += len;
            srcPos += 8 * this.widthBytes;
            if ((fcopied += len) + this.widthBytes <= flimit) continue;
            len = Math.min(flimit - fcopied, src.length - srcPos);
            if (len > 0) {
                System.arraycopy(src, srcPos, of, desPos, len);
            }
            desPos = o_desPos += 2048;
            srcPos = o_srcPos += this.widthBytes;
            fcopied = 0;
        }
        return of;
    }
}

