/*
 * Decompiled with CFR 0.152.
 */
package perfectpix;

import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.IndexColorModel;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.SampleModel;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.imageio.ImageIO;
import perfectpix.BaseLib;
import perfectpix.cfg;

public class ImageConverter
extends BaseLib {
    static final int nPaletteMaxColors = 27;
    public static final int[] nColorsMax = new int[]{16, 4, 2, 16, 16, 4};
    static final int[][] pixelFormats = new int[][]{{0, 128, 8, 136, 32, 160, 40, 168, 2, 130, 10, 138, 34, 162, 42, 170}, {0, 128, 8, 136}, {0, 128}, {0, 128, 8, 136, 32, 160, 40, 168, 2, 130, 10, 138, 34, 162, 42, 170}, {0, 128, 8, 136, 32, 160, 40, 168, 2, 130, 10, 138, 34, 162, 42, 170}, {0, 128, 8, 136}};
    static final Integer[] paletteRGB = new Integer[]{new Integer(513), new Integer(619), new Integer(787188), new Integer(7078401), new Integer(6881896), new Integer(7078642), new Integer(15926534), new Integer(15729256), new Integer(15926004), new Integer(161793), new Integer(30824), new Integer(818164), new Integer(7240449), new Integer(7241067), new Integer(7240694), new Integer(15957261), new Integer(15957355), new Integer(16417017), new Integer(192513), new Integer(62315), new Integer(1045490), new Integer(7468292), new Integer(7467883), new Integer(7468020), new Integer(15987469), new Integer(15987565), new Integer(0xFFF3F9)};
    static final Integer[] paletteCMCodes = new Integer[]{new Integer(84), new Integer(68), new Integer(85), new Integer(92), new Integer(88), new Integer(93), new Integer(76), new Integer(69), new Integer(77), new Integer(86), new Integer(70), new Integer(87), new Integer(94), new Integer(64), new Integer(95), new Integer(78), new Integer(71), new Integer(79), new Integer(82), new Integer(66), new Integer(83), new Integer(90), new Integer(89), new Integer(91), new Integer(74), new Integer(67), new Integer(75)};
    private static final boolean[] MESH_2X2 = new boolean[]{false, true, true, false};
    private static final int[] BLEND_MODE_ROT = new int[]{4, 2};
    private static final int[] BLEND_MODE_AND = new int[]{15, 3};
    private static Hashtable<Integer, Integer> CPCPalette = new Hashtable();
    private static Hashtable<Integer, Integer> CPCBasicPalette = new Hashtable();
    static double LUM_R_FACTOR = 0.299;
    static double LUM_G_FACTOR = 0.587;
    static double LUM_B_FACTOR = 0.114;
    static double[] PALETTE_LUM = new double[27];
    IndexColorModel icm;
    int[] palette;
    int bpp;
    cfg myCfg;
    int offsetPos;
    Vector<byte[]> all;
    Vector<Integer> all_offsets;
    boolean errors = false;

    public static int getCPCPaletteNumber(int _rgb) {
        Integer c = CPCBasicPalette.get(new Integer(_rgb));
        if (c != null) {
            return c;
        }
        return CPCBasicPalette.get(new Integer(ImageConverter.getCPCNearColor(_rgb)));
    }

    static void createPaletteHastables() {
        for (int i = 0; i < 27; ++i) {
            CPCPalette.put(paletteRGB[i], paletteCMCodes[i]);
            CPCBasicPalette.put(paletteRGB[i], new Integer(i));
        }
    }

    static void createLuminances() {
        for (int _i = 0; _i < 27; ++_i) {
            double _r = (paletteRGB[_i] & 0xFF0000) >>> 16;
            double _g = (paletteRGB[_i] & 0xFF00) >>> 8;
            double _b = paletteRGB[_i] & 0xFF;
            ImageConverter.PALETTE_LUM[_i] = Math.sqrt(LUM_R_FACTOR * _r * _r + LUM_G_FACTOR * _g * _g + LUM_B_FACTOR * _b * _b);
        }
    }

    public ImageConverter(cfg _myCfg) {
        this.myCfg = _myCfg;
        try {
            this.offsetPos = 0;
            this.all = new Vector();
            this.all_offsets = new Vector();
            int mode_b1_total_y = 0;
            block37: for (int _fi = 0; _fi < this.myCfg.fileNames.length; ++_fi) {
                int i;
                DataOutputStream ddatas;
                FileOutputStream fdatas;
                String imgTransferTypeName;
                String imgTypeName;
                String fileName = this.myCfg.fileNames[_fi] + "." + this.myCfg.fileExt;
                System.out.print("\nLoading " + fileName + " ... ");
                BufferedImage src = ImageIO.read(new File(fileName));
                ColorModel cm = src.getColorModel();
                int imgType = src.getType();
                System.out.println("OK.");
                switch (imgType) {
                    case 5: {
                        imgTypeName = "TYPE_3BYTE_BGR";
                        break;
                    }
                    case 6: {
                        imgTypeName = "TYPE_4BYTE_ABGR";
                        break;
                    }
                    case 7: {
                        imgTypeName = "TYPE_4BYTE_ABGR_PRE";
                        break;
                    }
                    case 12: {
                        imgTypeName = "TYPE_BYTE_BINARY";
                        break;
                    }
                    case 10: {
                        imgTypeName = "TYPE_BYTE_GRAY";
                        break;
                    }
                    case 13: {
                        imgTypeName = "TYPE_BYTE_INDEXED";
                        break;
                    }
                    case 0: {
                        imgTypeName = "TYPE_CUSTOM";
                        break;
                    }
                    case 2: {
                        imgTypeName = "TYPE_INT_ARGB";
                        break;
                    }
                    case 3: {
                        imgTypeName = "TYPE_INT_ARGB_PRE";
                        break;
                    }
                    case 4: {
                        imgTypeName = "TYPE_INT_BGR";
                        break;
                    }
                    case 1: {
                        imgTypeName = "TYPE_INT_RGB";
                        break;
                    }
                    case 9: {
                        imgTypeName = "TYPE_USHORT_555_RGB";
                        break;
                    }
                    case 8: {
                        imgTypeName = "TYPE_USHORT_565_RGB";
                        break;
                    }
                    case 11: {
                        imgTypeName = "TYPE_USHORT_GRAY";
                        break;
                    }
                    default: {
                        imgTypeName = "UNKNOW";
                    }
                }
                System.out.println("\nImage type = " + imgTypeName);
                if (imgType != 13 && imgType != 12) {
                    System.out.println("\n*** ERROR !!! Source file " + fileName + " is not an indexed color image !!!\n");
                    this.errors = true;
                    continue;
                }
                this.icm = (IndexColorModel)cm;
                int mapSize = this.icm.getMapSize();
                System.out.println("palette Size = " + mapSize);
                this.palette = new int[mapSize];
                this.icm.getRGBs(this.palette);
                Raster raster = src.getData();
                int transferType = raster.getTransferType();
                switch (transferType) {
                    case 0: {
                        imgTransferTypeName = "TYPE_BYTE";
                        break;
                    }
                    case 5: {
                        imgTransferTypeName = "TYPE_DOUBLE";
                        break;
                    }
                    case 4: {
                        imgTransferTypeName = "TYPE_FLOAT";
                        break;
                    }
                    case 3: {
                        imgTransferTypeName = "TYPE_INT";
                        break;
                    }
                    case 2: {
                        imgTransferTypeName = "TYPE_SHORT";
                        break;
                    }
                    case 32: {
                        imgTransferTypeName = "TYPE_UNDEFINED";
                        break;
                    }
                    case 1: {
                        imgTransferTypeName = "TYPE_USHORT";
                        break;
                    }
                    default: {
                        imgTransferTypeName = "UNKNOW";
                    }
                }
                System.out.println("Transfer type = " + imgTransferTypeName);
                SampleModel sm = src.getSampleModel();
                int nBands = sm.getNumBands();
                int nDataElementsToTransfer = sm.getNumDataElements();
                System.out.println("Number of Data Elements needed to transfer a pixel = " + nDataElementsToTransfer);
                int[] sSizes = sm.getSampleSize();
                this.bpp = 0;
                for (int _i = 0; _i < nBands; ++_i) {
                    this.bpp += sSizes[_i];
                }
                System.out.println("Size in bits of samples for all bands (bpp) = " + this.bpp);
                int srcWidth = src.getWidth();
                int height = this.myCfg.height[_fi] = src.getHeight();
                int nSrcPixelReps = (new int[]{2, 1, 1, 1, 2, 1})[this.myCfg.mode];
                int nSrcPixels = srcWidth * height;
                int[] o_RGB_Pixels = new int[nSrcPixels];
                src.getRGB(0, 0, srcWidth, height, o_RGB_Pixels, 0, srcWidth);
                if (nSrcPixelReps == 2) {
                    int _nErrors = 0;
                    for (int _y = 0; _y < height; ++_y) {
                        int _posy = _y * srcWidth;
                        for (int _x = 0; _x < srcWidth; _x += nSrcPixelReps) {
                            int _pos = _posy + _x;
                            if (o_RGB_Pixels[_pos] == o_RGB_Pixels[_pos + 1]) continue;
                            ++_nErrors;
                        }
                    }
                    if (_nErrors > 0) {
                        System.out.println("\n*** WARNING !!! Pixels in source image are not in the required pattern for destination format !\nDuplicating pixels of source image ...");
                        int[] o_RGB_Pixels_aux = new int[nSrcPixels * 2];
                        for (int i2 = 0; i2 < nSrcPixels; ++i2) {
                            int n = o_RGB_Pixels[i2];
                            o_RGB_Pixels_aux[i2 + i2 + 1] = n;
                            o_RGB_Pixels_aux[i2 + i2] = n;
                        }
                        srcWidth *= 2;
                        nSrcPixels *= 2;
                        o_RGB_Pixels = o_RGB_Pixels_aux;
                    }
                }
                if ((srcWidth & 7) != 0 || (height & 7) != 0) {
                    System.out.println("\n*** ERROR !!! source image width and height should be multiple of 8 !!!\n");
                    this.errors = true;
                    continue;
                }
                if (srcWidth > 384) {
                    System.out.println("\n*** WARNING !!! source image width exceeds the limit !!!\n");
                } else if (height > 272) {
                    System.out.println("\n*** WARNING !!! source image height exceeds the limit !!!\n");
                }
                this.myCfg.width[_fi] = srcWidth;
                int width = srcWidth / nSrcPixelReps;
                int nPixels = width * height;
                int nCharsH = height / 8;
                int nBytesW = this.myCfg.nBytesW[_fi] = width / (new int[]{2, 4, 8, 2, 2, 4})[this.myCfg.mode];
                int pixelsPerByte = width / nBytesW;
                int realPixelsPerByte = srcWidth / nBytesW;
                int nBytes = nPixels / pixelsPerByte;
                int nRealPixelPerPixel = realPixelsPerByte / pixelsPerByte;
                System.out.println("srcWidth = " + srcWidth);
                System.out.println("width = " + width);
                System.out.println("height = " + height);
                System.out.println("mode = " + this.myCfg.mode);
                System.out.println("pixelsPerByte = " + pixelsPerByte);
                System.out.println("nBytesW = " + nBytesW);
                System.out.println("nPixels = " + nPixels);
                System.out.println("nBytes = " + nBytes);
                System.out.println("nRealPixelPerPixel = " + nRealPixelPerPixel);
                int nDesPixels = nSrcPixels / nRealPixelPerPixel;
                System.out.println("nDesPixels = " + nDesPixels);
                int[] Indexed_Pixels = new int[nDesPixels];
                int[] RGB_Pixels = new int[nDesPixels];
                int minIndexColor = Integer.MAX_VALUE;
                int maxIndexColor = Integer.MIN_VALUE;
                for (int _y = 0; _y < height; ++_y) {
                    int _offy = _y * srcWidth;
                    block43: for (int _x = 0; _x < srcWidth; _x += nRealPixelPerPixel) {
                        int _pos = _offy + _x;
                        int _rgb = o_RGB_Pixels[_pos];
                        for (int _c = 0; _c < mapSize; ++_c) {
                            if (_rgb != this.palette[_c]) continue;
                            minIndexColor = minIndexColor > _c ? _c : minIndexColor;
                            maxIndexColor = maxIndexColor < _c ? _c : maxIndexColor;
                            int _off = _pos / nRealPixelPerPixel;
                            Indexed_Pixels[_off] = _c;
                            RGB_Pixels[_off] = _rgb;
                            continue block43;
                        }
                    }
                }
                System.out.println("Indexed Color Range = " + minIndexColor + " - " + maxIndexColor);
                BufferedImage bim = new BufferedImage(width, height, 2);
                bim.setRGB(0, 0, width, height, RGB_Pixels, 0, width);
                File file = new File("debug.png");
                ImageIO.write((RenderedImage)bim, "png", file);
                System.out.println("Debug image file created !");
                System.out.println("Converting to required format...");
                switch (this.myCfg.mode) {
                    case 4: 
                    case 5: {
                        int[] _oCPCPaletteNumbers = this.myCfg.oCPCPaletteNumbers[_fi];
                        int _rot = BLEND_MODE_ROT[this.myCfg.mode - 4];
                        int _and = BLEND_MODE_AND[this.myCfg.mode - 4];
                        int[] aux_pixels_eve = new int[nDesPixels];
                        int[] aux_pixels_odd = new int[nDesPixels];
                        for (int i3 = 0; i3 < nDesPixels; ++i3) {
                            int _x;
                            int _y;
                            int _bci = this.myCfg.getIndexedColor(_fi, RGB_Pixels[i3]);
                            if (_bci == -1) {
                                System.out.println("\n*** ERROR !!! The ACT file No." + (_fi + 1) + " does not match !!!\n");
                                this.errors = true;
                                continue block37;
                            }
                            int _eveColor = _bci & _and;
                            double _eveLum = PALETTE_LUM[_oCPCPaletteNumbers[_eveColor]];
                            int _oddColor = _bci >>> _rot;
                            double _oddLum = PALETTE_LUM[_oCPCPaletteNumbers[_oddColor]];
                            if (_eveLum > _oddLum) {
                                int _aux = _oddColor;
                                _oddColor = _eveColor;
                                _eveColor = _aux;
                            }
                            if (!MESH_2X2[((_y = mode_b1_total_y + i3 / width) & 1) * 2 + ((_x = i3 % width) & 1)]) {
                                aux_pixels_eve[i3] = _eveColor;
                                aux_pixels_odd[i3] = _oddColor;
                                continue;
                            }
                            aux_pixels_eve[i3] = _oddColor;
                            aux_pixels_odd[i3] = _eveColor;
                        }
                        if (this.myCfg.mode == 5) {
                            mode_b1_total_y += height;
                        }
                        this.saveFrame(".eve", _fi, aux_pixels_eve, width, height, nBytes, nBytesW, pixelsPerByte, nRealPixelPerPixel);
                        this.saveFrame(".odd", _fi, aux_pixels_odd, width, height, nBytes, nBytesW, pixelsPerByte, nRealPixelPerPixel);
                        break;
                    }
                    case 3: {
                        System.out.println("Generating even frame ...");
                        int[] aux_pixels = this.getInterlaced(0, width, height, Indexed_Pixels);
                        this.saveFrame(".eve", _fi, aux_pixels, width / 2, height, nBytes / 2, nBytesW / 2, pixelsPerByte, nRealPixelPerPixel);
                        System.out.println("Generating odd frame ...");
                        aux_pixels = this.getInterlaced(1, width, height, Indexed_Pixels);
                        this.saveFrame(".odd", _fi, aux_pixels, width / 2, height, nBytes / 2, nBytesW / 2, pixelsPerByte, nRealPixelPerPixel);
                        break;
                    }
                    default: {
                        byte[] buffer = this.convert(Indexed_Pixels, height, nBytes, nBytesW, width, pixelsPerByte, nRealPixelPerPixel);
                        switch (this.myCfg.type) {
                            case 4: {
                                this.save(buffer, this.myCfg.fileNames[_fi]);
                                break;
                            }
                            default: {
                                fdatas = new FileOutputStream(this.myCfg.fileNames[_fi] + ".bin");
                                ddatas = new DataOutputStream(fdatas);
                                ddatas.write(buffer);
                                ddatas.close();
                            }
                        }
                        this.all.addElement(buffer);
                        this.all_offsets.addElement(new Integer(this.offsetPos));
                        this.offsetPos += buffer.length;
                    }
                }
                System.out.println("Ok!");
                System.out.println("Saving all together ...");
                int _n = this.all.size();
                fdatas = new FileOutputStream(this.myCfg.output + ".bin");
                ddatas = new DataOutputStream(fdatas);
                for (i = 0; i < _n; ++i) {
                    ddatas.write(this.all.elementAt(i));
                }
                ddatas.close();
                fdatas = new FileOutputStream(this.myCfg.output + "_offsets.bin");
                ddatas = new DataOutputStream(fdatas);
                for (i = 0; i < _n; ++i) {
                    ddatas.writeShort(this.all_offsets.elementAt(i));
                }
                ddatas.close();
                fdatas = new FileOutputStream(this.myCfg.output + "_offsets.txt");
                ddatas = new DataOutputStream(fdatas);
                for (i = 0; i < _n; ++i) {
                    ddatas.writeBytes("        dw      " + this.all_offsets.elementAt(i) + "\n");
                }
                ddatas.close();
                System.out.println("Salving palette info ...");
                fdatas = new FileOutputStream(this.myCfg.fileNames[_fi] + "_pal.txt");
                ddatas = new DataOutputStream(fdatas);
                ddatas.writeBytes("        db ");
                for (i = 0; i < nColorsMax[this.myCfg.mode]; ++i) {
                    int _c;
                    int rgb;
                    switch (this.myCfg.mode) {
                        case 4: 
                        case 5: {
                            rgb = this.myCfg.oCPCPalette[_fi][i];
                            break;
                        }
                        default: {
                            rgb = this.palette[i] & 0xFFFFFF;
                        }
                    }
                    Integer c = CPCPalette.get(new Integer(rgb));
                    if (i > 0) {
                        ddatas.writeBytes(", ");
                    }
                    if (c != null) {
                        _c = c;
                        ddatas.writeByte(38);
                    } else {
                        System.out.print("\n*** WARNING !!! Color out of the CPC palette ! : " + Integer.toHexString(rgb));
                        rgb = ImageConverter.getCPCNearColor(rgb);
                        System.out.println(" -> converted to " + Integer.toHexString(rgb));
                        _c = CPCPalette.get(new Integer(rgb));
                        ddatas.writeByte(38);
                    }
                    ddatas.writeBytes(Integer.toHexString(_c));
                    this.myCfg.palette[_fi][i] = CPCBasicPalette.get(new Integer(rgb)).byteValue();
                }
                ddatas.close();
                System.out.println("Finished !!!");
            }
        }
        catch (Exception e) {
            System.out.println(e.getMessage());
            e.printStackTrace();
        }
    }

    private void saveFrame(String _ext, int _fi, int[] _pixels, int width, int height, int nBytes, int nBytesW, int pixelsPerByte, int nRealPixelPerPixel) throws Exception {
        byte[] buffer = this.convert(_pixels, height, nBytes, nBytesW, width, pixelsPerByte, nRealPixelPerPixel);
        switch (this.myCfg.type) {
            case 4: {
                this.save(buffer, this.myCfg.fileNames[_fi] + _ext);
                break;
            }
            default: {
                FileOutputStream fdatas = new FileOutputStream(this.myCfg.fileNames[_fi] + _ext);
                DataOutputStream ddatas = new DataOutputStream(fdatas);
                ddatas.write(buffer);
                ddatas.close();
            }
        }
        this.all.addElement(buffer);
        this.all_offsets.addElement(new Integer(this.offsetPos));
        this.offsetPos += buffer.length;
    }

    private static int getCPCNearColor(int rgb) {
        Enumeration<Integer> e = CPCPalette.keys();
        double minDif = Double.MAX_VALUE;
        int color = 0;
        while (e.hasMoreElements()) {
            Integer c = e.nextElement();
            int argb2 = c;
            double dif = ImageConverter.getPixelsDifs_fast(rgb, argb2);
            if (!(dif < minDif)) continue;
            minDif = dif;
            color = argb2;
        }
        return color;
    }

    private int[] getInterlaced(int _par, int width, int height, int[] pixels) {
        boolean inv = false;
        int _p_des_ini = 0;
        int _final_h = height;
        int[] aux_pixels = new int[pixels.length / 2];
        if (inv) {
            _par ^= 1;
        }
        int _p_src = _par;
        int _p_des = _p_des_ini;
        for (int _y = 0; _y < _final_h; ++_y) {
            int _x = 0;
            while (_x < width) {
                aux_pixels[_p_des] = pixels[_p_src];
                _x += 2;
                _p_src += 2;
                ++_p_des;
            }
            if (_y % 2 == _par) {
                ++_p_src;
                continue;
            }
            --_p_src;
        }
        return aux_pixels;
    }

    private byte[] convert(int[] pixels, int height, int nBytes, int nBytesW, int width, int pixelsPerByte, int nRealPixelPerPixel) {
        byte[] buffer2;
        int mod2;
        int addy2;
        int bufferPos = 0;
        int[] _pixelFormats = pixelFormats[this.myCfg.mode];
        switch (this.myCfg.type) {
            default: {
                System.out.println("Converting linear ... " + this.myCfg.type);
                addy2 = 1;
                mod2 = 0;
                buffer2 = new byte[nBytes];
                break;
            }
            case 5: {
                System.out.println("Converting custom scanline order ... " + this.myCfg.type);
                int addy2 = this.myCfg.scanlines_per_char_order.length;
                int mod2 = 0;
                byte[] buffer2 = new byte[nBytes];
                for (int _y = 0; _y < addy2; ++_y) {
                    int scanLine;
                    for (int y = scanLine = this.myCfg.scanlines_per_char_order[_y]; y < height; y += addy2) {
                        for (int bx = 0; bx < nBytesW; ++bx) {
                            int pos = y * width + bx * pixelsPerByte;
                            buffer2[bufferPos++] = (byte)this.getByteValue(_pixelFormats, pixels, pos);
                        }
                    }
                    bufferPos += mod2;
                }
                return buffer2;
            }
            case 1: {
                System.out.println("Converting standar ... " + this.myCfg.type);
                addy2 = 8;
                mod2 = 2048 - height / addy2 * nBytesW;
                buffer2 = new byte[nBytes + (addy2 - 1) * mod2];
                System.out.println("*** buffer.length = " + buffer2.length);
                break;
            }
            case 3: {
                System.out.println("Converting linear v ... " + this.myCfg.type);
                byte[] buffer2 = new byte[nBytes];
                for (int bx = 0; bx < nBytesW; bx += this.myCfg.lineal_v_w) {
                    for (int y = 0; y < height; ++y) {
                        int pos = y * width + bx * pixelsPerByte;
                        for (int x = 0; x < this.myCfg.lineal_v_w; ++x) {
                            buffer2[bufferPos++] = (byte)this.getByteValue(_pixelFormats, pixels, pos);
                            pos += pixelsPerByte;
                        }
                    }
                }
                return buffer2;
            }
            case 2: 
            case 4: {
                System.out.println("Converting overscan ... " + this.myCfg.type);
                byte[] buffer2 = new byte[nBytes];
                int xo = 0;
                int yo = 0;
                int byteProcessed_total = 0;
                int byteProcessed_mod = 0;
                int scanLine = 0;
                int y = yo + scanLine;
                int bx = xo / pixelsPerByte;
                boolean end = false;
                while (!end) {
                    int pos = y * width + bx * pixelsPerByte;
                    buffer2[bufferPos++] = (byte)this.getByteValue(_pixelFormats, pixels, pos);
                    ++bx;
                    ++byteProcessed_mod;
                    if (++byteProcessed_total >= nBytes) {
                        end = true;
                        continue;
                    }
                    if (byteProcessed_mod >= 2048) {
                        byteProcessed_mod = 0;
                        if (++scanLine >= 8) {
                            scanLine = 0;
                            xo = bx * pixelsPerByte;
                            yo = y - 7;
                        }
                        y = yo + scanLine;
                        bx = xo / pixelsPerByte;
                        continue;
                    }
                    if (bx < nBytesW) continue;
                    bx = 0;
                    if ((y += 8) < height) continue;
                    byteProcessed_mod = 0;
                    if (++scanLine >= 8) {
                        scanLine = 0;
                        xo = bx * pixelsPerByte;
                        yo = y - 7;
                    }
                    y = yo + scanLine;
                    bx = xo / pixelsPerByte;
                }
                return buffer2;
            }
        }
        for (int scanLine = 0; scanLine < addy2; ++scanLine) {
            for (int y = scanLine; y < height; y += addy2) {
                for (int bx = 0; bx < nBytesW; ++bx) {
                    int pos = y * width + bx * pixelsPerByte;
                    buffer2[bufferPos++] = (byte)this.getByteValue(_pixelFormats, pixels, pos);
                }
            }
            bufferPos += mod2;
        }
        return buffer2;
    }

    private int getByteValue(int[] _pixelFormats, int[] pixels, int pos) {
        int byteValue = 0;
        block0 : switch (this.myCfg.mode) {
            case 0: 
            case 3: 
            case 4: {
                switch (this.myCfg.transform) {
                    case 0: {
                        byteValue = _pixelFormats[pixels[pos]] | _pixelFormats[pixels[pos + 1]] >> 1;
                        break;
                    }
                    case 1: 
                    case 2: {
                        byteValue = _pixelFormats[pixels[pos + 1]] | _pixelFormats[pixels[pos]] >> 1;
                    }
                }
                break;
            }
            case 1: 
            case 5: {
                switch (this.myCfg.transform) {
                    case 0: {
                        byteValue = _pixelFormats[pixels[pos]] | _pixelFormats[pixels[pos + 1]] >> 1 | _pixelFormats[pixels[pos + 2]] >> 2 | _pixelFormats[pixels[pos + 3]] >> 3;
                        break;
                    }
                    case 1: {
                        byteValue = _pixelFormats[pixels[pos + 3]] | _pixelFormats[pixels[pos + 2]] >> 1 | _pixelFormats[pixels[pos + 1]] >> 2 | _pixelFormats[pixels[pos]] >> 3;
                        break;
                    }
                    case 2: {
                        byteValue = _pixelFormats[pixels[pos + 2]] | _pixelFormats[pixels[pos + 3]] >> 1 | _pixelFormats[pixels[pos]] >> 2 | _pixelFormats[pixels[pos + 1]] >> 3;
                    }
                }
                break;
            }
            case 2: {
                switch (this.myCfg.transform) {
                    case 0: {
                        byteValue = pixelFormats[this.myCfg.mode][pixels[pos]] | _pixelFormats[pixels[pos + 1]] >> 1 | _pixelFormats[pixels[pos + 2]] >> 2 | _pixelFormats[pixels[pos + 3]] >> 3 | _pixelFormats[pixels[pos + 4]] >> 4 | _pixelFormats[pixels[pos + 5]] >> 5 | _pixelFormats[pixels[pos + 6]] >> 6 | _pixelFormats[pixels[pos + 7]] >> 7;
                        break block0;
                    }
                    case 1: {
                        byteValue = pixelFormats[this.myCfg.mode][pixels[pos + 7]] | _pixelFormats[pixels[pos + 6]] >> 1 | _pixelFormats[pixels[pos + 5]] >> 2 | _pixelFormats[pixels[pos + 4]] >> 3 | _pixelFormats[pixels[pos + 3]] >> 4 | _pixelFormats[pixels[pos + 2]] >> 5 | _pixelFormats[pixels[pos + 1]] >> 6 | _pixelFormats[pixels[pos]] >> 7;
                    }
                }
            }
        }
        return byteValue;
    }

    private void save(byte[] buffer, String fileName) {
        int bankSize = 16384;
        if (this.myCfg.param1 > 0) {
            int i;
            System.out.println("(Saving overscan with offset ...)");
            int opiece_len = (buffer.length - bankSize) / 8;
            int piece_len = opiece_len + this.myCfg.param1;
            byte[][] _buffers = new byte[9][];
            _buffers[0] = new byte[bankSize - this.myCfg.param1];
            for (i = 0; i < 8; ++i) {
                System.arraycopy(buffer, i * 2048, _buffers[0], i * 2048, 2048 - this.myCfg.param1);
            }
            for (i = 1; i < 9; ++i) {
                _buffers[i] = new byte[piece_len];
                System.arraycopy(buffer, i * 2048 - this.myCfg.param1, _buffers[i], 0, this.myCfg.param1);
                System.arraycopy(buffer, bankSize + (i - 1) * opiece_len, _buffers[i], this.myCfg.param1, opiece_len);
            }
            for (int _i = 0; _i < 9; ++_i) {
                String _name = fileName + "_split" + _i + ".bin";
                try {
                    FileOutputStream fdatas = new FileOutputStream(_name);
                    DataOutputStream ddatas = new DataOutputStream(fdatas);
                    ddatas.write(_buffers[_i]);
                    ddatas.close();
                    continue;
                }
                catch (Exception e) {
                    System.out.println(e);
                }
            }
        } else {
            DataOutputStream ddatas;
            FileOutputStream fdatas;
            String _name;
            int piece_len = (buffer.length - bankSize) / 8;
            int piece_pos = bankSize;
            if (buffer.length > bankSize) {
                _name = fileName + "_split0.bin";
                try {
                    fdatas = new FileOutputStream(_name);
                    ddatas = new DataOutputStream(fdatas);
                    ddatas.write(buffer, 0, bankSize);
                    ddatas.close();
                }
                catch (Exception e) {
                    System.out.println(e);
                }
            } else {
                piece_len = buffer.length / 8;
                piece_pos = 0;
            }
            for (int _i = 1; _i < 9; ++_i) {
                _name = fileName + "_split" + _i + ".bin";
                try {
                    fdatas = new FileOutputStream(_name);
                    ddatas = new DataOutputStream(fdatas);
                    ddatas.write(buffer, piece_pos, piece_len);
                    piece_pos += piece_len;
                    ddatas.close();
                    continue;
                }
                catch (Exception e) {
                    System.out.println(e);
                }
            }
        }
    }
}

