/******************************************************************************/
/* MINIFMOD.H                                                                 */
/* ----------------                                                           */
/* MiniFMOD public source code release.                                       */
/* This source is provided as-is.  Firelight Multimedia will not support      */
/* or answer questions about the source provided.                             */
/* MiniFMOD Sourcecode is copyright (c) 2000, Firelight Multimedia.           */
/* MiniFMOD Sourcecode is in no way representative of FMOD 3 source.          */
/* Firelight Multimedia is a registered business name.                        */
/* This source must not be redistributed without this notice.                 */
/******************************************************************************/

//==========================================================================================
// MINIFMOD Main header file. Copyright (c), FireLight Multimedia 2000.
// Based on FMOD, copyright (c), FireLight Multimedia 2000.
//==========================================================================================

#ifndef _MINIFMOD_H_
#define _MINIFMOD_H_

//===============================================================================================
//= DEFINITIONS
//===============================================================================================

// fmod defined types
typedef struct FMUSIC_MODULE	FMUSIC_MODULE;

//===============================================================================================
//= FUNCTION PROTOTYPES
//===============================================================================================

#ifdef __cplusplus
extern "C" {
#endif

// ==================================
// Initialization / Global functions.
// ==================================
typedef void (*FMUSIC_CALLBACK)(FMUSIC_MODULE *mod, unsigned char param);

void			fmodInit	(unsigned long mixrate);
void			fmodFinish	(void);

// =============================================================================================
// FMUSIC API
// =============================================================================================

// Song management / playback functions.
// =====================================
FMUSIC_MODULE*	fmodLoad	(void* FileMem);
void			fmodFree	(FMUSIC_MODULE *mod);
void			fmodPlay	(FMUSIC_MODULE *mod, unsigned long volume);
void			fmodStop	(FMUSIC_MODULE *mod);

// Runtime song information.
// =========================
int				fmodGetOrder	(FMUSIC_MODULE *mod);
int				fmodGetRow		(FMUSIC_MODULE *mod);
unsigned int	fmodGetTime		(FMUSIC_MODULE *mod);
  
#ifdef __cplusplus
}
#endif

#endif
