<?xml version="1.0"?><doc>
<members>
<member name="T:Jacobi.Vst.Interop.MemoryTracker" decl="false" source="c:\workspace\soundengine\vst.net\code\jacobi.vst.interop\memorytracker.h" line="7">
<summary>
The MemoryTracker class maintains a list of native allocated objects that can be deleted (freed) at another time.
</summary>
</member>
<member name="M:Jacobi.Vst.Interop.MemoryTracker.#ctor" decl="true" source="c:\workspace\soundengine\vst.net\code\jacobi.vst.interop\memorytracker.h" line="13">
<summary>
Constructs a new instance.
</summary>
</member>
<member name="M:Jacobi.Vst.Interop.MemoryTracker.RegisterObject(System.Void*)" decl="true" source="c:\workspace\soundengine\vst.net\code\jacobi.vst.interop\memorytracker.h" line="18">
<summary>
Registers a <paramref name="memoryObject"/> that is not an array.
</summary>
</member>
<member name="M:Jacobi.Vst.Interop.MemoryTracker.RegisterArray(System.Void*)" decl="true" source="c:\workspace\soundengine\vst.net\code\jacobi.vst.interop\memorytracker.h" line="22">
<summary>
Registers an <paramref name="arrayObject"/> that is an array.
</summary>
</member>
<member name="M:Jacobi.Vst.Interop.MemoryTracker.ClearAll" decl="true" source="c:\workspace\soundengine\vst.net\code\jacobi.vst.interop\memorytracker.h" line="26">
<summary>
Deletes all 'pointers' tracked.
</summary>
</member>
<member name="T:Jacobi.Vst.Interop.Host.VstPluginCommandStub" decl="false" source="c:\workspace\soundengine\vst.net\code\jacobi.vst.interop\host\vstplugincommandstub.h" line="11">
<summary>
The VstPluginCommandStub class implements the <see cref="T:Jacobi.Vst.Core.Host.IVstPluginCommandStub"/>
interface that is called by the host to access the Plugin.
</summary>
<remarks>
The class also implements the <see cref="T:Jacobi.Vst.Core.Deprecated.IVstPluginCommandsDeprecated20"/> 
interface for deprecated method support.
</remarks>
</member>
<member name="M:Jacobi.Vst.Interop.Host.VstPluginCommandStub.ProcessReplacing(Jacobi.Vst.Core.VstAudioBuffer[],Jacobi.Vst.Core.VstAudioBuffer[])" decl="true" source="c:\workspace\soundengine\vst.net\code\jacobi.vst.interop\host\vstplugincommandstub.h" line="36">
<summary>
Called by the host once every cycle to process incoming audio as well as output audio.
</summary>
<param name="inputs">An array with audio input buffers.</param>
<param name="outputs">An array with audio output buffers.</param>
</member>
<member name="M:Jacobi.Vst.Interop.Host.VstPluginCommandStub.ProcessReplacing(Jacobi.Vst.Core.VstAudioPrecisionBuffer[],Jacobi.Vst.Core.VstAudioPrecisionBuffer[])" decl="true" source="c:\workspace\soundengine\vst.net\code\jacobi.vst.interop\host\vstplugincommandstub.h" line="43">
<summary>
Called by the host once every cycle to process incoming audio as well as output audio.
</summary>
<param name="inputs">An array with audio input buffers.</param>
<param name="outputs">An array with audio output buffers.</param>
</member>
<member name="M:Jacobi.Vst.Interop.Host.VstPluginCommandStub.SetParameter(System.Int32,System.Single)" decl="true" source="c:\workspace\soundengine\vst.net\code\jacobi.vst.interop\host\vstplugincommandstub.h" line="50">
<summary>
Called by the host to assign a new <paramref name="value"/> to the parameter at <paramref name="index"/>.
</summary>
<param name="index">A zero-base index into the parameters collection.</param>
<param name="value">The new value for the parameter.</param>
</member>
<member name="M:Jacobi.Vst.Interop.Host.VstPluginCommandStub.GetParameter(System.Int32)" decl="true" source="c:\workspace\soundengine\vst.net\code\jacobi.vst.interop\host\vstplugincommandstub.h" line="56">
<summary>
Called by the host to retrieve the current value of the parameter at <paramref name="index"/>.
</summary>
<param name="index">A zero-base index into the parameters collection.</param>
<returns>Returns 0.0 the value for the parameter at <paramref name="index"/>.</returns>
</member>
<member name="M:Jacobi.Vst.Interop.Host.VstPluginCommandStub.Open" decl="true" source="c:\workspace\soundengine\vst.net\code\jacobi.vst.interop\host\vstplugincommandstub.h" line="64">
<summary>
This is the first method called by the host right after the assembly is loaded.
</summary>
</member>
<member name="M:Jacobi.Vst.Interop.Host.VstPluginCommandStub.Close" decl="true" source="c:\workspace\soundengine\vst.net\code\jacobi.vst.interop\host\vstplugincommandstub.h" line="68">
<summary>
This is the last method the host calls. Dispose your resources.
</summary>
</member>
<member name="M:Jacobi.Vst.Interop.Host.VstPluginCommandStub.SetProgram(System.Int32)" decl="true" source="c:\workspace\soundengine\vst.net\code\jacobi.vst.interop\host\vstplugincommandstub.h" line="72">
<summary>
The plugin should activate the Program at <paramref name="programNumber"/>.
</summary>
<param name="programNumber">A zero-based program number (index).</param>
</member>
<member name="M:Jacobi.Vst.Interop.Host.VstPluginCommandStub.GetProgram" decl="true" source="c:\workspace\soundengine\vst.net\code\jacobi.vst.interop\host\vstplugincommandstub.h" line="77">
<summary>
Retrieve the current program index.
</summary>
<returns>Returns the current program index or 0 as a default.</returns>
</member>
<member name="M:Jacobi.Vst.Interop.Host.VstPluginCommandStub.SetProgramName(System.String)" decl="true" source="c:\workspace\soundengine\vst.net\code\jacobi.vst.interop\host\vstplugincommandstub.h" line="82">
<summary>
Assign a new name to the current/active program.
</summary>
<param name="name">The new program name.</param>
</member>
<member name="M:Jacobi.Vst.Interop.Host.VstPluginCommandStub.GetProgramName" decl="true" source="c:\workspace\soundengine\vst.net\code\jacobi.vst.interop\host\vstplugincommandstub.h" line="87">
<summary>
Retrieves the name of the current/active program.
</summary>
<returns>Can return null or an empty string.</returns>
</member>
<member name="M:Jacobi.Vst.Interop.Host.VstPluginCommandStub.GetParameterLabel(System.Int32)" decl="true" source="c:\workspace\soundengine\vst.net\code\jacobi.vst.interop\host\vstplugincommandstub.h" line="92">
<summary>
Retrieves the label for the parameter at <paramref name="index"/>.
</summary>
<param name="index">A zero-based index into the parameter collection.</param>
<returns>Can return null or an empty string.</returns>
</member>
<member name="M:Jacobi.Vst.Interop.Host.VstPluginCommandStub.GetParameterDisplay(System.Int32)" decl="true" source="c:\workspace\soundengine\vst.net\code\jacobi.vst.interop\host\vstplugincommandstub.h" line="98">
<summary>
Retrieves the display value for the parameter at <paramref name="index"/>.
</summary>
<param name="index">A zero-based index into the parameter collection.</param>
<returns>Can return null or an empty string.</returns>
</member>
<member name="M:Jacobi.Vst.Interop.Host.VstPluginCommandStub.GetParameterName(System.Int32)" decl="true" source="c:\workspace\soundengine\vst.net\code\jacobi.vst.interop\host\vstplugincommandstub.h" line="104">
<summary>
Retrieves the name for the parameter at <paramref name="index"/>.
</summary>
<param name="index">A zero-based index into the parameter collection.</param>
<returns>Can return null or an empty string.</returns>
</member>
<member name="M:Jacobi.Vst.Interop.Host.VstPluginCommandStub.SetSampleRate(System.Single)" decl="true" source="c:\workspace\soundengine\vst.net\code\jacobi.vst.interop\host\vstplugincommandstub.h" line="110">
<summary>
Assigns the <paramref name="sampleRate"/> to the plugin.
</summary>
<param name="sampleRate">The number of audio samples per second.</param>
</member>
<member name="M:Jacobi.Vst.Interop.Host.VstPluginCommandStub.SetBlockSize(System.Int32)" decl="true" source="c:\workspace\soundengine\vst.net\code\jacobi.vst.interop\host\vstplugincommandstub.h" line="115">
<summary>
Assigns the <paramref name="blockSize"/> to the plugin.
</summary>
<param name="blockSize">The number samples per cycle.</param>
</member>
<member name="M:Jacobi.Vst.Interop.Host.VstPluginCommandStub.MainsChanged(System.Boolean)" decl="true" source="c:\workspace\soundengine\vst.net\code\jacobi.vst.interop\host\vstplugincommandstub.h" line="120">
<summary>
Called by the host when the users has turned the plugin on or off.
</summary>
<param name="onoff">True when on, false when off.</param>
</member>
<member name="M:Jacobi.Vst.Interop.Host.VstPluginCommandStub.EditorGetRect(System.Drawing.Rectangle@)" decl="true" source="c:\workspace\soundengine\vst.net\code\jacobi.vst.interop\host\vstplugincommandstub.h" line="125">
<summary>
Called by the host to retrieve the bounding rectangle of the editor.
</summary>
<param name="rect">The rectangle receiving the bounds.</param>
<returns>Returns true when the <paramref name="rect"/> was set.</returns>
</member>
<member name="M:Jacobi.Vst.Interop.Host.VstPluginCommandStub.EditorOpen(System.IntPtr)" decl="true" source="c:\workspace\soundengine\vst.net\code\jacobi.vst.interop\host\vstplugincommandstub.h" line="131">
<summary>
Called by the host to open the plugin custom editor.
</summary>
<param name="hWnd">The handle to the parent window.</param>
<returns>Returns false when not implemented.</returns>
</member>
<member name="M:Jacobi.Vst.Interop.Host.VstPluginCommandStub.EditorClose" decl="true" source="c:\workspace\soundengine\vst.net\code\jacobi.vst.interop\host\vstplugincommandstub.h" line="137">
<summary>
Called by the host to close (and destroy) the plugin custom editor.
</summary>
</member>
<member name="M:Jacobi.Vst.Interop.Host.VstPluginCommandStub.EditorIdle" decl="true" source="c:\workspace\soundengine\vst.net\code\jacobi.vst.interop\host\vstplugincommandstub.h" line="141">
<summary>
Called by the host when the editor is idle.
</summary>
<remarks>Keep your processing short.</remarks>
</member>
<member name="M:Jacobi.Vst.Interop.Host.VstPluginCommandStub.GetChunk(System.Boolean)" decl="true" source="c:\workspace\soundengine\vst.net\code\jacobi.vst.interop\host\vstplugincommandstub.h" line="146">
<summary>
Called by the host to retrieve a buffer with Program (and Parameter) content.
</summary>
<param name="isPreset">True if only the current/active program should be serialized, 
otherwise (false) the complete program bank should be serialized.</param>
<returns>Returns null when not implemented.</returns>
</member>
<member name="M:Jacobi.Vst.Interop.Host.VstPluginCommandStub.SetChunk(System.Byte[],System.Boolean)" decl="true" source="c:\workspace\soundengine\vst.net\code\jacobi.vst.interop\host\vstplugincommandstub.h" line="153">
<summary>
Called by the host to load in a previously serialized program buffer.
</summary>
<param name="data">The buffer provided by the host that contains the program data.</param>
<param name="isPreset">True if only the current/active program should be deserialized, 
otherwise (false) the complete program bank should be deserialized.</param>
<returns>Returns the number of bytes read from the <paramref name="data"/> buffer or 
zero not implemented.</returns>
</member>
<member name="M:Jacobi.Vst.Interop.Host.VstPluginCommandStub.ProcessEvents(Jacobi.Vst.Core.VstEvent[])" decl="true" source="c:\workspace\soundengine\vst.net\code\jacobi.vst.interop\host\vstplugincommandstub.h" line="164">
<summary>
Called by the host when the plugin has specified the <see cref="T:Jacobi.Vst.Core.VstPluginCanDo"/><b>.ReceiveVstMidiEvent</b> flag.
</summary>
<param name="events">The (Midi) events for the current 'block'.</param>
<returns>Returns false if not implemented.</returns>
</member>
<member name="M:Jacobi.Vst.Interop.Host.VstPluginCommandStub.CanParameterBeAutomated(System.Int32)" decl="true" source="c:\workspace\soundengine\vst.net\code\jacobi.vst.interop\host\vstplugincommandstub.h" line="170">
<summary>
Called by the host to query the plugin whether the parameter at <paramref name="index"/> can be automated.
</summary>
<param name="index">The zero-based index into the parameters.</param>
<returns>Returns true if the parameter can be automated or false if not implemented.</returns>
</member>
<member name="M:Jacobi.Vst.Interop.Host.VstPluginCommandStub.String2Parameter(System.Int32,System.String)" decl="true" source="c:\workspace\soundengine\vst.net\code\jacobi.vst.interop\host\vstplugincommandstub.h" line="176">
<summary>
Parses the <paramref name="str"/> value to assign to the parameter at <paramref name="index"/>.
</summary>
<param name="index">The zero-base parameter index.</param>
<param name="str">The value for the parameter.</param>
<returns>Returns true when the parameter was successfully parsed or
false if not implemented.</returns>
</member>
<member name="M:Jacobi.Vst.Interop.Host.VstPluginCommandStub.GetProgramNameIndexed(System.Int32)" decl="true" source="c:\workspace\soundengine\vst.net\code\jacobi.vst.interop\host\vstplugincommandstub.h" line="184">
<summary>
Retrieves the name of the program at <paramref name="index"/>.
</summary>
<param name="index">The zero-base index into the plugin Programs.</param>
<returns>Returns null if not implemented.</returns>
</member>
<member name="M:Jacobi.Vst.Interop.Host.VstPluginCommandStub.GetInputProperties(System.Int32)" decl="true" source="c:\workspace\soundengine\vst.net\code\jacobi.vst.interop\host\vstplugincommandstub.h" line="190">
<summary>
Retrieves the pin properties for the input at <paramref name="index"/>.
</summary>
<param name="index">A zero-based index into the plugin inputs.</param>
<returns>Returns null if not implemented.</returns>
</member>
<member name="M:Jacobi.Vst.Interop.Host.VstPluginCommandStub.GetOutputProperties(System.Int32)" decl="true" source="c:\workspace\soundengine\vst.net\code\jacobi.vst.interop\host\vstplugincommandstub.h" line="196">
<summary>
Retrieves the pin properties for the output at <paramref name="index"/>.
</summary>
<param name="index">A zero-based index into the plugin outputs.</param>
<returns>Returns null if not implemented.</returns>
</member>
<member name="M:Jacobi.Vst.Interop.Host.VstPluginCommandStub.GetCategory" decl="true" source="c:\workspace\soundengine\vst.net\code\jacobi.vst.interop\host\vstplugincommandstub.h" line="202">
<summary>
Retrieves a categorization value for the plugin.
</summary>
<returns>Returns the plugin category.</returns>
</member>
<member name="M:Jacobi.Vst.Interop.Host.VstPluginCommandStub.SetSpeakerArrangement(Jacobi.Vst.Core.VstSpeakerArrangement,Jacobi.Vst.Core.VstSpeakerArrangement)" decl="true" source="c:\workspace\soundengine\vst.net\code\jacobi.vst.interop\host\vstplugincommandstub.h" line="212">
<summary>
Under Construction
</summary>
<param name="saInput">Must not be null.</param>
<param name="saOutput">Must not be null.</param>
<returns>Returns false if not implemented.</returns>
</member>
<member name="M:Jacobi.Vst.Interop.Host.VstPluginCommandStub.SetBypass(System.Boolean)" decl="true" source="c:\workspace\soundengine\vst.net\code\jacobi.vst.interop\host\vstplugincommandstub.h" line="220">
<summary>
Called by the host to bypass plugin processing.
</summary>
<param name="bypass">True to bypass, false to process.</param>
<returns>Returns false if not implemented.</returns>
</member>
<member name="M:Jacobi.Vst.Interop.Host.VstPluginCommandStub.GetEffectName" decl="true" source="c:\workspace\soundengine\vst.net\code\jacobi.vst.interop\host\vstplugincommandstub.h" line="226">
<summary>
Called by the host to retrieve the name of plugin.
</summary>
<returns>Returns the name. Must not be null.</returns>
<remarks>The plugin name should not exceed 31 characters.</remarks>
</member>
<member name="M:Jacobi.Vst.Interop.Host.VstPluginCommandStub.GetVendorString" decl="true" source="c:\workspace\soundengine\vst.net\code\jacobi.vst.interop\host\vstplugincommandstub.h" line="232">
<summary>
Called to retrieve the plugin vendor information.
</summary>
<returns>Returns the Vendor name.</returns>
</member>
<member name="M:Jacobi.Vst.Interop.Host.VstPluginCommandStub.GetProductString" decl="true" source="c:\workspace\soundengine\vst.net\code\jacobi.vst.interop\host\vstplugincommandstub.h" line="237">
<summary>
Called to retrieve the plugin product information.
</summary>
<returns>Returns the Product name.</returns>
</member>
<member name="M:Jacobi.Vst.Interop.Host.VstPluginCommandStub.GetVendorVersion" decl="true" source="c:\workspace\soundengine\vst.net\code\jacobi.vst.interop\host\vstplugincommandstub.h" line="242">
<summary>
Called to retrieve the plugin version information.
</summary>
<returns>Returns the Version number.</returns>
</member>
<member name="M:Jacobi.Vst.Interop.Host.VstPluginCommandStub.CanDo(System.String)" decl="true" source="c:\workspace\soundengine\vst.net\code\jacobi.vst.interop\host\vstplugincommandstub.h" line="247">
<summary>
Called by the host to query the plugin if a certain behavior or aspect is supported.
</summary>
<param name="cando">The string containing the can-do string, which can be host specific.</param>
<returns>Returns an indication if the capability is supported.</returns>
</member>
<member name="M:Jacobi.Vst.Interop.Host.VstPluginCommandStub.GetTailSize" decl="true" source="c:\workspace\soundengine\vst.net\code\jacobi.vst.interop\host\vstplugincommandstub.h" line="253">
<summary>
Called by the host to retrieve the number of samples that the plugin outputs after the input has gone silent.
</summary>
<returns>Returns zero if not implemented.</returns>
</member>
<member name="M:Jacobi.Vst.Interop.Host.VstPluginCommandStub.GetParameterProperties(System.Int32)" decl="true" source="c:\workspace\soundengine\vst.net\code\jacobi.vst.interop\host\vstplugincommandstub.h" line="258">
<summary>
Called by the host to retrieve information about a plugin parameter at <paramref name="index"/>.
</summary>
<param name="index">A zero-based index into the plugin parameters.</param>
<returns>Returns null if not implemented.</returns>
</member>
<member name="M:Jacobi.Vst.Interop.Host.VstPluginCommandStub.GetVstVersion" decl="true" source="c:\workspace\soundengine\vst.net\code\jacobi.vst.interop\host\vstplugincommandstub.h" line="264">
<summary>
Called by the host to query the plugin what VST version it supports.
</summary>
<returns>Returns 2400 for VST 2.4.</returns>
</member>
<member name="M:Jacobi.Vst.Interop.Host.VstPluginCommandStub.EditorKeyDown(System.Byte,Jacobi.Vst.Core.VstVirtualKey,Jacobi.Vst.Core.VstModifierKeys)" decl="true" source="c:\workspace\soundengine\vst.net\code\jacobi.vst.interop\host\vstplugincommandstub.h" line="271">
<summary>
Called by the host when the user presses a key.
</summary>
<param name="ascii">The identification of the key.</param>
<param name="virtualKey">Virtual key information.</param>
<param name="modifers">Additional keys pressed.</param>
<returns>Returns false when not implemented.</returns>
</member>
<member name="M:Jacobi.Vst.Interop.Host.VstPluginCommandStub.EditorKeyUp(System.Byte,Jacobi.Vst.Core.VstVirtualKey,Jacobi.Vst.Core.VstModifierKeys)" decl="true" source="c:\workspace\soundengine\vst.net\code\jacobi.vst.interop\host\vstplugincommandstub.h" line="280">
<summary>
Called by the host when the user releases a key.
</summary>
<param name="ascii">The identification of the key.</param>
<param name="virtualKey">Virtual key information.</param>
<param name="modifers">Additional keys pressed.</param>
<returns>Returns false when not implemented.</returns>
</member>
<member name="M:Jacobi.Vst.Interop.Host.VstPluginCommandStub.SetEditorKnobMode(Jacobi.Vst.Core.VstKnobMode)" decl="true" source="c:\workspace\soundengine\vst.net\code\jacobi.vst.interop\host\vstplugincommandstub.h" line="289">
<summary>
Called by the host to set the mode for turning knobs.
</summary>
<param name="mode">The mode to use for turning knobs.</param>
<returns>Returns false when not implemented.</returns>
</member>
<member name="M:Jacobi.Vst.Interop.Host.VstPluginCommandStub.GetMidiProgramName(Jacobi.Vst.Core.VstMidiProgramName,System.Int32)" decl="true" source="c:\workspace\soundengine\vst.net\code\jacobi.vst.interop\host\vstplugincommandstub.h" line="295">
<summary>
Retrieves information about a midi program for a specific Midi <paramref name="channel"/>.
</summary>
<param name="midiProgram">Must not be null.</param>
<param name="channel">The zero-based Midi channel.</param>
<returns>Returns the number of implemented Midi programs or 0 if not implemented.</returns>
</member>
<member name="M:Jacobi.Vst.Interop.Host.VstPluginCommandStub.GetCurrentMidiProgramName(Jacobi.Vst.Core.VstMidiProgramName,System.Int32)" decl="true" source="c:\workspace\soundengine\vst.net\code\jacobi.vst.interop\host\vstplugincommandstub.h" line="302">
<summary>
Retrieves information about the current midi program for a specific Midi <paramref name="channel"/>.
</summary>
<param name="midiProgram">Must not be null.</param>
<param name="channel">The zero-based Midi channel.</param>
<returns>Returns the number of implemented Midi programs or 0 if not implemented.</returns>
</member>
<member name="M:Jacobi.Vst.Interop.Host.VstPluginCommandStub.GetMidiProgramCategory(Jacobi.Vst.Core.VstMidiProgramCategory,System.Int32)" decl="true" source="c:\workspace\soundengine\vst.net\code\jacobi.vst.interop\host\vstplugincommandstub.h" line="309">
<summary>
Retrieves information about a Midi Program Category.
</summary>
<param name="midiCat">Must not be null.</param>
<param name="channel">The zero-based Midi channel.</param>
<returns>Returns the total number of Midi program categories or 0 if not implemented.</returns>
</member>
<member name="M:Jacobi.Vst.Interop.Host.VstPluginCommandStub.HasMidiProgramsChanged(System.Int32)" decl="true" source="c:\workspace\soundengine\vst.net\code\jacobi.vst.interop\host\vstplugincommandstub.h" line="316">
<summary>
Indicates if the program for the specified Midi <paramref name="channel"/> has changed.
</summary>
<param name="channel">The zero-base Midi channel.</param>
<returns>Returns true if the Midi Program has changed, otherwise false is returned.</returns>
</member>
<member name="M:Jacobi.Vst.Interop.Host.VstPluginCommandStub.GetMidiKeyName(Jacobi.Vst.Core.VstMidiKeyName,System.Int32)" decl="true" source="c:\workspace\soundengine\vst.net\code\jacobi.vst.interop\host\vstplugincommandstub.h" line="322">
<summary>
Retrieves information about a Midi Key (or note).
</summary>
<param name="midiKeyName">Must not be null.</param>
<param name="channel">The zero-base Midi channel.</param>
<returns>Returns true when the <paramref name="midiKeyName"/>.Name was filled.</returns>
</member>
<member name="M:Jacobi.Vst.Interop.Host.VstPluginCommandStub.BeginSetProgram" decl="true" source="c:\workspace\soundengine\vst.net\code\jacobi.vst.interop\host\vstplugincommandstub.h" line="329">
<summary>
Called by the host just before a new Program is set.
</summary>
<returns>Returns false when not implemented.</returns>
</member>
<member name="M:Jacobi.Vst.Interop.Host.VstPluginCommandStub.EndSetProgram" decl="true" source="c:\workspace\soundengine\vst.net\code\jacobi.vst.interop\host\vstplugincommandstub.h" line="334">
<summary>
Called by the host just after a new Program is set.
</summary>
<returns>Returns false when not implemented.</returns>
</member>
<member name="M:Jacobi.Vst.Interop.Host.VstPluginCommandStub.GetSpeakerArrangement(Jacobi.Vst.Core.VstSpeakerArrangement@,Jacobi.Vst.Core.VstSpeakerArrangement@)" decl="true" source="c:\workspace\soundengine\vst.net\code\jacobi.vst.interop\host\vstplugincommandstub.h" line="341">
<summary>
Returns the speaker arrangements for the input and output of the plugin.
</summary>
<param name="input">Filled with the speaker arrangement for the plugin inputs.</param>
<param name="output">Filled with the speaker arrangement for the plugin outputs.</param>
<returns>Returns false when not implemented.</returns>
</member>
<member name="M:Jacobi.Vst.Interop.Host.VstPluginCommandStub.StartProcess" decl="true" source="c:\workspace\soundengine\vst.net\code\jacobi.vst.interop\host\vstplugincommandstub.h" line="353">
<summary>
Called just before the first call to Process is made.
</summary>
<returns>It is unclear what this return value represents.</returns>
</member>
<member name="M:Jacobi.Vst.Interop.Host.VstPluginCommandStub.StopProcess" decl="true" source="c:\workspace\soundengine\vst.net\code\jacobi.vst.interop\host\vstplugincommandstub.h" line="358">
<summary>
Called just after the last call to Process is made.
</summary>
<returns>It is unclear what this return value represents.</returns>
</member>
<member name="M:Jacobi.Vst.Interop.Host.VstPluginCommandStub.SetPanLaw(Jacobi.Vst.Core.VstPanLaw,System.Single)" decl="true" source="c:\workspace\soundengine\vst.net\code\jacobi.vst.interop\host\vstplugincommandstub.h" line="363">
<summary>
Informs the plugin of the pan algorithm to use.
</summary>
<param name="type">The pan algorithm type.</param>
<param name="gain">A gain factor.</param>
<returns>Returns false when not implemented.</returns>
</member>
<member name="M:Jacobi.Vst.Interop.Host.VstPluginCommandStub.BeginLoadBank(Jacobi.Vst.Core.VstPatchChunkInfo)" decl="true" source="c:\workspace\soundengine\vst.net\code\jacobi.vst.interop\host\vstplugincommandstub.h" line="370">
<summary>
Called by the host to query the plugin that supports persistence if the chunk can be read.
</summary>
<param name="chunkInfo">Must not be null.</param>
<returns>Returns <see cref="T:Jacobi.Vst.Core.VstCanDoResult"/><b>.Yes</b> if the plugin can read the data.</returns>
</member>
<member name="M:Jacobi.Vst.Interop.Host.VstPluginCommandStub.BeginLoadProgram(Jacobi.Vst.Core.VstPatchChunkInfo)" decl="true" source="c:\workspace\soundengine\vst.net\code\jacobi.vst.interop\host\vstplugincommandstub.h" line="376">
<summary>
Called by the host to query the plugin that supports persistence if the chunk can be read.
</summary>
<param name="chunkInfo">Must not be null.</param>
<returns>Returns <see cref="T:Jacobi.Vst.Core.VstCanDoResult"/><b>.Yes</b> if the plugin can read the data.</returns>
</member>
<member name="M:Jacobi.Vst.Interop.Host.VstPluginCommandStub.SetProcessPrecision(Jacobi.Vst.Core.VstProcessPrecision)" decl="true" source="c:\workspace\soundengine\vst.net\code\jacobi.vst.interop\host\vstplugincommandstub.h" line="384">
<summary>
Called by the host query inform the plugin on the precision of audio processing it supports.
</summary>
<param name="precision">An indication of either 32 bit or 64 bit samples.</param>
<returns>Returns true when the requested <paramref name="precision"/> is supported.</returns>
</member>
<member name="M:Jacobi.Vst.Interop.Host.VstPluginCommandStub.GetNumberOfMidiInputChannels" decl="true" source="c:\workspace\soundengine\vst.net\code\jacobi.vst.interop\host\vstplugincommandstub.h" line="390">
<summary>
Called by the host to retrieve the number of Midi In channels the plugin supports.
</summary>
<returns>Returns the number of Midi In channels, or 0 (zero) if not supported.</returns>
</member>
<member name="M:Jacobi.Vst.Interop.Host.VstPluginCommandStub.GetNumberOfMidiOutputChannels" decl="true" source="c:\workspace\soundengine\vst.net\code\jacobi.vst.interop\host\vstplugincommandstub.h" line="395">
<summary>
Called by the host to retrieve the number of Midi Out channels the plugin supports.
</summary>
<returns>Returns the number of Midi Out channels, or 0 (zero) if not supported.</returns>
</member>
<member name="P:Jacobi.Vst.Interop.Host.VstPluginCommandStub.PluginContext" decl="false" source="c:\workspace\soundengine\vst.net\code\jacobi.vst.interop\host\vstplugincommandstub.h" line="402">
<summary>
Gets or sets the Plugin Context for this implementation.
</summary>
</member>
<member name="M:Jacobi.Vst.Interop.Host.VstPluginCommandStub.ProcessAcc(Jacobi.Vst.Core.VstAudioBuffer[],Jacobi.Vst.Core.VstAudioBuffer[])" decl="true" source="c:\workspace\soundengine\vst.net\code\jacobi.vst.interop\host\vstplugincommandstub.h" line="412">
<summary>
Processes audio in an accumulating fashion.
</summary>
<param name="inputs">Audio input buffers. Must not be null.</param>
<param name="outputs">Audio output buffers. Must not be null.</param>
</member>
<member name="M:Jacobi.Vst.Interop.Host.VstPluginCommandStub.GetVu" decl="true" source="c:\workspace\soundengine\vst.net\code\jacobi.vst.interop\host\vstplugincommandstub.h" line="420">
<summary>
Called if the VstPluginDeprecatedInfo.DeprecatedFlags has the "HasClip" or "HasVu" flags set.
</summary>
<returns>Returns the current Vu value.</returns>
</member>
<member name="M:Jacobi.Vst.Interop.Host.VstPluginCommandStub.EditorKey(System.Int32)" decl="true" source="c:\workspace\soundengine\vst.net\code\jacobi.vst.interop\host\vstplugincommandstub.h" line="425">
<summary>
Called when a key stroke occurs in the editor.
</summary>
<param name="keycode">The key code value.</param>
<returns>Returns true if the call was successful.</returns>
</member>
<member name="M:Jacobi.Vst.Interop.Host.VstPluginCommandStub.EditorTop" decl="true" source="c:\workspace\soundengine\vst.net\code\jacobi.vst.interop\host\vstplugincommandstub.h" line="431">
<summary>
The window that hosts the plugin editor is put on top of other windows.
</summary>
<returns>Returns true if the call was successful.</returns>
</member>
<member name="M:Jacobi.Vst.Interop.Host.VstPluginCommandStub.EditorSleep" decl="true" source="c:\workspace\soundengine\vst.net\code\jacobi.vst.interop\host\vstplugincommandstub.h" line="436">
<summary>
The window that hosts the plugin editor is put in the background.
</summary>
<returns>Returns true if the call was successful.</returns>
</member>
<member name="M:Jacobi.Vst.Interop.Host.VstPluginCommandStub.Identify" decl="true" source="c:\workspace\soundengine\vst.net\code\jacobi.vst.interop\host\vstplugincommandstub.h" line="441">
<summary>
Returns an identifaction code.
</summary>
<returns>Returns 'NvEf' as an integer.</returns>
</member>
<member name="M:Jacobi.Vst.Interop.Host.VstPluginCommandStub.GetProgramCategoriesCount" decl="true" source="c:\workspace\soundengine\vst.net\code\jacobi.vst.interop\host\vstplugincommandstub.h" line="448">
<summary>
Retrieves the number of program categories.
</summary>
<returns>Returns the number of program categories.</returns>
</member>
<member name="M:Jacobi.Vst.Interop.Host.VstPluginCommandStub.CopyCurrentProgramTo(System.Int32)" decl="true" source="c:\workspace\soundengine\vst.net\code\jacobi.vst.interop\host\vstplugincommandstub.h" line="453">
<summary>
Copy the current program to the program at <paramref name="programIndex"/>.
</summary>
<param name="programIndex">A zero-based index into the program collection.</param>
<returns>Returns true if the call was successful.</returns>
</member>
<member name="M:Jacobi.Vst.Interop.Host.VstPluginCommandStub.ConnectInput(System.Int32,System.Boolean)" decl="true" source="c:\workspace\soundengine\vst.net\code\jacobi.vst.interop\host\vstplugincommandstub.h" line="459">
<summary>
Notifies the plugin of the fact that an input pin was dis/connected.
</summary>
<param name="inputIndex">A zero-based index into the input connection collection.</param>
<param name="connected">Indicates if the pin was connected (True) or disconnected (False).</param>
<returns>Returns true if the call was successful.</returns>
</member>
<member name="M:Jacobi.Vst.Interop.Host.VstPluginCommandStub.ConnectOutput(System.Int32,System.Boolean)" decl="true" source="c:\workspace\soundengine\vst.net\code\jacobi.vst.interop\host\vstplugincommandstub.h" line="466">
<summary>
Notifies the plugin of the fact that an output pin was dis/connected.
</summary>
<param name="outputIndex">A zero-based index into the output connection collection.</param>
<param name="connected">Indicates if the pin was connected (True) or disconnected (False).</param>
<returns>Returns true if the call was successful.</returns>
</member>
<member name="M:Jacobi.Vst.Interop.Host.VstPluginCommandStub.GetCurrentPosition" decl="true" source="c:\workspace\soundengine\vst.net\code\jacobi.vst.interop\host\vstplugincommandstub.h" line="473">
<summary>
For external DSP.
</summary>
<returns>Returns the current position.</returns>
<remarks>The <see cref="T:Jacobi.Vst.Core.Deprecated.VstPluginDeprecatedFlags"/>.ExtIsAsync 
must be set in order for this method to be called.</remarks>
</member>
<member name="M:Jacobi.Vst.Interop.Host.VstPluginCommandStub.GetDestinationBuffer" decl="true" source="c:\workspace\soundengine\vst.net\code\jacobi.vst.interop\host\vstplugincommandstub.h" line="480">
<summary>
For external DSP.
</summary>
<returns>Returns the destination audio buffer.</returns>
<remarks>The <see cref="T:Jacobi.Vst.Core.Deprecated.VstPluginDeprecatedFlags"/>.ExtHasBuffer 
must be set in order for this method to be called.</remarks>
</member>
<member name="M:Jacobi.Vst.Interop.Host.VstPluginCommandStub.SetBlockSizeAndSampleRate(System.Int32,System.Single)" decl="true" source="c:\workspace\soundengine\vst.net\code\jacobi.vst.interop\host\vstplugincommandstub.h" line="487">
<summary>
Assigns a new block size and sample rate value to the plugin.
</summary>
<param name="blockSize">The number of samples per frame (cycle).</param>
<param name="sampleRate">The new sample rate.</param>
<returns>Returns true if the call was successful.</returns>
</member>
<member name="M:Jacobi.Vst.Interop.Host.VstPluginCommandStub.GetErrorText" decl="true" source="c:\workspace\soundengine\vst.net\code\jacobi.vst.interop\host\vstplugincommandstub.h" line="494">
<summary>
Retrieves an error text from the plugin.
</summary>
<returns>Returns the error text.</returns>
<remarks>The length of the text must not exceed 256 characters.</remarks>
</member>
<member name="M:Jacobi.Vst.Interop.Host.VstPluginCommandStub.Idle" decl="true" source="c:\workspace\soundengine\vst.net\code\jacobi.vst.interop\host\vstplugincommandstub.h" line="500">
<summary>
Called by the host to allow some light idle processing by the plugin.
</summary>
<returns>Returns True when subsequent Idle calls should follow. 
False is returned when no further Idle processing is required.</returns>
</member>
<member name="M:Jacobi.Vst.Interop.Host.VstPluginCommandStub.GetIcon" decl="true" source="c:\workspace\soundengine\vst.net\code\jacobi.vst.interop\host\vstplugincommandstub.h" line="506">
<summary>
Retrieves an iconic representation of the plugin.
</summary>
<returns>Returns null when not supported.</returns>
<remarks>The VST specs are not final for this method. Not supported.</remarks>
</member>
<member name="M:Jacobi.Vst.Interop.Host.VstPluginCommandStub.SetViewPosition(System.Drawing.Point@)" decl="true" source="c:\workspace\soundengine\vst.net\code\jacobi.vst.interop\host\vstplugincommandstub.h" line="512">
<summary>
Moves the view to a new position inside the window.
</summary>
<param name="position">The x and y coordinates.</param>
<returns>Returns true if the call was successful.</returns>
</member>
<member name="M:Jacobi.Vst.Interop.Host.VstPluginCommandStub.KeysRequired" decl="true" source="c:\workspace\soundengine\vst.net\code\jacobi.vst.interop\host\vstplugincommandstub.h" line="518">
<summary>
Indicates if keys are required by the plugin.
</summary>
<returns>Returns true if keys are required.</returns>
</member>
<member name="M:Jacobi.Vst.Interop.Host.VstPluginCommandStub.#ctor(AEffect*)" decl="true" source="c:\workspace\soundengine\vst.net\code\jacobi.vst.interop\host\vstplugincommandstub.h" line="525">
<summary>Constructs a new instance based on an <b>AEffect</b> structure.</summary>
</member>
</members>
</doc>