﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Drawing;
using System.Data;
using System.Linq;
using System.Text;
using System.Windows.Forms;

namespace TinyFM8.UserControls
{
    public partial class panelOpX : UserControl
    {
        public PatchData pd;
        public EventHandler UIChanged;

        private bool InternalValueChange = false;


        public void LoadFromData()
        {
            // Block self change reporting
            InternalValueChange = true;
            knobNoiseAmp.Value    = pd.OPX_NoiseAmp    ;
            knobNoiseCutoff.Value = pd.OPX_NoiseCutOff ;
            knobNoiseReso.Value   = pd.OPX_NoiseReso   ;
            knobSatGain.Value     = pd.OPX_SatGain     ;
            knobSatLimit.Value    = pd.OPX_SatLimit    ;

            InternalValueChange = false;
        }

        public void SaveToData()
        {
            pd.OPX_NoiseAmp    = (byte)knobNoiseAmp.Value    ;
            pd.OPX_NoiseCutOff = (byte)knobNoiseCutoff.Value ;
            pd.OPX_NoiseReso   = (byte)knobNoiseReso.Value   ;
            pd.OPX_SatGain     = (byte)knobSatGain.Value     ;
            pd.OPX_SatLimit    = (byte)knobSatLimit.Value    ;
        }

        public panelOpX()
        {
            InitializeComponent();
        }

        private void ValueChanged(object sender, EventArgs e)
        {
            // Block re-entry caused by self changing 
            if (InternalValueChange)
                return;

            // Save data
            if (UIChanged != null)
                UIChanged(this, null);
        }
    }
}
