#include "FM8_AppAbstractionLayer.h"
#include "FM8_Compressor.h"
#include "FM8_Reverb.h"
#include "FM8_Synth.h"

// decleration
int LoadInterlacedStruct(UInt8*& pInterlacedData, UInt8*& pStructs, int nStructSize, int nLoadSize);

extern "C"
{
	// Regarding fltused see http://www.scene.org/showforum.php?forum=11&topic=43333 for details
	int _fltused = 0;

	__declspec(dllexport) void __stdcall  BuildWaveforms()
	{
		FM8_GenerateWaveTable();
	}

	__declspec(dllexport) void __stdcall SynthRender(FM8_Synth* Handle, float* pBuffer, int nBufferSize)
	{
		Handle->RenderToBuffer(pBuffer, nBufferSize);
	}

	__declspec(dllexport) void __stdcall CompressorRender(FM8_Compressor* Handle, float* pBuffer, int nBufferSize)
	{
		Handle->Render(pBuffer, nBufferSize);
	}

	__declspec(dllexport) void __stdcall ReverbRender(FM8_Reverb* pLeft, FM8_Reverb* pRight, float* pBuffer, int nBufferSize)
	{
		FM8_ReverbRender(pLeft, pRight, pBuffer, nBufferSize);
	}

	__declspec(dllexport) void __stdcall SetVelocity(FM8_Synth* Handle, float Velocity)
	{
		Handle->SetVelocity(Velocity);
	}

	__declspec(dllexport) void __stdcall PlayNote(FM8_Synth* Handle, int NoteIndex, int VoiceIndex)
	{
		Handle->PlayNote(NoteIndex, VoiceIndex);
	}

	__declspec(dllexport) void __stdcall OffNote(FM8_Synth* Handle)
	{
		Handle->ReleaseNote();
	}

	__declspec(dllexport) int __stdcall GetVoices(FM8_Synth* Handle)
	{
		return Handle->Unison_Voices;
	}

	__declspec(dllexport) int __stdcall GetNote(FM8_Synth* Handle)
	{
		return Handle->Note_Index;
	}

	__declspec(dllexport) int __stdcall GetTrackIndex(FM8_Synth* Handle)
	{
		return Handle->TrackIndex;
	}

	__declspec(dllexport) int __stdcall CreateCompressors(void* pBlock, FM8_Compressor** pCompressors)
	{
		return FM8_CreateCompressors(pBlock, pCompressors);
	}

	__declspec(dllexport) int __stdcall CreateReverbs(void* pBlock, FM8_Reverb** pReverb)
	{
		return FM8_CreateReverbs(pBlock, pReverb);
	}

	__declspec(dllexport) int __stdcall CreateInstruments(void* pBlock, FM8_Synth** pInstruments)
	{
		FM8_Synth* pInstArray;
		int nInstCount = FM8_LoadInstruments((UInt8*)pBlock, pInstArray);
		for (int i = 0; i < nInstCount; i++)
			pInstruments[i] = pInstArray + i;

		return nInstCount;
	}

	__declspec(dllexport) FM8_Synth*  __stdcall DuplicateInstrument(FM8_Synth* Handle)
	{
		FM8_Synth* pInstruments = (FM8_Synth*)FM8_mallocAlloc(sizeof(FM8_Synth));
		msys_memcpy(pInstruments, Handle, sizeof(FM8_Synth));
		return pInstruments;
	}

	__declspec(dllexport) void  __stdcall GetWaveform(int nWaveformIndex, float* pBuffer)
	{
		FM8_GenerateWaveTable();
		msys_memcpy(pBuffer, FM8_Waveform(nWaveformIndex), 0x10000 * sizeof(float));
	}

	__declspec(dllexport) void  __stdcall RenderEnvelope(FM8_Synth* Handle, int OpIndex, float FromT, float ToT, int Samples, float* pBuffer)
	{
		return Handle->RenderEnvelope(OpIndex, FromT, ToT, Samples, pBuffer);
	}
}