﻿using Jacobi.Vst.Core;
using Jacobi.Vst.Framework;
using Jacobi.Vst.Framework.Plugin;
using System;
using KSDManager;
using System.IO;
using System.Collections.Generic;
using System.Runtime.InteropServices;
using System.Windows.Forms;
using System.Text;

namespace ReverbFX
{
    public class AudioProcessor : VstPluginAudioProcessorBase
    {
        Plugin _plugin;

        public AudioProcessor(Plugin plugin)
            : base(2, 2, 0)
        {
            _plugin = plugin;
        }

        public override void Process(VstAudioBuffer[] inChannels, VstAudioBuffer[] outChannels)
        {
            if (_plugin.LeftHandle == IntPtr.Zero)
                return;

            // Convert to buffer
            float[] BufferOut = new float[inChannels[0].SampleCount * 2];
            for (int i = inChannels[0].SampleCount - 1; i >= 0; i--)
            {
                BufferOut[i * 2 + 0] = inChannels[0][i];
                BufferOut[i * 2 + 1] = inChannels[1][i];
            }

            SoundRenderInterface.ReverbRender(_plugin.LeftHandle, _plugin.RightHandle, BufferOut, BufferOut.Length / 2);

            // Convert to buffer
            for (int i = outChannels[0].SampleCount - 1; i >= 0; i--)
            {
                outChannels[0][i] = BufferOut[i * 2 + 0];
                outChannels[1][i] = BufferOut[i * 2 + 1];
            }
        }
    }
}
