﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.IO;

namespace NRenoiseTools.Xrns2MidiApp
{
    public class WaveWriter: IDisposable
    {
        public string Filename { get; private set; }

        private BinaryWriter bw;
        private int SampleCount = 0;

        public WaveWriter(string WaveFilename)
        {
            Filename = WaveFilename;
            bw = new BinaryWriter(new FileStream(Filename, FileMode.Create));
            WriteFileHeader();
        }

        public void Dispose()
        {
            Dispose(true);

            // Use SupressFinalize in case a subclass
            // of this type implements a finalizer.
            GC.SuppressFinalize(this);
        }

        protected virtual void Dispose(bool disposing)
        {
            if (bw != null)
            {
                WriteFileTrailer();
                bw.Close();
                bw = null;
            }
        }


        public void WriteData(short[] buffer)
        {
            // Convert to byte array
            var bytesArr = new byte[buffer.Length * sizeof(short)];
            Buffer.BlockCopy(buffer, 0, bytesArr, 0, buffer.Length * sizeof(short));

            // Write byte array
            bw.Write(bytesArr, 0, bytesArr.Length);
            SampleCount += bytesArr.Length;
        }

        private void WriteFileHeader()
        {
            char[] Riff = { 'R', 'I', 'F', 'F' };
            char[] Wave = { 'W', 'A', 'V', 'E' };
            char[] Fmt = { 'f', 'm', 't', ' ' };
            char[] Data = { 'd', 'a', 't', 'a' };
            short padding = 1;
            short channels = 2;
            short blockAlign = 4;
            short bitperSample = (short)(8 * channels);
            int sampleRate = 44100;
            int byteRate = 44100*blockAlign;
            int formatLength = 0x10;
            int length = 0; // fill this in later!

            bw.Write(Riff);
            bw.Write(length);
            bw.Write(Wave);
            bw.Write(Fmt);
            bw.Write(formatLength);
            bw.Write(padding);
            bw.Write(channels);
            bw.Write(sampleRate);
            bw.Write(byteRate);
            bw.Write(blockAlign);
            bw.Write(bitperSample);
            bw.Write(Data);
            bw.Write((int)0); // update sample later
        }

        private void WriteFileTrailer()
        {
            bw.Seek(4, SeekOrigin.Begin);
            bw.Write((int)(SampleCount + 36));
            bw.Seek(40, SeekOrigin.Begin);
            bw.Write(SampleCount);
            bw.Close();
        }

    }
}
