﻿using System;
using System.Collections.Generic;
using System.Text;

public class VariableStateFilter
{
    // Setup parameters
    private float Damp;
    private float Freq;
    private float Scale;

    // Outputs
    public float Low   = 0;
    public float High  = 0;
    public float Band  = 0;
    public float Notch = 0;

    public void Setup(float CutOffFreq, float SampleRate, float Resonance)
    {
        Freq  = 2f * (float)Math.PI * CutOffFreq / (SampleRate * 2f);
        Damp = 2f * (1f - (float)Math.Pow(Resonance * 0.97f, 0.25f));
        Scale = 1f - Resonance * 0.7f; 
    }

    public void ExecuteFilter(float input)
    {
        for (int i = 0; i < 2; i++)
        {
            Low   = Low + Freq * Band;
            High  = Scale * input - Low - Damp * Band;
            Band  = Freq * High + Band;
            Notch = High + Low;
        }
    }
}
