﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.IO;


public class FMInstrument
{
    // loaded ints
    public int   OPX_NoiseCutOff;
    public int   OPX_NoiseReso;   // (float)divided by 100
    public int   OPX_NoiseAmp;
    public int   OPX_SatLimit;    // (float)divided by 100
    public int   OPX_SatGain;     // (float)divided by 100
    public int   Pitch_Envelope;  // (float)divided by 100
    public int   Pitch_Transp;    // (float)Convert to float

    public int[][] FM_Matrix; // Matrix=8*8=64;
    public int[] OP_Active;           // Arr=9
    public int[] OP_Waveform;
    public int[] OP_Velocity;
    public int[] OP_OutVol;
    public int[] OP_OutPan;
    public int[] OP_KeyScale;
    public int[] OP_KeyScale_Length;
    public int[] OP_Env_SustainLoopStart;
    public int[] OP_Env_SustainLoopEnd;
    public int[] OP_Env_Length;

    // loaded floats
    public float[] OP_Offset; // Loaded as float
    public float[] OP_Ratio;  // Loaded as float

    public float[][] OP_KeySc_Note;
    public float[][] OP_KeySc_Level;
    public float[][] OP_KeySc_Slope;

    public float[][] OP_Env_Level; 
    public float[][] OP_Env_Slope; 
    public float[][] OP_Env_RelTime; 

    // Pre-Computed fields
    public float     pcPitch_Transp;
    public float[][] pcFM_Matrix;
    public float[]   pcOP_OutVol;
    public float[][] pcOP_Env_AbsTime; // Needs to be computed manual
    
    // Current note info
    public int ActiveOperators;
    public int Note_Index = -1;
    public float Note_Velocity = 1;
    public int Note_PressTime;
    public int Note_ReleaseTime;

    // DSP related
    public float[] FMMatrixValue = new float[8];
    public float[] OscPos = new float[6];
    public static int TotalActiveOp = 0;

    // General helpers
    public Random rnd = new Random();
    public VariableStateFilter OpX_VSF = new VariableStateFilter();

    public int Index;

    const float SampleRate = 48000f;

    public float GetScaleValue(int OpIndex, float NoteIndex)
    {
        // OP 1 KeySc:
        // Note:  0.00000 58.00000  96.00000 127.00000 
        // Level: 0.00000  0.00000 -14.76923 -39.38462 
        // Slope: 0.50000  0.50000   0.41000   0.81000 

        // Search for segment
        int Seg_Index = 0;
        while (NoteIndex >= (int)OP_KeySc_Note[OpIndex][Seg_Index + 1])
            Seg_Index++;

        // Compute Interpolator
        float SegmentSlope = -(OP_KeySc_Slope[OpIndex][Seg_Index + 1] - 0.5f);
        SegmentSlope = SegmentSlope * 20f + 0.0001f;

        // Compute point in segment 
        float CurrKeyScale = OP_KeySc_Note[OpIndex][Seg_Index];
        float NextKeyScale = OP_KeySc_Note[OpIndex][Seg_Index + 1];
        float OffsetInSegment = (NoteIndex - CurrKeyScale) / (NextKeyScale - CurrKeyScale);
        float Interpolator = (float)((Math.Exp(OffsetInSegment * SegmentSlope) - 1.0) / (Math.Exp(SegmentSlope) - 1.0));

        return OP_KeySc_Level[OpIndex][Seg_Index] +
               (OP_KeySc_Level[OpIndex][Seg_Index + 1] -
                OP_KeySc_Level[OpIndex][Seg_Index]) * Interpolator;
    }

    public float GetEnvValue(int OpIndex, float Time_PressToNow, float Time_PressToRelease, out bool bPostEnv)
    {
        // Sample envelope data:
        //   Level:  1.00000 0.50000 0.10000 
        //   R-Time: 0.10000 0.70000 0.20000 
        //   A-Time: 0.00000 0.10000 0.80000 
        //   Slope:  0.50000 0.90000 0.90000 
        //
        //   OP_Env_SustainLoopStart:      0  
        //   OP_Env_SustainLoopEnd:        1  
        try
        {
            // Get sustain loop time
            int ValuesCount     = OP_Env_Length[OpIndex] - 1;
            int LoopStartIndex  = OP_Env_SustainLoopStart[OpIndex] + 1;
            int LoopEndIndex    = Math.Min(OP_Env_SustainLoopEnd[OpIndex] + 1, ValuesCount);
            float LoopStartTime = pcOP_Env_AbsTime[OpIndex][LoopStartIndex];
            float LoopEndTime   = pcOP_Env_AbsTime[OpIndex][LoopEndIndex];
            bool bLoopExists    = (LoopStartIndex != LoopEndIndex);

            // Local members
            float t;
            float PrevLevel = 0;
            int Seg_Index;
            bPostEnv = false;

            // If key was release 
            if (Time_PressToRelease > 0)
            {
                Seg_Index = LoopEndIndex;
                PrevLevel = GetEnvValue(OpIndex, Time_PressToRelease, 0, out bPostEnv);
                t = LoopEndTime + (Time_PressToNow - Time_PressToRelease);
            }
            else
            {
                t = Time_PressToNow;

                // Inside loop?
                if ((t >= LoopStartTime) && (bLoopExists))
                {
                    // Set segment search to loop start
                    Seg_Index = LoopStartIndex;

                    // Overlapped ?   
                    if (t >= LoopEndTime)
                    {
                        // If overlapped, asuume prev level is the end of the loop
                        PrevLevel = OP_Env_Level[OpIndex][LoopEndIndex - 1];
                    }
                    else
                    {
                        PrevLevel = OP_Env_Level[OpIndex][LoopStartIndex - 1];
                    }

                    t = LoopStartTime + (t - LoopStartTime) % (LoopEndTime - LoopStartTime);
                }
                else
                {
                    // Set segment search to start
                    Seg_Index = 0;

                    // If before the loop, assume prev level is end level (don't know why this works like this)
                    PrevLevel = OP_Env_Level[OpIndex][ValuesCount];
                }
            }

            // Find Segment
            // At this point "t" should be smaller than the absolute time of the segment Seg_Index.
            // We're search for the last segment that DO NOT over shoots "t"
            while ((Seg_Index <= ValuesCount) && (t > pcOP_Env_AbsTime[OpIndex][Seg_Index + 1]))
            {
                PrevLevel = OP_Env_Level[OpIndex][Seg_Index];
                Seg_Index++;
            }

            // Exit if after envelope
            //if (Seg_Index >= ValuesCount)
            if (t >= pcOP_Env_AbsTime[OpIndex][ValuesCount + 1])
            {
                bPostEnv = true;
                return OP_Env_Level[OpIndex][ValuesCount];
            }

            // Compute Interpolator
            float SegmentSlope = (0.5001f - OP_Env_Slope[OpIndex][Seg_Index]) * 15f;
            float SegmentWidth = OP_Env_RelTime[OpIndex][Seg_Index];
            float TimeInSegment = (SegmentWidth > 0) ? Math.Min(t - pcOP_Env_AbsTime[OpIndex][Seg_Index], SegmentWidth) / SegmentWidth : 0;
            float Interpolator = (float)((Math.Exp(TimeInSegment * SegmentSlope) - 1.0) / (Math.Exp(SegmentSlope) - 1.0));
            return PrevLevel + (OP_Env_Level[OpIndex][Seg_Index] - PrevLevel) * Interpolator;
        }
        catch (Exception ex)
        {
            System.Diagnostics.Debugger.Break();
            bPostEnv = false;
        }
        return 0 ;
    }

    private float SmoothStep(double t, double smooth)
    {
        return (float)((Math.Exp(Math.Abs(t) * smooth) - 1) / (Math.Exp(smooth) - 1) * Math.Sign(t));
    }

    public void Setup()
    {
        // Scale FM-Matrix
        pcFM_Matrix = new float[8][];
        for (int i = 0; i < 8; i++)
        {
            pcFM_Matrix[i] = new float[8];
            for (int j = 0; j < 8; j++)
                pcFM_Matrix[i][j] = (float)Math.Pow(FM_Matrix[i][j] / 100f, 2) * 2.113f;
        }

        pcOP_OutVol = new float[8];
        for (int i = 0; i < 8; i++)
        {
            // Scale output
            pcOP_OutVol[i] = (float)Math.Pow(OP_OutVol[i] / 100f, 2) * 0.111f;

            // Scale self feedback
            pcFM_Matrix[i][i] *= 0.5f;

            // scale OP-X inputs
            pcFM_Matrix[6][i] *= (1 / 2.113f);
        }

        // Rescale OP-X feedbacks
        for (int i = 0; i < 6; i++)
            pcFM_Matrix[i][6] *= 0.75f;

        // Compute the OpX cut-off frequancy
        float OpX_CutOff = (float)Math.Pow(10, OPX_NoiseCutOff / 24.51472341d);
        OpX_VSF.Setup(OpX_CutOff, SampleRate, OPX_NoiseReso / 100f);

        // Precompute Transp
        pcPitch_Transp = (float)Math.Pow(2, Pitch_Transp / 12f);
    }

    public void RenderToBuffer(int StartSample, float[] buffer)
    {
        //Exit if voice is ideal
        if ((Note_Index == -1) || (ActiveOperators == 0))
            return;

        // Precompute things
        float PitchEnvScale = (2.8291f / 10000f) * Pitch_Envelope * Pitch_Envelope;
        float BaseFreq = (float)Math.Pow(2f, (Note_Index - 69f) / 12f) * 440f;

        bool PostEnv;
        float PitchScale = 1;
        float[] KeyScaleAmp = new float[8];
        float[] VelocityAmp = new float[8];
        float[] EnvelopeAmp = new float[8];

        
        for (int row = 0; row < 8; row++)
        {
            // Compute velocity amplification
            float OpVelocity = OP_Velocity[row];
            float VelAmp;
            if (OpVelocity > 0)
                VelAmp = 0.025f * (float)Math.Log(Note_Velocity, Math.E) + 0.011f;
            else
                VelAmp = 0.0274f * Note_Velocity * Note_Velocity + 0.0088f * Note_Velocity - 0.0159f;
            VelocityAmp[row] = (float)Math.Exp(OpVelocity * VelAmp);

            // Compute Keyscales
            KeyScaleAmp[row] = (float)Math.Exp(9.210340372f * ((GetScaleValue(row, Note_Index) + 80) / 80)) / 10000;
        }

        
        // For each streao-sample in buffer 
        for (int index = 0; index < buffer.Length / 2; index++)
        {
            // Compute times
            float PressTime = ((StartSample + index) - Note_PressTime) / SampleRate;
            float ReleaseTime = ((StartSample + index) - Note_ReleaseTime) / SampleRate;
            float PressToRelease = PressTime - ReleaseTime;
            if (PressToRelease < 0) PressToRelease = 0;

            //if ((index & 15) == 0)
            {
                //float TimeScale = (float)Math.Exp((48 - Note_Index) * 0.000048f * pcPitch_Transp * OP_KeyScale[8]);
                PitchScale = GetEnvValue(8, PressTime, PressToRelease, out PostEnv);
                PitchScale = (float)Math.Exp(PitchEnvScale * PitchScale);
            }

            // Process operators
            ActiveOperators = 0;
            float TotalOutput = 0;
            for (int row = 0; row < 8; row++)
            {
                // Check if operator is non-active
                if (EnvelopeAmp[row] == float.MaxValue)
                    continue;

                // Check that OP is active
                if (OP_Active[row] == 0)
                {
                    EnvelopeAmp[row] = float.MaxValue;
                    continue;
                }


                /*if ((index & 15) == 0)
                {*/
                    // Compute Time scaling (optional)
                    float TimeScale = (float)Math.Exp((48 - Note_Index) * 0.000048f * pcPitch_Transp * OP_KeyScale[row]);

                    // Perform envelope and key scaling
                    EnvelopeAmp[row] = GetEnvValue(row, PressTime / TimeScale, PressToRelease / TimeScale, out PostEnv);
                    if (float.IsNaN(EnvelopeAmp[row]))
                        0.ToString();
                    if (PostEnv)
                    {
                        EnvelopeAmp[row] = float.MaxValue;
                        continue;
                    }
                //}

                // Collect inputs and feedbacks
                float OpInput = 0f;
                for (int i = 0; i < 8; i++)
                    if (FM_Matrix[row][i] != 0)
                        OpInput += pcFM_Matrix[row][i] * FMMatrixValue[i];

                float OscOutput = 0;
                if (row < 6)
                {
                    // Compute Osc state
                    float OscFreq = BaseFreq * PitchScale * OP_Ratio[row] * pcPitch_Transp + OP_Offset[row];
                    OscPos[row] = (1000 + OscPos[row] + OscFreq / SampleRate) % 1;

                    // Compute Osc new state (adjusted by input)
                    float OscInput = (1000 + OscPos[row] + OpInput) % 1;

                    switch (OP_Waveform[row])
                    {
                        case 0:
                        case 1: OscOutput = (float)Math.Sin(2 * Math.PI * OscInput);
                            break;

                        case 2: OscOutput = (float)Math.Abs(OscInput - 0.5) * 4 - 1;
                            break;

                        case 3: OscOutput = OscInput > 0.5 ? +1 : -1;
                            break;

                        case 4: OscOutput = 1 - OscInput;
                            break;

                        case 5: OscOutput = SmoothStep(Math.Sin(2 * Math.PI * OscInput), -5);
                            break;

                        case 6:
                            OscOutput = (float)Math.Sin(2 * Math.PI * OscInput);
                            OscOutput = (float)Math.Pow(OscOutput, 7);
                            OscOutput = SmoothStep(OscOutput, -5);
                            break;

                        case 7:
                            OscInput *= 2;
                            if (OscInput > 1) OscInput = 1;

                            OscOutput = (float)Math.Sin(2 * Math.PI * OscInput);
                            OscOutput = (float)Math.Pow(OscOutput, 7);
                            OscOutput = SmoothStep(OscOutput, -5);
                            break;
                    }
                    // Compute Actual operator value

                    // 1 + 3 + 5 Square 
                    //float OscOutput = Math.Sin(2 * Math.PI * OscInput) + Math.Sin(2 * Math.PI * OscInput * 3) / 3 + Math.Sin(2 * Math.PI * OscInput * 5) / 5;

                    // 1 + 2 + 3 Saw 
                    // float OscOutput = Math.Sin(2 * Math.PI * OscInput) +Math.Sin(2 * Math.PI * OscInput * 2) / 2 + Math.Sin(2 * Math.PI * OscInput * 3) / 3;

                    // 1+k
                    //int k = 3;
                    //float OscOutput = Math.Sin(2 * Math.PI * OscInput) * Track1 + Math.Sin(2 * Math.PI * OscInput * k) * Track2;
                }
                else if (row == 6) // X Op
                {
                    // Generate noise
                    float noiseSample = 0;
                    for (int j = 0; j < 12; j++)
                        noiseSample += (float)rnd.NextDouble();
                    OpInput += (float)(noiseSample - 6) * 0.0015f * OPX_NoiseAmp;

                    // Perform low pass
                    OpX_VSF.ExecuteFilter(OpInput);
                    OscOutput = OpX_VSF.Low;

                    // Wave shaper (http://www.musicdsp.org/showone.php?id=86)
                    float Gain = (1.1536f / 10000f) * OPX_SatGain * OPX_SatGain - 0.25f * 0.5f + 0.0878f;
                    float Level = (float)Math.Pow(0.00001 + OPX_SatLimit / 100f, 3.5f);

                    // Scale and remove sign (also store sign)
                    float Sign = Math.Sign(OscOutput);
                    OscOutput = Math.Abs(OscOutput) * Gain * (1 / Level);

                    // Perofrm clipping
                    if (OscOutput > 1) OscOutput = 1;

                    // Peroofrm soft clipping
                    OscOutput = Sign * (1.45f * OscOutput - 0.2175f * (OscOutput * OscOutput + OscOutput * OscOutput * OscOutput));

                    // Rescale level
                    OscOutput *= Level * 4;
                }

                FMMatrixValue[row] = OscOutput * EnvelopeAmp[row] * KeyScaleAmp[row] * VelocityAmp[row];

                // Add operator to output
                TotalOutput += FMMatrixValue[row] * pcOP_OutVol[row];
                ActiveOperators++;
            }

            // Check if terminated
            if (ActiveOperators == 0)
                return;

            if (index == 0)
                TotalActiveOp++;

            // Store value
            buffer[index * 2 + 0] += TotalOutput;
            buffer[index * 2 + 1] += TotalOutput; 
        }
    }
}
