; --------------------------------------------
; PtPack v2.4 - Replay routine
; Written by hitchhikr / Neural
; Based on the original protracker replay.

; --------------------------------------------
; Constants

; Uncomment all these for a complete replay
;PTA_EXTEND                  equ     1
;PTA_ARPEGGIO                equ     1
;PTA_PACKED_SMP              equ     1              ; module uses packed samples
;PTA_PORTAMENTOUP            equ     1
;PTA_PORTAMENTODOWN          equ     1
;PTA_TONEPORTAMENTO          equ     1
;PTA_VIBRATO                 equ     1
;PTA_TONEPLUSVOLSLIDE        equ     1
;PTA_VIBRATOPLUSVOLSLIDE     equ     1
;PTA_TREMOLO                 equ     1
;PTA_SAMPLEOFFSET            equ     1
;PTA_VOLUMESLIDE             equ     1
;PTA_POSITIONJUMP            equ     1
;PTA_VOLUMECHANGE            equ     1
;PTA_PATTERNBREAK            equ     1
;PTA_SETSPEED                equ     1
;PTA_SETSYNCHRO              equ     1
;PTA_EFX_FILTERONOFF         equ     1
;PTA_EFX_FINEPORTAUP         equ     1
;PTA_EFX_FINEPORTADOWN       equ     1
;PTA_EFX_SETGLISSCONTROL     equ     1
;PTA_EFX_SETVIBRATOCONTROL   equ     1
;PTA_EFX_SETFINETUNE         equ     1
;PTA_EFX_JUMPLOOP            equ     1
;PTA_EFX_SETTREMOLOCONTROL   equ     1
;PTA_EFX_KARPLUSTRONG        equ     1
;PTA_EFX_RETRIGNOTE          equ     1
;PTA_EFX_VOLUMEFINEUP        equ     1
;PTA_EFX_VOLUMEFINEDOWN      equ     1
;PTA_EFX_NOTECUT             equ     1
;PTA_EFX_NOTEDELAY           equ     1
;PTA_EFX_PATTERNDELAY        equ     1
;PTA_EFX_FUNKIT              equ     1
;PTA_FINETUNE_1              equ     1
;PTA_FINETUNE_2              equ     1
;PTA_FINETUNE_3              equ     1
;PTA_FINETUNE_4              equ     1
;PTA_FINETUNE_5              equ     1
;PTA_FINETUNE_6              equ     1
;PTA_FINETUNE_7              equ     1
;PTA_FINETUNE_M8             equ     1
;PTA_FINETUNE_M7             equ     1
;PTA_FINETUNE_M6             equ     1
;PTA_FINETUNE_M5             equ     1
;PTA_FINETUNE_M4             equ     1
;PTA_FINETUNE_M3             equ     1
;PTA_FINETUNE_M2             equ     1
;PTA_FINETUNE_M1             equ     1

n_note                      equ     0  ; W
n_cmd                       equ     2  ; W
n_cmdlo                     equ     3  ; B
n_start                     equ     4  ; L
n_length                    equ     8  ; W
n_loopstart                 equ     10 ; L
n_replen                    equ     14 ; W
n_period                    equ     16 ; W
n_finetune                  equ     18 ; B
n_volume                    equ     19 ; B
n_dmabit                    equ     20 ; W
n_toneportdirec             equ     22 ; B
n_toneportspeed             equ     23 ; B
n_wantedperiod              equ     24 ; W
n_vibratocmd                equ     26 ; B
n_vibratopos                equ     27 ; B
n_tremolocmd                equ     28 ; B
n_tremolopos                equ     29 ; B
n_wavecontrol               equ     30 ; B
n_glissfunk                 equ     31 ; B
n_sampleoffset              equ     32 ; B
n_pattpos                   equ     33 ; B
n_loopcount                 equ     34 ; B
n_funkoffset                equ     35 ; B
n_wavestart                 equ     36 ; L
n_realvolume                equ     40 ; B
n_gap                       equ     41 ; B
n_noteidx                   equ     42 ; W

ciatalo                     equ     $400
ciatahi                     equ     $500
ciatblo                     equ     $600
ciatbhi                     equ     $700
ciaicr                      equ     $d00
ciacra                      equ     $e00
ciacrb                      equ     $f00

                        ifnd NO_CONSTANTS
                            include "constants.inc"
                        endc

; --------------------------------------------
; Exe & replay stub (only used when creating a stand alone exe)
    ifd PTA_EXE_MOD
                            section pta_replay,code

AttnFlags                   equ     296
_LVOSupervisor              equ     -30

pta_stub:                   move.w  $dff01c,-(a7)
                            move.l  4.w,a6
                            move.b  AttnFlags+1(a6),d0
                            moveq   #0,d1                       ; vbr at 0
                            btst.l  #1,d0
                            beq.b   no_vbr
                            lea     get_vbr(pc),a5
                            jsr     _LVOSupervisor(a6)
no_vbr:                     move.l  d1,d0
                            bsr.w   pta_init
pta_wloop:                  lea     pta_Enable(pc),a0
                            tst.b   (a0)
                            beq.b   pta_fx_f00
                            btst    #6,$bfe001
                            bne.b   pta_wloop
pta_fx_f00:                 bsr.w   pta_end
                            move.w  (a7)+,d0
                            or.w    #$c000,d0
                            move.w  d0,$dff09a
                            move.l  4.w,a6
                            jsr     -138(a6)
                            moveq   #0,d0
                            rts
get_vbr:                    dc.w    $4e7a,$1801                 ; movec   vbr,d1
                            rte
    else

        ; Useless and only there so vasm does not complain
        ifd PTA_CREATE_BIN
                            org     0
        endc

    endc

; --------------------------------------------
; Tempo
    ifd PTA_SETSPEED
pta_set_tempo:              move.l  pta_TimerValue-pta_var(a2),d2
                            divu    d0,d2
                            lea     $bfd000,a1
                            move.b  d2,ciatalo(a1)
                            lsr.w   #8,d2
                            move.b  d2,ciatahi(a1)
                            move.b  #$83,ciaicr(a1)
                            move.b  #$11,ciacra(a1)
                            rts
    endc

; --------------------------------------------
; Replay routine initialization
; d0: VBR
; a0: .pta file
; a1: .smp file or 0
pta_init:                   movem.l d0-a6,-(a7)
                            lea     pta_var(pc),a2

    ifd PTA_EXE_MOD
                            lea     pta_data-pta_var(a2),a0
    endc

                            move.l  a0,pta_SongDataPtr-pta_var(a2)
                            add.l   #$78,d0                     ; vbr + $78
                            move.l  d0,pta_vbr-pta_var(a2)
    
                            moveq   #0,d0
                            move.w  14(a0),d0
                            move.l  d0,pta_patternssize-pta_var(a2)
                            lsr.w   #2,d0
                            move.l  d0,pta_chunksize-pta_var(a2)
    
                            ; Depack the samples
                            moveq   #0,d7
                            move.b  12(a0),d7
                            lea     16(a0),a6                   ; samples lengths

    ifnd PTA_EXE_MOD
                            move.l  a1,d0                       ; do we use a separate samples file ?
                            beq.b   pta_no_smp_file
                            move.l  d0,a0
                            bra.b   pta_process_samples
pta_no_smp_file:            
    endc
                            add.l   8(a0),a0                    ; samples pool
pta_process_samples:        lea     pta_SampleStarts-pta_var(a2),a4
pta_depack_samples:         moveq   #0,d1
                            move.w  (a6),d1
                            add.l   d1,d1                       ; real sample length
                            move.l  a0,(a4)+                    ; store sample address

    ifd PTA_PACKED_SMP
                            movem.l d1/d7/a0/a4/a6,-(a7)
                            lea     (a0),a1                     ; unpacked dest
                            moveq   #0,d0                       ; packed length
                            move.b  (a0)+,d0
                            lsl.w   #8,d0
                            move.b  (a0)+,d0
                            sub.l   d0,d1
                            add.l   d0,d0
                            lea     (a1,d1.l),a0                ; packed source
                            bsr.w   pta_smp_depacker
                            movem.l (a7)+,d1/d7/a0/a4/a6
    endc

                            clr.w   (a0)
                            lea     (a0,d1.l),a0                ; next sample
                            addq.w  #8,a6
                            dbf     d7,pta_depack_samples
    
                            bset.b  #1,$bfe001
                            lea     pta_var(pc),a2
                            move.b  #6,pta_speed-pta_var(a2)
                            clr.b   pta_counter-pta_var(a2)
                            clr.b   pta_SongPos-pta_var(a2)
                            clr.w   pta_PatternPos-pta_var(a2)

                            move.w  #$4000,$dff09a
                            move.l  pta_vbr-pta_var(a2),a0
                            move.l  (a0),pta_old_irq-pta_var(a2)

                            lea     $bfd000,a3
                            lea     pta_oldCiaTimers-pta_var(a2),a1
                            move.b  #$7f,ciaicr(a3)
                            move.b  ciatalo(a3),(a1)+
                            move.b  ciatahi(a3),(a1)+
                            move.b  ciatblo(a3),(a1)+
                            move.b  ciatbhi(a3),(a1)+
                            bsr.w   pta_end

                            lea     pta_repeat_interrupt-pta_var(a2),a0
                            move.l  a0,pta_repeat_irq-pta_var(a2)

                            move.l  #1773447,d0
                            move.l  d0,pta_TimerValue-pta_var(a2)
                            divu    #125,d0                     ; Default to normal 50 Hz timer
                            move.b  d0,ciatalo(a3)
                            lsr.w   #8,d0
                            move.b  d0,ciatahi(a3)
                            lea     pta_main_interrupt-pta_var(a2),a0
                            move.l  a0,pta_main_irq-pta_var(a2)
                            move.l  pta_vbr(pc),a1
                            move.l  a0,(a1)
                            move.b  #$83,ciaicr(a3)
                            move.b  #$11,ciacra(a3)
                            move.w  #$e000,$dff09a
                            st.b    pta_Enable-pta_var(a2)
                            movem.l (a7)+,d0-a6
                            rts

; --------------------------------------------
; Stop replay
pta_end:                    movem.l d0/a0/a1,-(a7)
                            lea     $dff000,a0
                            move.w  #$4000,$9a(a0)
                            move.l  pta_vbr(pc),a0
                            move.l  pta_old_irq(pc),(a0)
                            lea     $bfd000,a0
                            lea     pta_oldCiaTimers(pc),a1
                            move.b  (a1)+,ciatalo(a0)
                            move.b  (a1)+,ciatahi(a0)
                            move.b  (a1)+,ciatblo(a0)
                            move.b  (a1)+,ciatbhi(a0)
                            move.b  #$10,ciacra(a0)
                            move.b  #$10,ciacrb(a0)
                            lea     pta_Enable(pc),a0
                            sf.b    (a0)
                            lea     $dff000,a0
                            moveq   #0,d0
                            move.w  #$f,$96(a0)
                            move.w  d0,$a8(a0)
                            move.w  d0,$b8(a0)
                            move.w  d0,$c8(a0)
                            move.w  d0,$d8(a0)
                            movem.l (a7)+,d0/a0/a1
                            rts

; --------------------------------------------
; Depack a sample
    ifd PTA_PACKED_SMP
pta_smp_depacker:           move.l  d0,d7
                            lea     pta_stepsizeTable(pc),a4
                            move.w  (a4),d1
                            lea     pta_indexTable(pc),a3
                            lea     pta_bufferstep(pc),a2
                            sf.b    (a2)
                            moveq   #0,d0
                            moveq   #0,d6
                            moveq   #0,d3
                            moveq   #0,d4
                            move.l  d4,a5
pta_depack_sample:          tst.b   (a2)
                            beq.b   pta_load_new_byte
                            move.b  d2,d3
                            and.b   #$f,d3
                            bra.b   pta_no_smp_new_byte
pta_load_new_byte:          move.b  (a0)+,d2
                            move.b  d2,d3
                            lsr.b   #4,d3
pta_no_smp_new_byte:        not.b   (a2)
                            move.w  d3,d6
                            add.w   d6,d6
                            add.w   (a3,d6.w),d4
                            bge.b   pta_min_index
                            clr.w   d4
pta_min_index:              cmp.w   #88,d4
                            ble.b   pta_max_index
                            moveq   #88,d4
pta_max_index:              move.b  d3,d5
                            and.b   #8,d5
                            and.b   #7,d3
                            move.w  d1,d0
                            asr.w   #3,d0
                            move.b  d3,d6
                            and.b   #4,d6
                            beq.b   pta_delta_1
                            add.w   d1,d0
pta_delta_1:                move.b  d3,d6
                            and.b   #2,d6
                            beq.b   pta_delta_2
                            move.w  d1,d6
                            asr.w   #1,d6
                            add.w   d6,d0
pta_delta_2:                move.b  d3,d6
                            and.b   #1,d6
                            beq.b   pta_delta_3
                            move.w  d1,d6
                            asr.w   #2,d6
                            add.w   d6,d0
pta_delta_3:                tst.b   d5
                            beq.b   pta_set_sign
                            sub.l   d0,a5
                            bra.b   pta_no_sign
pta_set_sign:               add.l   d0,a5
pta_no_sign:                move.w  d4,d6
                            add.w   d6,d6
                            move.w  (a4,d6.w),d1
                            move.l  a5,d6
                            cmp.l   #32767,d6
                            ble.b   pta_max_clamp
                            move.l  #32767,d6
pta_max_clamp:              cmp.l   #-32767,d6
                            bge.b   pta_min_clamp
                            move.l  #-32767,d6
pta_min_clamp:              move.l  d6,a5
                            asr.w   #8,d6
                            move.b  d6,(a1)+
                            subq.l  #1,d7
                            bne.w   pta_depack_sample
                            rts
    endc

; --------------------------------------------
; Interrupts
pta_repeat_interrupt:       tst.b   $bfdd00
                            pea     (a0)
                            lea     $dff09c,a0
                            move.w  #$2000,(a0)
                            move.w  #$2000,(a0)
                            addq.w  #4,a0
                            move.l  pta_chan1temp+n_loopstart(pc),(a0)+
                            move.w  pta_chan1temp+n_replen(pc),(a0)
                            lea     12(a0),a0
                            move.l  pta_chan2temp+n_loopstart(pc),(a0)+
                            move.w  pta_chan2temp+n_replen(pc),(a0)
                            lea     12(a0),a0
                            move.l  pta_chan3temp+n_loopstart(pc),(a0)+
                            move.w  pta_chan3temp+n_replen(pc),(a0)
                            lea     12(a0),a0
                            move.l  pta_chan4temp+n_loopstart(pc),(a0)+
                            move.w  pta_chan4temp+n_replen(pc),(a0)
                            move.l  pta_vbr(pc),a0
                            move.l  pta_main_irq(pc),(a0)
                            move.l  (a7)+,a0
                            rte

pta_dma_interrupt:          tst.b   $bfdd00
                            pea     (a0)
                            lea     $dff09c,a0
                            move.w  #$2000,(a0)
                            move.w  #$2000,(a0)
                            move.b  #$19,$bfdf00
                            move.w  pta_DMACONtemp(pc),-6(a0)
                            move.l  pta_vbr(pc),a0
                            move.l  pta_repeat_irq(pc),(a0)
                            move.l  (a7)+,a0
                            rte

; --------------------------------------------
; Replay the module
pta_main_interrupt:         tst.b   $bfdd00
                            movem.l d0-d3/a0-a6,-(a7)
                            lea     $dff09c,a0
                            move.w  #$2000,(a0)
                            move.w  #$2000,(a0)
                            lea     pta_var(pc),a2
                            sf.b    pta_synchro-pta_var(a2)
                            tst.b   pta_Enable-pta_var(a2)
                            beq.w   pta_exit
                            addq.b  #1,pta_counter-pta_var(a2)
                            move.b  pta_counter-pta_var(a2),d0
                            cmp.b   pta_speed-pta_var(a2),d0
                            blo.b   pta_NoNewNote
                            clr.b   pta_counter-pta_var(a2)
                            tst.b   pta_PattDelTime2-pta_var(a2)
                            beq.w   pta_GetNewNote
                            bsr.b   pta_NoNewAllChannels
                            bra.w   pta_dskip

pta_NoNewNote:              bsr.b   pta_NoNewAllChannels
                            bra.w   pta_NoNewPosYet

pta_NoNewAllChannels:       lea     $dff0a0,a5
                            lea     pta_chan1temp-pta_var(a2),a6
                            bsr.w   pta_CheckEfx
                            moveq   #0,d0
                            move.b  pta_chan1temp+n_realvolume-pta_var(a2),d0
                            move.w  d0,8(a5)
                            lea     $10(a5),a5
                            lea     pta_chan2temp-pta_var(a2),a6
                            bsr.w   pta_CheckEfx
                            moveq   #0,d0
                            move.b  pta_chan2temp+n_realvolume-pta_var(a2),d0
                            move.w  d0,8(a5)
                            lea     $10(a5),a5
                            lea     pta_chan3temp-pta_var(a2),a6
                            bsr.w   pta_CheckEfx
                            moveq   #0,d0
                            move.b  pta_chan3temp+n_realvolume-pta_var(a2),d0
                            move.w  d0,8(a5)
                            lea     $10(a5),a5
                            lea     pta_chan4temp-pta_var(a2),a6
                            bsr.w   pta_CheckEfx
                            moveq   #0,d0
                            move.b  pta_chan4temp+n_realvolume-pta_var(a2),d0
                            move.w  d0,8(a5)
                            rts

pta_GetNewNote:             move.l  pta_SongDataPtr-pta_var(a2),a0
                            lea     16(a0),a3                  ; samples infos
                            lea     (a0),a4                    ; song positions
                            add.l   (a0),a4
                            add.l   4(a0),a0                   ; patterns datas
                            moveq   #0,d0
                            moveq   #0,d1
                            move.b  pta_SongPos-pta_var(a2),d0
                            move.b  (a4,d0.w),d1
                            lsl.l   #6,d1
                            add.w   pta_PatternPos-pta_var(a2),d1
                            add.l   d1,a0
                            move.w  #$8000,pta_DMACONtemp-pta_var(a2)

                            lea     $dff0a0,a5
                            lea     pta_chan1temp-pta_var(a2),a6
                            bsr.b   pta_PlayVoice
                            lea     $10(a5),a5
                            lea     pta_chan2temp-pta_var(a2),a6
                            bsr.b   pta_PlayVoice
                            lea     $10(a5),a5
                            lea     pta_chan3temp-pta_var(a2),a6
                            bsr.b   pta_PlayVoice
                            lea     $10(a5),a5
                            lea     pta_chan4temp-pta_var(a2),a6
                            bsr.b   pta_PlayVoice
                            bra.w   pta_SetDMA

pta_PlayVoice:              tst.l   (a6)
                            bne.b   pta_plvskip
                            bsr.w   pta_PerNop
pta_plvskip:
                            moveq   #0,d3
                            move.l  pta_patternssize-pta_var(a2),d1
                            move.b  (a0),d3                    ; note
                            subq.w  #1,d3
                            add.w   d3,d3
                            move.w  d3,n_noteidx(a6)
                            move.w  pta_PeriodTable-pta_var(a2,d3.w),(a6)
                            move.l  d1,d2
                            move.b  (a0,d2.l),d3               ; instrument
                            move.b  d3,d0
                            and.b   #$f0,d3
                            or.b    d3,(a6)
                            and.b   #$f,d0
                            lsl.b   #4,d0
                            add.l   d1,d2
                            move.b  (a0,d2.l),d3               ; fx
                            or.b    d3,d0
                            move.b  d0,n_cmd(a6)               ; half instrument + fx
                            add.l   d1,d2
                            move.b  (a0,d2.l),n_cmdlo(a6)      ; fx datas
                            add.l   pta_chunksize-pta_var(a2),a0
    
                            moveq   #0,d2
                            move.b  n_cmd(a6),d2
                            and.b   #$f0,d2
                            lsr.b   #4,d2
                            move.b  (a6),d0                    ; note
                            and.b   #$f0,d0
                            or.b    d0,d2
                            beq.w   pta_SetRegs
                            subq.w  #1,d2
                            add.w   d2,d2
                            add.w   d2,d2
                            move.w  d2,d0
                            add.w   d0,d0
                            move.l  pta_SampleStarts-pta_var(a2,d2.w),n_start(a6)
                            move.w  (a3,d0.w),n_length(a6)
                            move.b  2(a3,d0.w),n_finetune(a6)
                            move.b  3(a3,d0.w),n_volume(a6)

                            move.l  n_start(a6),d2             ; get start
                            movem.w 4(a3,d0.w),d0/d1           ; get repeat
                            move.w  d1,n_replen(a6)            ; save replen
                            tst.w   d0
                            beq.b   pta_NoLoop
                            move.w  d0,d3
                            add.w   d3,d3
                            add.l   d3,d2                      ; add repeat
                            add.w   d1,d0                      ; add replen
                            move.w  d0,n_length(a6)

pta_NoLoop:                 move.l  d2,n_loopstart(a6)
                            move.l  d2,n_wavestart(a6)

pta_SetRegs:                move.w  (a6),d0
                            and.w   #$fff,d0
                            beq.w   pta_CheckMoreEfxVolume      ; if no note

    ifd PTA_EFX_SETFINETUNE
                            move.w  n_cmd(a6),d0
                            and.w   #$ff0,d0
                            cmp.w   #$e50,d0
                            beq.b   pta_DoSetFineTune
    endc
    
                            move.b  n_cmd(a6),d0
                            and.b   #$f,d0

    ifd PTA_TONEPORTAMENTO
                            cmp.b   #3,d0                      ; tone portamento
                            beq.b   pta_ChkTonePorta
    endc

    ifd PTA_TONEPLUSVOLSLIDE
                            cmp.b   #5,d0
                            beq.b   pta_ChkTonePorta
    endc

    ifd PTA_SAMPLEOFFSET
                            cmp.b   #9,d0                      ; sample offset
                            bne.b   pta_SetPeriod
                            bsr.w   pta_CheckMoreEfx
    endc
                            bra.b   pta_SetPeriod

    ifd PTA_EFX_SETFINETUNE
pta_DoSetFineTune:          bsr.w   pta_SetFineTune
                            bra.b   pta_UpdateChannelVolume
    endc

pta_ChkTonePorta:

    ifd PTA_TONEPORTAMENTO
                            bsr.w   pta_SetTonePorta
    endc

pta_CheckMoreEfxVolume:     bsr.w   pta_CheckMoreEfx
pta_UpdateChannelVolume:    moveq   #0,d0
                            move.b  n_volume(a6),d0
                            move.w  d0,8(a5)
                            move.b  d0,n_realvolume(a6)
                            rts

pta_SetPeriod:              moveq   #0,d1
                            move.b  n_finetune(a6),d1
                            add.w   d1,d1
                            move.w  pta_PeriodTablePtr-pta_var(a2,d1.w),d1
                            add.w   n_noteidx(a6),d1
                            move.w  pta_PeriodTable-pta_var(a2,d1.w),n_period(a6)

    ifd PTA_EFX_NOTEDELAY
                            move.w  n_cmd(a6),d0
                            and.w   #$ff0,d0
                            cmp.w   #$ed0,d0                  ; notedelay
                            beq.w   pta_CheckMoreEfx
    endc

                            move.w  n_dmabit(a6),$dff096

    ifd PTA_VIBRATO
                            btst    #2,n_wavecontrol(a6)
                            bne.b   pta_vibnoc
                            clr.b   n_vibratopos(a6)
pta_vibnoc:
    else
        ifd PTA_TREMOLO
                            btst    #2,n_wavecontrol(a6)
                            bne.b   pta_vibnoc
                            clr.b   n_vibratopos(a6)
pta_vibnoc:
        endc
    endc

    ifd PTA_TREMOLO
                            btst    #6,n_wavecontrol(a6)
                            bne.b   pta_trenoc
                            clr.b   n_tremolopos(a6)
pta_trenoc:
    endc
                            move.l  n_start(a6),(a5)           ; set start
                            move.w  n_length(a6),4(a5)         ; set length
                            move.w  n_period(a6),6(a5)         ; set period
                            move.w  n_dmabit(a6),d0
                            or.w    d0,pta_DMACONtemp-pta_var(a2)
                            bra.w   pta_CheckMoreEfxVolume
 
pta_SetDMA:                 lea     pta_dma_interrupt-pta_var(a2),a1
                            move.l  pta_vbr-pta_var(a2),a0
                            move.l  a1,(a0)
                            move.b  #$f0,$bfd600
                            move.b  #1,$bfd700
                            move.b  #$19,$bfdf00

pta_dskip:                  addq.w  #1,pta_PatternPos-pta_var(a2)
                            move.b  pta_PattDelTime-pta_var(a2),d0
                            beq.b   pta_dskc
                            move.b  d0,pta_PattDelTime2-pta_var(a2)
                            sf.b    pta_PattDelTime-pta_var(a2)
pta_dskc:                   tst.b   pta_PattDelTime2-pta_var(a2)
                            beq.b   pta_dska
                            subq.b  #1,pta_PattDelTime2-pta_var(a2)
                            beq.b   pta_dska
                            subq.w  #1,pta_PatternPos-pta_var(a2)
pta_dska:                   tst.b   pta_PBreakFlag-pta_var(a2)
                            beq.b   pta_nnpysk
                            sf.b    pta_PBreakFlag-pta_var(a2)
                            moveq   #0,d0
                            move.b  pta_PBreakPos-pta_var(a2),d0
                            sf.b    pta_PBreakPos-pta_var(a2)
                            move.w  d0,pta_PatternPos-pta_var(a2)
pta_nnpysk:                 cmp.w   #64,pta_PatternPos-pta_var(a2)
                            blo.b   pta_NoNewPosYet
pta_NextPosition:
                            moveq   #0,d0
                            move.b  pta_PBreakPos-pta_var(a2),d0
                            move.w  d0,pta_PatternPos-pta_var(a2)
                            sf.b    pta_PBreakPos-pta_var(a2)
                            sf.b    pta_PosJumpFlag-pta_var(a2)
                            addq.b  #1,pta_SongPos-pta_var(a2)
                            and.b   #$7f,pta_SongPos-pta_var(a2)
                            move.b  pta_SongPos-pta_var(a2),d1
                            move.l  pta_SongDataPtr-pta_var(a2),a0
                            cmp.b   13(a0),d1                  ; max number of positions
                            blo.b   pta_NoNewPosYet
                            sf.b    pta_SongPos-pta_var(a2)
pta_NoNewPosYet:
                            tst.b   pta_PosJumpFlag-pta_var(a2)
                            bne.b   pta_NextPosition
pta_exit:
                            movem.l (a7)+,d0-d3/a0-a6
                            rte

pta_Fx_Table:
    ifd PTA_ARPEGGIO
                            dc.w    pta_Arpeggio-pta_Fx_Table
    else
                            dc.w    pta_PerNop-pta_Fx_Table
    endc
    ifd PTA_PORTAMENTOUP
                            dc.w    pta_PortaUp-pta_Fx_Table
    else
                            dc.w    pta_PerNop-pta_Fx_Table
    endc
    ifd PTA_PORTAMENTODOWN
                            dc.w    pta_PortaDown-pta_Fx_Table
    else
                            dc.w    pta_PerNop-pta_Fx_Table
    endc
    ifd PTA_TONEPORTAMENTO
                            dc.w    pta_TonePortamento-pta_Fx_Table
    else
                            dc.w    pta_PerNop-pta_Fx_Table
    endc
    ifd PTA_VIBRATO
                            dc.w    pta_Vibrato-pta_Fx_Table
    else
                            dc.w    pta_PerNop-pta_Fx_Table
    endc
    ifd PTA_TONEPLUSVOLSLIDE
                            dc.w    pta_TonePlusVolSlide-pta_Fx_Table
    else
                            dc.w    pta_PerNop-pta_Fx_Table
    endc
    ifd PTA_VIBRATOPLUSVOLSLIDE
                            dc.w    pta_VibratoPlusVolSlide-pta_Fx_Table
    else
                            dc.w    pta_PerNop-pta_Fx_Table
    endc
    ifd PTA_TREMOLO
                            dc.w    pta_Tremolo-pta_Fx_Table
    else
                            dc.w    pta_PerNop-pta_Fx_Table
    endc
                            dc.w    pta_PerNop-pta_Fx_Table
                            dc.w    pta_PerNop-pta_Fx_Table
    ifd PTA_VOLUMESLIDE
                            dc.w    pta_VolumeSlidePer-pta_Fx_Table
    else
                            dc.w    pta_PerNop-pta_Fx_Table
    endc
                            dc.w    pta_PerNop-pta_Fx_Table
                            dc.w    pta_PerNop-pta_Fx_Table
                            dc.w    pta_PerNop-pta_Fx_Table
    ifd PTA_EXTEND
                            dc.w    pta_E_Commands-pta_Fx_Table
    else
                            dc.w    pta_PerNop-pta_Fx_Table
    endc
                            dc.w    pta_PerNop-pta_Fx_Table

pta_CheckEfx:

    ifd PTA_EFX_FUNKIT
                            bsr.w   pta_UpdateFunk
    endc

                            move.w  n_cmd(a6),d0
                            and.w   #$fff,d0
                            beq.b   pta_PerNop
                            lsr.w   #8,d0
                            add.w   d0,d0
                            move.w  pta_Fx_Table(pc,d0.w),d0
                            jmp     pta_Fx_Table(pc,d0.w)

pta_PerNop:                 move.w  n_period(a6),6(a5)
pta_Return:                 rts


    ifd PTA_ARPEGGIO
pta_arpeggio_table:         dc.b    0,1,2,0,1,2,0,1,2,0,1,2,0,1,2,0,1,2,0,1,2,0,1,2,0,1,2,0,1,2,0,1
pta_Arpeggio:               moveq   #0,d1
                            move.b  pta_counter-pta_var(a2),d1
                            move.b  pta_arpeggio_table(pc,d1.w),d1
                            beq.b   pta_Arpeggio2
                            subq.b  #2,d1
                            beq.b   pta_Arpeggio1
                            move.b  n_cmdlo(a6),d1
                            lsr.b   #4,d1
                            bra.b   pta_Arpeggio3
pta_Arpeggio2:              move.w  n_period(a6),6(a5)
                            rts
pta_Arpeggio1:              move.b  n_cmdlo(a6),d1
                            and.b   #$f,d1
pta_Arpeggio3:              add.w   d1,d1
                            move.w  n_period(a6),d2
                            moveq   #0,d0
                            move.b  n_finetune(a6),d0
                            add.w   d0,d0
                            move.w  pta_PeriodTablePtr-pta_var(a2,d0.w),d0
                            lea     pta_PeriodTable-pta_var(a2,d0.w),a1
                            moveq   #37-1,d3
                            moveq   #0,d0
pta_Arp_Loop:               cmp.w   (a1,d0.w),d2
                            bhs.b   pta_Found_Arp
                            addq.w  #2,d0
                            dbf     d3,pta_Arp_Loop
                            rts
pta_Found_Arp:              add.w   d0,d1
                            move.w  (a1,d1.w),6(a5)
                            rts
    endc

    ifd PTA_EFX_FINEPORTAUP
pta_FinePortaUp:            tst.b   pta_counter-pta_var(a2)
                            bne.w   pta_Return
                            move.b  #$f,pta_LowMask-pta_var(a2)
    endc

    ifd PTA_PORTAMENTOUP
pta_PortaUp:                moveq   #0,d0
                            move.b  n_cmdlo(a6),d0
                            and.b   pta_LowMask-pta_var(a2),d0
                            st.b    pta_LowMask-pta_var(a2)
                            sub.w   d0,n_period(a6)
                            move.w  n_period(a6),d0
                            and.w   #$fff,d0
                            cmp.w   #113,d0
                            bpl.b   pta_PortaUskip
                            and.w   #$f000,n_period(a6)
                            or.w    #113,n_period(a6)
pta_PortaUskip:             move.w  n_period(a6),d0
                            and.w   #$fff,d0
                            move.w  d0,6(a5)
                            rts
    endc

    ifd PTA_EFX_FINEPORTADOWN
pta_FinePortaDown:          tst.b   pta_counter-pta_var(a2)
                            bne.w   pta_Return
                            move.b  #$f,pta_LowMask-pta_var(a2)
    endc

    ifd PTA_PORTAMENTODOWN
pta_PortaDown:              moveq   #0,d0
                            move.b  n_cmdlo(a6),d0
                            and.b   pta_LowMask-pta_var(a2),d0
                            st.b    pta_LowMask-pta_var(a2)
                            add.w   d0,n_period(a6)
                            move.w  n_period(a6),d0
                            and.w   #$fff,d0
                            cmp.w   #856,d0
                            bmi.b   pta_PortaDskip
                            and.w   #$f000,n_period(a6)
                            or.w    #856,n_period(a6)
pta_PortaDskip:             move.w  n_period(a6),d0
                            and.w   #$fff,d0
                            move.w  d0,6(a5)
                            rts
    endc

    ifd PTA_TONEPORTAMENTO
pta_SetTonePorta:           move.w  (a6),d2
                            and.w   #$fff,d2
 
                            moveq   #0,d0
                            move.b  n_finetune(a6),d0
                            add.w   d0,d0
                            move.w  pta_PeriodTablePtr-pta_var(a2,d0.w),d0
                            lea     pta_PeriodTable-pta_var(a2,d0.w),a1
                            moveq   #37-1,d3
                            moveq   #0,d0
pta_Stp_Loop:               cmp.w   (a1,d0.w),d2
                            bhs.b   pta_Stp_Found
                            addq.w  #2,d0
                            dbf     d3,pta_Stp_Loop
                            moveq   #35*2,d0
pta_Stp_Found:              move.b  n_finetune(a6),d2
                            and.b   #8,d2
                            beq.b   pta_StpGoss
                            tst.w   d0
                            beq.b   pta_StpGoss
                            subq.w  #2,d0
pta_StpGoss:                move.w  (a1,d0.w),d2
                            move.w  d2,n_wantedperiod(a6)
                            move.w  n_period(a6),d0
                            clr.b   n_toneportdirec(a6)
                            cmp.w   d0,d2
                            beq.b   pta_ClearTonePorta
                            bge.w   pta_Return
                            move.b  #1,n_toneportdirec(a6)
                            rts

pta_ClearTonePorta:         clr.w   n_wantedperiod(a6)
                            rts
    endc

    ifd PTA_TONEPORTAMENTO
pta_TonePortamento:         move.b  n_cmdlo(a6),d0
                            beq.b   pta_TonePortNoChange
                            move.b  d0,n_toneportspeed(a6)
                            clr.b   n_cmdlo(a6)
pta_TonePortNoChange:
                            tst.w   n_wantedperiod(a6)
                            beq.w   pta_Return
                            moveq   #0,d0
                            move.b  n_toneportspeed(a6),d0
                            tst.b   n_toneportdirec(a6)
                            bne.b   pta_TonePortaUp
pta_TonePortaDown:
                            add.w   d0,n_period(a6)
                            move.w  n_wantedperiod(a6),d0
                            cmp.w   n_period(a6),d0
                            bgt.b   pta_TonePortaSetPer
                            move.w  n_wantedperiod(a6),n_period(a6)
                            clr.w   n_wantedperiod(a6)
                            bra.b   pta_TonePortaSetPer

pta_TonePortaUp:            sub.w   d0,n_period(a6)
                            move.w  n_wantedperiod(a6),d0
                            cmp.w   n_period(a6),d0
                            blt.b   pta_TonePortaSetPer
                            move.w  n_wantedperiod(a6),n_period(a6)
                            clr.w   n_wantedperiod(a6)

pta_TonePortaSetPer:        move.w  n_period(a6),d2
                            move.b  n_glissfunk(a6),d0
                            and.b   #$f,d0
                            beq.b   pta_GlissSkip
                            moveq   #0,d0
                            move.b  n_finetune(a6),d0
                            add.w   d0,d0
                            move.w  pta_PeriodTablePtr-pta_var(a2,d0.w),d0
                            lea     pta_PeriodTable-pta_var(a2,d0.w),a1
                            moveq   #37-1,d3
                            moveq   #0,d0
pta_Gliss_Loop:             cmp.w   (a1,d0.w),d2
                            bhs.b   pta_Gliss_Found
                            addq.w  #2,d0
                            dbf     d3,pta_Gliss_Loop
                            moveq   #35*2,d0
pta_Gliss_Found:            move.w  (a1,d0.w),d2
pta_GlissSkip:              move.w  d2,6(a5)                       ; Set period
                            rts
    endc

    ifd PTA_VIBRATO
pta_Vibrato:                move.b  n_cmdlo(a6),d0
                            beq.b   pta_Vibrato2
                            move.b  n_vibratocmd(a6),d2
                            and.b   #$f,d0
                            beq.b   pta_vibskip
                            and.b   #$f0,d2
                            or.b    d0,d2
pta_vibskip:                move.b  n_cmdlo(a6),d0
                            and.b   #$f0,d0
                            beq.b   pta_vibskip2
                            and.b   #$f,d2
                            or.b    d0,d2
pta_vibskip2:               move.b  d2,n_vibratocmd(a6)
pta_Vibrato2:               move.b  n_vibratopos(a6),d0
                            lsr.w   #2,d0
                            and.w   #$1f,d0
                            moveq   #0,d2
                            move.b  n_wavecontrol(a6),d2
                            and.b   #3,d2
                            beq.b   pta_vib_sine
                            lsl.b   #3,d0
                            cmp.b   #1,d2
                            beq.b   pta_vib_rampdown
                            st.b    d2
                            bra.b   pta_vib_set

pta_vib_rampdown:           tst.b   n_vibratopos(a6)
                            bpl.b   pta_vib_rampdown2
                            st.b    d2
                            sub.b   d0,d2
                            bra.b   pta_vib_set

pta_vib_rampdown2:          move.b  d0,d2
                            bra.b   pta_vib_set

pta_vib_sine:               move.b  pta_VibratoTable-pta_var(a2,d0.w),d2

pta_vib_set:                move.b  n_vibratocmd(a6),d0
                            and.w   #$f,d0
                            mulu    d0,d2
                            lsr.w   #7,d2
                            move.w  n_period(a6),d0
                            tst.b   n_vibratopos(a6)
                            bmi.b   pta_VibratoNeg
                            add.w   d2,d0
                            bra.b   pta_Vibrato3
pta_VibratoNeg:             sub.w   d2,d0
pta_Vibrato3:               move.w  d0,6(a5)
                            move.b  n_vibratocmd(a6),d0
                            lsr.w   #2,d0
                            and.w   #$3c,d0
                            add.b   d0,n_vibratopos(a6)
                            rts
    endc

    ifd PTA_TONEPLUSVOLSLIDE
pta_TonePlusVolSlide:       bsr.w   pta_TonePortNoChange
                            bra.w   pta_VolumeSlide
    endc

    ifd PTA_VIBRATOPLUSVOLSLIDE
pta_VibratoPlusVolSlide:    bsr.b   pta_Vibrato2
                            bra.w   pta_VolumeSlide
    endc

    ifd PTA_TREMOLO
pta_Tremolo:                move.w  n_period(a6),6(a5)
                            move.b  n_cmdlo(a6),d0
                            beq.b   pta_Tremolo2
                            move.b  n_tremolocmd(a6),d2
                            and.b   #$f,d0
                            beq.b   pta_treskip
                            and.b   #$f0,d2
                            or.b    d0,d2
pta_treskip:                move.b  n_cmdlo(a6),d0
                            and.b   #$f0,d0
                            beq.b   pta_treskip2
                            and.b   #$f,d2
                            or.b    d0,d2
pta_treskip2:               move.b  d2,n_tremolocmd(a6)

pta_Tremolo2:               move.b  n_tremolopos(a6),d0
                            lsr.w   #2,d0
                            and.w   #$1f,d0
                            moveq   #0,d2
                            move.b  n_wavecontrol(a6),d2
                            lsr.b   #4,d2
                            and.b   #3,d2
                            beq.b   pta_tre_sine
                            lsl.b   #3,d0
                            cmp.b   #1,d2
                            beq.b   pta_tre_rampdown
                            st.b    d2
                            bra.b   pta_tre_set

pta_tre_rampdown:           tst.b   n_vibratopos(a6)
                            bpl.b   pta_tre_rampdown2
                            st.b    d2
                            sub.b   d0,d2
                            bra.b   pta_tre_set

pta_tre_rampdown2:          move.b  d0,d2
                            bra.b   pta_tre_set

pta_tre_sine:               move.b  pta_VibratoTable-pta_var(a2,d0.w),d2

pta_tre_set:                move.b  n_tremolocmd(a6),d0
                            and.w   #$f,d0
                            mulu    d0,d2
                            lsr.w   #6,d2
                            moveq   #0,d0
                            move.b  n_volume(a6),d0
                            tst.b   n_tremolopos(a6)
                            bmi.b   pta_TremoloNeg
                            add.w   d2,d0
                            bra.b   pta_Tremolo3
pta_TremoloNeg:             sub.w   d2,d0
pta_Tremolo3:               bpl.b   pta_TremoloSkip
                            clr.w   d0
pta_TremoloSkip:            cmp.w   #64,d0
                            bls.b   pta_TremoloOk
                            move.w  #64,d0

pta_TremoloOk:              move.b  d0,n_realvolume(a6)
                            move.b  n_tremolocmd(a6),d0
                            lsr.w   #2,d0
                            and.w   #$3c,d0
                            add.b   d0,n_tremolopos(a6)
                            rts
    endc

    ifd PTA_SAMPLEOFFSET
pta_SampleOffset:           moveq   #0,d0
                            move.b  n_cmdlo(a6),d0
                            beq.b   pta_sononew
                            move.b  d0,n_sampleoffset(a6)
pta_sononew:                move.b  n_sampleoffset(a6),d0
                            lsl.w   #7,d0
                            cmp.w   n_length(a6),d0
                            bge.b   pta_sofskip
                            sub.w   d0,n_length(a6)
                            add.w   d0,d0
                            add.l   d0,n_start(a6)
                            rts
pta_sofskip:                move.w  #1,n_length(a6)
                            rts
    endc

    ifd PTA_VOLUMESLIDE
pta_VolumeSlidePer:         move.w  n_period(a6),6(a5)
pta_VolumeSlide:            move.b  n_cmdlo(a6),d0
                            lsr.b   #4,d0
                            beq.b   pta_VolSlideDown
pta_VolSlideUp:             add.b   d0,n_volume(a6)
                            cmp.b   #64,n_volume(a6)
                            bmi.b   pta_vsuskip
                            move.b  #64,n_volume(a6)
pta_vsuskip:                move.b  n_volume(a6),n_realvolume(a6)
                            rts

pta_VolSlideDown:           move.b  n_cmdlo(a6),d0
                            and.b   #$f,d0
pta_VolSlideDown2:          sub.b   d0,n_volume(a6)
                            bpl.b   pta_vsdskip
                            clr.b   n_volume(a6)
pta_vsdskip:                move.b  n_volume(a6),n_realvolume(a6)
                            rts
    endc

    ifd PTA_POSITIONJUMP
pta_PositionJump:           move.b  n_cmdlo(a6),pta_SongPos-pta_var(a2)
pta_pj2:                    sf.b    pta_PBreakPos-pta_var(a2)
                            st.b    pta_PosJumpFlag-pta_var(a2)
                            rts
    endc

    ifd PTA_VOLUMECHANGE
pta_VolumeChange:           move.b  n_cmdlo(a6),d0
                            cmp.b   #64,d0
                            bls.b   pta_VolumeOk
                            moveq   #64,d0
pta_VolumeOk:               move.b  d0,n_volume(a6)
                            rts
    endc

    ifd PTA_PATTERNBREAK
pta_PatternBreak:           move.b  n_cmdlo(a6),pta_PBreakPos-pta_var(a2)
                            st.b    pta_PosJumpFlag-pta_var(a2)
                            rts
    endc

    ifd PTA_SETSPEED
pta_SetSpeed:               moveq   #0,d0
                            move.b  n_cmdlo(a6),d0
                            beq.w   pta_end
                            cmp.b   #32,d0
                            bhs.w   pta_set_tempo
                            sf.b    pta_counter-pta_var(a2)
                            move.b  d0,pta_speed-pta_var(a2)
                            rts
    endc

    ifd PTA_SETSYNCHRO
pta_SetSynchro:             move.b  n_cmdlo(a6),d0
                            addq.b  #1,d0
                            move.b  d0,pta_synchro-pta_var(a2)
                            rts
    endc

pta_Tick0_Fx_Table:         dc.w    pta_PerNop-pta_Tick0_Fx_Table
                            dc.w    pta_PerNop-pta_Tick0_Fx_Table
                            dc.w    pta_PerNop-pta_Tick0_Fx_Table
                            dc.w    pta_PerNop-pta_Tick0_Fx_Table
                            dc.w    pta_PerNop-pta_Tick0_Fx_Table
                            dc.w    pta_PerNop-pta_Tick0_Fx_Table
                            dc.w    pta_PerNop-pta_Tick0_Fx_Table
                            dc.w    pta_PerNop-pta_Tick0_Fx_Table
    ifd PTA_SETSYNCHRO
                            dc.w    pta_SetSynchro-pta_Tick0_Fx_Table
    else
                            dc.w    pta_PerNop-pta_Tick0_Fx_Table
    endc
    ifd PTA_SAMPLEOFFSET
                            dc.w    pta_SampleOffset-pta_Tick0_Fx_Table
    else
                            dc.w    pta_PerNop-pta_Tick0_Fx_Table
    endc
                            dc.w    pta_PerNop-pta_Tick0_Fx_Table
    ifd PTA_POSITIONJUMP
                            dc.w    pta_PositionJump-pta_Tick0_Fx_Table
    else
                            dc.w    pta_PerNop-pta_Tick0_Fx_Table
    endc        
    ifd PTA_VOLUMECHANGE
                            dc.w    pta_VolumeChange-pta_Tick0_Fx_Table
    else
                            dc.w    pta_PerNop-pta_Tick0_Fx_Table
    endc        
    ifd PTA_PATTERNBREAK
                            dc.w    pta_PatternBreak-pta_Tick0_Fx_Table
    else
                            dc.w    pta_PerNop-pta_Tick0_Fx_Table
    endc
    ifd PTA_EXTEND
                            dc.w    pta_E_Commands-pta_Tick0_Fx_Table
    else
                            dc.w    pta_PerNop-pta_Tick0_Fx_Table
    endc
    ifd PTA_SETSPEED
                            dc.w    pta_SetSpeed-pta_Tick0_Fx_Table
    else
                            dc.w    pta_PerNop-pta_Tick0_Fx_Table
    endc

pta_CheckMoreEfx:

    ifd PTA_EFX_FUNKIT
                            bsr.w   pta_UpdateFunk
    endc
                            move.b  n_cmd(a6),d0
                            and.w   #$f,d0
                            add.w   d0,d0
                            move.w  pta_Tick0_Fx_Table(pc,d0.w),d0
                            jmp     pta_Tick0_Fx_Table(pc,d0.w)

    ifd PTA_EXTEND

pta_E_Table:
    ifd PTA_EFX_FILTERONOFF
                            dc.w    pta_FilterOnOff-pta_E_Table
    else
                            dc.w    pta_Return-pta_E_Table
    endc
    ifd PTA_EFX_FINEPORTAUP
                            dc.w    pta_FinePortaUp-pta_E_Table
    else
                            dc.w    pta_Return-pta_E_Table
    endc
    ifd PTA_EFX_FINEPORTADOWN
                            dc.w    pta_FinePortaDown-pta_E_Table
    else
                            dc.w    pta_Return-pta_E_Table
    endc
    ifd PTA_EFX_SETGLISSCONTROL
                            dc.w    pta_SetGlissControl-pta_E_Table
    else
                            dc.w    pta_Return-pta_E_Table
    endc
    ifd PTA_EFX_SETVIBRATOCONTROL
                            dc.w    pta_SetVibratoControl-pta_E_Table
    else
                            dc.w    pta_Return-pta_E_Table
    endc
    ifd PTA_EFX_SETFINETUNE
                            dc.w    pta_SetFineTune-pta_E_Table
    else
                            dc.w    pta_Return-pta_E_Table
    endc
    ifd PTA_EFX_JUMPLOOP
                            dc.w    pta_JumpLoop-pta_E_Table
    else
                            dc.w    pta_Return-pta_E_Table
    endc
    ifd PTA_EFX_SETTREMOLOCONTROL
                            dc.w    pta_SetTremoloControl-pta_E_Table
    else
                            dc.w    pta_Return-pta_E_Table
    endc
    ifd PTA_EFX_KARPLUSTRONG
                            dc.w    pta_KarplusStrong-pta_E_Table
    else
                            dc.w    pta_Return-pta_E_Table
    endc
    ifd PTA_EFX_RETRIGNOTE
                            dc.w    pta_RetrigNote-pta_E_Table
    else
                            dc.w    pta_Return-pta_E_Table
    endc
    ifd PTA_EFX_VOLUMEFINEUP
                            dc.w    pta_VolumeFineUp-pta_E_Table
    else
                            dc.w    pta_Return-pta_E_Table
    endc
    ifd PTA_EFX_VOLUMEFINEDOWN
                            dc.w    pta_VolumeFineDown-pta_E_Table
    else
                            dc.w    pta_Return-pta_E_Table
    endc
    ifd PTA_EFX_NOTECUT
                            dc.w    pta_NoteCut-pta_E_Table
    else
                            dc.w    pta_Return-pta_E_Table
    endc
    ifd PTA_EFX_NOTEDELAY
                            dc.w    pta_NoteDelay-pta_E_Table
    else
                            dc.w    pta_Return-pta_E_Table
    endc
    ifd PTA_EFX_PATTERNDELAY
                            dc.w    pta_PatternDelay-pta_E_Table
    else
                            dc.w    pta_Return-pta_E_Table
    endc
    ifd PTA_EFX_FUNKIT
                            dc.w    pta_FunkIt-pta_E_Table
    else
                            dc.w    pta_Return-pta_E_Table
    endc

pta_E_Commands:             move.b  n_cmdlo(a6),d0
                            and.w   #$f0,d0
                            lsr.b   #4,d0
                            add.w   d0,d0
                            move.w  pta_E_Table(pc,d0.w),d0
                            jsr     pta_E_Table(pc,d0.w)
                            move.b  n_volume(a6),n_realvolume(a6)
                            rts

    ifd PTA_EFX_FILTERONOFF
pta_FilterOnOff:            move.b  n_cmdlo(a6),d0
                            and.b   #1,d0
                            add.b   d0,d0
                            and.b   #$fd,$bfe001
                            or.b    d0,$bfe001
                            rts 
    endc

    ifd PTA_EFX_SETGLISSCONTROL
pta_SetGlissControl:        move.b  n_cmdlo(a6),d0
                            and.b   #$f,d0
                            and.b   #$f0,n_glissfunk(a6)
                            or.b    d0,n_glissfunk(a6)
                            rts
    endc

    ifd PTA_EFX_SETVIBRATOCONTROL
pta_SetVibratoControl:      move.b  n_cmdlo(a6),d0
                            and.b   #$f,d0
                            and.b   #$f0,n_wavecontrol(a6)
                            or.b    d0,n_wavecontrol(a6)
                            rts
    endc

    ifd PTA_EFX_SETFINETUNE
pta_SetFineTune:            move.b  n_cmdlo(a6),d0
                            and.b   #$f,d0
                            move.b  d0,n_finetune(a6)
                            rts
    endc

    ifd PTA_EFX_JUMPLOOP
pta_JumpLoop:               tst.b   pta_counter-pta_var(a2)
                            bne.w   pta_Return
                            move.b  n_cmdlo(a6),d0
                            and.b   #$f,d0
                            beq.b   pta_SetLoop
                            tst.b   n_loopcount(a6)
                            beq.b   pta_jumpcnt
                            subq.b  #1,n_loopcount(a6)
                            beq.w   pta_Return
pta_jmploop:                move.b  n_pattpos(a6),pta_PBreakPos-pta_var(a2)
                            st.b    pta_PBreakFlag-pta_var(a2)
                            rts
pta_jumpcnt:                move.b  d0,n_loopcount(a6)
                            bra.b   pta_jmploop
pta_SetLoop:                move.w  pta_PatternPos-pta_var(a2),d0
                            move.b  d0,n_pattpos(a6)
                            rts
    endc

    ifd PTA_EFX_SETTREMOLOCONTROL
pta_SetTremoloControl:      move.b  n_cmdlo(a6),d0
                            and.b   #$f,d0
                            lsl.b   #4,d0
                            and.b   #$f,n_wavecontrol(a6)
                            or.b    d0,n_wavecontrol(a6)
                            rts
    endc

    ifd PTA_EFX_KARPLUSTRONG
pta_KarplusStrong:          movem.l	d1-d2/a0-a1,-(sp)
                            move.l	n_loopstart(a6),a0
                            move.l	a0,a1
                            move.w	n_replen(a6),d0
                            add.w	d0,d0
                            subq.w	#2,d0
pta_KarPLop:                move.b	(a0),d1
                            ext.w	d1
                            move.b	1(a0),d2
                            ext.w	d2
                            add.w	d1,d2
                            asr.w	#1,d2
                            move.b	d2,(a0)+
                            dbra	d0,pta_KarPLop
                            move.b	(a0),d1
                            ext.w	d1
                            move.b	(a1),d2
                            ext.w	d2
                            add.w	d1,d2
                            asr.w	#1,d2
                            move.b	d2,(a0)
                            movem.l	(sp)+,d1-d2/a0-a1
                            rts
    endc

    ifd PTA_EFX_RETRIGNOTE
pta_RetrigNote:             moveq   #0,d0
                            move.b  n_cmdlo(a6),d0
                            and.b   #$f,d0
                            beq.b   pta_rtnend
                            moveq   #0,d1
                            move.b  pta_counter-pta_var(a2),d1
                            bne.b   pta_rtnskp
                            move.w  (a6),d1
                            and.w   #$fff,d1
                            bne.b   pta_rtnend
                            moveq   #0,d1
                            move.b  pta_counter-pta_var(a2),d1
pta_rtnskp:                 divu    d0,d1
                            swap    d1
                            tst.w   d1
                            bne.b   pta_rtnend

pta_DoRetrig:               move.w  n_dmabit(a6),$dff096           ; channel dma off
                            move.l  n_start(a6),(a5)               ; set sampledata pointer
                            move.w  n_length(a6),4(a5)             ; set length
                            move.w  n_dmabit(a6),d0
                            or.w    d0,pta_DMACONtemp-pta_var(a2)
                            
                            lea     pta_dma_interrupt-pta_var(a2),a1
                            move.l  pta_vbr-pta_var(a2),a4
                            move.l  a1,(a4)
                            move.b  #$f0,$bfd600
                            move.b  #1,$bfd700
                            move.b  #$19,$bfdf00
pta_rtnend:                 rts
    endc

    ifd PTA_EFX_VOLUMEFINEUP
pta_VolumeFineUp:           tst.b   pta_counter-pta_var(a2)
                            bne.w   pta_Return
                            move.b  n_cmdlo(a6),d0
                            and.b   #$f,d0
                            bra.w   pta_VolSlideUp
    endc

    ifd PTA_EFX_VOLUMEFINEDOWN
pta_VolumeFineDown:         tst.b   pta_counter-pta_var(a2)
                            bne.w   pta_Return
                            move.b  n_cmdlo(a6),d0
                            and.b   #$f,d0
                            bra.w   pta_VolSlideDown2
    endc

    ifd PTA_EFX_NOTECUT
pta_NoteCut:                move.b  n_cmdlo(a6),d0
                            and.b   #$f,d0
                            cmp.b   pta_counter-pta_var(a2),d0
                            bne.w   pta_Return
                            sf.b    n_volume(a6)
                            rts
    endc

    ifd PTA_EFX_NOTEDELAY
pta_NoteDelay:              move.b  n_cmdlo(a6),d0
                            and.b   #$f,d0
                            cmp.b   pta_counter-pta_var(a2),d0
                            bne.w   pta_Return
                            move.w  (a6),d0
                            and.w   #$fff,d0
                            beq.w   pta_Return
                            bra.w   pta_DoRetrig
    endc

    ifd PTA_EFX_PATTERNDELAY
pta_PatternDelay:           tst.b   pta_counter-pta_var(a2)
                            bne.w   pta_Return
                            move.b  n_cmdlo(a6),d0
                            and.b   #$f,d0
                            tst.b   pta_PattDelTime2-pta_var(a2)
                            bne.w   pta_Return
                            addq.b  #1,d0
                            move.b  d0,pta_PattDelTime-pta_var(a2)
                            rts
    endc

    ifd PTA_EFX_FUNKIT
pta_FunkIt:                 tst.b   pta_counter-pta_var(a2)
                            bne.w   pta_Return
                            move.b  n_cmdlo(a6),d0
                            and.b   #$f,d0
                            lsl.b   #4,d0
                            and.b   #$f,n_glissfunk(a6)
                            or.b    d0,n_glissfunk(a6)
                            beq.w   pta_Return
pta_UpdateFunk:             moveq   #0,d0
                            move.b  n_glissfunk(a6),d0
                            lsr.b   #4,d0
                            beq.b   pta_funkend
                            move.b  pta_FunkTable(pc,d0.w),d0
                            add.b   d0,n_funkoffset(a6)
                            btst    #7,n_funkoffset(a6)
                            beq.b   pta_funkend
                            sf.b    n_funkoffset(a6)

                            move.l  n_loopstart(a6),d0
                            moveq   #0,d1
                            move.w  n_replen(a6),d1
                            add.l   d1,d0
                            add.l   d1,d0
                            move.l  n_wavestart(a6),a1
                            addq.l  #1,a1
                            cmp.l   d0,a1
                            blo.b   pta_funkok
                            move.l  n_loopstart(a6),a1
pta_funkok:                 move.l  a1,n_wavestart(a6)
                            moveq   #-1,d0
                            sub.b   (a1),d0
                            move.b  d0,(a1)
pta_funkend:                rts

pta_FunkTable:              dc.b    0,5,6,7,8,10,11,13,16,19,22,26,32,43,64,128
    endc

    endc                    ; PTA_EXTEND

pta_SampleStarts:           dcb.l   31,0

pta_var:

    ifd PTA_VIBRATO
pta_VibratoTable:           dc.b    0,24,49,74,97,120,141,161
                            dc.b    180,197,212,224,235,244,250,253
                            dc.b    255,253,250,244,235,224,212,197
                            dc.b    180,161,141,120,97,74,49,24
    endc

pta_PeriodTablePtr:         dc.w    pta_PeriodTable-pta_PeriodTable
    ifd PTA_FINETUNE_1
                            dc.w    pta_PeriodTable_1-pta_PeriodTable
    else
                            dc.w    pta_PeriodTable-pta_PeriodTable
    endc
    ifd PTA_FINETUNE_2
                            dc.w    pta_PeriodTable_2-pta_PeriodTable
    else
                            dc.w    pta_PeriodTable-pta_PeriodTable
    endc
    ifd PTA_FINETUNE_3
                            dc.w    pta_PeriodTable_3-pta_PeriodTable
    else
                            dc.w    pta_PeriodTable-pta_PeriodTable
    endc
    ifd PTA_FINETUNE_4
                            dc.w    pta_PeriodTable_4-pta_PeriodTable
    else
                            dc.w    pta_PeriodTable-pta_PeriodTable
    endc
    ifd PTA_FINETUNE_5
                            dc.w    pta_PeriodTable_5-pta_PeriodTable
    else
                            dc.w    pta_PeriodTable-pta_PeriodTable
    endc
    ifd PTA_FINETUNE_6
                            dc.w    pta_PeriodTable_6-pta_PeriodTable
    else
                            dc.w    pta_PeriodTable-pta_PeriodTable
    endc
    ifd PTA_FINETUNE_7
                            dc.w    pta_PeriodTable_7-pta_PeriodTable
    else
                            dc.w    pta_PeriodTable-pta_PeriodTable
    endc
    ifd PTA_FINETUNE_M8
                            dc.w    pta_PeriodTable_m8-pta_PeriodTable
    else
                            dc.w    pta_PeriodTable-pta_PeriodTable
    endc
    ifd PTA_FINETUNE_M7
                            dc.w    pta_PeriodTable_m7-pta_PeriodTable
    else
                            dc.w    pta_PeriodTable-pta_PeriodTable
    endc
    ifd PTA_FINETUNE_M6
                            dc.w    pta_PeriodTable_m6-pta_PeriodTable
    else
                            dc.w    pta_PeriodTable-pta_PeriodTable
    endc
    ifd PTA_FINETUNE_M5
                            dc.w    pta_PeriodTable_m5-pta_PeriodTable
    else
                            dc.w    pta_PeriodTable-pta_PeriodTable
    endc
    ifd PTA_FINETUNE_M4
                            dc.w    pta_PeriodTable_m4-pta_PeriodTable
    else
                            dc.w    pta_PeriodTable-pta_PeriodTable
    endc
    ifd PTA_FINETUNE_M3
                            dc.w    pta_PeriodTable_m3-pta_PeriodTable
    else
                            dc.w    pta_PeriodTable-pta_PeriodTable
    endc
    ifd PTA_FINETUNE_M2
                            dc.w    pta_PeriodTable_m2-pta_PeriodTable
    else
                            dc.w    pta_PeriodTable-pta_PeriodTable
    endc
    ifd PTA_FINETUNE_M1
                            dc.w    pta_PeriodTable_m1-pta_PeriodTable
    else
                            dc.w    pta_PeriodTable-pta_PeriodTable
    endc

                            dc.w    0

pta_PeriodTable:            ; Tuning 0,Normal
                            dc.w    856,808,762,720,678,640,604,570,538,508,480,453
                            dc.w    428,404,381,360,339,320,302,285,269,254,240,226
                            dc.w    214,202,190,180,170,160,151,143,135,127,120,113
    ifd PTA_FINETUNE_1
pta_PeriodTable_1:
                            ; Tuning 1
                            dc.w    850,802,757,715,674,637,601,567,535,505,477,450
                            dc.w    425,401,379,357,337,318,300,284,268,253,239,225
                            dc.w    213,201,189,179,169,159,150,142,134,126,119,113
    endc
    ifd PTA_FINETUNE_2
pta_PeriodTable_2:
                            ; Tuning 2
                            dc.w    844,796,752,709,670,632,597,563,532,502,474,447
                            dc.w    422,398,376,355,335,316,298,282,266,251,237,224
                            dc.w    211,199,188,177,167,158,149,141,133,125,118,112
    endc
    ifd PTA_FINETUNE_3
pta_PeriodTable_3:
                            ; Tuning 3
                            dc.w    838,791,746,704,665,628,592,559,528,498,470,444
                            dc.w    419,395,373,352,332,314,296,280,264,249,235,222
                            dc.w    209,198,187,176,166,157,148,140,132,125,118,111
    endc
    ifd PTA_FINETUNE_4
pta_PeriodTable_4:
                            ; Tuning 4
                            dc.w    832,785,741,699,660,623,588,555,524,495,467,441
                            dc.w    416,392,370,350,330,312,294,278,262,247,233,220
                            dc.w    208,196,185,175,165,156,147,139,131,124,117,110
    endc
    ifd PTA_FINETUNE_5
pta_PeriodTable_5:
                            ; Tuning 5
                            dc.w    826,779,736,694,655,619,584,551,520,491,463,437
                            dc.w    413,390,368,347,328,309,292,276,260,245,232,219
                            dc.w    206,195,184,174,164,155,146,138,130,123,116,109
    endc
    ifd PTA_FINETUNE_6
pta_PeriodTable_6:
                            ; Tuning 6
                            dc.w    820,774,730,689,651,614,580,547,516,487,460,434
                            dc.w    410,387,365,345,325,307,290,274,258,244,230,217
                            dc.w    205,193,183,172,163,154,145,137,129,122,115,109
    endc
    ifd PTA_FINETUNE_7
pta_PeriodTable_7:
                            ; Tuning 7
                            dc.w    814,768,725,684,646,610,575,543,513,484,457,431
                            dc.w    407,384,363,342,323,305,288,272,256,242,228,216
                            dc.w    204,192,181,171,161,152,144,136,128,121,114,108
    endc
    ifd PTA_FINETUNE_M8
pta_PeriodTable_m8:
                            ; Tuning -8
                            dc.w    907,856,808,762,720,678,640,604,570,538,508,480
                            dc.w    453,428,404,381,360,339,320,302,285,269,254,240
                            dc.w    226,214,202,190,180,170,160,151,143,135,127,120
    endc
    ifd PTA_FINETUNE_M7
pta_PeriodTable_m7:
                            ; Tuning -7
                            dc.w    900,850,802,757,715,675,636,601,567,535,505,477
                            dc.w    450,425,401,379,357,337,318,300,284,268,253,238
                            dc.w    225,212,200,189,179,169,159,150,142,134,126,119
    endc
    ifd PTA_FINETUNE_M6
pta_PeriodTable_m6:
                            ; Tuning -6
                            dc.w    894,844,796,752,709,670,632,597,563,532,502,474
                            dc.w    447,422,398,376,355,335,316,298,282,266,251,237
                            dc.w    223,211,199,188,177,167,158,149,141,133,125,118
    endc
    ifd PTA_FINETUNE_M5
pta_PeriodTable_m5:
                            ; Tuning -5
                            dc.w    887,838,791,746,704,665,628,592,559,528,498,470
                            dc.w    444,419,395,373,352,332,314,296,280,264,249,235
                            dc.w    222,209,198,187,176,166,157,148,140,132,125,118
    endc
    ifd PTA_FINETUNE_M4
pta_PeriodTable_m4:
                            ; Tuning -4
                            dc.w    881,832,785,741,699,660,623,588,555,524,494,467
                            dc.w    441,416,392,370,350,330,312,294,278,262,247,233
                            dc.w    220,208,196,185,175,165,156,147,139,131,123,117
    endc
    ifd PTA_FINETUNE_M3
pta_PeriodTable_m3:
                            ; Tuning -3
                            dc.w    875,826,779,736,694,655,619,584,551,520,491,463
                            dc.w    437,413,390,368,347,328,309,292,276,260,245,232
                            dc.w    219,206,195,184,174,164,155,146,138,130,123,116
    endc
    ifd PTA_FINETUNE_M2
pta_PeriodTable_m2:
                            ; Tuning -2
                            dc.w    868,820,774,730,689,651,614,580,547,516,487,460
                            dc.w    434,410,387,365,345,325,307,290,274,258,244,230
                            dc.w    217,205,193,183,172,163,154,145,137,129,122,115
    endc
    ifd PTA_FINETUNE_M1
pta_PeriodTable_m1:
                            ; Tuning -1
                            dc.w    862,814,768,725,684,646,610,575,543,513,484,457
                            dc.w    431,407,384,363,342,323,305,288,272,256,242,228
                            dc.w    216,203,192,181,171,161,152,144,136,128,121,114
    endc

    ifd PTA_PACKED_SMP
pta_stepsizeTable:          dc.w    7,8,9,10,11,12,13,14,16,17
                            dc.w    19,21,23,25,28,31,34,37,41,45
                            dc.w    50,55,60,66,73,80,88,97,107,118
                            dc.w    130,143,157,173,190,209,230,253,279,307
                            dc.w    337,371,408,449,494,544,598,658,724,796
                            dc.w    876,963,1060,1166,1282,1411,1552,1707,1878,2066
                            dc.w    2272,2499,2749,3024,3327,3660,4026,4428,4871,5358
                            dc.w    5894,6484,7132,7845,8630,9493,10442,11487,12635,13899
                            dc.w    15289,16818,18500,20350,22385,24623,27086,29794,32767

pta_indexTable:             dc.w    -1,-1,-1,-1,2,4,6,8
                            dc.w    -1,-1,-1,-1,2,4,6,8
    endc

pta_chan1temp:              dc.l    0,0,0,0,0,$00010000,0,0,0,0,0
pta_chan2temp:              dc.l    0,0,0,0,0,$00020000,0,0,0,0,0
pta_chan3temp:              dc.l    0,0,0,0,0,$00040000,0,0,0,0,0
pta_chan4temp:              dc.l    0,0,0,0,0,$00080000,0,0,0,0,0 

pta_bufferstep:             dc.l    0
pta_patternssize:           dc.l    0
pta_chunksize:              dc.l    0
pta_SongDataPtr:            dc.l    0
pta_synchro:                dc.b    0
pta_speed:                  dc.b    6
pta_counter:                dc.b    0
pta_SongPos:                dc.b    0
pta_PBreakPos:              dc.b    0
pta_PosJumpFlag:            dc.b    0
pta_PBreakFlag:             dc.b    0
pta_LowMask:                dc.b    0
pta_PattDelTime:            dc.b    0
pta_PattDelTime2:           dc.b    0
pta_Enable:                 dc.b    0
                            even
pta_PatternPos:             dc.w    0
pta_DMACONtemp:             dc.w    0
pta_vbr:                    dc.l    0
pta_old_irq:                dc.l    0
pta_repeat_irq:             dc.l    0
pta_main_irq:               dc.l    0
pta_oldCiaTimers:           dc.b    0
                            dc.b    0
                            dc.b    0
                            dc.b    0
pta_TimerValue:             dc.l    0

fin:

    ifd PTA_EXE_MOD
pta_data:                   ;incbin  "yourmodulehere"
    endc
