#include <stdio.h>
#include <string.h>

/********************************************
*
*  This software is copyright 1999 - Obsidian
*
*  Look for other great tools and demos from
*
*   Obisidian: http://go.to/Obsidian
*
*********************************************/

int main(int argc, char *argv[])
{
	int i, j, k;
	FILE *infile, *outfile;
	char file_in[128], file_out[128];
	char *ptr;
	int byte1, byte2, byte3, byte4;
	int instr;
	int pattern[13][64][4];
	int instrument[13][64][4];
	int note;
	int numPat = 0;
	int tuning;

	/* Initialize arrays with 0, 3328 = 13 * 64 * 4 */
	memset(instrument, '\0', 3328);
	memset(pattern, '\0', 3328);

	/* Make sure there's something on the command line. */
	if(argc != 2)
	{
		printf("\n\nMod-2-MB 2.0.0 - Copyright 1999 - Obsidian\n");
		printf("---------------\n\n");
		printf("Usage: m2mb.exe <filename>\n");
		return -1;
	}

	/* Copy command line argument to in and out strings */
	strcpy(file_out, argv[1]);
	strcpy(file_in, argv[1]);

	/* rename output file to .sav */
	if((ptr = strrchr(file_out, '.')) == NULL)
	{
		i = strlen(file_out);
		file_in[i] = '.';
		file_in[i + 1] = 'm';
		file_in[i + 2] = 'o';
		file_in[i + 3] = 'd';
		file_in[i + 4] = '\0';

		file_out[i] = '.';
		file_out[i + 1] = 's';
		file_out[i + 2] = 'a';
		file_out[i + 3] = 'v';
		file_out[i + 4] = '\0';
	}
	
	else
	{
		ptr[1] = 's';
		ptr[2] = 'a';
		ptr[3] = 'v';
		ptr[4] = '\0';
	}

	printf("\n\nInput file: %s\n", file_in);
	printf("Output file: %s\n", file_out);

	if((infile = fopen(file_in, "rb")) == NULL)
   	{
		printf("Can't open file %s\n", file_in);
		return -1;
	}

	if((outfile = fopen(file_out, "wb")) == NULL)
	{
		printf("Unable to open %s for writing.\n");
		fclose(infile);
		return -1;
	}

	if(fseek(infile, 44, SEEK_SET))
	{
		printf("Couldn't find tuning data in %s", file_in);
		fclose(infile);
		fclose(outfile);
		return -1;
	}

	tuning = getc(infile);
	tuning &= 0x0F;

	fputc(0x06, outfile); /* Tempo */
	fputc(0x77, outfile); /* NR50, full volume */
	fputc(0xA5, outfile); /* NR51, stereo */
	fputc(0x00, outfile); 
	fputc(0x43, outfile); /* Format check */
	fputc(0x2E, outfile); 
	fputc(0x4D, outfile); 
	fputc(0x2E, outfile); 
	fputc(0x00, outfile); 
	fputc(0x00, outfile); 
	fputc(0x00, outfile); 
	fputc(0x00, outfile); 
	fputc(0x00, outfile); 
	fputc(0x00, outfile); 
	fputc(0x00, outfile); 
	fputc(0x00, outfile); 

	/* Create a waveform, for use on instrument $03/Channel 3 */	
	putc(0x00, outfile); /* $0010 */
	putc(0x00, outfile); 
	putc(0x00, outfile);
	putc(0xFF, outfile);
	putc(0xFF, outfile);
	putc(0xFF, outfile);
	putc(0xFF, outfile);
	putc(0xFF, outfile);
	putc(0x00, outfile);
	putc(0x00, outfile);
	putc(0x00, outfile);
	putc(0xFF, outfile);
	putc(0xFF, outfile);
	putc(0xFF, outfile);
	putc(0xFF, outfile);
	putc(0xFF, outfile); /* $001F */
	

	/* Fill rest of waveform data with zero */
	for(i = 0x20; i < 0x100; i++)
		putc(0x00, outfile);

	/* Pattern order for voice #1 */
	putc(0x01, outfile); /* $0100 */
	putc(0x05, outfile);
	putc(0x09, outfile);
	putc(0x0D, outfile);
	putc(0x11, outfile);
	putc(0x15, outfile);
	putc(0x19, outfile);
	putc(0x1D, outfile);
	putc(0x21, outfile);
	putc(0x25, outfile);
	putc(0x29, outfile);
	putc(0x2D, outfile);
	putc(0x31, outfile);
	putc(0xFF, outfile);
	putc(0x00, outfile);
	putc(0x00, outfile); /* $010F */

	/* Fill remaining pattern order bytes with zero */
	for(i = 0x110; i < 0x140; i++)
		putc(0x00, outfile);

	/* Pattern order for voice #2 */
	putc(0x02, outfile); /* $0140 */
	putc(0x06, outfile);
	putc(0x0A, outfile);
	putc(0x0E, outfile);
	putc(0x12, outfile);
	putc(0x16, outfile);
	putc(0x1A, outfile);
	putc(0x1E, outfile);
	putc(0x22, outfile);
	putc(0x26, outfile);
	putc(0x2A, outfile);
	putc(0x2E, outfile);
	putc(0x32, outfile);
	putc(0x00, outfile);
	putc(0x00, outfile);
	putc(0x00, outfile); /* $014F */

	/* Fill remaining pattern order bytes with zero */
	for(i = 0x150; i < 0x180; i++)
		putc(0x00, outfile);

	/* Pattern order for voice #3 */
	putc(0x03, outfile); /* $0180 */
	putc(0x07, outfile);
	putc(0x0B, outfile);
	putc(0x0F, outfile);
	putc(0x13, outfile);
	putc(0x17, outfile);
	putc(0x1B, outfile);
	putc(0x1F, outfile);
	putc(0x23, outfile);
	putc(0x27, outfile);
	putc(0x2B, outfile);
	putc(0x2F, outfile);
	putc(0x33, outfile);
	putc(0x00, outfile);
	putc(0x00, outfile);
	putc(0x00, outfile); /* $018F */

	/* Fill remaining pattern order bytes with zero */
	for(i = 0x190; i < 0x1C0; i++)
		putc(0x00, outfile);

	/* Pattern order for voice #4 */
	putc(0x04, outfile); /* $01C0 */
	putc(0x08, outfile);
	putc(0x0C, outfile);
	putc(0x10, outfile);
	putc(0x14, outfile);
	putc(0x18, outfile);
	putc(0x1C, outfile);
	putc(0x20, outfile);
	putc(0x24, outfile);
	putc(0x28, outfile);
	putc(0x2C, outfile);
	putc(0x30, outfile);
	putc(0x34, outfile);
	putc(0x00, outfile);
	putc(0x00, outfile);
	putc(0x00, outfile); /* $01C8 */

	/* Fill remaining pattern order bytes with zero */
	for(i = 0x1D0; i < 0x200; i++)
		putc(0x00, outfile);

	/* Create an instrument, channel 1 */
	putc(0x00, outfile); /* $0200 */
	putc(0x40, outfile);
	putc(0xF0, outfile);
	putc(0x00, outfile);
	putc(0x00, outfile);
	putc(0x00, outfile);
	putc(0x00, outfile);
	putc(0x00, outfile); /* $0207 */

	/* Create an instrument, channel 2 */
	putc(0x00, outfile); /* $0208 */
	putc(0x40, outfile);
	putc(0xF0, outfile);
	putc(0x00, outfile);
	putc(0x00, outfile);
	putc(0x00, outfile);
	putc(0x00, outfile);
	putc(0x00, outfile); /* $020F */

	/* Create an instrument, channel 3 */
	putc(0x00, outfile); /* $0210 */
	putc(0x00, outfile);
	putc(0x40, outfile);
	putc(0x00, outfile);
	putc(0x00, outfile);
	putc(0x00, outfile);
	putc(0x00, outfile);
	putc(0x00, outfile); /* $021F */
    
	/* Create an instrument, channel 4 */
	putc(0x42, outfile); /* $0218 */
	putc(0xFD, outfile);
	putc(0xF7, outfile);
	putc(0x40, outfile);
	putc(0x00, outfile);
	putc(0x00, outfile);
	putc(0x00, outfile);
	putc(0x00, outfile); /* $021F */

	/* Fill rest of instruments with zero */
	for(i = 0x220; i < 0x300; i++)
		putc(0x00, outfile);

	/* Default arpeggio data */
	putc(0x00, outfile); 
	putc(0x80, outfile); /* This is suggested by the authors */
	putc(0x00, outfile); /* of Blackbox Music Box Sound System */ 

	/* Fill the rest of the arpeggio with zeros */
	for(i = 0x303; i < 0x400; i++)
		putc(0x00, outfile);

	/* Fill empty space for zero pattern */
	for(i = 0x400; i < 0x480; i++)
		putc(0x00, outfile);

	/* Protracker pattern list start at location 952 */
	if(fseek(infile, 952, SEEK_SET))
	{
		printf("Couldn't find Position data in %s", file_in);
		fclose(infile);
		fclose(outfile);
		return -1;
	}

	/* Get the highest number pattern */
	for(i = 0; i < 128; i++)
	{
		j = getc(infile);
		if(j > numPat)
			numPat = j;
	}

	/* A protracker mod can have 128 * 4 patterns */
	/* Music Box has only 13 * 4 + 2 */
	if(numPat > 13)
	{
		printf("Too many patterns, clipping at $34 (52).\n");
		numPat = 12;
	}

	/* Pattern data #0 starts at location 1084 */
	if(fseek(infile, 1084, SEEK_SET))
	{
		printf("Couldn't find Pattern data in %s", file_in);
		fclose(infile);
		fclose(outfile);
		return -1;
	}

	/* Scan thru mod for patterns, and fill our array */
	for(i = 0; i <= numPat; i++)
	{
		for(j = 0; j < 64; j++)
		{
			for(k = 0; k < 4; k++)
			{
				byte1 = getc(infile); 
				byte2 = getc(infile); 
				byte3 = getc(infile);
				byte4 = getc(infile); 

				note = ((byte1 & 0xF) << 8) | byte2;

				instr = (byte1 & 0xF0) | ((byte3 & 0xF0) >> 4);

            switch(tuning)
			{
				case 0:
					switch(note)
				    {
						case 0:    pattern[i][j][k] = 0x00;
							       instrument[i][j][k] = instr;
						           break;
				    	case 113:  pattern[i][j][k] = 0x24;
							       instrument[i][j][k] = instr;
						           break;
					    case 120:  pattern[i][j][k] = 0x23;
							       instrument[i][j][k] = instr;
						           break;
					    case 127:  pattern[i][j][k] = 0x22;
							       instrument[i][j][k] = instr;
						           break;
					    case 135:  pattern[i][j][k] = 0x21;
							       instrument[i][j][k] = instr;
						           break;
					    case 143:  pattern[i][j][k] = 0x20;
							       instrument[i][j][k] = instr;
						           break;
					    case 151:  pattern[i][j][k] = 0x1F;
							       instrument[i][j][k] = instr;
						           break;
					    case 160:  pattern[i][j][k] = 0x1E;
							       instrument[i][j][k] = instr;
						           break;
					    case 170:  pattern[i][j][k] = 0x1D;
							       instrument[i][j][k] = instr;
						           break;
					    case 180:  pattern[i][j][k] = 0x1C;
							       instrument[i][j][k] = instr;
						           break;
					    case 190:  pattern[i][j][k] = 0x1B;
							       instrument[i][j][k] = instr;
						           break;
					    case 202:  pattern[i][j][k] = 0x1A;
							       instrument[i][j][k] = instr;
						           break;
					    case 214:  pattern[i][j][k] = 0x19;
							       instrument[i][j][k] = instr;
						           break;
					    case 226:  pattern[i][j][k] = 0x18;
							       instrument[i][j][k] = instr;
						           break;
					    case 240:  pattern[i][j][k] = 0x17;
							       instrument[i][j][k] = instr;
						           break;
					    case 254:  pattern[i][j][k] = 0x16;
							       instrument[i][j][k] = instr;
						           break;
					    case 269:  pattern[i][j][k] = 0x15;
							       instrument[i][j][k] = instr;
						           break;
					    case 285:  pattern[i][j][k] = 0x14;
							       instrument[i][j][k] = instr;
						           break;
					    case 302:  pattern[i][j][k] = 0x13;
							       instrument[i][j][k] = instr;
						           break;
					    case 320:  pattern[i][j][k] = 0x12;
							       instrument[i][j][k] = instr;
						           break;
					    case 339:  pattern[i][j][k] = 0x11;
							       instrument[i][j][k] = instr;
						           break;
      					case 360:  pattern[i][j][k] = 0x10;
							       instrument[i][j][k] = instr;
						           break;
		      			case 381:  pattern[i][j][k] = 0x0F;
							       instrument[i][j][k] = instr;
						           break;
				      	case 404:  pattern[i][j][k] = 0x0E;
							       instrument[i][j][k] = instr;
						           break;
      					case 428:  pattern[i][j][k] = 0x0D;
							       instrument[i][j][k] = instr;
						           break;
		      			case 453:  pattern[i][j][k] = 0x0C;
							       instrument[i][j][k] = instr;
						           break;
				      	case 480:  pattern[i][j][k] = 0x0B;
							       instrument[i][j][k] = instr;
						           break;
					    case 508:  pattern[i][j][k] = 0x0A;
							       instrument[i][j][k] = instr;
						           break;
					    case 538:  pattern[i][j][k] = 0x09;
							       instrument[i][j][k] = instr;
						           break;
					    case 570:  pattern[i][j][k] = 0x08;
							       instrument[i][j][k] = instr;
						           break;
					    case 604:  pattern[i][j][k] = 0x07;
							       instrument[i][j][k] = instr;
						           break;
					    case 640:  pattern[i][j][k] = 0x06;
							       instrument[i][j][k] = instr;
						           break;
					    case 678:  pattern[i][j][k] = 0x05;
							       instrument[i][j][k] = instr;
						           break;
					    case 720:  pattern[i][j][k] = 0x04;
							       instrument[i][j][k] = instr;
						           break;
					    case 762:  pattern[i][j][k] = 0x03;
							       instrument[i][j][k] = instr;
						           break;
					    case 808:  pattern[i][j][k] = 0x02;
							       instrument[i][j][k] = instr;
						           break;
					    case 856:  pattern[i][j][k] = 0x01;
							       instrument[i][j][k] = instr;
						           break;
					    default:   pattern[i][j][k] = 0x00;
							       instrument[i][j][k] = instr;
					}
				    break;
				case 01:
				      switch(note)
				      {
						  case 0:    pattern[i][j][k] = 0x00;
							         instrument[i][j][k] = instr;
						             break;
				    	  case 113:  pattern[i][j][k] = 0x24;
							         instrument[i][j][k] = instr;
						             break;
					      case 119:  pattern[i][j][k] = 0x23;
							         instrument[i][j][k] = instr;
						             break;
					      case 126:  pattern[i][j][k] = 0x22;
							           instrument[i][j][k] = instr;
						              break;
					      case 134:  pattern[i][j][k] = 0x21;
							           instrument[i][j][k] = instr;
						              break;
					      case 142:  pattern[i][j][k] = 0x20;
							           instrument[i][j][k] = instr;
						              break;
					      case 150:  pattern[i][j][k] = 0x1F;
							           instrument[i][j][k] = instr;
						              break;
					      case 159:  pattern[i][j][k] = 0x1E;
							           instrument[i][j][k] = instr;
						              break;
					      case 169:  pattern[i][j][k] = 0x1D;
							           instrument[i][j][k] = instr;
						              break;
					      case 179:  pattern[i][j][k] = 0x1C;
							           instrument[i][j][k] = instr;
						              break;
					      case 189:  pattern[i][j][k] = 0x1B;
							           instrument[i][j][k] = instr;
						              break;
					      case 201:  pattern[i][j][k] = 0x1A;
							           instrument[i][j][k] = instr;
						              break;
					      case 213:  pattern[i][j][k] = 0x19;
							           instrument[i][j][k] = instr;
						              break;
					      case 225:  pattern[i][j][k] = 0x18;
							           instrument[i][j][k] = instr;
						              break;
					      case 239:  pattern[i][j][k] = 0x17;
							           instrument[i][j][k] = instr;
						              break;
					      case 253:  pattern[i][j][k] = 0x16;
							           instrument[i][j][k] = instr;
						              break;
					      case 268:  pattern[i][j][k] = 0x15;
							           instrument[i][j][k] = instr;
						              break;
					      case 284:  pattern[i][j][k] = 0x14;
							           instrument[i][j][k] = instr;
						              break;
					      case 300:  pattern[i][j][k] = 0x13;
							           instrument[i][j][k] = instr;
						              break;
					      case 318:  pattern[i][j][k] = 0x12;
							           instrument[i][j][k] = instr;
						              break;
					      case 337:  pattern[i][j][k] = 0x11;
							           instrument[i][j][k] = instr;
						              break;
      					case 357:  pattern[i][j][k] = 0x10;
							           instrument[i][j][k] = instr;
						              break;
		      			case 379:  pattern[i][j][k] = 0x0F;
							           instrument[i][j][k] = instr;
						              break;
				      	case 401:  pattern[i][j][k] = 0x0E;
							           instrument[i][j][k] = instr;
						              break;
      					case 425:  pattern[i][j][k] = 0x0D;
							           instrument[i][j][k] = instr;
						              break;
		      			case 450:  pattern[i][j][k] = 0x0C;
							           instrument[i][j][k] = instr;
						              break;
				      	case 477:  pattern[i][j][k] = 0x0B;
							           instrument[i][j][k] = instr;
						              break;
					      case 505:  pattern[i][j][k] = 0x0A;
							           instrument[i][j][k] = instr;
						              break;
					      case 535:  pattern[i][j][k] = 0x09;
							           instrument[i][j][k] = instr;
						              break;
					      case 567:  pattern[i][j][k] = 0x08;
							           instrument[i][j][k] = instr;
						              break;
					      case 601:  pattern[i][j][k] = 0x07;
							           instrument[i][j][k] = instr;
						              break;
					      case 637:  pattern[i][j][k] = 0x06;
							           instrument[i][j][k] = instr;
						              break;
					      case 674:  pattern[i][j][k] = 0x05;
							           instrument[i][j][k] = instr;
						              break;
					      case 715:  pattern[i][j][k] = 0x04;
							           instrument[i][j][k] = instr;
						              break;
					      case 757:  pattern[i][j][k] = 0x03;
							           instrument[i][j][k] = instr;
						              break;
					      case 802:  pattern[i][j][k] = 0x02;
							           instrument[i][j][k] = instr;
						              break;
					      case 850:  pattern[i][j][k] = 0x01;
							           instrument[i][j][k] = instr;
						              break;
					      default:   pattern[i][j][k] = 0x00;
							           instrument[i][j][k] = instr;
				      }
				      break;
				case 02:
				   switch(note)
				      {
					      case 00:  pattern[i][j][k] = 0x00;
							          instrument[i][j][k] = instr;
						             break;
				    	   case 112:  pattern[i][j][k] = 0x24;
							           instrument[i][j][k] = instr;
						              break;
					      case 118:  pattern[i][j][k] = 0x23;
							           instrument[i][j][k] = instr;
						              break;
					      case 125:  pattern[i][j][k] = 0x22;
							           instrument[i][j][k] = instr;
						              break;
					      case 133:  pattern[i][j][k] = 0x21;
							           instrument[i][j][k] = instr;
						              break;
					      case 141:  pattern[i][j][k] = 0x20;
							           instrument[i][j][k] = instr;
						              break;
					      case 149:  pattern[i][j][k] = 0x1F;
							           instrument[i][j][k] = instr;
						              break;
					      case 158:  pattern[i][j][k] = 0x1E;
							           instrument[i][j][k] = instr;
						              break;
					      case 167:  pattern[i][j][k] = 0x1D;
							           instrument[i][j][k] = instr;
						              break;
					      case 177:  pattern[i][j][k] = 0x1C;
							           instrument[i][j][k] = instr;
						              break;
					      case 188:  pattern[i][j][k] = 0x1B;
							           instrument[i][j][k] = instr;
						              break;
					      case 199:  pattern[i][j][k] = 0x1A;
							           instrument[i][j][k] = instr;
						              break;
					      case 211:  pattern[i][j][k] = 0x19;
							           instrument[i][j][k] = instr;
						              break;
					      case 224:  pattern[i][j][k] = 0x18;
							           instrument[i][j][k] = instr;
						              break;
					      case 237:  pattern[i][j][k] = 0x17;
							           instrument[i][j][k] = instr;
						              break;
					      case 251:  pattern[i][j][k] = 0x16;
							           instrument[i][j][k] = instr;
						              break;
					      case 266:  pattern[i][j][k] = 0x15;
							           instrument[i][j][k] = instr;
						              break;
					      case 282:  pattern[i][j][k] = 0x14;
							           instrument[i][j][k] = instr;
						              break;
					      case 298:  pattern[i][j][k] = 0x13;
							           instrument[i][j][k] = instr;
						              break;
					      case 316:  pattern[i][j][k] = 0x12;
							           instrument[i][j][k] = instr;
						              break;
					      case 335:  pattern[i][j][k] = 0x11;
							           instrument[i][j][k] = instr;
						              break;
      					case 355:  pattern[i][j][k] = 0x10;
							           instrument[i][j][k] = instr;
						              break;
		      			case 376:  pattern[i][j][k] = 0x0F;
							           instrument[i][j][k] = instr;
						              break;
				      	case 398:  pattern[i][j][k] = 0x0E;
							           instrument[i][j][k] = instr;
						              break;
      					case 422:  pattern[i][j][k] = 0x0D;
							           instrument[i][j][k] = instr;
						              break;
		      			case 447:  pattern[i][j][k] = 0x0C;
							           instrument[i][j][k] = instr;
						              break;
				      	case 474:  pattern[i][j][k] = 0x0B;
							           instrument[i][j][k] = instr;
						              break;
					      case 502:  pattern[i][j][k] = 0x0A;
							           instrument[i][j][k] = instr;
						              break;
					      case 532:  pattern[i][j][k] = 0x09;
							           instrument[i][j][k] = instr;
						              break;
					      case 563:  pattern[i][j][k] = 0x08;
							           instrument[i][j][k] = instr;
						              break;
					      case 597:  pattern[i][j][k] = 0x07;
							           instrument[i][j][k] = instr;
						              break;
					      case 632:  pattern[i][j][k] = 0x06;
							           instrument[i][j][k] = instr;
						              break;
					      case 670:  pattern[i][j][k] = 0x05;
							           instrument[i][j][k] = instr;
						              break;
					      case 709:  pattern[i][j][k] = 0x04;
							           instrument[i][j][k] = instr;
						              break;
					      case 752:  pattern[i][j][k] = 0x03;
							           instrument[i][j][k] = instr;
						              break;
					      case 796:  pattern[i][j][k] = 0x02;
							           instrument[i][j][k] = instr;
						              break;
					      case 844:  pattern[i][j][k] = 0x01;
							           instrument[i][j][k] = instr;
						              break;
					      default:   pattern[i][j][k] = 0x00;
							           instrument[i][j][k] = instr;
				      }
				      break;
				case 03:
				   switch(note)
				      {
					      case 0:  pattern[i][j][k] = 0x00;
							          instrument[i][j][k] = instr;
						             break;
				    	   case 111:  pattern[i][j][k] = 0x24;
							           instrument[i][j][k] = instr;
						              break;
					      case 118:  pattern[i][j][k] = 0x23;
							           instrument[i][j][k] = instr;
						              break;
					      case 125:  pattern[i][j][k] = 0x22;
							           instrument[i][j][k] = instr;
						              break;
					      case 132:  pattern[i][j][k] = 0x21;
							           instrument[i][j][k] = instr;
						              break;
					      case 140:  pattern[i][j][k] = 0x20;
							           instrument[i][j][k] = instr;
						              break;
					      case 148:  pattern[i][j][k] = 0x1F;
							           instrument[i][j][k] = instr;
						              break;
					      case 157:  pattern[i][j][k] = 0x1E;
							           instrument[i][j][k] = instr;
						              break;
					      case 166:  pattern[i][j][k] = 0x1D;
							           instrument[i][j][k] = instr;
						              break;
					      case 176:  pattern[i][j][k] = 0x1C;
							           instrument[i][j][k] = instr;
						              break;
					      case 187:  pattern[i][j][k] = 0x1B;
							           instrument[i][j][k] = instr;
						              break;
					      case 198:  pattern[i][j][k] = 0x1A;
							           instrument[i][j][k] = instr;
						              break;
					      case 209:  pattern[i][j][k] = 0x19;
							           instrument[i][j][k] = instr;
						              break;
					      case 222:  pattern[i][j][k] = 0x18;
							           instrument[i][j][k] = instr;
						              break;
					      case 235:  pattern[i][j][k] = 0x17;
							           instrument[i][j][k] = instr;
						              break;
					      case 249:  pattern[i][j][k] = 0x16;
							           instrument[i][j][k] = instr;
						              break;
					      case 264:  pattern[i][j][k] = 0x15;
							           instrument[i][j][k] = instr;
						              break;
					      case 280:  pattern[i][j][k] = 0x14;
							           instrument[i][j][k] = instr;
						              break;
					      case 296:  pattern[i][j][k] = 0x13;
							           instrument[i][j][k] = instr;
						              break;
					      case 314:  pattern[i][j][k] = 0x12;
							           instrument[i][j][k] = instr;
						              break;
					      case 332:  pattern[i][j][k] = 0x11;
							           instrument[i][j][k] = instr;
						              break;
      					case 352:  pattern[i][j][k] = 0x10;
							           instrument[i][j][k] = instr;
						              break;
		      			case 373:  pattern[i][j][k] = 0x0F;
							           instrument[i][j][k] = instr;
						              break;
				      	case 395:  pattern[i][j][k] = 0x0E;
							           instrument[i][j][k] = instr;
						              break;
      					case 419:  pattern[i][j][k] = 0x0D;
							           instrument[i][j][k] = instr;
						              break;
		      			case 444:  pattern[i][j][k] = 0x0C;
							           instrument[i][j][k] = instr;
						              break;
				      	case 470:  pattern[i][j][k] = 0x0B;
							           instrument[i][j][k] = instr;
						              break;
					      case 498:  pattern[i][j][k] = 0x0A;
							           instrument[i][j][k] = instr;
						              break;
					      case 528:  pattern[i][j][k] = 0x09;
							           instrument[i][j][k] = instr;
						              break;
					      case 559:  pattern[i][j][k] = 0x08;
							           instrument[i][j][k] = instr;
						              break;
					      case 592:  pattern[i][j][k] = 0x07;
							           instrument[i][j][k] = instr;
						              break;
					      case 628:  pattern[i][j][k] = 0x06;
							           instrument[i][j][k] = instr;
						              break;
					      case 665:  pattern[i][j][k] = 0x05;
							           instrument[i][j][k] = instr;
						              break;
					      case 704:  pattern[i][j][k] = 0x04;
							           instrument[i][j][k] = instr;
						              break;
					      case 746:  pattern[i][j][k] = 0x03;
							           instrument[i][j][k] = instr;
						              break;
					      case 791:  pattern[i][j][k] = 0x02;
							           instrument[i][j][k] = instr;
						              break;
					      case 838:  pattern[i][j][k] = 0x01;
							           instrument[i][j][k] = instr;
						              break;
					      default:   pattern[i][j][k] = 0x00;
							           instrument[i][j][k] = instr;
				      }
				      break;
				case 04:
				switch(note)
				      {
					      case 0:  pattern[i][j][k] = 0x00;
							          instrument[i][j][k] = instr;
						             break;
				    	  case 110:  pattern[i][j][k] = 0x24;
							           instrument[i][j][k] = instr;
						              break;
					      case 117:  pattern[i][j][k] = 0x23;
							           instrument[i][j][k] = instr;
						              break;
					      case 124:  pattern[i][j][k] = 0x22;
							           instrument[i][j][k] = instr;
						              break;
					      case 131:  pattern[i][j][k] = 0x21;
							           instrument[i][j][k] = instr;
						              break;
					      case 139:  pattern[i][j][k] = 0x20;
							           instrument[i][j][k] = instr;
						              break;
					      case 147:  pattern[i][j][k] = 0x1F;
							           instrument[i][j][k] = instr;
						              break;
					      case 156:  pattern[i][j][k] = 0x1E;
							           instrument[i][j][k] = instr;
						              break;
					      case 165:  pattern[i][j][k] = 0x1D;
							           instrument[i][j][k] = instr;
						              break;
					      case 175:  pattern[i][j][k] = 0x1C;
							           instrument[i][j][k] = instr;
						              break;
					      case 185:  pattern[i][j][k] = 0x1B;
							           instrument[i][j][k] = instr;
						              break;
					      case 196:  pattern[i][j][k] = 0x1A;
							           instrument[i][j][k] = instr;
						              break;
					      case 208:  pattern[i][j][k] = 0x19;
							           instrument[i][j][k] = instr;
						              break;
					      case 220:  pattern[i][j][k] = 0x18;
							           instrument[i][j][k] = instr;
						              break;
					      case 233:  pattern[i][j][k] = 0x17;
							           instrument[i][j][k] = instr;
						              break;
					      case 247:  pattern[i][j][k] = 0x16;
							           instrument[i][j][k] = instr;
						              break;
					      case 262:  pattern[i][j][k] = 0x15;
							           instrument[i][j][k] = instr;
						              break;
					      case 278:  pattern[i][j][k] = 0x14;
							           instrument[i][j][k] = instr;
						              break;
					      case 294:  pattern[i][j][k] = 0x13;
							           instrument[i][j][k] = instr;
						              break;
					      case 312:  pattern[i][j][k] = 0x12;
							           instrument[i][j][k] = instr;
						              break;
					      case 330:  pattern[i][j][k] = 0x11;
							           instrument[i][j][k] = instr;
						              break;
      					case 350:  pattern[i][j][k] = 0x10;
							           instrument[i][j][k] = instr;
						              break;
		      			case 370:  pattern[i][j][k] = 0x0F;
							           instrument[i][j][k] = instr;
						              break;
				      	case 392:  pattern[i][j][k] = 0x0E;
							           instrument[i][j][k] = instr;
						              break;
      					case 416:  pattern[i][j][k] = 0x0D;
							           instrument[i][j][k] = instr;
						              break;
		      			case 441:  pattern[i][j][k] = 0x0C;
							           instrument[i][j][k] = instr;
						              break;
				      	case 467:  pattern[i][j][k] = 0x0B;
							           instrument[i][j][k] = instr;
						              break;
					      case 495:  pattern[i][j][k] = 0x0A;
							           instrument[i][j][k] = instr;
						              break;
					      case 524:  pattern[i][j][k] = 0x09;
							           instrument[i][j][k] = instr;
						              break;
					      case 555:  pattern[i][j][k] = 0x08;
							           instrument[i][j][k] = instr;
						              break;
					      case 588:  pattern[i][j][k] = 0x07;
							           instrument[i][j][k] = instr;
						              break;
					      case 623:  pattern[i][j][k] = 0x06;
							           instrument[i][j][k] = instr;
						              break;
					      case 660:  pattern[i][j][k] = 0x05;
							           instrument[i][j][k] = instr;
						              break;
					      case 699:  pattern[i][j][k] = 0x04;
							           instrument[i][j][k] = instr;
						              break;
					      case 741:  pattern[i][j][k] = 0x03;
							           instrument[i][j][k] = instr;
						              break;
					      case 785:  pattern[i][j][k] = 0x02;
							           instrument[i][j][k] = instr;
						              break;
					      case 832:  pattern[i][j][k] = 0x01;
							           instrument[i][j][k] = instr;
						              break;
					      default:   pattern[i][j][k] = 0x00;
							           instrument[i][j][k] = instr;
				      }
				      break;
				case 05:
				switch(note)
				      {
					      case 0:  pattern[i][j][k] = 0x00;
							          instrument[i][j][k] = instr;
						             break;
				    	   case 109:  pattern[i][j][k] = 0x24;
							           instrument[i][j][k] = instr;
						              break;
					      case 116:  pattern[i][j][k] = 0x23;
							           instrument[i][j][k] = instr;
						              break;
					      case 123:  pattern[i][j][k] = 0x22;
							           instrument[i][j][k] = instr;
						              break;
					      case 130:  pattern[i][j][k] = 0x21;
							           instrument[i][j][k] = instr;
						              break;
					      case 138:  pattern[i][j][k] = 0x20;
							           instrument[i][j][k] = instr;
						              break;
					      case 146:  pattern[i][j][k] = 0x1F;
							           instrument[i][j][k] = instr;
						              break;
					      case 155:  pattern[i][j][k] = 0x1E;
							           instrument[i][j][k] = instr;
						              break;
					      case 164:  pattern[i][j][k] = 0x1D;
							           instrument[i][j][k] = instr;
						              break;
					      case 174:  pattern[i][j][k] = 0x1C;
							           instrument[i][j][k] = instr;
						              break;
					      case 184:  pattern[i][j][k] = 0x1B;
							           instrument[i][j][k] = instr;
						              break;
					      case 195:  pattern[i][j][k] = 0x1A;
							           instrument[i][j][k] = instr;
						              break;
					      case 206:  pattern[i][j][k] = 0x19;
							           instrument[i][j][k] = instr;
						              break;
					      case 219:  pattern[i][j][k] = 0x18;
							           instrument[i][j][k] = instr;
						              break;
					      case 232:  pattern[i][j][k] = 0x17;
							           instrument[i][j][k] = instr;
						              break;
					      case 245:  pattern[i][j][k] = 0x16;
							           instrument[i][j][k] = instr;
						              break;
					      case 260:  pattern[i][j][k] = 0x15;
							           instrument[i][j][k] = instr;
						              break;
					      case 276:  pattern[i][j][k] = 0x14;
							           instrument[i][j][k] = instr;
						              break;
					      case 292:  pattern[i][j][k] = 0x13;
							           instrument[i][j][k] = instr;
						              break;
					      case 309:  pattern[i][j][k] = 0x12;
							           instrument[i][j][k] = instr;
						              break;
					      case 328:  pattern[i][j][k] = 0x11;
							           instrument[i][j][k] = instr;
						              break;
      					case 347:  pattern[i][j][k] = 0x10;
							           instrument[i][j][k] = instr;
						              break;
		      			case 368:  pattern[i][j][k] = 0x0F;
							           instrument[i][j][k] = instr;
						              break;
				      	case 390:  pattern[i][j][k] = 0x0E;
							           instrument[i][j][k] = instr;
						              break;
      					case 413:  pattern[i][j][k] = 0x0D;
							           instrument[i][j][k] = instr;
						              break;
		      			case 437:  pattern[i][j][k] = 0x0C;
							           instrument[i][j][k] = instr;
						              break;
				      	case 463:  pattern[i][j][k] = 0x0B;
							           instrument[i][j][k] = instr;
						              break;
					      case 491:  pattern[i][j][k] = 0x0A;
							           instrument[i][j][k] = instr;
						              break;
					      case 520:  pattern[i][j][k] = 0x09;
							           instrument[i][j][k] = instr;
						              break;
					      case 551:  pattern[i][j][k] = 0x08;
							           instrument[i][j][k] = instr;
						              break;
					      case 584:  pattern[i][j][k] = 0x07;
							           instrument[i][j][k] = instr;
						              break;
					      case 619:  pattern[i][j][k] = 0x06;
							           instrument[i][j][k] = instr;
						              break;
					      case 655:  pattern[i][j][k] = 0x05;
							           instrument[i][j][k] = instr;
						              break;
					      case 694:  pattern[i][j][k] = 0x04;
							           instrument[i][j][k] = instr;
						              break;
					      case 736:  pattern[i][j][k] = 0x03;
							           instrument[i][j][k] = instr;
						              break;
					      case 779:  pattern[i][j][k] = 0x02;
							           instrument[i][j][k] = instr;
						              break;
					      case 826:  pattern[i][j][k] = 0x01;
							           instrument[i][j][k] = instr;
						              break;
					      default:   pattern[i][j][k] = 0x00;
							           instrument[i][j][k] = instr;
				      }
				      break;
				case 06:
				switch(note)
				      {
					      case 0:  pattern[i][j][k] = 0x00;
							          instrument[i][j][k] = instr;
						             break;
				    	   case 109:  pattern[i][j][k] = 0x24;
							           instrument[i][j][k] = instr;
						              break;
					      case 115:  pattern[i][j][k] = 0x23;
							           instrument[i][j][k] = instr;
						              break;
					      case 122:  pattern[i][j][k] = 0x22;
							           instrument[i][j][k] = instr;
						              break;
					      case 129:  pattern[i][j][k] = 0x21;
							           instrument[i][j][k] = instr;
						              break;
					      case 137:  pattern[i][j][k] = 0x20;
							           instrument[i][j][k] = instr;
						              break;
					      case 145:  pattern[i][j][k] = 0x1F;
							           instrument[i][j][k] = instr;
						              break;
					      case 154:  pattern[i][j][k] = 0x1E;
							           instrument[i][j][k] = instr;
						              break;
					      case 163:  pattern[i][j][k] = 0x1D;
							           instrument[i][j][k] = instr;
						              break;
					      case 172:  pattern[i][j][k] = 0x1C;
							           instrument[i][j][k] = instr;
						              break;
					      case 183:  pattern[i][j][k] = 0x1B;
							           instrument[i][j][k] = instr;
						              break;
					      case 193:  pattern[i][j][k] = 0x1A;
							           instrument[i][j][k] = instr;
						              break;
					      case 205:  pattern[i][j][k] = 0x19;
							           instrument[i][j][k] = instr;
						              break;
					      case 217:  pattern[i][j][k] = 0x18;
							           instrument[i][j][k] = instr;
						              break;
					      case 230:  pattern[i][j][k] = 0x17;
							           instrument[i][j][k] = instr;
						              break;
					      case 244:  pattern[i][j][k] = 0x16;
							           instrument[i][j][k] = instr;
						              break;
					      case 258:  pattern[i][j][k] = 0x15;
							           instrument[i][j][k] = instr;
						              break;
					      case 274:  pattern[i][j][k] = 0x14;
							           instrument[i][j][k] = instr;
						              break;
					      case 290:  pattern[i][j][k] = 0x13;
							           instrument[i][j][k] = instr;
						              break;
					      case 307:  pattern[i][j][k] = 0x12;
							           instrument[i][j][k] = instr;
						              break;
					      case 325:  pattern[i][j][k] = 0x11;
							           instrument[i][j][k] = instr;
						              break;
      					case 345:  pattern[i][j][k] = 0x10;
							           instrument[i][j][k] = instr;
						              break;
		      			case 365:  pattern[i][j][k] = 0x0F;
							           instrument[i][j][k] = instr;
						              break;
				      	case 387:  pattern[i][j][k] = 0x0E;
							           instrument[i][j][k] = instr;
						              break;
      					case 410:  pattern[i][j][k] = 0x0D;
							           instrument[i][j][k] = instr;
						              break;
		      			case 434:  pattern[i][j][k] = 0x0C;
							           instrument[i][j][k] = instr;
						              break;
				      	case 460:  pattern[i][j][k] = 0x0B;
							           instrument[i][j][k] = instr;
						              break;
					      case 487:  pattern[i][j][k] = 0x0A;
							           instrument[i][j][k] = instr;
						              break;
					      case 516:  pattern[i][j][k] = 0x09;
							           instrument[i][j][k] = instr;
						              break;
					      case 547:  pattern[i][j][k] = 0x08;
							           instrument[i][j][k] = instr;
						              break;
					      case 580:  pattern[i][j][k] = 0x07;
							           instrument[i][j][k] = instr;
						              break;
					      case 614:  pattern[i][j][k] = 0x06;
							           instrument[i][j][k] = instr;
						              break;
					      case 651:  pattern[i][j][k] = 0x05;
							           instrument[i][j][k] = instr;
						              break;
					      case 689:  pattern[i][j][k] = 0x04;
							           instrument[i][j][k] = instr;
						              break;
					      case 730:  pattern[i][j][k] = 0x03;
							           instrument[i][j][k] = instr;
						              break;
					      case 774:  pattern[i][j][k] = 0x02;
							           instrument[i][j][k] = instr;
						              break;
					      case 820:  pattern[i][j][k] = 0x01;
							           instrument[i][j][k] = instr;
						              break;
					      default:   pattern[i][j][k] = 0x00;
							           instrument[i][j][k] = instr;
				      }
				      break;
				case 07:
				switch(note)
				      {
					      case 0:  pattern[i][j][k] = 0x00;
							          instrument[i][j][k] = instr;
						             break;
				    	   case 108:  pattern[i][j][k] = 0x24;
							           instrument[i][j][k] = instr;
						              break;
					      case 114:  pattern[i][j][k] = 0x23;
							           instrument[i][j][k] = instr;
						              break;
					      case 121:  pattern[i][j][k] = 0x22;
							           instrument[i][j][k] = instr;
						              break;
					      case 128:  pattern[i][j][k] = 0x21;
							           instrument[i][j][k] = instr;
						              break;
					      case 136:  pattern[i][j][k] = 0x20;
							           instrument[i][j][k] = instr;
						              break;
					      case 144:  pattern[i][j][k] = 0x1F;
							           instrument[i][j][k] = instr;
						              break;
					      case 152:  pattern[i][j][k] = 0x1E;
							           instrument[i][j][k] = instr;
						              break;
					      case 161:  pattern[i][j][k] = 0x1D;
							           instrument[i][j][k] = instr;
						              break;
					      case 171:  pattern[i][j][k] = 0x1C;
							           instrument[i][j][k] = instr;
						              break;
					      case 181:  pattern[i][j][k] = 0x1B;
							           instrument[i][j][k] = instr;
						              break;
					      case 192:  pattern[i][j][k] = 0x1A;
							           instrument[i][j][k] = instr;
						              break;
					      case 204:  pattern[i][j][k] = 0x19;
							           instrument[i][j][k] = instr;
						              break;
					      case 216:  pattern[i][j][k] = 0x18;
							           instrument[i][j][k] = instr;
						              break;
					      case 228:  pattern[i][j][k] = 0x17;
							           instrument[i][j][k] = instr;
						              break;
					      case 242:  pattern[i][j][k] = 0x16;
							           instrument[i][j][k] = instr;
						              break;
					      case 256:  pattern[i][j][k] = 0x15;
							           instrument[i][j][k] = instr;
						              break;
					      case 272:  pattern[i][j][k] = 0x14;
							           instrument[i][j][k] = instr;
						              break;
					      case 288:  pattern[i][j][k] = 0x13;
							           instrument[i][j][k] = instr;
						              break;
					      case 305:  pattern[i][j][k] = 0x12;
							           instrument[i][j][k] = instr;
						              break;
					      case 323:  pattern[i][j][k] = 0x11;
							           instrument[i][j][k] = instr;
						              break;
      					case 342:  pattern[i][j][k] = 0x10;
							           instrument[i][j][k] = instr;
						              break;
		      			case 363:  pattern[i][j][k] = 0x0F;
							           instrument[i][j][k] = instr;
						              break;
				      	case 384:  pattern[i][j][k] = 0x0E;
							           instrument[i][j][k] = instr;
						              break;
      					case 407:  pattern[i][j][k] = 0x0D;
							           instrument[i][j][k] = instr;
						              break;
		      			case 431:  pattern[i][j][k] = 0x0C;
							           instrument[i][j][k] = instr;
						              break;
				      	case 457:  pattern[i][j][k] = 0x0B;
							           instrument[i][j][k] = instr;
						              break;
					      case 484:  pattern[i][j][k] = 0x0A;
							           instrument[i][j][k] = instr;
						              break;
					      case 513:  pattern[i][j][k] = 0x09;
							           instrument[i][j][k] = instr;
						              break;
					      case 543:  pattern[i][j][k] = 0x08;
							           instrument[i][j][k] = instr;
						              break;
					      case 575:  pattern[i][j][k] = 0x07;
							           instrument[i][j][k] = instr;
						              break;
					      case 610:  pattern[i][j][k] = 0x06;
							           instrument[i][j][k] = instr;
						              break;
					      case 646:  pattern[i][j][k] = 0x05;
							           instrument[i][j][k] = instr;
						              break;
					      case 684:  pattern[i][j][k] = 0x04;
							           instrument[i][j][k] = instr;
						              break;
					      case 725:  pattern[i][j][k] = 0x03;
							           instrument[i][j][k] = instr;
						              break;
					      case 768:  pattern[i][j][k] = 0x02;
							           instrument[i][j][k] = instr;
						              break;
					      case 814:  pattern[i][j][k] = 0x01;
							           instrument[i][j][k] = instr;
						              break;
					      default:   pattern[i][j][k] = 0x00;
							           instrument[i][j][k] = instr;
				      }
				      break;
				case 8:
				switch(note)
				      {
					      case 0:  pattern[i][j][k] = 0x00;
							          instrument[i][j][k] = instr;
						             break;
				    	   case 120:  pattern[i][j][k] = 0x24;
							           instrument[i][j][k] = instr;
						              break;
					      case 127:  pattern[i][j][k] = 0x23;
							           instrument[i][j][k] = instr;
						              break;
					      case 135:  pattern[i][j][k] = 0x22;
							           instrument[i][j][k] = instr;
						              break;
					      case 143:  pattern[i][j][k] = 0x21;
							           instrument[i][j][k] = instr;
						              break;
					      case 151:  pattern[i][j][k] = 0x20;
							           instrument[i][j][k] = instr;
						              break;
					      case 160:  pattern[i][j][k] = 0x1F;
							           instrument[i][j][k] = instr;
						              break;
					      case 170:  pattern[i][j][k] = 0x1E;
							           instrument[i][j][k] = instr;
						              break;
					      case 180:  pattern[i][j][k] = 0x1D;
							           instrument[i][j][k] = instr;
						              break;
					      case 190:  pattern[i][j][k] = 0x1C;
							           instrument[i][j][k] = instr;
						              break;
					      case 202:  pattern[i][j][k] = 0x1B;
							           instrument[i][j][k] = instr;
						              break;
					      case 214:  pattern[i][j][k] = 0x1A;
							           instrument[i][j][k] = instr;
						              break;
					      case 226:  pattern[i][j][k] = 0x19;
							           instrument[i][j][k] = instr;
						              break;
					      case 240:  pattern[i][j][k] = 0x18;
							           instrument[i][j][k] = instr;
						              break;
					      case 254:  pattern[i][j][k] = 0x17;
							           instrument[i][j][k] = instr;
						              break;
					      case 269:  pattern[i][j][k] = 0x16;
							           instrument[i][j][k] = instr;
						              break;
					      case 285:  pattern[i][j][k] = 0x15;
							           instrument[i][j][k] = instr;
						              break;
					      case 302:  pattern[i][j][k] = 0x14;
							           instrument[i][j][k] = instr;
						              break;
					      case 320:  pattern[i][j][k] = 0x13;
							           instrument[i][j][k] = instr;
						              break;
					      case 339:  pattern[i][j][k] = 0x12;
							           instrument[i][j][k] = instr;
						              break;
					      case 360:  pattern[i][j][k] = 0x11;
							           instrument[i][j][k] = instr;
						              break;
      					case 381:  pattern[i][j][k] = 0x10;
							           instrument[i][j][k] = instr;
						              break;
		      			case 404:  pattern[i][j][k] = 0x0F;
							           instrument[i][j][k] = instr;
						              break;
				      	case 428:  pattern[i][j][k] = 0x0E;
							           instrument[i][j][k] = instr;
						              break;
      					case 453:  pattern[i][j][k] = 0x0D;
							           instrument[i][j][k] = instr;
						              break;
		      			case 480:  pattern[i][j][k] = 0x0C;
							           instrument[i][j][k] = instr;
						              break;
				      	case 508:  pattern[i][j][k] = 0x0B;
							           instrument[i][j][k] = instr;
						              break;
					      case 538:  pattern[i][j][k] = 0x0A;
							           instrument[i][j][k] = instr;
						              break;
					      case 570:  pattern[i][j][k] = 0x09;
							           instrument[i][j][k] = instr;
						              break;
					      case 604:  pattern[i][j][k] = 0x08;
							           instrument[i][j][k] = instr;
						              break;
					      case 640:  pattern[i][j][k] = 0x07;
							           instrument[i][j][k] = instr;
						              break;
					      case 678:  pattern[i][j][k] = 0x06;
							           instrument[i][j][k] = instr;
						              break;
					      case 720:  pattern[i][j][k] = 0x05;
							           instrument[i][j][k] = instr;
						              break;
					      case 762:  pattern[i][j][k] = 0x04;
							           instrument[i][j][k] = instr;
						              break;
					      case 808:  pattern[i][j][k] = 0x03;
							           instrument[i][j][k] = instr;
						              break;
					      case 856:  pattern[i][j][k] = 0x02;
							           instrument[i][j][k] = instr;
						              break;
					      case 907:  pattern[i][j][k] = 0x01;
							           instrument[i][j][k] = instr;
						              break;
					      default:   pattern[i][j][k] = 0x00;
							           instrument[i][j][k] = instr;
				      }
				      break;
				case 9:
				switch(note)
				      {
					      case 0:  pattern[i][j][k] = 0x00;
							          instrument[i][j][k] = instr;
						             break;
				    	   case 119:  pattern[i][j][k] = 0x24;
							           instrument[i][j][k] = instr;
						              break;
					      case 126:  pattern[i][j][k] = 0x23;
							           instrument[i][j][k] = instr;
						              break;
					      case 134:  pattern[i][j][k] = 0x22;
							           instrument[i][j][k] = instr;
						              break;
					      case 142:  pattern[i][j][k] = 0x21;
							           instrument[i][j][k] = instr;
						              break;
					      case 150:  pattern[i][j][k] = 0x20;
							           instrument[i][j][k] = instr;
						              break;
					      case 159:  pattern[i][j][k] = 0x1F;
							           instrument[i][j][k] = instr;
						              break;
					      case 169:  pattern[i][j][k] = 0x1E;
							           instrument[i][j][k] = instr;
						              break;
					      case 179:  pattern[i][j][k] = 0x1D;
							           instrument[i][j][k] = instr;
						              break;
					      case 189:  pattern[i][j][k] = 0x1C;
							           instrument[i][j][k] = instr;
						              break;
					      case 200:  pattern[i][j][k] = 0x1B;
							           instrument[i][j][k] = instr;
						              break;
					      case 212:  pattern[i][j][k] = 0x1A;
							           instrument[i][j][k] = instr;
						              break;
					      case 226:  pattern[i][j][k] = 0x19;
							           instrument[i][j][k] = instr;
						              break;
					      case 238:  pattern[i][j][k] = 0x18;
							           instrument[i][j][k] = instr;
						              break;
					      case 253:  pattern[i][j][k] = 0x17;
							           instrument[i][j][k] = instr;
						              break;
					      case 268:  pattern[i][j][k] = 0x16;
							           instrument[i][j][k] = instr;
						              break;
					      case 284:  pattern[i][j][k] = 0x15;
							           instrument[i][j][k] = instr;
						              break;
					      case 300:  pattern[i][j][k] = 0x14;
							           instrument[i][j][k] = instr;
						              break;
					      case 318:  pattern[i][j][k] = 0x13;
							           instrument[i][j][k] = instr;
						              break;
					      case 337:  pattern[i][j][k] = 0x12;
							           instrument[i][j][k] = instr;
						              break;
					      case 357:  pattern[i][j][k] = 0x11;
							           instrument[i][j][k] = instr;
						              break;
      					case 379:  pattern[i][j][k] = 0x10;
							           instrument[i][j][k] = instr;
						              break;
		      			case 401:  pattern[i][j][k] = 0x0F;
							           instrument[i][j][k] = instr;
						              break;
				      	case 425:  pattern[i][j][k] = 0x0E;
							           instrument[i][j][k] = instr;
						              break;
      					case 450:  pattern[i][j][k] = 0x0D;
							           instrument[i][j][k] = instr;
						              break;
		      			case 477:  pattern[i][j][k] = 0x0C;
							           instrument[i][j][k] = instr;
						              break;
				      	case 505:  pattern[i][j][k] = 0x0B;
							           instrument[i][j][k] = instr;
						              break;
					      case 535:  pattern[i][j][k] = 0x0A;
							           instrument[i][j][k] = instr;
						              break;
					      case 567:  pattern[i][j][k] = 0x09;
							           instrument[i][j][k] = instr;
						              break;
					      case 601:  pattern[i][j][k] = 0x08;
							           instrument[i][j][k] = instr;
						              break;
					      case 636:  pattern[i][j][k] = 0x07;
							           instrument[i][j][k] = instr;
						              break;
					      case 675:  pattern[i][j][k] = 0x06;
							           instrument[i][j][k] = instr;
						              break;
					      case 715:  pattern[i][j][k] = 0x05;
							           instrument[i][j][k] = instr;
						              break;
					      case 757:  pattern[i][j][k] = 0x04;
							           instrument[i][j][k] = instr;
						              break;
					      case 802:  pattern[i][j][k] = 0x03;
							           instrument[i][j][k] = instr;
						              break;
					      case 850:  pattern[i][j][k] = 0x02;
							           instrument[i][j][k] = instr;
						              break;
					      case 900:  pattern[i][j][k] = 0x01;
							           instrument[i][j][k] = instr;
						              break;
					      default:   pattern[i][j][k] = 0x00;
							           instrument[i][j][k] = instr;
				      }
				      break;
				case 10:
				switch(note)
				      {
					      case 0:  pattern[i][j][k] = 0x00;
							          instrument[i][j][k] = instr;
						             break;
				    	   case 118:  pattern[i][j][k] = 0x24;
							           instrument[i][j][k] = instr;
						              break;
					      case 125:  pattern[i][j][k] = 0x23;
							           instrument[i][j][k] = instr;
						              break;
					      case 133:  pattern[i][j][k] = 0x22;
							           instrument[i][j][k] = instr;
						              break;
					      case 141:  pattern[i][j][k] = 0x21;
							           instrument[i][j][k] = instr;
						              break;
					      case 149:  pattern[i][j][k] = 0x20;
							           instrument[i][j][k] = instr;
						              break;
					      case 158:  pattern[i][j][k] = 0x1F;
							           instrument[i][j][k] = instr;
						              break;
					      case 167:  pattern[i][j][k] = 0x1E;
							           instrument[i][j][k] = instr;
						              break;
					      case 177:  pattern[i][j][k] = 0x1D;
							           instrument[i][j][k] = instr;
						              break;
					      case 188:  pattern[i][j][k] = 0x1C;
							           instrument[i][j][k] = instr;
						              break;
					      case 199:  pattern[i][j][k] = 0x1B;
							           instrument[i][j][k] = instr;
						              break;
					      case 211:  pattern[i][j][k] = 0x1A;
							           instrument[i][j][k] = instr;
						              break;
					      case 223:  pattern[i][j][k] = 0x19;
							           instrument[i][j][k] = instr;
						              break;
					      case 237:  pattern[i][j][k] = 0x18;
							           instrument[i][j][k] = instr;
						              break;
					      case 251:  pattern[i][j][k] = 0x17;
							           instrument[i][j][k] = instr;
						              break;
					      case 266:  pattern[i][j][k] = 0x16;
							           instrument[i][j][k] = instr;
						              break;
					      case 282:  pattern[i][j][k] = 0x15;
							           instrument[i][j][k] = instr;
						              break;
					      case 298:  pattern[i][j][k] = 0x14;
							           instrument[i][j][k] = instr;
						              break;
					      case 316:  pattern[i][j][k] = 0x13;
							           instrument[i][j][k] = instr;
						              break;
					      case 335:  pattern[i][j][k] = 0x12;
							           instrument[i][j][k] = instr;
						              break;
					      case 355:  pattern[i][j][k] = 0x11;
							           instrument[i][j][k] = instr;
						              break;
      					case 376:  pattern[i][j][k] = 0x10;
							           instrument[i][j][k] = instr;
						              break;
		      			case 398:  pattern[i][j][k] = 0x0F;
							           instrument[i][j][k] = instr;
						              break;
				      	case 422:  pattern[i][j][k] = 0x0E;
							           instrument[i][j][k] = instr;
						              break;
      					case 447:  pattern[i][j][k] = 0x0D;
							           instrument[i][j][k] = instr;
						              break;
		      			case 474:  pattern[i][j][k] = 0x0C;
							           instrument[i][j][k] = instr;
						              break;
				      	case 502:  pattern[i][j][k] = 0x0B;
							           instrument[i][j][k] = instr;
						              break;
					      case 532:  pattern[i][j][k] = 0x0A;
							           instrument[i][j][k] = instr;
						              break;
					      case 563:  pattern[i][j][k] = 0x09;
							           instrument[i][j][k] = instr;
						              break;
					      case 597:  pattern[i][j][k] = 0x08;
							           instrument[i][j][k] = instr;
						              break;
					      case 632:  pattern[i][j][k] = 0x07;
							           instrument[i][j][k] = instr;
						              break;
					      case 670:  pattern[i][j][k] = 0x06;
							           instrument[i][j][k] = instr;
						              break;
					      case 709:  pattern[i][j][k] = 0x05;
							           instrument[i][j][k] = instr;
						              break;
					      case 752:  pattern[i][j][k] = 0x04;
							           instrument[i][j][k] = instr;
						              break;
					      case 796:  pattern[i][j][k] = 0x03;
							           instrument[i][j][k] = instr;
						              break;
					      case 844:  pattern[i][j][k] = 0x02;
							           instrument[i][j][k] = instr;
						              break;
					      case 894:  pattern[i][j][k] = 0x01;
							           instrument[i][j][k] = instr;
						              break;
					      default:   pattern[i][j][k] = 0x00;
							           instrument[i][j][k] = instr;
				      }
				      break;
				case 11:
				switch(note)
				      {
					      case 0:  pattern[i][j][k] = 0x00;
							          instrument[i][j][k] = instr;
						             break;
				    	   case 118:  pattern[i][j][k] = 0x24;
							           instrument[i][j][k] = instr;
						              break;
					      case 125:  pattern[i][j][k] = 0x23;
							           instrument[i][j][k] = instr;
						              break;
					      case 132:  pattern[i][j][k] = 0x22;
							           instrument[i][j][k] = instr;
						              break;
					      case 140:  pattern[i][j][k] = 0x21;
							           instrument[i][j][k] = instr;
						              break;
					      case 148:  pattern[i][j][k] = 0x20;
							           instrument[i][j][k] = instr;
						              break;
					      case 157:  pattern[i][j][k] = 0x1F;
							           instrument[i][j][k] = instr;
						              break;
					      case 166:  pattern[i][j][k] = 0x1E;
							           instrument[i][j][k] = instr;
						              break;
					      case 176:  pattern[i][j][k] = 0x1D;
							           instrument[i][j][k] = instr;
						              break;
					      case 187:  pattern[i][j][k] = 0x1C;
							           instrument[i][j][k] = instr;
						              break;
					      case 198:  pattern[i][j][k] = 0x1B;
							           instrument[i][j][k] = instr;
						              break;
					      case 209:  pattern[i][j][k] = 0x1A;
							           instrument[i][j][k] = instr;
						              break;
					      case 222:  pattern[i][j][k] = 0x19;
							           instrument[i][j][k] = instr;
						              break;
					      case 235:  pattern[i][j][k] = 0x18;
							           instrument[i][j][k] = instr;
						              break;
					      case 249:  pattern[i][j][k] = 0x17;
							           instrument[i][j][k] = instr;
						              break;
					      case 264:  pattern[i][j][k] = 0x16;
							           instrument[i][j][k] = instr;
						              break;
					      case 280:  pattern[i][j][k] = 0x15;
							           instrument[i][j][k] = instr;
						              break;
					      case 296:  pattern[i][j][k] = 0x14;
							           instrument[i][j][k] = instr;
						              break;
					      case 314:  pattern[i][j][k] = 0x13;
							           instrument[i][j][k] = instr;
						              break;
					      case 332:  pattern[i][j][k] = 0x12;
							           instrument[i][j][k] = instr;
						              break;
					      case 352:  pattern[i][j][k] = 0x11;
							           instrument[i][j][k] = instr;
						              break;
      					case 373:  pattern[i][j][k] = 0x10;
							           instrument[i][j][k] = instr;
						              break;
		      			case 395:  pattern[i][j][k] = 0x0F;
							           instrument[i][j][k] = instr;
						              break;
				      	case 419:  pattern[i][j][k] = 0x0E;
							           instrument[i][j][k] = instr;
						              break;
      					case 444:  pattern[i][j][k] = 0x0D;
							           instrument[i][j][k] = instr;
						              break;
		      			case 470:  pattern[i][j][k] = 0x0C;
							           instrument[i][j][k] = instr;
						              break;
				      	case 498:  pattern[i][j][k] = 0x0B;
							           instrument[i][j][k] = instr;
						              break;
					      case 528:  pattern[i][j][k] = 0x0A;
							           instrument[i][j][k] = instr;
						              break;
					      case 559:  pattern[i][j][k] = 0x09;
							           instrument[i][j][k] = instr;
						              break;
					      case 592:  pattern[i][j][k] = 0x08;
							           instrument[i][j][k] = instr;
						              break;
					      case 628:  pattern[i][j][k] = 0x07;
							           instrument[i][j][k] = instr;
						              break;
					      case 665:  pattern[i][j][k] = 0x06;
							           instrument[i][j][k] = instr;
						              break;
					      case 704:  pattern[i][j][k] = 0x05;
							           instrument[i][j][k] = instr;
						              break;
					      case 746:  pattern[i][j][k] = 0x04;
							           instrument[i][j][k] = instr;
						              break;
					      case 791:  pattern[i][j][k] = 0x03;
							           instrument[i][j][k] = instr;
						              break;
					      case 838:  pattern[i][j][k] = 0x02;
							           instrument[i][j][k] = instr;
						              break;
					      case 887:  pattern[i][j][k] = 0x01;
							           instrument[i][j][k] = instr;
						              break;
					      default:   pattern[i][j][k] = 0x00;
							           instrument[i][j][k] = instr;
				      }
				      break;
				case 12:
				switch(note)
				      {
					      case 0:  pattern[i][j][k] = 0x00;
							          instrument[i][j][k] = instr;
						             break;
				    	   case 117:  pattern[i][j][k] = 0x24;
							           instrument[i][j][k] = instr;
						              break;
					      case 123:  pattern[i][j][k] = 0x23;
							           instrument[i][j][k] = instr;
						              break;
					      case 131:  pattern[i][j][k] = 0x22;
							           instrument[i][j][k] = instr;
						              break;
					      case 139:  pattern[i][j][k] = 0x21;
							           instrument[i][j][k] = instr;
						              break;
					      case 147:  pattern[i][j][k] = 0x20;
							           instrument[i][j][k] = instr;
						              break;
					      case 156:  pattern[i][j][k] = 0x1F;
							           instrument[i][j][k] = instr;
						              break;
					      case 165:  pattern[i][j][k] = 0x1E;
							           instrument[i][j][k] = instr;
						              break;
					      case 175:  pattern[i][j][k] = 0x1D;
							           instrument[i][j][k] = instr;
						              break;
					      case 185:  pattern[i][j][k] = 0x1C;
							           instrument[i][j][k] = instr;
						              break;
					      case 196:  pattern[i][j][k] = 0x1B;
							           instrument[i][j][k] = instr;
						              break;
					      case 208:  pattern[i][j][k] = 0x1A;
							           instrument[i][j][k] = instr;
						              break;
					      case 220:  pattern[i][j][k] = 0x19;
							           instrument[i][j][k] = instr;
						              break;
					      case 233:  pattern[i][j][k] = 0x18;
							           instrument[i][j][k] = instr;
						              break;
					      case 247:  pattern[i][j][k] = 0x17;
							           instrument[i][j][k] = instr;
						              break;
					      case 262:  pattern[i][j][k] = 0x16;
							           instrument[i][j][k] = instr;
						              break;
					      case 278:  pattern[i][j][k] = 0x15;
							           instrument[i][j][k] = instr;
						              break;
					      case 294:  pattern[i][j][k] = 0x14;
							           instrument[i][j][k] = instr;
						              break;
					      case 312:  pattern[i][j][k] = 0x13;
							           instrument[i][j][k] = instr;
						              break;
					      case 330:  pattern[i][j][k] = 0x12;
							           instrument[i][j][k] = instr;
						              break;
					      case 350:  pattern[i][j][k] = 0x11;
							           instrument[i][j][k] = instr;
						              break;
      					case 370:  pattern[i][j][k] = 0x10;
							           instrument[i][j][k] = instr;
						              break;
		      			case 392:  pattern[i][j][k] = 0x0F;
							           instrument[i][j][k] = instr;
						              break;
				      	case 416:  pattern[i][j][k] = 0x0E;
							           instrument[i][j][k] = instr;
						              break;
      					case 441:  pattern[i][j][k] = 0x0D;
							           instrument[i][j][k] = instr;
						              break;
		      			case 467:  pattern[i][j][k] = 0x0C;
							           instrument[i][j][k] = instr;
						              break;
				      	case 494:  pattern[i][j][k] = 0x0B;
							           instrument[i][j][k] = instr;
						              break;
					      case 524:  pattern[i][j][k] = 0x0A;
							           instrument[i][j][k] = instr;
						              break;
					      case 555:  pattern[i][j][k] = 0x09;
							           instrument[i][j][k] = instr;
						              break;
					      case 588:  pattern[i][j][k] = 0x08;
							           instrument[i][j][k] = instr;
						              break;
					      case 623:  pattern[i][j][k] = 0x07;
							           instrument[i][j][k] = instr;
						              break;
					      case 660:  pattern[i][j][k] = 0x06;
							           instrument[i][j][k] = instr;
						              break;
					      case 699:  pattern[i][j][k] = 0x05;
							           instrument[i][j][k] = instr;
						              break;
					      case 741:  pattern[i][j][k] = 0x04;
							           instrument[i][j][k] = instr;
						              break;
					      case 785:  pattern[i][j][k] = 0x03;
							           instrument[i][j][k] = instr;
						              break;
					      case 832:  pattern[i][j][k] = 0x02;
							           instrument[i][j][k] = instr;
						              break;
					      case 881:  pattern[i][j][k] = 0x01;
							           instrument[i][j][k] = instr;
						              break;
					      default:   pattern[i][j][k] = 0x00;
							           instrument[i][j][k] = instr;
				      }
				      break;
				case 13:
				switch(note)
				      {
					      case 0:  pattern[i][j][k] = 0x00;
							          instrument[i][j][k] = instr;
						             break;
				    	   case 116:  pattern[i][j][k] = 0x24;
							           instrument[i][j][k] = instr;
						              break;
					      case 123:  pattern[i][j][k] = 0x23;
							           instrument[i][j][k] = instr;
						              break;
					      case 130:  pattern[i][j][k] = 0x22;
							           instrument[i][j][k] = instr;
						              break;
					      case 138:  pattern[i][j][k] = 0x21;
							           instrument[i][j][k] = instr;
						              break;
					      case 146:  pattern[i][j][k] = 0x20;
							           instrument[i][j][k] = instr;
						              break;
					      case 155:  pattern[i][j][k] = 0x1F;
							           instrument[i][j][k] = instr;
						              break;
					      case 164:  pattern[i][j][k] = 0x1E;
							           instrument[i][j][k] = instr;
						              break;
					      case 174:  pattern[i][j][k] = 0x1D;
							           instrument[i][j][k] = instr;
						              break;
					      case 184:  pattern[i][j][k] = 0x1C;
							           instrument[i][j][k] = instr;
						              break;
					      case 195:  pattern[i][j][k] = 0x1B;
							           instrument[i][j][k] = instr;
						              break;
					      case 206:  pattern[i][j][k] = 0x1A;
							           instrument[i][j][k] = instr;
						              break;
					      case 219:  pattern[i][j][k] = 0x19;
							           instrument[i][j][k] = instr;
						              break;
					      case 232:  pattern[i][j][k] = 0x18;
							           instrument[i][j][k] = instr;
						              break;
					      case 245:  pattern[i][j][k] = 0x17;
							           instrument[i][j][k] = instr;
						              break;
					      case 260:  pattern[i][j][k] = 0x16;
							           instrument[i][j][k] = instr;
						              break;
					      case 276:  pattern[i][j][k] = 0x15;
							           instrument[i][j][k] = instr;
						              break;
					      case 292:  pattern[i][j][k] = 0x14;
							           instrument[i][j][k] = instr;
						              break;
					      case 309:  pattern[i][j][k] = 0x13;
							           instrument[i][j][k] = instr;
						              break;
					      case 328:  pattern[i][j][k] = 0x12;
							           instrument[i][j][k] = instr;
						              break;
					      case 347:  pattern[i][j][k] = 0x11;
							           instrument[i][j][k] = instr;
						              break;
      					case 368:  pattern[i][j][k] = 0x10;
							           instrument[i][j][k] = instr;
						              break;
		      			case 390:  pattern[i][j][k] = 0x0F;
							           instrument[i][j][k] = instr;
						              break;
				      	case 413:  pattern[i][j][k] = 0x0E;
							           instrument[i][j][k] = instr;
						              break;
      					case 437:  pattern[i][j][k] = 0x0D;
							           instrument[i][j][k] = instr;
						              break;
		      			case 463:  pattern[i][j][k] = 0x0C;
							           instrument[i][j][k] = instr;
						              break;
				      	case 491:  pattern[i][j][k] = 0x0B;
							           instrument[i][j][k] = instr;
						              break;
					      case 520:  pattern[i][j][k] = 0x0A;
							           instrument[i][j][k] = instr;
						              break;
					      case 551:  pattern[i][j][k] = 0x09;
							           instrument[i][j][k] = instr;
						              break;
					      case 584:  pattern[i][j][k] = 0x08;
							           instrument[i][j][k] = instr;
						              break;
					      case 619:  pattern[i][j][k] = 0x07;
							           instrument[i][j][k] = instr;
						              break;
					      case 655:  pattern[i][j][k] = 0x06;
							           instrument[i][j][k] = instr;
						              break;
					      case 694:  pattern[i][j][k] = 0x05;
							           instrument[i][j][k] = instr;
						              break;
					      case 736:  pattern[i][j][k] = 0x04;
							           instrument[i][j][k] = instr;
						              break;
					      case 779:  pattern[i][j][k] = 0x03;
							           instrument[i][j][k] = instr;
						              break;
					      case 826:  pattern[i][j][k] = 0x02;
							           instrument[i][j][k] = instr;
						              break;
					      case 875:  pattern[i][j][k] = 0x01;
							           instrument[i][j][k] = instr;
						              break;
					      default:   pattern[i][j][k] = 0x00;
							           instrument[i][j][k] = instr;
				      }
				      break;
				case 14:
				switch(note)
				      {
					      case 0:  pattern[i][j][k] = 0x00;
							          instrument[i][j][k] = instr;
						             break;
				    	   case 115:  pattern[i][j][k] = 0x24;
							           instrument[i][j][k] = instr;
						              break;
					      case 122:  pattern[i][j][k] = 0x23;
							           instrument[i][j][k] = instr;
						              break;
					      case 129:  pattern[i][j][k] = 0x22;
							           instrument[i][j][k] = instr;
						              break;
					      case 137:  pattern[i][j][k] = 0x21;
							           instrument[i][j][k] = instr;
						              break;
					      case 145:  pattern[i][j][k] = 0x20;
							           instrument[i][j][k] = instr;
						              break;
					      case 154:  pattern[i][j][k] = 0x1F;
							           instrument[i][j][k] = instr;
						              break;
					      case 163:  pattern[i][j][k] = 0x1E;
							           instrument[i][j][k] = instr;
						              break;
					      case 172:  pattern[i][j][k] = 0x1D;
							           instrument[i][j][k] = instr;
						              break;
					      case 183:  pattern[i][j][k] = 0x1C;
							           instrument[i][j][k] = instr;
						              break;
					      case 193:  pattern[i][j][k] = 0x1B;
							           instrument[i][j][k] = instr;
						              break;
					      case 205:  pattern[i][j][k] = 0x1A;
							           instrument[i][j][k] = instr;
						              break;
					      case 217:  pattern[i][j][k] = 0x19;
							           instrument[i][j][k] = instr;
						              break;
					      case 230:  pattern[i][j][k] = 0x18;
							           instrument[i][j][k] = instr;
						              break;
					      case 244:  pattern[i][j][k] = 0x17;
							           instrument[i][j][k] = instr;
						              break;
					      case 258:  pattern[i][j][k] = 0x16;
							           instrument[i][j][k] = instr;
						              break;
					      case 274:  pattern[i][j][k] = 0x15;
							           instrument[i][j][k] = instr;
						              break;
					      case 290:  pattern[i][j][k] = 0x14;
							           instrument[i][j][k] = instr;
						              break;
					      case 307:  pattern[i][j][k] = 0x13;
							           instrument[i][j][k] = instr;
						              break;
					      case 325:  pattern[i][j][k] = 0x12;
							           instrument[i][j][k] = instr;
						              break;
					      case 345:  pattern[i][j][k] = 0x11;
							           instrument[i][j][k] = instr;
						              break;
      					case 365:  pattern[i][j][k] = 0x10;
							           instrument[i][j][k] = instr;
						              break;
		      			case 387:  pattern[i][j][k] = 0x0F;
							           instrument[i][j][k] = instr;
						              break;
				      	case 410:  pattern[i][j][k] = 0x0E;
							           instrument[i][j][k] = instr;
						              break;
      					case 434:  pattern[i][j][k] = 0x0D;
							           instrument[i][j][k] = instr;
						              break;
		      			case 460:  pattern[i][j][k] = 0x0C;
							           instrument[i][j][k] = instr;
						              break;
				      	case 487:  pattern[i][j][k] = 0x0B;
							           instrument[i][j][k] = instr;
						              break;
					      case 516:  pattern[i][j][k] = 0x0A;
							           instrument[i][j][k] = instr;
						              break;
					      case 547:  pattern[i][j][k] = 0x09;
							           instrument[i][j][k] = instr;
						              break;
					      case 580:  pattern[i][j][k] = 0x08;
							           instrument[i][j][k] = instr;
						              break;
					      case 614:  pattern[i][j][k] = 0x07;
							           instrument[i][j][k] = instr;
						              break;
					      case 651:  pattern[i][j][k] = 0x06;
							           instrument[i][j][k] = instr;
						              break;
					      case 689:  pattern[i][j][k] = 0x05;
							           instrument[i][j][k] = instr;
						              break;
					      case 730:  pattern[i][j][k] = 0x04;
							           instrument[i][j][k] = instr;
						              break;
					      case 774:  pattern[i][j][k] = 0x03;
							           instrument[i][j][k] = instr;
						              break;
					      case 820:  pattern[i][j][k] = 0x02;
							           instrument[i][j][k] = instr;
						              break;
					      case 868:  pattern[i][j][k] = 0x01;
							           instrument[i][j][k] = instr;
						              break;
					      default:   pattern[i][j][k] = 0x00;
							           instrument[i][j][k] = instr;
				      }
				      break;
				case 15:
				switch(note)
				      {
					      case 0:  pattern[i][j][k] = 0x00;
							          instrument[i][j][k] = instr;
						             break;
				    	   case 114:  pattern[i][j][k] = 0x24;
							           instrument[i][j][k] = instr;
						              break;
					      case 121:  pattern[i][j][k] = 0x23;
							           instrument[i][j][k] = instr;
						              break;
					      case 128:  pattern[i][j][k] = 0x22;
							           instrument[i][j][k] = instr;
						              break;
					      case 136:  pattern[i][j][k] = 0x21;
							           instrument[i][j][k] = instr;
						              break;
					      case 144:  pattern[i][j][k] = 0x20;
							           instrument[i][j][k] = instr;
						              break;
					      case 152:  pattern[i][j][k] = 0x1F;
							           instrument[i][j][k] = instr;
						              break;
					      case 161:  pattern[i][j][k] = 0x1E;
							           instrument[i][j][k] = instr;
						              break;
					      case 171:  pattern[i][j][k] = 0x1D;
							           instrument[i][j][k] = instr;
						              break;
					      case 181:  pattern[i][j][k] = 0x1C;
							           instrument[i][j][k] = instr;
						              break;
					      case 192:  pattern[i][j][k] = 0x1B;
							           instrument[i][j][k] = instr;
						              break;
					      case 203:  pattern[i][j][k] = 0x1A;
							           instrument[i][j][k] = instr;
						              break;
					      case 216:  pattern[i][j][k] = 0x19;
							           instrument[i][j][k] = instr;
						              break;
					      case 228:  pattern[i][j][k] = 0x18;
							           instrument[i][j][k] = instr;
						              break;
					      case 242:  pattern[i][j][k] = 0x17;
							           instrument[i][j][k] = instr;
						              break;
					      case 256:  pattern[i][j][k] = 0x16;
							           instrument[i][j][k] = instr;
						              break;
					      case 272:  pattern[i][j][k] = 0x15;
							           instrument[i][j][k] = instr;
						              break;
					      case 288:  pattern[i][j][k] = 0x14;
							           instrument[i][j][k] = instr;
						              break;
					      case 305:  pattern[i][j][k] = 0x13;
							           instrument[i][j][k] = instr;
						              break;
					      case 323:  pattern[i][j][k] = 0x12;
							           instrument[i][j][k] = instr;
						              break;
					      case 342:  pattern[i][j][k] = 0x11;
							           instrument[i][j][k] = instr;
						              break;
      					case 363:  pattern[i][j][k] = 0x10;
							           instrument[i][j][k] = instr;
						              break;
		      			case 384:  pattern[i][j][k] = 0x0F;
							           instrument[i][j][k] = instr;
						              break;
				      	case 407:  pattern[i][j][k] = 0x0E;
							           instrument[i][j][k] = instr;
						              break;
      					case 431:  pattern[i][j][k] = 0x0D;
							           instrument[i][j][k] = instr;
						              break;
		      			case 457:  pattern[i][j][k] = 0x0C;
							           instrument[i][j][k] = instr;
						              break;
				      	case 484:  pattern[i][j][k] = 0x0B;
							           instrument[i][j][k] = instr;
						              break;
					      case 513:  pattern[i][j][k] = 0x0A;
							           instrument[i][j][k] = instr;
						              break;
					      case 543:  pattern[i][j][k] = 0x09;
							           instrument[i][j][k] = instr;
						              break;
					      case 575:  pattern[i][j][k] = 0x08;
							           instrument[i][j][k] = instr;
						              break;
					      case 610:  pattern[i][j][k] = 0x07;
							           instrument[i][j][k] = instr;
						              break;
					      case 646:  pattern[i][j][k] = 0x06;
							           instrument[i][j][k] = instr;
						              break;
					      case 684:  pattern[i][j][k] = 0x05;
							           instrument[i][j][k] = instr;
						              break;
					      case 725:  pattern[i][j][k] = 0x04;
							           instrument[i][j][k] = instr;
						              break;
					      case 768:  pattern[i][j][k] = 0x03;
							           instrument[i][j][k] = instr;
						              break;
					      case 814:  pattern[i][j][k] = 0x02;
							           instrument[i][j][k] = instr;
						              break;
					      case 862:  pattern[i][j][k] = 0x01;
							           instrument[i][j][k] = instr;
						              break;
					      default:   pattern[i][j][k] = 0x00;
							           instrument[i][j][k] = instr;
				      }
				      break;
		      }
			}
		}
	}

	for(i = 0; i < 13; i++)
		for(j = 0; j < 4; j++)
			for(k = 0; k < 64; k++)
			{
				putc(pattern[i][k][j], outfile);
				putc(instrument[i][k][j], outfile);
			}
	
	for(i = 0; i < 384; i++)
		putc(0x00, outfile);

	fclose(infile);
	if(numPat < 12)
	{
		fseek(outfile, 0x100 + numPat + 1, SEEK_SET);
		putc(0xFF, outfile);
		for(i = numPat + 1; i < 13; i++)
			putc(0x00, outfile);
		fseek(outfile, 0x140 + numPat + 1, SEEK_SET);
		for(i = numPat; i < 13; i++)
			putc(0x00, outfile);
		fseek(outfile, 0x180 + numPat + 1, SEEK_SET);
		for(i = numPat; i < 13; i++)
			putc(0x00, outfile);
		fseek(outfile, 0x1C0 + numPat + 1, SEEK_SET);
		for(i = numPat; i < 13; i++)
			putc(0x00, outfile);
	}

	printf("\nPatterns created: %d\n", (numPat + 1) * 4);

	fclose(outfile);
	return 0;
}
