@echo off
chcp 65001 >nul
setlocal enabledelayedexpansion

set "version=1.4"
set "datum=23. Januar 2025"
set "logdatei=log.txt"
set "templogdatei=templog.txt"
set "max_log_groesse=10240" :: 10 KB (die maximale Größe der Log-Datei)

:main
cls
echo ========================================================
echo                FFmpeg Audio Normalisierer v%version%
echo                Erstellt am: %datum%
echo --------------------------------------------------------
echo Diese Batch-Datei normalisiert die Lautstärke einer Audiodatei
echo und speichert sie in einer neuen Datei mit dem Zusatz '-Normalized'.
echo --------------------------------------------------------
echo Bitte kopieren Sie 'ffmpeg.exe' in dasselbe Verzeichnis wie
echo diese Batch-Datei. Sie können 'ffmpeg.exe' von hier herunterladen:
echo https://github.com/BtbN/FFmpeg-Builds/releases/tag/latest
echo ========================================================
echo.
echo Wählen Sie eine Option:
echo [1] Normalisierungsprozess starten
echo.
echo [D] Verzeichnisinhalt anzeigen
echo [Q] Programm beenden
echo.

set /p option=
if /i "!option!"=="1" goto input
if /i "!option!"=="D" goto directory
if /i "!option!"=="Q" goto end

echo Ungültige Eingabe. Bitte versuchen Sie es erneut.
pause
goto main

:directory
cls
echo ========================================================
echo                    Verzeichnisinhalt
echo ========================================================
echo.
dir /b /o:n /t:w
echo.
echo Sie können den Dateinamen mit der Maus markieren und entweder mit Rechtsklick kopieren oder mit STRG+C.
echo.
pause
goto main
:input
cls
echo ========================================================
echo                FFmpeg Audio Normalisierer v%version%
echo                Erstellt am: %datum%
echo --------------------------------------------------------
echo Diese Batch-Datei normalisiert die Lautstärke einer Audiodatei
echo und speichert sie in einer neuen Datei mit dem Zusatz '-Normalized'.
echo ========================================================
echo.
echo Bitte geben Sie den Namen der Originaldatei ein (mit Erweiterung, z.B. "datei.wav"):
echo Oder ziehen Sie die Datei einfach in dieses Fenster und drücken Sie Enter.
echo.
set /p quelle=

:: Anführungszeichen entfernen, falls vorhanden
set "quelle=!quelle:"=!"

:: Validierung der Eingabedatei
if /i not "!quelle:~-4!"==".wav" (
    echo.
    echo Die Datei !quelle! ist keine gültige WAV-Datei. Bitte überprüfen Sie den Dateinamen und versuchen Sie es erneut.
    echo.
    pause
    goto input
)

if not exist "!quelle!" (
    echo.
    echo Die Datei !quelle! wurde nicht gefunden. Bitte überprüfen Sie den Dateinamen und versuchen Sie es erneut.
    echo.
    pause
    goto input
)
echo.
echo Sie haben !quelle! eingegeben.
echo.
echo Das Programm wird den Prozess starten, um die Datei zu normalisieren und die Ausgabedatei zu erstellen.
echo.

echo Wollen Sie mit diesem Prozess fortfahren? [J]a / [N]ein / [Q]uit
set /p confirm=
echo.

if /i "!confirm!"=="J" goto loudness_query
if /i "!confirm!"=="N" (
    set "lautheit=-10"
    goto check_output_exists
)
if /i "!confirm!"=="Q" goto end

goto main
:loudness_query
echo Möchten Sie den Standardwert von -10 LUFS ändern? [J]a / [N]ein
set /p change_loudness=
echo.

if /i "!change_loudness!"=="J" goto process_input
if /i "!change_loudness!"=="N" (
    set "lautheit=-10"
    goto check_output_exists
)
echo Ungültige Eingabe. Bitte versuchen Sie es erneut.
pause
goto loudness_query

:process_input
echo Bitte geben Sie den Ziel-Lautheitswert ein (Standard: -10 LUFS):
set /p lautheit=
:: Überprüfung des Lautheitswertes
if "!lautheit!"=="" set "lautheit=-10"
goto check_output_exists

:check_output_exists
set "ausgabe=!quelle!"
set "ausgabe=!ausgabe:.wav=-Normalized.wav!"

if exist "!ausgabe!" (
    echo.
    echo Die Ausgabedatei "!ausgabe!" existiert bereits. Möchten Sie sie löschen und neu erstellen? [J]a / [N]ein
    set /p delete=
    if /i "!delete!"=="J" (
        del "!ausgabe!"
        goto process
    )
    if /i "!delete!"=="N" (
        goto main
    )
    goto main
)
goto process
:process
if not exist "ffmpeg.exe" (
    echo.
    echo FFmpeg wurde nicht gefunden. Bitte stellen Sie sicher, dass die Datei 'ffmpeg.exe' im gleichen Verzeichnis wie diese Batch-Datei liegt.
    echo.
    pause
    goto main
)

:: Datum und Uhrzeit zur temporären Log-Datei hinzufügen (ohne Hundertstelsekunden)
for /f "tokens=1-3 delims=:.," %%a in ("%time%") do set time_stamp=%%a:%%b:%%c
echo ======================================================== > %templogdatei%
echo Prozess gestartet: %datum% %time_stamp% >> %templogdatei%

:: Fortschrittsanzeige starten
cls
echo ========================================================
echo                FFmpeg Audio Normalisierer v%version%
echo                Erstellt am: %datum%
echo --------------------------------------------------------
echo Diese Batch-Datei normalisiert die Lautstärke einer Audiodatei
echo und speichert sie in einer neuen Datei mit dem Zusatz '-Normalized'.
echo ========================================================
echo.
echo Der Prozess läuft. Bitte warten Sie einen Moment:
echo.

:: Starte ffmpeg im Hintergrund und zeige Fortschrittsanzeige
start /b cmd /c ffmpeg.exe -i "!quelle!" -af "loudnorm=I=!lautheit!:TP=-1" -ar 48000 -ac 2 -c:a pcm_f32le "!ausgabe!" >> %templogdatei% 2>>&1

:: Simulierte Fortschrittsanzeige
set "progress=0"
:progress_loop
set /a progress+=10
if %progress% leq 100 (
    echo %progress%%
    timeout /t 1 >nul
    goto progress_loop
)

:: Überprüfe, ob der Prozess erfolgreich war
if exist "!ausgabe!" (
    echo Prozess abgeschlossen: %datum% %time_stamp% >> %templogdatei%
    echo ======================================================== >> %templogdatei%
    goto merge_logs
) else (
    echo.
    echo Fehler bei der Normalisierung. Weitere Details finden Sie in der %templogdatei% Datei.
    echo.
    echo Fehler bei der Normalisierung: %datum% %time_stamp% >> %templogdatei%
    echo ======================================================== >> %templogdatei%
    goto merge_logs
)
:merge_logs
type %logdatei% >> %templogdatei%
move /y %templogdatei% %logdatei%

:show_output
cls
echo ========================================================
echo                FFmpeg Audio Normalisierer v%version%
echo                Erstellt am: %datum%
echo --------------------------------------------------------
echo Diese Batch-Datei normalisiert die Lautstärke einer Audiodatei
echo und speichert sie in einer neuen Datei mit dem Zusatz '-Normalized'.
echo ========================================================
echo.
echo Die Ausgabedatei "!ausgabe!" wurde erstellt.
echo.
echo Der Arbeitsprozess wurde in der Datei "%logdatei%" gespeichert.
echo Möchten Sie die Log-Datei einsehen? [J]a / [N]ein
set /p view_log=
if /i "!view_log!"=="J" (
    notepad %logdatei%
    echo.
    pause
    goto main
)
if /i "!view_log!"=="N" (
    goto main
)

echo.
echo Der gesamte Prozess dauerte von %start_time% bis %end_time%.
echo.
echo Drücken Sie eine beliebige Taste . . .
pause
goto main
:end
cls
echo ========================================================
echo Diese Datei wurde von Andreas 'melcom' Urban erstellt.
echo Diese Datei ist frei und kostenlos und darf von jedem
echo verändert und weitergegeben werden.
echo --------------------------------------------------------
echo Bei Fragen können Sie melcom über folgenden Link kontaktieren:
echo https://www.melcom-music.de/p/contact.html
echo ========================================================
echo.
pause
exit
