/*******************************************************************************
*     DOS Sound Program Interface                                              *
********************************************************************************
*     (C) Copyright 1995 by Peter Moore                                        *
*     All Rights Reserved                                                      *
********************************************************************************
*     Source file:                                                             *
*     DSPI.H - Header for DSPI functions                                       *
*******************************************************************************/
#ifndef __DSPI_H
#define __DSPI_H

#if defined(__BORLANDC__) || defined(__TURBOC__)
#  define  _DSPIEXPFUNC
#else
#  define  _DSPIEXPFUNC    __cdecl
#endif
#define  _DSPIEXPCLASS
#define  _DSPIEXPDATA


/***************************** DSPI Macros and Definitions ********************/
#if defined(__DPMI16__) || defined(__DPMI32__)
#       define  DPMI
#endif
#ifdef DPMI
#       if defined(__FLAT__)
#               include <windef.h>
#               include <winbase.h>
#       else
#       include <windows.h>
#       endif
#endif
#ifndef NULL
#       define NULL   0
#endif
#if defined(__FLAT__)
#       ifndef  far
#               define  far
#       endif
#       ifndef  huge
#               define  huge
#       endif
#       ifndef interrupt
#               define interrupt
#       endif
#endif
#if !defined(__BORLANDC__) && !defined(__TURBOC__)
#       define  interrupt
#endif

#ifndef DPMI
#       define   FAR                  far
		  typedef  void                 VOID;
		  typedef  unsigned char        BYTE;
		  typedef  unsigned short       WORD;
		  typedef  unsigned long        DWORD;
		  typedef  BYTE FAR*            LPBYTE;
		  typedef  WORD FAR*            LPWORD;
		  typedef  DWORD FAR*           LPDWORD;
		  typedef  char FAR*            LPSTR;
		  typedef  void FAR*            LPVOID;
		  typedef  BYTE                 BOOL;
#endif
typedef  BYTE huge*        HPBYTE;
#ifndef FALSE
#       define  FALSE                (0)
#endif
#ifndef  TRUE
#       define  TRUE                 (!(FALSE))
#endif
#ifndef LO_BYTE
#       define  LO_BYTE(x)     ( ((WORD)(x)) & 0xFF )
#endif
#ifndef HI_BYTE
#       define  HI_BYTE(x)     ( ((WORD)(x)) >> 8 )
#endif
#ifndef LO_WORD
#       define  LO_WORD(x)     ( ((DWORD)(x)) & 0xFFFF )
#endif
#ifndef HI_WORD
#       define  HI_WORD(x)     ( ((DWORD)(x)) >> 16 )
#endif
#define FLIP_WORD(x)    ((x & 0xFF) << 8) + (x >> 8)
#define FLIP_DWORD(x)      (((x) & 0xFFL) << 24) +       \
																								(((x) & 0xFF00L) << 8) +      \
																								(((x) & 0xFF0000L) >> 8) +    \
																								(((x) & 0xFF000000L) >> 24)
#define MAKE_WORD(x,y)  (((WORD)x << 8) + y)
#define MAKE_DWORD(x,y) (((DWORD)x << 16) + y)

// DSPI Errors
#define  DSPI_ERROR_NONE               0x0000
#define  DSPI_ERROR_BAD_MEM_BLOCK      0x0001
#define  DSPI_ERROR_FILE_NOT_FOUND     0x0002
#define  DSPI_ERROR_CANT_READ_FILE     0x0003
#define  DSPI_ERROR_DRIVER             0xFFFF

// Technology types
#define  MIDI_GENERAL                  0x0000
#define  MIDI_2OPFM                    0x0001
#define  MIDI_4OPFM                    0x0003
#define  MIDI_PCSPEAKER                0x0004
#define  MIDI_NOMUSIC                  0xFFFF
#define  WAVE_PCM                      0x0001

// MIDI Errors
#define  MIDI_ERROR_NONE               0x0000
#define  MIDI_ERROR_FILE_NOT_FOUND     0x0101
#define  MIDI_ERROR_DRIVER_NOT_FOUND   0x0102
#define  MIDI_ERROR_NO_DRIVER          0x0103
#define  MIDI_ERROR_OUT_OF_MEMORY      0x0104
#define  MIDI_ERROR_FILE               0x0105
#define  MIDI_ERROR_NO_SCORE           0x0106
#define  MIDI_ERROR_DRIVER             0xFFFF

// MIDI Status
#define  MIDI_STOPPED                  0x0000
#define  MIDI_PLAYING                  0x0001
#define  MIDI_FADING_OUT               0x0002

// MIDI Needs
#define  MIDI_NEEDS_NOTHING            0x0000
#define  MIDI_NEEDS_SMF_ADDRESS        0x0001
#define  MIDI_NEEDS_TIMER_ISR          0x0002
#define  MIDI_NEEDS_SMF_TRACKS         0x0004

// WAVE Status
#define  WAVE_STOPPED                  0x0000
#define  WAVE_PLAYING                  0x0001
#define  WAVE_PAUSED                   0x0002

// WAVE Errors
#define  WAVE_ERROR_NONE               0x0000
#define  WAVE_ERROR_FILE_NOT_FOUND     0x0101
#define  WAVE_ERROR_DRIVER_NOT_FOUND   0x0102
#define  WAVE_ERROR_NO_DRIVER          0x0103
#define  WAVE_ERROR_OUT_OF_MEMORY      0x0104
#define  WAVE_ERROR_FILE               0x0105
#define  WAVE_ERROR_INVALID_FORMAT     0x0000
#define  WAVE_ERROR_DRIVER             0xFFFF

// How to play a MIDI file
#define  MIDI_NOW                      0x0000   // Immediately
#define  MIDI_NEXT                     0x0001   // Next
#define  MIDI_LAST                     0x0002   // At end of queue

// Wave Types
#ifndef __WINDOWS_H
		  #define  WAVE_FORMAT_1M08              0x0001
		  #define  WAVE_FORMAT_1S08              0x0002
		  #define  WAVE_FORMAT_1M16              0x0004
		  #define  WAVE_FORMAT_1S16              0x0008
		  #define  WAVE_FORMAT_2M08              0x0010
		  #define  WAVE_FORMAT_2S08              0x0020
		  #define  WAVE_FORMAT_2M16              0x0040
		  #define  WAVE_FORMAT_2S16              0x0080
		  #define  WAVE_FORMAT_4M08              0x0100
		  #define  WAVE_FORMAT_4S08              0x0200
		  #define  WAVE_FORMAT_4M16              0x0400
		  #define  WAVE_FORMAT_4S16              0x0800
#else
		  #include <mmsystem.h>
#endif
#define  WAVE_FORMAT_STEREO               0x0AAA
#define  WAVE_FORMAT_16BIT                0x0CCC


/***************************** DSPI Structures ********************************/
// 32-bit Only
#ifdef __DPMI32__
typedef struct {
		  DWORD Offset;
		  WORD  Selector;
} FWORD;
#endif

// For getting configuration variables
typedef struct {
		  LPSTR    lpszName;         // Name of the variable
		  LPSTR    lpszDescription;  // Description
		  BYTE     bType;            // Type. 0=byte, 1=word, 2=dword, 3= string
		  BYTE     bChoices;         // Number of choices
		  BYTE     bDefault;         // Index of default choice
		  LPDWORD  lpChoices;        // Array of choices
} DSPIVARIABLE;

typedef struct {
		  BYTE           bVariables; // Number of variables
		  DSPIVARIABLE*  Variables;  // Array of variables
} DSPICONFIG;

// Structures for DSPI MIDI (FF means flip-flopped)
typedef struct {
		  char  MThd[4];          // Should be "MThd"
		  DWORD dwHeaderLength;   // Should be 6 (FF)
		  WORD  wType;            // Should be 0 (FF)
		  WORD  wTracks;          // Should be 1 (FF)
		  WORD  wTicksPerQuarter; // Variable    (FF)
		  char  MTrk[4];          // Should be "MTrk"
		  DWORD dwTrackLength;    // Variable    (FF)
} SMF_0;

typedef struct {
		  WORD     wVersion;                  // Driver version
		  LPSTR    lpszDriverName;
		  LPSTR    lpszManufacturer;
		  LPSTR    lpszDescription;
		  WORD     wChannels;                 // Number of channels supported
		  WORD     wMaximumPolyphony;         // Maximum polyphony
		  WORD     wTechnology;               // Type of synthesizer
		  BOOL     bVolumeControl;            // TRUE if it has
																																		  // independent volume
																																		  // control
} MIDICAPS;

typedef struct {
		  WORD     wHowMany;
		  DWORD    dwNameOffset;
} SCOREHEADER;

typedef struct {
		  char  Name[8];
		  DWORD dwLength;
		  DWORD dwPosition;
} SEQUENCENAME;

// Structures for DSPI Time
typedef struct {
		  BYTE  hsec:7;  // hundredths of seconds
		  BYTE  sec:6;   // seconds
		  BYTE  min:6;   // minutes
		  BYTE  hour:5;  // hours
} DSPITIME; // 3 bytes

// Structures for DSPI Wave
typedef struct {
		  BYTE  RIFF[4];             // "RIFF"
		  DWORD dwFileLength;
		  BYTE  WAVE[4];             // "WAVE"
		  BYTE  fmt[4];              // "fmt "
		  DWORD dwFormatLength;
		  WORD  wFormatTag;          // WAVE_PCM is currently defined = 1
		  WORD  wChannels;           // 1 = mono, 2 = stereo, > 2 = ?
		  DWORD dwSamplesPerSecond;
		  DWORD dwBytesPerSecond;
		  WORD  wBlockAlignment;     // 8-bit mono = 1
																										  // 8-bit stereo = 2
																										  // 16-bit mono = 2
																										  // 16-bit stereo = 4
		  WORD  wBitsPerSample;      // 8 or 16
		  BYTE  data[4];             // "data"
		  DWORD dwSampleLength;      // actual length of wave data
} WAVE_FILE;

typedef struct {
		  WORD     wVersion;
		  LPSTR    lpszDriverName;
		  LPSTR    lpszManufacturer;
		  LPSTR    lpszDescription;
		  DWORD    dwMaxSamplingRate;
		  WORD     wMaxBitsPerSample;
		  WORD     wMaxChannels;
		  DWORD    dwFormats;
} WAVECAPS;

typedef struct {
		  DWORD    dwFormat;
		  DWORD    dwSamplingRate;
		  DWORD    dwLength;
		  WORD     wFormatTag;
} WAVEBUFFER;


/****************************** Global Variables ******************************/
extern SEQUENCENAME huge* lpScoreNames;
extern HPBYTE lpScoreFile;
extern DWORD dwTimeCounter;
extern DWORD dwTimeOldTime;
extern DWORD dwTimePeriod;
extern void (*timeCallback)(void);
extern DWORD dwTimeCallbackPeriod;
extern DWORD dwTimeCallbackCountdown;
#if !defined(__DPMI32__)
#if (defined(__BORLANDC__) || defined(__TURBOC__)) && defined(__cplusplus)
extern VOID interrupt (*lpTimeOldTimer)(...);
#else   // __BORLANDC__
extern VOID interrupt (*lpTimeOldTimer)(VOID);
#endif  // __BORLANDC__
#else   // __DPMI32__
extern FWORD lpTimeOldTimer;
extern DWORD wTimeSelector;
#endif  // __DPMI32__


/******************************** The DSPI API ********************************/
#ifdef __cplusplus
		  extern "C" {
#endif

// Functions for miscellaneous DSPI
DWORD _DSPIEXPFUNC dspiGetFileLength (LPSTR lpszFilename);
WORD _DSPIEXPFUNC dspiLoadFile (LPSTR lpszFilename, HPBYTE lpFile);
#ifdef DPMI
WORD _DSPIEXPFUNC dspiGetSelector (WORD wRealSegment);
#endif
#ifdef __DPMI32__
VOID _DSPIEXPFUNC setvect ( BYTE bVect, WORD wSel, DWORD dwOffset );
VOID _DSPIEXPFUNC getvect ( BYTE bVect, WORD* wSel, DWORD* dwOffset );
VOID _DSPIEXPFUNC timer_isr (VOID);
#endif

// glue code for non Borland C products
#if !defined(__BORLANDC__) && !defined(__TURBOC__) && !defined(__WATCOMC__)
VOID _DSPIEXPFUNC _dos_setvect (BYTE bVect, VOID (*isr)(VOID));
VOID _DSPIEXPFUNC (*_dos_getvect (BYTE bVect))(VOID);
#endif

#if !defined(__BORLANDC__) && !defined(__TURBOC__)
VOID _DSPIEXPFUNC enable (VOID);
VOID _DSPIEXPFUNC disable (VOID);
VOID _DSPIEXPFUNC outportb (WORD wPort, BYTE bData);
#endif

VOID _DSPIEXPFUNC timeGetOldTimer (VOID);
VOID _DSPIEXPFUNC timeSetOldTimer (VOID);

// Functions for timing
#if defined(_DSPIDEBUG)
VOID timeStartTimer (VOID);
VOID timeEndTimer (VOID);
#endif
DWORD _DSPIEXPFUNC timeGetLongTime (VOID);
DSPITIME _DSPIEXPFUNC timeGetClock (VOID);
VOID _DSPIEXPFUNC timeSetCallback ( void (*Callback)(void), float Frequency );
VOID _DSPIEXPFUNC timeRemoveCallback (VOID);
float _DSPIEXPFUNC timeGetClockFrequency (VOID);
VOID _DSPIEXPFUNC timeSetClockPeriod (WORD wPeriod);

// Functions for DSPI MIDI
HPBYTE _DSPIEXPFUNC midiLoadFile (LPSTR lpszFileName, LPDWORD dwSize);
WORD _DSPIEXPFUNC midiLoadDriver (LPSTR lpszDriver);
WORD _DSPIEXPFUNC midiOpenDriver (LPSTR lpszDriver);
WORD _DSPIEXPFUNC midiUnloadDriver (VOID);
WORD _DSPIEXPFUNC midiCloseDriver (VOID);
WORD _DSPIEXPFUNC midiDriverEntry (VOID);
WORD _DSPIEXPFUNC midiDriverExit (VOID);
WORD _DSPIEXPFUNC midiReset (VOID);
WORD _DSPIEXPFUNC midiGetDeviceCaps (MIDICAPS far* lpCaps);
DSPICONFIG _DSPIEXPFUNC midiGetConfigInfo (VOID);
HPBYTE _DSPIEXPFUNC midiLoadSMF (LPSTR lpszFilename, SMF_0 far* lpHeader);
WORD _DSPIEXPFUNC midiSetDriverSpecific (LPVOID lpBuffer);
VOID _DSPIEXPFUNC midiSetTempo (BYTE bTempo);
BYTE _DSPIEXPFUNC midiGetTempo (VOID);
VOID _DSPIEXPFUNC midiSetTicksPerQuarter (WORD wDelta);
WORD _DSPIEXPFUNC midiStartRawOutput (HPBYTE lpBuffer);
WORD _DSPIEXPFUNC midiPlaySMF (HPBYTE lpMidiFile, SMF_0 far* lpHeader);
WORD _DSPIEXPFUNC midiStopOutput (VOID);
WORD _DSPIEXPFUNC midiPauseOutput (VOID);
WORD _DSPIEXPFUNC midiContinueOutput (VOID);
WORD _DSPIEXPFUNC midiOutLongMessage (WORD wLength, LPBYTE lpBuffer);
WORD _DSPIEXPFUNC midiOutShortMessage (BYTE bMessage);
WORD _DSPIEXPFUNC midiGetStatus (VOID);
VOID _DSPIEXPFUNC midiStartTimer (VOID);
VOID _DSPIEXPFUNC midiStopTimer (VOID);
VOID _DSPIEXPFUNC midiSetVolume (BYTE bVolume);  // from 0-100% of normal
																																// volume
WORD _DSPIEXPFUNC midiFadeOut (float Seconds);   // Seconds is the number
					 // of seconds the fade out will take.  The fade will
					 // occur in the bakcground.  During the fade,
					 // midiGetStatus will return MIDI_FADING_OUT.  At the
					 // end, it will return MIDI_STOPPED.  At the end of
					 // the fade, thus, output stops completely.
BYTE* _DSPIEXPFUNC midiGetChannelVolumes (VOID);

// Functions for the Conductor
WORD _DSPIEXPFUNC midiLoadScore (LPSTR lpszScoreName);
VOID _DSPIEXPFUNC midiCloseScore (VOID);
WORD _DSPIEXPFUNC midiPlaySequence (WORD wWhich, WORD wWhen);
WORD _DSPIEXPFUNC midiSetQueue (WORD wLength, WORD wQueue[]);
LPSTR _DSPIEXPFUNC midiGetSequenceName (WORD wWhich);
VOID _DSPIEXPFUNC midiSetNext (HPBYTE lpData);
VOID _DSPIEXPFUNC midiAddToQueue (HPBYTE lpData);
SCOREHEADER _DSPIEXPFUNC midiGetScoreHeader (VOID);
VOID _DSPIEXPFUNC midiClearQueue (VOID);
WORD _DSPIEXPFUNC midiHowManySequences (VOID);

// Internal use; not to be called by programs
#if (defined(__BORLANDC__) || defined(__TURBOC__)) && defined(__cplusplus)
VOID interrupt midiTimerHandler(...);
#else
VOID interrupt midiTimerHandler(void);
#endif


/*
// Functions for DSPI WAVE
#define waveLoadFile(filename, size)  midiLoadFile(filename, size)
WORD waveOpenDriver (LPSTR lpszDrivername);
WORD waveCloseDriver (VOID);
WORD waveDriverEntry (VOID);
WORD waveDriverExit (VOID);
WORD waveGetDeviceCaps (WAVECAPS far* lpCaps);
WORD waveDriverReset (VOID);
HPBYTE waveLoadWAV (LPSTR lpszFilename, WAVE_FILE far* lpHeader);
WORD waveSetDriverSpecific (LPVOID lpString);
WORD waveGetStatus (VOID);
WORD wavePlayRawData (HPBYTE lpData, WAVEBUFFER far* lpInfo);
WORD wavePlayWAV (HPBYTE lpData, WAVE_FILE far* lpHeader);
WORD waveStopOutput (VOID);
WORD wavePauseOutput (VOID);
WORD waveContinueOutput (VOID);
*/
#ifdef __cplusplus
		  }


/***************************** DSPI++ - The C++ Interface *********************/
class _DSPIEXPCLASS TMidiDriver {
		  protected:
					 MIDICAPS Caps;
					 WORD     wLastError;
		  public:
					 TMidiDriver ();
					 TMidiDriver (LPSTR lpszDriver);
					 TMidiDriver (LPSTR lpszDriver, LPVOID lpConfigString);
					 ~TMidiDriver ();
					 WORD OpenDriver (LPSTR lpszDriver);
					 WORD GetLastError (VOID);
					 WORD GetStatus (VOID);
					 WORD GetTempo (VOID);
					 VOID SetTempo (WORD wTempo);
					 MIDICAPS GetCaps (VOID);
					 WORD FadeOut (float s);
					 WORD Stop (VOID);
					 VOID Wait (VOID);
};

class _DSPIEXPCLASS TMidi : public TMidiDriver  {
		  protected:
					 SMF_0    FileHeader;
					 HPBYTE   File;
		  public:
					 TMidi (VOID);
					 TMidi (LPSTR lpszDriver);
					 TMidi (LPSTR lpszDriver, LPSTR lpszFilename);
					 TMidi (LPSTR lpszDriver, LPVOID lpConfigString);
					 ~TMidi (VOID);
					 WORD LoadSMF (LPSTR lpszFilename);
					 SMF_0 GetFileHeader (VOID);
					 WORD Play (VOID);
};

class _DSPIEXPCLASS TMidiScore : public TMidiDriver {
		  protected:
					 SCOREHEADER ScoreHeader;
		  public:
					 TMidiScore (VOID);
					 TMidiScore (LPSTR lpszDriver);
					 TMidiScore (LPSTR lpszDriver, LPSTR lpszScorename);
					 TMidiScore (LPSTR lpszDriver, LPVOID lpConfigString);
					 ~TMidiScore ();
					 WORD LoadScore (LPSTR lpszScorename);
					 WORD Play (WORD wWhich, WORD wWhen);
					 LPSTR GetName (WORD wWhich);
					 SCOREHEADER GetHeader (VOID);
};

#endif   // __cplusplus


#endif   // __DSPI_H

