// -----------------------------------------------------------------------
// CList class
// Copyright (C) 2004 Franck Charlet.
//
// CList is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2, or (at your option)
// any later version.
//
// CList is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with CList; see the file Copying.txt.  If not, write to
// the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
// Boston, MA 02111-1307, USA.
// -----------------------------------------------------------------------
// CList.h: interface for the CList class
// -----------------------------------------------------------------------

#ifndef _CLIST_H_
#define _CLIST_H_

// -----------------------------------------------------------------------
// Includes
#include <stdlib.h>
#include <string.h>

// -----------------------------------------------------------------------
// Structures
struct CList_Entry {
	struct CList_Entry *Next;
	struct CList_Entry *Previous;
	union {
		char *Char;
		long Long;
		float Float;
		double Double;
	} u;
};

// -----------------------------------------------------------------------
// Class definition
class CList {
public:
	// Default Constructor/Destructor
	CList();
	virtual ~CList();
	// Methods
	struct CList_Entry *Add_Entry(long Datas);
	struct CList_Entry *Add_Entry(int Datas) {
		return(this->Add_Entry((long) Datas));
	}
	struct CList_Entry *Add_Entry(char *Datas);
	struct CList_Entry *Add_Entry(float Datas);
	struct CList_Entry *Add_Entry(double Datas);
	void Add_Entries(long Number, long Datas);
	void Add_Entries(long Number, int Datas);
	void Add_Entries(long Number, char *Datas);
	void Add_Entries(long Number, float Datas);
	void Add_Entries(long Number, double Datas);
	long Get_Number_Of_Entries(void);
	struct CList_Entry *Is_Entry(long Datas);
	void Delete_Entry(struct CList_Entry *, bool Free_Datas);
	void Delete_Entry_By_Ordinal(long Entry_Number, bool Free_Datas);
	struct CList_Entry *Get_Entry_By_Ordinal(long Entry_Number);
	long Get_Entry_By_Ordinal_Long(long Entry_Number);
	char *Get_Entry_By_Ordinal_Char(long Entry_Number);
	float Get_Entry_By_Ordinal_Float(long Entry_Number);
	double Get_Entry_By_Ordinal_Double(long Entry_Number);
	long *Get_Entry_By_Ordinal_Addr(long Entry_Number);
	struct CList_Entry *Set_Entry_By_Ordinal(long Entry_Number, long Datas, bool Free_Datas);
	struct CList_Entry *Set_Entry_By_Ordinal(long Entry_Number, int Datas) {
		return(this->Set_Entry_By_Ordinal(Entry_Number, (long) Datas, false));
	}
	struct CList_Entry *Set_Entry_By_Ordinal(long Entry_Number, char *Datas);
	struct CList_Entry *Set_Entry_By_Ordinal(long Entry_Number, float Datas);
	struct CList_Entry *Set_Entry_By_Ordinal(long Entry_Number, double Datas);
	long Get_Entry_By_Address(CList_Entry *);
	struct CList_Entry *Set_Entry_By_Address(struct CList_Entry *Entry_To_Set, long Datas, bool Free_Datas);
	struct CList_Entry *Set_Entry_By_Address(struct CList_Entry *Entry_To_Set, int Datas) {
		return(this->Set_Entry_By_Address(Entry_To_Set, (long) Datas, false));
	}
	struct CList_Entry *Set_Entry_By_Address(struct CList_Entry *Entry_To_Set, char *Datas);
	struct CList_Entry *Set_Entry_By_Address(struct CList_Entry *Entry_To_Set, float Datas);
	struct CList_Entry *Set_Entry_By_Address(struct CList_Entry *Entry_To_Set, double Datas);
	struct CList_Entry *Insert_Entry_Before(struct CList_Entry *Entry_To_Set, long Datas);
	struct CList_Entry *Insert_Entry_After(struct CList_Entry *Entry_To_Set, long Datas);
	void Clear_All(bool);
	struct CList_Entry *Search_Entry(long Entry_Datas);
	struct CList_Entry *Search_Entry(char *Entry_Datas, long Case_Sensitive);
private:
	long Nbr_Entries;
	struct CList_Entry *Last_Entry;
	struct CList_Entry *First_Entry;
};

#endif
