; ------------------------------------------
; Flat starter file for console applications
; Only one code section will be produced with Exec/Read/Write abilities
; Resulting smaller file and self modifiable code/datas.
; ------------------------------------------
; buildblock RELEASE
; 	CAPT [BINDIR]\ml.exe /c /coff /I"[INCLUDEDIR]" "%2"
; 	CAPT [BINDIR]\Link.exe /MERGE:.data=.text /LIBPATH:"[LIBDIR]" /MERGE:.rdata=.text /SECTION:.text,ERW /IGNORE:4078 /SUBSYSTEM:WINDOWS "%1.obj"
; buildblockend
; buildblock DEBUG
; 	CAPT [BINDIR]\ml.exe /Zd /Zi /c /coff /I"[INCLUDEDIR]" "%2"
;	CAPT [BINDIR]\Link.exe /DEBUG /DEBUGTYPE:CV /INCREMENTAL:NO /LIBPATH:"[LIBDIR]" /MERGE:.data=.text /MERGE:.rdata=.text /SECTION:.text,ERW /IGNORE:4078 /SUBSYSTEM:WINDOWS "%1.obj"
; buildblockend

; --------------- File model
			.386
			.model	flat,stdcall
			option	casemap:none

; --------------- Includes
			include	windows.inc
	 		include kernel32.inc
	 		include user32.inc
	 		include masm32.inc
			include dsound.inc
	 		include DSoundConst.inc

; --------------- Libraries
			includelib kernel32.lib
			includelib user32.lib
			includelib masm32.lib
			includelib dsound.lib

; --------------- Datas section
			.data

WindowName		db	"TRSI Sound Monitor replay routine.",0
WindowClassName		db	"TSMReplay_Class",0
ModuleName		db	"digit.tsm",0
hWnd			dd	0
ModuleMem		dd	0
ReadBytes		dd	0

; --------------- Code section
			.code

; --------------- Include the replay routine before the rest
			include	TSMReplay.asm

; --------------- Handle window messages
MainLoop		proc	hWin:dword,uMsg:dword,wParam:dword,lParam:dword
			.if uMsg == WM_DESTROY
			;	invoke	TSM_Stop
				invoke	GlobalFree,ModuleMem
				invoke	PostQuitMessage,0
				xor	eax,eax
				ret
			.endif
			invoke	DefWindowProc,hWin,uMsg,wParam,lParam
			ret
MainLoop		endp

; --- Open a file and load it into a memory block
; Returns the allocated memory block or 0
; (Free memory block with GlobalFree)
LoadFile		proc	FName:dword,FileReadBytes:dword
			local	FHandle:dword
			local	FSize:dword
			local	FPosition:dword

			mov	FPosition,0
			invoke	CreateFile,FName,GENERIC_READ,0,0,OPEN_EXISTING,FILE_FLAG_SEQUENTIAL_SCAN,0
			inc	eax
			je	Error_OpenFile
			dec	eax
			mov	FHandle,eax
			invoke	GetFileSize,eax,0
			inc	eax
			je	Error_ReadFile
			dec	eax
			mov	FSize,eax
			inc	eax				; Append a 0 char
			invoke	GlobalAlloc,GMEM_FIXED or GMEM_ZEROINIT,eax
			test	eax,eax
			jz	Error_ReadFile
			mov	FPosition,eax
			invoke	ReadFile,FHandle,FPosition,FSize,FileReadBytes,0
Error_ReadFile:		invoke	CloseHandle,FHandle
Error_OpenFile:		mov	eax,FPosition			; Return the memory block address
			ret
LoadFile		endp

; --------------- Display main window
DisplayWindow		proc	hInst:dword
			local	wc:WNDCLASSEX
	        	mov	wc.cbSize,sizeof WNDCLASSEX
			mov	wc.style,CS_HREDRAW or CS_VREDRAW or CS_BYTEALIGNWINDOW
			mov	wc.lpfnWndProc,offset MainLoop
			xor	eax,eax
			mov	wc.cbClsExtra,eax
			mov	wc.cbWndExtra,eax
			push	hInst
			pop	wc.hInstance
			mov	wc.hbrBackground,COLOR_BTNFACE+1
			mov	wc.lpszMenuName,eax
			mov	wc.lpszClassName,offset WindowClassName
			mov	wc.hIcon,eax
			mov	wc.hIconSm,eax
			invoke	LoadCursor,eax,IDC_ARROW
			mov	wc.hCursor,eax
			invoke	RegisterClassEx,addr wc
		        invoke	CreateWindowEx,WS_EX_TOOLWINDOW,addr WindowClassName,addr WindowName,WS_BORDER or WS_CAPTION or WS_SYSMENU,100,100,400,100,0,0,hInst,0
			mov	hWnd,eax
			invoke	ShowWindow,hWnd,SW_SHOWNORMAL
			invoke	UpdateWindow,hWnd
			mov	eax,hWnd
			ret
DisplayWindow		endp

; --------------- Process window messages
DoEvents		proc
			local	msg:MSG
StartLoop:		invoke	PeekMessage,addr msg, 0, 0, 0, PM_REMOVE
			test	eax,eax
			jz	NoMessages
			cmp	msg.message,WM_QUIT
			jne	WaitExit
			jmp	ExitLoop
WaitExit:		invoke	DispatchMessage,addr msg
			jmp	StartLoop
NoMessages:		;invoke	TSM_Play
			jmp	StartLoop
ExitLoop:		mov	eax,msg.wParam
			ret
DoEvents		endp

; -----------------
; --- WinMain() ---
; -----------------
WinMain			proc	hInstance:dword,hPrevInstance:dword,lpCmdLine:dword,nCmdShow:dword
			; Load the file into memory
			; S3M_LoadModule:
			; 	Module filename
			invoke	LoadFile,addr ModuleName,addr ReadBytes
			mov	ModuleMem,eax
			test	eax,eax
			jz	Err_LoadModule
			invoke	DisplayWindow,hInstance
			test	eax,eax
			jz	Err_InitModule
			;invoke	TSM_Init,addr ModuleName,eax
			;test	eax,eax
			;jz	Err_InitModule
			invoke	DoEvents
			ret
Err_InitModule:		invoke	GlobalFree,ModuleMem
			;invoke	TSM_Stop
Err_LoadModule:		xor	eax,eax
			ret
WinMain			endp

; ---------------------
; --- Program start ---
; ---------------------
start:			invoke	GetModuleHandle,NULL
			push	eax
			invoke	GetCommandLine
			pop	ebx
			invoke	WinMain,ebx,0,eax,SW_SHOWDEFAULT
			invoke	ExitProcess,eax

end start
