; --------------- Direct Sound definitions
STDMETHOD		MACRO	name,argl:VARARG
			LOCAL	@tmp_a
			LOCAL	@tmp_b
@tmp_a			TYPEDEF PROTO argl
@tmp_b			TYPEDEF PTR @tmp_a
			name	@tmp_b ?
			ENDM

DSINVOKE		MACRO	func,this,arglist:VARARG
			mov	eax,[this]
			mov	eax,[eax]
			IFB	<arglist>
				INVOKE	[IDirectSoundVtbl.func][eax],this
			ELSE
				INVOKE	[IDirectSoundVtbl.func][eax],this,arglist
			ENDIF
			ENDM

DSBINVOKE		MACRO	func,this,arglist:VARARG
			mov	eax,[this]
			mov	eax,[eax]
			IFB <arglist>
				INVOKE [IDirectSoundBufferVtbl.func][eax],this
			ELSE
				INVOKE [IDirectSoundBufferVtbl.func][eax],this,arglist
			ENDIF
			ENDM

DSNINVOKE		MACRO	func,this,arglist:VARARG
			mov	eax,[this]
			mov	eax,[eax]
			IFB <arglist>
				INVOKE [IDirectSoundNotifyVtbl.func][eax],this
			ELSE
				INVOKE [IDirectSoundNotifyVtbl.func][eax],this,arglist
			ENDIF
			ENDM

DSSCL_NORMAL		EQU	000000001h
DSSCL_EXCLUSIVE		EQU	000000003h
DSBCAPS_PRIMARYBUFFER	EQU	000000001h
DSBCAPS_GLOBALFOCUS	EQU	000008000h
DSBCAPS_CTRLPOSITIONNOTIFY EQU	000000100h
DSBCAPS_GETCURRENTPOSITION2 EQU	000010000h
DSBPLAY_LOOPING		EQU	000000001h
DSBSTATUS_BUFFERLOST	EQU	000000002h
DSBCAPS_STICKYFOCUS	EQU	000004000h

_DSBUFFERDESC		STRUCT	4
dwSize			DWORD	?
dwFlags			DWORD	?
dwBufferBytes		DWORD	?
dwReserved		DWORD	?
lpwfxFormat		DWORD	?
_DSBUFFERDESC		ENDS

_DSBPOSITIONNOTIFY	STRUCT	4
dwOffset		DWORD	?
hEventNotify		DWORD	?
_DSBPOSITIONNOTIFY	ENDS

PcmSound		STRUCT 
SndBuffer		dd	0	; the buffer for the sound 
SndState		dd	0	; state of the sound
SndRate			dd	0	; playback rate
SndLSize		dd	0	; size of sound
PcmSound		ENDS

DSBUFFERDESC		TYPEDEF	_DSBUFFERDESC
DSBPOSITIONNOTIFY	TYPEDEF	_DSBPOSITIONNOTIFY

IDirectSoundVtbl	STRUC
STDMETHOD		QueryInterface,:PTR IDirectSound,:PTR,:PTR PTR
STDMETHOD		AddRef,:PTR IDirectSound
STDMETHOD		Release,:PTR IDirectSound
STDMETHOD		CreateSoundBuffer,:PTR IDirectSound,:DWORD,:DWORD,:DWORD
STDMETHOD		GetCaps,:PTR IDirectSound,:DWORD
STDMETHOD		DuplicateSoundBuffer,:PTR IDirectSound,:DWORD,:DWORD
STDMETHOD		SetCooperativeLevel,:PTR IDirectSound,:DWORD,:DWORD
STDMETHOD		Compact,:PTR IDirectSound
STDMETHOD		GetSpeakerConfig,:PTR IDirectSound,:DWORD
STDMETHOD		SetSpeakerConfig,:PTR IDirectSound,:DWORD
STDMETHOD		Initialize,:PTR IDirectSound,:DWORD
IDirectSoundVtbl	ENDS

IDirectSoundBufferVtbl	STRUC
STDMETHOD		QueryInterface,:PTR IDirectSoundBuffer,:PTR,:PTR PTR
STDMETHOD		AddRef,:PTR IDirectSoundBuffer
STDMETHOD		Release,:PTR IDirectSoundBuffer
STDMETHOD		GetCaps,:PTR IDirectSoundBuffer,:DWORD
STDMETHOD		GetCurrentPosition,:PTR IDirectSoundBuffer,:DWORD,:DWORD
STDMETHOD		GetFormat,:PTR IDirectSoundBuffer,:DWORD,:DWORD,:DWORD
STDMETHOD		GetVolume,:PTR IDirectSoundBuffer,:DWORD
STDMETHOD		GetPan,:PTR IDirectSoundBuffer,:DWORD
STDMETHOD		GetFrequency,:PTR IDirectSoundBuffer,:DWORD
STDMETHOD		GetStatus,:PTR IDirectSoundBuffer,:DWORD
STDMETHOD		Initialize,:PTR IDirectSoundBuffer,:DWORD,:DWORD
STDMETHOD		mLock,:PTR IDirectSoundBuffer,:DWORD,:DWORD,:DWORD,:DWORD,:DWORD,:DWORD,:DWORD
STDMETHOD		Play,:PTR IDirectSoundBuffer,:DWORD,:DWORD,:DWORD
STDMETHOD		SetCurrentPosition,:PTR IDirectSoundBuffer,:DWORD
STDMETHOD		SetFormat,:PTR IDirectSoundBuffer,:DWORD
STDMETHOD		SetVolume,:PTR IDirectSoundBuffer,:DWORD
STDMETHOD		SetPan,:PTR IDirectSoundBuffer,:DWORD
STDMETHOD		SetFrequency,:PTR IDirectSoundBuffer,:DWORD
STDMETHOD		Stop,:PTR IDirectSoundBuffer
STDMETHOD		Unlock,:PTR IDirectSoundBuffer,:DWORD,:DWORD,:DWORD,:DWORD
STDMETHOD		Restore,:PTR IDirectSoundBuffer
IDirectSoundBufferVtbl	ENDS

IDirectSoundNotifyVtbl	STRUCT
STDMETHOD		QueryInterface,:DWORD,:DWORD,:DWORD
STDMETHOD		AddRef,:DWORD
STDMETHOD		Release,:DWORD
STDMETHOD		SetNotificationPositions,:DWORD,:DWORD,:DWORD
IDirectSoundNotifyVtbl	ENDS
