// --------------------------------------------------------------------
// TSM replay routine test

// --------------------------------------------------------------------
// Includes
#include <windows.h>

// --------------------------------------------------------------------
// Global Variables:
HINSTANCE hInst;
char *szTitle = "TRSI Sound Monitor replay routine.";
char *szWindowClass = "TSMReplay_Class";
HGLOBAL ModuleMem;
DWORD ReadBytes;
HWND hWnd;
HANDLE hReplayThread;
DWORD ThreadId;

char *ModuleName = "..\\..\\Songs\\wizardry.TSM";

// --------------------------------------------------------------------
// Forward declarations of functions included in this code module:
ATOM MyRegisterClass(HINSTANCE hInstance);
BOOL InitInstance(HINSTANCE, int);
LRESULT CALLBACK WndProc(HWND, UINT, WPARAM, LPARAM);
LRESULT CALLBACK About(HWND, UINT, WPARAM, LPARAM);
HGLOBAL LoadFile(char *FName, DWORD *FileReadBytes);
DWORD WINAPI Synth_Thread(LPVOID lpParameter);
void __stdcall CallBack_Routine(int Datas);

// --------------------------------------------------------------------
// Extern functions for TSM replay routine
#ifdef __cplusplus
	extern "C" {
#endif
int __stdcall TSM_Init(HGLOBAL ModuleMem, HWND hWnd, void (__stdcall *CallBack)(int Datas));
int __stdcall TSM_Play(void);
int __stdcall TSM_Stop(void);
#ifdef __cplusplus
	}
#endif

// --------------------------------------------------------------------
// Program entry point
int APIENTRY WinMain(HINSTANCE hInstance, HINSTANCE hPrevInstance, LPSTR lpCmdLine, int nCmdShow) {
	MSG msg;

	MyRegisterClass(hInstance);
	// Perform application initialization:
	if(!InitInstance(hInstance, nCmdShow)) return(FALSE);

	ModuleMem = LoadFile(ModuleName, &ReadBytes);
	if(ModuleMem) {
		// Init replay
		if(TSM_Init(ModuleMem, hWnd, &CallBack_Routine)) {
			hReplayThread = CreateThread(NULL, 0, &Synth_Thread, 0, 0, &ThreadId);

			while(GetMessage(&msg, NULL, 0, 0)) {
				Sleep(1);
				DispatchMessage(&msg);
			}
		} else {
			// Stop replay
			TSM_Stop();
			GlobalFree(ModuleMem);
		}
	}
	return(msg.wParam);
}

// --------------------------------------------------------------------
// Registers the window class.
ATOM MyRegisterClass(HINSTANCE hInstance) {
	WNDCLASSEX wcex;
	wcex.cbSize = sizeof(WNDCLASSEX); 
	wcex.style = CS_HREDRAW | CS_VREDRAW;
	wcex.lpfnWndProc = (WNDPROC)WndProc;
	wcex.cbClsExtra = 0;
	wcex.cbWndExtra	= 0;
	wcex.hInstance = hInstance;
	wcex.hIcon = NULL;
	wcex.hCursor = LoadCursor(NULL, IDC_ARROW);
	wcex.hbrBackground = (HBRUSH) (COLOR_WINDOW + 1);
	wcex.lpszMenuName = NULL;
	wcex.lpszClassName = szWindowClass;
	wcex.hIconSm = NULL;
	return(RegisterClassEx(&wcex));
}

// --------------------------------------------------------------------
// Saves instance handle and creates main window
BOOL InitInstance(HINSTANCE hInstance, int nCmdShow) {
   hInst = hInstance; // Store instance handle in our global variable
   hWnd = CreateWindow(szWindowClass, szTitle, WS_BORDER | WS_CAPTION | WS_SYSMENU, 100, 100, 400, 100, NULL, NULL, hInstance, NULL);
   if(!hWnd) return(FALSE);
   ShowWindow(hWnd, nCmdShow);
   UpdateWindow(hWnd);
   return(TRUE);
}

// --------------------------------------------------------------------
// Processes messages for the main window.
LRESULT CALLBACK WndProc(HWND hWnd, UINT message, WPARAM wParam, LPARAM lParam) {
	switch(message) {
		case WM_DESTROY:
			if(hReplayThread) {
				TerminateThread(hReplayThread, 0);
				CloseHandle(hReplayThread);
			}
			TSM_Stop();
			GlobalFree(ModuleMem);
			PostQuitMessage(0);
			break;
		default:
			return(DefWindowProc(hWnd, message, wParam, lParam));
   }
   return(0);
}

// --------------------------------------------------------------------
// Open a file and load it into a memory block
// Returns the allocated memory block or 0
// (Free memory block with GlobalFree)
HGLOBAL LoadFile(char *FName, DWORD *FileReadBytes) {
	HANDLE FHandle;
	DWORD FSize;
	HGLOBAL FPosition = 0;

	FHandle = CreateFile(FName, GENERIC_READ, 0, 0, OPEN_EXISTING, FILE_FLAG_SEQUENTIAL_SCAN, 0);
	if(FHandle != INVALID_HANDLE_VALUE) {
		FSize = GetFileSize(FHandle, NULL);
		if(FSize) {
			FSize++;
			FPosition = GlobalAlloc(GMEM_FIXED | GMEM_ZEROINIT, FSize);
			if(FPosition) ReadFile(FHandle, FPosition, FSize, FileReadBytes, NULL);
			CloseHandle(FHandle);
		}
	}
	return(FPosition);
}

// ------------------------------------------------------
// Name: Synth_Thread()
// Desc: Audio rendering
DWORD WINAPI Synth_Thread(LPVOID lpParameter) {
	for(;;) {
		TSM_Play();
		Sleep(1);
	}
	return(FALSE);
}

// --------------------------------------------------------------------
// Callback routine for synchro command (B) purposes
void __stdcall CallBack_Routine(int Datas) {

}