/*
 * frmNewInstrFrame.java
 *
 * 
 */

package symreader;
import javax.swing.JColorChooser;
import symreader.SymReaderView.UIManager;
import java.awt.Graphics;
import java.awt.Color;
import java.text.NumberFormat;

/**
 *
 * @author (c) Patrick Meng 2008
 */


public class frmNewInstrFrame extends javax.swing.JFrame {
    
    /** Creates new form frmNewInstrFrame */
    public frmNewInstrFrame() {
	initComponents();
    }
    
    
    @Override
    public void paint(Graphics g) {
	super.paint(g);
	redrawSampleFrame();
    }



    
    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {
        bindingGroup = new org.jdesktop.beansbinding.BindingGroup();

        jColorChooser = new javax.swing.JColorChooser();
        jToolBar1 = new javax.swing.JToolBar();
        InstrDetLoadSample = new javax.swing.JButton();
        jButton1 = new javax.swing.JButton();
        InstrDetExportRawSample = new javax.swing.JButton();
        jButton2 = new javax.swing.JButton();
        InstrDetSampleView = new javax.swing.JLayeredPane();
        InstrDetLoopText = new javax.swing.JLabel();
        jTabbedPane1 = new javax.swing.JTabbedPane();
        jPanel1 = new javax.swing.JPanel();
        lblInstrNr = new javax.swing.JLabel();
        lblInstrNr1 = new javax.swing.JLabel();
        lblInstrNr2 = new javax.swing.JLabel();
        lblInstrNr3 = new javax.swing.JLabel();
        InstrDetLoopStart = new javax.swing.JSpinner();
        InstrDetTune = new javax.swing.JSpinner();
        InstrDetVolume = new javax.swing.JSpinner();
        InstrDetNrNew = new javax.swing.JSpinner();
        InstrDetStereoType = new javax.swing.JComboBox();
        InstrDetSampleResolution = new javax.swing.JTextField();
        InstrDetFormat = new javax.swing.JTextField();
        InstrDetTxt = new javax.swing.JTextField();
        InstrDetFineTune = new javax.swing.JSpinner();
        InstrDetLoopLen = new javax.swing.JSpinner();
        jLabel2 = new javax.swing.JLabel();
        jLabel1 = new javax.swing.JLabel();
        InstrNoDetune = new javax.swing.JCheckBox();
        InstrDetMouseRelTxt = new javax.swing.JLabel();
        InstrDetSyncPlay = new javax.swing.JCheckBox();
        InstrDetNoDsp = new javax.swing.JCheckBox();
        InstrDetID = new javax.swing.JLabel();
        InstrDetViewFormat = new javax.swing.JComboBox();
        InstrDetTwoWayLoop = new javax.swing.JCheckBox();
        jPanel2 = new javax.swing.JPanel();
        InstrDetPanningEnable = new javax.swing.JCheckBox();
        jLabel3 = new javax.swing.JLabel();
        InstrDetPanorama = new javax.swing.JSpinner();
        InstrDetPanSlider = new javax.swing.JSlider();
        MetaPanel = new javax.swing.JPanel();
        MetaMainLead = new javax.swing.JCheckBox();
        MetaLead2 = new javax.swing.JCheckBox();
        MetaPercussion = new javax.swing.JCheckBox();
        MetaBeat = new javax.swing.JCheckBox();
        MetaSubBeat = new javax.swing.JCheckBox();
        MetaColor = new javax.swing.JPanel();
        jButton3 = new javax.swing.JButton();

        jColorChooser.setName("jColorChooser"); // NOI18N

        org.jdesktop.application.ResourceMap resourceMap = org.jdesktop.application.Application.getInstance(symreader.SymReaderApp.class).getContext().getResourceMap(frmNewInstrFrame.class);
        setTitle(resourceMap.getString("Form.title")); // NOI18N
        setName("Form"); // NOI18N
        addWindowFocusListener(new java.awt.event.WindowFocusListener() {
            public void windowGainedFocus(java.awt.event.WindowEvent evt) {
                formWindowGainedFocus(evt);
            }
            public void windowLostFocus(java.awt.event.WindowEvent evt) {
            }
        });
        addComponentListener(new java.awt.event.ComponentAdapter() {
            public void componentShown(java.awt.event.ComponentEvent evt) {
                formComponentShown(evt);
            }
        });
        addFocusListener(new java.awt.event.FocusAdapter() {
            public void focusGained(java.awt.event.FocusEvent evt) {
                formFocusGained(evt);
            }
        });

        jToolBar1.setFloatable(false);
        jToolBar1.setRollover(true);
        jToolBar1.setName("jToolBar1"); // NOI18N

        InstrDetLoadSample.setFont(resourceMap.getFont("InstrDetLoadSample.font")); // NOI18N
        InstrDetLoadSample.setText(resourceMap.getString("InstrDetLoadSample.text")); // NOI18N
        InstrDetLoadSample.setBorder(new javax.swing.border.SoftBevelBorder(javax.swing.border.BevelBorder.RAISED));
        InstrDetLoadSample.setFocusable(false);
        InstrDetLoadSample.setHorizontalTextPosition(javax.swing.SwingConstants.CENTER);
        InstrDetLoadSample.setName("InstrDetLoadSample"); // NOI18N
        InstrDetLoadSample.setVerticalTextPosition(javax.swing.SwingConstants.BOTTOM);
        InstrDetLoadSample.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                InstrDetLoadSampleActionPerformed(evt);
            }
        });
        jToolBar1.add(InstrDetLoadSample);

        jButton1.setText(resourceMap.getString("jButton1.text")); // NOI18N
        jButton1.setBorder(new javax.swing.border.SoftBevelBorder(javax.swing.border.BevelBorder.RAISED));
        jButton1.setFocusable(false);
        jButton1.setHorizontalTextPosition(javax.swing.SwingConstants.CENTER);
        jButton1.setName("jButton1"); // NOI18N
        jButton1.setVerticalTextPosition(javax.swing.SwingConstants.BOTTOM);
        jButton1.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jButton1ActionPerformed(evt);
            }
        });
        jToolBar1.add(jButton1);

        InstrDetExportRawSample.setFont(resourceMap.getFont("InstrDetExportRawSample.font")); // NOI18N
        InstrDetExportRawSample.setText(resourceMap.getString("InstrDetExportRawSample.text")); // NOI18N
        InstrDetExportRawSample.setBorder(new javax.swing.border.SoftBevelBorder(javax.swing.border.BevelBorder.RAISED));
        InstrDetExportRawSample.setFocusable(false);
        InstrDetExportRawSample.setHorizontalTextPosition(javax.swing.SwingConstants.CENTER);
        InstrDetExportRawSample.setName("InstrDetExportRawSample"); // NOI18N
        InstrDetExportRawSample.setVerticalTextPosition(javax.swing.SwingConstants.BOTTOM);
        InstrDetExportRawSample.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                InstrDetExportRawSampleActionPerformed(evt);
            }
        });
        jToolBar1.add(InstrDetExportRawSample);

        jButton2.setText(resourceMap.getString("jButton2.text")); // NOI18N
        jButton2.setBorder(new javax.swing.border.SoftBevelBorder(javax.swing.border.BevelBorder.RAISED));
        jButton2.setFocusable(false);
        jButton2.setHorizontalTextPosition(javax.swing.SwingConstants.CENTER);
        jButton2.setName("jButton2"); // NOI18N
        jButton2.setVerticalTextPosition(javax.swing.SwingConstants.BOTTOM);
        jButton2.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jButton2ActionPerformed(evt);
            }
        });
        jToolBar1.add(jButton2);

        InstrDetSampleView.setBackground(resourceMap.getColor("InstrDetSampleView.background")); // NOI18N
        InstrDetSampleView.setBorder(javax.swing.BorderFactory.createEtchedBorder());
        InstrDetSampleView.setDoubleBuffered(true);
        InstrDetSampleView.setName("InstrDetSampleView"); // NOI18N
        InstrDetSampleView.addComponentListener(new java.awt.event.ComponentAdapter() {
            public void componentResized(java.awt.event.ComponentEvent evt) {
                InstrDetSampleViewComponentResized(evt);
            }
        });
        InstrDetSampleView.addMouseMotionListener(new java.awt.event.MouseMotionAdapter() {
            public void mouseMoved(java.awt.event.MouseEvent evt) {
                InstrDetSampleViewMouseMoved(evt);
            }
        });

        InstrDetLoopText.setForeground(resourceMap.getColor("InstrDetLoopText.foreground")); // NOI18N
        InstrDetLoopText.setText(resourceMap.getString("InstrDetLoopText.text")); // NOI18N
        InstrDetLoopText.setName("InstrDetLoopText"); // NOI18N
        InstrDetLoopText.setBounds(10, 10, 130, -1);
        InstrDetSampleView.add(InstrDetLoopText, javax.swing.JLayeredPane.DEFAULT_LAYER);

        jTabbedPane1.setToolTipText(resourceMap.getString("jTabbedPane1.toolTipText")); // NOI18N
        jTabbedPane1.setName("jTabbedPane1"); // NOI18N

        jPanel1.setName("jPanel1"); // NOI18N

        lblInstrNr.setText(resourceMap.getString("lblInstrNr.text")); // NOI18N
        lblInstrNr.setName("lblInstrNr"); // NOI18N

        lblInstrNr1.setText(resourceMap.getString("lblInstrNr1.text")); // NOI18N
        lblInstrNr1.setName("lblInstrNr1"); // NOI18N

        lblInstrNr2.setText(resourceMap.getString("lblInstrNr2.text")); // NOI18N
        lblInstrNr2.setName("lblInstrNr2"); // NOI18N

        lblInstrNr3.setText(resourceMap.getString("lblInstrNr3.text")); // NOI18N
        lblInstrNr3.setName("lblInstrNr3"); // NOI18N

        InstrDetLoopStart.setName("InstrDetLoopStart"); // NOI18N
        InstrDetLoopStart.addChangeListener(new javax.swing.event.ChangeListener() {
            public void stateChanged(javax.swing.event.ChangeEvent evt) {
                InstrDetLoopStartStateChanged(evt);
            }
        });

        InstrDetTune.setName("InstrDetTune"); // NOI18N
        InstrDetTune.addChangeListener(new javax.swing.event.ChangeListener() {
            public void stateChanged(javax.swing.event.ChangeEvent evt) {
                InstrDetTuneStateChanged(evt);
            }
        });

        InstrDetVolume.setName("InstrDetVolume"); // NOI18N
        InstrDetVolume.addChangeListener(new javax.swing.event.ChangeListener() {
            public void stateChanged(javax.swing.event.ChangeEvent evt) {
                InstrDetVolumeStateChanged(evt);
            }
        });

        InstrDetNrNew.setName("InstrDetNrNew"); // NOI18N
        InstrDetNrNew.addChangeListener(new javax.swing.event.ChangeListener() {
            public void stateChanged(javax.swing.event.ChangeEvent evt) {
                InstrDetNrNewStateChanged(evt);
            }
        });

        InstrDetStereoType.setModel(new javax.swing.DefaultComboBoxModel(new String[] { "Mono", "Stereo L", "Stereo R", "Virtual Mix" }));
        InstrDetStereoType.setEnabled(false);
        InstrDetStereoType.setFocusable(false);
        InstrDetStereoType.setName("InstrDetStereoType"); // NOI18N

        InstrDetSampleResolution.setEditable(false);
        InstrDetSampleResolution.setText(resourceMap.getString("InstrDetSampleResolution.text")); // NOI18N
        InstrDetSampleResolution.setBorder(javax.swing.BorderFactory.createEtchedBorder());
        InstrDetSampleResolution.setName("InstrDetSampleResolution"); // NOI18N

        InstrDetFormat.setEditable(false);
        InstrDetFormat.setBorder(javax.swing.BorderFactory.createEtchedBorder());
        InstrDetFormat.setName("InstrDetFormat"); // NOI18N

        InstrDetTxt.setEditable(false);
        InstrDetTxt.setFont(resourceMap.getFont("InstrDetTxt.font")); // NOI18N
        InstrDetTxt.setBorder(javax.swing.BorderFactory.createEtchedBorder());
        InstrDetTxt.setName("InstrDetTxt"); // NOI18N

        InstrDetFineTune.setName("InstrDetFineTune"); // NOI18N
        InstrDetFineTune.addChangeListener(new javax.swing.event.ChangeListener() {
            public void stateChanged(javax.swing.event.ChangeEvent evt) {
                InstrDetFineTuneStateChanged(evt);
            }
        });

        InstrDetLoopLen.setName("InstrDetLoopLen"); // NOI18N
        InstrDetLoopLen.addChangeListener(new javax.swing.event.ChangeListener() {
            public void stateChanged(javax.swing.event.ChangeEvent evt) {
                InstrDetLoopLenStateChanged(evt);
            }
        });

        jLabel2.setText(resourceMap.getString("jLabel2.text")); // NOI18N
        jLabel2.setName("jLabel2"); // NOI18N

        jLabel1.setText(resourceMap.getString("jLabel1.text")); // NOI18N
        jLabel1.setName("jLabel1"); // NOI18N

        InstrNoDetune.setText(resourceMap.getString("InstrNoDetune.text")); // NOI18N
        InstrNoDetune.setName("InstrNoDetune"); // NOI18N

        InstrDetMouseRelTxt.setText(resourceMap.getString("InstrDetMouseRelTxt.text")); // NOI18N
        InstrDetMouseRelTxt.setName("InstrDetMouseRelTxt"); // NOI18N

        InstrDetSyncPlay.setText(resourceMap.getString("InstrDetSyncPlay.text")); // NOI18N
        InstrDetSyncPlay.setEnabled(false);
        InstrDetSyncPlay.setName("InstrDetSyncPlay"); // NOI18N

        InstrDetNoDsp.setText(resourceMap.getString("InstrDetNoDsp.text")); // NOI18N
        InstrDetNoDsp.setName("InstrDetNoDsp"); // NOI18N
        InstrDetNoDsp.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                InstrDetNoDspActionPerformed(evt);
            }
        });

        InstrDetID.setFont(resourceMap.getFont("InstrDetID.font")); // NOI18N
        InstrDetID.setText(resourceMap.getString("InstrDetID.text")); // NOI18N
        InstrDetID.setName("InstrDetID"); // NOI18N

        InstrDetViewFormat.setModel(new javax.swing.DefaultComboBoxModel(new String[] { "Lines", "Pixel", "Pixel Fast", "Filled" }));
        InstrDetViewFormat.setName("InstrDetViewFormat"); // NOI18N
        InstrDetViewFormat.addItemListener(new java.awt.event.ItemListener() {
            public void itemStateChanged(java.awt.event.ItemEvent evt) {
                InstrDetViewFormatItemStateChanged(evt);
            }
        });

        InstrDetTwoWayLoop.setText(resourceMap.getString("InstrDetTwoWayLoop.text")); // NOI18N
        InstrDetTwoWayLoop.setName("InstrDetTwoWayLoop"); // NOI18N
        InstrDetTwoWayLoop.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                InstrDetTwoWayLoopActionPerformed(evt);
            }
        });

        javax.swing.GroupLayout jPanel1Layout = new javax.swing.GroupLayout(jPanel1);
        jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(
            jPanel1Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(jPanel1Layout.createSequentialGroup()
                .addGroup(jPanel1Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addGroup(jPanel1Layout.createSequentialGroup()
                        .addContainerGap()
                        .addComponent(lblInstrNr3)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED, 412, Short.MAX_VALUE))
                    .addGroup(jPanel1Layout.createSequentialGroup()
                        .addGap(222, 222, 222)
                        .addComponent(InstrNoDetune, javax.swing.GroupLayout.PREFERRED_SIZE, 121, javax.swing.GroupLayout.PREFERRED_SIZE)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addComponent(InstrDetMouseRelTxt, javax.swing.GroupLayout.PREFERRED_SIZE, 77, javax.swing.GroupLayout.PREFERRED_SIZE))
                    .addGroup(jPanel1Layout.createSequentialGroup()
                        .addContainerGap()
                        .addGroup(jPanel1Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                            .addComponent(lblInstrNr)
                            .addComponent(lblInstrNr1)
                            .addComponent(lblInstrNr2))
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addGroup(jPanel1Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                            .addComponent(InstrDetTune, javax.swing.GroupLayout.PREFERRED_SIZE, 55, javax.swing.GroupLayout.PREFERRED_SIZE)
                            .addGroup(jPanel1Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING, false)
                                .addComponent(InstrDetVolume, javax.swing.GroupLayout.DEFAULT_SIZE, 61, Short.MAX_VALUE)
                                .addComponent(InstrDetNrNew, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                            .addComponent(InstrDetLoopStart, javax.swing.GroupLayout.PREFERRED_SIZE, 55, javax.swing.GroupLayout.PREFERRED_SIZE))
                        .addGroup(jPanel1Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                            .addGroup(jPanel1Layout.createSequentialGroup()
                                .addGap(4, 4, 4)
                                .addGroup(jPanel1Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                                    .addComponent(jLabel1)
                                    .addComponent(jLabel2)
                                    .addComponent(InstrDetStereoType, javax.swing.GroupLayout.PREFERRED_SIZE, 74, javax.swing.GroupLayout.PREFERRED_SIZE))
                                .addGap(10, 10, 10)
                                .addGroup(jPanel1Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                                    .addGroup(jPanel1Layout.createSequentialGroup()
                                        .addComponent(InstrDetSampleResolution, javax.swing.GroupLayout.PREFERRED_SIZE, 30, javax.swing.GroupLayout.PREFERRED_SIZE)
                                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                                        .addComponent(InstrDetFormat, javax.swing.GroupLayout.DEFAULT_SIZE, 179, Short.MAX_VALUE))
                                    .addComponent(InstrDetFineTune, javax.swing.GroupLayout.PREFERRED_SIZE, 55, javax.swing.GroupLayout.PREFERRED_SIZE)
                                    .addGroup(jPanel1Layout.createSequentialGroup()
                                        .addComponent(InstrDetLoopLen, javax.swing.GroupLayout.PREFERRED_SIZE, 55, javax.swing.GroupLayout.PREFERRED_SIZE)
                                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED, 83, Short.MAX_VALUE)
                                        .addComponent(InstrDetViewFormat, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)))
                                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED))
                            .addGroup(jPanel1Layout.createSequentialGroup()
                                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                                .addComponent(InstrDetID, javax.swing.GroupLayout.PREFERRED_SIZE, 31, javax.swing.GroupLayout.PREFERRED_SIZE)
                                .addGap(33, 33, 33)
                                .addComponent(InstrDetTxt, javax.swing.GroupLayout.DEFAULT_SIZE, 235, Short.MAX_VALUE))))
                    .addGroup(jPanel1Layout.createSequentialGroup()
                        .addComponent(InstrDetNoDsp)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addComponent(InstrDetSyncPlay)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addComponent(InstrDetTwoWayLoop)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)))
                .addContainerGap())
        );

        jPanel1Layout.linkSize(javax.swing.SwingConstants.HORIZONTAL, new java.awt.Component[] {InstrDetFineTune, InstrDetLoopLen, InstrDetLoopStart, InstrDetNrNew, InstrDetTune, InstrDetVolume});

        jPanel1Layout.setVerticalGroup(
            jPanel1Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(jPanel1Layout.createSequentialGroup()
                .addContainerGap()
                .addGroup(jPanel1Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.CENTER)
                    .addComponent(lblInstrNr)
                    .addComponent(InstrDetNrNew, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                    .addComponent(InstrDetTxt, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                    .addComponent(InstrDetID))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addGroup(jPanel1Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addGroup(jPanel1Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.CENTER, false)
                        .addComponent(InstrDetVolume, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                        .addComponent(InstrDetStereoType, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                        .addComponent(InstrDetSampleResolution, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                        .addComponent(lblInstrNr1))
                    .addComponent(InstrDetFormat, javax.swing.GroupLayout.PREFERRED_SIZE, 22, javax.swing.GroupLayout.PREFERRED_SIZE))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addGroup(jPanel1Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(lblInstrNr2)
                    .addComponent(InstrDetTune, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                    .addComponent(jLabel1)
                    .addComponent(InstrDetFineTune, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addGroup(jPanel1Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(lblInstrNr3)
                    .addComponent(InstrDetLoopStart, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                    .addComponent(jLabel2)
                    .addComponent(InstrDetLoopLen, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                    .addComponent(InstrDetViewFormat, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                .addGap(18, 18, 18)
                .addGroup(jPanel1Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(InstrDetNoDsp)
                    .addComponent(InstrDetSyncPlay)
                    .addComponent(InstrNoDetune)
                    .addComponent(InstrDetMouseRelTxt)
                    .addComponent(InstrDetTwoWayLoop))
                .addContainerGap(javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
        );

        jTabbedPane1.addTab(resourceMap.getString("jPanel1.TabConstraints.tabTitle"), jPanel1); // NOI18N

        jPanel2.setName("jPanel2"); // NOI18N

        InstrDetPanningEnable.setText(resourceMap.getString("InstrDetPanningEnable.text")); // NOI18N
        InstrDetPanningEnable.setEnabled(false);
        InstrDetPanningEnable.setName("InstrDetPanningEnable"); // NOI18N
        InstrDetPanningEnable.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                InstrDetPanningEnableActionPerformed(evt);
            }
        });

        jLabel3.setText(resourceMap.getString("jLabel3.text")); // NOI18N
        jLabel3.setToolTipText(resourceMap.getString("jLabel3.toolTipText")); // NOI18N
        jLabel3.setName("jLabel3"); // NOI18N

        InstrDetPanorama.setEnabled(false);
        InstrDetPanorama.setName("InstrDetPanorama"); // NOI18N

        org.jdesktop.beansbinding.Binding binding = org.jdesktop.beansbinding.Bindings.createAutoBinding(org.jdesktop.beansbinding.AutoBinding.UpdateStrategy.READ_WRITE, InstrDetPanSlider, org.jdesktop.beansbinding.ELProperty.create("${value}"), InstrDetPanorama, org.jdesktop.beansbinding.BeanProperty.create("value"));
        bindingGroup.addBinding(binding);

        InstrDetPanorama.addChangeListener(new javax.swing.event.ChangeListener() {
            public void stateChanged(javax.swing.event.ChangeEvent evt) {
                InstrDetPanoramaStateChanged(evt);
            }
        });

        InstrDetPanSlider.setMajorTickSpacing(200);
        InstrDetPanSlider.setMaximum(1000);
        InstrDetPanSlider.setMinimum(-1000);
        InstrDetPanSlider.setMinorTickSpacing(50);
        InstrDetPanSlider.setPaintTicks(true);
        InstrDetPanSlider.setToolTipText(resourceMap.getString("InstrDetPanSlider.toolTipText")); // NOI18N
        InstrDetPanSlider.setValue(0);
        InstrDetPanSlider.setEnabled(false);
        InstrDetPanSlider.setName("InstrDetPanSlider"); // NOI18N

        javax.swing.GroupLayout jPanel2Layout = new javax.swing.GroupLayout(jPanel2);
        jPanel2.setLayout(jPanel2Layout);
        jPanel2Layout.setHorizontalGroup(
            jPanel2Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(jPanel2Layout.createSequentialGroup()
                .addContainerGap()
                .addGroup(jPanel2Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addComponent(InstrDetPanningEnable)
                    .addGroup(jPanel2Layout.createSequentialGroup()
                        .addComponent(jLabel3)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addComponent(InstrDetPanorama, javax.swing.GroupLayout.PREFERRED_SIZE, 51, javax.swing.GroupLayout.PREFERRED_SIZE)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addComponent(InstrDetPanSlider, javax.swing.GroupLayout.DEFAULT_SIZE, 301, Short.MAX_VALUE)))
                .addContainerGap())
        );
        jPanel2Layout.setVerticalGroup(
            jPanel2Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(jPanel2Layout.createSequentialGroup()
                .addContainerGap()
                .addComponent(InstrDetPanningEnable)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addGroup(jPanel2Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.CENTER)
                    .addComponent(jLabel3)
                    .addComponent(InstrDetPanorama, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                    .addComponent(InstrDetPanSlider, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                .addContainerGap(89, Short.MAX_VALUE))
        );

        jTabbedPane1.addTab(resourceMap.getString("jPanel2.TabConstraints.tabTitle"), jPanel2); // NOI18N

        MetaPanel.setName("MetaPanel"); // NOI18N

        MetaMainLead.setText(resourceMap.getString("MetaMainLead.text")); // NOI18N
        MetaMainLead.setToolTipText(resourceMap.getString("MetaMainLead.toolTipText")); // NOI18N
        MetaMainLead.setName("MetaMainLead"); // NOI18N
        MetaMainLead.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                MetaMainLeadActionPerformed(evt);
            }
        });

        MetaLead2.setText(resourceMap.getString("MetaLead2.text")); // NOI18N
        MetaLead2.setToolTipText(resourceMap.getString("MetaLead2.toolTipText")); // NOI18N
        MetaLead2.setName("MetaLead2"); // NOI18N
        MetaLead2.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                MetaLead2ActionPerformed(evt);
            }
        });

        MetaPercussion.setText(resourceMap.getString("MetaPercussion.text")); // NOI18N
        MetaPercussion.setToolTipText(resourceMap.getString("MetaPercussion.toolTipText")); // NOI18N
        MetaPercussion.setName("MetaPercussion"); // NOI18N
        MetaPercussion.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                MetaPercussionActionPerformed(evt);
            }
        });

        MetaBeat.setText(resourceMap.getString("MetaBeat.text")); // NOI18N
        MetaBeat.setToolTipText(resourceMap.getString("MetaBeat.toolTipText")); // NOI18N
        MetaBeat.setName("MetaBeat"); // NOI18N
        MetaBeat.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                MetaBeatActionPerformed(evt);
            }
        });

        MetaSubBeat.setText(resourceMap.getString("MetaSubBeat.text")); // NOI18N
        MetaSubBeat.setToolTipText(resourceMap.getString("MetaSubBeat.toolTipText")); // NOI18N
        MetaSubBeat.setName("MetaSubBeat"); // NOI18N
        MetaSubBeat.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                MetaSubBeatActionPerformed(evt);
            }
        });

        MetaColor.setBackground(resourceMap.getColor("MetaColor.background")); // NOI18N
        MetaColor.setBorder(javax.swing.BorderFactory.createEtchedBorder());
        MetaColor.setName("MetaColor"); // NOI18N

        jButton3.setText(resourceMap.getString("jButton3.text")); // NOI18N
        jButton3.setName("jButton3"); // NOI18N
        jButton3.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jButton3ActionPerformed(evt);
            }
        });

        javax.swing.GroupLayout MetaColorLayout = new javax.swing.GroupLayout(MetaColor);
        MetaColor.setLayout(MetaColorLayout);
        MetaColorLayout.setHorizontalGroup(
            MetaColorLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(MetaColorLayout.createSequentialGroup()
                .addComponent(jButton3)
                .addContainerGap(23, Short.MAX_VALUE))
        );
        MetaColorLayout.setVerticalGroup(
            MetaColorLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addComponent(jButton3, javax.swing.GroupLayout.PREFERRED_SIZE, 18, Short.MAX_VALUE)
        );

        javax.swing.GroupLayout MetaPanelLayout = new javax.swing.GroupLayout(MetaPanel);
        MetaPanel.setLayout(MetaPanelLayout);
        MetaPanelLayout.setHorizontalGroup(
            MetaPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(MetaPanelLayout.createSequentialGroup()
                .addComponent(MetaMainLead)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(MetaLead2)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(MetaPercussion)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.UNRELATED)
                .addComponent(MetaBeat)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.UNRELATED)
                .addComponent(MetaSubBeat)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(MetaColor, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addContainerGap(javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
        );
        MetaPanelLayout.setVerticalGroup(
            MetaPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(MetaPanelLayout.createSequentialGroup()
                .addGroup(MetaPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addGroup(MetaPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                        .addComponent(MetaMainLead)
                        .addComponent(MetaLead2)
                        .addComponent(MetaPercussion)
                        .addComponent(MetaBeat)
                        .addComponent(MetaSubBeat))
                    .addComponent(MetaColor, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                .addContainerGap(131, Short.MAX_VALUE))
        );

        jTabbedPane1.addTab(resourceMap.getString("MetaPanel.TabConstraints.tabTitle"), MetaPanel); // NOI18N

        javax.swing.GroupLayout layout = new javax.swing.GroupLayout(getContentPane());
        getContentPane().setLayout(layout);
        layout.setHorizontalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addComponent(jTabbedPane1, javax.swing.GroupLayout.Alignment.TRAILING)
            .addComponent(InstrDetSampleView, javax.swing.GroupLayout.DEFAULT_SIZE, 450, Short.MAX_VALUE)
            .addComponent(jToolBar1, javax.swing.GroupLayout.DEFAULT_SIZE, 450, Short.MAX_VALUE)
        );
        layout.setVerticalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(layout.createSequentialGroup()
                .addComponent(jToolBar1, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(jTabbedPane1, javax.swing.GroupLayout.PREFERRED_SIZE, 182, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(InstrDetSampleView, javax.swing.GroupLayout.DEFAULT_SIZE, 130, Short.MAX_VALUE))
        );

        jTabbedPane1.getAccessibleContext().setAccessibleName(resourceMap.getString("jTabbedPane1.AccessibleContext.accessibleName")); // NOI18N

        bindingGroup.bind();

        pack();
    }// </editor-fold>//GEN-END:initComponents

    private void InstrDetLoadSampleActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_InstrDetLoadSampleActionPerformed
	// TODO add your handling code here:
	SymphManager.LoadSample(); //  LoadNewSample(true);
    }//GEN-LAST:event_InstrDetLoadSampleActionPerformed

    private void jButton1ActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButton1ActionPerformed
	// TODO add your handling code here:
	int ID1, ID2;
	int i = SymphManager.getActualInstrumentIndex();
	
	// backup IDs
	ID1 = SymphManager.SymSong.getIDofInstrumentIndex(i);
	ID2 = SymphManager.SymSong.getIDofInstrumentIndex(i+1);
	
	SymphManager.removeInstrumentIndex(i);
	SymphManager.LoadSample();
	
	// restore IDs
	SymphManager.SymSong.setIDofInstrumentIndex(i,ID1);
	SymphManager.SymSong.setIDofInstrumentIndex(i+1,ID2);
	
	SymphManager.refreshInstrumentList();
	UpdateActualInstrDetails();
    }//GEN-LAST:event_jButton1ActionPerformed

    private void InstrDetExportRawSampleActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_InstrDetExportRawSampleActionPerformed
//	ExportInstrumentSampleRaw();
	// TODO add your handling code here:
    }//GEN-LAST:event_InstrDetExportRawSampleActionPerformed

    private void jButton2ActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButton2ActionPerformed
	// TODO add your handling code here:
	int i = SymphManager.getActualInstrumentIndex();
	SymphManager.removeInstrumentIndex(i);
	SymphManager.refreshInstrumentList();
	UpdateActualInstrDetails();
    }//GEN-LAST:event_jButton2ActionPerformed

    private void InstrDetFineTuneStateChanged(javax.swing.event.ChangeEvent evt) {//GEN-FIRST:event_InstrDetFineTuneStateChanged
	// TODO add your handling code here:
	SymphManager.checkSpinnerLimits(InstrDetFineTune, -128, 127, true);
	SymphManager.getActualInstrument().FineTune = SymphManager.getSpinnerValue(InstrDetFineTune);
    }//GEN-LAST:event_InstrDetFineTuneStateChanged

    private void InstrDetNoDspActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_InstrDetNoDspActionPerformed
	// TODO add your handling code here:
	SymphManager.getActualInstrument().NoDsp = InstrDetNoDsp.isSelected();
    }//GEN-LAST:event_InstrDetNoDspActionPerformed

    private void InstrDetViewFormatItemStateChanged(java.awt.event.ItemEvent evt) {//GEN-FIRST:event_InstrDetViewFormatItemStateChanged
	UpdateActualInstrDetails();
	// TODO add your handling code here:
    }//GEN-LAST:event_InstrDetViewFormatItemStateChanged

    private void InstrDetSampleViewMouseMoved(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_InstrDetSampleViewMouseMoved
	// TODO add your handling code here:
	SampleShowMousePosition(evt.getX());
    }//GEN-LAST:event_InstrDetSampleViewMouseMoved

private void InstrDetVolumeStateChanged(javax.swing.event.ChangeEvent evt) {//GEN-FIRST:event_InstrDetVolumeStateChanged
// TODO add your handling code here:
    	SymphonieInstrument si = SymphManager.getActualInstrument();
	if(si != null) {
	    si.Volume = SymphManager.checkSpinnerLimits(InstrDetVolume, 0, 300, true);
	    //InstrDetVolume.setValue( SymphManager.checkSpinnerLimits(InstrDetVolume, 0, 300));
	}
}//GEN-LAST:event_InstrDetVolumeStateChanged

private void InstrDetNrNewStateChanged(javax.swing.event.ChangeEvent evt) {//GEN-FIRST:event_InstrDetNrNewStateChanged
// TODO add your handling code here:
    UpdateInstrDetails(SymphManager.checkSpinnerLimits(InstrDetNrNew, 0, SymphManager.SymSong.getNumbOfInstruments()-1, true) );  
    UpdateActualInstrDetails();
}//GEN-LAST:event_InstrDetNrNewStateChanged

private void InstrDetTuneStateChanged(javax.swing.event.ChangeEvent evt) {//GEN-FIRST:event_InstrDetTuneStateChanged
// TODO add your handling code here:
            int Value;                                       
        String s;
        Number n;
        NumberFormat nf = NumberFormat.getInstance();
        
        s = InstrDetTune.getModel().getValue().toString();
        try{
            n = nf.parse(s);
            Value = n.intValue();
            if(Value < -24) Value = -24;
            if(Value >= 48 ) Value = 48;
            SymphManager.SymSong.getInstrumentIndex(SymphManager.getActualInstrumentIndex()).Tune = Value;
            UpdateActualInstrDetails(); 
        } catch (java.text.ParseException e) {
        } 
}//GEN-LAST:event_InstrDetTuneStateChanged

private void formFocusGained(java.awt.event.FocusEvent evt) {//GEN-FIRST:event_formFocusGained
// TODO add your handling code here:

}//GEN-LAST:event_formFocusGained

private void formWindowGainedFocus(java.awt.event.WindowEvent evt) {//GEN-FIRST:event_formWindowGainedFocus
// TODO add your handling code here:
//    UpdateActualInstrDetails(); 
}//GEN-LAST:event_formWindowGainedFocus

private void formComponentShown(java.awt.event.ComponentEvent evt) {//GEN-FIRST:event_formComponentShown
// TODO add your handling code here:

}//GEN-LAST:event_formComponentShown

private void InstrDetSampleViewComponentResized(java.awt.event.ComponentEvent evt) {//GEN-FIRST:event_InstrDetSampleViewComponentResized
// TODO add your handling code here:
//            UpdateActualInstrDetails(); 
}//GEN-LAST:event_InstrDetSampleViewComponentResized

private void InstrDetLoopStartStateChanged(javax.swing.event.ChangeEvent evt) {//GEN-FIRST:event_InstrDetLoopStartStateChanged
// TODO add your handling code here:
    SymphonieInstrument si = SymphManager.getActualInstrument();
    if(si!=null && si.sp!=null && getVerifyValues()) {
	int max = si.getMaxLoopStart();
	int i = SymphManager.checkSpinnerLimits(InstrDetLoopStart, 0, max, false);  
	si.setLoopStart(i);
	InstrDetLoopStart.setValue(i);
	si.updateLoopParameters();
	redrawSampleFrame();
	//UpdateActualInstrDetails();	
    }

}//GEN-LAST:event_InstrDetLoopStartStateChanged

private void InstrDetLoopLenStateChanged(javax.swing.event.ChangeEvent evt) {//GEN-FIRST:event_InstrDetLoopLenStateChanged
// TODO add your handling code here:
    SymphonieInstrument si = SymphManager.getActualInstrument();
    if(si!=null && si.sp!=null && getVerifyValues()) {
	int max = si.getMaxLoopLen();
	int i = SymphManager.checkSpinnerLimits(InstrDetLoopLen, 0, max, false);  
	si.setLoopLen(i);
	InstrDetLoopLen.setValue(i);
	si.updateLoopParameters();
	redrawSampleFrame();
	//UpdateActualInstrDetails();	
    }
}//GEN-LAST:event_InstrDetLoopLenStateChanged

private void InstrDetPanningEnableActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_InstrDetPanningEnableActionPerformed
// TODO add your handling code here:
    SymphonieInstrument si = SymphManager.getActualInstrument();
    if(si!=null && si.checkReady()) {
        si.PanningActive = InstrDetPanningEnable.isSelected();
        UpdateActualInstrDetails();
    }    
}//GEN-LAST:event_InstrDetPanningEnableActionPerformed

private void InstrDetPanoramaStateChanged(javax.swing.event.ChangeEvent evt) {//GEN-FIRST:event_InstrDetPanoramaStateChanged
// TODO add your handling code here:
    SymphonieInstrument si = SymphManager.getActualInstrument();
    if(si!=null && si.checkReady()) {
	si.PanningX = SymphManager.checkSpinnerLimits(InstrDetPanorama, -1000, 1000, true);
    }
    
}//GEN-LAST:event_InstrDetPanoramaStateChanged

private void InstrDetTwoWayLoopActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_InstrDetTwoWayLoopActionPerformed
// TODO add your handling code here:
    SymphonieInstrument si = SymphManager.getActualInstrument();
    if(si!=null && si.checkReady()) {
	si.TwoWayLoop = InstrDetTwoWayLoop.isSelected();
    }

}//GEN-LAST:event_InstrDetTwoWayLoopActionPerformed

private void jButton3ActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButton3ActionPerformed
// TODO add your handling code here:
    Color NewColor = JColorChooser.showDialog(MetaPanel.getComponent(0), "Instrument ", MetaColor.getBackground());
    MetaColor.setBackground(NewColor);
    SymphonieInstrument si = SymphManager.getActualInstrument();
    if(si!=null && si.checkReady()) {
	si.MetaInfo.R = MetaColor.getBackground().getRed();
	si.MetaInfo.G = MetaColor.getBackground().getGreen();
	si.MetaInfo.B = MetaColor.getBackground().getBlue();
    }
}//GEN-LAST:event_jButton3ActionPerformed

private void MetaMainLeadActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_MetaMainLeadActionPerformed
// TODO add your handling code here:
    SymphonieInstrument si = SymphManager.getActualInstrument();
    if(si!=null && si.checkReady()) si.MetaInfo.MainLead = MetaMainLead.isSelected();
}//GEN-LAST:event_MetaMainLeadActionPerformed

private void MetaLead2ActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_MetaLead2ActionPerformed
// TODO add your handling code here:
    SymphonieInstrument si = SymphManager.getActualInstrument();
    if(si!=null && si.checkReady()) si.MetaInfo.Lead2 = MetaLead2.isSelected();
}//GEN-LAST:event_MetaLead2ActionPerformed

private void MetaPercussionActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_MetaPercussionActionPerformed
// TODO add your handling code here:
        SymphonieInstrument si = SymphManager.getActualInstrument();
    if(si!=null && si.checkReady()) si.MetaInfo.Percussion = MetaPercussion.isSelected();

}//GEN-LAST:event_MetaPercussionActionPerformed

private void MetaBeatActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_MetaBeatActionPerformed
// TODO add your handling code here:
    SymphonieInstrument si = SymphManager.getActualInstrument();
    if(si!=null && si.checkReady()) si.MetaInfo.Beat = MetaBeat.isSelected();

}//GEN-LAST:event_MetaBeatActionPerformed

private void MetaSubBeatActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_MetaSubBeatActionPerformed
// TODO add your handling code here:
   SymphonieInstrument si = SymphManager.getActualInstrument();
   if(si!=null && si.checkReady()) si.MetaInfo.SubBeat = MetaSubBeat.isSelected();
}//GEN-LAST:event_MetaSubBeatActionPerformed
	    
	    
    /**
     * @param args the command line arguments
     */
    public static void main(String args[]) {
	java.awt.EventQueue.invokeLater(new Runnable() {
	    public void run() {
		new frmNewInstrFrame().setVisible(true);
	    }
	});
    }
    
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JButton InstrDetExportRawSample;
    private javax.swing.JSpinner InstrDetFineTune;
    private javax.swing.JTextField InstrDetFormat;
    private javax.swing.JLabel InstrDetID;
    private javax.swing.JButton InstrDetLoadSample;
    private javax.swing.JSpinner InstrDetLoopLen;
    private javax.swing.JSpinner InstrDetLoopStart;
    private javax.swing.JLabel InstrDetLoopText;
    private javax.swing.JLabel InstrDetMouseRelTxt;
    private javax.swing.JCheckBox InstrDetNoDsp;
    private javax.swing.JSpinner InstrDetNrNew;
    private javax.swing.JSlider InstrDetPanSlider;
    private javax.swing.JCheckBox InstrDetPanningEnable;
    private javax.swing.JSpinner InstrDetPanorama;
    private javax.swing.JTextField InstrDetSampleResolution;
    private javax.swing.JLayeredPane InstrDetSampleView;
    private javax.swing.JComboBox InstrDetStereoType;
    private javax.swing.JCheckBox InstrDetSyncPlay;
    private javax.swing.JSpinner InstrDetTune;
    private javax.swing.JCheckBox InstrDetTwoWayLoop;
    private javax.swing.JTextField InstrDetTxt;
    private javax.swing.JComboBox InstrDetViewFormat;
    private javax.swing.JSpinner InstrDetVolume;
    private javax.swing.JCheckBox InstrNoDetune;
    private javax.swing.JCheckBox MetaBeat;
    private javax.swing.JPanel MetaColor;
    private javax.swing.JCheckBox MetaLead2;
    private javax.swing.JCheckBox MetaMainLead;
    private javax.swing.JPanel MetaPanel;
    private javax.swing.JCheckBox MetaPercussion;
    private javax.swing.JCheckBox MetaSubBeat;
    private javax.swing.JButton jButton1;
    private javax.swing.JButton jButton2;
    private javax.swing.JButton jButton3;
    private javax.swing.JColorChooser jColorChooser;
    private javax.swing.JLabel jLabel1;
    private javax.swing.JLabel jLabel2;
    private javax.swing.JLabel jLabel3;
    private javax.swing.JPanel jPanel1;
    private javax.swing.JPanel jPanel2;
    private javax.swing.JTabbedPane jTabbedPane1;
    private javax.swing.JToolBar jToolBar1;
    private javax.swing.JLabel lblInstrNr;
    private javax.swing.JLabel lblInstrNr1;
    private javax.swing.JLabel lblInstrNr2;
    private javax.swing.JLabel lblInstrNr3;
    private org.jdesktop.beansbinding.BindingGroup bindingGroup;
    // End of variables declaration//GEN-END:variables
    
    private UIManager SymphManager;
    private boolean VerifyValues = true;
    private Color MetaColorTemp;
    
    boolean getVerifyValues() {return(VerifyValues);}
    
    void initUIManager(UIManager mySymphManager) {
        this.SymphManager = mySymphManager;
    }
    
    void UpdateActualInstrDetails() {
        UpdateInstrDetails(SymphManager.getActualInstrumentIndex());
    }
    
    void redrawSampleFrame() {
        SymphManager.setActualInstrumentIndex(SymphManager.getActualInstrumentIndex());
        SymphonieInstrument si = SymphManager.SymSong.getInstrumentIndex(SymphManager.getActualInstrumentIndex());
        if((si != null)&&  (si.checkReady()) ) {
            UpdateInstrDetailsSampleView(SymphManager.getActualInstrumentIndex());
	}
    }
    
    void UpdateInstrDetailsVerifyValues(boolean b) {
	VerifyValues = b;
    }
    void UpdateInstrDetails(int ActualInstrNr) {
        
        SymphManager.setActualInstrumentIndex(ActualInstrNr);
        SymphonieInstrument si = SymphManager.SymSong.getInstrumentIndex(ActualInstrNr);
	UpdateInstrDetailsVerifyValues(false);
        if((si != null)&&  (si.checkReady()) ) {
            InstrDetTxt.setText(si.Name);
            InstrDetID.setText(""+si.ID);
            InstrDetVolume.setValue(si.Volume);
            InstrDetTune.setValue(si.Tune);
            InstrDetFineTune.setValue(si.FineTune);
            InstrNoDetune.setSelected(si.AllowPosDetune);
            InstrDetNoDsp.setSelected(si.NoDsp);
            InstrDetStereoType.setSelectedIndex(si.MultiChannel);
            InstrDetSampleResolution.setText("" + si.ImportSample.SampleResolutionBit);
            InstrDetFormat.setText(si.ImportSample.FormatString);
            UpdateInstrDetailsSampleView(ActualInstrNr);
	    InstrDetLoopStart.setValue(si.sp.getLoopStart());
	    InstrDetLoopLen.setValue(si.sp.getLoopLen());
            if(si.sp.hasLoop()==true) {
                InstrDetLoopText.setText( "Loop:" + si.sp.getLoopStart() + " Length:" + si.sp.getLoopLen()  );
            } else {
                InstrDetLoopText.setText("");
            }
	    InstrDetTwoWayLoop.setSelected(si.TwoWayLoop);
	    
	    InstrDetPanningEnable.setSelected(si.PanningActive);
	    InstrDetPanSlider.setValue((int) si.PanningX);
	    
	    // Meta Info
	    MetaMainLead.setSelected(si.MetaInfo.MainLead);
	    MetaLead2.setSelected(si.MetaInfo.Lead2);
	    MetaBeat.setSelected(si.MetaInfo.Beat);
	    MetaSubBeat.setSelected(si.MetaInfo.SubBeat);
	    MetaPercussion.setSelected(si.MetaInfo.Percussion);
	    
	    MetaColorTemp = new Color (si.MetaInfo.R, si.MetaInfo.G, si.MetaInfo.B);
	    MetaColor.setBackground(MetaColorTemp); 


	    setElementsEnabled(si, true);
        } else {
            InstrDetTxt.setText("<Unused>");
            ClearInstrDetailsSampleView();
            InstrDetSampleResolution.setText("n/a");
            InstrDetFormat.setText("n/a");
	    InstrDetID.setText("");
	    InstrDetLoopStart.setValue(0);
	    InstrDetLoopLen.setValue(0);
	    InstrDetVolume.setValue(0);
	    setElementsEnabled(si, false);
        }
	UpdateInstrDetailsVerifyValues(true);
    }
    
    void setElementsEnabled(SymphonieInstrument si, boolean Enable) {
	    InstrDetLoopStart.setEnabled(Enable);
	    InstrDetLoopLen.setEnabled(Enable);
	    InstrDetVolume.setEnabled(Enable);
	    InstrDetTune.setEnabled(Enable);
	    InstrDetFineTune.setEnabled(Enable);
	    InstrNoDetune.setEnabled(Enable);
	    InstrDetNoDsp.setEnabled(Enable);
            
	    if(si.MultiChannel == MultichannelType.Mono) {
		InstrDetPanningEnable.setEnabled(Enable);
	    } else {
		InstrDetPanningEnable.setEnabled(false);
	    }
	    
	    InstrDetTwoWayLoop.setEnabled(Enable);
	    
	    if(InstrDetPanningEnable.isSelected()) {
                InstrDetPanorama.setEnabled(Enable);
                InstrDetPanSlider.setEnabled(Enable);
            } else  {
                InstrDetPanorama.setEnabled(false);
                InstrDetPanSlider.setEnabled(false);
            }
	    MetaPanel.setEnabled(Enable);
                
    }

    
    float getActInstrSample(int i){
        float Sample = 0;
        if(SymphManager.getActualInstrument().SampleDataLoaded == true) {
            if(i < SymphManager.getActualInstrument().sp.getNumbOfSamples() ) {
                Sample = SymphManager.getActualInstrument().sp.Samples[i];
            }
        }
        return(Sample);
    }
    
     int getActInstrSamplePercent(long i, long maxi, int h){
        float Sample = 0;
        int NumbOfSamples;
        long temp;
        
        if(SymphManager.getActualInstrument().SampleDataLoaded == true) {
            NumbOfSamples = SymphManager.getActualInstrument().sp.getNumbOfSamples();
            temp = i * NumbOfSamples;
            Sample = getActInstrSample( (int) (temp / maxi) ) ;
        }            
        Sample = Sample * h / 2; // -1 to +1
        return((int) Sample);
    }
    
    void ClearInstrDetailsSampleView() {
        java.awt.Graphics g;
        int w,h,x,y,i, Oldy = 0;
        SampleViewMarkersCount = 0;
        w = InstrDetSampleView.getBounds().width;
        h = InstrDetSampleView.getBounds().height;
        g = InstrDetSampleView.getGraphics();
        g.clearRect(0, 0, w, h);
        SampleViewDrawLoop();
    }  
    
    int GetSamplePositionOnSampleView(SymphonieInstrument si, float SamplePtr) {
        if(si.checkReady() && si.sp.getNumbOfSamples()>0) {
            float x = (SamplePtr * InstrDetSampleView.getBounds().width) / si.sp.getNumbOfSamples();
            return((int) (x+InstrDetSampleView.getBounds().x));
        } else {
            return(0);
        }
    }

    void SampleViewDrawVMarker(int x) {
        java.awt.Graphics g;
        g = InstrDetSampleView.getGraphics();
        g.setXORMode(Color.YELLOW);
        g.drawLine(x,  0, x, InstrDetSampleView.getBounds().height);          
//        g.drawLine(x+1,0, x+1, InstrDetSampleView.getBounds().height);          
    }
    
    int[] SampleViewMarkers = new int[256];
    int SampleViewMarkersCount = 0;
    
    void SampleViewClearPlayPositions() {
        if(SampleViewMarkersCount>0) {
            for(int i = 0;i<SampleViewMarkersCount;i++) {
                if(SampleViewMarkersCount>0) SampleViewDrawVMarker(SampleViewMarkers[i]);
            }
        }
    }

    void SampleViewDrawPlayPositions() {
        int x;
        SymphonieInstrument si = SymphManager.getActualInstrument();
        SampleViewClearPlayPositions();
        SampleViewMarkersCount = 0;
        for(int i = 0;i<SymphManager.getVoiceExpander().getNumbOfVoicesPlaying();i++) {
            if((si != null) && (SymphManager.getVoiceExpander().Voices[i] != null) ) {
                if((SymphManager.getVoiceExpander().Voices[i].si == si) && (SymphManager.getVoiceExpander().isVoicePlaying(i))) {
                    x = GetSamplePositionOnSampleView(si, (float) SymphManager.getVoiceExpander().Voices[i].SamplePtr);
                    SampleViewDrawVMarker(x);
                    SampleViewMarkers[SampleViewMarkersCount] = x;
                    SampleViewMarkersCount++;
                }
            } 
        }
    }
    
    void SampleViewDrawLoop() {
        SymphonieInstrument si = SymphManager.getActualInstrument();
        if(si != null) {
            if(si.checkReady()) {
                if((si.sp.hasLoop()) ) { // && (si.sp.getNumbOfLoops()>0)
                    java.awt.Graphics g;
                    float w,h,x;
                    w = InstrDetSampleView.getBounds().width;
                    h = InstrDetSampleView.getBounds().height;
                    g = InstrDetSampleView.getGraphics();
                    g.setColor(SymphManager.LoopColor);
                    x = GetSamplePositionOnSampleView(si, si.sp.getLoopStart() );
                    w = GetSamplePositionOnSampleView(si, si.sp.getLoopLen() );
                    g.fillRect((int) x, 0, (int) w, (int) h);
                }
            }
        }
    }
    
    void SampleShowMousePosition(float x) {
        SymphonieInstrument si = SymphManager.getActualInstrument();
        if(si != null) {
            if(si.checkReady()) {
                float w;
		w = 255 * x / InstrDetSampleView.getBounds().width;
		InstrDetMouseRelTxt.setText(""+w);
	    }
	}
    }
    
    
    void UpdateInstrDetailsSampleView(int ActualInstrNr) {
        java.awt.Graphics g;
        int w,h,x,y,i, Oldy = 0;
        int Resolution;
        
        w = InstrDetSampleView.getBounds().width;
        h = InstrDetSampleView.getBounds().height;
        g = InstrDetSampleView.getGraphics();
        ClearInstrDetailsSampleView();
        g.drawLine(0, (h/2), w, (h/2));  
        Oldy = 0;
        
        switch(InstrDetViewFormat.getSelectedIndex()) {
            case 0: 
                for(i=0;i<w;i++) {
                    y = getActInstrSamplePercent(i,w,h) ;
                    g.drawLine(i, Oldy+(h/2), i+1, y+(h/2));   
                    Oldy = y;    
                }
                break;
            case 1: 
                Resolution = (w/10)+1;
                for(i=0;i<w*Resolution;i++) {
                    y = getActInstrSamplePercent(i,w*Resolution,h) ;
                    g.drawLine((i/Resolution)+1, y+(h/2), (i/Resolution)+1, y+(h/2));  
                }
                break;
            case 2: 
                Resolution = (w/60)+1;
                for(i=0;i<w*Resolution;i++) {
                    y = getActInstrSamplePercent(i,w*Resolution,h) ;
                    g.drawLine((i/Resolution)+1, y+(h/2), (i/Resolution)+1, y+(h/2));  
                }
                break;            
            case 3: 
                Resolution = 2;
                for(i=0;i<w*Resolution;i++) {
                    y = getActInstrSamplePercent(i+1,w*Resolution,h) ;
                    g.drawLine((i/Resolution)+1, (h/2), (i/Resolution)+1, y+(h/2));  
                }
                break;
        }

    }  
    
    void moveToInstrIndex(int i) {
	InstrDetNrNew.setValue(i);
    }
    
    
}
