/*
 * SymReaderView.java 
 * 
 */


/**
 *
 * @author (c) Patrick Meng 2008
 */

package symreader;

import java.awt.Color;
import org.jdesktop.application.Action;
import org.jdesktop.application.ResourceMap;
import org.jdesktop.application.SingleFrameApplication;
import org.jdesktop.application.FrameView;
import org.jdesktop.application.TaskMonitor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Timer;
import javax.swing.Icon;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JSpinner;

import javax.swing.DefaultListModel;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import javax.swing.JFileChooser;
import java.text.NumberFormat;


//import java.util.concurrent.Executor;
import java.lang.Thread;
/**
 * The application's main frame.
 */
public class SymReaderView extends FrameView {

    public SymReaderView(SingleFrameApplication app) {
        super(app);

        initComponents();
        

	
	
	
	
        // status bar initialization - message timeout, idle icon and busy animation, etc
        ResourceMap resourceMap = getResourceMap();
        int messageTimeout = resourceMap.getInteger("StatusBar.messageTimeout");
        messageTimer = new Timer(messageTimeout, new ActionListener() {
            public void actionPerformed(ActionEvent e) {
                //statusMessageLabel.setText("");
            }
        });
        messageTimer.setRepeats(false);
        int busyAnimationRate = resourceMap.getInteger("StatusBar.busyAnimationRate");
        for (int i = 0; i < busyIcons.length; i++) {
            busyIcons[i] = resourceMap.getIcon("StatusBar.busyIcons[" + i + "]");
        }
        busyIconTimer = new Timer(busyAnimationRate, new ActionListener() {
            public void actionPerformed(ActionEvent e) {
                busyIconIndex = (busyIconIndex + 1) % busyIcons.length;
                //statusAnimationLabel.setIcon(busyIcons[busyIconIndex]);
            }
        });
        idleIcon = resourceMap.getIcon("StatusBar.idleIcon");
        //statusAnimationLabel.setIcon(idleIcon);


        // connecting action tasks to status bar via TaskMonitor
//        TaskMonitor taskMonitor = new TaskMonitor(getApplication().getContext());
//        taskMonitor.addPropertyChangeListener(new java.beans.PropertyChangeListener() {
//            public void propertyChange(java.beans.PropertyChangeEvent evt) {
//                String propertyName = evt.getPropertyName();
//                if ("started".equals(propertyName)) {
//                    if (!busyIconTimer.isRunning()) {
//                        statusAnimationLabel.setIcon(busyIcons[0]);
//                        busyIconIndex = 0;
//                        busyIconTimer.start();
//                    }
//
//                } else if ("done".equals(propertyName)) {
//                    busyIconTimer.stop();
//                    statusAnimationLabel.setIcon(idleIcon);
//
//                } else if ("message".equals(propertyName)) {
//                    String text = (String)(evt.getNewValue());
//                    statusMessageLabel.setText((text == null) ? "" : text);
//                    messageTimer.restart();
//                } else if ("progress".equals(propertyName)) {
//                    int value = (Integer)(evt.getNewValue());
//
//                }
//            }
//        });
        initMyComponents();
    }

    @Action
    public void showAboutBox() {
        if (aboutBox == null) {
            JFrame mainFrame = SymReaderApp.getApplication().getMainFrame();
            aboutBox = new SymReaderAboutBox(mainFrame);
            aboutBox.setLocationRelativeTo(mainFrame);
        }
        SymReaderApp.getApplication().show(aboutBox);
    }

    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {
        bindingGroup = new org.jdesktop.beansbinding.BindingGroup();

        mainPanel = new javax.swing.JPanel();
        SysTab = new javax.swing.JTabbedPane();
        SystemPanel = new javax.swing.JPanel();
        jLabel5 = new javax.swing.JLabel();
        jLabel6 = new javax.swing.JLabel();
        jLabel7 = new javax.swing.JLabel();
        SysMasterVolume = new javax.swing.JSlider();
        SysMasterTune = new javax.swing.JSlider();
        SysMasterVoices = new javax.swing.JTextField();
        SysMasterBPMAdj = new javax.swing.JSlider();
        SysDeclicking = new javax.swing.JCheckBox();
        SysMasterBPM = new javax.swing.JTextField();
        jLabel17 = new javax.swing.JLabel();
        jButton3 = new javax.swing.JButton();
        jButton4 = new javax.swing.JButton();
        jLabel8 = new javax.swing.JLabel();
        SysDeclickingLenSlider = new javax.swing.JSlider();
        jLabel10 = new javax.swing.JLabel();
        SysMixRate = new javax.swing.JComboBox();
        SysDSPPanel = new javax.swing.JPanel();
        SysDspMixVolumeSlider = new javax.swing.JSlider();
        SysDspFxTypeCombox = new javax.swing.JComboBox();
        jLabel11 = new javax.swing.JLabel();
        jLabel12 = new javax.swing.JLabel();
        jLabel13 = new javax.swing.JLabel();
        SysDspFeedback = new javax.swing.JSlider();
        jLabel14 = new javax.swing.JLabel();
        SysDspLength = new javax.swing.JSlider();
        SysDspLPFilter = new javax.swing.JCheckBox();
        SysDspPreDelay = new javax.swing.JSlider();
        jLabel15 = new javax.swing.JLabel();
        jLabel16 = new javax.swing.JLabel();
        SysSyncToBeat = new javax.swing.JCheckBox();
        jLabel18 = new javax.swing.JLabel();
        SysSoundDesignPanel = new javax.swing.JPanel();
        jLabel1 = new javax.swing.JLabel();
        jLabel2 = new javax.swing.JLabel();
        SysSampleDiff = new javax.swing.JSlider();
        SysPitchDiff = new javax.swing.JSlider();
        jLabel3 = new javax.swing.JLabel();
        jLabel19 = new javax.swing.JLabel();
        jCheckBox1 = new javax.swing.JCheckBox();
        jCheckBox2 = new javax.swing.JCheckBox();
        SysPitchDiff2 = new javax.swing.JSlider();
        SysDitheringCombox = new javax.swing.JComboBox();
        jLabel9 = new javax.swing.JLabel();
        SysInterpolationType = new javax.swing.JComboBox();
        jLabel4 = new javax.swing.JLabel();
        SysUpdatePanel = new javax.swing.JPanel();
        SysUpdateSamplePos = new javax.swing.JCheckBox();
        SysUpdatePatternNr = new javax.swing.JCheckBox();
        SysUpdateCrsr = new javax.swing.JCheckBox();
        SysUpdateInstr = new javax.swing.JCheckBox();
        SysLoadingPanel = new javax.swing.JPanel();
        SysLoadModDeactivateDsp = new javax.swing.JCheckBox();
        jScrollPane1 = new javax.swing.JScrollPane();
        jList1 = new javax.swing.JList();
        jPanel1 = new javax.swing.JPanel();
        PEDDisplayMouseCrsr = new javax.swing.JCheckBox();
        MenuBar = new javax.swing.JToolBar();
        playSongButton = new javax.swing.JButton();
        stopSongButton = new javax.swing.JButton();
        jButton1 = new javax.swing.JButton();
        SymLoad = new javax.swing.JButton();
        playPatternButton = new javax.swing.JButton();
        SysStatusLabel = new javax.swing.JLabel();
        menuBar = new javax.swing.JMenuBar();
        javax.swing.JMenu fileMenu = new javax.swing.JMenu();
        loadModMenuItem = new javax.swing.JMenuItem();
        loadSampleMenuItem = new javax.swing.JMenuItem();
        newSongMenuItem = new javax.swing.JMenuItem();
        jMenuItem1 = new javax.swing.JMenuItem();
        jMenuItem2 = new javax.swing.JMenuItem();
        javax.swing.JMenuItem exitMenuItem = new javax.swing.JMenuItem();
        javax.swing.JMenu helpMenu = new javax.swing.JMenu();
        javax.swing.JMenuItem aboutMenuItem = new javax.swing.JMenuItem();
        frmInstrList = new javax.swing.JFrame();
        jScrollPane2 = new javax.swing.JScrollPane();
        InstrList = new javax.swing.JList();
        PosListjFrame = new javax.swing.JFrame();
        PosListPane = new javax.swing.JScrollPane();
        PosListJList = new javax.swing.JList();
        PosEdFrame = new javax.swing.JFrame();
        PosEdTab = new javax.swing.JTabbedPane();
        PosEdMainPanel = new javax.swing.JPanel();
        jLabel20 = new javax.swing.JLabel();
        jLabel21 = new javax.swing.JLabel();
        jLabel23 = new javax.swing.JLabel();
        PosEdNr = new javax.swing.JSpinner();
        jLabel24 = new javax.swing.JLabel();
        PosEdPatternNr = new javax.swing.JSpinner();
        PosEdStart = new javax.swing.JSpinner();
        jLabel25 = new javax.swing.JLabel();
        PosEdLen = new javax.swing.JSpinner();
        PosEdCycl = new javax.swing.JSpinner();
        jLabel22 = new javax.swing.JLabel();
        PosEdLoop = new javax.swing.JSpinner();
        jLabel26 = new javax.swing.JLabel();
        PosEdTune = new javax.swing.JSpinner();
        jLabel27 = new javax.swing.JLabel();
        PosEdNameText = new javax.swing.JTextField();
        PosEdToolbar = new javax.swing.JToolBar();
        jButton6 = new javax.swing.JButton();
        jButton7 = new javax.swing.JButton();
        jButton5 = new javax.swing.JButton();

        mainPanel.setName("mainPanel"); // NOI18N
        mainPanel.setPreferredSize(new java.awt.Dimension(320, 512));

        SysTab.setName("SysTab"); // NOI18N

        SystemPanel.setBorder(javax.swing.BorderFactory.createTitledBorder(""));
        SystemPanel.setName("Audio"); // NOI18N
        SystemPanel.setPreferredSize(new java.awt.Dimension(320, 400));
        SystemPanel.addKeyListener(new java.awt.event.KeyAdapter() {
            public void keyPressed(java.awt.event.KeyEvent evt) {
                SystemPanelKeyPressed(evt);
            }
            public void keyTyped(java.awt.event.KeyEvent evt) {
                SystemPanelKeyTyped(evt);
            }
        });

        org.jdesktop.application.ResourceMap resourceMap = org.jdesktop.application.Application.getInstance(symreader.SymReaderApp.class).getContext().getResourceMap(SymReaderView.class);
        jLabel5.setText(resourceMap.getString("jLabel5.text")); // NOI18N
        jLabel5.setName("jLabel5"); // NOI18N

        jLabel6.setText(resourceMap.getString("jLabel6.text")); // NOI18N
        jLabel6.setName("jLabel6"); // NOI18N

        jLabel7.setText(resourceMap.getString("jLabel7.text")); // NOI18N
        jLabel7.setName("jLabel7"); // NOI18N

        SysMasterVolume.setMajorTickSpacing(10);
        SysMasterVolume.setMinorTickSpacing(5);
        SysMasterVolume.setPaintLabels(true);
        SysMasterVolume.setPaintTicks(true);
        SysMasterVolume.setValue(100);
        SysMasterVolume.setName("SysMasterVolume"); // NOI18N
        SysMasterVolume.addChangeListener(new javax.swing.event.ChangeListener() {
            public void stateChanged(javax.swing.event.ChangeEvent evt) {
                SysMasterVolumeStateChanged(evt);
            }
        });

        SysMasterTune.setMajorTickSpacing(2);
        SysMasterTune.setMaximum(10);
        SysMasterTune.setMinimum(-10);
        SysMasterTune.setMinorTickSpacing(1);
        SysMasterTune.setPaintLabels(true);
        SysMasterTune.setPaintTicks(true);
        SysMasterTune.setValue(0);
        SysMasterTune.setName("SysMasterTune"); // NOI18N
        SysMasterTune.addChangeListener(new javax.swing.event.ChangeListener() {
            public void stateChanged(javax.swing.event.ChangeEvent evt) {
                SysMasterTuneStateChanged(evt);
            }
        });

        SysMasterVoices.setEditable(false);
        SysMasterVoices.setText(resourceMap.getString("SysMasterVoices.text")); // NOI18N
        SysMasterVoices.setName("SysMasterVoices"); // NOI18N

        SysMasterBPMAdj.setMajorTickSpacing(10);
        SysMasterBPMAdj.setMaximum(150);
        SysMasterBPMAdj.setMinimum(50);
        SysMasterBPMAdj.setMinorTickSpacing(5);
        SysMasterBPMAdj.setPaintLabels(true);
        SysMasterBPMAdj.setPaintTicks(true);
        SysMasterBPMAdj.setValue(100);
        SysMasterBPMAdj.setName("SysMasterBPMAdj"); // NOI18N
        SysMasterBPMAdj.addChangeListener(new javax.swing.event.ChangeListener() {
            public void stateChanged(javax.swing.event.ChangeEvent evt) {
                SysMasterBPMAdjStateChanged(evt);
            }
        });

        SysDeclicking.setSelected(true);
        SysDeclicking.setText(resourceMap.getString("SysDeclicking.text")); // NOI18N
        SysDeclicking.setName("SysDeclicking"); // NOI18N
        SysDeclicking.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                SysDeclickingActionPerformed(evt);
            }
        });

        SysMasterBPM.setText(resourceMap.getString("SysMasterBPM.text")); // NOI18N
        SysMasterBPM.setName("SysMasterBPM"); // NOI18N
        SysMasterBPM.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                SysMasterBPMActionPerformed(evt);
            }
        });

        jLabel17.setText(resourceMap.getString("jLabel17.text")); // NOI18N
        jLabel17.setName("jLabel17"); // NOI18N

        jButton3.setText(resourceMap.getString("jButton3.text")); // NOI18N
        jButton3.setBorder(new javax.swing.border.SoftBevelBorder(javax.swing.border.BevelBorder.RAISED));
        jButton3.setName("jButton3"); // NOI18N
        jButton3.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jButton3ActionPerformed(evt);
            }
        });

        jButton4.setText(resourceMap.getString("jButton4.text")); // NOI18N
        jButton4.setBorder(new javax.swing.border.SoftBevelBorder(javax.swing.border.BevelBorder.RAISED));
        jButton4.setName("jButton4"); // NOI18N
        jButton4.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jButton4ActionPerformed(evt);
            }
        });

        jLabel8.setText(resourceMap.getString("jLabel8.text")); // NOI18N
        jLabel8.setName("jLabel8"); // NOI18N

        SysDeclickingLenSlider.setMajorTickSpacing(100);
        SysDeclickingLenSlider.setMaximum(500);
        SysDeclickingLenSlider.setMinorTickSpacing(50);
        SysDeclickingLenSlider.setPaintLabels(true);
        SysDeclickingLenSlider.setPaintTicks(true);
        SysDeclickingLenSlider.setValue(25);
        SysDeclickingLenSlider.setName("SysDeclickingLenSlider"); // NOI18N
        SysDeclickingLenSlider.addChangeListener(new javax.swing.event.ChangeListener() {
            public void stateChanged(javax.swing.event.ChangeEvent evt) {
                SysDeclickingLenSliderStateChanged(evt);
            }
        });

        jLabel10.setName("jLabel10"); // NOI18N

        org.jdesktop.beansbinding.Binding binding = org.jdesktop.beansbinding.Bindings.createAutoBinding(org.jdesktop.beansbinding.AutoBinding.UpdateStrategy.READ_WRITE, SysDeclickingLenSlider, org.jdesktop.beansbinding.ELProperty.create("${value}"), jLabel10, org.jdesktop.beansbinding.BeanProperty.create("text"));
        bindingGroup.addBinding(binding);

        SysMixRate.setModel(new javax.swing.DefaultComboBoxModel(new String[] { "44.1 kHz", "48 kHz", "88.2 kHz", "96 kHz", "192 kHz" }));
        SysMixRate.setName("SysMixRate"); // NOI18N
        SysMixRate.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                SysMixRateActionPerformed(evt);
            }
        });

        javax.swing.GroupLayout SystemPanelLayout = new javax.swing.GroupLayout(SystemPanel);
        SystemPanel.setLayout(SystemPanelLayout);
        SystemPanelLayout.setHorizontalGroup(
            SystemPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(SystemPanelLayout.createSequentialGroup()
                .addContainerGap()
                .addGroup(SystemPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING, false)
                    .addComponent(jLabel7)
                    .addComponent(jButton4, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                    .addComponent(jLabel6)
                    .addComponent(jButton3, 0, 0, Short.MAX_VALUE))
                .addGap(46, 46, 46)
                .addGroup(SystemPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.TRAILING)
                    .addGroup(SystemPanelLayout.createSequentialGroup()
                        .addGap(39, 39, 39)
                        .addComponent(jLabel5)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addComponent(SysMixRate, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED, 40, Short.MAX_VALUE)
                        .addComponent(jLabel17)
                        .addGap(28, 28, 28)
                        .addComponent(SysMasterBPM, javax.swing.GroupLayout.PREFERRED_SIZE, 45, javax.swing.GroupLayout.PREFERRED_SIZE)
                        .addGap(32, 32, 32))
                    .addGroup(javax.swing.GroupLayout.Alignment.LEADING, SystemPanelLayout.createSequentialGroup()
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addGroup(SystemPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                            .addComponent(SysMasterTune, javax.swing.GroupLayout.DEFAULT_SIZE, 317, Short.MAX_VALUE)
                            .addComponent(SysMasterVolume, javax.swing.GroupLayout.DEFAULT_SIZE, 317, Short.MAX_VALUE)))
                    .addGroup(javax.swing.GroupLayout.Alignment.LEADING, SystemPanelLayout.createSequentialGroup()
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addComponent(SysMasterBPMAdj, javax.swing.GroupLayout.DEFAULT_SIZE, 317, Short.MAX_VALUE))))
            .addGroup(SystemPanelLayout.createSequentialGroup()
                .addGap(54, 54, 54)
                .addComponent(SysMasterVoices, javax.swing.GroupLayout.PREFERRED_SIZE, 64, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addContainerGap(304, Short.MAX_VALUE))
            .addGroup(SystemPanelLayout.createSequentialGroup()
                .addContainerGap()
                .addComponent(jLabel8)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(SysDeclicking)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(jLabel10)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(SysDeclickingLenSlider, javax.swing.GroupLayout.DEFAULT_SIZE, 329, Short.MAX_VALUE))
        );
        SystemPanelLayout.setVerticalGroup(
            SystemPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(SystemPanelLayout.createSequentialGroup()
                .addGroup(SystemPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(jLabel6)
                    .addComponent(SysMasterVoices, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                    .addComponent(SysMasterBPM, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                    .addComponent(jLabel17)
                    .addComponent(jLabel5)
                    .addComponent(SysMixRate, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                .addGroup(SystemPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addGroup(SystemPanelLayout.createSequentialGroup()
                        .addGap(28, 28, 28)
                        .addComponent(jLabel7))
                    .addGroup(SystemPanelLayout.createSequentialGroup()
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addComponent(SysMasterVolume, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addGroup(SystemPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addComponent(SysMasterTune, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                    .addComponent(jButton3))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addGroup(SystemPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addComponent(jButton4)
                    .addComponent(SysMasterBPMAdj, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addGroup(SystemPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.CENTER)
                    .addComponent(jLabel8)
                    .addComponent(SysDeclicking)
                    .addComponent(jLabel10)
                    .addComponent(SysDeclickingLenSlider, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                .addContainerGap(110, Short.MAX_VALUE))
        );

        SysTab.addTab(resourceMap.getString("Audio.TabConstraints.tabTitle"), SystemPanel); // NOI18N

        SysDSPPanel.setName("SysDSPPanel"); // NOI18N

        SysDspMixVolumeSlider.setMajorTickSpacing(10);
        SysDspMixVolumeSlider.setMinorTickSpacing(5);
        SysDspMixVolumeSlider.setPaintLabels(true);
        SysDspMixVolumeSlider.setPaintTicks(true);
        SysDspMixVolumeSlider.setValue(75);
        SysDspMixVolumeSlider.setName("SysDspMixVolumeSlider"); // NOI18N
        SysDspMixVolumeSlider.addChangeListener(new javax.swing.event.ChangeListener() {
            public void stateChanged(javax.swing.event.ChangeEvent evt) {
                SysDspMixVolumeSliderStateChanged(evt);
            }
        });

        SysDspFxTypeCombox.setModel(new javax.swing.DefaultComboBoxModel(new String[] { "Off", "Echo", "CrossEcho", "Delay", "CrossDelay" }));
        SysDspFxTypeCombox.setName("SysDspFxTypeCombox"); // NOI18N
        SysDspFxTypeCombox.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                SysDspFxTypeComboxActionPerformed(evt);
            }
        });

        jLabel11.setText(resourceMap.getString("jLabel11.text")); // NOI18N
        jLabel11.setName("jLabel11"); // NOI18N

        jLabel12.setText(resourceMap.getString("jLabel12.text")); // NOI18N
        jLabel12.setName("jLabel12"); // NOI18N

        jLabel13.setText(resourceMap.getString("jLabel13.text")); // NOI18N
        jLabel13.setName("jLabel13"); // NOI18N

        SysDspFeedback.setBackground(resourceMap.getColor("SysDspFeedback.background")); // NOI18N
        SysDspFeedback.setMajorTickSpacing(10);
        SysDspFeedback.setMaximum(99);
        SysDspFeedback.setMinorTickSpacing(5);
        SysDspFeedback.setPaintLabels(true);
        SysDspFeedback.setPaintTicks(true);
        SysDspFeedback.setName("SysDspFeedback"); // NOI18N
        SysDspFeedback.addChangeListener(new javax.swing.event.ChangeListener() {
            public void stateChanged(javax.swing.event.ChangeEvent evt) {
                SysDspFeedbackStateChanged(evt);
            }
        });

        jLabel14.setText(resourceMap.getString("jLabel14.text")); // NOI18N
        jLabel14.setName("jLabel14"); // NOI18N

        SysDspLength.setMajorTickSpacing(10);
        SysDspLength.setMinimum(10);
        SysDspLength.setMinorTickSpacing(5);
        SysDspLength.setPaintLabels(true);
        SysDspLength.setPaintTicks(true);
        SysDspLength.setValue(100);
        SysDspLength.setName("SysDspLength"); // NOI18N
        SysDspLength.addChangeListener(new javax.swing.event.ChangeListener() {
            public void stateChanged(javax.swing.event.ChangeEvent evt) {
                SysDspLengthStateChanged(evt);
            }
        });

        SysDspLPFilter.setText(resourceMap.getString("SysDspLPFilter.text")); // NOI18N
        SysDspLPFilter.setEnabled(false);
        SysDspLPFilter.setName("SysDspLPFilter"); // NOI18N

        SysDspPreDelay.setMajorTickSpacing(10);
        SysDspPreDelay.setMinorTickSpacing(5);
        SysDspPreDelay.setPaintLabels(true);
        SysDspPreDelay.setPaintTicks(true);
        SysDspPreDelay.setValue(99);
        SysDspPreDelay.setName("SysDspPreDelay"); // NOI18N
        SysDspPreDelay.addChangeListener(new javax.swing.event.ChangeListener() {
            public void stateChanged(javax.swing.event.ChangeEvent evt) {
                SysDspPreDelayStateChanged(evt);
            }
        });

        jLabel15.setText(resourceMap.getString("jLabel15.text")); // NOI18N
        jLabel15.setName("jLabel15"); // NOI18N

        jLabel16.setForeground(resourceMap.getColor("jLabel16.foreground")); // NOI18N
        jLabel16.setText(resourceMap.getString("jLabel16.text")); // NOI18N
        jLabel16.setName("jLabel16"); // NOI18N

        SysSyncToBeat.setText(resourceMap.getString("SysSyncToBeat.text")); // NOI18N
        SysSyncToBeat.setName("SysSyncToBeat"); // NOI18N
        SysSyncToBeat.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                SysSyncToBeatActionPerformed(evt);
            }
        });

        jLabel18.setBorder(javax.swing.BorderFactory.createEtchedBorder());
        jLabel18.setName("jLabel18"); // NOI18N

        binding = org.jdesktop.beansbinding.Bindings.createAutoBinding(org.jdesktop.beansbinding.AutoBinding.UpdateStrategy.READ_WRITE, SysDspLength, org.jdesktop.beansbinding.ELProperty.create("${value}"), jLabel18, org.jdesktop.beansbinding.BeanProperty.create("text"));
        bindingGroup.addBinding(binding);

        javax.swing.GroupLayout SysDSPPanelLayout = new javax.swing.GroupLayout(SysDSPPanel);
        SysDSPPanel.setLayout(SysDSPPanelLayout);
        SysDSPPanelLayout.setHorizontalGroup(
            SysDSPPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(SysDSPPanelLayout.createSequentialGroup()
                .addContainerGap()
                .addGroup(SysDSPPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addComponent(jLabel12)
                    .addComponent(jLabel11)
                    .addComponent(jLabel14)
                    .addComponent(jLabel13)
                    .addComponent(jLabel15))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addGroup(SysDSPPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addComponent(SysDspPreDelay, javax.swing.GroupLayout.DEFAULT_SIZE, 345, Short.MAX_VALUE)
                    .addComponent(SysDspFeedback, javax.swing.GroupLayout.DEFAULT_SIZE, 345, Short.MAX_VALUE)
                    .addComponent(SysDspMixVolumeSlider, javax.swing.GroupLayout.DEFAULT_SIZE, 345, Short.MAX_VALUE)
                    .addGroup(SysDSPPanelLayout.createSequentialGroup()
                        .addComponent(jLabel18, javax.swing.GroupLayout.PREFERRED_SIZE, 35, javax.swing.GroupLayout.PREFERRED_SIZE)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addComponent(SysDspLength, javax.swing.GroupLayout.DEFAULT_SIZE, 306, Short.MAX_VALUE)))
                .addGap(20, 20, 20))
            .addGroup(SysDSPPanelLayout.createSequentialGroup()
                .addGap(85, 85, 85)
                .addComponent(SysDspFxTypeCombox, javax.swing.GroupLayout.PREFERRED_SIZE, 106, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED, 99, Short.MAX_VALUE)
                .addComponent(jLabel16))
            .addGroup(SysDSPPanelLayout.createSequentialGroup()
                .addGap(10, 10, 10)
                .addComponent(SysDspLPFilter)
                .addGap(18, 18, 18)
                .addComponent(SysSyncToBeat)
                .addContainerGap(260, Short.MAX_VALUE))
        );
        SysDSPPanelLayout.setVerticalGroup(
            SysDSPPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(SysDSPPanelLayout.createSequentialGroup()
                .addGroup(SysDSPPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addGroup(SysDSPPanelLayout.createSequentialGroup()
                        .addContainerGap()
                        .addGroup(SysDSPPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                            .addComponent(jLabel11)
                            .addComponent(SysDspFxTypeCombox, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)))
                    .addComponent(jLabel16))
                .addGroup(SysDSPPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addGroup(SysDSPPanelLayout.createSequentialGroup()
                        .addGap(9, 9, 9)
                        .addComponent(jLabel12))
                    .addGroup(SysDSPPanelLayout.createSequentialGroup()
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addComponent(SysDspMixVolumeSlider, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addGroup(SysDSPPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addComponent(jLabel13)
                    .addComponent(SysDspFeedback, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                .addGap(19, 19, 19)
                .addGroup(SysDSPPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addGroup(SysDSPPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                        .addComponent(jLabel14)
                        .addComponent(jLabel18, javax.swing.GroupLayout.PREFERRED_SIZE, 31, javax.swing.GroupLayout.PREFERRED_SIZE))
                    .addComponent(SysDspLength, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addGroup(SysDSPPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addComponent(jLabel15)
                    .addComponent(SysDspPreDelay, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                .addGroup(SysDSPPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(SysDspLPFilter)
                    .addComponent(SysSyncToBeat))
                .addGap(95, 95, 95))
        );

        SysTab.addTab(resourceMap.getString("SysDSPPanel.TabConstraints.tabTitle"), SysDSPPanel); // NOI18N

        SysSoundDesignPanel.setName("SysSoundDesignPanel"); // NOI18N

        jLabel1.setFont(resourceMap.getFont("jLabel1.font")); // NOI18N
        jLabel1.setText(resourceMap.getString("jLabel1.text")); // NOI18N
        jLabel1.setName("jLabel1"); // NOI18N

        jLabel2.setText(resourceMap.getString("jLabel2.text")); // NOI18N
        jLabel2.setName("jLabel2"); // NOI18N

        SysSampleDiff.setMajorTickSpacing(50);
        SysSampleDiff.setMaximum(500);
        SysSampleDiff.setMinorTickSpacing(25);
        SysSampleDiff.setPaintLabels(true);
        SysSampleDiff.setPaintTicks(true);
        SysSampleDiff.setValue(0);
        SysSampleDiff.setName("SysSampleDiff"); // NOI18N
        SysSampleDiff.addChangeListener(new javax.swing.event.ChangeListener() {
            public void stateChanged(javax.swing.event.ChangeEvent evt) {
                SysSampleDiffStateChanged(evt);
            }
        });

        SysPitchDiff.setMajorTickSpacing(10);
        SysPitchDiff.setMinorTickSpacing(5);
        SysPitchDiff.setPaintLabels(true);
        SysPitchDiff.setPaintTicks(true);
        SysPitchDiff.setValue(0);
        SysPitchDiff.setName("SysPitchDiff"); // NOI18N
        SysPitchDiff.addChangeListener(new javax.swing.event.ChangeListener() {
            public void stateChanged(javax.swing.event.ChangeEvent evt) {
                SysPitchDiffStateChanged(evt);
            }
        });

        jLabel3.setText(resourceMap.getString("jLabel3.text")); // NOI18N
        jLabel3.setName("jLabel3"); // NOI18N

        jLabel19.setFont(resourceMap.getFont("jLabel19.font")); // NOI18N
        jLabel19.setText(resourceMap.getString("jLabel19.text")); // NOI18N
        jLabel19.setEnabled(false);
        jLabel19.setName("jLabel19"); // NOI18N

        jCheckBox1.setText(resourceMap.getString("jCheckBox1.text")); // NOI18N
        jCheckBox1.setEnabled(false);
        jCheckBox1.setName("jCheckBox1"); // NOI18N

        jCheckBox2.setText(resourceMap.getString("jCheckBox2.text")); // NOI18N
        jCheckBox2.setEnabled(false);
        jCheckBox2.setName("jCheckBox2"); // NOI18N

        SysPitchDiff2.setPaintLabels(true);
        SysPitchDiff2.setPaintTicks(true);
        SysPitchDiff2.setValue(0);
        SysPitchDiff2.setEnabled(false);
        SysPitchDiff2.setName("SysPitchDiff2"); // NOI18N

        SysDitheringCombox.setModel(new javax.swing.DefaultComboBoxModel(new String[] { "Off", "Random" }));
        SysDitheringCombox.setName("SysDitheringCombox"); // NOI18N
        SysDitheringCombox.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                SysDitheringComboxActionPerformed(evt);
            }
        });

        jLabel9.setText(resourceMap.getString("jLabel9.text")); // NOI18N
        jLabel9.setName("jLabel9"); // NOI18N

        SysInterpolationType.setModel(new javax.swing.DefaultComboBoxModel(new String[] { "Off (fastest)", "Linear", "Cubic", "Cosinus", "Bicubic Hermite (best)" }));
        SysInterpolationType.setSelectedIndex(2);
        SysInterpolationType.setName("SysInterpolationType"); // NOI18N
        SysInterpolationType.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                SysInterpolationTypeActionPerformed(evt);
            }
        });

        jLabel4.setText(resourceMap.getString("jLabel4.text")); // NOI18N
        jLabel4.setName("jLabel4"); // NOI18N

        javax.swing.GroupLayout SysSoundDesignPanelLayout = new javax.swing.GroupLayout(SysSoundDesignPanel);
        SysSoundDesignPanel.setLayout(SysSoundDesignPanelLayout);
        SysSoundDesignPanelLayout.setHorizontalGroup(
            SysSoundDesignPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(SysSoundDesignPanelLayout.createSequentialGroup()
                .addContainerGap()
                .addGroup(SysSoundDesignPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addGroup(SysSoundDesignPanelLayout.createSequentialGroup()
                        .addComponent(jCheckBox1)
                        .addGap(18, 18, 18)
                        .addComponent(jCheckBox2)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addComponent(SysPitchDiff2, javax.swing.GroupLayout.DEFAULT_SIZE, 290, Short.MAX_VALUE))
                    .addComponent(jLabel1)
                    .addGroup(SysSoundDesignPanelLayout.createSequentialGroup()
                        .addGroup(SysSoundDesignPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                            .addComponent(jLabel2)
                            .addComponent(jLabel3))
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addGroup(SysSoundDesignPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                            .addComponent(SysSampleDiff, javax.swing.GroupLayout.DEFAULT_SIZE, 360, Short.MAX_VALUE)
                            .addComponent(SysPitchDiff, javax.swing.GroupLayout.DEFAULT_SIZE, 360, Short.MAX_VALUE)))
                    .addComponent(jLabel19)
                    .addGroup(SysSoundDesignPanelLayout.createSequentialGroup()
                        .addComponent(jLabel4)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addComponent(SysInterpolationType, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                        .addGap(38, 38, 38)
                        .addComponent(jLabel9)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addComponent(SysDitheringCombox, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)))
                .addContainerGap())
        );
        SysSoundDesignPanelLayout.setVerticalGroup(
            SysSoundDesignPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(SysSoundDesignPanelLayout.createSequentialGroup()
                .addContainerGap()
                .addComponent(jLabel1)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addGroup(SysSoundDesignPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addComponent(jLabel2)
                    .addComponent(SysSampleDiff, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addGroup(SysSoundDesignPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addComponent(jLabel3)
                    .addComponent(SysPitchDiff, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                .addGroup(SysSoundDesignPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addGroup(SysSoundDesignPanelLayout.createSequentialGroup()
                        .addGap(18, 18, 18)
                        .addComponent(jLabel19)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addGroup(SysSoundDesignPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                            .addComponent(jCheckBox1)
                            .addComponent(jCheckBox2)))
                    .addGroup(SysSoundDesignPanelLayout.createSequentialGroup()
                        .addGap(34, 34, 34)
                        .addComponent(SysPitchDiff2, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)))
                .addGap(18, 18, 18)
                .addGroup(SysSoundDesignPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addGroup(SysSoundDesignPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                        .addComponent(jLabel4)
                        .addComponent(SysInterpolationType, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                    .addGroup(SysSoundDesignPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                        .addComponent(jLabel9)
                        .addComponent(SysDitheringCombox, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)))
                .addContainerGap(122, Short.MAX_VALUE))
        );

        SysTab.addTab(resourceMap.getString("SysSoundDesignPanel.TabConstraints.tabTitle"), SysSoundDesignPanel); // NOI18N

        SysUpdatePanel.setName("SysUpdatePanel"); // NOI18N

        SysUpdateSamplePos.setSelected(true);
        SysUpdateSamplePos.setText(resourceMap.getString("SysUpdateSamplePos.text")); // NOI18N
        SysUpdateSamplePos.setName("SysUpdateSamplePos"); // NOI18N
        SysUpdateSamplePos.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                SysUpdateSamplePosActionPerformed(evt);
            }
        });

        SysUpdatePatternNr.setSelected(true);
        SysUpdatePatternNr.setText(resourceMap.getString("SysUpdatePatternNr.text")); // NOI18N
        SysUpdatePatternNr.setName("SysUpdatePatternNr"); // NOI18N

        SysUpdateCrsr.setSelected(true);
        SysUpdateCrsr.setText(resourceMap.getString("SysUpdateCrsr.text")); // NOI18N
        SysUpdateCrsr.setName("SysUpdateCrsr"); // NOI18N

        SysUpdateInstr.setText(resourceMap.getString("SysUpdateInstr.text")); // NOI18N
        SysUpdateInstr.setName("SysUpdateInstr"); // NOI18N

        javax.swing.GroupLayout SysUpdatePanelLayout = new javax.swing.GroupLayout(SysUpdatePanel);
        SysUpdatePanel.setLayout(SysUpdatePanelLayout);
        SysUpdatePanelLayout.setHorizontalGroup(
            SysUpdatePanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(SysUpdatePanelLayout.createSequentialGroup()
                .addContainerGap()
                .addGroup(SysUpdatePanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addComponent(SysUpdateSamplePos)
                    .addComponent(SysUpdatePatternNr)
                    .addComponent(SysUpdateCrsr)
                    .addComponent(SysUpdateInstr))
                .addContainerGap(271, Short.MAX_VALUE))
        );
        SysUpdatePanelLayout.setVerticalGroup(
            SysUpdatePanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(SysUpdatePanelLayout.createSequentialGroup()
                .addContainerGap()
                .addComponent(SysUpdateSamplePos)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(SysUpdatePatternNr)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(SysUpdateCrsr)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(SysUpdateInstr)
                .addContainerGap(259, Short.MAX_VALUE))
        );

        SysTab.addTab(resourceMap.getString("SysUpdatePanel.TabConstraints.tabTitle"), SysUpdatePanel); // NOI18N

        SysLoadingPanel.setName("SysLoadingPanel"); // NOI18N

        SysLoadModDeactivateDsp.setText(resourceMap.getString("SysLoadModDeactivateDsp.text")); // NOI18N
        SysLoadModDeactivateDsp.setName("SysLoadModDeactivateDsp"); // NOI18N
        SysLoadModDeactivateDsp.addChangeListener(new javax.swing.event.ChangeListener() {
            public void stateChanged(javax.swing.event.ChangeEvent evt) {
                SysLoadModDeactivateDspStateChanged(evt);
            }
        });

        javax.swing.GroupLayout SysLoadingPanelLayout = new javax.swing.GroupLayout(SysLoadingPanel);
        SysLoadingPanel.setLayout(SysLoadingPanelLayout);
        SysLoadingPanelLayout.setHorizontalGroup(
            SysLoadingPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(SysLoadingPanelLayout.createSequentialGroup()
                .addContainerGap()
                .addComponent(SysLoadModDeactivateDsp)
                .addContainerGap(205, Short.MAX_VALUE))
        );
        SysLoadingPanelLayout.setVerticalGroup(
            SysLoadingPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(SysLoadingPanelLayout.createSequentialGroup()
                .addContainerGap()
                .addComponent(SysLoadModDeactivateDsp)
                .addContainerGap(328, Short.MAX_VALUE))
        );

        SysTab.addTab(resourceMap.getString("SysLoadingPanel.TabConstraints.tabTitle"), SysLoadingPanel); // NOI18N

        jScrollPane1.setHorizontalScrollBarPolicy(javax.swing.ScrollPaneConstants.HORIZONTAL_SCROLLBAR_ALWAYS);
        jScrollPane1.setVerticalScrollBarPolicy(javax.swing.ScrollPaneConstants.VERTICAL_SCROLLBAR_ALWAYS);
        jScrollPane1.setName("jScrollPane1"); // NOI18N

        jList1.setFont(resourceMap.getFont("jList1.font")); // NOI18N
        jList1.setModel(new javax.swing.AbstractListModel() {
            String[] strings = { ">>> Load a Song Module (*.SymMod)" };
            public int getSize() { return strings.length; }
            public Object getElementAt(int i) { return strings[i]; }
        });
        jList1.setFixedCellHeight(8);
        jList1.setName("jList1"); // NOI18N
        jScrollPane1.setViewportView(jList1);

        SysTab.addTab(resourceMap.getString("jScrollPane1.TabConstraints.tabTitle"), jScrollPane1); // NOI18N
        jScrollPane1.getAccessibleContext().setAccessibleParent(SysTab);

        jPanel1.setName("jPanel1"); // NOI18N

        PEDDisplayMouseCrsr.setText(resourceMap.getString("PEDDisplayMouseCrsr.text")); // NOI18N
        PEDDisplayMouseCrsr.setName("PEDDisplayMouseCrsr"); // NOI18N
        PEDDisplayMouseCrsr.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                PEDDisplayMouseCrsrActionPerformed(evt);
            }
        });

        javax.swing.GroupLayout jPanel1Layout = new javax.swing.GroupLayout(jPanel1);
        jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(
            jPanel1Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(jPanel1Layout.createSequentialGroup()
                .addContainerGap()
                .addComponent(PEDDisplayMouseCrsr)
                .addContainerGap(315, Short.MAX_VALUE))
        );
        jPanel1Layout.setVerticalGroup(
            jPanel1Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(jPanel1Layout.createSequentialGroup()
                .addContainerGap()
                .addComponent(PEDDisplayMouseCrsr)
                .addContainerGap(328, Short.MAX_VALUE))
        );

        SysTab.addTab(resourceMap.getString("jPanel1.TabConstraints.tabTitle"), jPanel1); // NOI18N

        MenuBar.setFloatable(false);
        MenuBar.setRollover(true);
        MenuBar.setName("MenuBar"); // NOI18N

        playSongButton.setFont(resourceMap.getFont("playSongButton.font")); // NOI18N
        playSongButton.setText(resourceMap.getString("playSongButton.text")); // NOI18N
        playSongButton.setBorder(new javax.swing.border.SoftBevelBorder(javax.swing.border.BevelBorder.RAISED));
        playSongButton.setFocusable(false);
        playSongButton.setHorizontalTextPosition(javax.swing.SwingConstants.CENTER);
        playSongButton.setName("playSongButton"); // NOI18N
        playSongButton.setVerticalTextPosition(javax.swing.SwingConstants.BOTTOM);
        playSongButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                playSongButtonActionPerformed(evt);
            }
        });
        MenuBar.add(playSongButton);

        stopSongButton.setForeground(resourceMap.getColor("stopSongButton.foreground")); // NOI18N
        stopSongButton.setText(resourceMap.getString("stopSongButton.text")); // NOI18N
        stopSongButton.setBorder(new javax.swing.border.SoftBevelBorder(javax.swing.border.BevelBorder.RAISED));
        stopSongButton.setFocusable(false);
        stopSongButton.setHorizontalTextPosition(javax.swing.SwingConstants.CENTER);
        stopSongButton.setName("stopSongButton"); // NOI18N
        stopSongButton.setVerticalTextPosition(javax.swing.SwingConstants.BOTTOM);
        stopSongButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                stopSongButtonActionPerformed(evt);
            }
        });
        MenuBar.add(stopSongButton);

        jButton1.setText(resourceMap.getString("jButton1.text")); // NOI18N
        jButton1.setBorder(new javax.swing.border.SoftBevelBorder(javax.swing.border.BevelBorder.RAISED));
        jButton1.setFocusable(false);
        jButton1.setHorizontalTextPosition(javax.swing.SwingConstants.CENTER);
        jButton1.setName("jButton1"); // NOI18N
        jButton1.setVerticalTextPosition(javax.swing.SwingConstants.BOTTOM);
        jButton1.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jButton1ActionPerformed(evt);
            }
        });
        MenuBar.add(jButton1);

        SymLoad.setFont(resourceMap.getFont("SymLoad.font")); // NOI18N
        SymLoad.setForeground(resourceMap.getColor("SymLoad.foreground")); // NOI18N
        SymLoad.setText(resourceMap.getString("SymLoad.text")); // NOI18N
        SymLoad.setBorder(new javax.swing.border.SoftBevelBorder(javax.swing.border.BevelBorder.RAISED));
        SymLoad.setFocusable(false);
        SymLoad.setHorizontalTextPosition(javax.swing.SwingConstants.CENTER);
        SymLoad.setName("SymLoad"); // NOI18N
        SymLoad.setVerticalTextPosition(javax.swing.SwingConstants.BOTTOM);
        SymLoad.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                SymLoadActionPerformed(evt);
            }
        });
        MenuBar.add(SymLoad);

        playPatternButton.setText(resourceMap.getString("playPatternButton.text")); // NOI18N
        playPatternButton.setBorder(new javax.swing.border.SoftBevelBorder(javax.swing.border.BevelBorder.RAISED));
        playPatternButton.setFocusable(false);
        playPatternButton.setHorizontalTextPosition(javax.swing.SwingConstants.CENTER);
        playPatternButton.setName("playPatternButton"); // NOI18N
        playPatternButton.setVerticalTextPosition(javax.swing.SwingConstants.BOTTOM);
        playPatternButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                playPatternButtonActionPerformed(evt);
            }
        });
        MenuBar.add(playPatternButton);

        SysStatusLabel.setBorder(javax.swing.BorderFactory.createEtchedBorder());
        SysStatusLabel.setName("SysStatusLabel"); // NOI18N

        javax.swing.GroupLayout mainPanelLayout = new javax.swing.GroupLayout(mainPanel);
        mainPanel.setLayout(mainPanelLayout);
        mainPanelLayout.setHorizontalGroup(
            mainPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(javax.swing.GroupLayout.Alignment.TRAILING, mainPanelLayout.createSequentialGroup()
                .addComponent(MenuBar, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                .addGap(84, 84, 84))
            .addGroup(javax.swing.GroupLayout.Alignment.TRAILING, mainPanelLayout.createSequentialGroup()
                .addContainerGap()
                .addComponent(SysStatusLabel, javax.swing.GroupLayout.DEFAULT_SIZE, 423, Short.MAX_VALUE)
                .addContainerGap())
            .addComponent(SysTab, javax.swing.GroupLayout.DEFAULT_SIZE, 443, Short.MAX_VALUE)
        );
        mainPanelLayout.setVerticalGroup(
            mainPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(mainPanelLayout.createSequentialGroup()
                .addComponent(MenuBar, javax.swing.GroupLayout.PREFERRED_SIZE, 25, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(SysTab, javax.swing.GroupLayout.DEFAULT_SIZE, 386, Short.MAX_VALUE)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(SysStatusLabel, javax.swing.GroupLayout.PREFERRED_SIZE, 15, javax.swing.GroupLayout.PREFERRED_SIZE))
        );

        SysTab.getAccessibleContext().setAccessibleName(resourceMap.getString("SysTab.AccessibleContext.accessibleName")); // NOI18N

        menuBar.setName("menuBar"); // NOI18N

        fileMenu.setText(resourceMap.getString("fileMenu.text")); // NOI18N
        fileMenu.setName("fileMenu"); // NOI18N

        loadModMenuItem.setAccelerator(javax.swing.KeyStroke.getKeyStroke(java.awt.event.KeyEvent.VK_M, java.awt.event.InputEvent.CTRL_MASK));
        loadModMenuItem.setText(resourceMap.getString("loadModMenuItem.text")); // NOI18N
        loadModMenuItem.setName("loadModMenuItem"); // NOI18N
        loadModMenuItem.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                loadModMenuItemActionPerformed(evt);
            }
        });
        fileMenu.add(loadModMenuItem);

        loadSampleMenuItem.setAccelerator(javax.swing.KeyStroke.getKeyStroke(java.awt.event.KeyEvent.VK_S, java.awt.event.InputEvent.ALT_MASK));
        loadSampleMenuItem.setText(resourceMap.getString("loadSampleMenuItem.text")); // NOI18N
        loadSampleMenuItem.setName("loadSampleMenuItem"); // NOI18N
        loadSampleMenuItem.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                loadSampleMenuItemActionPerformed(evt);
            }
        });
        fileMenu.add(loadSampleMenuItem);

        newSongMenuItem.setAccelerator(javax.swing.KeyStroke.getKeyStroke(java.awt.event.KeyEvent.VK_N, java.awt.event.InputEvent.CTRL_MASK));
        newSongMenuItem.setText(resourceMap.getString("newSongMenuItem.text")); // NOI18N
        newSongMenuItem.setName("newSongMenuItem"); // NOI18N
        newSongMenuItem.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                newSongMenuItemActionPerformed(evt);
            }
        });
        fileMenu.add(newSongMenuItem);

        jMenuItem1.setAccelerator(javax.swing.KeyStroke.getKeyStroke(java.awt.event.KeyEvent.VK_S, java.awt.event.InputEvent.CTRL_MASK));
        jMenuItem1.setText(resourceMap.getString("jMenuItem1.text")); // NOI18N
        jMenuItem1.setName("jMenuItem1"); // NOI18N
        jMenuItem1.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jMenuItem1ActionPerformed(evt);
            }
        });
        fileMenu.add(jMenuItem1);

        jMenuItem2.setAccelerator(javax.swing.KeyStroke.getKeyStroke(java.awt.event.KeyEvent.VK_L, java.awt.event.InputEvent.CTRL_MASK));
        jMenuItem2.setText(resourceMap.getString("jMenuItem2.text")); // NOI18N
        jMenuItem2.setActionCommand(resourceMap.getString("jMenuItem2.actionCommand")); // NOI18N
        jMenuItem2.setName("jMenuItem2"); // NOI18N
        jMenuItem2.addChangeListener(new javax.swing.event.ChangeListener() {
            public void stateChanged(javax.swing.event.ChangeEvent evt) {
                jMenuItem2StateChanged(evt);
            }
        });
        jMenuItem2.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jMenuItem2ActionPerformed(evt);
            }
        });
        fileMenu.add(jMenuItem2);

        javax.swing.ActionMap actionMap = org.jdesktop.application.Application.getInstance(symreader.SymReaderApp.class).getContext().getActionMap(SymReaderView.class, this);
        exitMenuItem.setAction(actionMap.get("quit")); // NOI18N
        exitMenuItem.setText(resourceMap.getString("exitMenuItem.text")); // NOI18N
        exitMenuItem.setName("exitMenuItem"); // NOI18N
        exitMenuItem.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                exitMenuItemActionPerformed(evt);
            }
        });
        fileMenu.add(exitMenuItem);

        menuBar.add(fileMenu);

        helpMenu.setText(resourceMap.getString("helpMenu.text")); // NOI18N
        helpMenu.setName("helpMenu"); // NOI18N

        aboutMenuItem.setAction(actionMap.get("showAboutBox")); // NOI18N
        aboutMenuItem.setName("aboutMenuItem"); // NOI18N
        helpMenu.add(aboutMenuItem);

        menuBar.add(helpMenu);

        frmInstrList.setTitle(resourceMap.getString("frmInstrList.title")); // NOI18N
        frmInstrList.setBounds(new java.awt.Rectangle(0, 0, 320, 320));
        frmInstrList.setName("frmInstrList"); // NOI18N

        jScrollPane2.setName("jScrollPane2"); // NOI18N

        InstrList.setModel(new javax.swing.AbstractListModel() {
            String[] strings = { "Item 1", "Item 2", "Item 3", "Item 4", "Item 5" };
            public int getSize() { return strings.length; }
            public Object getElementAt(int i) { return strings[i]; }
        });
        InstrList.setSelectionMode(javax.swing.ListSelectionModel.SINGLE_SELECTION);
        InstrList.setName("InstrList"); // NOI18N
        InstrList.addMouseListener(new java.awt.event.MouseAdapter() {
            public void mouseClicked(java.awt.event.MouseEvent evt) {
                InstrListMouseClicked(evt);
            }
            public void mouseReleased(java.awt.event.MouseEvent evt) {
                InstrListMouseReleased(evt);
            }
        });
        InstrList.addListSelectionListener(new javax.swing.event.ListSelectionListener() {
            public void valueChanged(javax.swing.event.ListSelectionEvent evt) {
                InstrListValueChanged(evt);
            }
        });
        InstrList.addKeyListener(new java.awt.event.KeyAdapter() {
            public void keyTyped(java.awt.event.KeyEvent evt) {
                InstrListKeyTyped(evt);
            }
        });
        jScrollPane2.setViewportView(InstrList);

        javax.swing.GroupLayout frmInstrListLayout = new javax.swing.GroupLayout(frmInstrList.getContentPane());
        frmInstrList.getContentPane().setLayout(frmInstrListLayout);
        frmInstrListLayout.setHorizontalGroup(
            frmInstrListLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(frmInstrListLayout.createSequentialGroup()
                .addContainerGap()
                .addComponent(jScrollPane2, javax.swing.GroupLayout.DEFAULT_SIZE, 189, Short.MAX_VALUE)
                .addContainerGap())
        );
        frmInstrListLayout.setVerticalGroup(
            frmInstrListLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(frmInstrListLayout.createSequentialGroup()
                .addContainerGap()
                .addComponent(jScrollPane2, javax.swing.GroupLayout.DEFAULT_SIZE, 425, Short.MAX_VALUE)
                .addContainerGap())
        );

        frmInstrList.getAccessibleContext().setAccessibleParent(menuBar);

        PosListjFrame.setTitle(resourceMap.getString("PosListjFrame.title")); // NOI18N
        PosListjFrame.setMinimumSize(new java.awt.Dimension(50, 50));
        PosListjFrame.setName("PosListjFrame"); // NOI18N

        PosListPane.setName("PosListPane"); // NOI18N

        PosListJList.setModel(new javax.swing.AbstractListModel() {
            String[] strings = { "Item 1", "Item 2", "Item 3", "Item 4", "Item 5" };
            public int getSize() { return strings.length; }
            public Object getElementAt(int i) { return strings[i]; }
        });
        PosListJList.setSelectionMode(javax.swing.ListSelectionModel.SINGLE_SELECTION);
        PosListJList.setMinimumSize(new java.awt.Dimension(320, 320));
        PosListJList.setName("PosListJList"); // NOI18N
        PosListJList.addMouseListener(new java.awt.event.MouseAdapter() {
            public void mouseClicked(java.awt.event.MouseEvent evt) {
                PosListJListMouseClicked(evt);
            }
        });
        PosListPane.setViewportView(PosListJList);

        javax.swing.GroupLayout PosListjFrameLayout = new javax.swing.GroupLayout(PosListjFrame.getContentPane());
        PosListjFrame.getContentPane().setLayout(PosListjFrameLayout);
        PosListjFrameLayout.setHorizontalGroup(
            PosListjFrameLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(PosListjFrameLayout.createSequentialGroup()
                .addContainerGap()
                .addComponent(PosListPane, javax.swing.GroupLayout.DEFAULT_SIZE, 202, Short.MAX_VALUE)
                .addContainerGap())
        );
        PosListjFrameLayout.setVerticalGroup(
            PosListjFrameLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(PosListjFrameLayout.createSequentialGroup()
                .addContainerGap()
                .addComponent(PosListPane, javax.swing.GroupLayout.DEFAULT_SIZE, 260, Short.MAX_VALUE)
                .addContainerGap())
        );

        PosEdFrame.setTitle(resourceMap.getString("PosEdFrame.title")); // NOI18N
        PosEdFrame.setName("PosEdFrame"); // NOI18N

        PosEdTab.setName("PosEdTab"); // NOI18N

        PosEdMainPanel.setName("PosEdMainPanel"); // NOI18N

        jLabel20.setText(resourceMap.getString("jLabel20.text")); // NOI18N
        jLabel20.setName("jLabel20"); // NOI18N

        jLabel21.setText(resourceMap.getString("jLabel21.text")); // NOI18N
        jLabel21.setName("jLabel21"); // NOI18N

        jLabel23.setText(resourceMap.getString("jLabel23.text")); // NOI18N
        jLabel23.setName("jLabel23"); // NOI18N

        PosEdNr.setName("PosEdNr"); // NOI18N
        PosEdNr.addChangeListener(new javax.swing.event.ChangeListener() {
            public void stateChanged(javax.swing.event.ChangeEvent evt) {
                PosEdNrStateChanged(evt);
            }
        });

        jLabel24.setText(resourceMap.getString("jLabel24.text")); // NOI18N
        jLabel24.setName("jLabel24"); // NOI18N

        PosEdPatternNr.setName("PosEdPatternNr"); // NOI18N
        PosEdPatternNr.addChangeListener(new javax.swing.event.ChangeListener() {
            public void stateChanged(javax.swing.event.ChangeEvent evt) {
                PosEdPatternNrStateChanged(evt);
            }
        });

        PosEdStart.setName("PosEdStart"); // NOI18N
        PosEdStart.addChangeListener(new javax.swing.event.ChangeListener() {
            public void stateChanged(javax.swing.event.ChangeEvent evt) {
                PosEdStartStateChanged(evt);
            }
        });

        jLabel25.setText(resourceMap.getString("jLabel25.text")); // NOI18N
        jLabel25.setName("jLabel25"); // NOI18N

        PosEdLen.setName("PosEdLen"); // NOI18N
        PosEdLen.addChangeListener(new javax.swing.event.ChangeListener() {
            public void stateChanged(javax.swing.event.ChangeEvent evt) {
                PosEdLenStateChanged(evt);
            }
        });

        PosEdCycl.setName("PosEdCycl"); // NOI18N
        PosEdCycl.addChangeListener(new javax.swing.event.ChangeListener() {
            public void stateChanged(javax.swing.event.ChangeEvent evt) {
                PosEdCyclStateChanged(evt);
            }
        });

        jLabel22.setText(resourceMap.getString("jLabel22.text")); // NOI18N
        jLabel22.setName("jLabel22"); // NOI18N

        PosEdLoop.setName("PosEdLoop"); // NOI18N
        PosEdLoop.addChangeListener(new javax.swing.event.ChangeListener() {
            public void stateChanged(javax.swing.event.ChangeEvent evt) {
                PosEdLoopStateChanged(evt);
            }
        });

        jLabel26.setText(resourceMap.getString("jLabel26.text")); // NOI18N
        jLabel26.setName("jLabel26"); // NOI18N

        PosEdTune.setName("PosEdTune"); // NOI18N
        PosEdTune.addChangeListener(new javax.swing.event.ChangeListener() {
            public void stateChanged(javax.swing.event.ChangeEvent evt) {
                PosEdTuneStateChanged(evt);
            }
        });

        jLabel27.setText(resourceMap.getString("jLabel27.text")); // NOI18N
        jLabel27.setName("jLabel27"); // NOI18N

        PosEdNameText.setText(resourceMap.getString("PosEdNameText.text")); // NOI18N
        PosEdNameText.setName("PosEdNameText"); // NOI18N
        PosEdNameText.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                PosEdNameTextActionPerformed(evt);
            }
        });
        PosEdNameText.addFocusListener(new java.awt.event.FocusAdapter() {
            public void focusLost(java.awt.event.FocusEvent evt) {
                PosEdNameTextFocusLost(evt);
            }
        });
        PosEdNameText.addInputMethodListener(new java.awt.event.InputMethodListener() {
            public void caretPositionChanged(java.awt.event.InputMethodEvent evt) {
            }
            public void inputMethodTextChanged(java.awt.event.InputMethodEvent evt) {
                PosEdNameTextInputMethodTextChanged(evt);
            }
        });
        PosEdNameText.addVetoableChangeListener(new java.beans.VetoableChangeListener() {
            public void vetoableChange(java.beans.PropertyChangeEvent evt)throws java.beans.PropertyVetoException {
                PosEdNameTextVetoableChange(evt);
            }
        });

        javax.swing.GroupLayout PosEdMainPanelLayout = new javax.swing.GroupLayout(PosEdMainPanel);
        PosEdMainPanel.setLayout(PosEdMainPanelLayout);
        PosEdMainPanelLayout.setHorizontalGroup(
            PosEdMainPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(PosEdMainPanelLayout.createSequentialGroup()
                .addGroup(PosEdMainPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addComponent(jLabel20)
                    .addComponent(jLabel21)
                    .addComponent(jLabel23)
                    .addComponent(jLabel26)
                    .addComponent(jLabel27))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addGroup(PosEdMainPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addGroup(PosEdMainPanelLayout.createSequentialGroup()
                        .addGroup(PosEdMainPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING, false)
                            .addComponent(PosEdTune, javax.swing.GroupLayout.PREFERRED_SIZE, 57, javax.swing.GroupLayout.PREFERRED_SIZE)
                            .addComponent(PosEdCycl, javax.swing.GroupLayout.DEFAULT_SIZE, 57, Short.MAX_VALUE)
                            .addComponent(PosEdStart, javax.swing.GroupLayout.DEFAULT_SIZE, 57, Short.MAX_VALUE)
                            .addComponent(PosEdNr, javax.swing.GroupLayout.DEFAULT_SIZE, 57, Short.MAX_VALUE))
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addGroup(PosEdMainPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                            .addComponent(jLabel24)
                            .addComponent(jLabel25)
                            .addComponent(jLabel22))
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addGroup(PosEdMainPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING, false)
                            .addComponent(PosEdPatternNr, javax.swing.GroupLayout.DEFAULT_SIZE, 41, Short.MAX_VALUE)
                            .addComponent(PosEdLen)
                            .addComponent(PosEdLoop))
                        .addContainerGap())
                    .addComponent(PosEdNameText, javax.swing.GroupLayout.DEFAULT_SIZE, 152, Short.MAX_VALUE)))
        );
        PosEdMainPanelLayout.setVerticalGroup(
            PosEdMainPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(PosEdMainPanelLayout.createSequentialGroup()
                .addGroup(PosEdMainPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(jLabel20)
                    .addComponent(PosEdNr, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                    .addComponent(jLabel24)
                    .addComponent(PosEdPatternNr, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addGroup(PosEdMainPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(jLabel21)
                    .addComponent(jLabel25)
                    .addComponent(PosEdLen, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                    .addComponent(PosEdStart, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addGroup(PosEdMainPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(jLabel23)
                    .addComponent(jLabel22)
                    .addComponent(PosEdLoop, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                    .addComponent(PosEdCycl, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                .addGap(18, 18, 18)
                .addGroup(PosEdMainPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(jLabel26)
                    .addComponent(PosEdTune, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addGroup(PosEdMainPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(jLabel27)
                    .addComponent(PosEdNameText, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                .addContainerGap(javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
        );

        PosEdTab.addTab(resourceMap.getString("PosEdMainPanel.TabConstraints.tabTitle"), PosEdMainPanel); // NOI18N

        PosEdToolbar.setRollover(true);
        PosEdToolbar.setName("PosEdToolbar"); // NOI18N

        jButton6.setText(resourceMap.getString("jButton6.text")); // NOI18N
        jButton6.setToolTipText(resourceMap.getString("jButton6.toolTipText")); // NOI18N
        jButton6.setFocusable(false);
        jButton6.setHorizontalTextPosition(javax.swing.SwingConstants.CENTER);
        jButton6.setName("jButton6"); // NOI18N
        jButton6.setVerticalTextPosition(javax.swing.SwingConstants.BOTTOM);
        jButton6.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jButton6ActionPerformed(evt);
            }
        });
        PosEdToolbar.add(jButton6);

        jButton7.setText(resourceMap.getString("jButton7.text")); // NOI18N
        jButton7.setFocusable(false);
        jButton7.setHorizontalTextPosition(javax.swing.SwingConstants.CENTER);
        jButton7.setName("jButton7"); // NOI18N
        jButton7.setVerticalTextPosition(javax.swing.SwingConstants.BOTTOM);
        PosEdToolbar.add(jButton7);

        jButton5.setText(resourceMap.getString("jButton5.text")); // NOI18N
        jButton5.setFocusable(false);
        jButton5.setHorizontalTextPosition(javax.swing.SwingConstants.CENTER);
        jButton5.setName("jButton5"); // NOI18N
        jButton5.setVerticalTextPosition(javax.swing.SwingConstants.BOTTOM);
        jButton5.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jButton5ActionPerformed(evt);
            }
        });
        PosEdToolbar.add(jButton5);

        javax.swing.GroupLayout PosEdFrameLayout = new javax.swing.GroupLayout(PosEdFrame.getContentPane());
        PosEdFrame.getContentPane().setLayout(PosEdFrameLayout);
        PosEdFrameLayout.setHorizontalGroup(
            PosEdFrameLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addComponent(PosEdToolbar, javax.swing.GroupLayout.DEFAULT_SIZE, 188, Short.MAX_VALUE)
            .addComponent(PosEdTab, javax.swing.GroupLayout.DEFAULT_SIZE, 188, Short.MAX_VALUE)
        );
        PosEdFrameLayout.setVerticalGroup(
            PosEdFrameLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(PosEdFrameLayout.createSequentialGroup()
                .addComponent(PosEdToolbar, javax.swing.GroupLayout.PREFERRED_SIZE, 25, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(PosEdTab, javax.swing.GroupLayout.DEFAULT_SIZE, 175, Short.MAX_VALUE))
        );

        setComponent(mainPanel);
        setMenuBar(menuBar);

        bindingGroup.bind();
    }// </editor-fold>//GEN-END:initComponents

        private void initMyComponents() {
            startUIRealTimeUpdate();
            readPreferences();
	    InitDefaultSong8Voices();
	    SymphManager.SymSong.fillPositionsToDefault();
	    SymphManager.refreshPositionsList();
	    SymphManager.refreshInstrumentList();
	    //InitDefaultSong8Voices();
	    //SymphManager.SymSong.fillPositionsToDefault();
	    
        }
    
   DefaultListModel listModel = new DefaultListModel(); 
   DefaultListModel InstrListModel = new DefaultListModel();
   DefaultListModel PosListModel = new DefaultListModel();
   
   UIManager SymphManager = new UIManager();
   VoiceExpander MyVoiceExpander = new VoiceExpander();
   ImportSongSymphonie ImportSymph; 
   
        
/* Print Info to Infopanel
*/
private void PrintToInfoWindow (String s){
    listModel.addElement(s);
}

private void PrintToInfoWindow (String s, int i){
    s = s + i;
    PrintToInfoWindow(s);
}

private void ExportInstrumentSampleRaw() {
    File f;
    FileOutputStream fo;
    int i;
    i = SymphManager.getActualInstrumentIndex();
    
    if((SymphManager.SymSong.getInstrumentIndex(i).SampleDataLoaded==true) && (i >= 0))  {
        JFileChooser jFc = new JFileChooser();
        PrintToInfoWindow("Exporting Sample Raw...");

        jFc.showSaveDialog(jFc);
        f = jFc.getSelectedFile();
        try { 
            if( f.createNewFile() == true) {
              fo = new FileOutputStream(f);
              fo.write(SymphManager.SymSong.getInstrumentIndex(i).ImportSample.RawSample);
              PrintToInfoWindow("Sample Export Done.");
            }
        } catch (java.io.IOException e) {
            PrintToInfoWindow("Error:File already exists. Aborted");
        }
        PrintToInfoWindow(f.toString());
    }
}


class UIManager {
    private int ActualInstrumentIndex = 0; // Selected Instrument on Instrument List
    private int ActualPatternNr = 0;
    byte SymphoniePatternData[];
    Song SymSong = new Song();
    frmPatternEditor PED = new frmPatternEditor();
    frmNewInstrFrame InstrED = new frmNewInstrFrame();
    
    Color LoopColor = new Color(128,128,255);
    Color WarnColorDsp1 = new Color(255,128,128);
    private VoiceExpander MyVoiceExpander = null;
    
    private String SamplePath;
    private String ModPath;
    private String NewModPath;
    
    UIManager() {
        PED.initPED(SymSong);
        PED.initUIManager(this);
        PED.setDefaultEditValues();
        InstrED.initUIManager(this);
    }
    
    //todo
    void UpdateActualInstrDetails() {
	InstrED.UpdateActualInstrDetails();
    }
    
    boolean getDrawMouseCrsr() {return(PEDDisplayMouseCrsr.isSelected());}
    
    void registerNewModPath(String s){NewModPath = s;}
    String getNewModPath(){return(NewModPath);}
    void registerModPath(String s){ModPath = s;}
    String getModPath(){return(ModPath);}
    void registerSamplePath(String s){SamplePath = s;}
    String getSamplePath(){return(SamplePath);}
    
    void LoadSample() {
	LoadNewSample(true);
    }
    
    void setBPM(float newbpm) {
	SysMasterBPM.setText(""+newbpm);
    }
    
    void setVoiceExpander(VoiceExpander theVoiceExpander) {
        MyVoiceExpander = theVoiceExpander;
    }
    VoiceExpander getVoiceExpander() {
        return(MyVoiceExpander);
    }
    
    private void addPositionList(String s) {
        PosListModel.addElement(s);   
    }
    void refreshPositionsList() {
	PosListModel.clear();
	for(int i=0;i<SymSong.getNumbOfPositions();i++) {
        Position Pos = SymSong.getPosition(i);
        if( (Pos != null) && (Pos.PatternNumbers!=null) )  {
	    addPositionList("" + i + ". Pat:" + Pos.PatternNumbers[0]
		+ " Spd:" + Pos.Speed_Cycl
		+ " Loops:" + Pos.NumbOfLoops
		+ " LineNr:" + Pos.StartRow
		+ " Len:" + Pos.RowLength
		+ " Tune:" + Pos.Tune
		+ " " + Pos.Name);	    
	    }
        }
    }
    
    int[] InstrListIndex;
    void refreshInstrumentList() {
	InstrListIndex = new int[SymSong.getNumbOfInstruments()];
	int IndexCounter = 0;
	InstrListModel.clear();
	for(int i=0;i<SymSong.getNumbOfInstruments();i++) {
	    SymphonieInstrument si = SymSong.getInstrumentIndex(i);
	    if( (si != null) && (si.checkReady()) )  {
		InstrListIndex[IndexCounter] = i;
		IndexCounter++;
		addInstrumentList(si.ID + "-" + si.Name);
	    }
        }
    }
    
    void addInstrumentList(String s) {
        InstrListModel.addElement(s);   
    }
    
    int getInstrIndexFromInstrListIndex(int i) {
	if(i>=0 && i < SymSong.getNumbOfInstruments()) {
	    return(InstrListIndex[i]);
	} else {
	    return(0);
	}
    }
    
    void stopAllStopSong() {
        if(SymSong != null) SymSong.StopSong();
        if(MyVoiceExpander != null) MyVoiceExpander.stopAll();
    }
    
    void playActualPattern() {
        SymphManager.SymSong.StopSong();
        MyVoiceExpander.stopAll();
        MyVoiceExpander.setSong(SymphManager.SymSong);
        SymphManager.SymSong.PlayingPatternNr = SymphManager.PED.getActualPatternNr();
        startAudioSystem();
        SymphManager.SymSong.PlaySong();
    }
    
    
    void PrintToInfoWindow (String s){
        listModel.addElement(s);
    }
    
    void setActualInstrumentIndex(int i) {ActualInstrumentIndex = i;};
    int getActualInstrumentIndex() {return(ActualInstrumentIndex);};
    int getActualInstrumentID() {
        SymphonieInstrument si=getActualInstrument();
        if(si!=null) {
            return(si.ID);
        } else {
            return(-1);
        }
    };
    SymphonieInstrument getActualInstrument() {
          return(SymSong.getInstrumentIndex(ActualInstrumentIndex));
    }
    
    void removeInstrumentIndex(int i) {
	SymSong.removeInstrumentIndex(i);
    }
    
    
    void setActualPatternNr(int i) {ActualPatternNr = i;};
    int getActualPatternNr() {return(ActualPatternNr);};
    
    // UI Tools
    
    int checkSpinnerLimits(JSpinner Component,int MinValue, int MaxValue, boolean doSetValue) {
        int Value;                                       
        Number n;
        NumberFormat nf = NumberFormat.getInstance();
        String s;
        
        s = Component.getModel().getValue().toString();
        try{
            n = nf.parse(s);
            Value = n.intValue();
            if(Value < MinValue) {
                Value = MinValue;
                if(doSetValue) Component.setValue(Value);
            }
            if(Value >= MaxValue ) {
                Value = MaxValue;
            }
        
        } catch (java.text.ParseException e) {
            Value = MinValue;
        }
        if(doSetValue) Component.setValue(Value);
        return(Value);
    }
    
    int getSpinnerValue(JSpinner Component) {
        int Value;                                       
        Number n;
        NumberFormat nf = NumberFormat.getInstance();
        String s;
        
        s = Component.getModel().getValue().toString();
        try{
            n = nf.parse(s);
            Value = n.intValue();

        
        } catch (java.text.ParseException e) {
            Value = 0;
        }
        return(Value);
    }
    
    float getStringValue(String s) {
        int Value;                                       
        Number n;
        NumberFormat nf = NumberFormat.getInstance();
        try{
            n = nf.parse(s);
            Value = n.intValue();

        
        } catch (java.text.ParseException e) {
            Value = 0;
        }
        return(Value);
    }
    
    void MoveInstrNext() {
        MoveToInstr(this.getActualInstrumentIndex() + 1);
    }
    
    void MoveInstrPrev() {
        if(getActualInstrumentIndex()>0) MoveToInstr(this.getActualInstrumentIndex() - 1);
    }
    
    void MoveToInstr(int i) {
	if(getActualInstrumentIndex()!=i) {
	    InstrED.moveToInstrIndex(i);
	    PED.SyncInstrumentNr(i);
	}
    }

    void PEDMoveToInstr(int i) {
        //InstrDetNrNew.setValue(i);
        //PED.SyncInstrumentNr(i);
    }    
    
    
    void MoveToInstrID(int i) {
	int Index = SymphManager.SymSong.getIndexOfInstrumentID(i);
	MoveToInstr(Index);
    }
    
    
    
    void KeyboardPlayChar(char c, int Tune) {
        SymphonieInstrument si;
        si = SymphManager.SymSong.getInstrumentIndex(SymphManager.getActualInstrumentIndex());        
        
        String s = "<aysxcfvgbhnmk,l.-ä";
        String s2 = "q2w3er5t6z7ui9o0pü";
        
        int pos = -1;
        for(int i=0;i<s.length();i++) {
            if(c == s.charAt(i)) pos = i;
        }
        
        for(int i=0;i<s2.length();i++) {
            if(c == s2.charAt(i)) pos = (i+12);
        }
        
        
        if((pos!=-1) && (si.SampleDataLoaded == true) && (si!=null)  ) {
            startAudioSystem();
            MyVoiceExpander.PlayInstrumentNote(si, pos+Tune, 100.0f);
            
        }
    }
    
        int getKeyboardCharToPitch(char c, int Tune) {
        SymphonieInstrument si;
        si = SymphManager.SymSong.getInstrumentIndex(SymphManager.getActualInstrumentIndex());        
        
        String s = "<aysxcfvgbhnmk,l.-ä";
        String s2 = "q2w3er5t6z7ui9o0pü";
        
        int pos = -1;
        for(int i=0;i<s.length();i++) {
            if(c == s.charAt(i)) pos = i;
        }
        
        for(int i=0;i<s2.length();i++) {
            if(c == s2.charAt(i)) pos = (i+12);
        }
	if(pos!=-1) {
	    pos+=Tune;
        }
        return(pos);
    }
    
    
    
    
    void KeyboardPlayChar(char c) {
        KeyboardPlayChar(c, 0);
    }
 }

    void InitDefaultSong8Voices() {
         // Init Lists
        SymphManager.stopAllStopSong();
        listModel.clear();
        jList1.setModel(listModel );
        InstrListModel.clear();
        InstrList.setModel(InstrListModel );
        PosListModel.clear();
        PosListJList.setModel(PosListModel );
        SymphManager.SymSong.allocDefaultSong();
	for(int i=0;i<SymphManager.SymSong.getNumbOfPatterns();i++) {
	    SymphManager.SymSong.getPattern(i).init(SymphManager.SymSong.getNumbOfVoices());
	}
	SymphManager.setActualInstrumentIndex(0);
        SymphManager.setActualPatternNr(0);
        PrintToInfoWindow("New Song intitalized.");
        ShowAllWindows();
	startAudioSystem();
    }

    void loadSymMod() {
        File f;
        JFileChooser jFc = new JFileChooser();
        f = new File(SymphManager.getModPath());
        jFc.setCurrentDirectory(f);
        jFc.showOpenDialog(jFc);
        f = jFc.getSelectedFile();
        if(f!=null) {
	    // get new Song Import Object
	    ImportSymph = new ImportSongSymphonie();
	    // Init Lists
	    listModel.clear();
	    jList1.setModel(listModel );

	    // Empty Lists
	    InstrListModel.clear();
	    InstrList.setModel(InstrListModel );

	    PosListModel.clear();
	    PosListJList.setModel(PosListModel );
	    
	    ImportSymph.initImport(listModel, InstrListModel, PosListModel, SymphManager.SymSong);
	    
	    ImportSymph.runImport(f);
	    ShowAllWindows();  
            SymphManager.registerModPath(jFc.getCurrentDirectory().getAbsolutePath());
	    SymphManager.MyVoiceExpander.setMuteAllVoices(false);
	}
    }

    private void SymLoadActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_SymLoadActionPerformed
        
        // TODO add your handling code here:
        actionImportSymMod();
    }//GEN-LAST:event_SymLoadActionPerformed

    
    void actionImportSymMod() {
        // DSP off
        if(SysLoadModDeactivateDsp.isSelected() ) {
	    MyVoiceExpander.setDSPFxIndex(0);
            SysDspFxTypeCombox.setSelectedIndex(0);
	}
        
        //Stop playing Song
        SymphManager.SymSong.StopSong();
        MyVoiceExpander.stopAll();
        loadSymMod();
        SymphManager.MoveToInstr(0);
        SymphManager.setActualPatternNr(0);
        SymphManager.PED.DrawAll(true);
        SymphManager.UpdateActualInstrDetails();
        SysMasterBPM.setText(""+SymphManager.SymSong.getBPM());	
	SymphManager.refreshInstrumentList();
	moveToPositionIndex(0, true);
    }
    
    
    void writePreferences() {
        java.util.prefs.AbstractPreferences.userRoot().put("Symphonie.Path.NewModule", SymphManager.getNewModPath() );        
        java.util.prefs.AbstractPreferences.userRoot().put("Symphonie.Path.Module", SymphManager.getModPath() );        
        java.util.prefs.AbstractPreferences.userRoot().put("Symphonie.Path.Samples", SymphManager.getSamplePath() );        

	java.util.prefs.AbstractPreferences.userRoot().putInt("Symphonie.PosEdFrame.x", PosEdFrame.getBounds().x);        
        java.util.prefs.AbstractPreferences.userRoot().putInt("Symphonie.PosEdFrame.y", PosEdFrame.getBounds().y);        
        java.util.prefs.AbstractPreferences.userRoot().putInt("Symphonie.PosEdFrame.width", PosEdFrame.getBounds().width);        
        java.util.prefs.AbstractPreferences.userRoot().putInt("Symphonie.PosEdFrame.height", PosEdFrame.getBounds().height);        

        java.util.prefs.AbstractPreferences.userRoot().putInt("Symphonie.frmMainPanel.x", mainPanel.getBounds().x);        
        java.util.prefs.AbstractPreferences.userRoot().putInt("Symphonie.frmMainPanel.y", mainPanel.getBounds().y);        
        java.util.prefs.AbstractPreferences.userRoot().putInt("Symphonie.frmMainPanel.width", mainPanel.getBounds().width);        
        java.util.prefs.AbstractPreferences.userRoot().putInt("Symphonie.frmMainPanel.height", mainPanel.getBounds().height);        
   
        java.util.prefs.AbstractPreferences.userRoot().putInt("Symphonie.frmPosList.x", PosListjFrame.getBounds().x);        
        java.util.prefs.AbstractPreferences.userRoot().putInt("Symphonie.frmPosList.y", PosListjFrame.getBounds().y);        
        java.util.prefs.AbstractPreferences.userRoot().putInt("Symphonie.frmPosList.width", PosListjFrame.getBounds().width);        
        java.util.prefs.AbstractPreferences.userRoot().putInt("Symphonie.frmPosList.height", PosListjFrame.getBounds().height);        

        java.util.prefs.AbstractPreferences.userRoot().putInt("Symphonie.frmInstrList.x", frmInstrList.getBounds().x);        
        java.util.prefs.AbstractPreferences.userRoot().putInt("Symphonie.frmInstrList.y", frmInstrList.getBounds().y);        
        java.util.prefs.AbstractPreferences.userRoot().putInt("Symphonie.frmInstrList.width", frmInstrList.getBounds().width);        
        java.util.prefs.AbstractPreferences.userRoot().putInt("Symphonie.frmInstrList.height", frmInstrList.getBounds().height);        
        
        java.util.prefs.AbstractPreferences.userRoot().putInt("Symphonie.frmPED.x", SymphManager.PED.getBounds().x);        
        java.util.prefs.AbstractPreferences.userRoot().putInt("Symphonie.frmPED.y", SymphManager.PED.getBounds().y);        
        java.util.prefs.AbstractPreferences.userRoot().putInt("Symphonie.frmPED.width", SymphManager.PED.getBounds().width);        
        java.util.prefs.AbstractPreferences.userRoot().putInt("Symphonie.frmPED.height", SymphManager.PED.getBounds().height);        
        
	java.util.prefs.AbstractPreferences.userRoot().putInt("Symphonie.frmInstrDetails.x", SymphManager.InstrED.getBounds().x);        
        java.util.prefs.AbstractPreferences.userRoot().putInt("Symphonie.frmInstrDetails.y", SymphManager.InstrED.getBounds().y);        
        java.util.prefs.AbstractPreferences.userRoot().putInt("Symphonie.frmInstrDetails.width", SymphManager.InstrED.getBounds().width);        
        java.util.prefs.AbstractPreferences.userRoot().putInt("Symphonie.frmInstrDetails.height", SymphManager.InstrED.getBounds().height);        
	
        java.util.prefs.AbstractPreferences.userRoot().putBoolean("Symphonie.SysLoadModDeactivateDsp", SysLoadModDeactivateDsp.isSelected());        
        java.util.prefs.AbstractPreferences.userRoot().putBoolean("Symphonie.SysUpdateSamplePos", SysUpdateSamplePos.isSelected());        
        java.util.prefs.AbstractPreferences.userRoot().putBoolean("Symphonie.SysUpdatePatternNr", SysUpdatePatternNr.isSelected());
        java.util.prefs.AbstractPreferences.userRoot().putBoolean("Symphonie.SysUpdateCrsr", SysUpdateCrsr.isSelected());
        java.util.prefs.AbstractPreferences.userRoot().putBoolean("Symphonie.SysUpdateInstr", SysUpdateInstr.isSelected());
    }
    
    void readPreferences() {
        int x,y,w,h;
	boolean b;
        SymphManager.registerNewModPath(java.util.prefs.AbstractPreferences.userRoot().get("Symphonie.Path.NewModule", ""));
        SymphManager.registerModPath(java.util.prefs.AbstractPreferences.userRoot().get("Symphonie.Path.Module", ""));
        SymphManager.registerSamplePath(java.util.prefs.AbstractPreferences.userRoot().get("Symphonie.Path.Samples", ""));
        
        x = java.util.prefs.AbstractPreferences.userRoot().getInt("Symphonie.PosEdFrame.x", 10);
        y = java.util.prefs.AbstractPreferences.userRoot().getInt("Symphonie.PosEdFrame.y", 10);
        w = java.util.prefs.AbstractPreferences.userRoot().getInt("Symphonie.PosEdFrame.width", 320);
        h = java.util.prefs.AbstractPreferences.userRoot().getInt("Symphonie.PosEdFrame.height", 200);
        PosEdFrame.setBounds(x, y, w, h);
        
	x = java.util.prefs.AbstractPreferences.userRoot().getInt("Symphonie.frmMainPanel.x", 10);
        y = java.util.prefs.AbstractPreferences.userRoot().getInt("Symphonie.frmMainPanel.y", 10);
        w = java.util.prefs.AbstractPreferences.userRoot().getInt("Symphonie.frmMainPanel.width", 320);
        h = java.util.prefs.AbstractPreferences.userRoot().getInt("Symphonie.frmMainPanel.height", 200);
        mainPanel.setBounds(x, y, w, h);

        x = java.util.prefs.AbstractPreferences.userRoot().getInt("Symphonie.frmPosList.x", 10);
        y = java.util.prefs.AbstractPreferences.userRoot().getInt("Symphonie.frmPosList.y", 10);
        w = java.util.prefs.AbstractPreferences.userRoot().getInt("Symphonie.frmPosList.width", 320);
        h = java.util.prefs.AbstractPreferences.userRoot().getInt("Symphonie.frmPosList.height", 200);
        PosListjFrame.setBounds(x, y, w, h);
    
        x = java.util.prefs.AbstractPreferences.userRoot().getInt("Symphonie.frmInstrList.x", 10);
        y = java.util.prefs.AbstractPreferences.userRoot().getInt("Symphonie.frmInstrList.y", 10);
        w = java.util.prefs.AbstractPreferences.userRoot().getInt("Symphonie.frmInstrList.width", 320);
        h = java.util.prefs.AbstractPreferences.userRoot().getInt("Symphonie.frmInstrList.height", 200);
        frmInstrList.setBounds(x, y, w, h);
        
        x = java.util.prefs.AbstractPreferences.userRoot().getInt("Symphonie.frmPED.x", 10);
        y = java.util.prefs.AbstractPreferences.userRoot().getInt("Symphonie.frmPED.y", 10);
        w = java.util.prefs.AbstractPreferences.userRoot().getInt("Symphonie.frmPED.width", 320);
        h = java.util.prefs.AbstractPreferences.userRoot().getInt("Symphonie.frmPED.height", 200);
        SymphManager.PED.setBounds(x, y, w, h);
	
        x = java.util.prefs.AbstractPreferences.userRoot().getInt("Symphonie.frmInstrDetails.x", 10);
        y = java.util.prefs.AbstractPreferences.userRoot().getInt("Symphonie.frmInstrDetails.y", 10);
        w = java.util.prefs.AbstractPreferences.userRoot().getInt("Symphonie.frmInstrDetails.width", 320);
        h = java.util.prefs.AbstractPreferences.userRoot().getInt("Symphonie.frmInstrDetails.height", 200);
        SymphManager.InstrED.setBounds(x, y, w, h);
	
        SysLoadModDeactivateDsp.setSelected(java.util.prefs.AbstractPreferences.userRoot().
		getBoolean("Symphonie.SysLoadModDeactivateDsp", false));
        SysUpdateSamplePos.setSelected(java.util.prefs.AbstractPreferences.userRoot().
		getBoolean("Symphonie.SysUpdateSamplePos", false));
        SysUpdatePatternNr.setSelected(java.util.prefs.AbstractPreferences.userRoot().
		getBoolean("Symphonie.SysUpdatePatternNr", false));
        SysUpdateCrsr.setSelected(java.util.prefs.AbstractPreferences.userRoot().
		getBoolean("Symphonie.SysUpdateCrsr", false));
        SysUpdateInstr.setSelected(java.util.prefs.AbstractPreferences.userRoot().
		getBoolean("Symphonie.SysUpdateInstr", false));

    
    }
    
    
    private void InstrListMouseClicked(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_InstrListMouseClicked
        ActionInstrListElement();
        // TODO add your handling code here:
    }//GEN-LAST:event_InstrListMouseClicked

    private void InstrListMouseReleased(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_InstrListMouseReleased
        ActionInstrListElement();
        // TODO add your handling code here:
    }//GEN-LAST:event_InstrListMouseReleased

    private void InstrListKeyTyped(java.awt.event.KeyEvent evt) {//GEN-FIRST:event_InstrListKeyTyped
        SymphManager.KeyboardPlayChar(evt.getKeyChar());
	ActionInstrListElement();
        // TODO add your handling code here:
    }//GEN-LAST:event_InstrListKeyTyped


    int MixSampleCalcSampleLen(int OrigSampleLen, float freqfactor) {
        int NewSampleLen = 0;
        
        if(freqfactor == 1.0f) {
            return(OrigSampleLen);
        } else {
            freqfactor = OrigSampleLen / freqfactor;
            NewSampleLen = (int) freqfactor;
            return(NewSampleLen);
        }
    }
    
    void MixSample(SymphonieInstrument si, byte[] SampleBuffer, float freqfactor) {
        int DestIndex = 0;
        int Sample, hi, lo;
        int NumbOfSamples = si.sp.getNumbOfSamples();
        
        // Check if Buffer is Large enough
        if(SampleBuffer.length < (NumbOfSamples*2 )) {
            NumbOfSamples = SampleBuffer.length*2;
        }
        
        // Convert Sample from float to Format defined
        for(int i=0;i<NumbOfSamples;i++) {
            Sample = (int) (si.sp.Samples[i] * 32767);
            hi = Sample /256;
            lo = Sample - (hi * 256);
            SampleBuffer[DestIndex++] = (byte) hi;
            SampleBuffer[DestIndex++] = (byte) lo;
        }   
    }
    
   SymphonieInstrument  LoadNewInstrumentSample(File f, FileInputStream fi) {
    int len = (int) f.length();
    byte[] src;
    SymphonieInstrument si = null;
    try{
        int numberread;

        si = SymphManager.SymSong.getFreeInstrument();
        src = new byte[(int) len];
        numberread = fi.read(src,0,(int) len);
        si.ImportSample.Analyse(src, len);
        si.Name = f.getAbsoluteFile() + " ";
        si.SampleDataLoaded = true;
        si.isInUse = true;
        
        // Make Stereo Sample if needet
        PostProcessMultiSample(si, si.ImportSample);
        
        // Visual Update
        InstrList.setModel(InstrListModel );
    }
    catch (java.io.IOException e) {
        PrintToInfoWindow("ERROR:While reading Samplefile " + f.getAbsoluteFile());
    }
    return(si);
} 
   
    // Split Instrument if it is a Stereo one
    void PostProcessMultiSample(SymphonieInstrument siLeft, ImportSample myImportSample ) {
        initNewInstrDefaults(siLeft);
	if(myImportSample.getNumbOfChannels() == 2) {
            SymphonieInstrument siRight;
            siLeft.sp = myImportSample.getSamplePool(0);
            siLeft.MultiChannel = 1;
            siRight = SymphManager.SymSong.getFreeInstrument();
            siRight.sp = myImportSample.getSamplePool(1);
            siRight.SampleDataLoaded = true;
            siRight.isInUse = true;
            siLeft.MultiChannel = 1;
            siRight.MultiChannel = 2;
            siRight.Name = siLeft.Name;// + " R";
            //siLeft.Name = siLeft.Name;// + " L";
            InstrListModel.addElement(siLeft.Name);
            InstrListModel.addElement(siRight.Name);
	    initNewInstrDefaults(siRight);
        } else {
            siLeft.sp = myImportSample.getSamplePool(0);
            siLeft.MultiChannel = 0;            
            InstrListModel.addElement(siLeft.Name);    
        }
    }
    
    void initNewInstrDefaults(SymphonieInstrument si) {
	si.AsQueue = false;
	si.FineTune = 0;
	si.Volume = 100;
	si.Tune = 26;
	si.VirtualSample = false;
    }
   
    
    void ShowAllWindows() {
        frmInstrList.setVisible(true);
        SymphManager.InstrED.setVisible(true);
        SymphManager.PED.setVisible(true);
        PosListjFrame.setVisible(true);
	PosEdFrame.setVisible(true);
    }
    
    void LoadNewSample(boolean MoveToNewSample) {
        File f;
        FileInputStream fi;
        long FileLength = 0;
        SymphonieInstrument si;
        
        JFileChooser jFc = new JFileChooser();
        ShowAllWindows();
        
        f = new File(SymphManager.getSamplePath());
        jFc.setCurrentDirectory(f);
        jFc.showOpenDialog(jFc);
        
        PrintToInfoWindow("Loading New Sample...");
        
        f = jFc.getSelectedFile();
        SymphManager.registerSamplePath(jFc.getCurrentDirectory().getAbsolutePath());
	
	if(f!=null) {
	    PrintToInfoWindow(f.getPath());
	    try {
		fi = new FileInputStream(f);
		FileLength = f.length();
		PrintToInfoWindow(">> Filelength in Byte:", (int) FileLength);
		si = LoadNewInstrumentSample(f, fi);
		if(MoveToNewSample) SymphManager.MoveToInstrID(si.ID);
	    } catch (java.io.FileNotFoundException e) {
		PrintToInfoWindow("Error:File not Found.");
	    }
	}
        
	//frmInstrList.setVisible(true);
        //FrmInstrDetails.setVisible(true);
        
        SymphManager.UpdateActualInstrDetails();
	SymphManager.refreshInstrumentList();
    }
    
    
    private void SysInterpolationTypeActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_SysInterpolationTypeActionPerformed
        // TODO add your handling code here:
        MyVoiceExpander.myInterpolateSample.setInterpolateType(SysInterpolationType.getSelectedIndex());
    }//GEN-LAST:event_SysInterpolationTypeActionPerformed

    private void SysMasterTuneStateChanged(javax.swing.event.ChangeEvent evt) {//GEN-FIRST:event_SysMasterTuneStateChanged
        // TODO add your handling code here:
        MyVoiceExpander.MasterTune = SysMasterTune.getValue();
    }//GEN-LAST:event_SysMasterTuneStateChanged

    private void SysMasterVolumeStateChanged(javax.swing.event.ChangeEvent evt) {//GEN-FIRST:event_SysMasterVolumeStateChanged
        // TODO add your handling code here:
        MyVoiceExpander.MasterVolume = SysMasterVolume.getValue();
    }//GEN-LAST:event_SysMasterVolumeStateChanged

    private void SystemPanelKeyPressed(java.awt.event.KeyEvent evt) {//GEN-FIRST:event_SystemPanelKeyPressed
        // TODO add your handling code here:
        SymphManager.KeyboardPlayChar(evt.getKeyChar());

}//GEN-LAST:event_SystemPanelKeyPressed

    private void SystemPanelKeyTyped(java.awt.event.KeyEvent evt) {//GEN-FIRST:event_SystemPanelKeyTyped
        // TODO add your handling code here:
        //SymphManager.KeyboardPlayChar(evt.getKeyChar());
        
    }//GEN-LAST:event_SystemPanelKeyTyped

    private void SysDitheringComboxActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_SysDitheringComboxActionPerformed
        // TODO add your handling code here:
        MyVoiceExpander.Dithering = SysDitheringCombox.getSelectedIndex();
}//GEN-LAST:event_SysDitheringComboxActionPerformed

    private void playPatternButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_playPatternButtonActionPerformed
        // TODO add your handling code here:
	SymphManager.playActualPattern();
	
}//GEN-LAST:event_playPatternButtonActionPerformed

    
    
    private void stopSongButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_stopSongButtonActionPerformed
        // TODO add your handling code here:
        SymphManager.SymSong.StopSong();
        MyVoiceExpander.stopAll();
}//GEN-LAST:event_stopSongButtonActionPerformed

    private void SysMasterBPMAdjStateChanged(javax.swing.event.ChangeEvent evt) {//GEN-FIRST:event_SysMasterBPMAdjStateChanged
        // TODO add your handling code here:
        MyVoiceExpander.setBPMTune(SysMasterBPMAdj.getValue());
}//GEN-LAST:event_SysMasterBPMAdjStateChanged

    private void PosListJListMouseClicked(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_PosListJListMouseClicked
        // TODO add your handling code here:
        int PositionIndex = PosListJList.getMinSelectionIndex();
        
	
	if ((SymphManager.SymSong.SongPlaying == true) && (SymphManager.SymSong.isPositionPlaying == true) ){
	    // Soft Start with Break
	    SymphManager.SymSong.setNextPositionToPlaySynced(PositionIndex, false);
	} else { 
	    // Start Song Playing
	    SymphManager.SymSong.StopSong();
	    MyVoiceExpander.stopAll();
	    SymphManager.SymSong.PlayPosition(PositionIndex);
	    MyVoiceExpander.setSongSpeed(SymphManager.SymSong.getBPM(), SymphManager.SymSong.getPositionSpeed());
	    startAudioSystem();
	    MyVoiceExpander.setSong(SymphManager.SymSong);
	}
	
	
    }//GEN-LAST:event_PosListJListMouseClicked

    private void playSongButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_playSongButtonActionPerformed
        // TODO add your handling code here:
        //        int PositionIndex = PosListJList.getMinSelectionIndex();
        
        SymphManager.SymSong.StopSong();
        MyVoiceExpander.stopAll();
        MyVoiceExpander.setSong(SymphManager.SymSong);
        
        startAudioSystem();
        MyVoiceExpander.setSongSpeed(SymphManager.SymSong.getBPM(), SymphManager.SymSong.getPositionSpeed());
        SymphManager.SymSong.PlayFromFirstSequence();
        MyVoiceExpander.setSongSpeed(SymphManager.SymSong.getBPM(), SymphManager.SymSong.getPositionSpeed());
    }//GEN-LAST:event_playSongButtonActionPerformed

    private void SysDspFxTypeComboxActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_SysDspFxTypeComboxActionPerformed
        // TODO add your handling code here:
        MyVoiceExpander.setDSPFxIndex(SysDspFxTypeCombox.getSelectedIndex());
}//GEN-LAST:event_SysDspFxTypeComboxActionPerformed

    private void SysDspMixVolumeSliderStateChanged(javax.swing.event.ChangeEvent evt) {//GEN-FIRST:event_SysDspMixVolumeSliderStateChanged
        // TODO add your handling code here:
        MyVoiceExpander.setWetMixVolume(SysDspMixVolumeSlider.getValue());
}//GEN-LAST:event_SysDspMixVolumeSliderStateChanged

    private void SysDeclickingActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_SysDeclickingActionPerformed
        // TODO add your handling code here:
        MyVoiceExpander.setDeclicking(SysDeclicking.isSelected());
    }//GEN-LAST:event_SysDeclickingActionPerformed

    private void SysDspFeedbackStateChanged(javax.swing.event.ChangeEvent evt) {//GEN-FIRST:event_SysDspFeedbackStateChanged
        // TODO add your handling code here:
        
        int FeedbackValue = SysDspFeedback.getValue();
        MyVoiceExpander.setDSPFeedback(FeedbackValue);
        if(FeedbackValue > 75) {
            SysDspFeedback.setBackground(SymphManager.WarnColorDsp1);
        } else {
            
            SysDspFeedback.setBackground(SysDspMixVolumeSlider.getBackground()); 
        }

}//GEN-LAST:event_SysDspFeedbackStateChanged

    private void SysDspLengthStateChanged(javax.swing.event.ChangeEvent evt) {//GEN-FIRST:event_SysDspLengthStateChanged
        // TODO add your handling code here:
        MyVoiceExpander.setDSPLength(SysDspLength.getValue());
}//GEN-LAST:event_SysDspLengthStateChanged

    private void SysDspPreDelayStateChanged(javax.swing.event.ChangeEvent evt) {//GEN-FIRST:event_SysDspPreDelayStateChanged
        // TODO add your handling code here:
        MyVoiceExpander.setDSPPreDelay(SysDspPreDelay.getValue());
}//GEN-LAST:event_SysDspPreDelayStateChanged

    private void SysSyncToBeatActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_SysSyncToBeatActionPerformed
        // TODO add your handling code here:
        MyVoiceExpander.DSP.setSyncToBeat(SysSyncToBeat.isSelected());
        if(SysSyncToBeat.isSelected()) {
            int i;
            i = MyVoiceExpander.DSP.getMaxBeatsDspLen();
            SysDspLength.setMajorTickSpacing(1);
            SysDspLength.setMinorTickSpacing(1);
            SysDspLength.setValue(i);
            SysDspLength.setSnapToTicks(true);
            SysDspLength.setMinimum(1);
            SysDspLength.setMaximum(i);
        } else {
            SysDspLength.setSnapToTicks(false);
            SysDspLength.setMajorTickSpacing(8);
            SysDspLength.setMinorTickSpacing(2);
            SysDspLength.setMinimum(1);
            SysDspLength.setMaximum(100);
        }
        
}//GEN-LAST:event_SysSyncToBeatActionPerformed

    private void SysLoadModDeactivateDspStateChanged(javax.swing.event.ChangeEvent evt) {//GEN-FIRST:event_SysLoadModDeactivateDspStateChanged
        // TODO add your handling code here:
}//GEN-LAST:event_SysLoadModDeactivateDspStateChanged

    private void jButton3ActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButton3ActionPerformed
        // TODO add your handling code here:
        SysMasterTune.setValue(0);
    }//GEN-LAST:event_jButton3ActionPerformed

    private void jButton4ActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButton4ActionPerformed
        // TODO add your handling code here:
        SysMasterBPMAdj.setValue(100);
    }//GEN-LAST:event_jButton4ActionPerformed

    private void SysDeclickingLenSliderStateChanged(javax.swing.event.ChangeEvent evt) {//GEN-FIRST:event_SysDeclickingLenSliderStateChanged
        // TODO add your handling code here:
        MyVoiceExpander.setVoiceSmoothingLen(SysDeclickingLenSlider.getValue());
    }//GEN-LAST:event_SysDeclickingLenSliderStateChanged

    private void SysSampleDiffStateChanged(javax.swing.event.ChangeEvent evt) {//GEN-FIRST:event_SysSampleDiffStateChanged
        // TODO add your handling code here:
        MyVoiceExpander.setSampleDiff(SysSampleDiff.getValue());
    }//GEN-LAST:event_SysSampleDiffStateChanged

    private void SysPitchDiffStateChanged(javax.swing.event.ChangeEvent evt) {//GEN-FIRST:event_SysPitchDiffStateChanged
        // TODO add your handling code here:
        MyVoiceExpander.setPitchDiff(SysPitchDiff.getValue());
    }//GEN-LAST:event_SysPitchDiffStateChanged

    private void SysMasterBPMActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_SysMasterBPMActionPerformed
	// TODO add your handling code here:
	SymphManager.SymSong.setBPM(SymphManager.getStringValue(SysMasterBPM.getText()));
	
    }//GEN-LAST:event_SysMasterBPMActionPerformed

    private void exitMenuItemActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_exitMenuItemActionPerformed
	// TODO add your handling code here:
	writePreferences();
    }//GEN-LAST:event_exitMenuItemActionPerformed

    private void jMenuItem2ActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jMenuItem2ActionPerformed
	// TODO add your handling code here:
	PrintToInfoWindow("Loading...");
	InitDefaultSong8Voices();
	SongIO testSongIO = new SongIO();
	testSongIO.setUIManager(SymphManager);
	testSongIO.loadAs(SymphManager.SymSong);
	SymphManager.MyVoiceExpander.setMuteAllVoices(false);
	SymphManager.refreshInstrumentList();
	PrintToInfoWindow("Done.");
	moveToPositionIndex(0, true);
    }//GEN-LAST:event_jMenuItem2ActionPerformed

    private void jMenuItem2StateChanged(javax.swing.event.ChangeEvent evt) {//GEN-FIRST:event_jMenuItem2StateChanged
	// TODO add your handling code here:
    }//GEN-LAST:event_jMenuItem2StateChanged

    private void jMenuItem1ActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jMenuItem1ActionPerformed
	// TODO add your handling code here:
	PrintToInfoWindow("Saving...");
	SongIO testSongIO = new SongIO();
	testSongIO.setUIManager(SymphManager);
	testSongIO.saveAs(SymphManager.SymSong);
	PrintToInfoWindow("Done.");
    }//GEN-LAST:event_jMenuItem1ActionPerformed

    private void newSongMenuItemActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_newSongMenuItemActionPerformed
	// TODO add your handling code here:
	InitDefaultSong8Voices();
	SymphManager.SymSong.fillPositionsToDefault();
	SymphManager.refreshPositionsList();
	SymphManager.refreshInstrumentList();
    }//GEN-LAST:event_newSongMenuItemActionPerformed

    private void loadSampleMenuItemActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_loadSampleMenuItemActionPerformed
	// TODO add your handling code here:
	LoadNewSample(true);
	SymphManager.refreshInstrumentList();
    }//GEN-LAST:event_loadSampleMenuItemActionPerformed

    private void loadModMenuItemActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_loadModMenuItemActionPerformed
	// TODO add your handling code here:
	PrintToInfoWindow("Loading...");
	actionImportSymMod();
	SymphManager.refreshInstrumentList();
	PrintToInfoWindow("Done.");

    }//GEN-LAST:event_loadModMenuItemActionPerformed

    private void SysDeclickingLenSlider12StateChanged(javax.swing.event.ChangeEvent evt) {//GEN-FIRST:event_SysDeclickingLenSlider12StateChanged
	// TODO add your handling code here:
    }//GEN-LAST:event_SysDeclickingLenSlider12StateChanged

    private void SysDeclicking12ActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_SysDeclicking12ActionPerformed
	// TODO add your handling code here:
    }//GEN-LAST:event_SysDeclicking12ActionPerformed

    private void SysDeclickingLenSlider1StateChanged(javax.swing.event.ChangeEvent evt) {//GEN-FIRST:event_SysDeclickingLenSlider1StateChanged
	// TODO add your handling code here:
    }//GEN-LAST:event_SysDeclickingLenSlider1StateChanged

    private void SysDeclicking1ActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_SysDeclicking1ActionPerformed
	// TODO add your handling code here:
    }//GEN-LAST:event_SysDeclicking1ActionPerformed

    private void SysDeclickingLenSlider2StateChanged(javax.swing.event.ChangeEvent evt) {//GEN-FIRST:event_SysDeclickingLenSlider2StateChanged
	// TODO add your handling code here:
    }//GEN-LAST:event_SysDeclickingLenSlider2StateChanged

    private void SysDeclicking2ActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_SysDeclicking2ActionPerformed
	// TODO add your handling code here:
    }//GEN-LAST:event_SysDeclicking2ActionPerformed

    private void SysDeclickingLenSlider3StateChanged(javax.swing.event.ChangeEvent evt) {//GEN-FIRST:event_SysDeclickingLenSlider3StateChanged
	// TODO add your handling code here:
    }//GEN-LAST:event_SysDeclickingLenSlider3StateChanged

    private void SysDeclicking3ActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_SysDeclicking3ActionPerformed
	// TODO add your handling code here:
    }//GEN-LAST:event_SysDeclicking3ActionPerformed

    private void SysDeclickingLenSlider4StateChanged(javax.swing.event.ChangeEvent evt) {//GEN-FIRST:event_SysDeclickingLenSlider4StateChanged
	// TODO add your handling code here:
    }//GEN-LAST:event_SysDeclickingLenSlider4StateChanged

    private void SysDeclicking4ActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_SysDeclicking4ActionPerformed
	// TODO add your handling code here:
    }//GEN-LAST:event_SysDeclicking4ActionPerformed

    private void SysDeclicking5ActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_SysDeclicking5ActionPerformed
	// TODO add your handling code here:
    }//GEN-LAST:event_SysDeclicking5ActionPerformed

    private void SysDeclickingLenSlider5StateChanged(javax.swing.event.ChangeEvent evt) {//GEN-FIRST:event_SysDeclickingLenSlider5StateChanged
	// TODO add your handling code here:
    }//GEN-LAST:event_SysDeclickingLenSlider5StateChanged

    private void SysDeclickingLenSlider6StateChanged(javax.swing.event.ChangeEvent evt) {//GEN-FIRST:event_SysDeclickingLenSlider6StateChanged
	// TODO add your handling code here:
    }//GEN-LAST:event_SysDeclickingLenSlider6StateChanged

    private void SysDeclicking6ActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_SysDeclicking6ActionPerformed
	// TODO add your handling code here:
    }//GEN-LAST:event_SysDeclicking6ActionPerformed

    private void SysMixRateActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_SysMixRateActionPerformed
	// TODO add your handling code here:
	
	if(SysMixRate.getSelectedIndex()==0) SymphManager.MyVoiceExpander.setMixRate(44100);
	if(SysMixRate.getSelectedIndex()==1) SymphManager.MyVoiceExpander.setMixRate(48000);
	if(SysMixRate.getSelectedIndex()==2) SymphManager.MyVoiceExpander.setMixRate(88200);
	if(SysMixRate.getSelectedIndex()==3) SymphManager.MyVoiceExpander.setMixRate(96000);
	if(SysMixRate.getSelectedIndex()==4) SymphManager.MyVoiceExpander.setMixRate(192000);

    }//GEN-LAST:event_SysMixRateActionPerformed

    private void PosEdNrStateChanged(javax.swing.event.ChangeEvent evt) {//GEN-FIRST:event_PosEdNrStateChanged
	// TODO add your handling code here:
	SymphManager.checkSpinnerLimits(PosEdNr, 0, SymphManager.SymSong.getNumbOfPositions()-1, true);
	showPositionNr(SymphManager.getSpinnerValue(PosEdNr));
    }//GEN-LAST:event_PosEdNrStateChanged

    private void PosEdPatternNrStateChanged(javax.swing.event.ChangeEvent evt) {//GEN-FIRST:event_PosEdPatternNrStateChanged
	// TODO add your handling code here:
	int i = SymphManager.getSpinnerValue(PosEdNr);Position Pos = getPositionIndex(i);
	if(Pos!=null) Pos.PatternNumbers[0] = SymphManager.getSpinnerValue(PosEdPatternNr);
	updatePosListFromPosIndex(i);
    }//GEN-LAST:event_PosEdPatternNrStateChanged

    private void PosEdStartStateChanged(javax.swing.event.ChangeEvent evt) {//GEN-FIRST:event_PosEdStartStateChanged
	// TODO add your handling code here:
	int i = SymphManager.getSpinnerValue(PosEdNr);Position Pos = getPositionIndex(i);
	if(Pos!=null) Pos.StartRow = SymphManager.getSpinnerValue(PosEdStart);
	updatePosListFromPosIndex(i);
    }//GEN-LAST:event_PosEdStartStateChanged

    private void PosEdLenStateChanged(javax.swing.event.ChangeEvent evt) {//GEN-FIRST:event_PosEdLenStateChanged
	// TODO add your handling code here:
	int i = SymphManager.getSpinnerValue(PosEdNr);Position Pos = getPositionIndex(i);
	if(Pos!=null) Pos.RowLength = SymphManager.getSpinnerValue(PosEdLen);
	updatePosListFromPosIndex(i);
    }//GEN-LAST:event_PosEdLenStateChanged

    private void PosEdCyclStateChanged(javax.swing.event.ChangeEvent evt) {//GEN-FIRST:event_PosEdCyclStateChanged
	// TODO add your handling code here:
	int i = SymphManager.getSpinnerValue(PosEdNr);Position Pos = getPositionIndex(i);
	if(Pos!=null) Pos.Speed_Cycl = SymphManager.getSpinnerValue(PosEdCycl);
	updatePosListFromPosIndex(i);
    }//GEN-LAST:event_PosEdCyclStateChanged

    private void PosEdLoopStateChanged(javax.swing.event.ChangeEvent evt) {//GEN-FIRST:event_PosEdLoopStateChanged
	// TODO add your handling code here:
	int i = SymphManager.getSpinnerValue(PosEdNr);Position Pos = getPositionIndex(i);
	if(Pos!=null) Pos.NumbOfLoops = SymphManager.getSpinnerValue(PosEdLoop);
	updatePosListFromPosIndex(i);
    }//GEN-LAST:event_PosEdLoopStateChanged

    private void PosEdTuneStateChanged(javax.swing.event.ChangeEvent evt) {//GEN-FIRST:event_PosEdTuneStateChanged
	// TODO add your handling code here:
	int i = SymphManager.getSpinnerValue(PosEdNr);Position Pos = getPositionIndex(i);
	if(Pos!=null) Pos.Tune = SymphManager.getSpinnerValue(PosEdTune);
	updatePosListFromPosIndex(i);
    }//GEN-LAST:event_PosEdTuneStateChanged

    private void PosEdNameTextActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_PosEdNameTextActionPerformed
	// TODO add your handling code here:
	int i = SymphManager.getSpinnerValue(PosEdNr);Position Pos = getPositionIndex(i);
	if(Pos!=null) Pos.Name = PosEdNameText.getText();
	updatePosListFromPosIndex(i);
}//GEN-LAST:event_PosEdNameTextActionPerformed

    private void PosEdNameTextInputMethodTextChanged(java.awt.event.InputMethodEvent evt) {//GEN-FIRST:event_PosEdNameTextInputMethodTextChanged
	// TODO add your handling code here:
		int i = SymphManager.getSpinnerValue(PosEdNr);Position Pos = getPositionIndex(i);
	if(Pos!=null) Pos.Name = PosEdNameText.getText();
	updatePosListFromPosIndex(i);
    }//GEN-LAST:event_PosEdNameTextInputMethodTextChanged

    private void PosEdNameTextVetoableChange(java.beans.PropertyChangeEvent evt)throws java.beans.PropertyVetoException {//GEN-FIRST:event_PosEdNameTextVetoableChange
	// TODO add your handling code here:
	int i = SymphManager.getSpinnerValue(PosEdNr);Position Pos = getPositionIndex(i);
	if(Pos!=null) Pos.Name = PosEdNameText.getText();
	updatePosListFromPosIndex(i);
    }//GEN-LAST:event_PosEdNameTextVetoableChange

    private void PosEdNameTextFocusLost(java.awt.event.FocusEvent evt) {//GEN-FIRST:event_PosEdNameTextFocusLost
	// TODO add your handling code here:
	Position Pos = getPositionIndex(getActualPositionIndex());
	if(Pos!=null) Pos.Name = PosEdNameText.getText();
	updatePosListFromPosIndex(getActualPositionIndex());
    }//GEN-LAST:event_PosEdNameTextFocusLost

    private void jButton5ActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButton5ActionPerformed
	// TODO add your handling code here:
	initPositionIndex(getActualPositionIndex());
	showPositionNr(getActualPositionIndex());
	updatePosListFromPosIndex(getActualPositionIndex());
    }//GEN-LAST:event_jButton5ActionPerformed

    private void jButton6ActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButton6ActionPerformed
	// TODO add your handling code here:
	insertPosAtActualPosition();
	SymphManager.refreshPositionsList();
    }//GEN-LAST:event_jButton6ActionPerformed

private void InstrListValueChanged(javax.swing.event.ListSelectionEvent evt) {//GEN-FIRST:event_InstrListValueChanged
// TODO add your handling code here:
    ActionInstrListElement();
}//GEN-LAST:event_InstrListValueChanged

private void jButton1ActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButton1ActionPerformed
// TODO add your handling code here:
        SymphManager.SymSong.StopSong();
        MyVoiceExpander.stopAll();
        MyVoiceExpander.setSong(SymphManager.SymSong);
        startAudioSystem();
	SymphManager.SymSong.playfromActualPosition();
	MyVoiceExpander.setSongSpeed(SymphManager.SymSong.getBPM(), SymphManager.SymSong.getPositionSpeed());
}//GEN-LAST:event_jButton1ActionPerformed

private void SysUpdateSamplePosActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_SysUpdateSamplePosActionPerformed
// TODO add your handling code here:
}//GEN-LAST:event_SysUpdateSamplePosActionPerformed

private void PEDDisplayMouseCrsrActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_PEDDisplayMouseCrsrActionPerformed
// TODO add your handling code here:
    SymphManager.PED.updateDrawMouseCrsrState();
}//GEN-LAST:event_PEDDisplayMouseCrsrActionPerformed
    
    // GUI Realtime Update ------------------------------
    boolean UpdateRealtimeUISwitch = false;
    void UpdateRealtimeUIInfos() {
        if(VoiceExpanderStarted == true) {
            UpdateRealtimeUISwitch = !UpdateRealtimeUISwitch;
            //SymphManager.InstrED.SampleViewDrawPlayPositions(); Extreme Speeddown
            RTDrawPEDVolumes();
            if(UpdateRealtimeUISwitch) {
                int PosPlayingIndex = 0;
		
                SysMasterVoices.setText(MyVoiceExpander.getNumbOfVoicesPlaying() +" / " +MyVoiceExpander.NumbOfVoices);
                PosPlayingIndex = SymphManager.SymSong.getPositionIndexPlaying();
                if(PosPlayingIndex >= 0) {
                    if(SymphManager.SymSong.checkUpdatePlayingPos()) {
			// Update actual Position Shown
			PosListJList.setSelectedIndex(PosPlayingIndex);
			moveToPositionIndex(PosPlayingIndex, false);
		    }
                    RTDrawPEDPosition(SymphManager.SymSong.getPosition(PosPlayingIndex).PatternNumbers[0]);
		    RTDrawPEDEditCrsr();
		    if(SysUpdateInstr.isSelected())  RTDrawInstr();
                }
            }
        }
    }

    void RTDrawInstr() {
	if(SysUpdateInstr.isSelected()) {
	    int VoiceNr = SymphManager.PED.getEditCrsrVoiceNr();
	    Voice v = SymphManager.MyVoiceExpander.getVoiceNr(VoiceNr);
	    if(v!=null) {
		int InstrID = v.getLastInstrIdPlayed();
		if(InstrID!=-1 && SymphManager.getActualInstrumentID()!=InstrID) {
		    SymphManager.MoveToInstr(SymphManager.SymSong.getIndexOfInstrumentID(InstrID));
		    SymphManager.InstrED.UpdateActualInstrDetails();
		}
	    }
	}
    }
    
    void RTDrawPEDVolumes() {
        for(int i=0;i<SymphManager.SymSong.getNumbOfVoices();i++) {
            Voice v = MyVoiceExpander.getVoiceNr(i);
            if( (v.inUse) && (!v.isPausing) ) {
                SymphManager.PED.DrawVoiceVolumeBar(i, v.ChannelVolume);
            } else {
                SymphManager.PED.DrawVoiceVolumeBar(i, 0);
            }
        }
    }
    
    int OldPatternNr = -1;
    int PlayingRowNr = 0;
    void RTDrawPEDPosition(int NewPatternNr) {
	// Jump to Pattern Nr
	if (SysUpdatePatternNr.isSelected()) {
	    if(NewPatternNr!=OldPatternNr) {
		OldPatternNr = NewPatternNr;
		SymphManager.PED.setActualPatternNr(NewPatternNr);
		SymphManager.PED.DrawAll(true);
	    }
	}
    }
    
    void RTDrawPEDEditCrsr() {
	if(SysUpdateCrsr.isSelected()) SymphManager.PED.moveEditCrsrToRowNr((int) SymphManager.SymSong.getPlayingLineNr());
    }
    
    
    
 
    boolean UIUpdateThreadStarted = false;
    void startUIRealTimeUpdate() {
        if(UIUpdateThreadStarted==false) {
            myUIUpdateThread.setCoalesce(true);
            myUIUpdateThread.setInitialDelay(5000);
            myUIUpdateThread.start();
            UIUpdateThreadStarted = true;
        } else {
        }
    }    

    ActionListener taskPerformer = new ActionListener() {
        public void actionPerformed(ActionEvent evt) {
            UpdateRealtimeUIInfos();
        }
    };
    Timer myUIUpdateThread = new Timer(250, taskPerformer);
    
    // Audio System Management -------------------------
    boolean VoiceExpanderStarted = false;
    void startAudioSystem() {
        if(VoiceExpanderStarted==false) {
            MyVoiceExpander.OpenMixSystem();
            VoiceExpanderTask.setName("Symphonie Voice Expander Task v1.0");
            VoiceExpanderTask.start();
            SymphManager.setVoiceExpander(MyVoiceExpander);
            VoiceExpanderStarted = true;
            SysStatusLabel.setText(MyVoiceExpander.ErrorString);
        }
        //writePreferences();
    }

    
    // Task Voiceexpander
    class VoiceExpanderThread extends Thread {
        VoiceExpanderThread() {
        }
        @Override
        public void run() {
            while(true) {
                MyVoiceExpander.PlayActualMixThread();
                VoiceExpanderThread.yield();
            }
        }
    }
    VoiceExpanderThread VoiceExpanderTask = new VoiceExpanderThread(); 
    
    private void ActionInstrListElement() {
        int i;
        i = InstrList.getMinSelectionIndex();
	i = SymphManager.getInstrIndexFromInstrListIndex(i);
        SymphManager.MoveToInstr(i);
    }
    
    
    // Section Position Designer
    void moveToPositionIndex(int i, boolean b) {
	PosEdNr.setValue(i);
	if(b==true) showPositionNr(i);
    }
    
    void showPositionNr(int PosNr) {
	if(PosNr>=0 && PosNr<SymphManager.SymSong.getNumbOfPositions()) {
	    Position myPos = SymphManager.SymSong.getPosition(PosNr);
	    if(myPos != null && myPos.PatternNumbers!=null) {
		PosEdCycl.setValue(myPos.Speed_Cycl);
		PosEdPatternNr.setValue(myPos.PatternNumbers[0]);
		PosEdStart.setValue(myPos.StartRow);
		PosEdLen.setValue(myPos.RowLength);
		PosEdTune.setValue(myPos.Tune);
		PosEdLoop.setValue(myPos.NumbOfLoops);
		PosEdNameText.setText(myPos.Name);
	    }	    
	}
    }
    
    Position getPositionIndex(int PosNr) {
	if(PosNr>=0 && PosNr<SymphManager.SymSong.getNumbOfPositions()) {
	    return(SymphManager.SymSong.getPosition(PosNr));
	} else {
	    return(null);
	}
    }
    
    void updatePosListFromPosIndex(int i) {
	if(i>=0 && i<SymphManager.SymSong.getNumbOfPositions()) {
	    Position Pos = SymphManager.SymSong.getPosition(i);
	    if(Pos != null) {
		PosListModel.set(i, Pos.buildPosListString(i));
	    }
	}
    }
    
    void initPositionIndex(int i) {
	Position pos = getPositionIndex(i);
	if(pos!=null) {
	    pos.NumbOfLayers = 1;
	    pos.NumbOfLoops = 1;
	    pos.RowLength = SymphManager.SymSong.getNumbOfRows();
	    pos.Speed_Cycl = 4;
	    pos.StartRow = 0;
	    pos.Tune = 0;
	}
    }
    
    int getActualPositionIndex() {
	return(SymphManager.getSpinnerValue(PosEdNr));
    }
    
    void duplicatePosition(int i) {
	Position src,dest;
	src = getPositionIndex(i);
	dest = getPositionIndex(i+1);
	if(src != null && dest!=null) {
	    src.copyValues(dest);
	}
    }
    
    void insertPosAtActualPosition() {
	int StartIndex = getActualPositionIndex();
	for(int i=SymphManager.SymSong.getNumbOfPositions()-2;i>=StartIndex;i--) {
	    duplicatePosition(i);
	}
    }
    
    
    
    
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JList InstrList;
    private javax.swing.JToolBar MenuBar;
    private javax.swing.JCheckBox PEDDisplayMouseCrsr;
    private javax.swing.JSpinner PosEdCycl;
    private javax.swing.JFrame PosEdFrame;
    private javax.swing.JSpinner PosEdLen;
    private javax.swing.JSpinner PosEdLoop;
    private javax.swing.JPanel PosEdMainPanel;
    private javax.swing.JTextField PosEdNameText;
    private javax.swing.JSpinner PosEdNr;
    private javax.swing.JSpinner PosEdPatternNr;
    private javax.swing.JSpinner PosEdStart;
    private javax.swing.JTabbedPane PosEdTab;
    private javax.swing.JToolBar PosEdToolbar;
    private javax.swing.JSpinner PosEdTune;
    private javax.swing.JList PosListJList;
    private javax.swing.JScrollPane PosListPane;
    private javax.swing.JFrame PosListjFrame;
    private javax.swing.JButton SymLoad;
    private javax.swing.JPanel SysDSPPanel;
    private javax.swing.JCheckBox SysDeclicking;
    private javax.swing.JSlider SysDeclickingLenSlider;
    private javax.swing.JComboBox SysDitheringCombox;
    private javax.swing.JSlider SysDspFeedback;
    private javax.swing.JComboBox SysDspFxTypeCombox;
    private javax.swing.JCheckBox SysDspLPFilter;
    private javax.swing.JSlider SysDspLength;
    private javax.swing.JSlider SysDspMixVolumeSlider;
    private javax.swing.JSlider SysDspPreDelay;
    private javax.swing.JComboBox SysInterpolationType;
    private javax.swing.JCheckBox SysLoadModDeactivateDsp;
    private javax.swing.JPanel SysLoadingPanel;
    private javax.swing.JTextField SysMasterBPM;
    private javax.swing.JSlider SysMasterBPMAdj;
    private javax.swing.JSlider SysMasterTune;
    private javax.swing.JTextField SysMasterVoices;
    private javax.swing.JSlider SysMasterVolume;
    private javax.swing.JComboBox SysMixRate;
    private javax.swing.JSlider SysPitchDiff;
    private javax.swing.JSlider SysPitchDiff2;
    private javax.swing.JSlider SysSampleDiff;
    private javax.swing.JPanel SysSoundDesignPanel;
    private javax.swing.JLabel SysStatusLabel;
    private javax.swing.JCheckBox SysSyncToBeat;
    private javax.swing.JTabbedPane SysTab;
    private javax.swing.JCheckBox SysUpdateCrsr;
    private javax.swing.JCheckBox SysUpdateInstr;
    private javax.swing.JPanel SysUpdatePanel;
    private javax.swing.JCheckBox SysUpdatePatternNr;
    private javax.swing.JCheckBox SysUpdateSamplePos;
    private javax.swing.JPanel SystemPanel;
    private javax.swing.JFrame frmInstrList;
    private javax.swing.JButton jButton1;
    private javax.swing.JButton jButton3;
    private javax.swing.JButton jButton4;
    private javax.swing.JButton jButton5;
    private javax.swing.JButton jButton6;
    private javax.swing.JButton jButton7;
    private javax.swing.JCheckBox jCheckBox1;
    private javax.swing.JCheckBox jCheckBox2;
    private javax.swing.JLabel jLabel1;
    private javax.swing.JLabel jLabel10;
    private javax.swing.JLabel jLabel11;
    private javax.swing.JLabel jLabel12;
    private javax.swing.JLabel jLabel13;
    private javax.swing.JLabel jLabel14;
    private javax.swing.JLabel jLabel15;
    private javax.swing.JLabel jLabel16;
    private javax.swing.JLabel jLabel17;
    private javax.swing.JLabel jLabel18;
    private javax.swing.JLabel jLabel19;
    private javax.swing.JLabel jLabel2;
    private javax.swing.JLabel jLabel20;
    private javax.swing.JLabel jLabel21;
    private javax.swing.JLabel jLabel22;
    private javax.swing.JLabel jLabel23;
    private javax.swing.JLabel jLabel24;
    private javax.swing.JLabel jLabel25;
    private javax.swing.JLabel jLabel26;
    private javax.swing.JLabel jLabel27;
    private javax.swing.JLabel jLabel3;
    private javax.swing.JLabel jLabel4;
    private javax.swing.JLabel jLabel5;
    private javax.swing.JLabel jLabel6;
    private javax.swing.JLabel jLabel7;
    private javax.swing.JLabel jLabel8;
    private javax.swing.JLabel jLabel9;
    private javax.swing.JList jList1;
    private javax.swing.JMenuItem jMenuItem1;
    private javax.swing.JMenuItem jMenuItem2;
    private javax.swing.JPanel jPanel1;
    private javax.swing.JScrollPane jScrollPane1;
    private javax.swing.JScrollPane jScrollPane2;
    private javax.swing.JMenuItem loadModMenuItem;
    private javax.swing.JMenuItem loadSampleMenuItem;
    private javax.swing.JPanel mainPanel;
    private javax.swing.JMenuBar menuBar;
    private javax.swing.JMenuItem newSongMenuItem;
    private javax.swing.JButton playPatternButton;
    private javax.swing.JButton playSongButton;
    private javax.swing.JButton stopSongButton;
    private org.jdesktop.beansbinding.BindingGroup bindingGroup;
    // End of variables declaration//GEN-END:variables

    private final Timer messageTimer;
    private final Timer busyIconTimer;
    private final Icon idleIcon;
    private final Icon[] busyIcons = new Icon[15];
    private int busyIconIndex = 0;

    private JDialog aboutBox;
}


