/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

package symreader;


import java.io.File;
import java.io.FileOutputStream;
import java.io.FileInputStream;

import java.io.IOException;


import java.text.NumberFormat;
import java.text.ParseException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JFileChooser;
import java.io.BufferedOutputStream;


import symreader.SymReaderView.UIManager;

/**
 *
 * @author File Format designed by Patrick Meng 2008
 * Features: is optimized for robustness and high tolerance
 *           loading of data can continue even if large parts of the data is missing
 *           or is broken
 */

    interface SymTags {
        String Content              = "SymphonieSongModule";
        String ObjectBegin          = "@OBJECTBEGIN";
        String ObjectEnd            = "@OBJECTEND";
        String ArrayNames           = "@ARRAYNAME";
        String ArrayPos             = "@ARRAYPOS";
        String ArrayEnd             = "@ARRAYEND";
        String TRUE                 = "@TRUE";
        String FALSE                = "@FALSE";
        String Objectversion        = "ObjectVersion";
        
        String SymObjSong           = "Song";
        String SymObjSequence       = "Sequence";
        
        String Action               = "Action";
        String StartPosition        = "StartPosition";
        String EndPosition          = "EndPosition";
        String Name                 = "Name";
        String NumbOfLoops          = "NumbOfLoops";
        String Tune                 = "Tune";
        String SymObjPosition       = "Position";
        String NumbOfLayers         = "NumbOfLayers";
        String StartRow             = "StartRow";
        String RowLength            = "RowLength";
        String SpeedCycl            = "SpeedCycl";
        String NumbOfRows           = "NumbOfTimePos";
        
        String Type                 = "Type";
        String Volume               = "Volume";
        String ID                   = "ID";
        String FineTune             = "FineTune";
        String LoopStart            = "LoopStart";
        String Looplen              = "Looplen";
        String LineSampleFlags      = "LineSampleFlags";
        String PlayFlag             = "PlayFlag";
        String MultiChannel         = "MultiChannel";
        String Resonance            = "Resonance";
        String VirtualSample        = "VirtualSample";
        String AllowPosDetune       = "AllowPosDetune";
        String NoDsp                = "NoDsp";
        String MirrorX              = "MirrorX";
        String PlayReverse          = "PlayReverse";
        String PlaySynced           = "PlaySynced";

        String FXClass              = "FXClass";
        String SongFXType           = "SongFXType";
        String A                    = "A";
        String B                    = "B";
        String C                    = "C";
        String D                    = "D";
        
        String SymObjEvent           = "Event";
        String SymObjInstrument      = "Instrument";
        String SymObjInstrumentData  = "InstrumentData";
        
        String Mixfrequency         = "Mixfrequency";
        String BPM                  = "BPM";
        String MasterVolume         = "MasterVolume";
        String NumbOfSequences      = "NumbOfSequences";
        String NumbOfPositions      = "NumbOfPositions";
        String NumbOfInstruments    = "NumbOfInstruments";
        String NumbOfPatterns       = "NumbOfPatterns";
        String NumbOfVoices         = "NumbOfVoices";
        String PatternSize          = "PatternSize";
        String PatternNr            = "PatternNr";
        String FlexibleTiming       = "FlexibleTiming";
        String EventsPerEventPool   = "EventsPerEventPool";
	
	String SymObjSamples	    = "RawSampleData";
	String RawDataBlockLen	    = "@RAWDATALEN";
	
	String PanningActive	    = "PanningActive";
	String PanningX		    = "PanningX";
	
	// Meta Info
	String MetaR		    = "MetaR";
	String MetaG		    = "MetaG";
	String MetaB		    = "MetaB";
	String MetaMainLead	    = "MetaMainLead";
	String MetaLead2	    = "MetaLead2";
	String MetaBackground	    = "MetaBackground";
	String MetaPercussion	    = "MetaPercussion";
	String MetaBeat		    = "MetaBeat";
	String MetaSubBeat	    = "MetaSubBeat";

    }

class SongToken {
    String Object;
    String ID;
    String Value;
    boolean isValid;
    
    private int ActArrayPos = 0;
    private float ArrayCoors[] = new float[10]; // upto to 10 Dimensional Arrays
    
    int Warnings = 0;
    
    void addArrayCoor(float Coor) {
        if(ActArrayPos<ArrayCoors.length) {
            ArrayCoors[ActArrayPos] = Coor;
            ActArrayPos++;
        } else {
            Warnings++;
        }
    }
    void resetArray() { ActArrayPos = 0;}
    int getArrayLen() {return(ActArrayPos);}
    float getArrayCoor(int Index) {
        if(Index<=ActArrayPos) {
            return(ArrayCoors[Index]);
        } else {
            Warnings++;
            return(0);
        }
    }
    
    String getStringValue() {return(Value);}
    float getFloatValue() {
        try {
            Number n;
            NumberFormat nf = NumberFormat.getInstance();
            n = nf.parse(Value);
            return n.floatValue();
        } catch (ParseException ex) {
            Logger.getLogger(SongToken.class.getName()).log(Level.SEVERE, null, ex);
            return(0);
        }
    }
    int getIntValue() {
        try {
            Number n;
            NumberFormat nf = NumberFormat.getInstance();
            n = nf.parse(Value);
            return n.intValue();
        } catch (ParseException ex) {
            Logger.getLogger(SongToken.class.getName()).log(Level.SEVERE, null, ex);
            return(0);
        }
    }
    
    boolean getBoolValue() {
	return(Value.equals(SymTags.TRUE));
    }
    
    SongToken() {
        resetArray();
        ActArrayPos = 0;
        Warnings = 0;
    }
}


public class SongIO {

    private boolean ok;
    private JFileChooser JFC = new JFileChooser();
    private File baseFile;
    //OutputStream basefo;
    FileOutputStream basefounbuffered;
    BufferedOutputStream basefo;
    String ObjectID;
    FileInputStream basefi;
    SongToken IOToken = new SongToken();
    
    byte[] ReadBuffer = new byte[1024];
    int ReadBufferPos = 0;
    boolean EOF = false;
    String[] TokenArray = new String[20]; // = new String[20];
    String[] TokenArray2 = new String[20]; // = new String[20];
    char Limiter = 34;
    UIManager SymphManager = null;


    void setUIManager(UIManager mySymphManager) {
        SymphManager = mySymphManager;
    }
    
    void SongSave() {
    }
    
    void saveAs(Song MySong) {
	File f = new File(SymphManager.getNewModPath());
	JFC.setCurrentDirectory(f);
	if (JFC.showSaveDialog(JFC) == JFileChooser.APPROVE_OPTION) {
            baseFile = JFC.getSelectedFile();
	    SymphManager.registerNewModPath(JFC.getCurrentDirectory().getAbsolutePath());
            save(MySong, baseFile);
        }
    }
    
    void loadAs(Song MySong) {
        boolean Sucess = false;
	File f = new File(SymphManager.getNewModPath());
	JFC.setCurrentDirectory(f);
	    
	if (JFC.showOpenDialog(JFC) == JFileChooser.APPROVE_OPTION) {
        try {
                baseFile = JFC.getSelectedFile();
		SymphManager.registerNewModPath(JFC.getCurrentDirectory().getAbsolutePath());
                basefi = new FileInputStream(baseFile);
                if(checkIsSymphonieFormat() && (!this.EOF)) {
                    Sucess = loadSongInfo(MySong);
                }
                basefi.close();
            } catch (Exception ex) {
                Logger.getLogger(SongIO.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
    }
    
    boolean loadSongInfo(Song MySong) {
        boolean Sucess = false;
        SongPattern MyPattern = null;
        Position Pos = null;
        SongEvent se = new SongEvent();
        SongEvent myEvent = null;
        int PatternNr, VoiceIndex;
        float TimePos;
        PatternVoice PatVoc;
        SongEventPool sep;
        int EventCounter;
	SymphonieInstrument si = null;
	int ActualSampleIndex = 0;
        
        EventCounter = 0;
        MySong.allocDefaultSong();
        while (EOF==false) {
           
            readToken(IOToken);
            
	    // Load Song Info
            if(IOToken.Object.equals(SymTags.SymObjSong) ){
                if(IOToken.ID.equals(SymTags.BPM)) {
		    SymphManager.PrintToInfoWindow("BPM:" + IOToken.getFloatValue());
		    SymphManager.setBPM(IOToken.getFloatValue());
		    MySong.setBPM(IOToken.getFloatValue());
		}
                if(IOToken.ID.equals(SymTags.NumbOfSequences)) {MySong.allocNumbOfSequences(IOToken.getIntValue());}
                if(IOToken.ID.equals(SymTags.NumbOfPositions)) {MySong.allocNumbOfPositions(IOToken.getIntValue());}
                if(IOToken.ID.equals(SymTags.NumbOfVoices)) {MySong.setNumbOfVoices(IOToken.getIntValue());}
                if(IOToken.ID.equals(SymTags.NumbOfPatterns)) {MySong.allocNumbOfPatterns(IOToken.getIntValue());}
                if(IOToken.ID.equals(SymTags.NumbOfInstruments)) {MySong.allocNumbInstruments(IOToken.getIntValue());}
                if(IOToken.ID.equals(SymTags.NumbOfRows)) {MySong.setNumbOfRows(IOToken.getIntValue());}
            }
            
	    // Load Sequences
	    if(IOToken.Object.equals(SymTags.SymObjSequence) ){
            }
            
	    // Load Positions
	    if(IOToken.Object.equals(SymTags.SymObjPosition) ){
                if(IOToken.ID.equals(SymTags.ArrayPos)) {
                    Pos = MySong.getPosition(IOToken.getIntValue());
                    Pos.setNumbOfLayers(1);
                    //SymphManager.PrintToInfoWindow("Position:"+IOToken.getIntValue());
                }
                if(Pos!=null && IOToken.ID.equals(SymTags.Name))            {Pos.Name = IOToken.getStringValue();}
                if(Pos!=null && IOToken.ID.equals(SymTags.StartRow))        {Pos.StartRow = IOToken.getIntValue();}
                if(Pos!=null && IOToken.ID.equals(SymTags.RowLength))       {Pos.RowLength = IOToken.getIntValue();}
                if(Pos!=null && IOToken.ID.equals(SymTags.PatternNr))       {Pos.PatternNumbers[0] = IOToken.getIntValue();}
                if(Pos!=null && IOToken.ID.equals(SymTags.NumbOfLayers))    {Pos.NumbOfLayers = IOToken.getIntValue();}
                if(Pos!=null && IOToken.ID.equals(SymTags.SpeedCycl))       {Pos.Speed_Cycl = IOToken.getIntValue();}
                if(Pos!=null && IOToken.ID.equals(SymTags.Tune))            {Pos.Tune = IOToken.getIntValue();}
                if(Pos!=null && IOToken.ID.equals(SymTags.NumbOfLoops))     {Pos.NumbOfLoops = IOToken.getIntValue();}
		
            }
            
	    // Load Pattern Events
	    if(IOToken.Object.equals(SymTags.SymObjEvent) ){
                if(IOToken.ID.equals(SymTags.ArrayPos)) {
                    if(IOToken.getArrayLen()==3) {
                        IOToken.resetArray();
                    }
                    
                    IOToken.addArrayCoor(IOToken.getFloatValue());
                    if(IOToken.getArrayLen()==3) {
                        // allocate Event Position
                        PatternNr = (int)IOToken.getArrayCoor(0);
                        VoiceIndex = (int)IOToken.getArrayCoor(1);
                        TimePos = IOToken.getArrayCoor(2);
                        MyPattern = MySong.getPattern((int)IOToken.getArrayCoor(0));
                        if(MyPattern.checkIsInitialized()==false) {
                            MyPattern.init(MySong.getNumbOfVoices());    
                        }
                        MyPattern.addSongEvent(VoiceIndex, TimePos, se);
                        PatVoc = MyPattern.PatternVoices[VoiceIndex];
                        sep = PatVoc.getSongEventPool(TimePos);
                        myEvent = sep.getSongEvent(0);
                        EventCounter++;
                    }
                }
                if(myEvent!=null && IOToken.ID.equals(SymTags.FXClass)) {myEvent.FXClass = IOToken.getIntValue();}
                if(myEvent!=null && IOToken.ID.equals(SymTags.SongFXType)) {myEvent.SongFXType = IOToken.getIntValue();}
                if(myEvent!=null && IOToken.ID.equals(SymTags.A)) {myEvent.A = IOToken.getIntValue();}
                if(myEvent!=null && IOToken.ID.equals(SymTags.B)) {myEvent.B = IOToken.getIntValue();}
                if(myEvent!=null && IOToken.ID.equals(SymTags.C)) {myEvent.C = IOToken.getIntValue();}
                if(myEvent!=null && IOToken.ID.equals(SymTags.D)) {myEvent.D = IOToken.getIntValue();}
            }
            
            // Load Instruments
	    if(IOToken.Object.equals(SymTags.SymObjInstrument) ){
                
		if(IOToken.ID.equals(SymTags.ArrayPos)) {
		    ActualSampleIndex = IOToken.getIntValue();
                    si = MySong.getInstrumentIndex(ActualSampleIndex);
                }
		if(si != null) {
		    if(IOToken.ID.equals(SymTags.Name))	{
			si.Name = IOToken.getStringValue();
			//SymphManager.addInstrumentList(si.Name);
		    }    
		    if(IOToken.ID.equals(SymTags.Type))			{
			si.Type = IOToken.getIntValue();
			if(si.Type==0) {
			    si.deactivateLoop();
			}
			if(si.Type==4) {
			    si.setHasLoop(true);
			}
		    }    
		    if(IOToken.ID.equals(SymTags.Volume))		{si.Volume = IOToken.getIntValue();}    
		    if(IOToken.ID.equals(SymTags.ID)) {
			si.ID = IOToken.getIntValue();
			MySong.setIDOfInstrIndex(si.ID, ActualSampleIndex);
		    }    
		    if(IOToken.ID.equals(SymTags.Tune))			{si.Tune = IOToken.getIntValue();}    
		    if(IOToken.ID.equals(SymTags.FineTune))		{si.FineTune = IOToken.getIntValue();}    
		    if(IOToken.ID.equals(SymTags.LoopStart))		{si.setLoopStart(IOToken.getIntValue());}    
		    if(IOToken.ID.equals(SymTags.Looplen))		{si.setLoopLen(IOToken.getIntValue());}    
		    if(IOToken.ID.equals(SymTags.NumbOfLoops))		{si.setNumbOfLoops(IOToken.getIntValue());}
		    if(IOToken.ID.equals(SymTags.LineSampleFlags))	{si.LineSampleFlags = IOToken.getIntValue();}    
		    if(IOToken.ID.equals(SymTags.PlayFlag))		{si.PlayFlag = IOToken.getIntValue();}    
		    if(IOToken.ID.equals(SymTags.MultiChannel))		{si.MultiChannel = IOToken.getIntValue();}    
		    if(IOToken.ID.equals(SymTags.Resonance))		{si.Resonance = IOToken.getIntValue();}    
		    if(IOToken.ID.equals(SymTags.VirtualSample))	{si.VirtualSample = IOToken.getBoolValue();}    
		    if(IOToken.ID.equals(SymTags.AllowPosDetune))	{si.AllowPosDetune = IOToken.getBoolValue();}    
		    if(IOToken.ID.equals(SymTags.NoDsp))		{si.NoDsp = IOToken.getBoolValue();}    
		    if(IOToken.ID.equals(SymTags.MirrorX))		{si.MirrorX = IOToken.getBoolValue();}    
		    if(IOToken.ID.equals(SymTags.PlayReverse))		{si.PlayReverse = IOToken.getBoolValue();}    
		    if(IOToken.ID.equals(SymTags.PlaySynced))		{si.PlaySynced = IOToken.getBoolValue();}  
		    if(IOToken.ID.equals(SymTags.PanningActive))	{
			si.PanningActive = IOToken.getBoolValue();}  
		    if(IOToken.ID.equals(SymTags.PanningX))		{si.PanningX = IOToken.getIntValue();}  
		    
		    // Meta Info
		    if(IOToken.ID.equals(SymTags.MetaMainLead))		{si.MetaInfo.MainLead = IOToken.getBoolValue();}  
		    if(IOToken.ID.equals(SymTags.MetaLead2))		{si.MetaInfo.Lead2 = IOToken.getBoolValue();}  
		    if(IOToken.ID.equals(SymTags.MetaPercussion))	{si.MetaInfo.Percussion = IOToken.getBoolValue();}  
		    if(IOToken.ID.equals(SymTags.MetaBeat))		{si.MetaInfo.Beat = IOToken.getBoolValue();}  
		    if(IOToken.ID.equals(SymTags.MetaSubBeat))		{si.MetaInfo.SubBeat = IOToken.getBoolValue();}  

		    if(IOToken.ID.equals(SymTags.MetaR))		{si.MetaInfo.R = IOToken.getIntValue();} 
		    if(IOToken.ID.equals(SymTags.MetaG))		{si.MetaInfo.G = IOToken.getIntValue();} 
		    if(IOToken.ID.equals(SymTags.MetaB))		{si.MetaInfo.B = IOToken.getIntValue();} 
		}

	    }
            
            // Load Instrument Samples
	    if(IOToken.Object.equals(SymTags.SymObjSamples) ){
		
		if(IOToken.ID.equals(SymTags.ArrayPos)) {
		    ActualSampleIndex = IOToken.getIntValue();
                    si = MySong.getInstrumentIndex(ActualSampleIndex);
                }
		if(si != null) {
		    if(IOToken.ID.equals(SymTags.RawDataBlockLen)) {
			try {
			    int SampleLenByte = IOToken.getIntValue();
			    byte[] Samples = new byte[SampleLenByte];
			    basefi.read(Samples);
			    BuildInstrumentSamples(si, Samples, Samples.length, ActualSampleIndex, MySong);
			    MySong.getInstrumentIndex(ActualSampleIndex).SampleDataLoaded = true;
			    SymphManager.PrintToInfoWindow("Sample imported("+ActualSampleIndex+"):" 
				    + Samples.length + " byte");
			} catch (IOException ex) {
			    EOF = true;
			    SymphManager.PrintToInfoWindow("Error while reading Sample Data. Aborted.");
			    Logger.getLogger(SongIO.class.getName()).log(Level.SEVERE, null, ex);
			}
		    }
		}
	    }
        }
        SymphManager.PrintToInfoWindow("Number of Events:"+EventCounter);
        SymphManager.refreshPositionsList();
        return(Sucess);
    }
    
    private void BuildInstrumentSamples(SymphonieInstrument si, byte[] src, int len, int ActualSampleIndex, Song MySong) {
        si.ImportSample.Analyse(src, len);
        si.sp = si.ImportSample.SamplePools[0];
        si.sp.initLoopData(si.hasLoop(), si.getLoopStart(), si.getLoopLen(), si.getNumbOfLoops());
        si.SampleDataLoaded = true;
        si.isInUse = true;
        if(si.MultiChannel==1) {
            if(si.ImportSample.getNumbOfChannels() ==2 ) {
                SymphonieInstrument siRight = MySong.getInstrumentIndex(ActualSampleIndex+1);
                siRight.sp = si.ImportSample.SamplePools[1];
                siRight.sp.initLoopData(si.hasLoop(), si.getLoopStart(), si.getLoopLen(), si.getNumbOfLoops());
                siRight.SampleDataLoaded = true;
                siRight.isInUse = true;
                siRight.MultiChannel = 2;
                siRight.Name = si.Name;
                //si.Name = si.Name;
            } else {
                // error Stereo Sample not correctly recognized
            }
        }
    }
    
    boolean checkIsSymphonieFormat() {
        EOF = false;
        readToken(IOToken);
        if(IOToken.Object.equals("Content") && IOToken.ID.equals(SymTags.Content) ) {
            return(true);
        }
        return(false);
    }
    
    void readToken(SongToken myToken) {
        String s = readNextLine();
        myToken.isValid = true;
        TokenArray = s.split(""+Limiter , 10);
        if(TokenArray.length>=5) {
            if( TokenArray[0].equals("{") &&
                TokenArray[2].equals(":") &&
                TokenArray[4].equals("}") ) {
                s = TokenArray[1];
                myToken.Value = TokenArray[3];
                int pos = TokenArray[1].indexOf(".");
                if(pos>0) {
                    myToken.Object = s.substring(0, pos);
                    myToken.ID = s.substring(pos+1);
                    myToken.isValid = true;
                }
            }
        }
    }
    
    String readNextLine() {
        String s="";
        boolean done = false;
        int MaxReadLen = 1024;
        int len, Count=0;
        ReadBufferPos = 0;
        try {
            while(done==false) {
                len = basefi.read();
                if (len == -1) {
                    done = true;
                    EOF = true;
                } else {
                    if (len == 13) {
                        done = true;
                    } else {
                        byte b = (byte) len;
                        s += (char) b;
                        Count++;
                        if(Count>=MaxReadLen) done = true;
                    }
                }
            }
        } catch (IOException ex) {
            Logger.getLogger(SongIO.class.getName()).log(Level.SEVERE, null, ex);
            done = true;
            EOF = true;
        }
        return(s);
    }
    

    
    void save(Song MySong, File myFile) {
        try {
            if(myFile.createNewFile()==true) {
		basefounbuffered = new FileOutputStream(myFile);
                basefo = new BufferedOutputStream(basefounbuffered);
                ok = saveSongInfo(MySong);
                ok = saveSongSequences(MySong);
                ok = saveSongPositions(MySong);
                ok = saveInstruments(MySong);
                ok = savePatterns(MySong);
                ok = saveInstrumentsSamples(MySong);
                basefo.close();
            }
        } catch (IOException ex) {
            Logger.getLogger(SongIO.class.getName()).log(Level.SEVERE, null, ex);
        }
    }    
    
    boolean saveSongInfo(Song MySong) throws IOException {
        ObjectID = "Content";
        writeKey(SymTags.Content,2.0f);
        // ----------------------------------------------
        writeObjectBegin(SymTags.SymObjSong);
        writeKey(SymTags.Mixfrequency,MySong.MixFrequency);
        writeKey(SymTags.BPM,MySong.getBPM());
        writeKey(SymTags.MasterVolume,MySong.Volume);
        writeKey(SymTags.NumbOfSequences,MySong.getNumbOfSequences());
        writeKey(SymTags.NumbOfInstruments,MySong.getNumbOfInstruments());
        writeKey(SymTags.NumbOfPatterns,MySong.getNumbOfPatterns());
        writeKey(SymTags.NumbOfPositions,MySong.getNumbOfPositions());
        writeKey(SymTags.NumbOfVoices,MySong.getNumbOfVoices());
        writeKey(SymTags.PatternSize,MySong.getPatternSize());
        writeKey(SymTags.FlexibleTiming,false);
        writeKey(SymTags.EventsPerEventPool,1);
        writeKey(SymTags.EventsPerEventPool,1);
	writeKey(SymTags.NumbOfRows,MySong.getNumbOfRows());
        writeObjectEnd();
        return(true);
    }
    
    boolean saveSongSequences(Song MySong) throws IOException {
        Sequence Obj;
        writeObjectBegin(SymTags.SymObjSequence);
        writeKey(SymTags.ArrayNames, "SequenceIndex");
        for(int i = 0;i<MySong.getNumbOfSequences();i++) {
            Obj = MySong.getSequence(i);
            writeKey(SymTags.ArrayPos, i);
            writeKey(SymTags.Action, Obj.Action);
            writeKey(SymTags.StartPosition, Obj.StartPosition);
            writeKey(SymTags.EndPosition, Obj.EndPosition);
            writeKey(SymTags.Name, Obj.Name);
            writeKey(SymTags.NumbOfLoops, Obj.NumbOfLoops);
            writeKey(SymTags.Tune, Obj.Tune);
            writeKey(SymTags.ArrayEnd, 0);
        }
        writeObjectEnd();
        return(true);
    }    
    
    boolean saveSongPositions(Song MySong) throws IOException {
        Position Obj;
        writeObjectBegin(SymTags.SymObjPosition);
        writeKey(SymTags.ArrayNames, "PositionIndex");
        for(int i = 0;i<MySong.getNumbOfPositions();i++) {
            Obj = MySong.getPosition(i);
            writeKey(SymTags.ArrayPos, i);
            writeKey(SymTags.Name, Obj.Name);
            writeKey(SymTags.StartRow, Obj.StartRow);
            writeKey(SymTags.NumbOfLayers, Obj.NumbOfLayers);
            if(Obj.PatternNumbers != null) {
               writeKey(SymTags.PatternNr, Obj.PatternNumbers[0]);
            }
            writeKey(SymTags.NumbOfLoops, Obj.NumbOfLoops);
            writeKey(SymTags.RowLength, Obj.RowLength);
            writeKey(SymTags.SpeedCycl, Obj.Speed_Cycl);
            writeKey(SymTags.Tune, Obj.Tune);
            writeKey(SymTags.ArrayEnd, 0);
        }
        writeObjectEnd();
        return(true);
    }
    
    boolean saveInstruments(Song MySong) throws IOException {
        SymphonieInstrument Obj;
        writeObjectBegin(SymTags.SymObjInstrument);
        writeKey(SymTags.ArrayNames, "InstrumentIndex");
        for(int i = 0;i<MySong.getNumbOfInstruments();i++) {
            if(MySong.checkInstrumentIndexInUse(i)) { //geht nicht richtig
		Obj = MySong.getInstrumentIndex(i);
		writeKey(SymTags.ArrayPos, i);
		writeKey(SymTags.Name, Obj.Name);
		writeKey(SymTags.Type, Obj.Type);
		writeKey(SymTags.Volume, Obj.Volume);
		writeKey(SymTags.ID, Obj.ID);
		writeKey(SymTags.Tune, Obj.Tune);
		writeKey(SymTags.FineTune, Obj.FineTune);
		writeKey(SymTags.LoopStart, Obj.getLoopStart());
		writeKey(SymTags.Looplen, Obj.getLoopLen());
		writeKey(SymTags.NumbOfLoops, Obj.getNumbOfLoops());
		writeKey(SymTags.LineSampleFlags, Obj.LineSampleFlags);
		writeKey(SymTags.PlayFlag, Obj.PlayFlag);
		writeKey(SymTags.MultiChannel, Obj.MultiChannel);
		writeKey(SymTags.Resonance, Obj.Resonance);

		// Flags
		writeKey(SymTags.VirtualSample, Obj.VirtualSample);
		writeKey(SymTags.AllowPosDetune, Obj.AllowPosDetune);
		writeKey(SymTags.NoDsp, Obj.NoDsp);
		writeKey(SymTags.MirrorX, Obj.MirrorX);
		writeKey(SymTags.PlayReverse, Obj.PlayReverse);
		writeKey(SymTags.PlaySynced, Obj.PlaySynced);

		// Panning
		writeKey(SymTags.PanningActive, Obj.PanningActive);
		writeKey(SymTags.PanningX, Obj.PanningX);
		
		// Meta Info
		writeKey(SymTags.MetaR, Obj.MetaInfo.R);
		writeKey(SymTags.MetaG, Obj.MetaInfo.G);
		writeKey(SymTags.MetaB, Obj.MetaInfo.B);
		writeKey(SymTags.MetaMainLead, Obj.MetaInfo.MainLead);
		writeKey(SymTags.MetaLead2, Obj.MetaInfo.Lead2);
		writeKey(SymTags.MetaPercussion, Obj.MetaInfo.Percussion);
		writeKey(SymTags.MetaBeat, Obj.MetaInfo.Beat);
		writeKey(SymTags.MetaSubBeat, Obj.MetaInfo.SubBeat);
		
		
		writeKey(SymTags.ArrayEnd, 0);
	    }
        }
        writeObjectEnd();
        return(true);
    } 
    
    
    boolean saveInstrumentsSamples(Song MySong) throws IOException {
        SymphonieInstrument Obj;
        writeObjectBegin(SymTags.SymObjSamples);
        writeKey(SymTags.ArrayNames, "InstrumentIndex");
        for(int i = 0;i<MySong.getNumbOfInstruments();i++) {
            Obj = MySong.getInstrumentIndex(i);
            if(Obj.ImportSample.RawSample!=null) {
		writeKey(SymTags.ArrayPos, i);
		writeKey(SymTags.ID, Obj.ID);
		writeRawByteBlock(Obj.ImportSample.RawSample);
		writeKey(SymTags.ArrayEnd, 0);
	    }
        }
        writeObjectEnd();
        return(true);
    } 
    
    
    boolean savePatterns(Song MySong) throws IOException {
        SongPattern Obj;
        writeObjectBegin(SymTags.SymObjEvent);
        writeKey(SymTags.ArrayNames, "PatternNr,VoiceNr,PosTime");
        for(int i = 0;i<MySong.getNumbOfPatterns();i++) {
            Obj = MySong.getPattern(i);
            
            for(int PatVocNr=0;PatVocNr<Obj.getNumbOfVoices();PatVocNr++) {
                for(int RowNr=0;RowNr<Obj.getNumbOfRows();RowNr++) {
                    savePatternsEventPool(MySong, Obj, i, PatVocNr, RowNr);
                }
            }
        }
        writeObjectEnd();
        return(true);
    }
    
    boolean savePatternsEventPool(Song MySong, SongPattern Obj, int PatNr, int PatVocNr, int RowNr) {
        PatternVoice myPatternVoices = Obj.PatternVoices[PatVocNr];
        SongEventPool se;
        SongEvent mySongEvent;
        if(myPatternVoices!=null) {
            se = myPatternVoices.getSongEventPool(RowNr);
            if(se!=null) {
                mySongEvent = se.getSongEvent(0);
                if((mySongEvent!=null) && (mySongEvent.SongFXType != SongEventType.FX_NONE)) {
                    writeKey(SymTags.ArrayPos, PatNr);
                    writeKey(SymTags.ArrayPos, PatVocNr);
                    writeKey(SymTags.ArrayPos, se.TimePosition);
                    writeKey(SymTags.FXClass, mySongEvent.FXClass);
                    writeKey(SymTags.SongFXType, mySongEvent.SongFXType);
                    writeKey(SymTags.A, mySongEvent.A);
                    writeKey(SymTags.B, mySongEvent.B);
                    writeKey(SymTags.C, mySongEvent.C);
                    writeKey(SymTags.D, mySongEvent.D);
                    writeKey(SymTags.ArrayEnd, 0);
                }
            }
        }    
        return(true);
    }
    
    boolean writeObjectBegin(String myObjectID) {
        writeBeginKey();
        ObjectID = myObjectID;
        writeString2(ObjectID+"."+SymTags.ObjectBegin);
        writeEndKey();
        return(true);
    }
    boolean writeObjectEnd() {
        writeBeginKey();
        writeString2(ObjectID+"."+SymTags.ObjectEnd);
        writeEndKey();
        return(true);
    }
    
    boolean writeKey(String skey, boolean bValue) {
        if(bValue==true) {
            writeKey(skey, "@TRUE");
        } else {
            writeKey(skey, "@FALSE");
        }
        return(true);
    }    
    
    boolean writeKey(String skey, int sValue) {
        writeKey(skey, "" + ((float) sValue));
        return(true);
    }
    
    boolean writeKey(String skey, float sValue) {
        writeKey(skey, "" + sValue);
        return(true);
    }

    boolean writeKey(String skey, String sValue) {
        writeBeginKey();
        writeString2(ObjectID + "." + skey);
        writeString(":");
        writeString2(sValue);
        writeEndKey();
        return(true);
    }
    
    boolean writeBeginKey() {
        writeString("{");
        return(true);
    }
    boolean writeEndKey() {
        writeString("}");
        writeEOL();
        return(true);
    }
    
    boolean writeEOL() {
        return(writeByte(13));
    }
    
    boolean writeByte(int b) {
        try {
            basefo.write(b);
            return true;
        } catch (IOException ex) {
            Logger.getLogger(SongIO.class.getName()).log(Level.SEVERE, null, ex);
            return(false);
        }
    }
    
    boolean writeRawByteBlock(byte[] ByteArray) {
        try {
            writeKey(SymTags.RawDataBlockLen, ByteArray.length);
	    basefo.write(ByteArray);
            return true;
        } catch (IOException ex) {
            Logger.getLogger(SongIO.class.getName()).log(Level.SEVERE, null, ex);
            return(false);
        }	
    }
    
    boolean writeString2(String s) {
        writeByte(34);
        writeString(s);
        writeByte(34);
        return(true);
    }
    
    boolean writeString(String s) {
        if(s!=null) {
            for(int i=0;i<s.length();i++) {
                try {
                    basefo.write((byte)s.charAt(i) );
                } catch (IOException ex) {
                    Logger.getLogger(SongIO.class.getName()).log(Level.SEVERE, null, ex);
                    return(false);
                }
            }
        }
        return(true);
    }
}    
