/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

package symreader;
import java.lang.Math;

/**
 *
 * @author mp
 */

interface FilterType {
    int Off = 0;
    int Lowpass = 1;
    int	Bandpass = 2;
    int Highpass = 3;
    int Notch = 4;
    int Max=4;
}

public class SampleFilter {
    private boolean LPFilter = true;
    private double high=0, mid=0, low=0;
    private double freq,recq,q;
    //private boolean isactive = false;
    private int Type = FilterType.Off;
    
    SampleFilter() {
	init(0,0,44100, FilterType.Off);
	clearSampleBuffers();
    }
    
    void clearSampleBuffers() {
	high = 0; low = 0; mid = 0;
    }
    
    void init(int newFiltertype, double myq, double FilterFreq, double SampleRate) {
	Type = newFiltertype;
	if(Type>FilterType.Max) Type = FilterType.Off;
	if(FilterFreq==0.0f) {
	    Type = FilterType.Off;
	} else {
	    freq = 2 * java.lang.Math.sin(java.lang.Math.PI*FilterFreq*10/SampleRate);
	    //freq = (f*1.25f/100.0f);
	    if(myq!=0) {
		recq = 1/myq;
	    } else {
		recq = 1;
	    }
	}
    }
    
    boolean isActive() {
	return(Type != FilterType.Off);
    }
    
    float getNextFilteredSample(float Sample) {
	if(freq==0) Type = FilterType.Off;
	if(isActive()==true) {
	    high = clip(Sample - mid * recq - low);
	    mid += (high * freq);mid = clip (mid);
	    low += (mid * freq);low = clip (low);
	    switch(Type) {
		case FilterType.Lowpass: return((float) low);
		case FilterType.Highpass: return((float) high);
		case FilterType.Bandpass: return((float) mid);
		case FilterType.Notch: return((float) (low+high) );
	    } 
	    return((float) low);
	} else {
	    return(Sample);
	}
    }
    
    private double clip(double Sample) {
	if(Sample > 1.00d) return (1.00d);
	if(Sample < -1.00d) return (-1.00d);
	return(Sample);
    }
}
