/*
 * Decompiled with CFR 0.152.
 */
package symreader;

import java.awt.Color;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowFocusListener;
import java.text.NumberFormat;
import java.text.ParseException;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JColorChooser;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JLayeredPane;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.JSpinner;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import javax.swing.LayoutStyle;
import javax.swing.border.SoftBevelBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.jdesktop.application.Application;
import org.jdesktop.application.ResourceMap;
import org.jdesktop.beansbinding.AutoBinding;
import org.jdesktop.beansbinding.BeanProperty;
import org.jdesktop.beansbinding.Binding;
import org.jdesktop.beansbinding.BindingGroup;
import org.jdesktop.beansbinding.Bindings;
import org.jdesktop.beansbinding.ELProperty;
import org.jdesktop.beansbinding.Property;
import symreader.SymReaderApp;
import symreader.SymReaderView;
import symreader.SymphonieInstrument;

public class frmNewInstrFrame
extends JFrame {
    private JButton InstrDetExportRawSample;
    private JSpinner InstrDetFineTune;
    private JTextField InstrDetFormat;
    private JLabel InstrDetID;
    private JButton InstrDetLoadSample;
    private JSpinner InstrDetLoopLen;
    private JSpinner InstrDetLoopStart;
    private JLabel InstrDetLoopText;
    private JLabel InstrDetMouseRelTxt;
    private JCheckBox InstrDetNoDsp;
    private JSpinner InstrDetNrNew;
    private JSlider InstrDetPanSlider;
    private JCheckBox InstrDetPanningEnable;
    private JSpinner InstrDetPanorama;
    private JTextField InstrDetSampleResolution;
    private JLayeredPane InstrDetSampleView;
    private JComboBox InstrDetStereoType;
    private JCheckBox InstrDetSyncPlay;
    private JSpinner InstrDetTune;
    private JCheckBox InstrDetTwoWayLoop;
    private JTextField InstrDetTxt;
    private JComboBox InstrDetViewFormat;
    private JSpinner InstrDetVolume;
    private JCheckBox InstrNoDetune;
    private JCheckBox MetaBeat;
    private JPanel MetaColor;
    private JCheckBox MetaLead2;
    private JCheckBox MetaMainLead;
    private JPanel MetaPanel;
    private JCheckBox MetaPercussion;
    private JCheckBox MetaSubBeat;
    private JButton jButton1;
    private JButton jButton2;
    private JButton jButton3;
    private JColorChooser jColorChooser;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JTabbedPane jTabbedPane1;
    private JToolBar jToolBar1;
    private JLabel lblInstrNr;
    private JLabel lblInstrNr1;
    private JLabel lblInstrNr2;
    private JLabel lblInstrNr3;
    private BindingGroup bindingGroup;
    private SymReaderView.UIManager SymphManager;
    private boolean VerifyValues = true;
    private Color MetaColorTemp;
    int[] SampleViewMarkers = new int[256];
    int SampleViewMarkersCount = 0;

    public frmNewInstrFrame() {
        this.initComponents();
    }

    public void paint(Graphics g) {
        super.paint(g);
        this.redrawSampleFrame();
    }

    private void initComponents() {
        this.bindingGroup = new BindingGroup();
        this.jColorChooser = new JColorChooser();
        this.jToolBar1 = new JToolBar();
        this.InstrDetLoadSample = new JButton();
        this.jButton1 = new JButton();
        this.InstrDetExportRawSample = new JButton();
        this.jButton2 = new JButton();
        this.InstrDetSampleView = new JLayeredPane();
        this.InstrDetLoopText = new JLabel();
        this.jTabbedPane1 = new JTabbedPane();
        this.jPanel1 = new JPanel();
        this.lblInstrNr = new JLabel();
        this.lblInstrNr1 = new JLabel();
        this.lblInstrNr2 = new JLabel();
        this.lblInstrNr3 = new JLabel();
        this.InstrDetLoopStart = new JSpinner();
        this.InstrDetTune = new JSpinner();
        this.InstrDetVolume = new JSpinner();
        this.InstrDetNrNew = new JSpinner();
        this.InstrDetStereoType = new JComboBox();
        this.InstrDetSampleResolution = new JTextField();
        this.InstrDetFormat = new JTextField();
        this.InstrDetTxt = new JTextField();
        this.InstrDetFineTune = new JSpinner();
        this.InstrDetLoopLen = new JSpinner();
        this.jLabel2 = new JLabel();
        this.jLabel1 = new JLabel();
        this.InstrNoDetune = new JCheckBox();
        this.InstrDetMouseRelTxt = new JLabel();
        this.InstrDetSyncPlay = new JCheckBox();
        this.InstrDetNoDsp = new JCheckBox();
        this.InstrDetID = new JLabel();
        this.InstrDetViewFormat = new JComboBox();
        this.InstrDetTwoWayLoop = new JCheckBox();
        this.jPanel2 = new JPanel();
        this.InstrDetPanningEnable = new JCheckBox();
        this.jLabel3 = new JLabel();
        this.InstrDetPanorama = new JSpinner();
        this.InstrDetPanSlider = new JSlider();
        this.MetaPanel = new JPanel();
        this.MetaMainLead = new JCheckBox();
        this.MetaLead2 = new JCheckBox();
        this.MetaPercussion = new JCheckBox();
        this.MetaBeat = new JCheckBox();
        this.MetaSubBeat = new JCheckBox();
        this.MetaColor = new JPanel();
        this.jButton3 = new JButton();
        this.jColorChooser.setName("jColorChooser");
        ResourceMap resourceMap = Application.getInstance(SymReaderApp.class).getContext().getResourceMap(frmNewInstrFrame.class);
        this.setTitle(resourceMap.getString("Form.title", new Object[0]));
        this.setName("Form");
        this.addWindowFocusListener(new WindowFocusListener(){

            public void windowGainedFocus(WindowEvent evt) {
                frmNewInstrFrame.this.formWindowGainedFocus(evt);
            }

            public void windowLostFocus(WindowEvent evt) {
            }
        });
        this.addComponentListener(new ComponentAdapter(){

            public void componentShown(ComponentEvent evt) {
                frmNewInstrFrame.this.formComponentShown(evt);
            }
        });
        this.addFocusListener(new FocusAdapter(){

            public void focusGained(FocusEvent evt) {
                frmNewInstrFrame.this.formFocusGained(evt);
            }
        });
        this.jToolBar1.setFloatable(false);
        this.jToolBar1.setRollover(true);
        this.jToolBar1.setName("jToolBar1");
        this.InstrDetLoadSample.setFont(resourceMap.getFont("InstrDetLoadSample.font"));
        this.InstrDetLoadSample.setText(resourceMap.getString("InstrDetLoadSample.text", new Object[0]));
        this.InstrDetLoadSample.setBorder(new SoftBevelBorder(0));
        this.InstrDetLoadSample.setFocusable(false);
        this.InstrDetLoadSample.setHorizontalTextPosition(0);
        this.InstrDetLoadSample.setName("InstrDetLoadSample");
        this.InstrDetLoadSample.setVerticalTextPosition(3);
        this.InstrDetLoadSample.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                frmNewInstrFrame.this.InstrDetLoadSampleActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.InstrDetLoadSample);
        this.jButton1.setText(resourceMap.getString("jButton1.text", new Object[0]));
        this.jButton1.setBorder(new SoftBevelBorder(0));
        this.jButton1.setFocusable(false);
        this.jButton1.setHorizontalTextPosition(0);
        this.jButton1.setName("jButton1");
        this.jButton1.setVerticalTextPosition(3);
        this.jButton1.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                frmNewInstrFrame.this.jButton1ActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.jButton1);
        this.InstrDetExportRawSample.setFont(resourceMap.getFont("InstrDetExportRawSample.font"));
        this.InstrDetExportRawSample.setText(resourceMap.getString("InstrDetExportRawSample.text", new Object[0]));
        this.InstrDetExportRawSample.setBorder(new SoftBevelBorder(0));
        this.InstrDetExportRawSample.setFocusable(false);
        this.InstrDetExportRawSample.setHorizontalTextPosition(0);
        this.InstrDetExportRawSample.setName("InstrDetExportRawSample");
        this.InstrDetExportRawSample.setVerticalTextPosition(3);
        this.InstrDetExportRawSample.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                frmNewInstrFrame.this.InstrDetExportRawSampleActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.InstrDetExportRawSample);
        this.jButton2.setText(resourceMap.getString("jButton2.text", new Object[0]));
        this.jButton2.setBorder(new SoftBevelBorder(0));
        this.jButton2.setFocusable(false);
        this.jButton2.setHorizontalTextPosition(0);
        this.jButton2.setName("jButton2");
        this.jButton2.setVerticalTextPosition(3);
        this.jButton2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                frmNewInstrFrame.this.jButton2ActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.jButton2);
        this.InstrDetSampleView.setBackground(resourceMap.getColor("InstrDetSampleView.background"));
        this.InstrDetSampleView.setBorder(BorderFactory.createEtchedBorder());
        this.InstrDetSampleView.setDoubleBuffered(true);
        this.InstrDetSampleView.setName("InstrDetSampleView");
        this.InstrDetSampleView.addComponentListener(new ComponentAdapter(){

            public void componentResized(ComponentEvent evt) {
                frmNewInstrFrame.this.InstrDetSampleViewComponentResized(evt);
            }
        });
        this.InstrDetSampleView.addMouseMotionListener(new MouseMotionAdapter(){

            public void mouseMoved(MouseEvent evt) {
                frmNewInstrFrame.this.InstrDetSampleViewMouseMoved(evt);
            }
        });
        this.InstrDetLoopText.setForeground(resourceMap.getColor("InstrDetLoopText.foreground"));
        this.InstrDetLoopText.setText(resourceMap.getString("InstrDetLoopText.text", new Object[0]));
        this.InstrDetLoopText.setName("InstrDetLoopText");
        this.InstrDetLoopText.setBounds(10, 10, 130, -1);
        this.InstrDetSampleView.add((Component)this.InstrDetLoopText, JLayeredPane.DEFAULT_LAYER);
        this.jTabbedPane1.setToolTipText(resourceMap.getString("jTabbedPane1.toolTipText", new Object[0]));
        this.jTabbedPane1.setName("jTabbedPane1");
        this.jPanel1.setName("jPanel1");
        this.lblInstrNr.setText(resourceMap.getString("lblInstrNr.text", new Object[0]));
        this.lblInstrNr.setName("lblInstrNr");
        this.lblInstrNr1.setText(resourceMap.getString("lblInstrNr1.text", new Object[0]));
        this.lblInstrNr1.setName("lblInstrNr1");
        this.lblInstrNr2.setText(resourceMap.getString("lblInstrNr2.text", new Object[0]));
        this.lblInstrNr2.setName("lblInstrNr2");
        this.lblInstrNr3.setText(resourceMap.getString("lblInstrNr3.text", new Object[0]));
        this.lblInstrNr3.setName("lblInstrNr3");
        this.InstrDetLoopStart.setName("InstrDetLoopStart");
        this.InstrDetLoopStart.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent evt) {
                frmNewInstrFrame.this.InstrDetLoopStartStateChanged(evt);
            }
        });
        this.InstrDetTune.setName("InstrDetTune");
        this.InstrDetTune.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent evt) {
                frmNewInstrFrame.this.InstrDetTuneStateChanged(evt);
            }
        });
        this.InstrDetVolume.setName("InstrDetVolume");
        this.InstrDetVolume.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent evt) {
                frmNewInstrFrame.this.InstrDetVolumeStateChanged(evt);
            }
        });
        this.InstrDetNrNew.setName("InstrDetNrNew");
        this.InstrDetNrNew.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent evt) {
                frmNewInstrFrame.this.InstrDetNrNewStateChanged(evt);
            }
        });
        this.InstrDetStereoType.setModel(new DefaultComboBoxModel<String>(new String[]{"Mono", "Stereo L", "Stereo R", "Virtual Mix"}));
        this.InstrDetStereoType.setEnabled(false);
        this.InstrDetStereoType.setFocusable(false);
        this.InstrDetStereoType.setName("InstrDetStereoType");
        this.InstrDetSampleResolution.setEditable(false);
        this.InstrDetSampleResolution.setText(resourceMap.getString("InstrDetSampleResolution.text", new Object[0]));
        this.InstrDetSampleResolution.setBorder(BorderFactory.createEtchedBorder());
        this.InstrDetSampleResolution.setName("InstrDetSampleResolution");
        this.InstrDetFormat.setEditable(false);
        this.InstrDetFormat.setBorder(BorderFactory.createEtchedBorder());
        this.InstrDetFormat.setName("InstrDetFormat");
        this.InstrDetTxt.setEditable(false);
        this.InstrDetTxt.setFont(resourceMap.getFont("InstrDetTxt.font"));
        this.InstrDetTxt.setBorder(BorderFactory.createEtchedBorder());
        this.InstrDetTxt.setName("InstrDetTxt");
        this.InstrDetFineTune.setName("InstrDetFineTune");
        this.InstrDetFineTune.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent evt) {
                frmNewInstrFrame.this.InstrDetFineTuneStateChanged(evt);
            }
        });
        this.InstrDetLoopLen.setName("InstrDetLoopLen");
        this.InstrDetLoopLen.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent evt) {
                frmNewInstrFrame.this.InstrDetLoopLenStateChanged(evt);
            }
        });
        this.jLabel2.setText(resourceMap.getString("jLabel2.text", new Object[0]));
        this.jLabel2.setName("jLabel2");
        this.jLabel1.setText(resourceMap.getString("jLabel1.text", new Object[0]));
        this.jLabel1.setName("jLabel1");
        this.InstrNoDetune.setText(resourceMap.getString("InstrNoDetune.text", new Object[0]));
        this.InstrNoDetune.setName("InstrNoDetune");
        this.InstrDetMouseRelTxt.setText(resourceMap.getString("InstrDetMouseRelTxt.text", new Object[0]));
        this.InstrDetMouseRelTxt.setName("InstrDetMouseRelTxt");
        this.InstrDetSyncPlay.setText(resourceMap.getString("InstrDetSyncPlay.text", new Object[0]));
        this.InstrDetSyncPlay.setEnabled(false);
        this.InstrDetSyncPlay.setName("InstrDetSyncPlay");
        this.InstrDetNoDsp.setText(resourceMap.getString("InstrDetNoDsp.text", new Object[0]));
        this.InstrDetNoDsp.setName("InstrDetNoDsp");
        this.InstrDetNoDsp.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                frmNewInstrFrame.this.InstrDetNoDspActionPerformed(evt);
            }
        });
        this.InstrDetID.setFont(resourceMap.getFont("InstrDetID.font"));
        this.InstrDetID.setText(resourceMap.getString("InstrDetID.text", new Object[0]));
        this.InstrDetID.setName("InstrDetID");
        this.InstrDetViewFormat.setModel(new DefaultComboBoxModel<String>(new String[]{"Lines", "Pixel", "Pixel Fast", "Filled"}));
        this.InstrDetViewFormat.setName("InstrDetViewFormat");
        this.InstrDetViewFormat.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent evt) {
                frmNewInstrFrame.this.InstrDetViewFormatItemStateChanged(evt);
            }
        });
        this.InstrDetTwoWayLoop.setText(resourceMap.getString("InstrDetTwoWayLoop.text", new Object[0]));
        this.InstrDetTwoWayLoop.setName("InstrDetTwoWayLoop");
        this.InstrDetTwoWayLoop.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                frmNewInstrFrame.this.InstrDetTwoWayLoopActionPerformed(evt);
            }
        });
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addComponent(this.lblInstrNr3).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 412, Short.MAX_VALUE)).addGroup(jPanel1Layout.createSequentialGroup().addGap(222, 222, 222).addComponent(this.InstrNoDetune, -2, 121, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.InstrDetMouseRelTxt, -2, 77, -2)).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.lblInstrNr).addComponent(this.lblInstrNr1).addComponent(this.lblInstrNr2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.InstrDetTune, -2, 55, -2).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.InstrDetVolume, -1, 61, Short.MAX_VALUE).addComponent(this.InstrDetNrNew, -2, -1, -2)).addComponent(this.InstrDetLoopStart, -2, 55, -2)).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addGap(4, 4, 4).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel1).addComponent(this.jLabel2).addComponent(this.InstrDetStereoType, -2, 74, -2)).addGap(10, 10, 10).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.InstrDetSampleResolution, -2, 30, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.InstrDetFormat, -1, 179, Short.MAX_VALUE)).addComponent(this.InstrDetFineTune, -2, 55, -2).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.InstrDetLoopLen, -2, 55, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 83, Short.MAX_VALUE).addComponent(this.InstrDetViewFormat, -2, -1, -2))).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED)).addGroup(jPanel1Layout.createSequentialGroup().addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.InstrDetID, -2, 31, -2).addGap(33, 33, 33).addComponent(this.InstrDetTxt, -1, 235, Short.MAX_VALUE)))).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.InstrDetNoDsp).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.InstrDetSyncPlay).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.InstrDetTwoWayLoop).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED))).addContainerGap()));
        jPanel1Layout.linkSize(0, this.InstrDetFineTune, this.InstrDetLoopLen, this.InstrDetLoopStart, this.InstrDetNrNew, this.InstrDetTune, this.InstrDetVolume);
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(this.lblInstrNr).addComponent(this.InstrDetNrNew, -2, -1, -2).addComponent(this.InstrDetTxt, -2, -1, -2).addComponent(this.InstrDetID)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.CENTER, false).addComponent(this.InstrDetVolume, -2, -1, -2).addComponent(this.InstrDetStereoType, -2, -1, -2).addComponent(this.InstrDetSampleResolution, -2, -1, -2).addComponent(this.lblInstrNr1)).addComponent(this.InstrDetFormat, -2, 22, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.lblInstrNr2).addComponent(this.InstrDetTune, -2, -1, -2).addComponent(this.jLabel1).addComponent(this.InstrDetFineTune, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.lblInstrNr3).addComponent(this.InstrDetLoopStart, -2, -1, -2).addComponent(this.jLabel2).addComponent(this.InstrDetLoopLen, -2, -1, -2).addComponent(this.InstrDetViewFormat, -2, -1, -2)).addGap(18, 18, 18).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.InstrDetNoDsp).addComponent(this.InstrDetSyncPlay).addComponent(this.InstrNoDetune).addComponent(this.InstrDetMouseRelTxt).addComponent(this.InstrDetTwoWayLoop)).addContainerGap(-1, Short.MAX_VALUE)));
        this.jTabbedPane1.addTab(resourceMap.getString("jPanel1.TabConstraints.tabTitle", new Object[0]), this.jPanel1);
        this.jPanel2.setName("jPanel2");
        this.InstrDetPanningEnable.setText(resourceMap.getString("InstrDetPanningEnable.text", new Object[0]));
        this.InstrDetPanningEnable.setEnabled(false);
        this.InstrDetPanningEnable.setName("InstrDetPanningEnable");
        this.InstrDetPanningEnable.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                frmNewInstrFrame.this.InstrDetPanningEnableActionPerformed(evt);
            }
        });
        this.jLabel3.setText(resourceMap.getString("jLabel3.text", new Object[0]));
        this.jLabel3.setToolTipText(resourceMap.getString("jLabel3.toolTipText", new Object[0]));
        this.jLabel3.setName("jLabel3");
        this.InstrDetPanorama.setEnabled(false);
        this.InstrDetPanorama.setName("InstrDetPanorama");
        AutoBinding binding = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this.InstrDetPanSlider, (Property)ELProperty.create((String)"${value}"), (Object)this.InstrDetPanorama, (Property)BeanProperty.create((String)"value"));
        this.bindingGroup.addBinding((Binding)binding);
        this.InstrDetPanorama.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent evt) {
                frmNewInstrFrame.this.InstrDetPanoramaStateChanged(evt);
            }
        });
        this.InstrDetPanSlider.setMajorTickSpacing(200);
        this.InstrDetPanSlider.setMaximum(1000);
        this.InstrDetPanSlider.setMinimum(-1000);
        this.InstrDetPanSlider.setMinorTickSpacing(50);
        this.InstrDetPanSlider.setPaintTicks(true);
        this.InstrDetPanSlider.setToolTipText(resourceMap.getString("InstrDetPanSlider.toolTipText", new Object[0]));
        this.InstrDetPanSlider.setValue(0);
        this.InstrDetPanSlider.setEnabled(false);
        this.InstrDetPanSlider.setName("InstrDetPanSlider");
        GroupLayout jPanel2Layout = new GroupLayout(this.jPanel2);
        this.jPanel2.setLayout(jPanel2Layout);
        jPanel2Layout.setHorizontalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addContainerGap().addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.InstrDetPanningEnable).addGroup(jPanel2Layout.createSequentialGroup().addComponent(this.jLabel3).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.InstrDetPanorama, -2, 51, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.InstrDetPanSlider, -1, 301, Short.MAX_VALUE))).addContainerGap()));
        jPanel2Layout.setVerticalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addContainerGap().addComponent(this.InstrDetPanningEnable).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(this.jLabel3).addComponent(this.InstrDetPanorama, -2, -1, -2).addComponent(this.InstrDetPanSlider, -2, -1, -2)).addContainerGap(89, Short.MAX_VALUE)));
        this.jTabbedPane1.addTab(resourceMap.getString("jPanel2.TabConstraints.tabTitle", new Object[0]), this.jPanel2);
        this.MetaPanel.setName("MetaPanel");
        this.MetaMainLead.setText(resourceMap.getString("MetaMainLead.text", new Object[0]));
        this.MetaMainLead.setToolTipText(resourceMap.getString("MetaMainLead.toolTipText", new Object[0]));
        this.MetaMainLead.setName("MetaMainLead");
        this.MetaMainLead.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                frmNewInstrFrame.this.MetaMainLeadActionPerformed(evt);
            }
        });
        this.MetaLead2.setText(resourceMap.getString("MetaLead2.text", new Object[0]));
        this.MetaLead2.setToolTipText(resourceMap.getString("MetaLead2.toolTipText", new Object[0]));
        this.MetaLead2.setName("MetaLead2");
        this.MetaLead2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                frmNewInstrFrame.this.MetaLead2ActionPerformed(evt);
            }
        });
        this.MetaPercussion.setText(resourceMap.getString("MetaPercussion.text", new Object[0]));
        this.MetaPercussion.setToolTipText(resourceMap.getString("MetaPercussion.toolTipText", new Object[0]));
        this.MetaPercussion.setName("MetaPercussion");
        this.MetaPercussion.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                frmNewInstrFrame.this.MetaPercussionActionPerformed(evt);
            }
        });
        this.MetaBeat.setText(resourceMap.getString("MetaBeat.text", new Object[0]));
        this.MetaBeat.setToolTipText(resourceMap.getString("MetaBeat.toolTipText", new Object[0]));
        this.MetaBeat.setName("MetaBeat");
        this.MetaBeat.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                frmNewInstrFrame.this.MetaBeatActionPerformed(evt);
            }
        });
        this.MetaSubBeat.setText(resourceMap.getString("MetaSubBeat.text", new Object[0]));
        this.MetaSubBeat.setToolTipText(resourceMap.getString("MetaSubBeat.toolTipText", new Object[0]));
        this.MetaSubBeat.setName("MetaSubBeat");
        this.MetaSubBeat.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                frmNewInstrFrame.this.MetaSubBeatActionPerformed(evt);
            }
        });
        this.MetaColor.setBackground(resourceMap.getColor("MetaColor.background"));
        this.MetaColor.setBorder(BorderFactory.createEtchedBorder());
        this.MetaColor.setName("MetaColor");
        this.jButton3.setText(resourceMap.getString("jButton3.text", new Object[0]));
        this.jButton3.setName("jButton3");
        this.jButton3.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                frmNewInstrFrame.this.jButton3ActionPerformed(evt);
            }
        });
        GroupLayout MetaColorLayout = new GroupLayout(this.MetaColor);
        this.MetaColor.setLayout(MetaColorLayout);
        MetaColorLayout.setHorizontalGroup(MetaColorLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(MetaColorLayout.createSequentialGroup().addComponent(this.jButton3).addContainerGap(23, Short.MAX_VALUE)));
        MetaColorLayout.setVerticalGroup(MetaColorLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jButton3, -2, 18, Short.MAX_VALUE));
        GroupLayout MetaPanelLayout = new GroupLayout(this.MetaPanel);
        this.MetaPanel.setLayout(MetaPanelLayout);
        MetaPanelLayout.setHorizontalGroup(MetaPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(MetaPanelLayout.createSequentialGroup().addComponent(this.MetaMainLead).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.MetaLead2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.MetaPercussion).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.MetaBeat).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.MetaSubBeat).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.MetaColor, -2, -1, -2).addContainerGap(-1, Short.MAX_VALUE)));
        MetaPanelLayout.setVerticalGroup(MetaPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(MetaPanelLayout.createSequentialGroup().addGroup(MetaPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(MetaPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.MetaMainLead).addComponent(this.MetaLead2).addComponent(this.MetaPercussion).addComponent(this.MetaBeat).addComponent(this.MetaSubBeat)).addComponent(this.MetaColor, -2, -1, -2)).addContainerGap(131, Short.MAX_VALUE)));
        this.jTabbedPane1.addTab(resourceMap.getString("MetaPanel.TabConstraints.tabTitle", new Object[0]), this.MetaPanel);
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jTabbedPane1, GroupLayout.Alignment.TRAILING).addComponent(this.InstrDetSampleView, -1, 450, Short.MAX_VALUE).addComponent(this.jToolBar1, -1, 450, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.jToolBar1, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jTabbedPane1, -2, 182, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.InstrDetSampleView, -1, 130, Short.MAX_VALUE)));
        this.jTabbedPane1.getAccessibleContext().setAccessibleName(resourceMap.getString("jTabbedPane1.AccessibleContext.accessibleName", new Object[0]));
        this.bindingGroup.bind();
        this.pack();
    }

    private void InstrDetLoadSampleActionPerformed(ActionEvent evt) {
        this.SymphManager.LoadSample();
    }

    private void jButton1ActionPerformed(ActionEvent evt) {
        int i = this.SymphManager.getActualInstrumentIndex();
        int ID1 = this.SymphManager.SymSong.getIDofInstrumentIndex(i);
        int ID2 = this.SymphManager.SymSong.getIDofInstrumentIndex(i + 1);
        this.SymphManager.removeInstrumentIndex(i);
        this.SymphManager.LoadSample();
        this.SymphManager.SymSong.setIDofInstrumentIndex(i, ID1);
        this.SymphManager.SymSong.setIDofInstrumentIndex(i + 1, ID2);
        this.SymphManager.refreshInstrumentList();
        this.UpdateActualInstrDetails();
    }

    private void InstrDetExportRawSampleActionPerformed(ActionEvent evt) {
    }

    private void jButton2ActionPerformed(ActionEvent evt) {
        int i = this.SymphManager.getActualInstrumentIndex();
        this.SymphManager.removeInstrumentIndex(i);
        this.SymphManager.refreshInstrumentList();
        this.UpdateActualInstrDetails();
    }

    private void InstrDetFineTuneStateChanged(ChangeEvent evt) {
        this.SymphManager.checkSpinnerLimits(this.InstrDetFineTune, -128, 127, true);
        this.SymphManager.getActualInstrument().FineTune = this.SymphManager.getSpinnerValue(this.InstrDetFineTune);
    }

    private void InstrDetNoDspActionPerformed(ActionEvent evt) {
        this.SymphManager.getActualInstrument().NoDsp = this.InstrDetNoDsp.isSelected();
    }

    private void InstrDetViewFormatItemStateChanged(ItemEvent evt) {
        this.UpdateActualInstrDetails();
    }

    private void InstrDetSampleViewMouseMoved(MouseEvent evt) {
        this.SampleShowMousePosition(evt.getX());
    }

    private void InstrDetVolumeStateChanged(ChangeEvent evt) {
        SymphonieInstrument si = this.SymphManager.getActualInstrument();
        if (si != null) {
            si.Volume = this.SymphManager.checkSpinnerLimits(this.InstrDetVolume, 0, 300, true);
        }
    }

    private void InstrDetNrNewStateChanged(ChangeEvent evt) {
        this.UpdateInstrDetails(this.SymphManager.checkSpinnerLimits(this.InstrDetNrNew, 0, this.SymphManager.SymSong.getNumbOfInstruments() - 1, true));
        this.UpdateActualInstrDetails();
    }

    private void InstrDetTuneStateChanged(ChangeEvent evt) {
        NumberFormat nf = NumberFormat.getInstance();
        String s = this.InstrDetTune.getModel().getValue().toString();
        try {
            Number n = nf.parse(s);
            int Value = n.intValue();
            if (Value < -24) {
                Value = -24;
            }
            if (Value >= 48) {
                Value = 48;
            }
            this.SymphManager.SymSong.getInstrumentIndex((int)this.SymphManager.getActualInstrumentIndex()).Tune = Value;
            this.UpdateActualInstrDetails();
        }
        catch (ParseException e) {
            // empty catch block
        }
    }

    private void formFocusGained(FocusEvent evt) {
    }

    private void formWindowGainedFocus(WindowEvent evt) {
    }

    private void formComponentShown(ComponentEvent evt) {
    }

    private void InstrDetSampleViewComponentResized(ComponentEvent evt) {
    }

    private void InstrDetLoopStartStateChanged(ChangeEvent evt) {
        SymphonieInstrument si = this.SymphManager.getActualInstrument();
        if (si != null && si.sp != null && this.getVerifyValues()) {
            int max = si.getMaxLoopStart();
            int i = this.SymphManager.checkSpinnerLimits(this.InstrDetLoopStart, 0, max, false);
            si.setLoopStart(i);
            this.InstrDetLoopStart.setValue(i);
            si.updateLoopParameters();
            this.redrawSampleFrame();
        }
    }

    private void InstrDetLoopLenStateChanged(ChangeEvent evt) {
        SymphonieInstrument si = this.SymphManager.getActualInstrument();
        if (si != null && si.sp != null && this.getVerifyValues()) {
            int max = si.getMaxLoopLen();
            int i = this.SymphManager.checkSpinnerLimits(this.InstrDetLoopLen, 0, max, false);
            si.setLoopLen(i);
            this.InstrDetLoopLen.setValue(i);
            si.updateLoopParameters();
            this.redrawSampleFrame();
        }
    }

    private void InstrDetPanningEnableActionPerformed(ActionEvent evt) {
        SymphonieInstrument si = this.SymphManager.getActualInstrument();
        if (si != null && si.checkReady()) {
            si.PanningActive = this.InstrDetPanningEnable.isSelected();
            this.UpdateActualInstrDetails();
        }
    }

    private void InstrDetPanoramaStateChanged(ChangeEvent evt) {
        SymphonieInstrument si = this.SymphManager.getActualInstrument();
        if (si != null && si.checkReady()) {
            si.PanningX = this.SymphManager.checkSpinnerLimits(this.InstrDetPanorama, -1000, 1000, true);
        }
    }

    private void InstrDetTwoWayLoopActionPerformed(ActionEvent evt) {
        SymphonieInstrument si = this.SymphManager.getActualInstrument();
        if (si != null && si.checkReady()) {
            si.TwoWayLoop = this.InstrDetTwoWayLoop.isSelected();
        }
    }

    private void jButton3ActionPerformed(ActionEvent evt) {
        Color NewColor = JColorChooser.showDialog(this.MetaPanel.getComponent(0), "Instrument ", this.MetaColor.getBackground());
        this.MetaColor.setBackground(NewColor);
        SymphonieInstrument si = this.SymphManager.getActualInstrument();
        if (si != null && si.checkReady()) {
            si.MetaInfo.R = this.MetaColor.getBackground().getRed();
            si.MetaInfo.G = this.MetaColor.getBackground().getGreen();
            si.MetaInfo.B = this.MetaColor.getBackground().getBlue();
        }
    }

    private void MetaMainLeadActionPerformed(ActionEvent evt) {
        SymphonieInstrument si = this.SymphManager.getActualInstrument();
        if (si != null && si.checkReady()) {
            si.MetaInfo.MainLead = this.MetaMainLead.isSelected();
        }
    }

    private void MetaLead2ActionPerformed(ActionEvent evt) {
        SymphonieInstrument si = this.SymphManager.getActualInstrument();
        if (si != null && si.checkReady()) {
            si.MetaInfo.Lead2 = this.MetaLead2.isSelected();
        }
    }

    private void MetaPercussionActionPerformed(ActionEvent evt) {
        SymphonieInstrument si = this.SymphManager.getActualInstrument();
        if (si != null && si.checkReady()) {
            si.MetaInfo.Percussion = this.MetaPercussion.isSelected();
        }
    }

    private void MetaBeatActionPerformed(ActionEvent evt) {
        SymphonieInstrument si = this.SymphManager.getActualInstrument();
        if (si != null && si.checkReady()) {
            si.MetaInfo.Beat = this.MetaBeat.isSelected();
        }
    }

    private void MetaSubBeatActionPerformed(ActionEvent evt) {
        SymphonieInstrument si = this.SymphManager.getActualInstrument();
        if (si != null && si.checkReady()) {
            si.MetaInfo.SubBeat = this.MetaSubBeat.isSelected();
        }
    }

    public static void main(String[] args) {
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                new frmNewInstrFrame().setVisible(true);
            }
        });
    }

    boolean getVerifyValues() {
        return this.VerifyValues;
    }

    void initUIManager(SymReaderView.UIManager mySymphManager) {
        this.SymphManager = mySymphManager;
    }

    void UpdateActualInstrDetails() {
        this.UpdateInstrDetails(this.SymphManager.getActualInstrumentIndex());
    }

    void redrawSampleFrame() {
        this.SymphManager.setActualInstrumentIndex(this.SymphManager.getActualInstrumentIndex());
        SymphonieInstrument si = this.SymphManager.SymSong.getInstrumentIndex(this.SymphManager.getActualInstrumentIndex());
        if (si != null && si.checkReady()) {
            this.UpdateInstrDetailsSampleView(this.SymphManager.getActualInstrumentIndex());
        }
    }

    void UpdateInstrDetailsVerifyValues(boolean b) {
        this.VerifyValues = b;
    }

    void UpdateInstrDetails(int ActualInstrNr) {
        this.SymphManager.setActualInstrumentIndex(ActualInstrNr);
        SymphonieInstrument si = this.SymphManager.SymSong.getInstrumentIndex(ActualInstrNr);
        this.UpdateInstrDetailsVerifyValues(false);
        if (si != null && si.checkReady()) {
            this.InstrDetTxt.setText(si.Name);
            this.InstrDetID.setText("" + si.ID);
            this.InstrDetVolume.setValue(si.Volume);
            this.InstrDetTune.setValue(si.Tune);
            this.InstrDetFineTune.setValue(si.FineTune);
            this.InstrNoDetune.setSelected(si.AllowPosDetune);
            this.InstrDetNoDsp.setSelected(si.NoDsp);
            this.InstrDetStereoType.setSelectedIndex(si.MultiChannel);
            this.InstrDetSampleResolution.setText("" + si.ImportSample.SampleResolutionBit);
            this.InstrDetFormat.setText(si.ImportSample.FormatString);
            this.UpdateInstrDetailsSampleView(ActualInstrNr);
            this.InstrDetLoopStart.setValue(si.sp.getLoopStart());
            this.InstrDetLoopLen.setValue(si.sp.getLoopLen());
            if (si.sp.hasLoop()) {
                this.InstrDetLoopText.setText("Loop:" + si.sp.getLoopStart() + " Length:" + si.sp.getLoopLen());
            } else {
                this.InstrDetLoopText.setText("");
            }
            this.InstrDetTwoWayLoop.setSelected(si.TwoWayLoop);
            this.InstrDetPanningEnable.setSelected(si.PanningActive);
            this.InstrDetPanSlider.setValue((int)si.PanningX);
            this.MetaMainLead.setSelected(si.MetaInfo.MainLead);
            this.MetaLead2.setSelected(si.MetaInfo.Lead2);
            this.MetaBeat.setSelected(si.MetaInfo.Beat);
            this.MetaSubBeat.setSelected(si.MetaInfo.SubBeat);
            this.MetaPercussion.setSelected(si.MetaInfo.Percussion);
            this.MetaColorTemp = new Color(si.MetaInfo.R, si.MetaInfo.G, si.MetaInfo.B);
            this.MetaColor.setBackground(this.MetaColorTemp);
            this.setElementsEnabled(si, true);
        } else {
            this.InstrDetTxt.setText("<Unused>");
            this.ClearInstrDetailsSampleView();
            this.InstrDetSampleResolution.setText("n/a");
            this.InstrDetFormat.setText("n/a");
            this.InstrDetID.setText("");
            this.InstrDetLoopStart.setValue(0);
            this.InstrDetLoopLen.setValue(0);
            this.InstrDetVolume.setValue(0);
            this.setElementsEnabled(si, false);
        }
        this.UpdateInstrDetailsVerifyValues(true);
    }

    void setElementsEnabled(SymphonieInstrument si, boolean Enable) {
        this.InstrDetLoopStart.setEnabled(Enable);
        this.InstrDetLoopLen.setEnabled(Enable);
        this.InstrDetVolume.setEnabled(Enable);
        this.InstrDetTune.setEnabled(Enable);
        this.InstrDetFineTune.setEnabled(Enable);
        this.InstrNoDetune.setEnabled(Enable);
        this.InstrDetNoDsp.setEnabled(Enable);
        if (si.MultiChannel == 0) {
            this.InstrDetPanningEnable.setEnabled(Enable);
        } else {
            this.InstrDetPanningEnable.setEnabled(false);
        }
        this.InstrDetTwoWayLoop.setEnabled(Enable);
        if (this.InstrDetPanningEnable.isSelected()) {
            this.InstrDetPanorama.setEnabled(Enable);
            this.InstrDetPanSlider.setEnabled(Enable);
        } else {
            this.InstrDetPanorama.setEnabled(false);
            this.InstrDetPanSlider.setEnabled(false);
        }
        this.MetaPanel.setEnabled(Enable);
    }

    float getActInstrSample(int i) {
        float Sample = 0.0f;
        if (this.SymphManager.getActualInstrument().SampleDataLoaded && i < this.SymphManager.getActualInstrument().sp.getNumbOfSamples()) {
            Sample = this.SymphManager.getActualInstrument().sp.Samples[i];
        }
        return Sample;
    }

    int getActInstrSamplePercent(long i, long maxi, int h) {
        float Sample = 0.0f;
        if (this.SymphManager.getActualInstrument().SampleDataLoaded) {
            int NumbOfSamples = this.SymphManager.getActualInstrument().sp.getNumbOfSamples();
            long temp = i * (long)NumbOfSamples;
            Sample = this.getActInstrSample((int)(temp / maxi));
        }
        Sample = Sample * (float)h / 2.0f;
        return (int)Sample;
    }

    void ClearInstrDetailsSampleView() {
        boolean Oldy = false;
        this.SampleViewMarkersCount = 0;
        int w = this.InstrDetSampleView.getBounds().width;
        int h = this.InstrDetSampleView.getBounds().height;
        Graphics g = this.InstrDetSampleView.getGraphics();
        g.clearRect(0, 0, w, h);
        this.SampleViewDrawLoop();
    }

    int GetSamplePositionOnSampleView(SymphonieInstrument si, float SamplePtr) {
        if (si.checkReady() && si.sp.getNumbOfSamples() > 0) {
            float x = SamplePtr * (float)this.InstrDetSampleView.getBounds().width / (float)si.sp.getNumbOfSamples();
            return (int)(x + (float)this.InstrDetSampleView.getBounds().x);
        }
        return 0;
    }

    void SampleViewDrawVMarker(int x) {
        Graphics g = this.InstrDetSampleView.getGraphics();
        g.setXORMode(Color.YELLOW);
        g.drawLine(x, 0, x, this.InstrDetSampleView.getBounds().height);
    }

    void SampleViewClearPlayPositions() {
        if (this.SampleViewMarkersCount > 0) {
            for (int i = 0; i < this.SampleViewMarkersCount; ++i) {
                if (this.SampleViewMarkersCount <= 0) continue;
                this.SampleViewDrawVMarker(this.SampleViewMarkers[i]);
            }
        }
    }

    void SampleViewDrawPlayPositions() {
        SymphonieInstrument si = this.SymphManager.getActualInstrument();
        this.SampleViewClearPlayPositions();
        this.SampleViewMarkersCount = 0;
        for (int i = 0; i < this.SymphManager.getVoiceExpander().getNumbOfVoicesPlaying(); ++i) {
            if (si == null || this.SymphManager.getVoiceExpander().Voices[i] == null || this.SymphManager.getVoiceExpander().Voices[i].si != si || !this.SymphManager.getVoiceExpander().isVoicePlaying(i)) continue;
            int x = this.GetSamplePositionOnSampleView(si, (float)this.SymphManager.getVoiceExpander().Voices[i].SamplePtr);
            this.SampleViewDrawVMarker(x);
            this.SampleViewMarkers[this.SampleViewMarkersCount] = x;
            ++this.SampleViewMarkersCount;
        }
    }

    void SampleViewDrawLoop() {
        SymphonieInstrument si = this.SymphManager.getActualInstrument();
        if (si != null && si.checkReady() && si.sp.hasLoop()) {
            float w = this.InstrDetSampleView.getBounds().width;
            float h = this.InstrDetSampleView.getBounds().height;
            Graphics g = this.InstrDetSampleView.getGraphics();
            g.setColor(this.SymphManager.LoopColor);
            float x = this.GetSamplePositionOnSampleView(si, si.sp.getLoopStart());
            w = this.GetSamplePositionOnSampleView(si, si.sp.getLoopLen());
            g.fillRect((int)x, 0, (int)w, (int)h);
        }
    }

    void SampleShowMousePosition(float x) {
        SymphonieInstrument si = this.SymphManager.getActualInstrument();
        if (si != null && si.checkReady()) {
            float w = 255.0f * x / (float)this.InstrDetSampleView.getBounds().width;
            this.InstrDetMouseRelTxt.setText("" + w);
        }
    }

    void UpdateInstrDetailsSampleView(int ActualInstrNr) {
        int Oldy = 0;
        int w = this.InstrDetSampleView.getBounds().width;
        int h = this.InstrDetSampleView.getBounds().height;
        Graphics g = this.InstrDetSampleView.getGraphics();
        this.ClearInstrDetailsSampleView();
        g.drawLine(0, h / 2, w, h / 2);
        Oldy = 0;
        switch (this.InstrDetViewFormat.getSelectedIndex()) {
            case 0: {
                for (int i = 0; i < w; ++i) {
                    int y = this.getActInstrSamplePercent(i, w, h);
                    g.drawLine(i, Oldy + h / 2, i + 1, y + h / 2);
                    Oldy = y;
                }
                break;
            }
            case 1: {
                int Resolution = w / 10 + 1;
                for (int i = 0; i < w * Resolution; ++i) {
                    int y = this.getActInstrSamplePercent(i, w * Resolution, h);
                    g.drawLine(i / Resolution + 1, y + h / 2, i / Resolution + 1, y + h / 2);
                }
                break;
            }
            case 2: {
                int Resolution = w / 60 + 1;
                for (int i = 0; i < w * Resolution; ++i) {
                    int y = this.getActInstrSamplePercent(i, w * Resolution, h);
                    g.drawLine(i / Resolution + 1, y + h / 2, i / Resolution + 1, y + h / 2);
                }
                break;
            }
            case 3: {
                int Resolution = 2;
                for (int i = 0; i < w * Resolution; ++i) {
                    int y = this.getActInstrSamplePercent(i + 1, w * Resolution, h);
                    g.drawLine(i / Resolution + 1, h / 2, i / Resolution + 1, y + h / 2);
                }
                break;
            }
        }
    }

    void moveToInstrIndex(int i) {
        this.InstrDetNrNew.setValue(i);
    }
}

