/*
 * Decompiled with CFR 0.152.
 */
package symreader;

import java.util.Arrays;
import symreader.PEDBlock;
import symreader.PatternVoice;
import symreader.Position;
import symreader.Sequence;
import symreader.SongEvent;
import symreader.SongEventPool;
import symreader.SongPattern;
import symreader.SymphonieInstrument;
import symreader.VoiceExpander;

public class Song {
    String Name = "Unnamed";
    float Volume = 100.0f;
    private float BPM = 125.0f;
    float MixFrequency = 44100.0f;
    private int NumbOfSequences = 64;
    private int NumbOfPositions = 1024;
    private int NumbOfInstruments = 256;
    private int NumbOfVoices = 16;
    private int NumbOfRows = 64;
    private int NumbOfPatterns = 100;
    private int PatternSize;
    private boolean InstrumentsAllocated = false;
    private Sequence[] Sequences;
    private Position[] Positions;
    private SongPattern[] Patterns;
    PEDBlock myPEDBlock = new PEDBlock(this);
    private int[] IDs;
    private SymphonieInstrument[] Instruments;
    private VoiceExpander LinkedVoiceExpander = null;
    boolean SongPlaying = false;
    int PlayingPatternNr = 0;
    boolean isPositionPlaying = false;
    boolean ForceJumpToPos = false;
    boolean ForceSyncedBreak = false;
    int ForcedPosNr = 0;
    int PlayPositionIndex = 0;
    int PosNumbOfLoops = 0;
    int PosStart = 0;
    int PosLen = 0;
    int PosSpeed = 0;
    int PosTuneOffset = 0;
    private float PlayLinePos = 0.0f;
    private boolean UpdatePlayingPos = false;
    private boolean RealtimeModifyActivated = false;
    private int ModifyVoiceNr = 0;
    private int ModifyParameter = 0;
    private float ModifyValueTo = 0.0f;

    void activateRealtimeModify(boolean b) {
        this.RealtimeModifyActivated = b;
    }

    boolean checkRealtimeModifyVoice(int VoiceNr) {
        return this.RealtimeModifyActivated && this.ModifyVoiceNr == VoiceNr;
    }

    void realtimeModifyEventD(int VoiceNr, float NewValue) {
        this.ModifyVoiceNr = VoiceNr;
        this.ModifyParameter = 4;
        this.ModifyValueTo = NewValue;
    }

    void realtimeModifyEventC(int VoiceNr, float NewValue) {
        this.ModifyVoiceNr = VoiceNr;
        this.ModifyParameter = 3;
        this.ModifyValueTo = NewValue;
    }

    void modifyRealtimeEvent(SongEvent se) {
        if (se.SongFXType != 0) {
            if (this.ModifyParameter == 4) {
                se.D = this.ModifyValueTo;
            }
            if (this.ModifyParameter == 3) {
                se.C = this.ModifyValueTo;
            }
        }
    }

    SongEvent getFreeSongEvent(int PatNr, int x, int y) {
        SongPattern Pat;
        if (this.hasContent() && this.Patterns != null && (Pat = this.getPattern(PatNr)) != null) {
            return Pat.getFreeSongEvent(x, y);
        }
        return null;
    }

    SongEvent getSongEvent(int PatNr, int x, int y) {
        SongPattern Pat;
        if (this.hasContent() && this.Patterns != null && (Pat = this.getPattern(PatNr)) != null) {
            return Pat.getSongEvent(x, y);
        }
        return null;
    }

    SongEvent getSongEventForced(int PatNr, int x, int y) {
        SongPattern Pat;
        if (this.hasContent() && this.Patterns != null && (Pat = this.getPattern(PatNr)) != null) {
            return Pat.getSongEventForced(x, y);
        }
        return null;
    }

    void copySongEvent(SongEvent e, int PatNr, int x, int y) {
        if (this.hasContent() && this.Patterns != null && e != null) {
            SongPattern Pat = this.getPattern(PatNr);
            Pat.addSongEvent(this.PosLen, this.Volume, e);
        }
    }

    float getPlayingLineNr() {
        return this.PlayLinePos;
    }

    int getPlayingPatternNr() {
        return this.PlayingPatternNr;
    }

    int getPositionSpeed() {
        return this.PosSpeed;
    }

    float getSongBPM() {
        return this.BPM;
    }

    int getPositionIndexPlaying() {
        if (this.isPositionPlaying && this.SongPlaying) {
            return this.PlayPositionIndex;
        }
        return -1;
    }

    boolean checkEarlyBreakImmediate() {
        return this.ForceJumpToPos && !this.ForceSyncedBreak;
    }

    boolean checkEarlyBreak() {
        return this.ForceJumpToPos;
    }

    void setNextPositionToPlaySynced(int NewNextPos, boolean SyncedBreak) {
        if (NewNextPos < this.getNumbOfPositions()) {
            this.ForceJumpToPos = true;
            this.ForcedPosNr = NewNextPos;
            this.ForceSyncedBreak = SyncedBreak;
        }
    }

    private int getNextPositionToPlay() {
        int nextpos;
        if (this.ForceJumpToPos) {
            nextpos = this.ForcedPosNr;
            this.ForceJumpToPos = false;
        } else {
            nextpos = this.PlayPositionIndex + 1;
        }
        return nextpos;
    }

    private void MoveToNextPosition() {
        this.PlayPositionIndex = this.getNextPositionToPlay();
        if (this.PlayPositionIndex >= this.getNumbOfPositions()) {
            this.StopSong();
        } else {
            this.PlayPositionInit();
        }
        this.setUpdatePlayingPos(true);
    }

    private void PlayPositionInit() {
        if (this.Positions != null && this.PlayPositionIndex < this.Positions.length && this.Positions[this.PlayPositionIndex] != null) {
            this.PosTuneOffset = this.Positions[this.PlayPositionIndex].Tune;
            this.PosNumbOfLoops = this.Positions[this.PlayPositionIndex].NumbOfLoops;
            this.PosStart = this.Positions[this.PlayPositionIndex].StartRow;
            this.PosLen = this.Positions[this.PlayPositionIndex].RowLength;
            this.PosSpeed = this.Positions[this.PlayPositionIndex].Speed_Cycl;
            this.PlayingPatternNr = this.Positions[this.PlayPositionIndex].PatternNumbers[0];
            this.PlayLinePos = this.PosStart;
            this.isPositionPlaying = true;
        }
        this.setUpdatePlayingPos(true);
    }

    void PlayPosition(int PosIndex) {
        this.SongPlaying = false;
        this.PlayPositionIndex = PosIndex;
        this.PlayPositionInit();
        this.SongPlaying = true;
        this.setUpdatePlayingPos(true);
    }

    void playfromActualPosition() {
        this.PlayPosition(this.PlayPositionIndex);
    }

    void PlaySong() {
        this.PlayLinePos = 0.0f;
        this.SongPlaying = true;
    }

    void PlayFromFirstSequence() {
        if (this.Sequences[0] != null) {
            if (this.Sequences[0].Action == 0) {
                this.PlayPosition(this.Sequences[0].StartPosition);
            } else {
                this.PlayPosition(0);
            }
        } else {
            this.PlayPosition(0);
        }
    }

    void StopSong() {
        this.isPositionPlaying = false;
        this.SongPlaying = false;
        this.ForceJumpToPos = false;
        this.ForceSyncedBreak = false;
    }

    public boolean hasContent() {
        return this.Sequences != null && this.Positions != null && this.Patterns != null && this.Instruments != null;
    }

    void allocDefaultSong() {
        this.setNumbOfVoices(16);
        this.setBPM(120.0f);
        this.setNumbOfRows(64);
        this.allocNumbOfSequences(16);
        this.allocNumbOfPositions(512);
        this.allocNumbOfPatterns(100);
        this.allocDefaultNumbInstruments();
    }

    void allocDefaultNumbInstruments() {
        if (!this.InstrumentsAllocated) {
            this.allocNumbInstruments(256);
        }
    }

    void allocNumbOfPatterns(int i) {
        this.Patterns = new SongPattern[i];
        this.myPEDBlock = new PEDBlock(this);
        this.myPEDBlock.TempPattern = new SongPattern();
        this.myPEDBlock.TempPattern.ParentSong = this;
        this.NumbOfPatterns = i;
    }

    void allocNumbOfPositions(int i) {
        this.Positions = new Position[i];
        this.setNumbOfPositions(i);
    }

    void fillPositionsToDefault() {
        for (int i = 0; i < this.getNumbOfPositions(); ++i) {
            this.Positions[i] = this.getPosition(i);
            this.Positions[i].setNumbOfLayers(1);
        }
    }

    void allocNumbOfSequences(int i) {
        this.Sequences = new Sequence[i];
        this.setNumbOfSequences(i);
    }

    void allocNumbInstruments(int i) {
        this.Instruments = new SymphonieInstrument[i];
        this.IDs = new int[i];
        Arrays.fill(this.IDs, -1);
        this.InstrumentsAllocated = true;
        this.setNumbOfInstruments(i);
    }

    int getNumbInstrumentsAllocated() {
        if (this.InstrumentsAllocated) {
            return this.getNumbOfInstruments();
        }
        return 0;
    }

    void updatePatternSize() {
        this.PatternSize = this.NumbOfVoices * this.NumbOfRows;
    }

    int getPatternSize() {
        return this.PatternSize;
    }

    int getNumbOfPatterns() {
        return this.NumbOfPatterns;
    }

    void setNumbOfSequences(int i) {
        this.NumbOfSequences = i;
    }

    int getNumbOfSequences() {
        return this.NumbOfSequences;
    }

    void setNumbOfPositions(int i) {
        this.NumbOfPositions = i;
    }

    int getNumbOfPositions() {
        return this.NumbOfPositions;
    }

    void setNumbOfVoices(int i) {
        this.NumbOfVoices = i;
        this.updatePatternSize();
    }

    int getNumbOfVoices() {
        return this.NumbOfVoices;
    }

    void setNumbOfRows(int i) {
        this.NumbOfRows = i;
        this.updatePatternSize();
    }

    int getNumbOfRows() {
        return this.NumbOfRows;
    }

    void setNumbOfInstruments(int i) {
        this.NumbOfInstruments = i;
    }

    int getNumbOfInstruments() {
        if (this.Instruments != null) {
            return this.NumbOfInstruments;
        }
        return 0;
    }

    void setBPM(float i) {
        this.BPM = i;
    }

    float getBPM() {
        return this.BPM;
    }

    Sequence getSequence(int i) {
        if (i < this.getNumbOfSequences()) {
            if (this.Sequences[i] == null) {
                this.Sequences[i] = new Sequence();
            }
            this.Sequences[i].ParentSong = this;
            return this.Sequences[i];
        }
        return null;
    }

    Position getPosition(int i) {
        if (i < this.getNumbOfPositions()) {
            if (this.Positions[i] == null) {
                this.Positions[i] = new Position();
            }
            this.Positions[i].ParentSong = this;
            return this.Positions[i];
        }
        return null;
    }

    SongPattern getPattern(int i) {
        if (i < this.getNumbOfPatterns()) {
            if (this.Patterns[i] == null) {
                this.Patterns[i] = new SongPattern();
            }
            this.Patterns[i].ParentSong = this;
            return this.Patterns[i];
        }
        return null;
    }

    int getIndexOfInstrumentID(int i) {
        return this.IDs[i];
    }

    SymphonieInstrument getInstrumentID(int i) {
        return this.getInstrumentIndex(this.getIndexOfInstrumentID(i));
    }

    void setIDofInstrumentIndex(int i, int newid) {
        SymphonieInstrument si = this.getInstrumentIndex(i);
        if (si != null && i != -1) {
            si.ID = newid;
        }
    }

    int getIDofInstrumentIndex(int i) {
        SymphonieInstrument si = this.getInstrumentIndex(i);
        if (si != null) {
            return si.ID;
        }
        return -1;
    }

    SymphonieInstrument getInstrumentIndex(int i) {
        if (i < this.getNumbOfInstruments() && i >= 0) {
            if (this.Instruments[i] == null) {
                this.Instruments[i] = new SymphonieInstrument();
            }
            return this.Instruments[i];
        }
        return null;
    }

    void removeInstrumentIndex(int i) {
        if (this.Instruments[i] != null && i < this.getNumbOfInstruments()) {
            if (this.Instruments[i].MultiChannel == 2) {
                this.removeInstrumentIndex(i + 1);
            }
            this.IDs[this.Instruments[i].ID] = -1;
            this.Instruments[i] = null;
        }
    }

    boolean checkInstrumentIndexInUse(int i) {
        if (i < this.getNumbOfInstruments() && i >= 0) {
            if (this.Instruments[i] == null) {
                return false;
            }
            return this.Instruments[i].isInUse;
        }
        return false;
    }

    SymphonieInstrument getInstrumentExisting(int i) {
        if (i < this.getNumbOfInstruments() && i >= 0) {
            if (this.Instruments[i] != null) {
                return this.Instruments[i];
            }
        } else {
            return null;
        }
        return null;
    }

    SymphonieInstrument getFreeInstrument() {
        for (int i = 0; i < this.getNumbOfInstruments(); ++i) {
            if (this.getInstrumentIndex((int)i).isInUse) continue;
            this.Instruments[i].ID = this.getFreeInstrID(i);
            return this.Instruments[i];
        }
        return null;
    }

    int getFreeInstrID(int InstrIndex) {
        for (int i = 0; i < this.IDs.length; ++i) {
            if (this.IDs[i] != -1) continue;
            this.IDs[i] = InstrIndex;
            return i;
        }
        return -1;
    }

    void setIDOfInstrIndex(int ID, int InstrIndex) {
        this.IDs[ID] = InstrIndex;
    }

    int PlaySongEvent(VoiceExpander vx) {
        this.LinkedVoiceExpander = vx;
        if (this.isPositionPlaying) {
            this.PlayEventsAtPos(vx, this.PlayLinePos);
            this.PlayLinePos += 1.0f;
            if (this.PlayLinePos >= (float)(this.PosStart + this.PosLen) || this.checkEarlyBreakImmediate()) {
                --this.PosNumbOfLoops;
                if (this.PosNumbOfLoops <= 0 || this.checkEarlyBreak()) {
                    this.MoveToNextPosition();
                    vx.setSongSpeed(this.BPM, this.PosSpeed);
                } else {
                    this.PlayLinePos = this.PosStart;
                }
            }
        } else {
            this.PlayEventsAtPos(vx, this.PlayLinePos);
            this.PlayLinePos += 1.0f;
            if (this.PlayLinePos >= (float)this.NumbOfRows) {
                this.PlayLinePos = 0.0f;
            }
        }
        return 0;
    }

    void setUpdatePlayingPos(boolean b) {
        this.UpdatePlayingPos = b;
    }

    boolean checkUpdatePlayingPos() {
        boolean b = this.UpdatePlayingPos;
        this.UpdatePlayingPos = false;
        return b;
    }

    void PlayEventsAtPos(VoiceExpander vx, float PlayLinePos) {
        for (int VoiceNr = 0; VoiceNr < this.getNumbOfVoices(); ++VoiceNr) {
            this.PlayEventsOfVoiceAtPos(vx, PlayLinePos, VoiceNr);
        }
    }

    void PlayEventsOfVoiceAtPos(VoiceExpander vx, float PlayLinePos, int VoiceNr) {
        SongPattern Pat = this.getPattern(this.PlayingPatternNr);
        PatternVoice pv = Pat.PatternVoices[VoiceNr];
        SongEventPool sep = pv.getSongEventPool(PlayLinePos);
        if (sep != null) {
            for (int i = 0; i < sep.getNumberOfSongEvents(); ++i) {
                SongEvent mySongEvent = sep.getSongEvent(i);
                if (mySongEvent == null) continue;
                this.PlaySongEvent(vx, VoiceNr, mySongEvent);
            }
        }
    }

    SongEventPool getSongEventPool(int PatNr, int VoiceNr, float TimePosition) {
        SongPattern Pat = this.getPattern(PatNr);
        PatternVoice pv = Pat.PatternVoices[VoiceNr];
        return pv.getSongEventPool(TimePosition);
    }

    boolean checkIsLeftStereoChannel(int ChannelIndex) {
        return (ChannelIndex & 1) == 0;
    }

    void addKeyOnEvent(int PatNr, int x, int y, int InstrNr, int Pitch, int Vol) {
        SongEventPool se = this.getSongEventPool(PatNr, x, y);
        SongEvent MySongEvent = se.getSongEventForced(0);
        if (MySongEvent != null) {
            MySongEvent.setKeyOn(InstrNr, Pitch, Vol);
        }
    }

    void clrEvent(int PatNr, int x, int y) {
        SongEventPool se = this.getSongEventPool(PatNr, x, y);
        SongEvent MySongEvent = se.getSongEvent(0);
        if (MySongEvent != null) {
            MySongEvent.clear();
        }
    }

    void setEventType(int PatNr, int x, int y, int newEventType) {
        SongEventPool se = this.getSongEventPool(PatNr, x, y);
        SongEvent MySongEvent = se.getSongEventForced(0);
        if (MySongEvent != null) {
            MySongEvent.setType(newEventType);
        }
    }

    void PlaySongEvent(VoiceExpander vx, int VoiceNr, SongEvent e) {
        if (this.checkRealtimeModifyVoice(VoiceNr)) {
            this.modifyRealtimeEvent(e);
        }
        int tempPitch = (int)e.B;
        int tempInstrNr = (int)e.A;
        tempInstrNr = this.getIndexOfInstrumentID(tempInstrNr);
        switch (e.SongFXType) {
            case 1: {
                SymphonieInstrument si;
                float tempVolume = e.C;
                if (!(tempVolume <= 100.0f) || (si = this.getInstrumentExisting(tempInstrNr)) == null || !si.checkReady()) break;
                vx.SongEventKeyOn(si, VoiceNr, tempPitch, tempVolume);
                if (si.MultiChannel != 1 || !this.checkIsLeftStereoChannel(VoiceNr) || !(si = this.getInstrumentExisting(tempInstrNr + 1)).checkReady()) break;
                vx.SongEventKeyOn(si, VoiceNr + 1, tempPitch, tempVolume);
                break;
            }
            case 2000: {
                SymphonieInstrument si = this.getInstrumentExisting(tempInstrNr);
                if (si == null) break;
                vx.SongEventSetPitch(si, VoiceNr, tempPitch);
                break;
            }
            case 2007: {
                SymphonieInstrument si = this.getInstrumentExisting(tempInstrNr);
                if (si == null) break;
                vx.adjustVoiceFreq(si, VoiceNr, 1.0078125);
                break;
            }
            case 2009: {
                SymphonieInstrument si = this.getInstrumentExisting(tempInstrNr);
                if (si == null) break;
                vx.adjustVoiceFreq(si, VoiceNr, 1.015625);
                break;
            }
            case 2011: {
                SymphonieInstrument si = this.getInstrumentExisting(tempInstrNr);
                if (si == null) break;
                vx.adjustVoiceFreq(si, VoiceNr, 1.03125);
                break;
            }
            case 2008: {
                SymphonieInstrument si = this.getInstrumentExisting(tempInstrNr);
                if (si == null) break;
                vx.adjustVoiceFreq(si, VoiceNr, 0.9921875);
                break;
            }
            case 2010: {
                SymphonieInstrument si = this.getInstrumentExisting(tempInstrNr);
                if (si == null) break;
                vx.adjustVoiceFreq(si, VoiceNr, 0.984375);
                break;
            }
            case 2012: {
                SymphonieInstrument si = this.getInstrumentExisting(tempInstrNr);
                if (si == null) break;
                vx.adjustVoiceFreq(si, VoiceNr, 0.9788f);
                break;
            }
            case 2002: {
                SymphonieInstrument si = this.getInstrumentExisting(tempInstrNr);
                if (si == null) break;
                vx.SongEventPSlide(VoiceNr, e.D);
                break;
            }
            case 2003: {
                SymphonieInstrument si = this.getInstrumentExisting(tempInstrNr);
                if (si == null) break;
                vx.SongEventPSlide(VoiceNr, -e.D);
                break;
            }
            case 2001: {
                SymphonieInstrument si = this.getInstrumentExisting(tempInstrNr);
                if (si == null) break;
                vx.SetVoicePSlideTo(si, VoiceNr, tempPitch, e.D);
                break;
            }
            case 1001: {
                vx.SongEventVSlide(VoiceNr, e.D);
                break;
            }
            case 1002: {
                vx.SongEventVSlide(VoiceNr, -e.D);
                break;
            }
            case 1003: {
                vx.SongEventAddVolume(VoiceNr, e.C / 8.0f);
                break;
            }
            case 1000: {
                vx.SongEventSetVolume(VoiceNr, e.C);
                break;
            }
            case 1007: {
                vx.SongEventPausePlaying(VoiceNr);
                break;
            }
            case 1008: {
                vx.SongEventContinue(VoiceNr, true);
                break;
            }
            case 3001: {
                SymphonieInstrument si = this.getInstrumentExisting(tempInstrNr);
                if (si == null) break;
                vx.SongEventKeyOnSamplePos(si, VoiceNr, tempPitch, e.D);
                break;
            }
            case 3000: {
                SymphonieInstrument si = this.getInstrumentExisting(tempInstrNr);
                if (si == null) break;
                vx.SongEventKeyOnSamplePos(si, VoiceNr, e.D);
                break;
            }
            case 5000: {
                vx.setFilter(VoiceNr, (int)e.A, e.C, e.D);
            }
        }
    }
}

