//
// R_MUSIC.CPP
//

#include "stdafx.h"
#include <fstream.h>

#include "FileNewDlg.h"
#include "ExportDlgs.h"


#include "MainFrm.h"	//!

#include "r_music.h"
#include "global.h"

//-------

void SetStatusBarText(const char* text)
{
	CStatusBar& sb = ((CMainFrame*)AfxGetApp()->GetMainWnd())->m_wndStatusBar;
	sb.SetWindowText(text);
}

//-------

CTrackClipboard::CTrackClipboard()
{
	m_song = NULL;
	m_trackcopy.len = -1;	//pro kopirovani kompletniho tracku i se smyckama atd.
	m_trackbackup.len = -1; //zalozni
	m_all = 1;				//1=vsechny udalosti / 0=jen u udalosti s instrumentem stejnym jako je aktualne nastaveny
	Empty();
}

void CTrackClipboard::Init(CSong* song)
{
	m_song = song;
}

void CTrackClipboard::Empty()
{
	m_selcol = m_seltrack = -1;
	ClearTrack();
}

void CTrackClipboard::ClearTrack()
{
	m_track.len = -1;
	m_track.go = -1;
	for(int i=0; i<TRACKLEN; i++)
	{
		m_track.note[i]=-1;
		m_track.instr[i]=-1;
		m_track.volume[i]=-1;
		m_track.speed[i]=-1;
	}
}

BOOL CTrackClipboard::BlockSetBegin(int col, int track, int line)
{
	if (col<0 || track<0 || track>=TRACKSNUM || line<0 || line>=TRACKLEN) return 0;
	if (m_selcol<0 || m_selcol!=col || m_seltrack!=track)
	{
		//nove oznaceny zacatek bloku
		m_selcol = col;
		m_seltrack = track;
		m_selsongline = m_song->SongGetActiveLine();
		m_selfrom = m_selto = line;
		//uschova si ten track tak jak byl ted
		memcpy((void*)(&m_trackbackup),(void*)(m_song->GetTracks()->GetTrack(track)),sizeof(TTrack));
		//a inicializuje base track
		BlockInitBase(track);
		return 1;
	}
	return 0;
}

BOOL CTrackClipboard::BlockSetEnd(int line)
{
	if (line<0 || line>=TRACKLEN) return 0;
	m_selto = line;
	return 1;
}

void CTrackClipboard::BlockDeselect()
{
	m_selcol = -1;
	SetStatusBarText("");
}

void CTrackClipboard::BlockInitBase(int track)
{
	if (track<0 || track>=TRACKSNUM) return;
	memcpy((void*)(&m_trackbase),(void*)(m_song->GetTracks()->GetTrack(track)),sizeof(TTrack));
	m_changenote=0;
	m_changeinstr=0;
	m_changevolume=0;
	m_instrbase= -1;
}

void CTrackClipboard::BlockAllOnOff()
{
	if (!IsBlockSelected()) return;
	m_all ^= 1;

	int bfro,bto;
	GetFromTo(bfro,bto);

	//promitne momentalni stav tracku do base tracku
	BlockInitBase(m_seltrack);
}

int CTrackClipboard::BlockCopyToClipboard()
{
	if (!IsBlockSelected()) { ClearTrack(); return 0; }
	if (m_seltrack<0) return 0;

	ClearTrack();

	int j,line,xline;
	int linefrom,lineto;
	GetFromTo(linefrom,lineto);

	TTrack& ts = *m_song->GetTracks()->GetTrack(m_seltrack);
	TTrack& td = m_track;

	int len=ts.len,go=ts.go;

	for(line=linefrom,j=0; line<=lineto; line++,j++)
	{
		if (line<len || go<0) xline=line;
		else
			xline = ((line-len) % (len-go)) + go;

		if (line<len || go>=0)
		{
			td.note[j]=ts.note[xline];
			td.instr[j]=ts.instr[xline];
			td.volume[j]=ts.volume[xline];
			td.speed[j]=ts.speed[xline];
		}
		else
		{
			td.note[j]=-1;
			td.instr[j]=-1;
			td.volume[j]=-1;
			td.speed[j]=-1;
		}
	}
	td.len = j;
	return td.len;
}

int CTrackClipboard::BlockPasteToTrack(int track, int line)
{
	if (track<0 || track>=TRACKSNUM) return 0;

	int bfro=-1,bto=-1;
	if (IsBlockSelected() && m_seltrack>=0)
	{
		//Je vybrany blok, takze PASTE bude do nej misto na line pozici
		track = m_seltrack;
		GetFromTo(bfro,bto);
	}
	
	TTrack& ts = m_track;
	TTrack& td = *m_song->GetTracks()->GetTrack(track);
	int i,j;
	int linemax;
	
	if (bfro>=0) //je vybrany blok (pokracovani)
	{
		line = bfro;
		linemax = bto+1;
	}
	else
		linemax = line + ts.len;

	if (linemax > m_song->GetTracks()->m_maxtracklen) linemax = m_song->GetTracks()->m_maxtracklen;
	if (line>td.len)
	{
		for(i=td.len; i<line; i++) td.note[i]=td.instr[i]=td.volume[i]=td.speed[i]=-1;
	}

	for(i=line,j=0; i<linemax; i++,j++)
	{
		td.note[i]=ts.note[j];
		td.instr[i]=ts.instr[j];
		td.volume[i]=ts.volume[j];
		td.speed[i]=ts.speed[j];
	}
	//pokud je to za koncem tracku, prodlouzi mu delku
	if (linemax>td.len) td.len=linemax;
	return (bfro>=0)? 0 : linemax-line;	//kdyz bylo paste do bloku, vraci 0
}

int CTrackClipboard::BlockClear()
{
	if (!IsBlockSelected() || m_seltrack<0) return 0;

	int i,bfro,bto;
	GetFromTo(bfro,bto);

	TTrack& td = *m_song->GetTracks()->GetTrack(m_seltrack);
	for(i=bfro; i<=bto && i<td.len; i++)
	{
		td.note[i]=-1;
		td.instr[i]=-1;
		td.volume[i]=-1;
		td.speed[i]=-1;
	}
	return bto-bfro+1;
}

int CTrackClipboard::BlockRestoreFromBackup()
{
	if (!IsBlockSelected() || m_seltrack<0) return 0;
	memcpy((void*)(m_song->GetTracks()->GetTrack(m_seltrack)),(void*)(&m_trackbackup),sizeof(TTrack));
	BlockInitBase(m_seltrack);
	return 1;
}

void CTrackClipboard::GetFromTo(int& from, int& to)
{ 
	if (!IsBlockSelected()) { from=1; to=0; return; }
	if (m_selfrom<=m_selto) 
	{ from=m_selfrom; to=m_selto; } 
	else 
	{ from=m_selto; to=m_selfrom; }
}

void CTrackClipboard::BlockNoteTransposition(int instr,int addnote)
{
	if (!IsBlockSelected() || m_seltrack<0) return;

	if (instr!=m_instrbase)
	{
		//promitne momentalni stav tracku do base tracku
		BlockInitBase(m_seltrack);
		m_instrbase = instr;
	}

	m_changenote +=addnote;
	if (m_changenote>=NOTESNUM) m_changenote = NOTESNUM-1;
	if (m_changenote<=-NOTESNUM) m_changenote = -NOTESNUM+1;

	TTrack& td = *m_song->GetTracks()->GetTrack(m_seltrack);
	int i,j;
	int bfro,bto;
	GetFromTo(bfro,bto);

	for(i=bfro; i<=bto && i<td.len; i++)
	{
		if (td.note[i]>=0 && (td.instr[i]==instr || m_all))
		{
			j=m_trackbase.note[i]+m_changenote;
			if (j>=NOTESNUM) j = j-NOTESNUM+1;
			if (j<0) j= j+NOTESNUM-1;
			td.note[i]=j;
		}
	}

	//Info do status baru
	CString s;
	s.Format("Note transposition: %+i",m_changenote);
	SetStatusBarText((LPCTSTR)s);
}

void CTrackClipboard::BlockInstrumentChange(int instr,int addinstr)
{
	if (!IsBlockSelected() || m_seltrack<0) return;

	if (instr!=m_instrbase)
	{
		//promitne momentalni stav tracku do base tracku
		BlockInitBase(m_seltrack);
		m_instrbase = instr;
	}
	
	m_changeinstr +=addinstr;
	if (m_changeinstr>=INSTRSNUM) m_changeinstr = INSTRSNUM-1;
	if (m_changeinstr<=-INSTRSNUM) m_changeinstr = -INSTRSNUM+1;

	TTrack& td = *m_song->GetTracks()->GetTrack(m_seltrack);
	int i,j;
	int bfro,bto;
	GetFromTo(bfro,bto);

	for(i=bfro; i<=bto && i<td.len; i++)
	{
		if (m_trackbase.instr[i]>=0 && (m_trackbase.instr[i]==instr || m_all))
		{
			j=m_trackbase.instr[i]+m_changeinstr;
			if (j>=INSTRSNUM) j = (j % INSTRSNUM );
			if (j<0) j= (j % INSTRSNUM ) +INSTRSNUM;
			td.instr[i]=j;
		}
	}

	//Info do status baru
	CString s;
	s.Format("Instrument change: %+i",m_changeinstr);
	SetStatusBarText((LPCTSTR)s);
}

void CTrackClipboard::BlockVolumeChange(int instr,int addvol)
{
	if (!IsBlockSelected() || m_seltrack<0) return;

	if (instr!=m_instrbase)
	{
		//promitne momentalni stav tracku do base tracku
		BlockInitBase(m_seltrack);
		m_instrbase = instr;
	}

	m_changevolume +=addvol;
	if (m_changevolume > MAXVOLUME) m_changevolume = MAXVOLUME;
	if (m_changevolume < -MAXVOLUME) m_changevolume = -MAXVOLUME;

	TTrack& td = *m_song->GetTracks()->GetTrack(m_seltrack);
	int i,j;
	int lasti=-1;
	int bfro,bto;
	GetFromTo(bfro,bto);

	for(i=bfro; i<=bto && i<td.len; i++)
	{
		if (td.instr[i]>=0) lasti=td.instr[i]; //aby kdyz je samotne volume, aby poznal ze to patri k tomu nastroji nad tim
		if (td.volume[i]>=0 && (lasti==instr || m_all))
		{
			j=m_trackbase.volume[i]+m_changevolume;
			if (j>MAXVOLUME) j=MAXVOLUME;
			if (j<0) j=0;
			td.volume[i]=j;
		}
	}

	//Info do status baru
	CString s;
	s.Format("Volume change: %+i",m_changevolume);
	SetStatusBarText((LPCTSTR)s);
}



//-------


const char *notes[]=
{ "C-1","C#1","D-1","D#1","E-1","F-1","F#1","G-1","G#1","A-1","A#1","H-1",
  "C-2","C#2","D-2","D#2","E-2","F-2","F#2","G-2","G#2","A-2","A#2","H-2",
  "C-3","C#3","D-3","D#3","E-3","F-3","F#3","G-3","G#3","A-3","A#3","H-3",
  "C-4","C#4","D-4","D#4","E-4","F-4","F#4","G-4","G#4","A-4","A#4","H-4",
  "C-5","C#5","D-5","D#5","E-5","F-5","F#5","G-5","G#5","A-5","A#5","H-5",
  "C-6","???","???","???"
};

//pro castecne selektovani v tracku
static char *colac[]=
//  z   C   #    1      I   I       V   S   S
{ "\x06\x03\x03\x03\x06\x06\x06\x06\x06\x06\x06",
  "\x06\x06\x06\x06\x06\x03\x03\x06\x06\x06\x06",
  "\x06\x06\x06\x06\x06\x06\x06\x06\x03\x06\x06",
  "\x06\x06\x06\x06\x06\x06\x06\x06\x06\x03\x03"
};


//----------------------------------------------

struct Tshpar
{
	int c;
	int x,y;
	char *name;
	int pand;
	int pfrom;
	int gup,gdw,gle,gri;
};

#define INSTRS_X 2*8
#define INSTRS_Y 8*16
#define INSTRS_PY	INSTRS_Y+2*16		//parametry Y

#define INSTRS_EX	INSTRS_X+29*8		//envelope X
#define INSTRS_EY	INSTRS_Y+2*16		//envelope Y

const Tshpar shpar[]=
{
	//TABLE: 00-07
	{ 0,INSTRS_X+2*8,INSTRS_PY+ 7*16,"00:",0xff,0,12, 1,16,17 },
	{ 1,INSTRS_X+2*8,INSTRS_PY+ 8*16,"01:",0xff,0, 0, 2,17,17 },
	{ 2,INSTRS_X+2*8,INSTRS_PY+ 9*16,"02:",0xff,0, 1, 3,18,18 },
	{ 3,INSTRS_X+2*8,INSTRS_PY+10*16,"03:",0xff,0, 2, 4,19,19 },
	{ 4,INSTRS_X+2*8,INSTRS_PY+11*16,"04:",0xff,0, 3, 5,19,19 },
	{ 5,INSTRS_X+2*8,INSTRS_PY+12*16,"05:",0xff,0, 4, 6,19,20 },
	{ 6,INSTRS_X+2*8,INSTRS_PY+13*16,"06:",0xff,0, 5, 7,20,20 },
	{ 7,INSTRS_X+2*8,INSTRS_PY+14*16,"07:",0xff,0, 6, 8,21,21 },
	//TABLE: LEN GO SPD TYPE MODE
	{ 8,INSTRS_X+1*8,INSTRS_PY+2*16,"LEN:",0x07,1,  7, 9,13,13 },
	{ 9,INSTRS_X+2*8,INSTRS_PY+3*16,"GO:" ,0x07,0,  8,10,14,14 },
	{10,INSTRS_X+1*8,INSTRS_PY+4*16,"SPD:",0x3f,1,  9,11,15,15 },
	{11,INSTRS_X+0*8,INSTRS_PY+5*16,"TYPE:",0x01,0,10,12,16,16 },
	{12,INSTRS_X+0*8,INSTRS_PY+6*16,"MODE:",0x01,0,11, 0,16,16 },
	//ENVELOPE: LEN GO VSLIDE VMIN
	{13,INSTRS_X+16*8,INSTRS_PY+2*16,"LEN:"   ,0x1f,1,21,14, 8, 8 },
	{14,INSTRS_X+17*8,INSTRS_PY+3*16,"GO:"    ,0x1f,0,13,15, 9, 9 },
	{15,INSTRS_X+13*8,INSTRS_PY+4*16,"VSLIDE:",0xff,0,14,16,10,10 },
	{16,INSTRS_X+15*8,INSTRS_PY+5*16,"VMIN:"  ,0x0f,0,15,17,11,11 },
	//EFFECT: DELAY VIBRATO FSHIFT
	{17,INSTRS_X+14*8,INSTRS_PY+ 8*16,"DELAY:",  0xff,0,16,18, 1, 1 },
	{18,INSTRS_X+12*8,INSTRS_PY+ 9*16,"VIBRATO:",0x03,0,17,19, 2, 2 },
	{19,INSTRS_X+13*8,INSTRS_PY+10*16,"FSHIFT:", 0xff,0,18,20, 3, 3 },
	//AUDCTL: POLY9 15KHZ
	{20,INSTRS_X+14*8,INSTRS_PY+13*16,"POLY9:"  ,0x01,0,19,21, 6, 6 },
	{21,INSTRS_X+14*8,INSTRS_PY+14*16,"15KHZ:"  ,0x01,0,20,13, 7, 7 }
};


#define PAR_TAB0	0
#define PAR_TAB1	1
#define PAR_TAB2	2
#define PAR_TAB3	3
#define PAR_TAB4	4
#define PAR_TAB5	5
#define PAR_TAB6	6
#define PAR_TAB7	7
#define PAR_TABLEN	8
#define PAR_TABGO	9
#define PAR_TABSPD	10
#define PAR_TABTYPE	11
#define PAR_TABMODE	12

#define PAR_ENVLEN	13
#define PAR_ENVGO	14
#define PAR_VSLIDE	15
#define PAR_VMIN	16
#define PAR_DELAY	17
#define PAR_VIBRATO	18
#define PAR_FSHIFT	19
#define PAR_POLY9	20
#define PAR_15KHZ	21


struct Tshenv
{
	char ch;
	int pand;
	int padd;
	int psub;
};

const Tshenv shenv[8]=
{
	//ENVELOPE
	{   0,0x0f,1,-1 },	//volume right
	{   0,0x0f,1,-1 },	//volume left
	{   0,0x0e,2,-2 },	//distortion 0,2,4,6,...
	{   0,0x07,1,-1 },	//command 0-7, 7 neni v teto verzi podporovana
	{   0,0x0f,1,-1 },	//X
	{   0,0x0f,1,-1 },	//Y
	{   9,0x01,1,-1 },	//filter *
	{   9,0x01,1,-1 }	//portamento *
};

#define	ENV_VOLUMER		0
#define	ENV_VOLUMEL		1
#define	ENV_DISTORTION	2
#define ENV_COMMAND		3
#define	ENV_X			4
#define	ENV_Y			5
#define	ENV_FILTER		6
#define	ENV_PORTAMENTO	7


CInstruments::CInstruments()
{
	InitInstruments();
}

BOOL CInstruments::InitInstruments()
{
	for(int i=0; i<INSTRSNUM; i++)
	{
		ClearInstrument(i);
	}
	return 1;
}

BOOL CInstruments::ClearInstrument(int it)
{
	int i,j;
	char *s = m_instr[it].name; 
	strnset(s,' ',INSTRNAMEMAXLEN);
	s[INSTRNAMEMAXLEN]=0;
	sprintf(s,"Instrument %02X",it);
	s[strlen(s)] = ' ';

	m_instr[it].act=0;				//active name
	m_instr[it].activenam=0;		//0.ty znak v name
	m_instr[it].activepar=13;		//13.parametr je ENVELOPE LEN
	m_instr[it].activeenvx=0;
	m_instr[it].activeenvy=1;		//volume levy
	for(i=0; i<PARCOUNT; i++) m_instr[it].par[i]=0;
	for(i=0; i<ENVCOLS; i++)
	{
		for(j=0; j<ENVROWS; j++) m_instr[it].env[i][j]=0; //rand()&0x0f;			//0;
	}

	m_iflag[it] = 0;	//init instrument flagu

	ModificationInstrument(it);			//promitne do Atari mem

	return 1;
}

int CInstruments::SaveAll(ofstream& ou)
{
	for(int i=0; i<INSTRSNUM; i++)
	{
		SaveInstrument(i,ou,IOINSTR_RMW);
	}
	return 1;
}


int CInstruments::LoadAll(ifstream& in)
{
	for(int i=0; i<INSTRSNUM; i++)
	{
		LoadInstrument(i,in,IOINSTR_RMW);
	}

	return 1;
}

int CInstruments::SaveInstrument(int instr,ofstream& ou, int iotype)
{
	TInstrument& ai=m_instr[instr];

	if (iotype==IOINSTR_RTI)
	{
		//RTI file
		static char head[4]="RTI";
		head[3]=0;			//typ 0
		ou.write(head,4);	//4 byty hlavicka RTI0 (binarni nula)
		ou.write((unsigned char*) ai.name,sizeof(ai.name)); //jmeno 32bytu + 33. je binarni nula ukoncujici string
		unsigned char ibf[MAXATAINSTRLEN];
		BYTE len = InstrToAta(instr,ibf,MAXATAINSTRLEN);
		ou.write((char*)&len,sizeof(len));				//delka instrumentu v Atari bytech
		if (len>0) ou.write(ibf,len);					//data instrumentu
	}
	else
	if (iotype==IOINSTR_RMW)
	{
		//name instrumentu
		ou.write((unsigned char*) ai.name,sizeof(ai.name));

		char bfpar[PARCOUNT],bfenv[ENVCOLS][ENVROWS];
		int j,k;
		//
		//
		for (j=0; j<PARCOUNT; j++) bfpar[j]=ai.par[j];
		ou.write(bfpar, sizeof(bfpar));
		//
		for (j=0; j<ENVCOLS; j++)
		{
			for(k=0; k<ENVROWS; k++)
				bfenv[j][k] = ai.env[j][k];
		}
		ou.write((char*)bfenv, sizeof(bfenv));
		//
		//+editacni doplnky:
		ou.write((char*)&ai.act,sizeof(ai.act));
		ou.write((char*)&ai.activenam,sizeof(ai.activenam));
		ou.write((char*)&ai.activepar,sizeof(ai.activepar));
		ou.write((char*)&ai.activeenvx,sizeof(ai.activeenvx));
		ou.write((char*)&ai.activeenvy,sizeof(ai.activeenvy));
	}

	return 1;
}

int CInstruments::LoadInstrument(int instr, ifstream& in, int iotype)
{
	//nejdriv ho smaze nez bude nacitat
	ClearInstrument(instr);
	
	TInstrument& ai=m_instr[instr];

	if (iotype==IOINSTR_RTI)
	{
		//RTI
		char head[4];
		in.read(head,4);	//4 byty hlavicka
		if (strncmp(head,"RTI\x0",4)!=0) return 0;		//neni tam RTI hlavicka

		in.read((unsigned char*) ai.name,sizeof(ai.name)); //jmeno 32 bytu + 33.binarni ukoncujici nula

		BYTE len;
		in.read((char*)&len,sizeof(len));				//delka instrumentu v Atari bytech
		if (len>0)
		{
			unsigned char ibf[MAXATAINSTRLEN];
			in.read(ibf,len);
			AtaToInstr(ibf,instr);
			ModificationInstrument(instr);	//zapise do Atari ram
		}
	}
	else
	if (iotype==IOINSTR_RMW)
	{
		//RMW
		//jmeno instrumentu
		in.read((unsigned char*) ai.name,sizeof(ai.name));


		char bfpar[PARCOUNT],bfenv[ENVCOLS][ENVROWS];
		int j,k;

		//
		in.read(bfpar, sizeof(bfpar));
		for (j=0; j<PARCOUNT; j++) ai.par[j] = bfpar[j];
		//
		in.read((char*)bfenv, sizeof(bfenv));
		for (j=0; j<ENVCOLS; j++)
		{
			for(k=0; k<ENVROWS; k++)
				ai.env[j][k] = bfenv[j][k];
		}
		//
		ModificationInstrument(instr);	//zapise do Atari mem
		//
		//+editacni doplnky:
		in.read((char*)&ai.act,sizeof(ai.act));
		in.read((char*)&ai.activenam,sizeof(ai.activenam));
		in.read((char*)&ai.activepar,sizeof(ai.activepar));
		in.read((char*)&ai.activeenvx,sizeof(ai.activeenvx));
		in.read((char*)&ai.activeenvy,sizeof(ai.activeenvy));
	}

	return 1;
}


BOOL CInstruments::ModificationInstrument(int instr)
{
	unsigned char* ata = g_atarimem + instr*256 +0x4000;
	g_rmtroutine = 0;			//vypnuti RMT rutiny
	BYTE r = InstrToAta(instr,ata,MAXATAINSTRLEN);
	g_rmtroutine = 1;			//zapnuti RMT rutiny
	RecalculateFlag(instr);
	return r;
}

BOOL CInstruments::RecalculateFlag(int instr)
{
	BYTE flag = 0;
	TInstrument& ti = m_instr[instr];
	int i;
	int envl = ti.par[PAR_ENVLEN];
	//filter?
	for(i=0; i<=envl; i++)
	{
		if (ti.env[i][ENV_FILTER]) { flag |= IF_FILTER; break; }
	}
	//bass16?
	for(i=0; i<=envl; i++)
	{
		//filter ma prednost pred bass16, tj. kdyz je soucasne filter i bass16, bass16 neplati
		if (ti.env[i][ENV_DISTORTION]==6 && !ti.env[i][ENV_FILTER]) { flag |= IF_BASS16; break; }
	}
	//portamento?
	for(i=0; i<=envl; i++)
	{
		if (ti.env[i][ENV_PORTAMENTO]) { flag |= IF_PORTAMENTO; break; }
	}
	//poly9?
	if (ti.par[PAR_POLY9]) flag |= IF_POLY9;
	//15khz?
	if (ti.par[PAR_15KHZ]) flag |= IF_15KHZ;
	//
	m_iflag[instr] = flag;
	return 1;
}

BYTE CInstruments::InstrToAta(int instr,unsigned char *ata,int max)
{
	TInstrument& ai=m_instr[instr];
	int i,j;
	//0-7 table
	for(i=PAR_TAB0; i<=PAR_TAB7; i++) ata[i]=ai.par[i];
	//8 ;instr len  0-31 *8, table len  0-7  (iiii ittt)
	int* par = ai.par;
	ata[8] = (par[PAR_ENVLEN]<<3) | (par[PAR_TABLEN]);
	ata[9] = (par[PAR_ENVGO]<<3) | (par[PAR_TABGO]);
	ata[10]= (par[PAR_TABTYPE]<<7)
		   | (par[PAR_TABMODE]<<6)
		   | (par[PAR_TABSPD]);
	ata[11]= (par[PAR_VSLIDE]);
	ata[12]= (par[PAR_VMIN]<<4) | (par[PAR_POLY9]<<1) | (par[PAR_15KHZ]);
	ata[13]= (par[PAR_DELAY]);
	ata[14]= (par[PAR_VIBRATO]);
	ata[15]= (par[PAR_FSHIFT]);

	//
	BOOL stereo = (g_tracks4_8>4);
	int len= par[PAR_ENVLEN];
	for(i=0,j=16; i<=len; i++,j+=3)
	{
		int* env = (int*) &ai.env[i];
		ata[j] = (stereo)?
			(env[ENV_VOLUMER]<<4) | (env[ENV_VOLUMEL]) //stereo
		:
			(env[ENV_VOLUMEL]<<4) | (env[ENV_VOLUMEL]); //mono, VOLUME R = VOLUME L

		ata[j+1]=(env[ENV_FILTER]<<7)
			   | (env[ENV_COMMAND]<<4)	//0-7
			   | (env[ENV_DISTORTION])	//0,2,4,..14
			   | (env[ENV_PORTAMENTO]);
		ata[j+2]=(env[ENV_X]<<4)
			   | (env[ENV_Y]);
	}
/*
	dta 1*8+0		;instr len  0-31 *8, table len  0-7  (iiii ittt)
	dta 1*8+0		;instr loop 0-31 *8, table loop 0-7  (iiii ittt)
	dta $00+$00+15		;tmss ssss	table type, table mode, table speed 0-63 (0=>1vbi,63=>64vbi)
					;t = type 0-1 *$80 (table 0=notes/1=frqshifts)
					;m = mode 0-1 *$40 (0=set/1=add notes or frqshifts)
					;s = table speed 0-63
	dta 64			;volume-= x/256 (from first instrument loop each vbi)		(ok)
	dta 5*16		;mmmm 00ab   minimalni volume *16 + audctl ab (a=1=>9bit citac misto 17bit, b=1=>hlavni frq 15KHz)
	dta 20			;effdelay: 0-vubec,1-255					(ok)
	dta 3			;0000 00vv
					;v = effvibrato 0zadne,1male,2stredni,3velke	(ok)
	dta 0			;effshift    (shiftfrq+=xx)					(ok)
	;trojice rrrrllll,fcccddds,pppppppp    (volume right left, filter command distortion slide, parametr)
	dta 10*16+14,$80+$50+$0a+0,$18
*/
	return 16 + (len+1)*3;	//vraci datovou delku instrumentu
}


BOOL CInstruments::AtaToInstr(unsigned char *ata, int instr)
{
	TInstrument& ai=m_instr[instr];
	int i,j;
	//0-7 table
	for(i=PAR_TAB0; i<=PAR_TAB7; i++) ai.par[i] = ata[i];
	//8 ;instr len  0-31 *8, table len  0-7  (iiii ittt)
	int* par = ai.par;
	int len = par[PAR_ENVLEN] = ata[8]>>3;
	par[PAR_TABLEN] = ata[8] & 0x07;
	par[PAR_ENVGO]  = ata[9]>>3;
	par[PAR_TABGO]  = ata[9] & 0x07;
	par[PAR_TABTYPE]= ata[10]>>7;
	par[PAR_TABMODE]= (ata[10]>>6) & 0x01;
	par[PAR_TABSPD]	= ata[10] & 0x3f;
	par[PAR_VSLIDE] = ata[11];
	par[PAR_VMIN]	= ata[12]>>4;
	par[PAR_POLY9]	= (ata[12]>>1) & 0x01;
	par[PAR_15KHZ]	= ata[12] & 0x01;
	par[PAR_DELAY]	= ata[13];
	par[PAR_VIBRATO]= ata[14] & 0x03;
	par[PAR_FSHIFT]	= ata[15];

	//
	BOOL stereo = (g_tracks4_8>4);
	for(i=0,j=16; i<=len; i++,j+=3)
	{
		int* env = (int*) &ai.env[i];
		env[ENV_VOLUMER] = (stereo)? (ata[j]>>4) : (ata[j] & 0x0f); //je-li mono, pak VOLUME R = VOLUME L
		env[ENV_VOLUMEL] = ata[j] & 0x0f;
		env[ENV_FILTER]  = ata[j+1]>>7;
		env[ENV_COMMAND] = (ata[j+1]>>4) & 0x07;
		env[ENV_DISTORTION] = ata[j+1] & 0x0e;	//suda cisla 0,2,4,..,14
		env[ENV_PORTAMENTO] = ata[j+1] & 0x01;
		env[ENV_X]		 = ata[j+2]>>4;
		env[ENV_Y]		 = ata[j+2] & 0x0f;
	}

	return 1;
}

CInstruments::CalculateNoEmpty(int instr)
{
	TInstrument& it = m_instr[instr];
	int i,j;
	int len=it.par[PAR_ENVLEN];
	for(i=0; i<len; i++)
	{
		for (j=0; j<ENVROWS; j++) 
		{
			if (it.env[i][j]!=0) return 1;
		}
	}
	for(i=0; i<PARCOUNT; i++) 
	{
		if (it.par[i]!=0) return 1;
	}
	return 0; //je prazdny
}


BOOL CInstruments::DrawInstrument(int it)
{
	int i;
	char s[128];

	TInstrument& t = m_instr[it];

	sprintf(s,"INSTRUMENT %02X",it);
	TextXY(s,INSTRS_X,INSTRS_Y);
	DrawName(it);

	TextXY("TABLE",INSTRS_X,INSTRS_PY+16);
	TextXY("ENVELOPE",INSTRS_X+13*8,INSTRS_PY+16);
	TextXY("EFFECT",INSTRS_X+13*8,INSTRS_PY+7*16);
	TextXY("AUDCTL",INSTRS_X+13*8,INSTRS_PY+12*16);
	//
	TextDownXY("\x0e\x0e\x0e\x0e", INSTRS_EX+11*8-1,INSTRS_EY+3*16,1);
	
	if (t.act==2)	//pouze kdyz je kurzor na editaci envelope
	{
		sprintf(s,"POS %02X",t.activeenvx);
		TextXY(			   s,INSTRS_EX+2*8,INSTRS_EY+5*16,1); //sedou
	}
	//
	TextXY(  "VOLUME L:",INSTRS_EX+2*8,INSTRS_EY+8*16);
	TextXY("DISTORTION:",INSTRS_EX+0*8,INSTRS_EY+9*16);
	TextXY(   "COMMAND:",INSTRS_EX+3*8,INSTRS_EY+10*16);
	TextXY(         "X/",INSTRS_EX+9*8,INSTRS_EY+11*16);
	TextXY(         "Y\\",INSTRS_EX+9*8,INSTRS_EY+12*16);
	TextXY(    "FILTER:",INSTRS_EX+4*8,INSTRS_EY+13*16);
	TextXY("PORTAMENTO:",INSTRS_EX+0*8,INSTRS_EY+14*16);

	if (g_tracks4_8>4)
	{
		TextXY(  "VOLUME R:",INSTRS_EX+2*8,INSTRS_EY+2*16);
		TextDownXY("\x0e\x0e\x0e\x0e", INSTRS_EX+11*8-1,INSTRS_EY-2*16,1);
		g_mem_dc->MoveTo(INSTRS_EX+12*8-1,INSTRS_EY+2*16-1);
		g_mem_dc->LineTo(INSTRS_EX+44*8,INSTRS_EY+2*16-1);
	}

	for(i=0; i<22; i++) DrawPar(i,it);
	
	//ikona u TABLE TYPE
	i = (t.par[PAR_TABTYPE]==0) ? 1 : 2;
	IconMiniXY(i,shpar[PAR_TABTYPE].x+8*8+2,shpar[PAR_TABTYPE].y+7);
	//ikona u TABLE MODE
	i = (t.par[PAR_TABMODE]==0) ? 3 : 4;
	IconMiniXY(i,shpar[PAR_TABMODE].x+8*8+2,shpar[PAR_TABMODE].y+7);

	s[1]=0;


	int len = t.par[PAR_ENVLEN];	//par 13 je delka evelope
	for(i=0; i<=len; i++) DrawEnv(i,it);

	//ENVELOPE LOOP SIPKY
	int go = t.par[PAR_ENVGO];		//par 14 je envelope GO smycka
	if (go<len)
	{
		s[0]='\x07';	//Go odtud
		TextXY(s,INSTRS_EX+12*8+len*8,INSTRS_EY+7*16);
		s[0]='\x06';	//Go sem

		int lengo = len-go;
		if (lengo>3) NumberMiniXY(lengo+1,INSTRS_EX+11*8+4+go*8+lengo*4,INSTRS_EY+7*16+4); //len-go cisilko
	}
	else
		s[0]='\x16';	//GO odtud-sem
	TextXY(s,INSTRS_EX+12*8+go*8,INSTRS_EY+7*16);
	if (go>2) NumberMiniXY(go,INSTRS_EX+11*8+go*4,INSTRS_EY+7*16+4); //GO cisilko

	//TABLE LOOP SIPKY
	len = t.par[PAR_TABLEN];	//par 8 je delka table
	go = t.par[PAR_TABGO];		//par 9 je table GO smycka
	if (go<len)
	{
		s[0]='\x10';	//Go odtud
		TextXY(s,INSTRS_X+1*8,INSTRS_PY+7*16+len*16);
		s[0]='\x0f';	//Go sem
	}
	else
	{
		if (len==0)
			s[0]='\x18';	//jen rovna sipka na prvni parametr v tabulce
		else
			s[0]='\x11';	//GO odtud-sem
	}
	TextXY(s,INSTRS_X+1*8,INSTRS_PY+7*16+go*16);

	g_mem_dc->MoveTo(INSTRS_EX+12*8-1,INSTRS_EY+7*16-1);
	g_mem_dc->LineTo(INSTRS_EX+44*8,INSTRS_EY+7*16-1);

	if (!g_viewinstractivehelp) return 1; //nechce help => konec
	//chce help, pokracujeme

#define INSTRS_HX INSTRS_X
#define INSTRS_HY INSTRS_Y+18*16

//oddelujici cara
#define HORIZONTALLINE {	g_mem_dc->MoveTo(INSTRS_HX,INSTRS_HY-1); g_mem_dc->LineTo(INSTRS_HX+93*8,INSTRS_HY-1); }

	if (t.act==2)	//je kurzor na envelope?
	{
		switch(t.activeenvy)
		{
		case ENV_DISTORTION:
			{
			int d = t.env[t.activeenvx][ENV_DISTORTION];
			static char* distor_help[8] = {
				"Distortion 0. (AUDC $0v)",
				"Distortion 2. (AUDC $2v)",
				"Distortion 4. (AUDC $4v)",
				"Distortion 12, 16bit bass tones by join of two generators. (AUDC $Cv)",
				"Distortion 8. (AUDC $8v)",
				"Distortion 10, pure tones. (AUDC $Av)",
				"Distortion 12, bass tones - bass table 1. (AUDC $Cv)",
				"Distortion 12, bass tones - bass table 2. (AUDC $Cv)" };
			char* hs = distor_help[(d>>1)&0x07];
			TextXY(hs,INSTRS_HX,INSTRS_HY,1);
			//HORIZONTALLINE;
			}
			break;

		case ENV_COMMAND:
			{
			int c = t.env[t.activeenvx][ENV_COMMAND];
			static char* comm_help[8] = {
				"Play BASE_NOTE + $XY semitones.",
				"Play frequency $XY.",
				"Play BASE_NOTE + frequency $XY.",
				"Set BASE_NOTE += $XY semitones. Play BASE_NOTE.",
				"Set FSHIFT += frequency $XY. Play BASE_NOTE.",
				"Set portamento speed $X, step $Y. Play BASE_NOTE.",
				"Set FILTER_SHFRQ += frequency $XY. Play BASE_NOTE.",
				"Set BASE_NOTE = $XY. Play BASE_NOTE." };
			char* hs = comm_help[c & 0x07];
			TextXY(hs,INSTRS_HX,INSTRS_HY,1);
			//HORIZONTALLINE;
			}
			break;

		case ENV_X:
		case ENV_Y:
			{
			char i = (t.env[t.activeenvx][ENV_X]<<4) | t.env[t.activeenvx][ENV_Y];
			sprintf(s,"XY: $%02X = %i = %+i",(unsigned char)i,(unsigned char)i,i);
			TextXY(s,INSTRS_HX,INSTRS_HY,1);
			//HORIZONTALLINE;
			}
			break;
		}
	}
	else
	if (t.act==1)	//kurzor je na main parametrech
	{
		switch(t.activepar)
		{
		case PAR_TAB0:
		case PAR_TAB1:
		case PAR_TAB2:
		case PAR_TAB3:
		case PAR_TAB4:
		case PAR_TAB5:
		case PAR_TAB6:
		case PAR_TAB7:
		case PAR_FSHIFT:
			{
			char i = (t.par[t.activepar]);
			sprintf(s,"$%02X = %+i",(unsigned char)i,i);
			TextXY(s,INSTRS_HX,INSTRS_HY,1);
			//HORIZONTALLINE;
			}
			break;

		case PAR_DELAY:
			{
			unsigned char i = (t.par[t.activepar]);
			if (i>0)
				sprintf(s,"$%02X = %i",i,i);
			else
				sprintf(s,"$00 = no effects.");
			TextXY(s,INSTRS_HX,INSTRS_HY,1);
			//HORIZONTALLINE;
			}
			break;

		case PAR_VSLIDE:
			{
			unsigned char i = (t.par[t.activepar]);
			double f;
			if (i==0) f=0;
			else
			if (i==0xff) f=1;
			else
				f = (double)i/256 + 0.0005;
			sprintf(s,"$%02X = -%.3f / vbi",(unsigned char)i,f);
			TextXY(s,INSTRS_HX,INSTRS_HY,1);
			//HORIZONTALLINE;
			}
			break;

		}
	}


	return 1;
}

BOOL CInstruments::DrawName(int it)
{
	char* s=GetName(it);
	int n=-1,c=0;
	if (!g_prove && g_activepart==PARTINSTRS && m_instr[it].act==0) //je aktivni zmena jmena instrumentu
	{
		n=m_instr[it].activenam; //ktere pismenko
		c=6; //cervene
	}
	TextXY("NAME:",INSTRS_X,INSTRS_Y+16,0);
	TextXYSelN(s,n,INSTRS_X+6*8,INSTRS_Y+16,c);
	return 1;
}

BOOL CInstruments::DrawPar(int p,int it)
{
	char s[2];
	s[1]=0;
	//TextXY(shpar[p].name,shpar[p].x,shpar[p].y);
	char *txt=shpar[p].name;
	int x=shpar[p].x;
	int y=shpar[p].y;

	char a;
	int c=0;				//c<<4;
	for(int i=0; a=(txt[i]); i++,x+=8)
		g_mem_dc->BitBlt(x,y,8,16,g_gfx_dc,(a & 0x7f)<<3,c,SRCCOPY);
	
	//selektnuty parametr?
	if (!g_prove && g_activepart==PARTINSTRS && m_instr[it].act==1 && m_instr[it].activepar==p) c=3;	//color 3

	x+=8;
	int showpar = m_instr[it].par[p] + shpar[p].pfrom;	//nektere parametry jsou 0..x ale vypisuje se 1..x+1
	if (shpar[p].pand>0x0f)
	{
		s[0]=CharH4(showpar);
		TextXY(s,x,y,c);
	}

	x+=8;
	s[0]=CharL4(showpar);
	TextXY(s,x,y,c);	

	return 1;
}

BOOL CInstruments::DrawEnv(int e, int it)
{
	TInstrument& in = m_instr[it];
	int volR= in.env[e][0] & 0x0f; //volume right
	int volL= in.env[e][1] & 0x0f; //volume left/mono
	int c;
	int x=INSTRS_EX+12*8+e*8;
	char s[2],a;
	s[1]=0;
	int ay= (in.act==2 && in.activeenvx==e)? in.activeenvy : -1;
	//volume sloupec
	if (volL) g_mem_dc->FillSolidRect(x,INSTRS_EY+3*16+4+4*(15-volL),8,volL*4,RGB(255,255,255));
	if (g_tracks4_8>4 && volR) g_mem_dc->FillSolidRect(x,INSTRS_EY-2*16+4+4*(15-volR),8,volR*4,RGB(255,255,255));
	for(int j=0; j<8; j++)
	{
		if ( (a=shenv[j].ch)!=0 )
		{
			if (m_instr[it].env[e][j])
				s[0]=a;
			else
				s[0]=8;	//znak . v envelope
		}
		else
			s[0]=CharL4(m_instr[it].env[e][j]);
		c = (j==ay && !g_prove && g_activepart==PARTINSTRS)? 3 : 0;	//selectovany znak?
		if (j==0)
		{
			if (g_tracks4_8>4) TextXY(s,x,INSTRS_EY+2*16,c);		 //volume R je mimo ostatni 
		}
		else
			TextXY(s,x,INSTRS_EY+7*16+j*16,c);
	}
	return 1;
}

//----------------------------------------------

CTracks::CTracks()
{
	m_maxtracklen = 64;			//default hodnota
	InitTracks();
}

BOOL CTracks::InitTracks()
{
	for(int i=0; i<TRACKSNUM; i++)
	{
		ClearTrack(i);
	}
	return 1;
}

BOOL CTracks::ClearTrack(int t)
{
	m_track[t].len=m_maxtracklen;	//32+(rand()&0x1f);		//0;
	m_track[t].go=-1;	//-1+(rand()&0x01);			//-1;
	for (int i=0; i<TRACKLEN; i++)
	{
		m_track[t].note[i]=-1;	//(rand()&0xff)-192;		//-1;
		m_track[t].instr[i]=-1;	//rand()&0xff;	//-1;
		m_track[t].volume[i]=-1;//rand()&0x0f;	//-1;
		m_track[t].speed[i]=-1; //rand()&0xff;	//-1;
	}
	return 1;
}

BOOL CTracks::IsEmptyTrack(int track)
{
	if (m_track[track].len!=m_maxtracklen) return 0;
	int* tvolumes = (int*)&m_track[track].volume;
	int* tspeeds = (int*)&m_track[track].speed;

	for(int i=0; i<m_maxtracklen; i++)
	{
		if ( *(tvolumes+i) >=0 || *(tspeeds+i)>=0) return 0;
	}
	return 1;
}

int CTracks::SaveAll(ofstream& ou)
{
	ou.write((unsigned char*) &m_maxtracklen,sizeof(m_maxtracklen));
	char bf[TRACKLEN];
	int j;
	for(int i=0; i<TRACKSNUM; i++)
	{
		TTrack& at=m_track[i];
		ou.write((unsigned char*) &at.len,sizeof(at.len));
		ou.write((unsigned char*) &at.go,sizeof(at.go));
		//
		//vsechno
		for(j=0; j<m_maxtracklen; j++) bf[j]=at.note[j];
		ou.write(bf,m_maxtracklen);
		for(j=0; j<m_maxtracklen; j++) bf[j]=at.instr[j];
		ou.write(bf,m_maxtracklen);
		for(j=0; j<m_maxtracklen; j++) bf[j]=at.volume[j];
		ou.write(bf,m_maxtracklen);
		for(j=0; j<m_maxtracklen; j++) bf[j]=at.speed[j];
		ou.write(bf,m_maxtracklen);
	}
	return 1;
}


int CTracks::LoadAll(ifstream& in)
{
	InitTracks();

	in.read((unsigned char*) &m_maxtracklen,sizeof(m_maxtracklen));

	char bf[TRACKLEN];
	int j;
	for(int i=0; i<TRACKSNUM; i++)
	{
		TTrack& at=m_track[i];
		in.read((unsigned char*) &at.len,sizeof(at.len));
		in.read((unsigned char*) &at.go,sizeof(at.go));
		//
		//vsechno
		in.read(bf,m_maxtracklen);
		for(j=0; j<m_maxtracklen; j++) at.note[j]=bf[j];
		in.read(bf,m_maxtracklen);
		for(j=0; j<m_maxtracklen; j++) at.instr[j]=bf[j];
		in.read(bf,m_maxtracklen);
		for(j=0; j<m_maxtracklen; j++) at.volume[j]=bf[j];
		in.read(bf,m_maxtracklen);
		for(j=0; j<m_maxtracklen; j++) at.speed[j]=bf[j];
	}
	return 1;
}

int CTracks::TrackToAta(int track,unsigned char* dest,int max)
{

#define WRITEATIDX(value) { if (idx<max) { dest[idx]=value; idx++; } else return -1; }
#define WRITEPAUSE(pause)									\
{															\
	if (pause>=1 && pause<=3)								\
		{ WRITEATIDX(62 | (pause<<6)); }						\
	else													\
		{ WRITEATIDX(62); WRITEATIDX(pause); }				\
}

	int note,instr,volume,speed;
	int idx=0;
	int goidx=-1;
	TTrack& t=m_track[track];
	int pause=0;

	for(int i=0; i<t.len; i++)
	{
		note = t.note[i];
		instr = t.instr[i];
		volume = t.volume[i];
		speed = t.speed[i];

		if (volume>=0 || speed>=0 || t.go==i) //neco tam bude, zapise prazdne takty predtim
		{
			if (pause>0)
			{
				WRITEPAUSE(pause);
				pause=0;
			}
			
			if (t.go==i) goidx=idx;	//sem se bude skakat go smyckou

			//speed je pred notami
			if (speed>=0)
			{
				//je speed
				WRITEATIDX(63);		//63 = zmena speed
				WRITEATIDX(speed & 0xff);

				if (note>=0 || volume>=0)
					pause=0;
				else
					pause=1;	//v tomto radku je jen speed bez jine udalosti
			}
		}
		
		//co to bude
		if (note>=0 && instr>=0 && volume>=0)
		{
			//nota,instr,vol
			WRITEATIDX( ((volume & 0x03)<<6)
					|  ((note & 0x3f))
					 );
			WRITEATIDX( ((instr & 0x3f)<<2)
					|  ((volume & 0x0c)>>2)
					 );
			pause=0;
		}
		else
		if (volume>=0)
		{
			//jen volume
			WRITEATIDX( ((volume & 0x03)<<6)
					|	61		//61 = empty note (nastavuje se pouze volume)
					 );
			WRITEATIDX( (volume & 0x0c)>>2 );	//bez instrumentu
			pause=0;
		}
		else
			pause++;
	}
	//konec smycky

	if (t.len<m_maxtracklen)	//track je kratsi nez maximalni delka
	{
		if (pause>0)	//zbyva pred koncem jeste nejaka pauza?
		{
			//tak tu pauzu zapise
			WRITEPAUSE(pause);
			pause=0;
		}
		
		if (t.go>=0 && goidx>=0)	//je tam go smycka?
		{
			//zapise go smycku
			WRITEATIDX( 0x80 | 63 );	//go povel
			WRITEATIDX( goidx );
		}
		else
		{
			//zapise konec
			WRITEATIDX( 255 );		//konec
		}
	}
	else
	{		//track je dlouhy jako maximalni delka
		if (pause>0)
		{
			WRITEPAUSE(pause);	//zapise je
		}
	}
	return idx;
}

BOOL CTracks::AtaToTrack(unsigned char* sour,int len,int track)
{
	TTrack& t = m_track[track];
	unsigned char b,c;
	int goidx=-1;

	if (len>=2)
	{
		//na konci tracku je go smycka
		if (sour[len-2]==128+63) goidx=sour[len-1];	//ulozi si jeji index
	}

	int line=0;
	int i=0;
	while(i<len)
	{
		if (i==goidx) t.go = line;		//sem skace goidx => nastavi go na tuto line

		b = sour[i] & 0x3f;
		if (b>=0 && b<=60)	//note,instr,vol
		{
			t.note[line]=b;
			t.instr[line]= ((sour[i+1] & 0xfc)>>2);			//11111100
			t.volume[line]=((sour[i+1] & 0x03)<<2)			//00000011
						|  ((sour[i]   & 0xc0)>>6);			//11000000
			i+=2;
			line++;
			continue;
		}
		else
		if (b==61)	//vol only
		{
			t.volume[line]=((sour[i+1] & 0x03)<<2)			//00000011
						|  ((sour[i] & 0xc0)>>6);			//11000000
			i+=2;
			line++;
			continue;
		}
		else
		if (b==62)	//pause
		{
			c = sour[i] & 0xc0;		//nejvyssi 2 bity
			if (c==0)
			{	//jsou nulove
				if (sour[i+1]==0) break;			//nekonecna pauza =>konec
				line += sour[i+1];	//posun line
				i+=2;
			}
			else
			{	//jsou nenulove
				line += (c>>6);		//horni 2 bity primo urcuji pauzu 1-3
				i++;
			}
			continue;
		}
		else
		if (b==63)	//speed nebo gosmycka nebo end
		{
			c = sour[i] & 0xc0;		//11000000
			if (c==0)				//nejvyssi 2 bity jsou 0 ?  (00xxxxxx)
			{
				//speed
				t.speed[line]=sour[i+1];
				i+=2;
				//bez posunu line
				continue;
			}
			else
			if (c==0x80)			//nejvyssi bit=1?   (10xxxxxx)
			{
				//go smycka
				t.len = line; //tim padem je tady konec
				break;
			}
			else
			if (c==0xc0)			//nejvyssi dva bity=1?  (11xxxxxx)
			{
				//end
				t.len = line;
				break;
			}
		}
	}

	return 1;
}

BOOL CTracks::DrawTrack(int col,int x,int y,int tr,int aline,int pline,BOOL isactive,int acu)
{
	char s[16];
	int i,line,xline,n,c,len,last,go;

	len=last=0;
	TTrack *tt=NULL;
	strcpy(s,"--  ---- ");
	if (tr>=0)
	{
		tt=&m_track[tr];
		s[0]=CharH4(tr);
		s[1]=CharL4(tr);
		len=last=tt->len;	//len a last
		go=tt->go;	//go
		if (IsEmptyTrack(tr))
		{
			//prazdny track
			strncpy(s+3,"EMPTY",5);
		}
		else
		{
			//neprazdny track
			if (len>=0)
			{
				s[4]=CharH4(len);
				s[5]=CharL4(len);
			}
			if (go>=0)
			{
				s[6]=CharH4(go);
				s[7]=CharL4(go);
				last=m_maxtracklen;
			}
		}
	}
	TextXY(s,x+8,y);
	y+=32;
	//--
	for(i=0; i<17; i++,y+=16)
	{
		line = aline + i - 8;		//8 lines shora
		if (line<0 || line>=m_maxtracklen) continue;
		if (line>=last)
		{
			if (line == aline && isactive) c=6;	//cervena
			else
			if (line == pline) c=2;	//zluta
			else
				c=1;		//seda
			
			if (line==last && len>0)
			{
				if (c==1) c=0;	//end neni sedy, ale bily
				TextXY("\x12\x12\x13\x14\x15\x12\x12\x12",x+1*8,y,c);
			}
			else
				TextXY(".",x+5*8,y,c);
			continue;
		}
		strcpy(s," --- -- -  ");
		if (tt)
		{
			if (line<len || go<0) xline=line;
			else
				xline = ((line-len) % (len-go)) + go;

			if ( (n=tt->note[xline])>=0 )
			{ 
				//nota
				s[1]=notes[n][0];		// C
				s[2]=notes[n][1];		// #
				s[3]=notes[n][2];		// 1
			}
			if ( (n=tt->instr[xline])>=0 )
			{
				//instrument
				s[5]=CharH4(n);
				s[6]=CharL4(n);
			}
			if ( (n=tt->volume[xline])>=0 )
			{
				//volume
				s[8]=CharL4(n);
			}
			if ( (n=tt->speed[xline])>=0 )
			{
				//speed
				s[9]=CharH4(n);
				s[10]=CharL4(n);
			}
		}

		if (line==go)
		{
			if (line==len-1)
				s[0]='\x11';			//sipka doleva-nahoru-doprava
			else
				s[0]='\x0f';			//sipka nahoru-doprava
		}
		else
		if (line==len-1 && go>=0) s[0]='\x10'; //sipka doleva-nahoru

		//barvy
		if (line == aline && isactive) c=6;	//cervena
		else
		if (line == pline) c=2;	//zluta
		else
		if (line>=len) c=1;		//seda 
		else
		if ((line & 0x07) == 0) c=5;	//modra
		else
			c=0;				//bila

		if (!g_prove && g_activepart==PARTTRACKS && line<len && c==6)
			TextXYCol(s,x,y,colac[acu]);
		else
			TextXY(s,x,y,c);
	}

	return 1;
}

BOOL CTracks::SetNoteInstrVol(int note,int instr,int vol,int track,int line)
{
	//if (note>NOTESNUM || track<0 || track>=TRACKSNUM || line>=m_track[track].len) return 0;
	if (note>=NOTESNUM || line>=m_track[track].len) return 0;
	if (note==-1)
	{
		instr=vol=-1;
	}
	m_track[track].note[line]=note;
	m_track[track].instr[line]=instr;
	if (g_respectvolume)
	{
		//volume prepisuje jen je-li prazdne nebo chce-li ho zrusit (-1)
		if (m_track[track].volume[line]<0 || vol<0) 
				m_track[track].volume[line]=vol;
	}
	else
		m_track[track].volume[line]=vol;	//vzdycky
	return 1;	
}

BOOL CTracks::SetInstr(int instr,int track,int line)
{
	if (line>=m_track[track].len) return 0;
	m_track[track].instr[line]=instr;
	return 1;
}

BOOL CTracks::SetVol(int vol,int track,int line)
{
	if (line>=m_track[track].len) return 0;
	m_track[track].volume[line]=vol;
	return 1;
}

BOOL CTracks::SetSpeed(int speed,int track,int line)
{
	if (line>=m_track[track].len) return 0;
	m_track[track].speed[line]=speed;
	return 1;
}

BOOL CTracks::SetEnd(int track, int line)
{
	if (track<0 || track>=TRACKSNUM) return 0;
	m_track[track].len= (line>0 && m_track[track].len!=line)? line : m_maxtracklen;
	if (m_track[track].go>=m_track[track].len) m_track[track].go=-1;
	return 1;
}

int CTracks::GetLastLine(int track)
{
	return (track>=0 && track<TRACKSNUM)? m_track[track].len-1 : -1;
}

BOOL CTracks::SetGo(int track, int line)
{
	if (track<0 || track>=TRACKSNUM) return 0;
	if (line>=m_track[track].len) return 0;
	m_track[track].go= ( m_track[track].go == line)? -1: line;
	return 1;
}

int CTracks::GetGoLine(int track)
{
	return (track>=0)? m_track[track].go : -1;
}

BOOL CTracks::InsertLine(int track, int line)
{
	if (track<0 || track>=TRACKSNUM) return 0;
	TTrack& t=m_track[track];
	if (t.len<0) return 0;
	for(int i=t.len-2; i>=line; i--)
	{
		t.note[i+1]=t.note[i];
		t.instr[i+1]=t.instr[i];
		t.volume[i+1]=t.volume[i];
		t.speed[i+1]=t.speed[i];
	}
	t.note[line]=t.instr[line]=t.volume[line]=t.speed[line]=-1;
	return 1;
}

BOOL CTracks::DeleteLine(int track, int line)
{
	if (track<0 || track>=TRACKSNUM) return 0;
	TTrack& t=m_track[track];
	if (t.len<0) return 0;
	for(int i=line; i<t.len-1; i++)
	{
		t.note[i]=t.note[i+1];
		t.instr[i]=t.instr[i+1];
		t.volume[i]=t.volume[i+1];
		t.speed[i]=t.speed[i+1];
	}
	line = t.len-1;
	t.note[line]=t.instr[line]=t.volume[line]=t.speed[line]=-1;
	return 1;
}

BOOL CTracks::CalculateNoEmpty(int track)
{
	//proveri zda je track neprazdny
	TTrack& t = m_track[track];
	if (t.len != m_maxtracklen)	//ma nejakou jinou delku nez maximalni
		return 1;				//takze je neprazdny
	else
	{
		for(int i=0; i<t.len; i++)
		{
			if (	t.note[i]>=0			//nejaka nota, hlasitost nebo speed?
				||	t.volume[i]>=0
				||	t.speed[i]>=0 )
			{
				return 1;	//takze je neprazdny
			}
		}
	}
	return 0;	//je prazdny
}

//----------------------------------------------

CSong* g_song;
void CALLBACK G_TimerRoutine(UINT, UINT, DWORD, DWORD, DWORD)
{
	g_song->TimerRoutine();
}


CSong::CSong()
{
	ClearSong(8);	//defaultne je 8 tracku stereo

	//spusteni Timeru
	g_timerroutineprocessed=0;
	g_song = this;
	m_timer = timeSetEvent(10, 0, G_TimerRoutine,(ULONG) (NULL), TIME_PERIODIC);
}

CSong::~CSong()
{
	if (m_timer) timeKillEvent(m_timer);
}

BOOL CSong::ClearSong(int numoftracks)
{
	g_tracks4_8 = numoftracks;	//skladba pro 4/8 generatory
	g_rmtroutine = 1;			//zapnuto provadeni RMT rutiny
	g_prove=0;
	g_respectvolume=0;
	PlayPressedTonesInit();

	//	
	m_50s=0;
	m_play=0;
	m_followplay=1;
	m_mainspeed=m_speed=m_speeda=16;
	m_instrspeed=1;
	m_instrspeeda=0;
	//
	m_songplayline = m_songactiveline = 0;
	m_trackactiveline = m_trackplayline = 0;
	m_trackactivecol = m_trackactivecur = 0;
	m_activeinstr = 0;
	m_octave = 0;
	m_volume = 15;
	//
	m_infoact=0;

	strnset(m_songname,' ',SONGNAMEMAXLEN);
	strcpy(m_songname,"Noname song");
	m_songname[strlen(m_songname)] = ' ';
	m_songname[SONGNAMEMAXLEN]=0;

	m_songnamecur=0;
	//
	m_filename = "";
	m_filetype = 0;	//zadny

	for(int i=0; i<SONGLEN; i++)
	{
		for(int j=0; j<SONGTRACKS; j++)
		{
			m_song[i][j]=-1;	//TRACK --
		}
		m_songgo[i]=-1;		//neni GO
	}

	//prazdne clipboardy
	g_trackcl.Init(this);
	g_trackcl.Empty();
	//
	m_instrclipboard.act = -1;
	m_songgoclipboard = -2;				//podle -2 pozna ze je prazdny

	//a smaze vsechny tracky i instrumenty
	m_tracks.InitTracks();
	m_instrs.InitInstruments();


	return 1;
}

int CSong::SongToAta(unsigned char* dest, int max, int adr)
{
	int j;
	int apos=0,len=0,go=-1;;
	for(int sline=0; sline<SONGLEN; sline++)
	{
		apos=sline*g_tracks4_8;
		if (apos>=max) return 0;		//kdyby mel prelezt buffer

		if ( (go=m_songgo[sline])>=0)
		{
			//je tam go radek
			dest[apos]= 254;		//go povel
			dest[apos+1] = go;		//cislo kam skace
			WORD goadr = adr + (go*g_tracks4_8);
			dest[apos+2] = goadr & 0xff;	//dolni byte
			dest[apos+3] = (goadr>>8);		//horni byte
			if (g_tracks4_8>4)
			{
				for(int j=4; j<g_tracks4_8; j++) dest[apos+j]=255; //pro poradek
			}
			len = sline*g_tracks4_8 +4; //toto je prozatim konec (goto ma 4 byty i pro 8 tracku)
		}
		else
		{
			//jsou tam cisla tracku
			for(int i=0; i<g_tracks4_8; i++)
			{
				j = m_song[sline][i];
				if (j>=0 && j<TRACKSNUM) 
				{ 
					dest[apos+i]=j;
					len = (sline+1) * g_tracks4_8;		//toto je prozatim konec
				}
				else
					dest[apos+i]=255; //--
			}
		}
	}
	return len;
}

BOOL CSong::AtaToSong(unsigned char* sour, int len)
{
	int i=0;
	int col=0,line=0;
	unsigned char b;
	while(i<len)
	{
		b=sour[i];
		if (b>=0 && b<TRACKSNUM)
		{
			m_song[line][col]=b;
		}
		else
		if (b==254 && col==0)		//go povel pouze v 0.tracku
		{
			m_songgo[line]=sour[i+1];
			i+= g_tracks4_8;
			if (i>=len)	return 1;		//konci to goto radkem
			line++;
			if (line>=SONGLEN) return 1;
			continue;
		}
		else
			m_song[line][col]=-1;

		col++;
		if (col>=g_tracks4_8)
		{
			line++;
			if (line>=SONGLEN) return 1;	//aby nahodou nepretekl
			col=0;
		}
		i++;
	}
	return 1;
}


void CSong::SetRMTTitle()
{
	char bf[256],bf2[256];
	CString s;
	LoadString(AfxGetApp()->m_hInstance,IDS_RMTVERSION,bf,255);
	LoadString(AfxGetApp()->m_hInstance,IDS_RMTAUTHOR,bf2,255);
	s.Format("%s, %s",bf,bf2);
	AfxGetApp()->GetMainWnd()->SetWindowText(s);
}

void CSong::FileOpen()
{
	//zastavi hudbu
	Stop();


	CFileDialog fid(TRUE, 
					NULL,
					NULL,
					OFN_HIDEREADONLY,
					"RMT song files (*.rmt)|*.rmt|RMW song work files (*.rmw)|*.rmw||");
	fid.m_ofn.lpstrTitle = "Load song file";
	
	//jestli neda ok, tak konec
	if ( fid.DoModal() == IDOK )
	{
		Stop();

		CString fn;
		fn = fid.GetPathName();

		int type = fid.m_ofn.nFilterIndex;
		if (type<1 || type>2) return;

		ifstream in(fn,ios::binary);
		if (!in)
		{
			MessageBox(0,"Can't open this file: " +fn,"Open error",MB_ICONERROR);
			return;
		}

		//vymaze nynejsi song
		ClearSong(g_tracks4_8);

		switch (type)
		{
		case 1: //prvni volba v Dialogu (RMT)
			Import(in,IOTYPE_RMT);
			m_filetype = IOTYPE_RMT;
			//g_tracks4_8 = 4;		//hack!!!!!!!! konverze na mono ;-)
			break;
		case 2: //druha volba v Dialogu (RMW)
			Load(in);
			m_filetype = IOTYPE_RMW;
			break;
		}

		in.close();
		m_filename = fn;
		
		//init speedu
		m_speed = m_mainspeed;

		//nazev do okna
		AfxGetApp()->GetMainWnd()->SetWindowText(m_filename);

		g_screenupdate = 1;
	}
}

void CSong::FileSave()
{
	//zastavi hudbu
	Stop();

	
	if (m_filename=="" || m_filetype==0) 
	{
		FileSaveAs();
		return;
	}

	if (m_filetype==IOTYPE_RMT && !TestBeforeFileSave())
	{
		MessageBox(0,"Warning!\nNo data has been saved!","Warning",MB_ICONEXCLAMATION);
		AfxGetApp()->GetMainWnd()->SetWindowText(m_filename + " [Unsaved!]");
		return;
	}
	
	ofstream out(m_filename,ios::binary);
	if (!out)
	{
		MessageBox(0,"Can't create this file","Write error",MB_ICONERROR);
		return;
	}

	int r;
	switch (m_filetype)
	{
	case IOTYPE_RMT: //RMT
		r = Export(out,IOTYPE_RMT);
		if (!r)
		{
			MessageBox(0,"RMT save aborted.\nWarning!\nDestination file is empty!","Export aborted",MB_ICONEXCLAMATION);
		}
		break;
	case IOTYPE_RMW: //RMW
		Save(out);
		break;
	}

	AfxGetApp()->GetMainWnd()->SetWindowText(m_filename);

	out.close();
}

void CSong::FileSaveAs()
{
	//zastavi hudbu
	Stop();
	
	CFileDialog fod(FALSE, 
					NULL,
					NULL,
					OFN_HIDEREADONLY,
					"RMT song file (*.rmt)|*.rmt|RMW song work file (*.rmw)|*.rmw||");
	fod.m_ofn.lpstrTitle = "Save song as...";
	//if (m_filename!="") fod.m_ofn.
	if (m_filetype) fod.m_ofn.nFilterIndex = m_filetype;	//predchysta typ podle posledne ulozeneho
	
	//jestli neda ok, tak konec
	if ( fod.DoModal() == IDOK )
	{
		int type = fod.m_ofn.nFilterIndex;

		if (type<1 || type>2) return;

		m_filename = fod.GetPathName();
		const char* ext[]={".rmt",".rmw"};
		if (m_filename.Right(4)!=ext[type-1]) m_filename += ext[type-1];
		
		switch (type)
		{
		case 1: //prvni volba
			m_filetype = IOTYPE_RMT;
			break;
		case 2: //druha volba
			m_filetype = IOTYPE_RMW;
			break;
		default:
			return;
		}


		FileSave();
	}
}

void CSong::FileNew()
{
	//zastavi hudbu
	Stop();

	//
	CFileNewDlg dlg;
	if (dlg.DoModal() == IDOK )
	{
		//jestlize je nazev souboru v okne, smaze ho
		if (m_filename!="") 
		{
			SetRMTTitle();	
		}

		m_tracks.m_maxtracklen = dlg.m_maxtracklen;
		int i = dlg.m_combotype;
		g_tracks4_8 = (i==0)? 4 : 8;
		ClearSong(g_tracks4_8);

		//automaticky predchystany
		//nulty radek songu
		for(i=0; i<g_tracks4_8; i++) m_song[0][i] = i;
		m_songgo[1] = 0;	//a goto v prvnim radku songu

		g_screenupdate = 1;
	}
}

void CSong::FileExportAs()
{
	//zastavi hudbu
	Stop();

	CFileDialog fod(FALSE, 
					NULL,
					NULL,
					OFN_HIDEREADONLY | OFN_OVERWRITEPROMPT,
					"RMT stripped song file (*.rmt)|*.rmt|SAP file (*.sap)|*.sap|XEX Atari executable msx (*.xex)|*.xex||");
	fod.m_ofn.lpstrTitle = "Export song as...";
	
	//jestli neda ok, tak konec
	if ( fod.DoModal() == IDOK )
	{
		if (!TestBeforeFileSave())
		{
			MessageBox(0,"Warning!\nNo data has been saved!","Warning",MB_ICONEXCLAMATION);
			return;
		}

		CString fn;
		fn = fod.GetPathName();
		int type = fod.m_ofn.nFilterIndex;
		if (type<1 || type>3) return;
		const char* ext[]={".rmt",".sap",".xex"};

		if (fn.Right(4)!=ext[type-1]) fn += ext[type-1];

		ofstream out(fn,ios::binary);
		if (!out)
		{
			MessageBox(0,"Can't create this file: " +fn,"Write error",MB_ICONERROR);
			return;
		}

		int r;
		switch (type)
		{
		case 1: //RMTOPT
			r = Export(out,IOTYPE_RMTSTRIPPED);
			break;
		case 2: //SAP
			r = Export(out,IOTYPE_SAP);
			break;
		case 3: //XEX
			//MessageBox(0,"Not implemeted yet.","Sorry",MB_ICONINFORMATION);
			r = Export(out,IOTYPE_XEX);
			//Export(out,IOTYPE_XEX);
			break;
		}

		if (!r)
		{
			MessageBox(0,"Export aborted.\nWarning: Export file is empty!","Export aborted",MB_ICONEXCLAMATION);
		}

		out.close();
	}
}

void CSong::FileInstrumentSave()
{
	//zastavi hudbu
	Stop();

	
	CFileDialog fod(FALSE, 
					NULL,
					NULL,
					OFN_HIDEREADONLY | OFN_OVERWRITEPROMPT,
					"RMT instrument file (*.rti)|*.rti||");
	fod.m_ofn.lpstrTitle = "Save RMT instrument file";
	
	//jestli neda ok, tak konec
	if ( fod.DoModal() == IDOK )
	{
		CString fn;
		fn = fod.GetPathName();
		if (fn.Right(4)!=".rti") fn += ".rti";
		ofstream ou(fn,ios::binary);
		if (!ou)
		{
			MessageBox(0,"Can't create this file: " +fn,"Write error",MB_ICONERROR);
			return;
		}

		m_instrs.SaveInstrument(m_activeinstr,ou,IOINSTR_RTI);

		ou.close();
	}
}

void CSong::FileInstrumentLoad()
{
	//zastavi hudbu
	Stop();

	CFileDialog fid(TRUE, 
					NULL,
					NULL,
					OFN_HIDEREADONLY,
					"RMT instrument files (*.rti)|*.rti||");
	fid.m_ofn.lpstrTitle = "Load RMT instrument file";
	
	//jestli neda ok, tak konec
	if ( fid.DoModal() == IDOK )
	{
		CString fn;
		fn = fid.GetPathName();
		ifstream in(fn,ios::binary);
		if (!in)
		{
			MessageBox(0,"Can't open this file: " +fn,"Open error",MB_ICONERROR);
			return;
		}

		int r = m_instrs.LoadInstrument(m_activeinstr,in,IOINSTR_RTI);
		in.close();
		g_screenupdate = 1;

		if (!r)
		{
			MessageBox(0,"It isn't RTI format (standard version 0)","Data error",MB_ICONERROR);
			return;
		}
	}
}



#define RMWMAINPARAMSCOUNT		19		//celkove se v RMP saveuje 19 parametru
#define DEFINE_MAINPARAMS int* mainparams[RMWMAINPARAMSCOUNT]= {		\
	&g_tracks4_8,												\
	(int*)&m_speed,(int*)&m_mainspeed,(int*)&m_instrspeed,		\
	(int*)&m_songactiveline,(int*)&m_songplayline,				\
	(int*)&m_trackactiveline,(int*)&m_trackplayline,			\
	(int*)&g_activepart,(int*)&g_active_ti,						\
	(int*)&g_prove,(int*)&g_respectvolume,						\
	&m_trackactivecol,&m_trackactivecur,						\
	&m_activeinstr,&m_volume,&m_octave,							\
	&m_infoact,&m_songnamecur									\
}

int CSong::Save(ofstream& ou)
{
	ou.write((unsigned char*)m_songname,sizeof(m_songname));
	//
	DEFINE_MAINPARAMS;

	int p = RMWMAINPARAMSCOUNT; //pocet ukladanych parametru
	ou.write((unsigned char*) &p,sizeof(p));		//zapise pocet main parametru
	for(int i=0; i<p; i++)
		ou.write((unsigned char*) mainparams[i],sizeof(mainparams[0]));
	//

	//zapise komplet song a songgo
	ou.write((unsigned char*)m_song,sizeof(m_song));
	ou.write((unsigned char*)m_songgo,sizeof(m_songgo));

	m_instrs.SaveAll(ou);
	m_tracks.SaveAll(ou);
	return 1;
}


int CSong::Load(ifstream& in)
{
	ClearSong(8);	//je predchystany na 8
	in.read((unsigned char*)m_songname,sizeof(m_songname));
	//
	DEFINE_MAINPARAMS;
	int p=0;
	in.read((unsigned char*)&p,sizeof(p));			//precte si pocet main parametru
	for(int i=0; i<p; i++)
		in.read((unsigned char*) mainparams[i],sizeof(mainparams[0]));
	//

	//precte komplet song a songgo
	in.read((unsigned char*)m_song,sizeof(m_song));
	in.read((unsigned char*)m_songgo,sizeof(m_songgo));

	m_instrs.LoadAll(in);
	m_tracks.LoadAll(in);

	return 1;
}

int CSong::TestBeforeFileSave()
{
	//provadi se u Exportu (vsechno krom RMW) jeste pred tim, nez se provede prepsani ciloveho souboru
	//takze pokud vrati 0, export se ukonci a k prepsani souboru nedojde.

	//Zkusi vytvorit modul
	unsigned char mem[65536];
	int adr_module=0x4000;
	BYTE instrsaved[INSTRSNUM];
	BYTE tracksaved[TRACKSNUM];
	int maxadr;
	
	//zkusi udelat jen tak naprazdno RMT modul
	maxadr = MakeModule(mem,adr_module,IOTYPE_RMT,instrsaved,tracksaved);
	if (maxadr<0) return 0;	//pokud se nepodarilo vytvorit modul

	//A ted se bude hlidat, zda je song ukoncen GOTO radkem
	//a zda tam neni GOTO na GOTO radek.
	CString errmsg,wrnmsg,s;
	int trx[SONGLEN];
	int i,j,r,go,last=-1,tr=0,empty=0;

	for(i=0; i<SONGLEN; i++)
	{
		if (m_songgo[i]>=0) 
		{
			trx[i]=2;
			last=i;
		}
		else
		{
			trx[i]=0;
			for(j=0; j<g_tracks4_8; j++)
			{
				if (m_song[i][j]>=0 && m_song[i][j]<TRACKSNUM)
				{
					trx[i]=1;
					last=i; //tracky
					tr++;
					break;
				}
			}
		}
	}

	//if (tr<1) wrnmsg += "Warning: No tracks are placed into song.\n";

	if (last<0)
	{
		errmsg += "Error: Song is empty.\n";
	}

	for(i=0; i<=last; i++)
	{
		if (m_songgo[i]>=0)
		{
			//je tam GO radek
			go = m_songgo[i];	//kam skace
			if (go>last)
			{
				s.Format("Error: Song line [%02X]: Go to line over last used song line.\n",i);
				errmsg += s;
			}
			if (m_songgo[go]>=0)
			{
				s.Format("Error: Song line [%02X]: Recursive \"go to line\" to \"go to line\".\n",i);
				errmsg += s;
			}
			if (i>0 && m_songgo[i-1]>=0)
			{
				s.Format("Warning: Song line [%02X]: More \"go to line\" on subsequent lines.\n",i);
				wrnmsg += s;
			}
			goto TestTooManyEmptyLines;
		}
		else
		{
			//jsou tam tracky nebo volno
			if (trx[i]==0) 
				empty++; 
			else 
			{
TestTooManyEmptyLines:
				if (empty>1)
				{
					s.Format("Warning: Song lines [%02X-%02X]: Too many empty song lines (%i) waste memory.\n",i-empty,i-1,empty);
					wrnmsg += s;
				}
				empty=0;
			}
		}
	}

	if (trx[last]==1)
	{
		s.Format("Error: Song line [%02X]: Unexpected end of song. You have to use \"go to line\" at the foot of song.\n",last+1);
		errmsg += s;
	}

	if (errmsg!="" || wrnmsg!="")
	{
		if (errmsg=="")
		{
			//jsou tam jen warningy
			wrnmsg += "\nIgnore this warning(s) and save anyway?";
			r = MessageBox(0,wrnmsg,"Warnings",MB_YESNO | MB_ICONQUESTION);
			if (r==IDYES) return 1;
			return 0;
		}
		//jsou tam i errory
		MessageBox(0,errmsg + wrnmsg,"Errors",MB_ICONERROR);
		return 0;
	}

	return 1;	
}

//---

#define EOL "\x0d\x0a"

int CSong::Export(ofstream& ou,int iotype)
{
	unsigned char mem[65536];

	int adr_init= (g_tracks4_8==4)? 0x3998 : 0x3a98;	//u sap4 je kratsi rutina nez u sap8
	int adr_player=0x3403;
	int adr_module=0x4000;
	int adr_msxrunadr=0x3e00;
	int adr_msxvideo =0x3f00;
	int adr_msxcolor =adr_msxvideo+160;
	int maxadr=adr_module;
	int i;

	WORD adrfrom,adrto;
	BYTE instrsaved[INSTRSNUM];
	BYTE tracksaved[TRACKSNUM];

	BOOL head_ffff=1;		//hlavicka FF FF na zacatku souboru

	//vytvori modul
	memset(mem,0,65536);
	maxadr = MakeModule(mem,adr_module,iotype,instrsaved,tracksaved);
	if (maxadr<0) return 0;	//pokud se nepodarilo vytvorit modul

	CString s;
	switch(iotype)
	{
	case IOTYPE_RMT:
		break;

	case IOTYPE_RMTSTRIPPED:
		{
			//Dialog pro urceni adresy RMT modulu v pameti
			CExpRMTDlg dlg;
			dlg.m_adr = adr_module;
			dlg.m_len = maxadr-adr_module;
			//
			if (dlg.DoModal() != IDOK)
			{
				return 0;	
			}

			adr_module = dlg.m_adr;
			//znovu vygeneruje modul podle zadane adresy "adr"
			memset(mem,0,65536);
			maxadr = MakeModule(mem,adr_module,iotype,instrsaved,tracksaved);
			if (maxadr<0) return 0; //nepodarilo-li se vytvorit modul
			
		}
		break;

	case IOTYPE_SAP:
		{
			CExpSAPDlg dlg;
			//
			s = m_songname;
			s.TrimRight();		//oreze mezery za nazvem
			s.Replace('"','\''); //nahradi uvozovky apostrofem
			dlg.m_name = s;
			//
			dlg.m_author = "???";
			//
			CTime time = CTime::GetCurrentTime();
			dlg.m_date = time.Format("%d/%m/%Y");
			//
			if (dlg.DoModal() != IDOK)
			{
				return 0;	
			}
			//
			s.Format("%srmt_sap%i.sys",g_prgpath,g_tracks4_8);	//../rmt_sap4.sys nebo /rmt_sap8.sys
			int r = LoadBinaryFile((char*)(LPCSTR)s,mem,adrfrom,adrto);
			if (!r)
			{
				MessageBox(0,"Can't open RMT SAP system routines.","Export aborted",MB_ICONERROR);
				return 0;	
			}
			ou << "SAP" << EOL;
			s = dlg.m_name;
			s.TrimRight();		//oreze mezery za nazvem
			s.Replace('"','\''); //nahradi uvozovky apostrofem
			ou << "NAME \"" << s << "\"" << EOL;
			//
			s = dlg.m_author;
			s.TrimRight();		//oreze mezery za nazvem
			s.Replace('"','\''); //nahradi uvozovky apostrofem
			ou << "AUTHOR \"" << s << "\"" << EOL;
			//
			s = dlg.m_date;
			s.TrimRight();		//oreze mezery za nazvem
			s.Replace('"','\''); //nahradi uvozovky apostrofem
			ou << "DATE \"" << s << "\"" << EOL;
			//
			ou << "TYPE B" << EOL;
			s.Format("INIT %04X", adr_init);
			ou << s << EOL;
			s.Format("PLAYER %04X", adr_player);
			ou << s << EOL;
			if (m_instrspeed==2)
			{	//zrychlene instrumenty
				ou << "FASTPLAY 156" << EOL;
			}
			if (g_tracks4_8>4)
			{	//stereo modul
				ou << "STEREO" << EOL;
			}
			SaveBinaryBlock(ou,mem,adrfrom,adrto,1);
			head_ffff=0;
		}
		break;

	case IOTYPE_XEX:
		{
			CExpMSXDlg dlg;
			s = m_songname;
			s.TrimRight();
			CTime time = CTime::GetCurrentTime();

			dlg.m_txt = s + "\x0d\x0a" +"by ???" +"\x0d\x0a" + time.Format("%d/%m/%Y");
			if (g_tracks4_8>4)
			{
				dlg.m_txt += "\x0d\x0a";
				dlg.m_txt +="STEREO";
			}
			dlg.m_meter = 1;

			//
			if (dlg.DoModal() != IDOK)
			{
				return 0;	
			}
		
			//
			s.Format("%srmt_sap%i.sys",g_prgpath,g_tracks4_8);	//../rmt_sap4.sys nebo /rmt_sap8.sys
			int r = LoadBinaryFile((char*)(LPCSTR)s,mem,adrfrom,adrto);
			if (!r)
			{
				MessageBox(0,"Can't open RMT SAP system routines.","Export aborted",MB_ICONERROR);
				return 0;	
			}
			SaveBinaryBlock(ou,mem,adrfrom,adrto,1);
			head_ffff=0;

			r = LoadBinaryFile((char*)((LPCSTR)(g_prgpath+"rmt_msx.sys")),mem,adrfrom,adrto); //rmt_msx.sys
			if (!r)
			{
				MessageBox(0,"Can't open RMT MSX system routines.","Export aborted",MB_ICONERROR);
				return 0;	
			}
			SaveBinaryBlock(ou,mem,adrfrom,adrto,0);

			memset(mem+adr_msxvideo,32,40*4);
			int p=0,q=0;
			char a;
			for(i=0; i<dlg.m_txt.GetLength(); i++)
			{
				a = dlg.m_txt.GetAt(i);
				if (a=='\n') { p+=40; q=0; }
				else
				{
					mem[adr_msxvideo+p+q]=a;
					q++;
				}
				if (p+q>=4*40) break;
			}
			StrToAtariVideo((char*)mem+adr_msxvideo,160);
			mem[adr_msxcolor]= (dlg.m_meter)? 6 : 0;
			SaveBinaryBlock(ou,mem,adr_msxvideo,adr_msxvideo+40*4-1+1,0);	//video+color

			//run addr se prida az za modul jako posledni blok
		}
		break;

	default:
		return 0;
	}

	// ULOZI VLASTNI RMT MODUL
	SaveBinaryBlock(ou,mem,adr_module,maxadr-1,head_ffff);


	//DODATECNA DATA u nekterych typu
	switch(iotype)
	{
	case IOTYPE_RMT:
		{
			//pro RMT prida dalsi blok s nazvem songu a instrumentuuu
			//jednotlive nazvy jsou zprava orezane o mezery a ukoncene nulou
			int adrsongname = maxadr;
			s = m_songname;
			s.TrimRight();
			int lens = s.GetLength()+1;	//vcetne 0 za stringem
			strncpy((char*)(mem+adrsongname),(LPCSTR)s,lens);
			int adrinstrnames = adrsongname+lens;
			for(i=0; i<INSTRSNUM; i++)
			{
				if (instrsaved[i])
				{
					s = m_instrs.GetName(i);
					s.TrimRight();
					lens = s.GetLength()+1;	//vcetne 0 za stringem
					strncpy((char*)(mem+adrinstrnames),s,lens);
					adrinstrnames+=lens;
				}
			}
			//a ted ten 2.blok ulozi
			SaveBinaryBlock(ou,mem,adrsongname,adrinstrnames-1,0);
		}
		break;

	case IOTYPE_XEX:
		{
			//prida run addr na konec
			mem[0x2e0]=adr_msxrunadr & 0xff;
			mem[0x2e1]=adr_msxrunadr >> 8;	//run adr.
			SaveBinaryBlock(ou,mem,0x2e0,0x2e1,0);	//zapise blok s run adresou
		}
		break;
	}
	//
	return 1;
}

int CSong::Import(ifstream& in,int iotype)
{
	unsigned char mem[65536];
	memset(mem,0,65536);
	WORD bfrom,bto;

	BYTE instrloaded[INSTRSNUM];
	BYTE trackloaded[TRACKSNUM];

	int len,i,j,k;
	
	len = LoadBinaryBlock(in,mem,bfrom,bto);

	if (len>0)
	{
		int r = DecodeModule(mem,bfrom,bto+1,iotype,instrloaded,trackloaded);
		if (!r)
		{
			MessageBox(0,"Bad RMT data format","Open error",MB_ICONERROR);
			return 0;
		}
	}
	else
	{
		MessageBox(0,"Corrupted file or unsupported format version.","Open error",MB_ICONERROR);
		return 0;	//v prvnim bloku nenacetl zadna data
	}

	if (iotype == IOTYPE_RMT) //load RMT (bude chtit nacitat druhy blok se jmeny)
	{
		len = LoadBinaryBlock(in,mem,bfrom,bto);
		if (len<1)
		{
			MessageBox(0,"It is probably some stripped RMT song file.\nName of song and names of instruments are missing.","Warning",MB_ICONINFORMATION);
			return 1;
		}

		char a;
		for(j=0; j<SONGNAMEMAXLEN && (a=mem[bfrom+j]); j++)
			m_songname[j]=a;
	
		for(k=j;k<SONGNAMEMAXLEN; k++) m_songname[k]=' '; //doplni mezery

		int adrinames=bfrom+j+1; //+1 to je ta nula za nazvem
		for(i=0; i<INSTRSNUM; i++)
		{
			if (instrloaded[i])
			{
				for(j=0; j<INSTRNAMEMAXLEN && (a=mem[adrinames+j]); j++)
					m_instrs.m_instr[i].name[j] = a;

				for(k=j; k<INSTRNAMEMAXLEN; k++) m_instrs.m_instr[i].name[k]=' '; //doplni mezery
				adrinames += j+1; //+1 to je nula za nazvem
			}
		}
	}
	return 1;
}

int CSong::MakeModule(unsigned char* mem,int adr,int iotype,BYTE *instrsaved,BYTE* tracksaved)
{
	//vraci maxadr (ukazuje na prvni volnou adresu za modulem)
	//a nastavuje pole instrsaved a tracksaved

	BYTE* instrsave = instrsaved;
	BYTE* tracksave = tracksaved;
	memset(instrsave,0,INSTRSNUM);	//init
	memset(tracksave,0,TRACKSNUM); //init

	strncpy((char*)(mem+adr),"RMT",3);
	mem[adr+3]=g_tracks4_8+'0';	//4 nebo 8
	mem[adr+4]=m_tracks.m_maxtracklen & 0xff;
	mem[adr+5]=m_mainspeed & 0xff;
	mem[adr+6]=m_instrspeed;		//instr speed 1-2
	mem[adr+7]=0;			//reserved

	//v RMT se budou ukladat vsechny neprazdne tracky a neprazdne instrumenty
	//v ostatnich pouze neprazdne pouzite tracky a v nich pouzite instrumenty
	int i,j,tr;

	//vsechny tracky pouzite v songu
	for(i=0; i<SONGLEN; i++)
	{
		if (m_songgo[i]<0)
		{
			for(int j=0; j<g_tracks4_8; j++)
			{
				tr = m_song[i][j];
				if (tr>=0 && tr<TRACKSNUM) tracksave[tr] =TF_USED;

			}
		}
	}

	if (iotype==IOTYPE_RMT)
	{
		//do RMT se krom pouzitych pridavaji i vsechny neprazdne tracky
		//vsechny neprazdne tracky
		for(i=0; i<TRACKSNUM; i++)
		{
			if (m_tracks.CalculateNoEmpty(i)) tracksave[i] |= TF_NOEMPTY;
		}
	}

	//vsechny instrumenty v trackach, ktere se budou ukladat
	for(i=0; i<TRACKSNUM; i++)
	{
		if (tracksave[i]>0)
		{
			TTrack& tr = *m_tracks.GetTrack(i);
			for(j=0; j<tr.len; j++)
			{
				int ins = tr.instr[j];
				if (ins>=0 && ins<INSTRSNUM) instrsave[ins] = IF_USED;
			}
		}
	}

	if (iotype==IOTYPE_RMT)
	{
		//do RMT se krom instrumentu pouzitych v trackach co jsou v songu ukladaji i vsechny neprazdne instrumenty
		for(i=0; i<INSTRSNUM; i++)
		{
			if (m_instrs.CalculateNoEmpty(i)) instrsave[i] |= IF_NOEMPTY;
		}
	}

	//---

	int numtracks=0;
	for (i=TRACKSNUM-1; i>=0; i--)
	{
		if (tracksave[i]>0) { numtracks=i+1; break; }
	}

	int numinstrs=0;
	for (i=INSTRSNUM-1; i>=0; i--)
	{
		if (instrsave[i]>0) { numinstrs=i+1; break; }
	}

	//a ted ma ukladat:
	//instrumenty numinstr
	//tracky numtracks
	//song songlines

	int adrpinstruments = adr + 16;
	int adrptrackslbs = adrpinstruments + numinstrs*2;
	int adrptrackshbs = adrptrackslbs + numtracks;

	int adrinstrdata = adrptrackshbs + numtracks; //za tabulkou hbytuuu trackuuu
	//uklada data instrumentu a zapisuje jejich zacatky do table
	for(i=0; i<numinstrs; i++)
	{
		if (instrsave[i])
		{
			int leninstr = m_instrs.InstrToAta(i,mem+adrinstrdata,MAXATAINSTRLEN);
			mem[adrpinstruments+i*2] = adrinstrdata & 0xff;	//dbyte
			mem[adrpinstruments+i*2+1] = adrinstrdata >> 8;	//hbyte
			adrinstrdata +=leninstr;
		}
		else
		{
			mem[adrpinstruments+i*2] = mem[adrpinstruments+i*2+1] = 0;
		}
	}

	int adrtrackdata = adrinstrdata;	//za daty instrumentuuu
	//uklada data tracku a zapisuje jejich zacatky do table
	for(i=0; i<numtracks; i++)
	{
		if (tracksave[i])
		{
			int lentrack = m_tracks.TrackToAta(i,mem+adrtrackdata,MAXATATRACKLEN);
			if (lentrack<1)
			{	//nelze ulozit do RMT
				CString msg;
				msg.Format("Fatal error in track %02X.\n\nThis track contains too many events (notes and speed commands),\nthat's why it can't be coded to RMT internal code format.",i);
				MessageBox(0,msg,"Internal format problem.",MB_ICONERROR);
				return -1;
			}
			mem[adrptrackslbs+i] = adrtrackdata & 0xff;	//dbyte
			mem[adrptrackshbs+i] = adrtrackdata >> 8;	//hbyte
			adrtrackdata +=lentrack;
		}
		else
		{
			mem[adrptrackslbs+i] = mem[adrptrackshbs+i] = 0;
		}
	}

	int adrsong = adrtrackdata;		//za daty trackuuu

	//ulozi od adrsong data songu
	int lensong = SongToAta(mem+adrsong,g_tracks4_8*SONGLEN,adrsong);

	int endofmodule = adrsong+lensong;

	//zapise vypocitane pointery do hlavicky
	mem[adr+8] = adrpinstruments & 0xff;	//dbyte
	mem[adr+9] = adrpinstruments >> 8;		//hbyte
	//
	mem[adr+10] = adrptrackslbs & 0xff;		//dbyte
	mem[adr+11] = adrptrackslbs >> 8;		//hbyte
	mem[adr+12] = adrptrackshbs & 0xff;		//dbyte
	mem[adr+13] = adrptrackshbs >> 8;		//hbyte
	//
	mem[adr+14] = adrsong & 0xff;		//dbyte
	mem[adr+15] = adrsong >> 8;			//hbyte

	return endofmodule;
}

int CSong::DecodeModule(unsigned char* mem,int adrfrom,int adrend,int iotype,BYTE *instrloaded,BYTE* trackloaded)
{
	int adr=adrfrom;

	memset(instrloaded,0,INSTRSNUM);
	memset(trackloaded,0,TRACKSNUM);

	unsigned char b;
	int i,j;

	if (strncmp((char*)(mem+adr),"RMT",3)!=0) return 0; //neni tam RMT
	b = mem[adr+3];
	if (b!='4' && b!='8') return 0;	//neni to RMT4 nebo RMT8
	g_tracks4_8 = b & 0x0f;
	b = mem[adr+4];
	m_tracks.m_maxtracklen = (b>0)? b:256;	//0 => 256
	b = mem[adr+5];
	m_mainspeed = b;
	b = mem[adr+6];
	m_instrspeed = b;
	b = mem[adr+7];
	if (b!=0)	return 0;	//reserved byte neni 0


	//Ted uz je nastaveno m_tracks.m_maxtracklen na hodnotu podle hlavicky z RMT modulu, takze
	//musi znovu reinicializovat Tracky aby se jim vsem tato hodnota nastavila jako delka
	m_tracks.InitTracks();

	int adrpinstruments = mem[adr+ 8] + (mem[adr+ 9]<<8);
	int adrptrackslbs   = mem[adr+10] + (mem[adr+11]<<8);
	int adrptrackshbs   = mem[adr+12] + (mem[adr+13]<<8);
	int adrsong		    = mem[adr+14] + (mem[adr+15]<<8);

	int numinstrs = (adrptrackslbs-adrpinstruments)/2;
	int numtracks = (adrptrackshbs-adrptrackslbs);
	int lensong = adrend - adrsong;

	//dekodovani jednotlivych instrumentuuu
	for(i=0; i<numinstrs; i++)
	{
		int instrdata = mem[adrpinstruments+i*2] + (mem[adrpinstruments+i*2+1]<<8);
		if (instrdata==0) continue; //vynechane instrumenty maji ukazatel db,hb = 0
		//tenhle ma ukazatel nenulovy
		m_instrs.AtaToInstr(mem+instrdata,i);
		m_instrs.ModificationInstrument(i);	//zapise do Atari ram
		instrloaded[i]=1;
	}

	//dekodovani jednotlivych trackuuu
	for(i=0; i<numtracks; i++)
	{
		int track=i;
		int trackdata = mem[adrptrackslbs+i] + (mem[adrptrackshbs+i]<<8);
		if (trackdata==0) continue; //vynechane tracky maji ukazatel db,hb=0

		//konec tracku pozna podle adresy dalsiho tracku a u posledniho podle adresy songu,
		//ktery nasleduje za daty posledniho tracku
		int trackend=0;
		for(j=i; j<numtracks; j++)
		{
			trackend = (j+1==numtracks)? adrsong : mem[adrptrackslbs+j+1] + (mem[adrptrackshbs+j+1]<<8);
			if (trackend!=0) break;
			i++;	//aby pak pokracoval az od dalsiho a preskocil ten vynechany
		}
		int tracklen = trackend - trackdata;
		//
		m_tracks.AtaToTrack(mem+trackdata,tracklen,track);
		trackloaded[track]=1;
	}

	//dekodovani songu
	AtaToSong(mem+adrsong,lensong);

	return 1;
}

//---

BOOL CSong::PlayPressedTonesInit()
{
	for(int t=0; t<SONGTRACKS; t++)
		SetPlayPressedTonesTNIV(t,-1,-1,-1);
	return 1;
}

BOOL CSong::SetPlayPressedTonesSilence()
{
	for(int t=0; t<SONGTRACKS; t++)
		SetPlayPressedTonesTNIV(t,-1,-1,0);
	return 1;
}

BOOL CSong::PlayPressedTones()
{
	int t,n,i,v;
	for(t=0; t<SONGTRACKS; t++)
	{
		if ( (v=m_playptvolume[t])>=0) //volume se nastavuje jako posledni
		{
			n=m_playptnote[t];
			i=m_playptinstr[t];
			if (n>=0 && i>=0)
				Atari_SetTrack_NoteInstrVolume(t,n,i,v);
			else
				Atari_SetTrack_Volume(t,v);
			SetPlayPressedTonesTNIV(t,-1,-1,-1);
		}
	}
	return 1;
}


#define	SONG_X	66*8
#define SONG_Y	1*16


BOOL CSong::DrawSong()
{
	int line,i,j,k,y,t;
	char s[32],c;
	TextXY("SONG",SONG_X+8,SONG_Y);

	//tisk L1 .. L4 R1 .. R4 s cervenym aktualnim trackem
	k=SONG_X+6*8;
	s[0]='L';
	s[2]=0;
	for(i=0; i<4; i++,k+=24)
	{
		s[1]=i+49;	//znak 1-4
		TextXY(s,k,SONG_Y,(m_trackactivecol==i)? 6:0);
	}
	s[0]='R';
	for(i=4; i<g_tracks4_8; i++,k+=24)
	{
		s[1]=i+49-4;	//znak 1-4
		TextXY(s,k,SONG_Y,(m_trackactivecol==i)? 6:0);
	}

	y=SONG_Y+16;
	for(i=0; i<5; i++,y+=16)	//vypisuje 5 radku songu
	{
		line = m_songactiveline + i -2; 		//2 radky nad
		if (line<0 || line>255)
		{
			//ClearXY(SONG_X+16,y,27);		//smaze 27 pismen
			continue;
		}
		strcpy(s,"XX:");
		s[0]= CharH4(line);
		s[1]= CharL4(line);
		c = (line==m_songplayline)? 2:0;
		TextXY(s,SONG_X+16,y,c);

		if ((j=m_songgo[line])>=0)
		{
			//je tam GO radek
			s[0]=CharH4(j);
			s[1]=CharL4(j);
			s[2]=0;
			c = (line==m_songactiveline)? 6:0;
			TextXY("Go to line",SONG_X+16+32,y,c);
			if (line==m_songactiveline && !g_prove && g_activepart==PARTSONG) c=3;
			TextXY(s,SONG_X+16+32+11*8,y,c);
		}
		else
		{
			//jsou tam cisla tracku
			s[2]=0;
			for (j=0,k=32; j<g_tracks4_8; j++,k+=24)
			{
				if ( (t=m_song[line][j]) >=0 )
				{
					s[0]= CharH4(t);
					s[1]= CharL4(t);
				}
				else
				{
					s[0]=s[1]='-';	//--
				}
				if (line==m_songactiveline && j==m_trackactivecol)
					c= (!g_prove && g_activepart==PARTSONG)? 3:6;
				else
					c = (line==m_songplayline)? 2:0;
				TextXY(s,SONG_X+16+k,y,c);
			}
		}
	}
	TextXY("\x04\x05",SONG_X,SONG_Y+48,6);	//sipka
	return 1;
}

#define TRACKS_X 2*8
#define TRACKS_Y 8*16

BOOL CSong::DrawTracks()
{
	static char* tnames="L1L2L3L4R1R2R3R4";
	char s[16];
	int i,x,y,tr,line,c;
	int t;

	if (SongGetGo()>=0)		//je to GO radek, nebude tracky vykreslovat
	{
		sprintf(s,"Go to line %02X",SongGetGo());
		TextXY(s,TRACKS_X+40*8,TRACKS_Y+8*16);
		return 1;
	}

	//cisla vlevo
	y = TRACKS_Y+3*16;
	strcpy(s,"--");
	for(i=0; i<17; i++,y+=16)
	{
		line = m_trackactiveline + i - 8;		//8 lines shora
		if (line<0 || line>=m_tracks.m_maxtracklen)
		{
			//ClearXY(TRACKS_X,y,3);
			continue;
		}
		s[0]=CharH4(line);
		s[1]=CharL4(line);
		//if (line == m_trackactiveline) c=6;		//cervena
		//else
		if (line == m_trackplayline) c=2;		//zluta
		else
		if ((line & 0x07) == 0) c=5;	//modra
		else
			c=0;
		TextXY(s,TRACKS_X,y,c);
	}

	//tracky
	strcpy(s,"TRACK_XX ");
	x = TRACKS_X+5*8;
	for(i=0; i<g_tracks4_8; i++, x+=11*8)
	{
		s[6]=tnames[i*2];
		s[7]=tnames[i*2 +1];
		TextXY(s,x+8,TRACKS_Y);
		//track v aktualnim radku songu
		tr = m_song[m_songactiveline][i];
		//prehrava se?
		if ( m_song[m_songplayline][i] == tr ) t = m_trackplayline; else t = -1;
		m_tracks.DrawTrack(i,x,TRACKS_Y+16,tr,m_trackactiveline,t,(m_trackactivecol==i),m_trackactivecur);
	}


	//selektovany blok
	if (g_trackcl.IsBlockSelected())
	{
		x = TRACKS_X+6*8+ g_trackcl.m_selcol *11*8 -2;
		int xt = x + 10*8+4;
		y = TRACKS_Y+16*3;
		int bfro,bto;
		g_trackcl.GetFromTo(bfro,bto);

		int yf = bfro-m_trackactiveline+8;
		int yt = bto-m_trackactiveline+8+1;
		int p1=1,p2=1;
		if (yf<0)  { yf=0; p1=0; }
		if (yt>17) { yt=17; p2=0; }

		if (yf<17 && yt>0 
			&& g_trackcl.m_seltrack==SongGetActiveTrackInColumn(g_trackcl.m_selcol)
			&& g_trackcl.m_selsongline==SongGetActiveLine())
		{
			//obdelnik vymezujici selektnuty blok
			CPen redpen(PS_SOLID,1,RGB(255,255,255));
			CPen* origpen = g_mem_dc->SelectObject(&redpen);
			g_mem_dc->MoveTo(x,y+yf*16);
			g_mem_dc->LineTo(x,y+yt*16);
			g_mem_dc->MoveTo(xt,y+yf*16);
			g_mem_dc->LineTo(xt,y+yt*16);
			if (p1) { g_mem_dc->MoveTo(x,y+yf*16); g_mem_dc->LineTo(xt,y+yf*16); }
			if (p2) { g_mem_dc->MoveTo(x,y+yt*16); g_mem_dc->LineTo(xt+1,y+yt*16); }
			g_mem_dc->SelectObject(origpen);
		}
		char tx[96];
		sprintf(tx,"%i line(s) [%02X-%02X] selected in the track %02X",bto-bfro+1,bfro,bto,g_trackcl.m_seltrack);
		TextXY(tx,TRACKS_X+4*8,TRACKS_Y+21*16);
		x = TRACKS_X+4*8 + strlen(tx)*8 +8;
		if (g_trackcl.m_all)
			strcpy(tx,"[change ALL events]");
		else
			sprintf(tx,"[change events for instr %02X only]",m_activeinstr);
		TextXY(tx,x,TRACKS_Y+21*16,6);
	}

	//cary vymezujici aktualni radek
	x = (g_tracks4_8==4)? TRACKS_X+(93-4*11)*8 : TRACKS_X+93*8;
	g_mem_dc->MoveTo(TRACKS_X,TRACKS_Y+11*16-2);
	g_mem_dc->LineTo(x,TRACKS_Y+11*16-2);
	g_mem_dc->MoveTo(TRACKS_X,TRACKS_Y+12*16+1);
	g_mem_dc->LineTo(x,TRACKS_Y+12*16+1);

	return 1;
}

BOOL CSong::DrawInstrument()
{
	m_instrs.DrawInstrument(m_activeinstr);
	return 1;
}

#define INFO_X	2*8
#define INFO_Y	1*16

BOOL CSong::DrawInfo()
{
	char s[80];
	int i,c;

	if (g_prove>0)
		TextXY((g_prove==1)?"PROVE MODE 1":"PROVE MODE 2 - STEREO",INFO_X,INFO_Y+2*16,6);
	
	if (!g_prove && g_activepart==PARTINFO && m_infoact==0) //info? && edit name?
	{
		i=m_songnamecur;
		c=6; //cervene
	}
	else
	{
		i=-1;
		c=0; //bila
	}
	TextXYSelN(m_songname,i,INFO_X,INFO_Y,c);


	sprintf(s,"MUSIC SPEED: %02X/%02X/%X  MAXTRACKLENGTH: %02X  %s",
		m_speed,m_mainspeed,m_instrspeed,
		m_tracks.m_maxtracklen,
		(g_tracks4_8==4)? "MONO-4-TRACKS" : "STEREO-8-TRACKS"
		);
	TextXY(s,INFO_X,INFO_Y+1*16);
	if (!g_prove && g_activepart==PARTINFO)
	{
		switch (m_infoact)
		{
		case 1:	//speed
			s[15]=0; //za cislem speed
			TextXY(s+13,INFO_X+13*8,INFO_Y+1*16,3);	//selected
			break;
		case 2: //mainspeed
			s[18]=0; //za cislem main speed
			TextXY(s+16,INFO_X+16*8,INFO_Y+1*16,3);	//selected
			break;
		case 3: //instrspeed
			s[20]=0; //za cislem instrspeed
			TextXY(s+19,INFO_X+19*8,INFO_Y+1*16,3);	//selected
			break;
		}
	}
		
	sprintf(s,"%02X: %s",m_activeinstr,m_instrs.GetName(m_activeinstr));
	TextXY(s,INFO_X,INFO_Y+3*16);
	sprintf(s,"OCTAVE %i-%i",m_octave+1,m_octave+2);
	TextXY(s,INFO_X+47*8,INFO_Y+3*16);
	sprintf(s,"VOLUME %X",m_volume);
	TextXY(s,INFO_X+49*8,INFO_Y+4*16);
	if (g_respectvolume) TextXY("\x17",INFO_X+57*8,INFO_Y+4*16);	//respect volume mode

	//nad instrumentem radek s flagy
	BYTE flag = m_instrs.GetFlag(m_activeinstr);

	int x=INFO_X;	//+4*8;
	const y=INFO_Y+4*16;
	int g=(m_trackactivecol%4) +1;		//generator 1 az 4
	if (flag&IF_FILTER)
	{
		if (g>2) 
		{
			TextMiniXY("NO_FILTER",x,y,1);	//gray
			x += 10*8;
		}
		else
		{
			if (g==1)
				TextMiniXY("FILTER(1+3)",x,y);
			else
				TextMiniXY("FILTER(2+4)",x,y);
			x += 12*8;
		}
	}
	if (flag&IF_BASS16)
	{
		if (g==2)
		{
			TextMiniXY("BASS16(2+1)",x,y);
			x += 12*8;
		}
		else
		if (g==4)
		{
			TextMiniXY("BASS16(4+3)",x,y);
			x += 12*8;
		}
		else
		{
			TextMiniXY("NO_BASS16",x,y,1);	//gray
			x += 10*8;
		}
	}
	if (flag&IF_PORTAMENTO)
	{
		TextMiniXY("PORTAMENTO",x,y);
		x += 11*8;
	}
	if (flag&IF_POLY9)
	{
		TextMiniXY("POLY9",x,y);
		x += 6*8;
	}
	if (flag&IF_15KHZ)
	{
		TextMiniXY("15KHZ",x,y);
		x += 6*8;
	}

	return 1;
}

BOOL CSong::DrawAnalyzer(CDC *pDC = NULL)
{
	if (!g_viewanalyzer) return 0;

#define ANALYZER_X	TRACKS_X+6*8+2
#define ANALYZER_Y	TRACKS_Y-8
#define ANALYZER_S	4
#define ANALYZER_H	4
#define ANALYZER_HP	8

#define ANALYZER2_X	SONG_X+6*8
#define ANALYZER2_Y	TRACKS_Y-8
#define ANALYZER2_S	1
#define ANALYZER2_H	4
#define ANALYZER2_HP 8

#define Hook1(g1,g2)			\
	{							\
		g_mem_dc->MoveTo(ANALYZER_X+ANALYZER_S*15/2+11*8*(g1),ANALYZER_Y-1);		\
		g_mem_dc->LineTo(ANALYZER_X+ANALYZER_S*15/2+11*8*(g1),ANALYZER_Y-yu);		\
		g_mem_dc->LineTo(ANALYZER_X+ANALYZER_S*15/2+11*8*(g2),ANALYZER_Y-yu);		\
		g_mem_dc->LineTo(ANALYZER_X+ANALYZER_S*15/2+11*8*(g2),ANALYZER_Y);			\
	}
#define Hook2(g1,g2)			\
	{							\
		g_mem_dc->MoveTo(ANALYZER2_X+ANALYZER2_S*15/2+3*8*(g1),ANALYZER_Y-1);		\
		g_mem_dc->LineTo(ANALYZER2_X+ANALYZER2_S*15/2+3*8*(g1),ANALYZER_Y-yu);		\
		g_mem_dc->LineTo(ANALYZER2_X+ANALYZER2_S*15/2+3*8*(g2),ANALYZER_Y-yu);		\
		g_mem_dc->LineTo(ANALYZER2_X+ANALYZER2_S*15/2+3*8*(g2),ANALYZER_Y);			\
	}

#define COL_BLOCK	64

	int vol;
	static idx[8]={0xd201,0xd203,0xd205,0xd207,0xd211,0xd213,0xd215,0xd217};
	int col[8];
	int yu=7;
	for(int i=0; i<g_tracks4_8; i++) col[i]=80;
	int a;

	if (g_active_ti==PARTTRACKS)
	{
		g_mem_dc->FillSolidRect(ANALYZER_X,ANALYZER_Y-ANALYZER_HP,g_tracks4_8*11*8-8,ANALYZER_H+ANALYZER_HP,RGB(80,80,80));
		a = g_atarimem[0xd208]; //audctl1
		if (a&0x04) { col[2]=COL_BLOCK; Hook1(0,2); yu-=2; }
		if (a&0x02) { col[3]=COL_BLOCK;	Hook1(1,3); yu-=2; }
		if (a&0x10) { col[0]=COL_BLOCK;	Hook1(0,1); yu-=2; }
		if (a&0x08) { col[2]=COL_BLOCK;	Hook1(2,3); yu-=2; }
		yu=7;
		a = g_atarimem[0xd218]; //audctl2
		if (a&0x04) { col[2+4]=COL_BLOCK; Hook1(0+4,2+4); yu-=2; }
		if (a&0x02) { col[3+4]=COL_BLOCK; Hook1(1+4,3+4); yu-=2; }
		if (a&0x10) { col[0+4]=COL_BLOCK; Hook1(0+4,1+4); yu-=2; }
		if (a&0x08) { col[2+4]=COL_BLOCK; Hook1(2+4,3+4); yu-=2; }
		
		for(int i=0; i<g_tracks4_8; i++)
		{
			vol = g_atarimem[idx[i]] & 0x0f;
			g_mem_dc->FillSolidRect(ANALYZER_X+i*11*8,ANALYZER_Y,15*ANALYZER_S ,ANALYZER_H,RGB(col[i],col[i],col[i]));
			if (vol) g_mem_dc->FillSolidRect(ANALYZER_X+i*11*8+(15-vol)*ANALYZER_S/2,ANALYZER_Y,vol*ANALYZER_S,ANALYZER_H,RGB(255,255,255));
		}
		if (pDC) pDC->BitBlt(ANALYZER_X,ANALYZER_Y-ANALYZER_HP,g_tracks4_8*11*8-8,ANALYZER_H+ANALYZER_HP,g_mem_dc,ANALYZER_X,ANALYZER_Y-ANALYZER_HP,SRCCOPY);
	}
	else //instruments
	{
		g_mem_dc->FillSolidRect(ANALYZER2_X,ANALYZER2_Y-ANALYZER2_HP,g_tracks4_8*3*8-8,ANALYZER2_H+ANALYZER2_HP,RGB(80,80,80));
		a = g_atarimem[0xd208]; //audctl1
		if (a&0x04) { col[2]=COL_BLOCK; Hook2(0,2); yu-=2; }
		if (a&0x02) { col[3]=COL_BLOCK;	Hook2(1,3); yu-=2; }
		if (a&0x10) { col[0]=COL_BLOCK;	Hook2(0,1); yu-=2; }
		if (a&0x08) { col[2]=COL_BLOCK;	Hook2(2,3); yu-=2; }
		yu=7;
		a = g_atarimem[0xd218]; //audctl2
		if (a&0x04) { col[2+4]=COL_BLOCK; Hook2(0+4,2+4); yu-=2; }
		if (a&0x02) { col[3+4]=COL_BLOCK; Hook2(1+4,3+4); yu-=2; }
		if (a&0x10) { col[0+4]=COL_BLOCK; Hook2(0+4,1+4); yu-=2; }
		if (a&0x08) { col[2+4]=COL_BLOCK; Hook2(2+4,3+4); yu-=2; }
		
		for(int i=0; i<g_tracks4_8; i++)
		{
			vol = g_atarimem[idx[i]] & 0x0f;
			g_mem_dc->FillSolidRect(ANALYZER2_X+i*3*8,ANALYZER2_Y,15*ANALYZER2_S ,ANALYZER2_H,RGB(col[i],col[i],col[i]));
			if (vol) g_mem_dc->FillSolidRect(ANALYZER2_X+i*3*8+(15-vol)*ANALYZER2_S/2,ANALYZER2_Y,vol*ANALYZER2_S,ANALYZER2_H,RGB(255,255,255));
		}
		if (pDC) pDC->BitBlt(ANALYZER2_X,ANALYZER2_Y-ANALYZER2_HP,g_tracks4_8*3*8-8,ANALYZER2_H+ANALYZER2_HP,g_mem_dc,ANALYZER2_X,ANALYZER2_Y-ANALYZER2_HP,SRCCOPY);
	}

	return 1;
}


BOOL CSong::InfoKey(int vk,int shift,int control)
{
	if (m_infoact==0)
	{
		if ( EditText(vk,shift,control,m_songname,m_songnamecur,SONGNAMEMAXLEN) ) m_infoact=1;
		return 1;
	}

	int i,num;		
	int volatile * infptab[]={&m_speed,&m_mainspeed,&m_instrspeed};
	int infandtab[]={0xff,0xff,0x02};
	int volatile& infp = *infptab[m_infoact-1];
	int infand = infandtab[m_infoact-1];
		
		
	if ( (num=NumbKey(vk))>=0 && num<=infand)
	{
		i= infp & 0x0f; //nizsi cifra
		i = ((i<<4) | num) & infand;
		if (i<=0) i=1;	//vsechny speedy mohou byt minimalne 1
		infp = i;
		return 1;
	}

	switch(vk)
	{
	case VK_TAB:
		if (shift)
		{
			m_infoact=0;	//Shift+TAB => Name
		}
		else
		{
			if (m_infoact<3) m_infoact++; else m_infoact=1; //TAB 1 a 2 a 3
		}
		return 1;

	case VK_UP:
		if (control) goto IncrementInfoPar;
		break;

	case VK_DOWN:
		if (control) goto DecrementInfoPar;
		break;

	case VK_LEFT:
		if (control)
		{
DecrementInfoPar:
			i = infp;
			i--;
			if (i<=0) i=infand; //speedy mohou byt minimalne 1
			infp = i;
		}
		else
		{
			if (m_infoact>1) m_infoact--; else m_infoact=3;
		}
		return 1;
	
	case VK_RIGHT:
		if (control)
		{
IncrementInfoPar:
			i = infp;
			i++;
			if (i>infand) i=1;	//speedy mohou byt minimalne 1
			infp = i;
		}
		else
		{
			if (m_infoact<3) m_infoact++; else m_infoact=1;
		}
		return 1;

	case 13:		//VK_ENTER
		g_activepart = g_active_ti;
		return 1;

	}
	return 0;
}

BOOL CSong::InstrKey(int vk,int shift,int control)
{
	//poznamka: vraci-li 1, pak se v RmtView dela screenupdate
	TInstrument& ai= m_instrs.m_instr[m_activeinstr];
	int& ap = ai.par[ai.activepar];
	int& ae = ai.env[ai.activeenvx][ai.activeenvy];
	int i;

	if (!control && !shift && NumbKey(vk)>=0)
	{
		//if (control)
		//	return SongTrackSetByNum(NumbKey(vk));		//<--v Instrument modu nebude pres CTRL+cislo menit song

		if (ai.act==1) //parameters
		{
			int pand = shpar[ai.activepar].pand;
			int pfrom = shpar[ai.activepar].pfrom;
			if (NumbKey(vk)>pand+pfrom) return 0;
			i = ap + pfrom;
			i &= 0x0f; //dolni cifra
			if (pand+pfrom>0x0f)
			{
				i = (i<<4) | NumbKey(vk);
				if (i > pand+pfrom)
					i &= 0x0f;		//necha pouze dolni cifru
			}
			else
			{
				if (NumbKey(vk)>=pfrom) i = NumbKey(vk);
			}
			i -= pfrom;
			if ( i<0) i=0;
			ap = i;
			goto ChangeInstrumentPar;
		}
		else
		if (ai.act==2) //envelope
		{
			int eand = shenv[ai.activeenvy].pand;
			int num = NumbKey(vk);
			i = num & eand;
			if (i != num) return 0; //po andu vyslo neco jineho => stlaceno cislo mimo rozsah
			ae = i;
			//posun doprava
			i=ai.activeenvx;
			if (i<ai.par[PAR_ENVLEN]) i++;	// else i=0; //delka env
			ai.activeenvx=i;
			goto ChangeInstrumentEnv;
		}
	}

	//pro name,parametrs i envelope
	switch(vk)
	{
	case VK_TAB:
		if (shift)
		{
			//if (ai.act>0) ai.act--;	else ai.act=2;
			ai.act=0;	//Shift+TAB => Name
		}
		else
		{
			if (ai.act<2) ai.act++;	else ai.act=1; //TAB 1 a 2
		}
		return 1;

	case VK_LEFT:
		if (shift)
		{
			m_activeinstr = (m_activeinstr-1) & 0x3f;
			return 1;
		}
		break;

	case VK_RIGHT:
		if (shift)
		{
			m_activeinstr = (m_activeinstr+1) & 0x3f;
			return 1;
		}
		break;

	case VK_UP:
	case VK_DOWN:
		if (shift) return 0;
		break;

	case 33:	//VK_PAGE_UP:
		if (shift) 
		{
			OctaveUp();
			return 1;
		}
		break;

	case 34:	//VK_PAGE_DOWN: 
		if (shift)
		{
			OctaveDown();
			return 1;
		}
		break;

	case VK_SUBTRACT:
		VolumeDown();
		break;

	case VK_ADD:
		VolumeUp();
		break;
	}

	//a ted jen pro specialni casti

	if (ai.act==0)
	{
		//NAME
		if ( EditText(vk,shift,control,ai.name,ai.activenam,INSTRNAMEMAXLEN) ) ai.act=1;

		return 1;
	}
	else
	if (ai.act==1)
	{
		//PARAMETERS
		switch(vk)
		{
		case VK_UP:
			if (control) goto ParameterInc;
			ai.activepar = shpar[ai.activepar].gup;
			return 1;
			
		case VK_DOWN:
			if (control) goto ParameterDec;			
			ai.activepar = shpar[ai.activepar].gdw;
			return 1;
			
		case VK_LEFT:
			if (control)
			{
ParameterDec:
				ap = (ap-1) & shpar[ai.activepar].pand;
				goto ChangeInstrumentPar;
			}
			else
				ai.activepar = shpar[ai.activepar].gle;
			return 1;
			
		case VK_RIGHT:
			if (control)
			{
ParameterInc:
				ap = (ap+1) & shpar[ai.activepar].pand;
				goto ChangeInstrumentPar;
			}
			else
				ai.activepar = shpar[ai.activepar].gri;
			return 1;
			
		case VK_HOME:
			if (control)
			{	//nastavi sem TABLE go smycku
				if (ai.activepar>=PAR_TAB0 && ai.activepar<=PAR_TAB7)
				{
					ai.par[PAR_TABGO] = ai.activepar;
					if (ai.activepar>ai.par[PAR_TABLEN]) ai.par[PAR_TABLEN] = ai.activepar;
					goto ChangeInstrumentPar;
				}
			}
			else
			{
				//prechod na zacatek TABLE a na zacatek TABLE smycky
				if (ai.activepar!=PAR_TAB0)
					ai.activepar=PAR_TAB0;
				else
					ai.activepar = ai.par[PAR_TABGO];
			}
			return 1;

		case VK_END:
			if (control)
			{	//nastavi TABLE len podle mista
				if (ai.activepar>=PAR_TAB0 && ai.activepar<=PAR_TAB7)
				{
					ai.par[PAR_TABLEN] = ai.activepar;
					goto ChangeInstrumentPar;
				}
			}
			else	//prejde na posledni parametr v TABLE
				ai.activepar = ai.par[PAR_TABLEN];
			return 1;
			
		case 8:		//VK_BACKSPACE:
			ap=0;
			goto ChangeInstrumentPar;
			return 1;

ChangeInstrumentPar:
			//kontrola ENVELOPE len-go smycky
			if (ai.par[PAR_ENVGO]>ai.par[PAR_ENVLEN]) ai.par[PAR_ENVGO]=ai.par[PAR_ENVLEN];
			//kontrola TABLE len-go smycky
			if (ai.par[PAR_TABGO]>ai.par[PAR_TABLEN]) ai.par[PAR_TABGO]=ai.par[PAR_TABLEN];
			//kontrola kurzoru v envelope
			if (ai.activeenvx>ai.par[PAR_ENVLEN]) ai.activeenvx=ai.par[PAR_ENVLEN];
			//neco se zmenilo => Ulozeni instrumentu "do Atarka"
			m_instrs.ModificationInstrument(m_activeinstr);
			return 1;
		}
	}
	else
	if (ai.act==2)
	{
		//ENVELOPE
		switch(vk)
		{
		case VK_UP:
			if (control) goto EnvelopeInc;
			i=ai.activeenvy;
			if (i>0)
			{
				i--;
				if (i==0 && g_tracks4_8<=4) i=7;	//mono rezim
			}
			else 
				i=7;
			ai.activeenvy=i;
			return 1;
			
		case VK_DOWN: 
			if (control) goto EnvelopeDec;
			i=ai.activeenvy;
			if (i<7) i++; else i=(g_tracks4_8>4)? 0 : 1;
			ai.activeenvy=i;
			return 1;
			
		case VK_LEFT:
			if (control)
			{
EnvelopeDec:
				ae = (ae+shenv[ai.activeenvy].psub) & shenv[ai.activeenvy].pand;
				goto ChangeInstrumentEnv;
			}
			else
			{
				i=ai.activeenvx;
				if (i>0) i--; else i=ai.par[PAR_ENVLEN]; //delka env
				ai.activeenvx=i;
			}
			return 1;
			
		case VK_RIGHT:
			if (control)
			{
EnvelopeInc:
				ae = (ae+shenv[ai.activeenvy].padd) & shenv[ai.activeenvy].pand;
				goto ChangeInstrumentEnv;
			}
			else
			{
				i=ai.activeenvx;
				if (i<ai.par[PAR_ENVLEN]) i++; else i=0; //delka env
				ai.activeenvx=i;
			}
			return 1;
			
		case VK_HOME:		
			if (control)
			{
				ai.par[PAR_ENVGO] = ai.activeenvx; //nastavi ENVGO na tento sloupec
				goto ChangeInstrumentPar;	//ano, to je v poradku, opravdu zmenil PARAMETR, i kdyz je v envelope
			}
			else
			{
				//prejde doleva na 0.sloupec nebo na zacatek GO smycky
				if (ai.activeenvx!=0)
					ai.activeenvx = 0;
				else
					ai.activeenvx=ai.par[PAR_ENVGO];
			}
			return 1;

		case VK_END:
			if (control)
			{
				if (ai.activeenvx==ai.par[PAR_ENVLEN])	//nastavi ENVLEN na tento sloupec nebo na konec
					ai.par[PAR_ENVLEN]=ENVCOLS-1;
				else
					ai.par[PAR_ENVLEN]=ai.activeenvx;
				goto ChangeInstrumentPar;	//ano, zmenil PAR z envelope
			}
			else
			{
				ai.activeenvx=ai.par[PAR_ENVLEN];	//prejde kursorem doprava na konec
			}
			return 1;
			
		case 8:			//VK_BACKSPACE:
			ae=0;
			goto ChangeInstrumentEnv;
			return 1;

ChangeInstrumentEnv:
			//neco se zmenilo => Ulozeni instrumentu "do Atarka"
			m_instrs.ModificationInstrument(m_activeinstr);
			return 1;
		}
	}

	return 0;	//=> nebude se delat SCREENUPDATE
}

BOOL CSong::ActiveInstrSetByNum(int num)
{
	//int i = m_activeinstr & 0x0f;
	//i = (i<<4) | num;
	//if ( i >= INSTRSNUM ) i &= 0x0f;
	//m_activeinstr = i;
	m_activeinstr = num;
	return 1;
}


BOOL CSong::ProveKey(int vk,int shift,int control)
{
	int note,i;

	if (Numblock09Key(vk)>=0)
	{
		if (shift)
		{
			ActiveInstrSetByNum(Numblock09Key(vk));
			return 1;
		}
	}

	note = NoteKey(vk);
	if (note>=0)
	{
		i=note+m_octave*12;
		if (i>=0 && i<NOTESNUM)		//jenom v mezich
		{
			SetPlayPressedTonesTNIV(m_trackactivecol,i,m_activeinstr,m_volume);
			if ((control || g_prove==2) && g_tracks4_8>4)
			{	//s controlem nebo v prove2 => stereo test
				SetPlayPressedTonesTNIV((m_trackactivecol+4)&0x07,i,m_activeinstr,m_volume);
			}
		}
		return 0; //nemusi prekreslovat
	}

	switch(vk)
	{
	case VK_LEFT:
		if (shift)
			m_activeinstr = (m_activeinstr-1) & 0x3f;
		else
			TrackLeft(1);
		break;

	case VK_RIGHT:
		if (shift)
			m_activeinstr = (m_activeinstr+1) & 0x3f;
		else
			TrackRight(1);
		break;

	case VK_TAB:
		if (shift)
			TrackLeft(1);
		else
			TrackRight(1);
		break;


	case VK_SPACE:
		SetPlayPressedTonesTNIV(m_trackactivecol,-1,-1,0);
		if ((control || g_prove==2) && g_tracks4_8>4)
		{	//s controlem nebo prove2 = stereo test
			SetPlayPressedTonesTNIV((m_trackactivecol+4)&0x07,-1,-1,0);
		}
		return 0;	//nemusi prekreslovat
		//break;

	case VK_SUBTRACT:
		VolumeDown();
		//if (control) SetPlayPressedTonesV(m_trackactivecol,m_volume);
		break;

	case VK_ADD:
		VolumeUp();
		//if (control) SetPlayPressedTonesV(m_trackactivecol,m_volume);
		break;


	default:
		return 0;
		break;
	}
	return 1;
}


BOOL CSong::TrackKey(int vk,int shift,int control)
{
#define BLOCKSETBEGIN	g_trackcl.BlockSetBegin(m_trackactivecol,SongGetActiveTrack(),m_trackactiveline)
#define BLOCKSETEND		g_trackcl.BlockSetEnd(m_trackactiveline)
#define BLOCKDESELECT	g_trackcl.BlockDeselect()
#define ISBLOCKSELECTED	g_trackcl.IsBlockSelected()

	int note,i,j;

	if (g_trackcl.IsBlockSelected() && SongGetActiveTrack()!=g_trackcl.m_seltrack) BLOCKDESELECT;

	/* 1.01
	if (NumbKey(vk)>=0)
	{
		if (control)
			return SongTrackSetByNum(NumbKey(vk));
	}
	*/

	if (SongGetGo()>=0) //je aktivni song go radek => nesmi nic editovat
	{
		if (!control && !shift) return 0;
		if (control && (vk==8 || vk==71) ) //control+backspace nebo control+G
		{
			SongTrackGoOnOff();
			return 1;
		}
		if (control && !shift && (vk==VK_INSERT || vk==VK_DELETE)) goto TrackKeyOk;
		if (vk!=VK_LEFT && vk!=VK_RIGHT && vk!=VK_UP && vk!=VK_DOWN) return 0;
	}
TrackKeyOk:


	switch (m_trackactivecur)
	{
	case 0: //sloupec not
		if (control) break;		//s controlem se noty nezadavaji (breakem pokracuje dal)
		note = NoteKey(vk);
		if (note>=0)
		{
			i=note+m_octave*12;
			if (i>=0 && i<NOTESNUM)		//jenom v mezich
			{
				BLOCKDESELECT;
				if ( TrackSetNoteActualInstrVol(i) )
				{
					SetPlayPressedTonesTNIV(m_trackactivecol,i,m_activeinstr,TrackGetVol());
					TrackDown();
				}
			}
			return 1;
		}
		else //cislama 1-6 na numeraku se prepisuje oktava
		if ( (j=Numblock09Key(vk))>=1 && j<=6 && m_trackactiveline<=TrackGetLastLine())
		{
			note = TrackGetNote();
			if (note>=0)		//je tam nejaka nota?
			{
				BLOCKDESELECT;
				note = (note % 12) + ((j-1)*12);		//zmeni jeji oktavu podle stlaceneho cisla na numblocku
				if (note>=0 && note<NOTESNUM)
				{
					int instr=TrackGetInstr(),vol=TrackGetVol();
					if (TrackSetNoteInstrVol(note,instr,vol))
						SetPlayPressedTonesTNIV(m_trackactivecol,note,instr,vol);
				}
			}
			TrackDown();
			return 1;
		}

		break;

	case 1: //sloupec instrumentu
		i = NumbKey(vk);
		if (i>=0 && !shift && !control)
		{
			BLOCKDESELECT;
			if (TrackGetNote()>=0) //cislo instrumentu lze menit jen pouze je-li tam nota
			{
				j= ((TrackGetInstr()&0x0f)<<4) | i;
				if (j>=INSTRSNUM) j &= 0x0f;	//ponecha jen dolni cifru
				TrackSetInstr(j);
			}
			return 1;
		}
		break;
	
	case 2: //sloupec volume
		i = NumbKey(vk);
		if (i>=0 && !shift && !control)
		{
			BLOCKDESELECT;
			if ( TrackSetVol(i) ) TrackDown();
			return 1;
		}
		break;

	case 3: //sloupec speed
		i = NumbKey(vk);
		if (i>=0 && !shift && !control)
		{
			BLOCKDESELECT;
			j = TrackGetSpeed();
			if (j<0) j=0;
			j= (( j & 0x0f )<<4) | i;
			if (j>=TRACKMAXSPEED) j &= 0x0f;	//ponecha jen dolni cifru
			if (j<=0) j= -1;	//nulova neexistuje
			TrackSetSpeed(j);
			return 1;
		}
		break;

	}


	switch(vk)
	{
	case VK_UP:
		if (shift)
		{
			//selektovani bloku
			BLOCKSETBEGIN;
			TrackUp();
			BLOCKSETEND;
		}
		else
		{
			BLOCKDESELECT;
			if (control)
				SongUp();
			else
				TrackUp();
		}
		break;

	case VK_DOWN: 
		if (shift)
		{
			//selektovani bloku
			BLOCKSETBEGIN;
			TrackDown(0);	//nebude zastavovat na poslednim radku
			BLOCKSETEND;
		}
		else
		{
			BLOCKDESELECT;
			if (control)
				SongDown();
			else
				TrackDown(0);	//stoponlastline=0 =>nebude zastavovat na poslednim radku tracku
		}
		break;

	case VK_LEFT:
		if (shift)
		{
			if (ISBLOCKSELECTED && control)
			{
				//zmeny instrumentu v bloku
				g_trackcl.BlockInstrumentChange(m_activeinstr,-1);
			}
			else
				m_activeinstr = (m_activeinstr-1) & 0x3f;
		}
		else
		{
			BLOCKDESELECT;
			if (control)
				SongTrackDec();
			else
				TrackLeft();
		}
		break;

	case VK_RIGHT:
		if (shift)
		{
			if (ISBLOCKSELECTED && control)
			{
				//zmeny instrumentu v bloku
				g_trackcl.BlockInstrumentChange(m_activeinstr,1);
			}
			else
				m_activeinstr = (m_activeinstr+1) & 0x3f;
		}
		else
		{
			BLOCKDESELECT;
			if (control)
				SongTrackInc();
			else
				TrackRight();
		}
		break;

	case 33: //VK_PAGE_UP:
		if (shift)
		{
			if (ISBLOCKSELECTED && control) 
			{
				//transpozice v bloku nahoru (k vyssim notam)
				g_trackcl.BlockNoteTransposition(m_activeinstr,1);
			}
			else
				OctaveUp();
		}
		else
		{
			BLOCKDESELECT;
			if (m_trackactiveline>0)
			{
				m_trackactiveline = (m_trackactiveline-1) & 0xf8;
			}
		}
		break;

	case 34: //VK_PAGE_DOWN:
		if (shift)
		{
			if (ISBLOCKSELECTED && control)
			{
				//transpozice v bloku dolu (k nizsim notam)
				g_trackcl.BlockNoteTransposition(m_activeinstr,-1);
			}
			else
				OctaveDown();
		}
		else
		{
			BLOCKDESELECT;
			i = (m_trackactiveline+8) & 0xf8;
			if (i>=m_tracks.m_maxtracklen) i = m_tracks.m_maxtracklen-1;
			m_trackactiveline = i;
		}
		break;

	case VK_SUBTRACT:
		if (shift && ISBLOCKSELECTED && control)
		{
			//zeslabovani v bloku
			g_trackcl.BlockVolumeChange(m_activeinstr,-1);
		}
		else
			VolumeDown();
		break;

	case VK_ADD:
		if (shift && ISBLOCKSELECTED && control)
		{
			//zesilovani v bloku
			g_trackcl.BlockVolumeChange(m_activeinstr,1);
		}
		else
			VolumeUp();
		break;

	case VK_TAB:
		BLOCKDESELECT;
		if (shift)
			TrackLeft(1);
		else
			TrackRight(1);
		break;

	
	case 65:	//VK_A
		if (g_trackcl.IsBlockSelected() && shift && control)
		{	//Shift+control+A
			//prepinani ALL / no ALL
			g_trackcl.BlockAllOnOff();
		}
		else
		if (control && !shift)
		{
			//control+A
			//selektovani celeho tracku (od 0 po delku toho tracku)
			g_trackcl.BlockDeselect();
			g_trackcl.BlockSetBegin(m_trackactivecol,SongGetActiveTrack(),0);
			g_trackcl.BlockSetEnd(m_tracks.GetLastLine(SongGetActiveTrack()));
		}
		break;

	case 66:	//VK_B			//restore block from backup
		if (g_trackcl.IsBlockSelected() && control && !shift)
			g_trackcl.BlockRestoreFromBackup();
		break;

	case 67:	//VK_C
		if (control)
		{
Block_copy:
			if (!g_trackcl.IsBlockSelected())
			{	//kdyz neni vybran blok, udela blok na aktualnim miste
				g_trackcl.BlockSetBegin(m_trackactivecol,SongGetActiveTrack(),m_trackactiveline);
				g_trackcl.BlockSetEnd(m_trackactiveline);
			}
			g_trackcl.BlockCopyToClipboard();
		}
		break;

	case 86:	//VK_V
		if (control)
		{
Block_paste:
			int lines = g_trackcl.BlockPasteToTrack(SongGetActiveTrack(),m_trackactiveline);
			if (lines>0)
			{
				int lastl = m_trackactiveline+lines-1;
				//prenastavi zacatek bloku na toto misto
				g_trackcl.BlockDeselect();
				g_trackcl.BlockSetBegin(m_trackactivecol,SongGetActiveTrack(),m_trackactiveline);
				g_trackcl.BlockSetEnd(lastl);
				//posune aktualni line na posledni dolni radek pastnuteho bloku
				m_trackactiveline=lastl;
			}
		}
		break;

	case 88:	//VK_X
		if (control && g_trackcl.IsBlockSelected())
		{
			g_trackcl.BlockCopyToClipboard();
			g_trackcl.BlockClear();
		}
		break;

	case 83:	//VK_S		//speed sloupec
		BLOCKDESELECT;
		if (control) m_trackactivecur=3;	//control+S => speed sloupec
		break;

	case 71:	//VK_G		//song goto on/off
		BLOCKDESELECT;
		if (control) SongTrackGoOnOff();	//control+G => goto on/off line v songu
		break;

	case 73:	//VK_I:
		BLOCKDESELECT;
		if (control)
			SongInsertLine(m_songactiveline);
		break;
	
	case 85:	//VK_U:
		BLOCKDESELECT;
		if (control)
			SongDeleteLine(m_songactiveline);
		break;


	case VK_HOME:
		if (control)
			TrackSetGo();
		else
		{
			if (shift)
			{
				BLOCKSETBEGIN;
				m_trackactiveline = 0;		//na 0.radek
				BLOCKSETEND;
			}
			else
			{
				if (g_trackcl.IsBlockSelected())
				{
					//nastavi na prvni radek v bloku
					int bfro,bto;
					g_trackcl.GetFromTo(bfro,bto);
					m_trackactiveline=bfro;
				}
				else
				{
					if (m_trackactiveline!=0)
						m_trackactiveline = 0;		//na 0.radek
					else
					{
						i=TrackGetGoLine();
						if (i>=0) m_trackactiveline = i;	//na zacatek GO smycky
					}
					BLOCKDESELECT;
				}
			}
		}
		break;

	case VK_END:
		if (control)
			TrackSetEnd();
		else
		{
			if (shift)
			{
				BLOCKSETBEGIN;
				m_trackactiveline = TrackGetLastLine();
				BLOCKSETEND;
			}
			else
			{
				if (g_trackcl.IsBlockSelected())
				{
					//nastavi na prvni radek v bloku
					int bfro,bto;
					g_trackcl.GetFromTo(bfro,bto);
					m_trackactiveline=bto;
				}
				else
				{
					m_trackactiveline = TrackGetLastLine();
					BLOCKDESELECT;
				}
			}
		}
		break;

	case 13:		//VK_ENTER:
		{
			int instr,vol;
			if (control)	//control+Enter => hraje cely radek (vsechny tracky)
			{
				//pro vsechny sloupce tracku krom aktivniho sloupce tracku
				for(i=0; i<g_tracks4_8; i++)
				{
					if (i!=m_trackactivecol)
					{
						TrackGetLoopingNoteInstrVol(m_song[m_songactiveline][i],note,instr,vol);
						if (note>=0)		//je tam nejaka nota?
							SetPlayPressedTonesTNIV(i,note,instr,vol);	//prehraje ji tak jak tam je
						else
						if (vol>0) //neni tam nota, ale je tam samostatne volume?
							SetPlayPressedTonesV(i,vol);				//nastavi tu hlasitost tak jak tam je
					}
				}
			}

			//a ted pro ten aktivni sloupec tracku
			TrackGetLoopingNoteInstrVol(SongGetActiveTrack(),note,instr,vol);
			if (note>=0)		//je tam nejaka nota?
			{
				SetPlayPressedTonesTNIV(m_trackactivecol,note,instr,vol);	//prehraje ji tak jak tam je
				if (shift)	//se shiftem si navic tento instrument a volume "nabere" jako aktualni
				{
					m_activeinstr = instr;
					m_volume = vol;
				}
			}
			else
			if (vol>0) //neni tam nota, ale je tam samostatne volume?
			{
				SetPlayPressedTonesV(m_trackactivecol,vol); //nastavi tu hlasitost
				if (shift) m_volume = vol; //"nabere" si tu volume jako aktualni
			}
		}
		TrackDown(0);	//stoponlastline=0 => jede dal

		//pokud je selektnuty blok, pohybuje se (a playuje) pouze v nem
		if (g_trackcl.IsBlockSelected())
		{
			int bfro,bto;
			g_trackcl.GetFromTo(bfro,bto);
			if (m_trackactiveline<bfro || m_trackactiveline>bto) m_trackactiveline=bfro;
		}
		break;

	case VK_INSERT:
		if (control)
		{
			goto Block_copy;
		}
		else
		if (shift)
		{
			goto Block_paste;
		}
		else
		{
			BLOCKDESELECT;
			m_tracks.InsertLine(SongGetActiveTrack(),m_trackactiveline);
		}
		break;

	case VK_DELETE:
		if (g_trackcl.IsBlockSelected())
		{
			//je selektovany blok, takze ho smaze
			g_trackcl.BlockClear();
		}
		else
		if (!shift)
		{
			BLOCKDESELECT;
			m_tracks.DeleteLine(SongGetActiveTrack(),m_trackactiveline);
		}
		break;


	case VK_SPACE:
		BLOCKDESELECT;
		TrackSetSpeed(-1);	//vynuluje speed
		if (TrackSetNoteActualInstrVol(-1)) TrackDown();
		break;

	case 8:			//VK_BACKSPACE:
		BLOCKDESELECT;
		if (control)
		{
			int isgo = (m_songgo[m_songactiveline]>=0)? 1:0;
			if (isgo) 
				SongTrackGoOnOff();	//Go off
			else
				SongTrackEmpty();
		}
		else
		{
			int r=0;
			switch(m_trackactivecur)
			{
			case 0:	// nota
			case 1: // instrument
				{
					int v=TrackGetVol();
					r=TrackSetNoteActualInstrVol(-1);
					TrackSetVol(v);
				}
				break;
			case 2: // volume
				r=TrackSetNoteActualInstrVol(-1);
				break;
			case 3: // speed
				r=TrackSetSpeed(-1);
				break;
			}
			if (r) TrackDown();
		}
		break;

	default:
		return 0;
		break;
	}
	return 1;
}

BOOL CSong::TrackUp()
{
	m_trackactiveline--;
	if (m_trackactiveline<0) m_trackactiveline=m_tracks.m_maxtracklen-1;
	return 1;
}

BOOL CSong::TrackDown(BOOL stoponlastline)
{
	if (stoponlastline && m_trackactiveline==TrackGetLastLine()) return 0;
	m_trackactiveline++;
	if (m_trackactiveline>=m_tracks.m_maxtracklen) m_trackactiveline=0;
	return 1;
}

BOOL CSong::TrackLeft(BOOL column)
{
	if (column || m_trackactiveline>TrackGetLastLine()) goto track_leftcolumn;
	m_trackactivecur--;
	if (m_trackactivecur==1 && TrackGetNote()<0) //neni-li nota, preskakuje sloupec instrumentu
		m_trackactivecur=0;
	else
	if (m_trackactivecur<0)
	{
		m_trackactivecur=2;
track_leftcolumn:
		m_trackactivecol--;
		if (m_trackactivecol<0) m_trackactivecol=g_tracks4_8-1;
	}
	return 1;
}

BOOL CSong::TrackRight(BOOL column)
{
	if (column || m_trackactiveline>TrackGetLastLine()) goto track_rightcolumn;
	m_trackactivecur++;
	if (m_trackactivecur==1 && TrackGetNote()<0) //neni-li nota, preskakuje sloupec instrumentu
		m_trackactivecur=2;
	else
	if (m_trackactivecur>2)
	{
		m_trackactivecur=0;
track_rightcolumn:
		m_trackactivecol++;
		if (m_trackactivecol>=g_tracks4_8) m_trackactivecol=0;
	}
	return 1;
}

void CSong::TrackGetLoopingNoteInstrVol(int track,int& note,int& instr,int& vol)
{
	//preda aktualni notu s prihlednutim na pripadnou goto smycku
	//int track = SongGetActiveTrack();
	int line,len,go;
	len = m_tracks.GetLastLine(track)+1;
	go = m_tracks.GetGoLine(track);
	if (m_trackactiveline < len)
		line = m_trackactiveline;
	else
	{
		if (go>=0)
			line = (m_trackactiveline - len) % (go - len) + go;
		else
		{
			note=instr=vol=-1;
			return;
		}
	}
	note = m_tracks.GetNote(track,line);
	instr = m_tracks.GetInstr(track,line);
	vol = m_tracks.GetVol(track,line);
}

BOOL CSong::SongKey(int vk,int shift,int control)
{
	int isgo = (m_songgo[m_songactiveline]>=0)? 1:0;

	if (NumbKey(vk)>=0)
	{
		//if (control)	- v songu je to i s controlem i primo jen cislo bez controlu
		return SongTrackSetByNum(NumbKey(vk));
	}

	switch(vk)
	{
	case VK_UP:
		SongUp();
		break;

	case VK_DOWN: 
		SongDown();
		break;

	case VK_LEFT:
		if (shift)
			m_activeinstr = (m_activeinstr-1) & 0x3f;
		else
		if (control)
		{
			if (isgo)
				SongTrackGoDec();
			else
				SongTrackDec();
		}
		else
			TrackLeft(1);
		break;

	case VK_RIGHT:
		if (shift)
			m_activeinstr = (m_activeinstr+1) & 0x3f;
		else
		if (control)
		{
			if (isgo)
				SongTrackGoInc();
			else
				SongTrackInc();
		}
		else
			TrackRight(1);
		break;

	case VK_INSERT:
		SongInsertLine(m_songactiveline);
		break;

	case VK_DELETE:
		SongDeleteLine(m_songactiveline);
		break;

	case 8:			//VK_BACKSPACE:
		if (isgo) 
			SongTrackGoOnOff();	//Go off
		else
			SongTrackEmpty();
		break;

	case 71:		//VK_G
		SongTrackGoOnOff();	//Go on/off
		break;

	default:
		return 0;
		break;
	}
	return 1;
}


BOOL CSong::SongUp()
{
	m_songactiveline--;
	if (m_songactiveline<0) m_songactiveline=SONGLEN-1;
	return 1;
}

BOOL CSong::SongDown()
{
	m_songactiveline++;
	if (m_songactiveline>=SONGLEN) m_songactiveline=0;
	return 1;
}

BOOL CSong::SongTrackSet(int t)
{
	if ( t>=-1 && t<TRACKSNUM)
		m_song[m_songactiveline][m_trackactivecol] = t;
	return 1;
}

BOOL CSong::SongTrackSetByNum(int num)
{
	int i;
	if (m_songgo[m_songactiveline]<0) // GO ?
	{	//zmeni track
		i = SongGetActiveTrack();
		if (i<0) i=0;
		i &= 0x0f;	//jen dolni cifra
		i = (i<<4) | num;
		if ( i >= TRACKSNUM ) i &= 0x0f;
		return SongTrackSet(i);
	}
	else
	{	//zmeni GO parametr
		i = m_songgo[m_songactiveline];
		if (i<0) i=0;
		i &= 0x0f;	//jen dolni cifra
		i = (i<<4) | num;
		if ( i >= SONGLEN ) i &= 0x0f;
		m_songgo[m_songactiveline] = i;
		return 1;
	}
}

BOOL CSong::SongTrackDec()
{
	if (m_songgo[m_songactiveline]<0)
	{
		int t = m_song[m_songactiveline][m_trackactivecol] -1;
		if (t<-1) t=TRACKSNUM-1;
		m_song[m_songactiveline][m_trackactivecol] = t;
	}
	else
	{	//je tam GO
		int g = m_songgo[m_songactiveline] -1;
		if (g<0) g=SONGLEN-1;
		m_songgo[m_songactiveline] = g;
	}
	return 1;
}

BOOL CSong::SongTrackInc()
{
	if (m_songgo[m_songactiveline]<0)
	{
		int t = m_song[m_songactiveline][m_trackactivecol] +1;
		if (t>=TRACKSNUM) t=-1;
		m_song[m_songactiveline][m_trackactivecol] = t;
	}
	else
	{	//je tam GO
		int g = m_songgo[m_songactiveline] +1;
		if (g>=SONGLEN) g=0;
		m_songgo[m_songactiveline] = g;
	}
	return 1;
}

BOOL CSong::SongTrackEmpty()
{
	m_song[m_songactiveline][m_trackactivecol] = -1;
	return 1;
}

BOOL CSong::SongTrackGoOnOff()
{
	//GO on/off
	m_songgo[m_songactiveline] = (m_songgo[m_songactiveline]<0) ? 0:-1;
	return 1;
}

BOOL CSong::SongInsertLine(int line)
{
	int j,go;
	for(int i=SONGLEN-2; i>=line; i--)
	{
		for(j=0; j<g_tracks4_8; j++) m_song[i+1][j] = m_song[i][j];
		go = m_songgo[i];
		if (go>0 && go>=line) go++;
		m_songgo[i+1] = go;
	}
	for(j=0; j<g_tracks4_8; j++) m_song[line][j] = -1;
	m_songgo[line] = -1;
	for(i=0; i<line; i++)
	{
		if (m_songgo[i]>=line) m_songgo[i]++;
	}
	return 1;
}

BOOL CSong::SongDeleteLine(int line)
{
	int j,go;
	for(int i=line; i<SONGLEN-1; i++)
	{
		for(j=0; j<g_tracks4_8; j++) m_song[i][j] = m_song[i+1][j];
		go = m_songgo[i+1];
		if (go>0 && go>line) go--;
		m_songgo[i] = go;
	}
	for(i=0; i<line; i++)
	{
		if (m_songgo[i]>line) m_songgo[i]--;
	}
	line = SONGLEN-1;
	for(j=0; j<g_tracks4_8; j++) m_song[line][j] = -1;
	m_songgo[line] = -1;
	return 1;
}

//--clipboardove funkce

void CSong::TrackCopy()
{
	int i = SongGetActiveTrack();
	if (i<0 || i>=TRACKSNUM) return;

	TTrack& at = *m_tracks.GetTrack(i);
	TTrack& tot = g_trackcl.m_trackcopy;

	/*
	for(i=0; i<at.len; i++)
	{
		tot.note[i] = at.note[i];
		tot.instr[i] = at.instr[i];
		tot.volume[i] = at.volume[i];
		tot.speed[i] = at.speed[i];
	}
	tot.len = at.len;
	tot.go = at.go;
	*/
	memcpy((void*)(&tot),(void*)(&at),sizeof(TTrack));
}

void CSong::TrackPaste()
{
	if (g_trackcl.m_trackcopy.len<=0) return;
	int i = SongGetActiveTrack();
	if (i<0 || i>=TRACKSNUM) return;

	TTrack& fro = g_trackcl.m_trackcopy;
	TTrack& at = *m_tracks.GetTrack(i);

	/*
	for(i=0; i<fro.len; i++)
	{
		at.note[i] = fro.note[i];
		at.instr[i] = fro.instr[i];
		at.volume[i] = fro.volume[i];
		at.speed[i] = fro.speed[i];
	}
	at.len = fro.len;
	at.go = fro.go;
	*/
	memcpy((void*)(&at),(void*)(&fro),sizeof(TTrack));
}

void CSong::TrackCut()
{
	TrackCopy();
	TrackDelete();
}

void CSong::InstrCopy()
{
	int i = GetActiveInstr();
	TInstrument& ai = m_instrs.m_instr[i];
	memcpy((void*)(&m_instrclipboard),(void*)(&ai),sizeof(TInstrument));
}

void CSong::InstrPaste()
{
	int i = GetActiveInstr();
	TInstrument& ai = m_instrs.m_instr[i];
	memcpy((void*)(&ai),(void*)(&m_instrclipboard),sizeof(TInstrument));
	ai.act=ai.activenam=0; //aby byl cursor na zacatku nazvu instrumentu
	m_instrs.ModificationInstrument(i); //promitne do Atari RAM
}

void CSong::InstrCut()
{
	InstrCopy();
	InstrDelete();
}

void CSong::SongCopyLine()
{
	for(int i=0; i<g_tracks4_8; i++) m_songlineclipboard[i]=m_song[m_songactiveline][i];
	m_songgoclipboard = m_songgo[m_songactiveline];
}

void CSong::SongPasteLine()
{
	if (m_songgoclipboard<-1) return;
	for(int i=0; i<g_tracks4_8; i++) m_song[m_songactiveline][i] = m_songlineclipboard[i];
	m_songgo[m_songactiveline] = m_songgoclipboard;
}

void CSong::SongClearLine()
{
	for(int i=0; i<g_tracks4_8; i++) m_song[m_songactiveline][i] = -1;
	m_songgo[m_songactiveline] = -1;
}



//---

BOOL CSong::Play(int mode, BOOL follow)
{
	if (m_play) Stop();

	switch (mode)
	{
	case 1: //cely song od zacatku vcetne inicializace (kvuli portamentum atd.)
		Atari_InitRMTRoutine();
		m_songplayline = 0;					
		m_trackplayline = 0;
		m_speed = m_mainspeed;
		break;
	case 2: //song od aktualniho mista
		m_songplayline = m_songactiveline;
		m_trackplayline = m_trackactiveline;
		break;
	case 3: //jen aktualni tracky porad dokola
Play3:
		m_songplayline = m_songactiveline;
		m_trackplayline = 0;
		break;
	case 4: //jen v bloku
		if (!g_trackcl.IsBlockSelected()) goto Play3;
		{
			int bfro,bto;
			g_trackcl.GetFromTo(bfro,bto);
			m_songplayline = g_trackcl.m_selsongline;
			m_trackplayline = m_trackplayblockstart = bfro;
			m_trackplayblockend = bto;
		}
		break;
	}
	WaitForTimerRoutineProcessed();
	m_50s = 0;
	m_followplay = follow;
	m_instrspeeda=0;
	g_screenupdate=1;
	PlayBeat();						//nastavuje m_speeda
	if (m_followplay)	//nasledovani prehravaneho
	{
		m_trackactiveline = m_trackplayline;
		m_songactiveline = m_songplayline;
	}

	m_play = mode;
	return 1;
}

BOOL CSong::Stop()
{
	m_play = 0;
	SetPlayPressedTonesSilence();
	//Sleep(100);	//nez se stop projevi
	WaitForTimerRoutineProcessed();		//ceka nez aspon jednou probehne cela TimerRoutine
	//Atari_Silence();
	//g_screenupdate=1;
	return 1;
}

BOOL CSong::SongPlayNextLine()
{
	m_trackplayline=0;
	if (m_play==1 || m_play==2)
	{	//normalni play a play od mista => posun
		m_songplayline++;
		if (m_songplayline>255) m_songplayline=0;
	}
	//pro vsechny (nezustane na goto radku)
	//Go to line ??
	if (m_songgo[m_songplayline]>=0)
		m_songplayline=m_songgo[m_songplayline];

	return 1;
}

BOOL CSong::PlayBeat()
{
	int t,tt,xline,len,go,speed;
	int note[SONGTRACKS],instr[SONGTRACKS],vol[SONGTRACKS];
	TTrack *tr;

	//m_play mode 4 => hraje jen rozsah v bloku
	if (m_play==4 && m_trackplayline>m_trackplayblockend) m_trackplayline=m_trackplayblockstart;

TrackLine:
	speed = m_speed;

	for(t=0; t<g_tracks4_8; t++)
	{
		note[t] = -1;
		instr[t] = -1;
		vol[t] = -1;
		tt = m_song[m_songplayline][t];
		if (tt<0) continue; //--
		tr = m_tracks.GetTrack(tt);
		len = tr->len;
		go = tr->go;
		if (m_trackplayline>=len)
		{
			if (go>=0) 
				xline = ((m_trackplayline-len) % (len-go)) + go;
			else
			{
				SongPlayNextLine();
				goto TrackLine;
			}
		}
		else
			xline = m_trackplayline;

		note[t] = tr->note[xline];
		instr[t] = tr->instr[xline];
		vol[t] = tr->volume[xline];
		if (tr->speed[xline]>0) speed=tr->speed[xline];
	}

	//teprve ted se nastavi zmenena rychlost
	m_speeda = m_speed = speed;

	//nastaveni aktivnich not,instrumentu a volume
	for(t=0; t<g_tracks4_8; t++)
	{
		int n=note[t];
		int i=instr[t];
		int v=vol[t];
		if (v>=0 && v<16)
		{
			if (n>=0 && n<NOTESNUM && i>=0 && i<INSTRSNUM)
			{
				//Atari_SetTrack_NoteInstrVolume(int t,int n,int i,int v)
				Atari_SetTrack_NoteInstrVolume(t,n,i,v);
			}
			else
			{
				//Atari_SetTrack_Volume(int t,int v)
				Atari_SetTrack_Volume(t,v);
			}
		}
	}

	return 1;
}

BOOL CSong::PlayVBI()
{
	if (!m_play) return 0;
	m_speeda--;
	if (m_speeda>0) return 0;

	m_trackplayline++;
	if (m_trackplayline>=m_tracks.m_maxtracklen)
		SongPlayNextLine();

	PlayBeat();

	if (m_followplay)	//nasledovani prehravaneho
	{
		m_trackactiveline = m_trackplayline;
		m_songactiveline = m_songplayline;
	}

	g_screenupdate=1;
	
	return 1;
}

void CSong::TimerRoutine()
{
	//MessageBeep(-1);
	//g_timerroutineprocessed=1;	//probehla TimerRoutine
	//return;

	m_50s ^= 1;

	if (m_50s)	//1vbi
	{
		//veci ktere se resi 1x za vbi
		PlayVBI();

		//tony na zaklade on-line stlacenych klaves
		PlayPressedTones();

		m_instrspeeda = 0;

	} //konec m_50s

	if (m_instrspeeda<=0)
	{
		//--- RMT - playovani instrumentuuu ---/
		if (g_rmtroutine) Atari_PlayRMT();			//jeden prubeh RMT rutinou

		m_pokey.MemToPokey(g_tracks4_8);			//prenos z g_atarimem do POKEYe (mono ci stereo)

		m_instrspeeda = 2-m_instrspeed;
	}
	else
	{
			m_instrspeeda--;
	}

	//--- Renderovani Soundu ---//
	m_pokey.RenderSound1_100();		//vyrendrovani kousku samplu (10ms)

	//MessageBeep(-1);
	//!!!!!!!!!!!!!!!!!!!!!!!!
	//MessageBeep(-1); g_timerroutineprocessed=1;	return; //probehla TimerRoutine

	//--- VYKRESLOVANI OBRAZU ---//

	if (g_screena>0)
		g_screena--;
	else
	{
		if (g_screenupdate) //Chce prekreslit?
		{
			//g_screenupdate=0;
			g_invalidatebytimer=1;
			AfxGetApp()->GetMainWnd()->Invalidate();
			//g_screena = g_screenwait se nastavuje v OnDraw
			//=>Dalsi prekresleni nejdrive po uplynuti g_screenwait
		}
	}


	g_timerroutineprocessed=1;	//probehla TimerRoutine

}

//A to je konec... taaa dy daaa, dy daaaaaaa.... :-)
