        .386p
code32  segment para public use32
        assume cs:code32, ds:code32, ss:code32

include pmode.inc
include argc.inc
include file.inc
include dfmpm.inc
include kb.inc
include vga50.inc

extrn   muzorderc:byte

public  _main, exit

;
; MAIN DATA
;

_hextbl db      '0123456789ABCDEF'

ht      db      15,13,01,'Renaissance 670 quickie composer, by Tran ofcourse...',0
        db      07,00,04,'As for the keys:',0
        db      07,01,05,24,', ',25,', PgUp, PgDn, Home, and End reformat your HD in all the menus.',0
        db      07,00,06,'These are common basic keys:',0
        db      07,01,07,'= and \ decrease and increase editing volume.',0
        db      07,01,08,'; and '' decrease and increase master tempo.',0
        db      07,01,09,'/ and * decrease and increase editing volume.',0
        db      07,02,10,'(A note on this, the octaves range from 0-3 for digital and 0-5 for FM)',0
        db      07,01,12,'Tab toggles stereo digital.',0
        db      07,01,13,'Shift-Tab toggles stereo FM.',0
        db      07,02,14,'(both start off as mono, however in stereo FM there are 9 extra channels',0
        db      07,03,15,'but in stereo digital, the existing 4 are just split up between l and r)',0
        db      07,01,17,'F5 plays the whole song.',0
        db      07,01,18,'F6 plays just the pattern youre editing at the moment.',0
        db      07,01,19,'F7 plays from the order the cursor is on in the order thingy.',0
        db      07,02,20,'(press any key during playback to stop)',0
        db      07,01,22,'F12 saves the song in full info mode. (you use this)',0
        db      07,01,23,'ALT-F12 saves the song as the data file that will actually be used by moi.',0
        db      07,01,27,'F4 takes ya to FM instrument menu thing.',0
        db      07,01,24,'F1 takes ya to the digital instrument menu.',0
        db      07,01,25,'F2 takes ya to the edit pattern menu or window or whatever.',0
        db      07,01,26,'F3 lets ya edit the order list, then blows out your VGA.',0
        db      07,01,28,'ALT-X destroys your computer...',0
        db      07,01,30,'Space in the instrument menu whatevers allows ya to select an instrument.',0
        db      07,01,31,'Enter be allowing ya to edit the instrument name.',0
        db      07,01,32,'. clears stuff in any menu...',0
        db      07,01,33,'- and + decrease and increase values in the FM instrument menu.',0
        db      07,01,34,'ALT-Backspace saves the instrument ya got currently selected.',0
        db      07,02,35,'(digital instruments are saved as filez, FM are saved in the bank file',0
        db      07,03,36,'which can hold up to 666 FM instruments. Thus make sure the digital',0
        db      07,03,37,'instrument namez are valid filenames before saving)',0
        db      07,01,40,'Umm, ok, U B on your own now... play wit this ting and figure it out for',0
        db      07,01,41,'yourself, I gotta finish coding it now... L8r...',0
        db      12,07,47,'Overall, this composer works pretty much like my other composers...',0
        db      12,05,48,'But for the sake of speed in coding this ting, it is a bare-bones thing.',0
        db      12,06,49,'There is very little error cheking and shit, so dont make any mistakes!',0
        db      0

l8rmsg          db      'L8r...$'
errmsg0         db      'CDFM <670 filename with no extention> <digital instrument directory> [-c#]$'

songfile        db      64 dup(?)
datafile        db      64 dup(?)
dinsdir         db      64 dup(?)
prgdir          db      64 dup(?)
fileworkbuf     db      64 dup(?)
extention670    db      '.C67',0
extentiondat    db      '.670',0
allfilemask     db      '*.*',0
fminsfile       db      'CDFM.DAT',0
fminsdat0       db      'Spaceguitar',0,0
                db      0,48,195,242,128,2,0,0,240,2,2

patbase         dd      ?               ; beginning of compiled patterns
patoffbase      dd      ?               ; pattern offset data
patlenbase      dd      ?               ; pattern length data
dinsbase        dd      ?               ; digital instrument data
dinsnames       dd      ?               ; names of digital instruments
fminsbase       dd      ?               ; FM instrument data
fminsnames      dd      ?               ; names of FM instruments
fminsbank       dd      ?               ; ptr to bank file of FM instruments
ordbase         dd      ?               ; ptr to order list
workpatptr      dd      ?               ; ptr to workpattern
buildpat        dd      ?               ; ptr to build pattern buffer
dinsfilez       dd      ?               ; ptr to cached digital filenames
worktrak        dd      ?               ; ptr to single worktrack
savetrak        dd      ?               ; ptr to save buffer

vgacolorz:
        db      21,19,3, 42,22,0, 26,39,33, 48,35,9, 24,21,4, 35,10,37
        db      4,23,31, 40,38,22, 30,28,12, 63,24,14, 37,63,44
        db      59,50,29, 0,29,56, 53,12,61, 15,48,56, 60,59,56
        db      3,21,19, 0,42,22, 33,26,39, 9,48,35, 4,23,21, 37,35,10
        db      31,4,23, 22,40,38, 12,30,28, 14,63,24, 44,37,63
        db      29,59,50, 56,0,29, 61,53,12, 56,15,48, 56,60,59
        db      19,3,21, 22,0,42, 39,33,26, 35,9,48, 21,4,23, 10,37,35
	db	23,31,4, 38,22,40, 28,12,30, 24,14,63, 63,44,37
	db	50,29,59, 29,56,0, 12,61,53, 48,56,15, 59,56,60
        db      0,3,12, 0,0,31, 0,31,0, 0,31,42, 1,5,15, 38
        db      0,31,31, 21,0,9, 39,49,21, 21,21,10, 21,53,10, 44
        db      21,10,42, 63,53,21, 10,44,21, 51,56,46, 10,20,53, 63
        db      0, 0, 10, 0, 0, 24, 0, 22, 19, 0, 25, 28, 1, 2, 13, 24
        db      5, 22, 20, 17, 13, 0, 24, 33, 2, 24, 38, 16, 24, 41, 0, 32
        db      28, 0, 34, 38, 38, 19, 19, 34, 7, 31, 36, 32, 12, 32, 43, 56
        db      19, 0, 0, 25, 0, 0, 31, 0, 0, 37, 0, 0, 22, 2, 1, 50
        db      0, 0, 56, 0, 0, 63, 0, 0, 63, 0, 0, 63, 8, 0, 63, 17
        db      0, 63, 26, 0, 63, 35, 0, 63, 44, 0, 63, 53, 0, 63, 63, 0
        db      2, 16, 21, 3, 18, 23, 6, 21, 26, 8, 24, 29, 3, 18, 24, 14
        db      29, 35, 17, 32, 37, 21, 35, 40, 25, 38, 43, 29, 42, 46, 34, 45
        db      49, 39, 48, 51, 44, 52, 54, 50, 55, 57, 56, 59, 60, 63, 63, 63

;
; BEGINNING, MISC, AND CODE
;
include textmode.rt
include putnumtm.rt
include strcpy.rt
include strcat.rt
include strlen.rt
include strltu.rt
include strhtn.rt
include indxword.rt
include indxbyte.rt
include copymem.rt
include pdosmsg.rt

;
exitsave:                               ; exit and save FM instrument bank
        mov edi,offset fileworkbuf
        mov esi,offset prgdir
        call _strcpy
        mov esi,offset fminsfile
        call _strcat
        mov edx,edi
        call _createfile
        mov edx,offset fminsnum
        mov ecx,2
        call _writefile
        mov edx,fminsbank
        imul cx,fminsnum,24
        call _writefile
        call _closefile
exit1:                                  ; exit with L8r msg
        mov edx,offset l8rmsg
        jmp short exit
exit0:                                  ; exit cuz commandline be not right
        mov edx,offset errmsg0
exit:                                   ; exit with a message
        push edx
        call _resetkb
        call _uninstall_dfm
        call _text_mode
        pop edx
        call _putdosmsg
        jmp _exit
;
_main:                                  ; beginning of program............
        mov ax,220h
        mov bl,5
        mov bh,1

        add ax,0ch
        mov _sbport,ax
        mov _sbirq,bl
;        mov _sbdma,bh

;        mov _sbport,530h
;        mov _sbirq,10
;        mov _sbdma,3
;        mov _scard,1101b

        sti
        call _initkb
        mov al,1001b
        call _install_dfm
        call allocbuffers
        call setdirs
        call setupscreen
        call cachedins
        call loadfmins
        call clearsong
        call loadsong
;        call _getch
;        jmp exit1

        mov eax,dinsfilez
        mov selbps,eax
        mov eax,fminsbank
        mov selbps[4],eax
        jmp editins1

;-----------------------------------------------------------------------------
setdirs:                                ; set and chek files and dirs
        mov ebp,offset extention670
        mov edx,offset songfile
        call setdirsrout
        mov ebp,offset extentiondat
        mov edx,offset datafile
        call setdirsrout
        mov al,1
        mov edx,offset dinsdir
        call _cchekstr
        jc exit0
        mov ax,18h
        mov es,ax
        mov edi,_code16a
        sub edi,0d4h
        movzx edi,word ptr es:[edi]
        shl edi,4
        mov ecx,-1
        xor al,al
setdirsl0:
        repnz scasb
        scasb
        jnz setdirsl0
        add edi,2
        mov esi,edi
        mov ecx,edi
setdirsl1:
        mov al,es:[edi]
        inc edi
        or al,al
        jz short setdirsl1d
        cmp al,'\'
        jne setdirsl1
        mov ecx,edi
        jmp setdirsl1
setdirsl1d:
        mov ax,ds
        mov bx,es
        mov ds,bx
        mov es,ax
        sub ecx,esi
        mov edi,offset prgdir
        rep movsb
        xor al,al
        stosb
        mov ax,es
        mov ds,ax
        ret
;-----------------------------------------------------------------------------
setdirsrout:
        xor al,al
        call _cchekstr
        jc exit0
        mov edi,edx
        mov esi,ebp
        jmp _strcat
;-----------------------------------------------------------------------------
allocbuffers:                           ; set up buffers
        mov eax,4000h
        call _getmem
        mov _filebufloc,eax
        mov eax,60000h
        call _getmem
        mov patbase,eax
        mov eax,4353
        call _getmem
        mov buildpat,eax
        mov eax,11*32
        call _getmem
        mov fminsbase,eax
        mov eax,13*32
        call _getmem
        mov fminsnames,eax
        mov eax,4*4*32
        call _getmem
        mov dinsbase,eax
        mov eax,13*32
        call _getmem
        mov dinsnames,eax
        mov eax,4*128
        call _getmem
        mov patoffbase,eax
        mov eax,4*128
        call _getmem
        mov patlenbase,eax
        mov eax,256
        call _getmem
        mov ordbase,eax
        mov eax,22*2*64
        call _getmem
        mov workpatptr,eax
        mov eax,666*24
        call _getmem
        mov fminsbank,eax
        mov eax,2048*13
        call _getmem
        mov dinsfilez,eax
        mov eax,128
        call _getmem
        mov worktrak,eax
        mov eax,128
        call _getmem
        mov savetrak,eax
        ret
;-----------------------------------------------------------------------------
loadfmins:                              ; load or create FM instruments
	mov esi,offset prgdir
        mov edi,offset fileworkbuf
	call _strcpy
        mov esi,offset fminsfile
	call _strcat
	mov edx,edi
	call _openfile
	jc short loadfminsf0
	mov edx,offset fminsnum
	mov ecx,2
	call _readfile
	movzx ecx,fminsnum
	imul ecx,24
        mov edx,fminsbank
	call _readfile
	call _closefile
	ret
loadfminsf0:
        mov esi,offset fminsdat0
        mov edi,fminsbank
        mov ecx,24
        rep movsb
	ret
;-----------------------------------------------------------------------------
setupscreenstr  db      'Name',0
setupscreen:                            ; setup VGA and clear screen
        mov al,'c'
        mov edx,offset fileworkbuf
        call _ccheksstr
        jc short setupscreenf0
        movzx esi,fileworkbuf
        sub esi,'0'
        imul esi,30h
        mov ecx,0ch
        add esi,offset vgacolorz
        mov edi,offset _vgadefcolorz
        rep movsd
setupscreenf0:
        call _initvga50
        mov edi,_vgatextptr
        mov eax,10201020h
        mov ecx,40*50
        rep stosd
        mov bx,4
        mov ah,19h
        mov edx,offset setupscreenstr
        call _putstr
        ret
;-----------------------------------------------------------------------------
cachedins:                              ; cache filenames in dinsdir
        mov esi,offset dinsdir
        mov edi,offset fileworkbuf
        call _strcpy
        mov esi,offset allfilemask
        call _strcat
        add edi,_code32a
        mov eax,edi
        and di,0fh
        mov v86r_dx,di
        shr eax,4
        mov v86r_ds,ax
        mov v86r_cx,0
        mov ebp,_code16a
        sub ebp,62h
        mov edi,dinsfilez
        mov v86r_ah,4eh
        jmp short cachedinsf0
cachedinsml:
        mov v86r_ah,4fh
cachedinsf0:
        mov al,21h
        int 33h
        test v86r_flags,1
        jnz short cachedinsd
        mov esi,ebp
        mov ax,18h
        mov ds,ax
        movsd
        movsd
        movsd
        movsb
        mov ax,es
        mov ds,ax
        inc dinsnum
        jmp cachedinsml
cachedinsd:
        mov ebp,dinsfilez
        mov cx,dinsnum
        jmp alph
;-----------------------------------------------------------------------------
loadsong:                               ; load 670 specified if exists
        mov edx,offset songfile
        call _openfile
        jc _ret
        mov edx,offset mztempo
        mov ecx,1
        call _readfile
        mov edx,offset mzloop
        call _readfile
        mov edx,dinsnames
        mov ecx,13*32
        call _readfile
        mov edx,dinsbase
        mov ecx,16*32
        call _readfile
        mov edx,fminsnames
        mov ecx,13*32
        call _readfile
        mov edx,fminsbase
        mov ecx,11*32
        call _readfile
        mov edx,ordbase
        mov ecx,100h
        call _readfile
        mov ecx,4*128
        mov edx,patoffbase
        call _readfile
        mov ebx,[edx+4*127]
        mov edx,patlenbase
        call _readfile
        add ebx,[edx+4*127]
        mov edx,patbase
        mov ecx,ebx
        call _readfile
;        @rlp edx,100000h
        mov edx,_himembase
        mov ecx,1000000h
        call _readfile
        call _closefile
        push offset putall
        jmp resetdinslens

;
; COMPOSER SPECIFIC DATA
;
nkeylist        db      24,'zsxdcvgbhnjmq2w3er5t6y7u'
numlist         db      16,'0123456789ABCDEF'

installword     dw      1001b
zeroforplay     db      0
maxvoiceb       db      2
smpbase         dd      ?
dinsnum         dw      0
fminsnum        dw      1               ; number of FM instruments in bank

mztempo         db      ?               ; tempo of muzik
svnord          db      ?
svnpat          db      ?
svndins         db      ?
svnfmins        db      ?
mzloop          db      ?               ; muzik loop
svdinsoff       dd      ?
mzbreak         db      ?               ; break for this pattern

edpat           db      ?               ; current pattern
edvol           db      ?               ; current volume
edoct           db      ?               ; editing octave
edvoiceb        db      ?               ; editing voice base
edvoiceo        db      ?               ; editing voice offset
edrowb          db      ?               ; editing row base
edrowo          db      ?               ; editing row offset
edinsb          db      ?               ; editing instrument base
edinso          db      ?               ; editing instrument offset
edordb          db      ?               ; editing order base
edordo          db      ?               ; editing order offset
edfmval         db      ?               ; editing FM value

edblkb          db      -1
edblke          db      -1
edblkl          db      -1

;
; COMPOSER CODE
;

;
setdinslens:
        mov ebx,dinsbase
        mov ecx,32
setdinslensml:
        mov eax,[ebx]
        sub [ebx+4],eax
        sub [ebx+8],eax
        sub [ebx+12],eax
        mov dword ptr [ebx],0
        add ebx,10h
        loop setdinslensml
        ret
;
resetdinslens:
;        @rlp eax,100000h
        mov eax,_himembase
        mov ebx,dinsbase
        mov ecx,32
resetdinslensml:
        mov edx,[ebx+4]
        or edx,edx
        jz short resetdinslensmlc
        mov [ebx],eax
        add [ebx+8],eax
        add [ebx+12],eax
        add eax,edx
        mov [ebx+4],eax
resetdinslensmlc:
        add ebx,10h
        loop resetdinslensml
        ret

;
adjoct:
        cmp edoct,4
        jb _ret
        mov edoct,3
        ret

;
calcloc:
        movzx eax,edrowb
        add al,edrowo
        imul edi,eax,44
        movzx eax,edvoiceb
        add al,edvoiceo
        lea edi,[edi+eax*2]
        add edi,workpatptr
        ret

;
boxgrfx db      'ͺɻȼ '
playstr db      'Playing...',0
play:
        mov bx,1822h
        mov cx,60fh
        call _pushtext
        add bx,101h
        sub cx,101h
        mov ax,20h
        call _textbox0
        sub bx,101h
        mov edx,offset boxgrfx
        mov ah,87h
        call _textbox1
        add bx,202h
        mov edx,offset playstr
        mov ah,8fh
        call _putstr
        mov al,mztempo
        mov muztempo,al
        mov eax,dinsbase
        mov muzsbinsptr,eax
        mov eax,fminsbase
        mov muzfminsptr,eax
        mov eax,patbase
        mov muzpatbase,eax
        call _setmuzik
        call _getch
        call _stopmuzik
        call _poptext
        ret

;
howmanyorders:
        xor ah,ah
        mov esi,ordbase
howmanyordersml:
        lodsb
        cmp al,-1
        je short howmanyordersd
        inc ah
        jmp howmanyordersml
howmanyordersd:
        mov al,ah
        ret

;
calcloc2:
        mov bh,edrowo
        add bh,16
        movzx eax,edvoiceo
        imul eax,7
        mov bl,al
        add bl,3
        ret

;
setins:
        xor bl,bl
        mov bh,al
        cmp al,14h
        jb short setinsf0
        mov bl,al
        sub bl,13h
        mov bh,13h
setinsf0:
        mov edinsb,bh
        mov edinso,bl
        ret

;
gettrak:
        movzx eax,edvoiceb
        add al,edvoiceo
        lea esi,[eax*2]
        add esi,workpatptr
        mov edi,worktrak
        mov ecx,64
gettrakml:
        movsw
        add esi,42
        loop gettrakml
        ret
;
puttrak:
        movzx eax,edvoiceb
        add al,edvoiceo
        lea edi,[eax*2]
        add edi,workpatptr
        mov esi,worktrak
        mov ecx,64
puttrakml:
        movsw
        add edi,42
        loop puttrakml
        ret

;
calc3:
        call gettrak
        mov edi,worktrak
        movzx ebx,edblkb
        or bl,bl
        js ret2
        lea edi,[edi+ebx*2]
        movzx ecx,edblke
        or cl,cl
        js ret2
        sub cl,bl
        inc cl
        ret
ret2:
        add esp,4
        ret

;
inputlist       db      19
                dw      278h,'*','/','=','\',12ch,12eh,';','''',0fh,10fh
                dw      13fh,8,6,5,7,12,20ch
inputrout       dd      exitsave,incoct,decoct,decvol,incvol,decloop,incloop
                dd      dectempo,inctempo,togglesd,togglesfm,help,_stopmuzik
                dd      playpat,playsong,playord,savesong,savedata
getinput:                               ; regular high get input routine
        call _getch
        mov edx,offset inputlist
        call _indexword
        jc _ret
        call inputrout[eax*4]
        jmp getinput
;-----------------------------------------------------------------------------
incoct:
        mov ah,1
        jmp short changeoct
;-----------------------------------------------------------------------------
decoct:
        mov ah,-1
changeoct:
        mov al,edoct
        add al,ah
        js _ret
        cmp al,6
        ja _ret
        mov edoct,al
        jmp putstat
;-----------------------------------------------------------------------------
incvol:
        mov ah,1
        jmp short changevol
;-----------------------------------------------------------------------------
decvol:
        mov ah,-1
changevol:
        mov al,edvol
        add al,ah
        js _ret
        cmp al,0fh
        ja _ret
        mov edvol,al
        jmp putstat
;-----------------------------------------------------------------------------
incloop:
        mov ah,1
        jmp short changeloop
;-----------------------------------------------------------------------------
decloop:
        mov ah,-1
changeloop:
        mov al,mzloop
        add al,ah
        js _ret
        cmp al,7fh
        ja _ret
        mov mzloop,al
        jmp putstat
;-----------------------------------------------------------------------------
inctempo:
        mov ah,1
        jmp short changetempo
;-----------------------------------------------------------------------------
dectempo:
        mov ah,-1
changetempo:
        mov al,mztempo
        add al,ah
        jz _ret
        cmp al,0fh
        ja _ret
        mov mztempo,al
        jmp putstat
;-----------------------------------------------------------------------------
togglesd:
        xor installword,100b
togglereinstall:
        mov ax,installword
        jmp _install_dfm
;-----------------------------------------------------------------------------
togglesfm:
;       xor maxvoiceb,9
;       mov edvoiceb,0
        xor installword,11b
        jmp togglereinstall
;-----------------------------------------------------------------------------
help:
        xor ebx,ebx
        mov cx,3250h
        call _pushtext
        mov ax,0f20h
        call _textbox0
        mov esi,offset ht
helploop:
        lodsb
        or al,al
        jz helpdone
        mov ah,al
        lodsb
        mov bl,al
        lodsb
        mov bh,al
        mov edx,esi
        call _putstr
        mov edi,esi
        mov ecx,-1
        xor al,al
        repnz scasb
        mov esi,edi
        jmp helploop
helpdone:
        call _getch
        call _poptext
        ret
;-----------------------------------------------------------------------------
playpat:
        call setpat
        mov muzordptr,offset zeroforplay
        mov muzordern,1
        mov muzorderl,0
        movzx eax,edpat
        shl eax,2
        add eax,patoffbase
        mov muzpatoffptr,eax
        mov muzorderc,0
        jmp play
;-----------------------------------------------------------------------------
playsong:
        xor al,al
        jmp short playfrom
playord:
        mov al,edordb
        add al,edordo
playfrom:
        dec al
        mov muzorderc,al
        call setpat
        call howmanyorders
        mov muzordern,al
        mov al,mzloop
        mov muzorderl,al
        mov eax,ordbase
        mov muzordptr,eax
        mov eax,patoffbase
        mov muzpatoffptr,eax
        jmp play
;-----------------------------------------------------------------------------
savesong:
        call setdinslens
        call setpat
        mov edx,offset songfile
        call _createfile
        mov edx,offset mztempo
        mov ecx,1
        call _writefile
        mov edx,offset mzloop
        call _writefile
        mov edx,dinsnames
        mov ecx,13*32
        call _writefile
        mov edx,dinsbase
        mov ecx,16*32
        call _writefile
        mov edx,fminsnames
        mov ecx,13*32
        call _writefile
        mov edx,fminsbase
        mov ecx,11*32
        call _writefile
        mov edx,ordbase
        mov ecx,100h
        call _writefile
        mov ecx,4*128
        mov edx,patoffbase
        mov ebx,[edx+4*127]
        call _writefile
        mov edx,patlenbase
        add ebx,[edx+4*127]
        call _writefile
        mov edx,patbase
        mov ecx,ebx
        call _writefile
;        @rlp edx,100000h
        mov edx,_himembase
        mov ecx,smpbase
        sub ecx,edx
        call _writefile
        call _closefile
        jmp resetdinslens
;-----------------------------------------------------------------------------
svpatlen        dd      ?
svrouttbl       dd      savedatan,savedata1,savedata1,_ret
savedata:
        call setpat
        call howmanyorders
        or al,al
        jz _ret
        mov svnord,al
        movzx ecx,al
        mov esi,ordbase
        xor ah,ah
savedatal0:
        lodsb
        cmp al,ah
        jbe short savedatal0c
        mov ah,al
savedatal0c:
        loop savedatal0
        movzx ebp,ah
        inc ah
        mov svnpat,ah
        lea eax,[ebp*4]
        add eax,patoffbase
        mov edi,[eax]
        lea eax,[ebp*4]
        add eax,patlenbase
        add edi,[eax]
        mov svpatlen,edi
        mov esi,patbase
        add edi,esi
        mov edx,-1
savedatal1:
        lodsb
        movzx ebx,al
        shr bl,5
        call svrouttbl[ebx*4]
        cmp esi,edi
        jb savedatal1
        jmp short savedatal1d
savedata1:
        inc esi
        ret
savedatan:
        mov bl,al
        and bl,1fh
        lodsw
        xchg ah,al
        shr ah,7
        shr eax,4
        cmp bl,3
        ja short savedatanfm
        cmp al,dl
        jle _ret
        mov dl,al
        ret
savedatanfm:
        cmp al,dh
        jle _ret
        mov dh,al
        ret
savedatal1d:
        inc dh
        inc dl
        mov svndins,dl
        mov svnfmins,dh
        movzx eax,dl
        shl eax,4
        movzx ebx,dh
        imul ebx,11
        add eax,svpatlen
        lea eax,[eax+ebx+10]
        movzx ebx,svnord
        add eax,ebx
        movzx ebx,svnpat
        lea eax,[eax+ebx*4]
        mov svdinsoff,eax
        mov edi,workpatptr
        mov esi,dinsbase
        mov ecx,32
savedatal2:
        xor eax,eax
        stosd
        lodsd
        mov ebx,eax
        lodsd
        sub eax,ebx
        stosd
        lodsd
        sub eax,ebx
        stosd
        lodsd
        sub eax,ebx
        stosd
        loop savedatal2
        mov edx,offset datafile
        call _createfile
        mov edx,offset mztempo
        mov ecx,10
        call _writefile
        mov edx,ordbase
        movzx ecx,svnord
        call _writefile
        mov edx,patoffbase
        movzx ecx,svnpat
        shl ecx,2
        call _writefile
        mov edx,workpatptr
        movzx ecx,svndins
        shl ecx,4
        call _writefile
        mov edx,fminsbase
        movzx ecx,svnfmins
        imul ecx,11
        call _writefile
        mov edx,patbase
        mov ecx,svpatlen
        call _writefile
        movzx eax,svndins
        or al,al
        jz getpat
        dec eax
        shl eax,4
        add eax,dinsbase
        mov ecx,[eax+4]
;        @rlp edx,100000h
        mov edx,_himembase
        sub ecx,edx
        call _writefile
        jmp _closefile

;
editordlist     db      14
                dw      25,26,21,22,19,20,13,32,'.',1,4,2,17,18
editordrout     dd      eoup,eodn,eopgup,eopgdn,eohome,eoend,eoed,eoed,eoclear
                dd      eof1,eof2,eof3,eoins,eodel
editord:
        call putstat
        call putord
        call putordcur
        call getinput
        mov edx,offset editordlist
        call _indexword
        jc editord
        call editordrout[eax*4]
        jmp editord
;-----------------------------------------------------------------------------
eoup:
        mov ah,-1
        jmp short eoupdn
;-----------------------------------------------------------------------------
eodn:
        mov ah,1
eoupdn:
        mov al,edordo
        add al,ah
        js eopgupdn
        cmp al,0ch
        ja eopgupdn
        mov edordo,al
        ret
;-----------------------------------------------------------------------------
eopgup:
        mov ah,-0dh
        jmp short eopgupdn
;-----------------------------------------------------------------------------
eopgdn:
        mov ah,0dh
eopgupdn:
        mov al,edordb
        add al,ah
        jc short eopgupdnf2
        or ah,ah
        js short eopgupdnf1
        cmp al,0f4h
        jb short eopgupdnf0
eopgupdnf3:
        mov edordb,0f3h
        ret
eopgupdnf1:
        mov edordb,0
        ret
eopgupdnf2:
        or ah,ah
        jns eopgupdnf3
eopgupdnf0:
        mov edordb,al
        ret
;-----------------------------------------------------------------------------
eohome:
        mov edordo,0
        ret
;-----------------------------------------------------------------------------
eoend:
        mov edordo,0ch
        ret
;-----------------------------------------------------------------------------
eoed:
        mov bh,edordo
        add bh,1
        mov bl,77
        mov cl,2
        call getnum
        jc _ret
        movzx ebx,edordb
        add bl,edordo
        add ebx,ordbase
        and al,7fh
        mov [ebx],al
        jmp eodn
;-----------------------------------------------------------------------------
eoclear:
        movzx ebx,edordb
        add bl,edordo
        add ebx,ordbase
        mov byte ptr [ebx],-1
        jmp eodn
;-----------------------------------------------------------------------------
eof1:
        add esp,4
        call putord
        jmp editins0
;-----------------------------------------------------------------------------
eof2:
        add esp,4
        call putord
        jmp editins1
;-----------------------------------------------------------------------------
eof3:
        add esp,4
        call putord
        jmp editpat
;-----------------------------------------------------------------------------
eoins:
        mov eax,offset ins
        jmp short eoid
;-----------------------------------------------------------------------------
eodel:
        mov eax,offset del
eoid:
        mov ebp,ordbase
        movzx bx,edordb
        add bl,edordo
        mov dx,100h
        mov ecx,1
        call eax
        mov byte ptr [edi],-1
        ret

;
editins0list    db      17
                dw      4,2,3,25,26,21,22,19,20,13,'[',']',32,'.',17,18,210h
editins0rout    dd      esf2,esf3,esf4,eiup,eidn,eipgup,eipgdn,eihome,eiend
                dd      esgetname,eslbeg,eslend,esload,esclearins,esins,esdel
                dd      esaddins
editins0:
        call putstat
        call putins0
        call putins0cur
        call getinput
        mov edx,offset editins0list
        call _indexword
        jc short editins0f0
        call editins0rout[eax*4]
        jmp editins0
editins0f0:
        or ah,ah
        jnz editins0
        mov edx,offset nkeylist
        call _indexbyte
        jc editins0
        movzx edx,edinsb
        add dl,edinso
        shl edx,4
        add edx,dinsbase
        mov bl,edvol
        mov ah,al
        cmp ah,12
        jb short editins0f1
        add ah,10h-12
editins0f1:
        call adjoct
        mov al,edoct
        shl al,4
        add ah,al
        xor al,al
        mov ebp,[edx+4]
        mov esi,[edx]
        mov ecx,[edx+8]
        mov edx,[edx+12]
        call _sbnote
        jmp editins0

;-----------------------------------------------------------------------------
esf4:
        add esp,4
        call putins0
        jmp editord
;-----------------------------------------------------------------------------
esf2:
        add esp,4
        call putins0
        jmp editins1
;-----------------------------------------------------------------------------
esf3:
        add esp,4
        call putins0
        jmp editpat
;-----------------------------------------------------------------------------
esgetname:
        call putins0
        mov ax,8a00h
        mov bx,104h
        add bh,edinso
        mov cl,12
        movzx edx,edinsb
        add dl,edinso
        imul edx,13
        add edx,dinsnames
        mov ebp,offset editinsaccept
        call _getstr
        ret
;-----------------------------------------------------------------------------
eslbeg:
        mov edx,8
        mov bl,17
        jmp short eslnum
;-----------------------------------------------------------------------------
eslend:
        mov edx,12
        mov bl,23
eslnum:
        push edx
        mov bh,edinso
        inc bh
        mov cl,5
        call getnum
        pop edx
        jc _ret
        movzx ebx,edinsb
        add bl,edinso
        shl ebx,4
        add ebx,dinsbase
        add eax,[ebx]
        mov [ebx+edx],eax
        ret
;-----------------------------------------------------------------------------
esload:
        mov edx,dinsfilez
        movzx ecx,dinsnum
        mov seli,0
        call select
        jc _ret
        movzx ebx,edinsb
        add bl,edinso
        mov edi,offset fileworkbuf
        mov esi,offset dinsdir
        call _strcpy
        imul esi,eax,13
        add esi,dinsfilez
        call _strcat
        mov edx,edi
        imul edi,ebx,13
        add edi,dinsnames
        movsd
        movsd
        movsd
        movsb
        call _openfile
        call _filesize
        mov ecx,eax
        mov edx,smpbase
        shl ebx,4
        add ebx,dinsbase
        mov [ebx],edx
        mov [ebx+8],edx
        add eax,edx
        mov [ebx+4],eax
        lea eax,[edx+0ffffffh]
        mov [ebx+12],eax
        call _readfile
        call _closefile
        jmp adjsmp
;-----------------------------------------------------------------------------
esclearins:
        movzx ebx,edinsb
        add bl,edinso
        mov edi,ebx
        shl edi,4
        add edi,dinsbase
        xor eax,eax
        stosd
        stosd
        stosd
        mov dword ptr [edi],0ffffffh
        imul ebx,13
        add ebx,fminsnames
        mov byte ptr [ebx],0
        call adjsmp
        jmp eidn
;-----------------------------------------------------------------------------
esins:
        mov idcall,offset ins
        jmp short esid
;-----------------------------------------------------------------------------
esdel:
        mov idcall,offset del
esid:
        mov dx,20h
        movzx bx,edinsb
        add bl,edinso
        mov ebp,dinsnames
        mov ecx,13
        push bx
        push dx
        call idcall
        pop dx
        pop bx
        mov byte ptr [edi],0
        mov ebp,dinsbase
        mov ecx,16
        call idcall
        xor eax,eax
        stosd
        stosd
        stosd
        mov dword ptr [edi],0ffffffh
        jmp adjsmp
;-----------------------------------------------------------------------------
esaddins:
        movzx eax,edinsb
        add al,edinso
        imul esi,eax,13
        add esi,dinsnames
        mov edi,offset errmsg0
        call _strcpy
        mov edx,edi
        call _strltu
        mov ebp,edx
        movzx ebx,dinsnum
        mov esi,dinsfilez
        call alphfind
        jc _ret
        mov bx,ax
        mov dx,dinsnum
        inc dx
        mov dinsnum,dx
        mov ecx,13
        mov ebp,dinsfilez
        call ins
        mov esi,offset errmsg0
        movsd
        movsd
        movsd
        movsb
        mov esi,offset dinsdir
        mov edi,offset fileworkbuf
        call _strcpy
        mov esi,offset errmsg0
        call _strcat
        mov edx,edi
        call _createfile
        movzx eax,edinsb
        add al,edinso
        shl eax,4
        add eax,dinsbase
        mov edx,[eax]
        mov ecx,[eax+4]
        sub ecx,edx
        call _writefile
        call _closefile
        ret

;
editinsaccept   db      editins1list-editinsaccept,'QWERTYUIOPASDFGHJKLZXCVBNM'
                db      'qwertyuiopasdfghjklzxcvbnm1234567890 !_?,.()-'
editins1list    db      19
                dw      25,26,23,24,'+','-',21,22,32,13,19,20,'.',210h,1,2,3
                dw      17,18
editins1rout    dd      eiup,eidn,eivald,eivalu,eiincval,eidecval
                dd      eipgup,eipgdn,eigetins,eigetname,eihome,eiend
                dd      eiclearins,eiaddins,eif1,eif3,eif4,eiins,eidel
editins1:
        call putstat
        call putins1
        call putins1cur
        call getinput
        mov edx,offset editins1list
        call _indexword
        jc short editins1f0
        call editins1rout[eax*4]
        jmp editins1
editins1f0:
        or ah,ah
        jnz editins1
        mov edx,offset nkeylist
        call _indexbyte
        jc editins1
        movzx edx,edinsb
        add dl,edinso
        imul edx,11
        add edx,fminsbase
        mov bl,edvol
        mov ah,al
        cmp ah,12
        jb short editins1f1
        add ah,10h-12
editins1f1:
        mov al,edoct
        shl al,4
        add ah,al
        xor al,al
        call _fmnote
        mov al,9
        call _fmnote
        jmp editins1
;-----------------------------------------------------------------------------
eiup:
        mov ah,-1
        jmp short eiupdn
;-----------------------------------------------------------------------------
eidn:
        mov ah,1
eiupdn:
        mov al,edinso
        add al,ah
        js eipgupdn
        cmp al,0ch
        ja eipgupdn
        mov edinso,al
        ret
;-----------------------------------------------------------------------------
eipgup:
        mov ah,-0dh
        jmp short eipgupdn
;-----------------------------------------------------------------------------
eipgdn:
        mov ah,0dh
eipgupdn:
        mov al,edinsb
        add al,ah
        jns short eipgupdnf0
        mov edinsb,0
        ret
eipgupdnf0:
        cmp al,14h
        jb short eipgupdnf1
        mov al,13h
eipgupdnf1:
        mov edinsb,al
        ret
;-----------------------------------------------------------------------------
eivald:
        mov ah,-1
        jmp short eichangeval
;-----------------------------------------------------------------------------
eivalu:
        mov ah,1
eichangeval:
        mov al,edfmval
        add al,ah
        js _ret
        cmp al,25
        ja _ret
        mov edfmval,al
        ret
;-----------------------------------------------------------------------------
eiincval:
        mov bl,1
        jmp short eiincdecval
;-----------------------------------------------------------------------------
eidecval:
        mov bl,-1
eiincdecval:
        mov ah,edinsb
        add ah,edinso
        mov al,edfmval
        call getfminsval
        add bl,al
        mov al,edfmval
        call setfminsval
        ret
;-----------------------------------------------------------------------------
eigetname:
        call putins1
        mov ax,8a00h
        mov bx,104h
        add bh,edinso
        mov cl,12
        movzx edx,edinsb
        add dl,edinso
        imul edx,13
        add edx,fminsnames
        mov ebp,offset editinsaccept
        call _getstr
        ret
;-----------------------------------------------------------------------------
eihome:
        mov edinso,0
        ret
;-----------------------------------------------------------------------------
eiend:
        mov edinso,0ch
        ret
;-----------------------------------------------------------------------------
eigetins:
        mov edx,fminsbank
        movzx ecx,fminsnum
        mov seli,1
        call select
        jc _ret
        movzx ebx,edinsb
        add bl,edinso
        imul edi,ebx,13
        add edi,fminsnames
        imul esi,eax,13
        add esi,fminsbank
        movsd
        movsd
        movsd
        movsb
        imul edi,ebx,11
        add edi,fminsbase
        movzx ebx,fminsnum
        imul ebx,13
        imul esi,eax,11
        add esi,fminsbank
        add esi,ebx
        movsd
        movsd
        movsw
        movsb
        ret
;-----------------------------------------------------------------------------
eiclearins:
        movzx ebx,edinsb
        add bl,edinso
        imul edi,ebx,11
        add edi,fminsbase
        xor eax,eax
        stosd
        stosd
        stosw
        stosb
        imul ebx,13
        add ebx,fminsnames
        mov byte ptr [ebx],0
        jmp eidn
;-----------------------------------------------------------------------------
eif1:
        add esp,4
        call putins1
        jmp editins0
;-----------------------------------------------------------------------------
eif3:
        add esp,4
        call putins1
        jmp editpat
;-----------------------------------------------------------------------------
eif4:
        add esp,4
        call putins1
        jmp editord
;-----------------------------------------------------------------------------
idcall  dd      ?
eiins:
        mov idcall,offset ins
        jmp short eiid
;-----------------------------------------------------------------------------
eidel:
        mov idcall,offset del
eiid:
        mov dx,20h
        movzx bx,edinsb
        add bl,edinso
        mov ebp,fminsnames
        mov ecx,13
        push bx
        push dx
        call idcall
        pop dx
        pop bx
        mov byte ptr [edi],0
        mov ebp,fminsbase
        mov ecx,11
        call idcall
        xor eax,eax
        stosd
        stosd
        stosw
        stosb
        ret
;-----------------------------------------------------------------------------
eiaddinsbase    dd      ?
eiaddinsindx    dw      ?
eiaddins:
        movzx eax,edinsb
        add al,edinso
        movzx ebx,fminsnum
        mov esi,fminsbank
        imul ebp,eax,13
        add ebp,fminsnames
        call alphfind
        jc eiaddinsf0
        mov eiaddinsindx,ax
        movzx edi,fminsnum
        imul ecx,edi,11
        inc edi
        mov fminsnum,di
        imul edi,13
        add edi,fminsbank
        mov esi,edi
        sub esi,13
        mov eiaddinsbase,edi
        call _copymem
        mov dx,fminsnum
        mov bx,eiaddinsindx
        mov ecx,13
        mov ebp,fminsbank
        call ins
        movzx eax,edinsb
        add al,edinso
        imul esi,eax,13
        add esi,fminsnames
        movsd
        movsd
        movsd
        movsb
        mov dx,fminsnum
        mov bx,eiaddinsindx
        mov ecx,11
        mov ebp,eiaddinsbase
        call ins
eiaddinsf1:
        movzx eax,edinsb
        add al,edinso
        imul esi,eax,11
        add esi,fminsbase
        movsd
        movsd
        movsw
        movsb
        ret
eiaddinsf0:
        movzx edi,fminsnum
        imul edi,13
        imul eax,11
        add edi,eax
        add edi,fminsbank
        jmp eiaddinsf1

;
editpatlist     db      34
                dw      1,4,3,25,26,21,22,19,20,23,24,'[',']','.','-','+',13
                dw      621,'`',262h,265h,26ch,275h,17,18,27ah,263h,26fh
                dw      276h,269h,271h,261h,277h,273h
editpatrout     dd      epf1,epf2,epf4,epup,epdn,eppgup,eppgdn,ephome,epend
                dd      epdecvoice,epincvoice,epcins,epcvol,epclear,epdecpat
                dd      epincpat,epbreak,epcopypat,eppickup,epblkb,epblke
                dd      epblkl,epblku,epins,epdel,epblkzero,epblkcopy
                dd      epblkover,epblkvol,epblkins,epblkou,epblkod,epblknu
                dd      epblknd
editpat:
        call putstat
        call putpat
        call putpatcur
        call getinput
        mov edx,offset editpatlist
        call _indexword
        jc short editpatf0
        call editpatrout[eax*4]
        jmp editpat
editpatf0:
        or ah,ah
        jnz editpat
        push ax
        call calcloc
        pop ax
        mov edx,offset nkeylist
        call _indexbyte
        jc editpat
        mov dl,edvoiceb
        add dl,edvoiceo
        cmp dl,3
        ja short editpatf1
        call adjoct
editpatf1:
        mov bl,edoct
        shl bl,4
        cmp al,12
        jb short editpatf2
        add al,10h-12
editpatf2:
        add bl,al
        mov bh,edvol
        movzx ecx,edinsb
        add cl,edinso
        shld ax,cx,20
        or bh,al
        shl ah,7
        or bl,ah
        mov [edi],bx
        mov al,dl
        mov ah,bl
        and ah,7fh
        mov bl,edvol
        cmp al,3
        ja editpatfm
        shl ecx,4
        add ecx,dinsbase
        mov esi,[ecx]
        mov ebp,[ecx+4]
        mov edx,[ecx+12]
        mov ecx,[ecx+8]
        call _sbnote
        push offset editpat
        jmp epdn
editpatfm:
        sub al,4
        imul edx,ecx,11
        add edx,fminsbase
        call _fmnote
        push offset editpat
        jmp epdn

;-----------------------------------------------------------------------------
epf1:
        add esp,4
        call putpat
        jmp editins0
;-----------------------------------------------------------------------------
epf2:
        add esp,4
        call putpat
        jmp editins1
;-----------------------------------------------------------------------------
epf4:
        add esp,4
        call putpat
        jmp editord
;-----------------------------------------------------------------------------
ephome:
        mov edrowo,0
        ret
;-----------------------------------------------------------------------------
epend:
        mov edrowo,1fh
        ret
;-----------------------------------------------------------------------------
epup:
        mov ah,-1
        jmp short epupdn
;-----------------------------------------------------------------------------
epdn:
        mov ah,1
epupdn:
        mov al,edrowo
        add al,ah
        js eppgupdn
        cmp al,1fh
        ja eppgupdn
        mov edrowo,al
        ret
;-----------------------------------------------------------------------------
eppgup:
        mov ah,-10h
        jmp short eppgupdn
;-----------------------------------------------------------------------------
eppgdn:
        mov ah,10h
eppgupdn:
        mov al,edrowb
        add al,ah
        jns short eppgupdnf0
        mov edrowb,0
        ret
eppgupdnf0:
        cmp al,21h
        jb short eppgupdnf1
        mov al,20h
eppgupdnf1:
        mov edrowb,al
        ret
;-----------------------------------------------------------------------------
epdecvoice:
        mov ah,-1
        jmp short epcvoice
;-----------------------------------------------------------------------------
epincvoice:
        mov ah,1
epcvoice:
        mov al,edvoiceo
        add al,ah
        js epcvoiceb
        cmp al,10
        ja epcvoiceb
        mov edvoiceo,al
        ret
epcvoiceb:
        mov al,edvoiceb
        add al,ah
        js _ret
        cmp al,maxvoiceb
        ja _ret
        mov edvoiceb,al
        ret
;-----------------------------------------------------------------------------
epcins:
        call calcloc
        cmp byte ptr [edi],0feh
        jae _ret
        call calcloc2
        add bl,3
        mov cl,2
        call getnum
        jc _ret
        and al,1fh
        call setins
        shl eax,4
        shl ah,7
        xchg al,ah
        and word ptr [edi],0f7fh
        or word ptr [edi],ax
        jmp epdn
;-----------------------------------------------------------------------------
epcvol:
        call calcloc
        call calcloc2
        add bl,5
        mov cl,1
        call getnum
        jc _ret
        mov edvol,al
        cmp byte ptr [edi],0ffh
        jb short epcvolf0
        mov word ptr [edi],0feh
epcvolf0:
        and byte ptr [edi+1],0f0h
        or byte ptr [edi+1],al
        jmp epdn
;-----------------------------------------------------------------------------
epclear:
        call calcloc
        mov word ptr [edi],-1
        jmp epdn
;-----------------------------------------------------------------------------
epdecpat:
        mov ah,-1
        jmp short epchangepat
;-----------------------------------------------------------------------------
epincpat:
        mov ah,1
epchangepat:
        push ax
        call setpat
        pop ax
        mov al,edpat
        add al,ah
        and al,7fh
        mov edpat,al
        call getpat
        ret
;-----------------------------------------------------------------------------
epbreak:
        mov al,edrowb
        add al,edrowo
        mov mzbreak,al
        ret
;-----------------------------------------------------------------------------
wpatstr db      'Copy to which pattern?',0
epcopypat:
        mov bx,181ah
        mov cx,61eh
        call _pushtext
        add bx,101h
        sub cx,101h
        mov ax,20h
        call _textbox0
        sub bx,101h
        mov edx,offset boxgrfx
        mov ah,87h
        call _textbox1
        add bx,202h
        mov edx,offset wpatstr
        mov ah,8fh
        call _putstr
        add bx,17h
        mov cl,2
        call getnum
        jc short epcopypatd
        mov ah,edpat
        push ax
        mov edpat,al
        call setpat
        pop ax
        mov edpat,ah
epcopypatd:
        call _poptext
        ret
;-----------------------------------------------------------------------------
eppickup:
        call calcloc
        mov dx,[edi]
        cmp dl,-2
        ja _ret
        je short eppickupf0
        mov ah,dl
        mov al,dh
        shr ah,7
        shr eax,4
        call setins
eppickupf0:
        and dh,0fh
        mov edvol,dh
        ret
;-----------------------------------------------------------------------------
epblkb:
	mov al,edrowb
	add al,edrowo
	mov edblkb,al
	ret
;-----------------------------------------------------------------------------
epblke:
	mov al,edrowb
	add al,edrowo
	mov edblke,al
        ret
;-----------------------------------------------------------------------------
epblkl:
	mov edblkb,0
	mov edblke,3fh
	ret
;-----------------------------------------------------------------------------
epblku:
	mov edblkb,-1
	mov edblke,-1
        ret
;-----------------------------------------------------------------------------
epins:
        mov idcall,offset ins
        jmp short epid
;-----------------------------------------------------------------------------
epdel:
        mov idcall,offset del
epid:
        call gettrak
        mov dx,64
        movzx bx,edrowb
        add bl,edrowo
        mov ecx,2
        mov ebp,worktrak
        call idcall
        mov eax,-1
        stosw
        jmp puttrak
;-----------------------------------------------------------------------------
epblkzero:
        call calc3
epblkzeroml:
        mov word ptr [edi],-1
        add edi,2
        loop epblkzeroml
        jmp puttrak
;-----------------------------------------------------------------------------
epblkcopy:
        call calc3
        mov esi,edi
        mov edi,savetrak
        mov edblkl,cl
        rep movsw
        ret
;-----------------------------------------------------------------------------
epblkover:
        call gettrak
        movzx ecx,edblkl
        or cl,cl
        js _ret
        movzx eax,edrowb
        add al,edrowo
        mov ebx,64
        sub ebx,eax
        cmp ecx,ebx
        jbe epblkoverf0
        mov ecx,ebx
epblkoverf0:
        mov esi,savetrak
        lea edi,[eax*2]
        add edi,worktrak
        mov bl,edvoiceb
        add bl,edvoiceo
epblkoverml:
        lodsw
        cmp al,0fdh
        ja short epblkovermlc
        cmp bl,3
        ja short epblkovermlc
        cmp al,1010000b
        jb short epblkovermlc
        and al,0bfh
epblkovermlc:
        stosw
        loop epblkoverml
        jmp puttrak
;-----------------------------------------------------------------------------
epblkvol:
        call calc3
        mov esi,edi
        mov bl,edvol
epblkvolml:
        lodsw
        and ah,0f0h
        or ah,bl
        stosw
        loop epblkvolml
        jmp puttrak
;-----------------------------------------------------------------------------
epblkins:
        call calc3
        mov esi,edi
        mov bl,edinsb
        add bl,edinso
        shl ebx,4
        shl bh,7
        xchg bl,bh
epblkinsml:
        lodsw
        cmp al,0fdh
        ja short epblkinsmlc
        and ax,0f7fh
        or ax,bx
epblkinsmlc:
        stosw
        loop epblkinsml
        jmp puttrak
;-----------------------------------------------------------------------------
epblkou:
        mov dh,10h
        jmp short epblkoc
;-----------------------------------------------------------------------------
epblkod:
        mov dh,-10h
epblkoc:
        call calc3
        mov esi,edi
        mov al,edvoiceb
        add al,edvoiceo
        mov dl,40h
        cmp al,4
        jb short epblkoml
        mov dl,70h
epblkoml:
        lodsw
        cmp al,0fdh
        ja short epblkomlc
        mov bl,al
        and bl,70h
        add bl,dh
        js short epblkomlc
        cmp bl,dl
        ja short epblkomlc
        and al,8fh
        or al,bl
epblkomlc:
        stosw
        loop epblkoml
        jmp puttrak
;-----------------------------------------------------------------------------
epblknu:
        mov dh,1
        jmp short epblknc
;-----------------------------------------------------------------------------
epblknd:
        mov dh,-1
epblknc:
        call calc3
        mov esi,edi
        mov al,edvoiceb
        add al,edvoiceo
        mov dl,4
        cmp al,4
        jb short epblknml
        mov dl,7
epblknml:
        lodsw
        cmp al,0fdh
        ja short epblknmlc
        mov bl,al
        and bl,0fh
        mov bh,al
        shr bh,4
        and bh,7
        add bl,dh
        js short epblknmlf0
        cmp bl,12
        jb short epblknmlf1
        sub bl,12
        jmp short epblknmlf2
epblknmlf0:
        add bl,12
epblknmlf2:
        add bh,dh
        js short epblknmlc
        cmp bh,dl
        ja short epblknmlc
        shl bh,4
        and al,8fh
        or al,bh
epblknmlf1:
        and al,0f0h
        or al,bl
epblknmlc:
        stosw
        loop epblknml
        jmp puttrak

;
; CL - number to start at
; CH - number to do
; EDI -> coordinates to start at
putnumbar:
        mov ebx,offset _hextbl
        mov ah,2
putnumbarml:
        mov al,cl
        shr al,4
        xlat
        stosw
        mov al,cl
        and al,0fh
        xlat
        stosw
        add edi,156
        inc cl
        dec ch
        jnz putnumbarml
        ret
;
; AH - attributes
; EDX - number
; EDI - coordinates
putnum5:
        mov ebx,offset _hextbl
        shl edx,12
        mov ecx,5
putnum5ml:
        rol edx,4
        mov al,dl
        and al,0fh
        xlat
        stosw
        loop putnum5ml
        ret
;
; AH - attributes
; AL - number
; EDI - coordinates
putnum2:
        mov ebx,offset _hextbl
        mov dl,al
        shr al,4
        xlat
        stosw
        mov al,dl
        and al,0fh
        xlat
        stosw
        ret
;
; AH - attributes
; AL - number
; EDI - coordinates
putnum1:
        mov ebx,offset _hextbl
        and al,0fh
        xlat
        stosw
        ret

;-----------------------------------------------------------------------------
putcur:                                 ; routine for putcursor
        add edi,_vgatextptr
putcurl0:
        lodsb
        movzx ecx,al
        mov al,8fh
putcurl1:
        inc edi
        stosb
        loop putcurl1
        lodsb
        or al,al
        jz _ret
        movzx eax,al
        lea edi,[edi+eax*2]
        jmp putcurl0
;
putins:                                 ; General put ins routine
        mov bx,17
        mov cx,0e2dh
        mov ax,1920h
        call _textbox0
        mov bx,17
        mov ah,13h
        mov edx,[esp+4]
        call _putstr
        mov edi,2
        mov edi,_vgatextptr
        add edi,160+2
        mov cl,edinsb
        mov ch,13
        call putnumbar
        mov ax,720h
        mov bx,104h
        mov cx,0d0ch
        call _textbox0
        movzx edx,edinsb
        imul edx,13
        add edx,[esp+8]
        mov ecx,13
putinsl0:
        call _putstr
        inc bh
        add edx,13
        loop putinsl0
        ret 8
;
putins0str      db      'Lbeg  Lend  Len',0
putins0:                                ; Put digital instrument data
        push dinsnames
        push offset putins0str
        call putins
        movzx esi,edinsb
        imul esi,16
        add esi,dinsbase
        mov ecx,13
        mov ah,7
        mov edi,_vgatextptr
        add edi,160+34
putins0ml:
        push ecx
        mov edx,[esi+8]
        sub edx,[esi]
        call putnum5
        add edi,2
        mov edx,[esi+12]
        sub edx,[esi]
        call putnum5
        add edi,2
        mov edx,[esi+4]
        sub edx,[esi]
        call putnum5
        add edi,126
        add esi,16
        pop ecx
        loop putins0ml
        ret
;
ins0curdat      db      2,1,12,1,5,1,5,1,5,0
putins0cur:                             ; Put digital instrument cursor
        movzx edi,edinso
        imul edi,160
        add edi,160+2
        mov esi,offset ins0curdat
        jmp putcur
;
putins1str      db      'ArDrSlRrMlKsTlWsAVEK ArDrSlRrMlKsTlWsAVEK FbC',0
putins1pmns     db      0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,1,0,1,0,1,2
                db      0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,1,0,1,0,1,2
                db      0,0,1,0
putins1pm       dd      putnum2,putnum1
putins1:                                ; Put FM instrument data
        push fminsnames
        push offset putins1str
        call putins
        mov dh,edinsb
        mov edi,_vgatextptr
        add edi,160+34
        mov ecx,13
putins1l0:
        push ecx
        mov esi,offset putins1pmns
        xor cl,cl
putins1l1:
        mov ah,dh
        mov al,cl
        call getfminsval
        movzx ebp,byte ptr [esi]
        mov ah,7
        call putins1pm[ebp*4]
        movzx ebp,byte ptr [esi+1]
        add esi,2
        add edi,ebp
        inc cl
        cmp cl,26
        jb putins1l1
        inc dh
        add edi,70
        pop ecx
        loop putins1l0
        ret
;
ins1curdat      db      2,1,12,1,20,1,20,1,3,0
ins1curdat2     db      0,1,2,1,4,1,6,1,8,1,10,1,12,1,14,1,16,0,17,0,18,0,19,0
                db      21,1,23,1,25,1,27,1,29,1,31,1,33,1,35,1,37,0,38,0,39,0,40,0
                db      42,1,44,0
putins1cur:                             ; Put FM instrument cursor
        movzx edi,edinso
        imul edi,160
        add edi,160+2
        mov esi,offset ins1curdat
        call putcur
        movzx esi,edfmval
        movzx edi,ins1curdat2[esi*2]
        lea edi,[edi*2+160+35]
        add edi,_vgatextptr
        movzx eax,edinso
        imul eax,160
        add edi,eax
        mov byte ptr [edi],0dh
        cmp ins1curdat2[esi*2+1],0
        je _ret
        mov byte ptr [edi+2],0dh
        ret
;
putord:                                 ; Put order list
        mov edi,_vgatextptr
        add edi,160+148
        mov cl,edordb
        mov ch,13
        call putnumbar
        mov edi,_vgatextptr
        add edi,160+154
        movzx esi,edordb
        add esi,ordbase
        mov ecx,13
        mov ah,7
putordl0:
        lodsb
        cmp al,-1
        je short putordl0f0
        call putnum2
        jmp short putordl0c
putordl0f0:
        mov al,''
        stosw
        stosw
putordl0c:
        add edi,156
        loop putordl0
        ret
;
ordcurdat       db      2,1,2,0
putordcur:                              ; Put order list cursor
        movzx edi,edordo
        imul edi,160
        add edi,160+148
        mov esi,offset ordcurdat
        jmp putcur
;
statline db '  Tempo:_   Loop:__   Channel:__   Octave:_   Volume:_   Order:__   Pattern:__  ',0
putstat:                                ; Put stat line
        mov al,mztempo
        mov cl,0
        mov edx,offset statline+8
        call _putnumtomem
        mov al,mzloop
        mov cl,1
        mov edx,offset statline+17
        call _putnumtomem
        mov al,edvoiceb
        add al,edvoiceo
        mov cl,1
        mov edx,offset statline+30
        call _putnumtomem
        mov al,edoct
        mov cl,0
        mov edx,offset statline+42
        call _putnumtomem
        mov al,edvol
        mov cl,0
        mov edx,offset statline+53
        call _putnumtomem
        mov al,edordb
        add al,edordo
        mov cl,1
        mov edx,offset statline+63
        call _putnumtomem
        mov al,edpat
        mov cl,1
        mov edx,offset statline+76
        call _putnumtomem
        mov edx,offset statline
        mov bx,3100h
        mov ah,08fh
        call _putstr
        ret
;
noteascii       db      'CC#DD#EFF#GG#AA#B'
patchannels     db      '00  DL01  DR02  DL03  DR04  FL05  FR06  FL07  FR'
                db      '08  FL09  FR0A  FL0B  FR0C  FL0D *FR0E *FL0F *FR'
                db      '10 *FL11 *FR12 *FL13 *FR14 *FL15 *FR'
putpatphase     db      ?
putpatcolor     db      ?
putpat:                                 ; Put pattern
        mov edi,_vgatextptr
        add edi,16*160+2
        mov cl,edrowb
        mov ch,32
        call putnumbar
        mov ax,132dh
        mov bx,104fh
        mov cx,2001h
        call _textbox0
        movzx esi,edrowb
        imul esi,44
        add esi,workpatptr
        movzx eax,edvoiceb
        lea esi,[esi+eax*2]
        mov edi,_vgatextptr
        add edi,16*160+6
        mov ebp,20h
        mov al,edrowb
        dec al
        mov putpatphase,al
putpatl0:
        mov al,putpatphase
        inc al
        mov putpatphase,al
        test al,3
        setz ah
        shl ah,6
        mov putpatcolor,ah
        mov ecx,11
putpatl1:
        mov bl,[esi]
        cmp bl,0feh
        jb short putpatl1f0
        mov ax,7fah
        or ah,putpatcolor
        stosw
        stosw
        stosw
        stosw
        stosw
        cmp bl,-1
        jb short putpatl1f1
        stosw
        jmp short putpatl1c
putpatl1f0:
        mov ah,putpatcolor
        or ah,11
        movzx edx,bl
        and dl,0fh
        mov al,noteascii[edx*2]
        stosw
        mov al,noteascii[edx*2+1]
        stosw
        mov dl,bl
        mov al,bl
        shr al,4
        and al,7
        call putnum1
        mov ah,putpatcolor
        or ah,3
        mov al,[esi+1]
        shr al,4
        and dl,80h
        shr dl,3
        or al,dl
        call putnum2
putpatl1f1:
        mov ah,putpatcolor
        or ah,11
        mov al,[esi+1]
        call putnum1
putpatl1c:
        add esi,2
        add edi,2
        dec ecx
        jnz putpatl1
        add esi,22
        add edi,6
        dec ebp
        jnz putpatl0
        mov edi,_vgatextptr
        add edi,15*160+6
        movzx esi,edvoiceb
        imul esi,6
        add esi,offset patchannels
        mov ah,8fh
        mov ecx,11
putpatl2:
        lodsb
        stosw
        lodsb
        stosw
        lodsb
        stosw
        lodsb
        stosw
        lodsb
        stosw
        lodsb
        stosw
        add edi,2
        loop putpatl2
        mov bh,edblkb
        cmp bh,0ffh
        je putpatf2
        mov ch,edblke
        cmp ch,0ffh
        je putpatf2
        cmp ch,bh
	jae short putpatf3
	mov edblkb,-1
        mov edblke,-1
	jmp short putpatf2
putpatf3:
        mov al,edrowb
        cmp ch,al
        jb short putpatf2
        cmp bh,al
        jae putpatf0
        mov bh,al
putpatf0:
        add al,1fh
        cmp bh,al
        ja short putpatf2
        cmp ch,al
        jbe putpatf1
        mov ch,al
putpatf1:
        sub ch,bh
        inc ch
        sub bh,edrowb
        add bh,16
        mov bl,79
        mov cl,1
        mov ax,0b02dh
        call _textbox0
        movzx ecx,ch
        movzx edi,bh
        imul edi,160
        movzx eax,edvoiceo
        imul eax,14
        lea edi,[edi+eax+7]
        add edi,_vgatextptr
        mov byte ptr [edi],0ffh
        mov al,04eh
putpatl3:
        stosb
        inc edi
        stosb
        inc edi
        stosb
        inc edi
        stosb
        inc edi
        stosb
        inc edi
        stosb
        inc edi
        add edi,148
        loop putpatl3
putpatf2:
        mov edi,_vgatextptr
        add edi,16*160+158
        movzx eax,mzbreak
        sub al,edrowb
        jc _ret
        cmp al,1fh
        ja _ret
        imul eax,160
        add edi,eax
        mov byte ptr [edi],11h
        mov al,[edi+1]
        and al,0f0h
        or al,0fh
        mov [edi+1],al
        ret
;
patcurdat       db      6,0
putpatcur:
        movzx edi,edrowo
        imul edi,160
        add edi,16*160+6
        movzx eax,edvoiceo
        imul eax,14
        add edi,eax
        mov esi,offset patcurdat
        jmp putcur

;
clearsong:                              ; Clear song
        call _stopmuzik
        mov mztempo,6
        mov mzloop,0
        xor al,al
        mov edvol,0fh
        mov edoct,2
        mov edpat,al
        mov edvoiceb,al
        mov edvoiceo,al
        mov edrowb,al
        mov edrowo,al
        mov edinsb,al
        mov edinso,al
        mov edordb,al
        mov edordo,al
        mov edfmval,al
        mov edi,ordbase
        mov eax,-1
        mov ecx,40h
        rep stosd
        mov edi,patbase
        mov eax,604040h
        mov ecx,80h
clearsongl0:
        stosd
        dec edi
        loop clearsongl0
        mov edi,patoffbase
        mov ecx,80h
        xor eax,eax
clearsongl1:
        stosd
        add eax,3
        loop clearsongl1
        mov edi,patlenbase
        mov ecx,80h
        mov eax,3
        rep stosd
        xor eax,eax
        mov edi,dinsbase
        mov ecx,32
clearsongl2:
        xor eax,eax
        stosd
        stosd
        stosd
        mov eax,0ffffffh
        stosd
        loop clearsongl2
        xor eax,eax
        mov edi,fminsbase
        mov ecx,11*8
        rep stosd
        mov edi,dinsnames
        mov ecx,13*8
        rep stosd
        mov edi,fminsnames
        mov ecx,13*8
        rep stosd
putall:
        call getpat
        call putins0
        call putpat
        call putord
        call putstat
        call adjsmp
_retc:
        stc
        ret

;
adjsmp:                                 ; defragment sample memory...
        call _stopmuzik
;        @rlp ebp,100000h
        mov ebp,_himembase
adjsmpl1:
        xor ebx,ebx
        mov ecx,20h
        mov edx,-1
        mov esi,dinsbase
adjsmpl2:
        mov eax,[esi+4]
        or eax,eax
        je short adjsmpl2c
        cmp eax,ebx
        jb short adjsmpl2f1
        mov ebx,eax
adjsmpl2f1:
        mov eax,[esi]
        cmp eax,ebp
        jb short adjsmpl2c
        cmp eax,edx
        ja short adjsmpl2c
        mov edi,esi
        mov edx,eax
adjsmpl2c:
        add esi,16
        loop adjsmpl2
        cmp edx,-1
        je short adjsmpdone
        cmp edx,ebp
        je short adjsmpl1c
        push edi
        mov eax,edx
        sub eax,ebp
        mov ecx,20h
        mov esi,dinsbase
adjsmpl3:
        cmp [esi],ebp
        jb short adjsmpl3c
        sub [esi],eax
        sub [esi+4],eax
        sub [esi+8],eax
        sub [esi+12],eax
adjsmpl3c:
        add esi,16
        loop adjsmpl3
        mov esi,edx
        mov edi,ebp
        mov ecx,ebx
        sub ecx,esi
        rep movsb
        pop edi
adjsmpl1c:
        mov ebp,[edi+4]
        jmp adjsmpl1
adjsmpdone:
        mov smpbase,ebp
        ret

;
; CX - number of strings
; EBP - 13 byte ASCIIZstrings
alph:
        cmp cx,2
        jb _ret
        movzx edx,cx
        dec edx
alphl1:
        mov ecx,edx
        mov esi,ebp
alphl2:
        push cx
        push esi
        mov edi,esi
        add edi,13
        mov cx,13
        repe cmpsb
        jb alphl2c
        pop esi
        pop cx
        mov cx,13
alphl3:
        lodsb
        xchg al,[esi+12]
        mov [esi-1],al
        loop alphl3
        jmp alphl1
alphl2c:
        pop esi
        pop cx
        add esi,13
        loop alphl2
        ret

;
alphfindbp      dd      ?
; EBX - total strings present
; ESI - base of strings
; EBP - string to place
; out:
;  EAX - index to put string at
alphfind:
        mov alphfindbp,esi
        mov edx,ebp
        call _strlen
        lea edx,[eax+1]
        xor eax,eax
alphfindml:
        mov ecx,edx
        mov edi,ebp
        repe cmpsb
        je _retc
        ja _retnc
        mov esi,alphfindbp
        add esi,13
        mov alphfindbp,esi
        inc eax
        dec ebx
        jnz alphfindml
_retnc:
        clc
        ret

;
; DX - total items present
; BX - number to insert at
; EBP - base of list
; ECX - size of each item
; out:
;  EDI - item to fill with blank
ins:
        movzx esi,bx
        imul esi,ecx
        add esi,ebp
        lea edi,[esi+ecx]
        sub dx,bx
        movzx edx,dx
        dec edx
        jz short insdone
        imul ecx,edx
        call _copymem
insdone:
        mov edi,esi
        ret
;
; DX - total items present
; BX - number to insert at
; EBP - base of list
; ECX - size of each item
; out:
;  EDI - item to fill with blank
del:
        movzx eax,dx
        dec eax
        imul eax,ecx
        add eax,ebp
        movzx edi,bx
        imul edi,ecx
        add edi,ebp
        lea esi,[edi+ecx]
        sub dx,bx
        movzx edx,dx
        dec edx
        jz short deldone
        imul ecx,edx
        call _copymem
deldone:
        mov edi,eax
        ret

;
; BL,BH - X and Y
; CL - number of digits
; out:
;  EAX - number
getnum:
        mov ax,8a01h
        mov edx,offset errmsg0
        mov byte ptr [edx],0
        mov ebp,offset numlist
        call _getstr
        jc _ret
        cmp byte ptr [edx],0
        je _retc
        call _strltu
        call _strhtn
        clc
        ret

;
sellist db      9
        dw      14,32,13,21,22,25,26,19,20
selrout dd      selectexit,selectdone,selectdone,selpgup,selpgdn,selup,seldn
        dd      selhome,selend
sels    dd      ?
selbp   dd      ?
seln    dw      ?
selb    dw      ?
selo    db      ?
seli    db      ?
selbs   dw      0,0
selos   db      0,0
selbps  dd      ?,?
; EDX -> 13 byte ASCIIZ strings
; ECX - number present
; out:
;  EAX - index
select:
        movzx ebx,seli
        mov eax,selbps[ebx*4]
        mov selbp,eax
        mov ax,selbs[ebx*2]
        mov selb,ax
        mov al,selos[ebx]
        mov selo,al
        mov sels,edx
        mov seln,cx
        mov bx,32
        mov cx,3210h
        call _pushtext
        mov ax,7020h
        call _textbox0
selectml:
        mov bx,33
        mov cx,320eh
        mov ax,7020h
        call _textbox0
        movzx ecx,seln
        movzx edx,selb
        sub ecx,edx
        cmp ecx,50
        jbe short selectf0
        mov ecx,50
selectf0:
        mov edx,selbp
        inc bl
selectl0:
        call _putstr
        inc bh
        add edx,13
        loop selectl0
        movzx edi,selo
        imul edi,160
        add edi,_vgatextptr
        add edi,67
        mov al,15
        mov ecx,14
selectl1:
        stosb
        inc edi
        loop selectl1
selectml2:
        call _getch
        mov edx,offset sellist
        call _indexword
        jc short selectfind
        push offset selectml
        jmp selrout[eax*4]
;-----------------------------------------------------------------------------
selectfind:
        or ah,ah
        jnz selectml2
        mov edx,sels
        movzx ecx,seln
selectfindml:
        cmp al,[edx]
        jz short selectfindf0
        add edx,13
        loop selectfindml
        cmp al,'a'
        jb selectml2
        cmp al,'z'
        ja selectml2
        add al,'A'-'a'
        jmp selectfind
selectfindf0:
        mov selbp,edx
        mov ax,seln
        sub ax,cx
        mov selb,ax
        mov selo,0
        jmp selectml
;-----------------------------------------------------------------------------
selup:
        mov bx,-1
        jmp short selupdn
;-----------------------------------------------------------------------------
seldn:
        mov bx,1
selupdn:
        mov al,selo
        add al,bl
        js short selpgupdn
        movzx cx,al
        add cx,selb
        cmp cx,seln
        jae _ret
        cmp al,49
        ja selpgupdn
        mov selo,al
        ret
;-----------------------------------------------------------------------------
selpgup:
        mov bx,-50
        jmp short selupdn
;-----------------------------------------------------------------------------
selpgdn:
        mov bx,50
selpgupdn:
        mov ax,selb
        add ax,bx
        js _ret
        movzx cx,selo
        add cx,ax
        cmp cx,seln
        jae _ret
        movsx ebx,bx
        imul ebx,13
        add selbp,ebx
        mov selb,ax
        ret
;-----------------------------------------------------------------------------
selectdone:
        movzx ebx,seli
        mov eax,selbp
        mov selbps[ebx*4],eax
        mov ax,selb
        mov selbs[ebx*2],ax
        mov al,selo
        mov selos[ebx],al
        add esp,4
        call _poptext
        movzx eax,selo
        add ax,selb
        clc
        ret
;-----------------------------------------------------------------------------
selectexit:
        add esp,4
        call _poptext
        stc
        ret
;-----------------------------------------------------------------------------
selhome:
        mov selo,0
        ret
;-----------------------------------------------------------------------------
selend:
        mov ax,seln
        sub ax,selb
        cmp ax,51
        jb short selendf0
        mov al,50
selendf0:
        dec al
        mov selo,al
        ret

;
fminsvaldat     db      3,4,15, 3,0,15, 4,4,15, 4,0,15, 1,0,15, 2,6,3, 2,0,63, 5,0,3, 1,7,1,1,6,1,1,5,1,1,4,1
                db      8,4,15, 8,0,15, 9,4,15, 9,0,15, 6,0,15, 7,6,3, 7,0,63, 10,0,3, 6,7,1,6,6,1,6,5,1,6,4,1
                db      0,1,7, 0,0,1
; AH - instrument
; AL - value number
; out AL - val
getfminsval:
        push ebx
        push ecx
        push edx
        movzx edx,ah
        imul edx,11
        add edx,fminsbase
        movzx ebx,al
        lea ebx,[ebx*2+ebx+fminsvaldat]
        movzx ecx,byte ptr [ebx]
        add edx,ecx
        mov cl,[ebx+1]
        mov al,[edx]
        shr al,cl
        and al,[ebx+2]
        pop edx
        pop ecx
        pop ebx
        ret
;
; AH - instrument
; AL - value number
; BL - val
setfminsval:
        push ax
        push ecx
        push edx
        push edi
        movzx edx,ah
        imul edx,11
        add edx,fminsbase
        movzx edi,al
        lea edi,[edi*2+edi+fminsvaldat]
        movzx ecx,byte ptr [edi]
        add edx,ecx
        mov cl,[edi+1]
        mov ch,[edx]
        mov al,[edi+2]
        shl al,cl
        not al
        and ch,al
        mov al,bl
        and al,[edi+2]
        shl al,cl
        or al,ch
        mov [edx],al
        pop edi
        pop edx
        pop ecx
        pop ax
        ret

;
getpatrout      dd      getpat0,getpat1,getpat2,getpat3
getpat:                                 ; Unsquish EDPAT to work buffer
        mov edi,workpatptr
        mov eax,-1
        mov ecx,11*64
        rep stosd
        movzx esi,edpat
        shl esi,2
        add esi,patoffbase
        mov esi,[esi]
        add esi,patbase
        mov edi,workpatptr
        xor edx,edx
getpatml:
        lodsb
        movzx ebx,al
        shr bl,5
        jmp getpatrout[ebx*4]
getpat0:
        movzx ebx,al
        and bl,1fh
        lodsw
        mov [edi+ebx*2],ax
        jmp getpatml
getpat1:
        movzx ebx,al
        and bl,1fh
        lodsb
        mov ah,al
        mov al,0feh
        mov [edi+ebx*2],ax
        jmp getpatml
getpat2:
        lodsb
        movzx ebx,al
        add dl,al
        imul ebx,44
        add edi,ebx
        jmp getpatml
getpat3:
        dec dl
        mov mzbreak,dl
        ret

;
setpat:                                 ; Squish work buffer to EDPAT
        mov esi,workpatptr
        mov edi,buildpat
        xor edx,edx
setpatl0:
        mov ecx,22
setpatl1:
        mov ah,[esi]
        cmp ah,0feh
        ja short setpatl1c
        call setpatrout
        mov al,22
        sub al,cl
        cmp ah,0feh
        jb short setpatl1f0
        or al,20h
        jmp short setpatl1f1
setpatl1f0:
        stosb
        mov al,ah
setpatl1f1:
        stosb
        mov al,[esi+1]
        stosb
setpatl1c:
        add esi,2
        loop setpatl1
        add dx,101h
        cmp dh,mzbreak
        jbe setpatl0
        call setpatrout
        mov al,60h
        stosb
        movzx ebp,edpat
        mov edx,edi
        sub edx,buildpat
        push edx
        lea ebx,[ebp*4]
        add ebx,patlenbase
        xchg edx,[ebx]
        sub edx,[ebx]
        cmp ebp,7fh
        je short setpatf0
        lea esi,[ebp*4+4]
        add esi,patoffbase
        mov esi,[esi]
        mov ecx,patoffbase
        mov ecx,[ecx+4*127]
        mov ebx,patlenbase
        add ecx,[ebx+4*127]
        sub ecx,esi
        add esi,patbase
        mov edi,esi
        sub edi,edx
        call _copymem
setpatf0:
        pop ecx
        mov esi,buildpat
        lea edi,[ebp*4]
        add edi,patoffbase
        mov edi,[edi]
        add edi,patbase
        rep movsb
        mov ecx,7fh
        sub ecx,ebp
        jz _ret
        lea ebp,[ebp*4+4]
        add ebp,patoffbase
setpatl2:
        sub [ebp],edx
        add ebp,4
        loop setpatl2
        ret
;-----------------------------------------------------------------------------
setpatrout:
        or dl,dl
        jz _ret
        mov al,40h
        stosb
        mov al,dl
        stosb
        xor dl,dl
        ret


code32  ends
        end
