// trackerDoc.cpp : implementation of the CTrackerDoc class
//
/*****************************************************************************
 * File        : gtkformat.c                                                       
 * Author(s)   : Fredrik Kling (gnilk@home.se)
 * Original    : 2001-01-27 01:42:43
 * Last edit   : 2001-01-27 19:49:18
 * Description : Holds all system handling of the gtk_format
 *               
 *--------------------------------------------------------------------------- 
 * Changes: 
 * 
 * -- Date -- | -- Name ------- | -- Did what...                              
 * 2002-02-26 | gnilk           | Default config, wont crash if tracker_config.txt not found
 * 2002-05-26 | zyrax           | Now reads from .INI via Configuration.h/.cpp
 * 
 *****************************************************************************/

#include "stdafx.h"
#include "tracker.h"
#include "songoptdlg.h"
#include "mainfrm.h"
#include "trackerDoc.h"
#include "mixerview.h"
#include "gtkformat.h"
#include "Configuration.h"
#include "TrackerOptions.h"
#include "SendFxView10.h"
#include "SamplePoolEditor.h"
#include "Globals.h"


#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CTrackerDoc

IMPLEMENT_DYNCREATE(CTrackerDoc, CDocument)

BEGIN_MESSAGE_MAP(CTrackerDoc, CDocument)
	//{{AFX_MSG_MAP(CTrackerDoc)
	ON_COMMAND(IDD_MENU_OPTIONS, OnMenuOptions)
	ON_COMMAND(ID_FILE_SAVE, OnFileSave)
	ON_COMMAND(ID_FILE_SAVE_AS, OnFileSaveAs)
	ON_COMMAND(ID_FILE_OPEN, OnFileOpen)
	ON_COMMAND(IDD_MENU_SONGOPTIONS, OnMenuSongoptions)
	ON_NOTIFY(UDN_DELTAPOS, IDC_SPIN_TCNTRL_PJUMP, OnDeltaposSpinTcntrlPjump)
	ON_COMMAND(IDD_MENU_SAMPLEVIEW, OnMenuSampleview)
	ON_COMMAND(IDD_MENU_MIXERVIEW, OnMenuMixerview)
	ON_COMMAND(IDD_MENU_SENDFXEDITOR, OnMenuSendfxeditor)
	ON_COMMAND(IDD_MENU_SAMPLEPOOL, OnMenuSamplepool)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CTrackerDoc construction/destruction

isPlayer *g_docPlayerList[16] = { 0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 };


CTrackerDoc::CTrackerDoc()
{
	// TODO: add one-time construction code here
  pl = NULL;
  synth = NULL;
  ctrl_latency = 400;
  gtk = 0;

}

CTrackerDoc::~CTrackerDoc()
{
  for (int i=0;i<16;i++)
	  if (g_docPlayerList[i] == pl )
		  g_docPlayerList[i] = 0;

  pl->Stop();
  delete pl;
  delete synth;

}


BOOL CTrackerDoc::OnNewDocument()
{
	if (!CDocument::OnNewDocument())
		return FALSE;

	// TODO: add reinitialization code here
	// (SDI documents will reuse this document)
	int i;
	ctrl_light = RGB (128,128,192);
	ctrl_cursor = RGB (192,128,128);
	ctrl_text = RGB (255,255,255);
  ctrl_curtext = RGB (192,255,192);
  ctrl_marktext = RGB (40,40,255);
  
	LoadConfig ();

	int r,g,b;
	r = GetRValue (ctrl_light);
	g = GetGValue (ctrl_light);
	b = GetBValue (ctrl_light);
	ctrl_bg = RGB (r*0.6,g*0.6,b*0.6);
	ctrl_dark = RGB (r*0.3,g*0.3,b*0.3);


  CWnd *wnd  = AfxGetMainWnd ();


	synth = new isSynth();	
	pl = new isPlayer (wnd->m_hWnd,synth);
    pl->SetLatency( CONFIGURATION_GETDWORD( _T("dsound"), _T("latency"), 400 ) );

	HANDLE thread = pl->GetThreadHandle();
	switch ( CONFIGURATION_GETDWORD( _T("dsound"), _T("threadpriority"), 0 ) ) {
		case 0:
			SetThreadPriority( thread, THREAD_PRIORITY_NORMAL );
			break;
		case 1:
			SetThreadPriority( thread, THREAD_PRIORITY_ABOVE_NORMAL );
			break;
		case 2:
			SetThreadPriority( thread, THREAD_PRIORITY_HIGHEST );
			break;
		case 3:
			SetThreadPriority( thread, THREAD_PRIORITY_TIME_CRITICAL );
			break;
	}

	for (i=0;i<16;i++)
		if (!g_docPlayerList[i]) {
		  g_docPlayerList[i] = pl;
		  break;
		}


	playing = 0;

	curFname.Empty ();

	editData.trkcol = 0;
	editData.trkpos = 0;
	editData.trknum = 0;
	editData.trkposadd = 1;
	editData.patcol = 0;
	editData.patnum = 0;
	editData.patpos = 0;
	editData.patposadd = 1;
	editData.octave = 0;
	editData.copybuffer.hasdata=0;
	editData.state = GTK_EDITSTATE_DEFAULT;

	
	gtk = gtk_create ();
	return TRUE;
}



/////////////////////////////////////////////////////////////////////////////
// CTrackerDoc serialization

void CTrackerDoc::Serialize(CArchive& ar)
{
	if (ar.IsStoring())
	{
		// TODO: add storing code here
	}
	else
	{
		// TODO: add loading code here
	}
}

/////////////////////////////////////////////////////////////////////////////
// CTrackerDoc diagnostics

#ifdef _DEBUG
void CTrackerDoc::AssertValid() const
{
	CDocument::AssertValid();
}

void CTrackerDoc::Dump(CDumpContext& dc) const
{
	CDocument::Dump(dc);
}
#endif //_DEBUG

/////////////////////////////////////////////////////////////////////////////
// CTrackerDoc commands
void CTrackerDoc::ValidateEditData ()
{

}

void CTrackerDoc::OnMenuOptions() 
{
	CTrackerOptions options( (LPCTSTR) _T("Tracker Options"), 0, 0 );
	options.DoModal();
	
	/*
	// TODO: Add your command handler code here
	COptionsDlg optDlg;
	int r,g,b;

	optDlg.m_PatPosAdd = editData.patposadd;
//	optDlg.m_MainColor.Format ("%02x %02x %02x",	GetRValue (ctrl_light), GetGValue(ctrl_light), GetBValue (ctrl_light));
	optDlg.main_col_ref = ctrl_light;
    optDlg.m_Latency = pl->GetLatency();
    

	if (optDlg.DoModal ()==IDOK)
	{
		editData.patposadd = optDlg.m_PatPosAdd;

		r = GetRValue (optDlg.main_col_ref);
		g = GetGValue (optDlg.main_col_ref);
		b = GetBValue (optDlg.main_col_ref);
		ctrl_light = RGB(r,g,b);
		ctrl_bg = RGB (r*0.6,g*0.6,b*0.6);
		ctrl_dark = RGB (r*0.3,g*0.3,b*0.3);
        ctrl_latency = optDlg.m_Latency;

        pl->Stop();
        pl->SetLatency(ctrl_latency);

		UpdateAllViews (NULL);

	}
	SaveConfig ();
	*/

	editData.patposadd = g_patposadd;
	editData.trkposadd = g_chanposadd;
	UpdateAllViews (NULL);


}

void CTrackerDoc::SaveConfig()
{
	CONFIGURATION_SETDWORD( _T("Colors"), _T("basecol"), ctrl_light );
	CONFIGURATION_SETDWORD( _T("Colors"), _T("cursorcol"), ctrl_cursor );
	CONFIGURATION_SETDWORD( _T("Colors"), _T("textcol"), ctrl_text );
	CONFIGURATION_SETDWORD( _T("Colors"), _T("edtextcol"), ctrl_curtext );
	CONFIGURATION_SETDWORD( _T("Colors"), _T("marktextcol"), ctrl_marktext );
}

void CTrackerDoc::LoadConfig()
{
	ctrl_light = CONFIGURATION_GETDWORD( _T("Colors"), _T("basecol"), 0x8080C0 );	
	ctrl_cursor = CONFIGURATION_GETDWORD( _T("Colors"), _T("cursorcol"), 0xC08080 );
	ctrl_curtext = CONFIGURATION_GETDWORD( _T("Colors"), _T("edtextcol"), 0xC0ffC0  );
	ctrl_text = CONFIGURATION_GETDWORD( _T("Colors"), _T("textcol"), 0xffffff );
	ctrl_marktext = CONFIGURATION_GETDWORD( _T("Colors"), _T("marktextcol"), 0x2828ff );
}

void CTrackerDoc::OnFileSave() 
{
	// TODO: Add your command handler code here
	if (curFname.IsEmpty ()) OnFileSaveAs ();
	else gtk_save (gtk,synth,(char *)(LPCSTR)curFname);	
}

void CTrackerDoc::OnFileSaveAs() 
{
	// TODO: Add your command handler code here
	CFileDialog fd(FALSE,_T("*.gtk"),0,OFN_OVERWRITEPROMPT,_T("GTK Songs (*.gtk)|*.gtk|All files (*.*)|*.*||"),0);
	if (fd.DoModal () == IDOK)
	{
		curFname = fd.GetPathName ();
		gtk_save (gtk,synth,(char *)(LPCSTR)fd.GetPathName ());	
	}
	
}

void CTrackerDoc::OnFileOpen() 
{
	// TODO: Add your command handler code here
	CFileDialog fd(TRUE,_T("*.gtk"),0,0,_T("GTK Songs (*.gtk)|*.gtk|All files (*.*)|*.*||"),0);	
	if (fd.DoModal () == IDOK)
	{
        GTK *tmp;
	    
        pl->Stop();
        delete pl;
		
//    delete synth;
    
		curFname = fd.GetPathName ();
// STEFFO		tmp = gtk_load ((char *)(LPCSTR)fd.GetPathName ());	

        /* TEST OF MEMORY READING STUFF */
/*
        HANDLE hf = CreateFile (fd.GetPathName(),GENERIC_READ,0,NULL,OPEN_EXISTING,0,NULL);
        if (hf != INVALID_HANDLE_VALUE)
        {
            DWORD numout;
            DWORD sz;
            BYTE tmpbuf[16384];
            sz = GetFileSize(hf,NULL);
            ReadFile (hf,tmpbuf,sz,&numout,NULL);

            //tmp = gtk_load (synth, (char *)(LPCSTR)fd.GetPathName ());	
            tmp = gtk_load (synth, (char *)tmpbuf);	
            CloseHandle (hf);
            
        } else
            AfxMessageBox("ERROR while loading");

*/

        tmp = gtk_load (synth, (char *)(LPCSTR)fd.GetPathName ());	
        
/*    if(!tmp)
    {
      MessageBox (NULL,"Unabel to load file","File Error",MB_OK);
      return;
    }*/

    
    gtk_clearmod (gtk);
    gtk = tmp;
    
    
    CWnd *wnd  = AfxGetMainWnd ();
// steffo    synth = new isSynth();	
    pl = new isPlayer (wnd->m_hWnd,synth);
    playing = 0;

    CMainFrame *mf=(CMainFrame *)wnd;
    mf->m_trackerControls.m_defvelocity = 0x80;
    mf->m_trackerControls.m_bpm = gtk->def_bpm;    
    mf->m_trackerControls.m_pattick = gtk->def_pattick;    
    mf->m_trackerControls.m_seqtick = gtk->def_seqtick;    
    mf->m_trackerControls.UpdateData(FALSE);
  }
	UpdateAllViews (NULL);
}
/*
void CTrackerDoc::OnActionPlay() 
{
	// TODO: Add your command handler code here
	GetActiveView ();
	pl->Start (gtk);
	playing = 1;
}

void CTrackerDoc::OnActionStop() 
{
	// TODO: Add your command handler code here
	if (playing)
		pl->Stop ();

	playing = 0;
	
}
*/

void CTrackerDoc::OnMenuSongoptions() 
{
	// TODO: Add your command handler code here
	CSongOptDlg dlg;
    int old_len;

    old_len = gtk->channels[0].len;

	dlg.m_bpm = gtk->def_bpm;
	dlg.m_pattick = gtk->def_pattick;
	dlg.m_seqtick = gtk->internal_seqtick;
    dlg.m_seqlen = old_len;
	if (dlg.DoModal ()==IDOK)
	{
        int newlen;
		gtk->def_bpm = dlg.m_bpm;
		gtk->def_pattick = dlg.m_pattick;
		gtk->internal_seqtick = dlg.m_seqtick;
        gtk->def_seqtick = GTK_SEQ_MUL * gtk->internal_seqtick;

        newlen = dlg.m_seqlen;
        if (newlen != old_len)
        {
            int i;
            for (i=0;i<gtk->num_channels;i++)
            {
                gtk->channels[i].positions = (GTK_SEQPOS *)realloc(gtk->channels[i].positions,sizeof (GTK_SEQPOS) * newlen);
                if (newlen > old_len)
                    memset (&gtk->channels[i].positions[old_len],0,sizeof (GTK_SEQPOS) * (newlen - old_len));

                gtk->channels[i].len = newlen;
                
            }

        }
        UpdateAllViews(NULL);
	}
	
}

void CTrackerDoc::OnDeltaposSpinTcntrlPjump(NMHDR* pNMHDR, LRESULT* pResult) 
{
	NM_UPDOWN* pNMUpDown = (NM_UPDOWN*)pNMHDR;
	// TODO: Add your control notification handler code here

  editData.patposadd-=pNMUpDown->iDelta;
  
  CMainFrame *mwnd;
  mwnd = (CMainFrame *)AfxGetMainWnd();
  if (editData.patposadd<0) editData.patposadd=0;
  if (editData.patposadd>32) editData.patposadd=32;
  
  mwnd->m_trackerControls.m_pjumpEdit=editData.patposadd;
  mwnd->m_trackerControls.UpdateData(FALSE);

  
	*pResult = 0;
}

void CTrackerDoc::OnMenuSampleview() 
{

  // TODO: Add your command handler code here
  CMSDIWinApp* pApp = (CMSDIWinApp*)AfxGetApp();
#ifdef _DEBUG
//  this->pl->Stop();
#endif
  pApp->CreateOrActivateFrame(RUNTIME_CLASS(CInstrEditor), this);
  
}

void CTrackerDoc::OnMenuMixerview() 
{
	// TODO: Add your command handler code here
    CMSDIWinApp* pApp = (CMSDIWinApp*)AfxGetApp();
    pApp->CreateOrActivateFrame(RUNTIME_CLASS(CMixerView), this);
    
}

void CTrackerDoc::OnMenuSendfxeditor() 
{
	// TODO: Add your command handler code here
	// TODO: Add your command handler code here
    CMSDIWinApp* pApp = (CMSDIWinApp*)AfxGetApp();
    pApp->CreateOrActivateFrame(RUNTIME_CLASS(CSendFxView), this);
	
}

void CTrackerDoc::OnMenuSamplepool() 
{
	// TODO: Add your command handler code here
    CMSDIWinApp* pApp = (CMSDIWinApp*)AfxGetApp();
    pApp->CreateOrActivateFrame(RUNTIME_CLASS(CSamplePoolEditor), this);

	
}
