/* Copyright Stefan Hlln
 * May not be used without
 * the authors specific
 * authorization
 * el98shn@ing.umu.se       */

#ifndef __isSamplePool_h
#define __isSamplePool_h

#include "isFile.h"

const NR_OF_SAMPLES=32;

// all samples are loaded as 16bit 44k1Hz, mono, raw.

class isSamplePool
{
public:
	isSamplePool();
	~isSamplePool();

	void Load(isFile *f);
	void Save(isFile *f);
	void Import(short *buffer, unsigned int length, int toSampleNr );
	struct Sample
	{
		bool loop;
		bool pingpong;
		
		int sampleLength;
		float *buffer;
		
		int loopStart;
		int loopEnd;
		

	};

	Sample sample[NR_OF_SAMPLES];
	bool used[NR_OF_SAMPLES];
private:
};

#endif