/* Copyright Stefan Hlln
 * May not be used without
 * the authors specific
 * authorization
 * el98shn@ing.umu.se       */

#ifndef __isInstrument_h
#define __isInstrument_h

#include "isBase.h"
#include "isVoice.h"
#include "isEvent.h"
#include "isDistortion.h"
#include "isArpeggiator.h"

#define MAXVOICES		256

class isInstrument : public isBase
{
public:
	isInstrument(isSamplePool &samplePool);
	virtual ~isInstrument();
	
	void Load(isFile *f);
	void Save(isFile *f);

	void Play(float *buffer);
	bool IsActive(); // checks if the instrument needs to be played or not
	void SetBufferSize(int length);
	void Event(isEVENT event);

	
	// here goes stuff for the editor API 
	// **********************************
	isVoice *GetVoice(int index); // returns null if that voice does not exist
	int GetNrOfVoices() { return nrOfVoices;	};
	// increase/decrease the amount of voices
	void IncVoice();
	void DecVoice();

	// **********************************
	// instrument distortion settings	
	bool enableDistortion;
	isDistortion distortion;

	// instrument arpeggiator
	bool enableArpeggiator;
	isArpeggiator arpeggiator;

private:
	isSamplePool &samplePool;
	
	unsigned char nrOfVoices;
	
	isVoice *voc[MAXVOICES];

	int bufferLength;

};

#endif
