// SendFxView10.cpp : implementation file
//

#include "stdafx.h"
#include "tracker.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

#include "SendFxView10.h"
#include "isSynth.h"
#include "trackerdoc.h"
#include "DSPEffectTemplate.h"


/////////////////////////////////////////////////////////////////////////////
// CSendFxView

IMPLEMENT_DYNCREATE(CSendFxView, CFormView)

CSendFxView::CSendFxView()
	: CFormView(CSendFxView::IDD)
{
	//{{AFX_DATA_INIT(CSendFxView)
	//}}AFX_DATA_INIT
}

CSendFxView::~CSendFxView()
{
}

void CSendFxView::DoDataExchange(CDataExchange* pDX)
{
	CFormView::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CSendFxView)
	DDX_Control(pDX, IDC_COMBO1, m_chainsel);
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(CSendFxView, CFormView)
	//{{AFX_MSG_MAP(CSendFxView)
	ON_CBN_SELCHANGE(IDC_COMBO1, OnSelchangeCombo1)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CSendFxView diagnostics

#ifdef _DEBUG
void CSendFxView::AssertValid() const
{
	CFormView::AssertValid();
}

void CSendFxView::Dump(CDumpContext& dc) const
{
	CFormView::Dump(dc);
}
#endif //_DEBUG

/////////////////////////////////////////////////////////////////////////////
// CSendFxView message handlers

void CSendFxView::OnInitialUpdate() 
{
	CFormView::OnInitialUpdate();
	
	// TODO: Add your specialized code here and/or call the base class
	m_chainsel.AddString( _T("EffectChain 1") );
	m_chainsel.AddString( _T("EffectChain 2") );
	m_chainsel.AddString( _T("EffectChain 3") );
	m_chainsel.SetCurSel(0);

	m_effect_template[0] = 0;
	m_effect_template[1] = 0;
	m_effect_template[2] = 0;

	m_current_chain = 0;

	OnSelchangeCombo1();
	
	
}

void CSendFxView::OnSelchangeCombo1() 
{
	// TODO: Add your control notification handler code here

	// ta bort redan existerande
	for (int i=0;i<3;i++) {		
		if (m_effect_template[i]) {
			delete m_effect_template[i];
			m_effect_template[i] = 0;
		}
	}
	
	CTrackerDoc *doc = (CTrackerDoc*) GetDocument();	

	m_current_chain = 0;

	if (!doc) return;
	isSynth *synth = doc->synth;
	if (!synth) return;
	int sel = m_chainsel.GetCurSel();
	if (sel < 0)
		return;
	if (sel >= 3)
		return;

	// hmta effektchain
	m_current_chain = &synth->effectChain[ sel ];

	updateChain();
		
}


void CSendFxView::updateChain(void)
{
	if (!m_current_chain)
		return;

	// Position?
	POINT p;
	p.x = 10;
	p.y = 40;
	int spacing = 1;

	CTrackerDoc *doc = (CTrackerDoc *) GetDocument();

	// TODO: Add your control notification handler code here
	for (int i=0;i<3;i++) {
		WINDOWPLACEMENT pm;
		m_effect_template[i] = new CDSPEffectTemplate();
		m_effect_template[i]->setChain( m_current_chain, i );
		m_effect_template[i]->Create( IDD_SENDFX_TEMPLATE, this );	
		m_effect_template[i]->SetWindowPos( 0, p.x, p.y, 0, 0, SWP_NOSIZE | SWP_SHOWWINDOW );
		m_effect_template[i]->GetWindowPlacement( &pm );
		m_effect_template[i]->setPlayer( doc ? doc->pl : 0 );
		//p.y += tmp.bottom - tmp.left;
		p.y += pm.rcNormalPosition.bottom - pm.rcNormalPosition.top + spacing;

	}

}
