// InsertMain.cpp : implementation file
//

#include "stdafx.h"
#include "tracker.h"
#include "InsertMain.h"
#include "insertfilter.h"
#include "insertDist.h"
#include "isSynth.h"
#include "isDistortion.h"
#include "isInsert.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CInsertMain dialog
static char *modnames[]=
{
    "unused",
        "ENVELOPE",
        "LFO",
        "CONTROLLER",
        "OSCILLATOR",
        
        // inserts
        "FILTER",
        "DISTORTION",
        
        // stereo fx
        "DELAY",
        "CHORUS",        
        NULL,    
};


CInsertMain::CInsertMain(CWnd* pParent /*=NULL*/)
	: CVoiceBaseDlg(CInsertMain::IDD, pParent)
{
	//{{AFX_DATA_INIT(CInsertMain)
		// NOTE: the ClassWizard will add member initialization here
	//}}AFX_DATA_INIT
}


void CInsertMain::DoDataExchange(CDataExchange* pDX)
{
	CVoiceBaseDlg::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CInsertMain)
	DDX_Control(pDX, IDC_STATIC_INSWIN, m_inswin);
	DDX_Control(pDX, IDC_LIST_INSERTS, m_listInsert);
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(CInsertMain, CVoiceBaseDlg)
	//{{AFX_MSG_MAP(CInsertMain)
	ON_LBN_SELCHANGE(IDC_LIST_INSERTS, OnSelchangeListInserts)
	ON_BN_CLICKED(IDC_BUTTON_INSDIST, OnButtonInsdist)
	ON_BN_CLICKED(IDC_BUTTON_INSFILTER, OnButtonInsfilter)
	ON_BN_CLICKED(IDC_BUTTON_DELINSERT, OnButtonDelinsert)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CInsertMain message handlers

void CInsertMain::UpdateVoiceData()
{
    m_listInsert.ResetContent();
    isInsert *ins;
    int i;
    for (i=0;i<voice->GetNrOfInserts();i++)
    {
        ins = voice->GetInsert(i);
        m_listInsert.InsertString(i,modnames[ins->GetType()]);
        m_listInsert.SetItemData(i,ins->GetType());
        
        //m_modlist.InsertItem (0,"envelope");
    }
    int typ;
    m_listInsert.SetCurSel(curselins);
    typ = m_listInsert.GetItemData(curselins);
    switch (typ)
    {
    case is_FILTER :
        current = filed;
        break;
    case is_DISTORTION :
        current = disted;
        break;
    }
    

    CRect wrect;
    current->SetVoice (voice->GetInsert(curselins),voice,instrument,synth);
    current->UpdateInsertData(); 
    current->GetClientRect(&wrect);
    current->MoveWindow(4,20,wrect.Width(),wrect.Height());
    current->ShowWindow(SW_SHOW);

    
    
}
void CInsertMain::OnSelchangeListInserts() 
{
	// TODO: Add your control notification handler code here
    int typ;
    curselins = m_listInsert.GetCurSel();
    

    typ = m_listInsert.GetItemData(curselins);
    current->ShowWindow(SW_HIDE);

    switch (typ)
    {
        case is_FILTER :
            current = filed;
            break;
        case is_DISTORTION :
            current = disted;
            break;
    }

    CRect wrect;
    
    current->SetVoice (voice->GetInsert(curselins),voice,instrument,synth);
    current->UpdateInsertData(); 
    current->GetClientRect(&wrect);
    current->MoveWindow(4,20,wrect.Width(),wrect.Height());
    
    current->ShowWindow(SW_SHOW);
    
}

BOOL CInsertMain::OnInitDialog() 
{
	CVoiceBaseDlg::OnInitDialog();
    CRect wrect;
    
    curselins=0;
    filed= (CInsertBaseDlg *)new CInsertFilter();
    disted= (CInsertBaseDlg *)new CInsertDist();
    //lfoed = (CModulateBaseDlg *)new CModLfo();
    
    filed->Create(MAKEINTRESOURCE(IDD_DIALOG_INSERTFILTER),&m_inswin);
    disted->Create(MAKEINTRESOURCE(IDD_DIALOG_INSERTDIST),&m_inswin);
    
    
    current = filed;
    current->GetClientRect(&wrect);
    current->MoveWindow(4,20,wrect.Width(),wrect.Height());
    
    current->UpdateWindow();
    current->ShowWindow(SW_HIDE);
    curselins=0;
    // TODO: Add extra initialization here
    
	return TRUE;  // return TRUE unless you set the focus to a control
	              // EXCEPTION: OCX Property Pages should return FALSE
}

void CInsertMain::OnButtonInsdist() 
{
	// TODO: Add your control notification handler code here
    voice->AddInsert(is_DISTORTION);    
    UpdateVoiceData();
}

void CInsertMain::OnButtonInsfilter() 
{
	// TODO: Add your control notification handler code here
    voice->AddInsert(is_FILTER);
    UpdateVoiceData();    
}

void CInsertMain::OnButtonDelinsert() 
{
	// TODO: Add your control notification handler code here
    voice->DelInsert();
    UpdateVoiceData();
	
}
