unit gmtfm;
interface
procedure isfm;
procedure fmins;
implementation
uses gmtcrt3;
const rfm=$388;
      dfm=$389;
      fmmod:array[0..8] of byte=
        (0,   1,   2  , 8,    9,   10,    16,    17,    18   );

      fmfre:array[0..11] of word=
      (343,363,385,408,432,458,485,514,544,577,611,647);

{**********************************************}
procedure fmout(reg,dat,lr:byte);
var count,k:word;
begin
lr:=lr shl 1;
port[rfm+lr]:=reg;
for count:=0 to 9 do k:=port[rfm+lr];
port[dfm+lr]:=dat;
for count:=0 to 9 do k:=port[rfm+lr];
end;
{***************************************************************}
procedure initsbfm;
var count1:byte;
begin
FOR Count1 := 0 TO 255 DO FMOut(Count1, 0,0);
FOR Count1 := 0 TO 255 DO FMOut(Count1, 0,1);
fmout($05,1,1);
FMOut($01,$20,0);
fmout($bd,00,0);
end;
{**********************************************}
procedure fmnoton(co:com;c:byte);
begin
with co do
 begin
 fmout($b0+c and 7,0,c shr 3);
 fmout($a0+c and 7,lo(fmfre[note mod 12]),c shr 3);
 fmchan[c].freqpara:=hi(fmfre[note mod 12])+4*(note div 12);
 fmchan[c].use:=true;
 fmout($b0+c and 7,fmchan[c].freqpara+32,c shr 3);
 end;
end;
{**********************************************}
procedure fmcnotof(c:byte);
begin
if fmchan[c].use then fmout($b0+c and 7,fmchan[c].freqpara,c shr 3);
fmchan[c].use:=false;
end;
{**********************************************}
procedure stopfm;
var k:byte;
begin
for k:=0 to 15 do
 begin
 fmchan[k].use:=false;
 fmout($b0+k and 7,0,k shr 3);
 fmout($a0+k and 7,0,k shr 3);
 end;
end;
{**********************************************}
procedure fmnof(v:byte);
begin
with curr[v] do if afct then
 begin
 fmcnotof(curr[v].canal);
 afct:=false;
 end;
end;
{**********************************************}
procedure fmcvo(val,v:byte);
begin
with curr[v] do
 begin
 vol:=val;
 fmout($40+fmmod[canal and 7]+3,
 (cho and $c0)+ 63-(val shr 1),canal shr 3);
 end;
end;
{**********************************************}
function newcanal:byte;
var k,tmp:byte;
begin
k:=0;
tmp:=curfmchan;
repeat
 inc(curfmchan);curfmchan:=curfmchan and 15;
 inc(k);
until (not (fmchan[curfmchan].use)) or (k>15);
if fmchan[curfmchan].use then wrt(2,55,txt,bar,'fm BINS '+l2d(tim));

newcanal:=curfmchan;
end;
{*******************************************************}
procedure changefm(val,c:byte);
var fmm,cs3:byte;
begin
fmchan[c].fmintru:=val;
fmm:=fmmod[c and 7]+3;cs3:=c shr 3;
fmout($20+fmm,fmi[val][0],cs3);
fmout($40+fmm,fmi[val][1],cs3);
fmout($60+fmm,fmi[val][2],cs3);
fmout($80+fmm,fmi[val][3],cs3);
fmout($e0+fmm,fmi[val][4],cs3);
dec(fmm,3);
fmout($20+fmm,fmi[val][5],cs3);
fmout($40+fmm,fmi[val][6],cs3);
fmout($60+fmm,fmi[val][7],cs3);
fmout($80+fmm,fmi[val][8],cs3);
fmout($e0+fmm,fmi[val][9],cs3);
fmout($c0+c and 7,fmi[val][10] and $0f + not(fmi[val][10]) and 48,cs3);
end;
{**********************************************}
procedure fmco(co:com;v:byte);
begin
with curr[v] do
 begin
 if afct then fmcnotof(canal);
 canal:=newcanal;
 if fmchan[canal].fmintru<>ins then changefm(ins,canal);
 lno:=co;
 fr:=fmfre[co.note mod 12];
 fmcvo(co.vel and 127,v);
 fmnoton(co,canal);
 afct:=true;
 end;
end;
{*******************************************************}
procedure changefmi(val,v:byte);
begin
with curr[v] do
 begin
 ins:=val and $7f;
 cho :=fmi[ins][6];
 rev :=fmi[ins][0];
 filt:=fmi[ins][1];
 pan :=fmi[ins][10];
 {changefm(ins,canal);}
 end;
end;
{*******************************************************}
procedure fmpan(val,v:byte);
var k:byte;
begin
with curr[v] do
 begin
 k:=(val and $10);
 val:=val and 1;
 k:=k+val shl 5;
 pan:=pan and $f+not(k) and 48;
 fmout($c0+canal and 7,pan,canal shr 3);
 end;
end;
{*******************************************************}
procedure pmulti(val,v:byte);
begin
with curr[v] do fmout($20+fmmod[canal and 7]+3,
(rev and $f0)+val div 16,canal shr 3);
end;
{*******************************************************}
procedure fmi2tab(var fi,tab:array of byte);
var j:byte;
begin
for j:=0 to 1 do
              begin
              tab[j*12]:=(fi[j*5] and $0f);
            tab[j*12+1]:=(fi[j*5] and $10) shr 4;
            tab[j*12+2]:=(fi[j*5] and $20) shr 5;
            tab[j*12+3]:=(fi[j*5] and $40) shr 6;
            tab[j*12+4]:=(fi[j*5] and $80) shr 7;
          tab[j*12+5]:=(fi[j*5+1] and $3f);
          tab[j*12+6]:=(fi[j*5+1] and $c0) shr 6;
          tab[j*12+7]:=(fi[j*5+2] and $0f);
          tab[j*12+8]:=(fi[j*5+2] and $f0) shr 4;
          tab[j*12+9]:=(fi[j*5+3] and $0f);
         tab[j*12+10]:=(fi[j*5+3] and $f0) shr 4;
         tab[j*12+11]:= fi[j*5+4];
             end;
  tab[24]:=fi[10] and $01;
  tab[25]:=(fi[10] and $0e) shr 1;
  tab[26]:=(fi[10] and $20) shr 5;
  tab[27]:=(fi[10] and $10) shr 4;
end;
{****************************}
procedure tab2fmi(var fi,tab:array of byte);
var j:byte;
begin
for j:=0 to 1 do
               begin
               fi[j*5]:=
tab[j*12]+tab[j*12+1]*16+tab[j*12+2]*32+tab[j*12+3]*64+tab[j*12+4]*128;
               fi[j*5+1]:=
               tab[j*12+5]+tab[j*12+6]*64;
               fi[j*5+2]:=
               tab[j*12+7]+tab[j*12+8]*16;
               fi[j*5+3]:=
               tab[j*12+9]+tab[j*12+10]*16;
               fi[j*5+4]:=tab[j*12+11];
               end;

 fi[10]:= tab[24]+tab[25]*2+(tab[26]) shl 5+(tab[27]) shl 4;
end;
{****************************************************************}
procedure matte(val,v:byte);
begin
with curr[v] do fmout($40+fmmod[canal and 7],
(filt and $c0)+val div 4,canal shr 3);
end;
{***************************}
procedure effetvol(val,v:byte);
var r:byte;
begin
r:=0;
if val div 16 > 0 then r:=$80;
if val mod 16 > 0 then r:=r+$40;
fmout($bd,r,curr[v].canal shr 3);
end;
{***************************}
procedure savefmi;
var fmf:file;
begin
chd(fmdir);
if cre(fmin[cfmi]+'.fmi',fmf,1) then
         begin
           blockwrite(fmf,fmi[cfmi],11);
          close(fmf);
          {$I+}
         end;
end;
{***************************}
procedure loadfmi;
var fmf:file;
    fn:string[12];
begin
chd(fmdir);
if getfic('*.fmi       ',fn,' Select an FM instrument ',cfmdir,testrien)
 then
if ouvre(fn,fmf,1) then
   begin
   blockread(fmf,fmi[cfmi],11);
   fmin[cfmi]:='        ';
   move(fn[1],fmin[cfmi][1],length(fn)-4);
   close(fmf);
   {$I+}
   end;
end;

procedure loadsgi;
var fmf:file of byte;
    fn:string[12];
    tb:array[0..27] of byte;
begin
chd(fmdir);
if getfic('*.sgi       ',fn,' Select an FM instrument ',cfmdir,testrien)
 then begin
 assign(fmf,fn);
 {$I-}
 reset(fmf);
 {$I+}
 if ioresult=0 then begin
   {0 Attack m}  read(fmf,tb[8]);
   {1 Decay m}   read(fmf,tb[7]);
   {2 Sustain m} read(fmf,tb[9]);
   {3 release m} read(fmf,tb[10]);
   {4 Welle m}   read(fmf,tb[11]);
   {5 Multi m}   read(fmf,tb[0]);
   {6 Adaempf m} read(fmf,tb[6]);
   {7 Volume m}  read(fmf,tb[5]);
   {8 HKdaempf m}read(fmf,tb[1]);
   {9 Tremolo m} read(fmf,tb[4]);
   {10Vibrato m} read(fmf,tb[3]);
   {11Tonart m}  read(fmf,tb[2]);
   {12Attack t}  read(fmf,tb[8+12]);
   {13Decay t}   read(fmf,tb[7+12]);
   {14Sustain t} read(fmf,tb[9+12]);
   {15release t} read(fmf,tb[10+12]);
   {16Welle t}   read(fmf,tb[11+12]);
   {17Multi t}   read(fmf,tb[0+12]);
   {18Adaempf t} read(fmf,tb[6+12]);
   {19Volume t}  read(fmf,tb[5+12]);
   {20HKdaempf t}read(fmf,tb[1+12]);
   {21Tremolo t} read(fmf,tb[4+12]);
   {22Vibrato t} read(fmf,tb[3+12]);
   {23Tonart t}  read(fmf,tb[2+12]);
   {24Feedback}  read(fmf,tb[25]);
   {25Verbindung}read(fmf,tb[24]);
   tb[26]:=0;
   tb[27]:=0;

   fmin[cfmi]:='        ';
   move(fn[1],fmin[cfmi][1],length(fn)-4);
   close(fmf);
   tab2fmi(fmi[cfmi],tb);
   end;
   end;
end;

procedure loadsbi;
var fmf:file of byte;
    fn:string[12];
    kk,kkk:byte;
    tb:array[0..$2e] of byte;
begin
chd(fmdir);
if getfic('*.sbi       ',fn,' Select an FM instrument ',cfmdir,testrien)
 then begin
 assign(fmf,fn);
 {$I-}
 reset(fmf);
 {$I+}
 if ioresult=0 then begin
   {File ID, Name}
   for kk:=0 to $23 do read(fmf,kkk);
   {Modlulator char}
   read(fmf,kkk);
   tb[12]:=kkk and $f;
   tb[13]:=kkk and $1f shr 4;
   tb[14]:=kkk and $3f shr 5;
   tb[15]:=kkk and $7f shr 6;
   tb[16]:=kkk and $ff shr 7;
   {Carrier char}
   read(fmf,kkk);
   tb[0]:=kkk and $f;
   tb[1]:=kkk and $1f shr 4;
   tb[2]:=kkk and $3f shr 5;
   tb[3]:=kkk and $7f shr 6;
   tb[4]:=kkk and $ff shr 7;
   {Modulator Amp}
   read(fmf,kkk);
   tb[17]:=kkk and $3f;
   tb[18]:=kkk shr 6;
   {Carrier Amp}
   read(fmf,kkk);
   tb[5]:=kkk and $3f;
   tb[6]:=kkk shr 6;
   {Modulator Dec, att}
   read(fmf,kkk);
   tb[19]:=kkk and $f;
   tb[20]:=kkk shr 4;
   {Carrier Dec, att}
   read(fmf,kkk);
   tb[7]:=kkk and $f;
   tb[8]:=kkk shr 4;
   {Modulator Rel, sus}
   read(fmf,kkk);
   tb[22]:=kkk and $f;
   tb[21]:=kkk shr 4;
   {Carrier rel, sus}
   read(fmf,kkk);
   tb[10]:=kkk and $f;
   tb[9]:=kkk shr 4;
   {modulator Wave}
   read(fmf,tb[23]);
   {carrier Wave}
   read(fmf,tb[11]);
   {rest}
   read(fmf,kkk);
   tb[24]:=kkk and 1;
   tb[25]:=kkk and $f shr 1;
   tb[26]:=0;
   tb[27]:=0;

   fmin[cfmi]:='        ';
   move(fn[1],fmin[cfmi][1],length(fn)-4);
   close(fmf);
   tab2fmi(fmi[cfmi],tb);
   end;
   end;
end;




{***************************}
procedure fmafnom;
var kf:byte;
begin
for kf:= 2 to 43 do wrtw(48,kf,fonpat,cdef,'           ');
for kf:= max(cfmi-21,0) to min(cfmi+20,maxfmi) do
  wrtw(48,23+kf-cfmi,fonpat,cdef,b2h(kf)+' '+fmin[kf]);
wrtw(48,23,bar,txt,b2h(cfmi)+' '+fmin[cfmi]);
linev(61,5,35,cdef,cdef,'');
wrtw(61,5+(cfmi*34) div maxfmi,cdef,fonpat,'');
end;
{***************************}
procedure fmins;
const
maxpara:array[0..27] of byte=
(16,2,2,2,2,64,4,16,16,16,16,8,16,2,2,2,2,64,4,16,16,16,16,8,2,8,2,2);
var tb:array[0..27] of byte;
    kf,pf,i:byte;
    fmst:array[0..15] of byte;
    nt:byte;
begin
menuclosed:=false;
for i:=0 to 10 do fmst[i]:=0;
win(9,2,72,47,' FM Instrument editor ');
cadr(60,4,62,40,cdef,c4def);
wrtmb(61,2,cdef,'');
wrtmb(61,42,cdef,'');
wrtw(19,03,cdef,fonpat,'Ŀ');
wrtw(19,04,cdef,fonpat,'C         Chorase        ');
wrtw(19,05,cdef,fonpat,'A        Env.damp        ');
wrtw(19,06,cdef,fonpat,'R        Env.type        ');
wrtw(19,07,cdef,fonpat,'R         Vibrato        ');
wrtw(19,08,cdef,fonpat,'I         Tremolo        ');
wrtw(19,09,cdef,fonpat,'E        Velocity        ');
wrtw(19,10,cdef,fonpat,'R            damp        ');
wrtw(19,11,cdef,fonpat,'      Decay  rate        ');
wrtw(19,12,cdef,fonpat,'      Attack rate        ');
wrtw(19,13,cdef,fonpat,'          Release        ');
wrtw(19,14,cdef,fonpat,'    Sustain Level        ');
wrtw(19,15,cdef,fonpat,'Waveform    Ĵ');
wrtw(19,16,cdef,fonpat,'M         Chorase        ');
wrtw(19,17,cdef,fonpat,'O        Env.damp        ');
wrtw(19,18,cdef,fonpat,'D        Env.type        ');
wrtw(19,19,cdef,fonpat,'U         Vibrato        ');
wrtw(19,20,cdef,fonpat,'L         Tremolo        ');
wrtw(19,21,cdef,fonpat,'A        Velocity        ');
wrtw(19,22,cdef,fonpat,'T            damp        ');
wrtw(19,23,cdef,fonpat,'O     Decay  rate        ');
wrtw(19,24,cdef,fonpat,'R     Attack rate        ');
wrtw(19,25,cdef,fonpat,'          Release        ');
wrtw(19,26,cdef,fonpat,'    Sustain level        ');
wrtw(19,27,cdef,fonpat,'Waveform    Ĵ');
wrtw(19,28,cdef,fonpat,'  Serial/Parallel        ');
wrtw(19,29,cdef,fonpat,'         Feedback        ');
wrtw(19,30,cdef,fonpat,'    Disable right        ');
wrtw(19,31,cdef,fonpat,'    Disable  left        ');
wrtw(19,32,cdef,fonpat,'');

wrtw(48,1,cdef,fonpat,'N Name');

wrtmb(2,2,cdef,'   Open  FMI   ');
wrtmb(2,5,cdef,'   Save  FMI   ');
wrtmb(2,8,cdef,'   Open  SGI   ');
wrtmb(2,11,cdef,'   Open  SBI   ');
wrtmb(2,14,cdef,'    Delete     ');
wrtmb(2,29,cdef,'      Help     ');
wrtmb(2,32,cdef,'      Exit     ');
fmi2tab(fmi[cfmi],tb);
pf:=0;
linev(47,1,44,cdef,bar,'');
waitrel;
fmafnom;
repeat
for kf:= 0 to 27 do wrtw(39,4+kf,fonpat,txt,b2d2(tb[kf]));
tb[pf]:=getnum(39,4+pf,2,maxpara[pf]-1,0,tb[pf],0,true);

if lb then
  begin
if mouin(1,31,17,33) then wkey:=1 else
if mouin(1,28,17,30) then wkey:=kf1 else
if mouin(60,1,62,3) then wkey:=pgup  else
if mouin(60,41,62,43) then wkey:=pgdn else
if mouin(36,4,44,31) then pf:=my-4 else
if mouin(48,2,50,43) then begin
                          if (my-23+cfmi>=0) and(my-23+cfmi<=maxfmi)
                          then cfmi:=my-23+cfmi;
                          fmi2tab(fmi[cfmi],tb);
                          fmafnom;
                          waitrel;
                          end else
if mouin(51,2,60,43) then begin
                          if (my-23+cfmi>=0) and(my-23+cfmi<=maxfmi)
                          then cfmi:=my-23+cfmi;
                          fmi2tab(fmi[cfmi],tb);
                          fmafnom;
                          fmin[cfmi]:=getchai(52,23,8,fmin[cfmi]);
                          end else

if mouin(1,4,17,6) then begin
                tab2fmi(fmi[cfmi],tb);
                savefmi;
                end else
if mouin(1,1,17,3) then begin loadfmi;fmi2tab(fmi[cfmi],tb);fmafnom;end;
if mouin(1,7,17,9) then begin loadsgi;fmi2tab(fmi[cfmi],tb);fmafnom;end;
if mouin(1,10,17,12) then wkey:=28;
if mouin(1,13,17,15) then wkey:=Ksup;
end;

case wkey of
28:begin
     loadsbi;
     fmi2tab(fmi[cfmi],tb);
     fmafnom;
    end;
KSup:begin
   for kf:=0 to 27 do tb[kf]:=0;
   fmin[cfmi]:='        ';
   tab2fmi(fmi[cfmi],tb);
   fmafnom;
   end;
pgup:begin
        if cfmi>0 then dec(cfmi);
        fmi2tab(fmi[cfmi],tb);
       fmafnom;
       end;
pgdn:begin
        if cfmi<maxfmi then inc(cfmi);
        fmi2tab(fmi[cfmi],tb);
       fmafnom;
       end;
kfb:if pf<27 then inc(pf);
kfH:if pf>0 then dec(pf);
kf1:help(0,'l');

3..53: if clv[wkey]<maxnote then
       begin
       midbr[0]:=$90;
       midbr[1]:=min(oct*12+clv[wkey],127);
       midbr[2]:=$7f;
       end;
131..181:if clv[wkey and $7f]<maxnote then
         begin
          midbr[0]:=$90;
          midbr[1]:=min(oct*12+clv[wkey and $7f],127);
          midbr[2]:=0;
         end;
end;

case midbr[0] and $f0 of
$90: if midbr[2]>0 then
     begin
      i:=0;
      nt:=midbr[1];
      while (fmst[i]<> nt) and (i<15) do inc(i);
      if (fmst[i]<> nt) then
        begin
         tab2fmi(fmi[cfmi],tb);
         fmcam.note:=nt;
         fmcam.vel:=midbr[2];
         fmcam.eff:=46;
         asm cli end;
         can:=newcanal;
         fmst[can]:=nt;
         changefm(cfmi,can);
         fmnoton(fmcam,can);
         asm sti end;
        end;
      end else
        begin
         i:=0;
         nt:=midbr[1];
         while (fmst[i]<> nt) and (i<15) do inc(i);
         if (fmst[i]= nt) then
           begin
           fmst[i]:=0;
           fmcnotof(i);
           end;
         end;


end;
tab2fmi(fmi[cfmi],tb);
for i:=0 to 15 do if fmchan[i].fmintru=cfmi then changefm(cfmi,i);
until wkey=1;
restwin;
end;

{****************************************************************}
FUNCTION FMAvailable : Boolean;

VAR
  Status1, Status2 : Byte;                                { Variables d'tat }
  Count            : Word;                                     { Compteur }

BEGIN
  FMOut($01,$00,0);                           { Efface le registre de test }
  FMOut($04,$60,0);    { Interdit l'apparition du dbordement compteur dans le registre d'tat }
  fMOut($04,$80,0);              { Efface les drapeaux du registre d'tat }
  Status1 := Port[rfm];                          { Lit le registre d'tat }
  FMout($02,$FF,0);     { Cale le compteur rapide sur 255 }
  FMOut($04,$21,0);          { Transmet les donnes et lance le compteur }
  FOR Count := 1 TO 200 DO                  { Attend env. 200 microsecondes }
    Status2 := Port[rFM];     { Lit le contenu du registre d'tat  chaque passage }
  Status2 := Port[rFM];                   { Lit  nouveau le registre d'tat }
  FMOut($04,$60,0);    { Ne transmet rien, bloque apparition du dbordement }
  FMOut($04,$80,0);              { Efface le registre d'tat pour finir }
  FMAvailable := ((Status1 AND $E0) = $00) AND ((Status2 AND $E0) = $C0);
END;
{*************************************************************}
procedure isfm;
var k:byte;
begin
fmdt:=false;
if fmavailable then
  begin
   fmdt:=true;
   initsbfm;
   sco[2]:=fmco;  noof[2]:=fmnof;stoppe[2]:=stopfm;
   trtv[2]:=nihil;
   gltrtv[2]:=rien;
   reglevo[2]:=fmcvo;
   ef[2][105]:=changefmi;  {i}
   ef[2][ord('e')]:=pmulti;  {e}
   ef[2][ord('f')]:=matte;   {f}
   ef[2][118]:=effetvol;   {v}
   ef[2][ord('s')]:=fmpan;
  end
  else
   begin
 {  wrt(71,55,bar,cdef,'No   ');}
    sco[2]:=rc;trtv[2]:=nihil;noof[2]:=nihil;stoppe[2]:=rien;
    gltrtv[2]:=rien;
    reglevo[2]:=rrr;
    for k:=46 to 122 do ef[2][k]:=rrr;
   end;

end;
{*************************************************}
begin
end.