unit gmtbeep;
interface
const
  beepfreq : Array[0..144] Of Word =
  { C    C#,D-  D    D#,E-  E     F    F#,G-  G    G#,A-  A    A#,B-  B  }
  (0033, 0035, 0037, 0039, 0041, 0044, 0046, 0049, 0052, 0055, 0058, 0062,
   0065, 0069, 0073, 0078, 0082, 0087, 0093, 0098, 0104, 0110, 0117, 0123,
   0131, 0139, 0147, 0156, 0165, 0175, 0185, 0196, 0208, 0220, 0233, 0247,
   0262, 0277, 0294, 0311, 0330, 0349, 0370, 0392, 0415, 0440, 0466, 0494,
   0523, 0554, 0587, 0622, 0659, 0698, 0740, 0784, 0831, 0880, 0932, 0987,
   1047, 1109, 1175, 1245, 1329, 1397, 1480, 1568, 1661, 1760, 1865, 1976,
   2093, 2217, 2349, 2489, 2637, 2794, 2960, 3136, 3322, 3520, 3729, 3951,
   4186, 4435, 4699, 4978, 5274, 5588, 5920, 6272, 6645, 7040, 7459, 7902,
   8372, 8870, 9398, 9956,10548,11176, 11840,12544,13290,14080,14918,15804,
   16744,17740,18796,19912,21096,22352,23680,25088,26580,28160,29836,31608,
   33488,35480,37592,39824,42192,44704,47360,50176,53160,56320,59672,63216
   ,47360,47360,47360,47360,47360,47360,47360,47360,47360,47360,47360,47360,43371);

implementation
uses {crt,}gmtcrt3;
procedure sound( hertz : word); Assembler;
{hertz is the sound frequency to send to the speaker port}

asm
  MOV    BX,SP
  MOV    BX,&hertz
  MOV    AX,34DDh
  MOV    DX,0012h
  CMP    DX,BX
  JNB    @J1
  DIV    BX
  MOV    BX,AX
  IN     AL,61h
  TEST   AL,03h
  JNZ    @J2
  OR     AL,03h
  OUT    61h,AL
  MOV    AL,-4Ah
  OUT    43h,AL
@J2:
  MOV    AL,BL
  OUT    42h,AL
  MOV    AL,BH
  OUT    42h,AL
@J1:
end;

procedure nosound; Assembler;
{turns the speaker off}
asm
  IN     AL,61h
  AND    AL,0FCh
  OUT    61h,AL
end;

{*********************************************************}
procedure beepnof(v:byte);
begin
nosound;
end;
{*********************************************************}
procedure stopbeep;
begin
nosound;
end;
{*********************************************************}
procedure setpmtb(val,v:byte);
begin
if val >2 then curr[v].pmt:=val;
end;
{*********************************************************}
procedure pmt2n(val,v:byte);
begin
with curr[v] do if val<144 then
 begin
 adp:= integer(beepfreq[12*((val and $f0) shr 4)+(val and $0f)]-fr) div pmt;
 pmtp:=pmt;
 end;
end;
{*********************************************************}
procedure setf(val,v:byte);
begin
with curr[v] do
 begin
 fr:=beepfreq[12*((val and $f0) shr 4)+(val and $0f)];
 sound(fr);
 pmtp:=0;
 end;
end;
{*********************************************************}
procedure beepco(co:com;v:byte);
begin
with curr[v] do
 begin
 lno:=co;
 fr:=beepfreq[co.note];
 sound(fr);
 pmtp:=0;
 end;
end;
{***************************************************}
procedure beeptrtv(v:byte);
begin
if curr[v].pmtp>0 then
 begin
 curr[v].fr:=curr[v].fr+curr[v].adp;
 sound(curr[v].fr);
 dec(curr[v].pmtp);
 end;
end;
{*********************************************************}
begin
reglevo[1]:=rrr;
sco[1]:=beepco;noof[1]:=beepnof;stoppe[1]:=stopbeep;trtv[1]:=beeptrtv;
gltrtv[1]:=rien;
ef[1][ord('p')]:=setf;
ef[1][ord('e')]:=pmt2n;
ef[1][ord('q')]:=setpmtb;
end.