unit astDMA;
interface
uses gmtcrt3;
type intpro=procedure;

     XMS_Copyblock = Record
       Size     : longint;
       Q_Handle : Word;
       Q_Offset : longint;
       Z_Handle : Word;
       Z_Offset : longint;
     end;

var lsbuff:word;
    sbuffpt:patr;
    sbirq:byte;
    sbdma16:byte;
    irqvector:byte;
    picmask:word;

    middle:boolean;
    recordavail:byte;
    recste:boolean;
    recpitch,playpitch:word;

    XMSDriver: pointer;
    xms_size:longint;
    mh:word;
    xc: XMS_Copyblock;
    xmsdt:byte;

    dtdavail:longint;
    dtdpos:longint;
    dtdrep:longint;
    dtdste:boolean;
    dtdwav:file;
    dtdhead:wavheader;
    dtdname:string[8];
    dtdplay:word;
    dtdrec:word;

    xms_pos:longint;
    reppos:longint;

    oscwav:wavheader;
    oscwavname:string[8];
procedure SBstart(out,stereo:boolean;fre:word;pro:intpro);
procedure SBstop;
function checSB(lb:word):byte;
function resetSB:boolean;
procedure wrdsp(v:byte);

function setupmem:byte;
procedure exit_xms;
procedure RAM_2_XMS(q:longint;ofset:longint;Size:Word);
procedure XMS_2_Ram(d:longint;ofset:longint;Size:Word);

{*****************************************}
implementation
uses dos;
const dmap:array[5..7] of byte=($8b,$89,$8a);
var dmah,dmal:word;
    oldsbirq:pointer;
    intsb:procedure;
    irqok:boolean;
{*******************************************}
function resetSB:boolean;
const ready =$aa;
var ct,stat:byte;
begin
 port[sbp+$6 ]:=1;
 for ct:=1 to 100 do;
 port[sbp+$6]:=0;
 stat:=0;
 ct:=0;
 while (stat<>ready) and (ct<100) do
  begin
  stat:=port[sbp+$e];
  stat:=port[sbp+$a];
  inc(ct);
  end;
resetSB:=(stat=ready);
end;
{**********************************************}
procedure wrdsp(v:byte);
begin
 while port[sbp+$c]>=128 do ;
 port[sbp+$c]:=v;
end;
{*****************************************}
procedure allocsbuff;
var la:longint;
begin
sbuffpt:=b;
asm
 db 66h;xor ax,ax
 db 66h;xor bx,bx
 mov ax,word ptr sbuffpt
 mov bx,word ptr sbuffpt[2]
 db 66h;shl bx,4
 db 66h;add ax,bx
 db 66h;mov word ptr la,ax
end;
if (la and $ffff + lsbuff*4 >$ffff) then
  begin
  inc( longint(sbuffpt),lsbuff*4);
  inc(la,lsbuff*4);
  end;
dmah:=la shr 16;
dmal:=(la div 2) and $ffff;
fillchar(b^,34000,0);
end;
{*****************************************}
procedure sb_handler;interrupt;
var temp:byte;
begin
asm
db 66h;push bp;
db 66h;push ax;
db 66h;push bx;
db 66h;push cx;
db 66h;push dx;
db 66h;push si;
db 66h;push di;
end;
Temp := Port[sbp+$0f];
intsb;
middle:=not middle;
asm
db 66h;pop di;
db 66h;pop si;
db 66h;pop dx;
db 66h;pop cx;
db 66h;pop bx;
db 66h;pop ax;
db 66h;pop bp;
end;
port[$a0]:=$20;
port[$20]:=$20;
end;
{*****************************************}
procedure SBstart(out,stereo:boolean;fre:word;pro:intpro);
var d6,fw,sw:byte;
begin
if out then
 begin
 wrdsp($42);wrdsp(hi(fre));wrdsp(lo(fre));
 d6:=sbDMA16-4+$58;
 fw:=$b6;
 end else
 begin
 wrdsp($41);wrdsp(hi(fre));wrdsp(lo(fre));
 d6:=sbDMA16-4+$54;
 fw:=$be;
 end;
if stereo then sw:=$30 else sw:=$10;
intsb:=pro;
asm cli end;
Port[picmask] := Port[picmask] or (1 shl (sbirq and 7) );

SetIntVec(irqvector,@sb_Handler);
Port[picmask] := Port[picmask] and not(1 shl (sbirq and 7) );
asm sti end;

Port[$d4]   := sbDMA16-4+$04;
Port[$d8]   := $00;
Port[$d6]   := d6;
Port[$C0 + 4*(sbDMA16-4)] := lo(dmal);
Port[$C0 + 4*(sbDMA16-4)]:= Hi(dmal);
Port[$C2 + 4*(sbDMA16-4)]    := lo((lsBuff*2)- 1);
Port[$C2 + 4*(sbDMA16-4)]    := hi((lsBuff*2)- 1);
Port[dmap[sbdma16]] := dmah;
Port[$d4]     := sbDMA16-4;
WrDSP(fw);
WrDSP(sw);
WrDSP(lo(lsbuff-1));
WrDSP(hi(lsbuff-1));
middle:=true;
end;
{*****************************************************}
procedure SBstop;
begin
asm cli end;
Port[picmask] := Port[picmask] or (1 shl (sbirq and 7) );
setintvec(irqvector,oldsbirq);
wrdsp($d5);
asm sti end;
end;
{*****************************************}
function readdsp:byte;
begin
while  port[sbp+$e]<$80 do ;
readdsp:= port[sbp+$a];
end;
{*****************************************************}
procedure detectIRQ;
begin
irqok:=true;
end;
{*****************************************}
function checSB(lb:word):byte;
var s,tmps:string;
    ps:byte;
    code:integer;
begin

s:=getenv('BLASTER');
if s='' then
 begin
 checsb:=1;
 exit;
 end;

ps:=pos('I',s);
if ps=0 then
 begin
 checsb:=2;
 exit;
 end;
tmps:=copy(s,ps+1,2);
if (tmps[2]>'9') or (tmps[2]<'0') then tmps[0]:=#1;
val(tmps,sbirq,code);

if sbirq<=7 then
 begin
 irqvector:=$08+sbirq;
 picmask:=$21;
 end else
 begin
 irqvector:=$70+sbirq-8;
 picmask:=$a1;
 end;

ps:=pos('A',s);
if ps=0 then
 begin
 checsb:=3;
 exit;
 end;
tmps:=copy(s,ps+1,3);
val('$'+tmps,sbp,code);

ps:=pos('H',s);
if ps=0 then
 begin
 checsb:=4;
 exit;
 end;
tmps:=copy(s,ps+1,1);
val(tmps,sbdma16,code);

if not resetsb then
  begin
  checsb:=5;
  exit
  end;
port[sbp+4]:=$83;
port[sbp+5]:=$fb;

wrdsp($E1);
code:=readdsp;
code:=code*100+readdsp;
if code<400 then
 begin
 checsb:=6;
 exit;
 end;

lsbuff:=lb;
allocsbuff;
checsb:=0;

getintvec(irqvector,oldsbirq);
irqok:=false;
sbstart(true,true,45000,detectirq );
tim:=0;
repeat  until irqok  or (tim>2);
sbstop;
if irqok then checsb:=0 else checsb:=7;
setintvec(irqvector,oldsbirq);
end;
{}
function XMSInstalled: boolean; assembler;
      asm
        mov    ax, 4300h
        int    2Fh
        cmp    al, 80h
        jne    @NoXMSDriver
        mov    al, TRUE
        jmp    @Done
       @NoXMSDriver:
        mov    al, FALSE
       @Done:
      end;

{}

    procedure XMSInit; assembler;
      asm
        mov    ax, 4310h
        int    2Fh
        mov    word ptr [XMSDriver], bx
        mov    word ptr [XMSDriver+2], es
      end;

{}

    function XMSGetVersion: word; assembler;
      asm
        mov    ah, 00h
        call   XMSDriver
      end;

{}

    function XMSGetFreeMem: word; assembler;
      asm
        mov    ah, 08h
        call   XMSDriver
        mov    ax, dx
      end;

{}

    function XMSAllocate(var Handle: word; Size: word): boolean; assembler;
      asm
        mov    ah, 09h
        mov    dx, Size
        call   XMSDriver
        les    di, Handle
        mov    es:[di], dx
      end;

{}

    function XMSFree(Handle: word): boolean; assembler;
      asm
        mov    ah, 0Ah
        mov    dx, Handle
        call   XMSDriver
      end;
{}
{************************************************}
function XMS_lock(H : word) : longint; assembler;
asm;
  mov ax,0c00h
  mov dx,h
  call dword ptr [XMSdriver]
  mov ax,bx
end;
{************************************************}
procedure XMS_unlock(H : word); assembler;
asm;
  mov ax,0d00h
  mov dx,h
  call dword ptr [XMSdriver]
end;
{************************************************}
procedure RAM_2_XMS(q:longint;ofset:longint; Size : Word);
begin;
  XC.Size     := Size;
  XC.Q_Handle := 0;
  XC.Q_Offset := q;
  XC.Z_Handle := mh;
  XC.Z_Offset := ofset;
  asm
    mov si,offset XC
    mov ax,0B00h
    call dword ptr [XMSdriver]
  end;
end;
{************************************************}
procedure XMS_2_Ram(d : longint;ofset:longint; Size : Word);
begin;
  XC.Size     := Size;
  XC.Q_Handle := mh;
  XC.Q_Offset := ofset;
  XC.Z_Handle := 0;              { 0 = RAM }
  XC.Z_Offset := longint(d);
  asm
    mov si,offset XC
    mov ax,0B00h
    call dword ptr [XMSdriver]
  end;
end;
{************************************************}
function setupmem:byte;
begin
if not xmsinstalled then begin setupmem:=1;exit;end;
xmsinit;
if xmsgetversion<3 then begin setupmem:=2;exit;end;

xms_size:=xmsgetfreemem;
dec(xms_size);
if xms_size<0 then begin setupmem:=3;exit;end;

if not xmsallocate(mh,xms_size) then begin setupmem:=4;exit;end;
xms_size:=longint(xms_size)*1024;
xms_lock(mh);
setupmem:=0;
end;
{}
procedure exit_xms;
begin
xms_unlock(mh);
xmsfree(mh);
end;
{*****************************************}
begin

dtdpos:=0;
dtdrep:=0;
dtdste:=true;
dtdname:='No_NAME ';
dtdplay:=44100;
dtdrec:=44100;

xms_pos:=0;
reppos:=0;
recste:=true;
recpitch:=44100;
playpitch:=44100;
oscwavname:='NO_NAME ';
end.